<?php
ob_start();

$module = $module ?? [];
$routeBase = $module['routeBase'] ?? '/vendas';
$slug = $module['slug'] ?? 'vendas';
$plural = $module['plural'] ?? 'Vendas';
$singular = $module['singular'] ?? 'Venda';
$icon = $module['icon'] ?? 'bi bi-cart-check';
$newIcon = $module['createIcon'] ?? 'bi bi-cart-plus';
$subtitle = $module['subtitle'] ?? 'Gerencie suas vendas e pedidos';
$newButtonLabel = $module['newButtonLabel'] ?? ('Nova ' . $singular);
$conversionEnabled = $module['conversionEnabled'] ?? false;
$moduleOrigin = $module['origin'] ?? 'venda';
?>

<style>
    .badge.bg-purple {
        background-color: #6f42c1 !important;
    }

    .badge.bg-cyan {
        background-color: #0dcaf0 !important;
        color: #000 !important;
    }

    /* Card discreto para informações do cliente */
    .cliente-card {
        background-color: #f8f9fa;
        border: 1px solid #e9ecef;
        border-radius: 4px;
        padding: 4px 6px;
        font-size: 0.8125rem;
        line-height: 1.3;
        display: inline-block;
        vertical-align: middle;
    }

    .cliente-card-item {
        margin-bottom: 2px;
    }

    .cliente-card-item-inline {
        white-space: nowrap;
    }

    .cliente-card-item:last-child {
        margin-bottom: 0;
    }

    .cliente-card-item small {
        font-size: 0.7rem;
        font-weight: 600;
        color: #6c757d;
        margin-right: 4px;
        display: inline;
    }

    .cliente-card-item strong,
    .cliente-card-item span {
        color: #212529;
        font-size: 0.8125rem;
        font-weight: 500;
        display: inline;
    }

    /* Switches modernos para modal NFe */
    .swal2-container .form-switch .form-check-input {
        width: 2.5em;
        height: 1.25em;
        cursor: pointer;
        background-color: #e9ecef;
        border: none;
    }

    .swal2-container .form-switch .form-check-input:checked {
        background-color: #198754;
    }

    .swal2-container .form-switch .form-check-input:focus {
        box-shadow: 0 0 0 0.25rem rgba(25, 135, 84, 0.25);
    }

    .swal2-container .form-check-label {
        font-size: 0.9rem;
        color: #495057;
        cursor: pointer;
    }

    /* Cards de opções (padrão semelhante ao módulo Pessoas) */
    .opcoes-grupo {
        margin-bottom: 1.5rem;
        padding: 0 0.5rem;
    }

    .opcoes-grupo:last-child {
        margin-bottom: 0.5rem;
    }

    .opcoes-titulo {
        font-size: 0.85rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.08em;
        color: #64748b;
        margin-bottom: 0.6rem;
        display: flex;
        align-items: center;
        gap: 0.35rem;
    }

    .opcoes-titulo::before {
        content: '';
        width: 6px;
        height: 6px;
        border-radius: 50%;
        background: #cbd5f5;
    }

    .opcoes-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
        gap: 0.75rem;
    }

    .opcao-card {
        width: 130px;
        height: 130px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        gap: 0.75rem;
        border: 2px solid #e0e0e0;
        border-radius: 12px;
        background: white;
        cursor: pointer;
        transition: all 0.2s ease-in-out;
        padding: 1rem;
    }

    .opcao-card i {
        font-size: 2rem;
    }

    .opcao-card span {
        font-size: 0.9rem;
        font-weight: 600;
        text-align: center;
    }

    .opcao-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 18px rgba(0, 0, 0, 0.12);
    }

    .opcao-card-primary {
        border-color: #0d6efd;
        color: #0d6efd;
    }

    .opcao-card-primary:hover {
        background: #0d6efd;
        color: #fff;
    }

    .opcao-card-success {
        border-color: #198754;
        color: #198754;
    }

    .opcao-card-success:hover {
        background: #198754;
        color: #fff;
    }

    .opcao-card-warning {
        border-color: #ffc107;
        color: #ffc107;
    }

    .opcao-card-warning:hover {
        background: #ffc107;
        color: #fff;
    }

    .opcao-card-danger {
        border-color: #dc3545;
        color: #dc3545;
    }

    .opcao-card-danger:hover {
        background: #dc3545;
        color: #fff;
    }

    .opcao-card-secondary {
        border-color: #6c757d;
        color: #6c757d;
    }

    .opcao-card-secondary:hover {
        background: #6c757d;
        color: #fff;
    }

    .opcao-card-info {
        border-color: #0dcaf0;
        color: #0dcaf0;
    }

    .opcao-card-info:hover {
        background: #0dcaf0;
        color: #fff;
    }
</style>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="<?= htmlspecialchars($icon) ?> me-2"></i> <?= htmlspecialchars($plural) ?></h2>
        <p class="text-muted"><?= htmlspecialchars($subtitle) ?></p>
    </div>
    <div class="col-md-6 text-end">
        <button type="button" class="btn btn-info me-2" onclick="abrirModalConferencia()">
            <i class="bi bi-clipboard-check me-2"></i> Conferência
        </button>
        <a href="<?= url($routeBase . '/criar') ?>" class="btn btn-primary">
            <i class="<?= htmlspecialchars($newIcon) ?> me-2"></i> <?= htmlspecialchars($newButtonLabel) ?>
        </a>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-6">
                <input type="text" class="form-control" name="search" placeholder="Buscar por número, cliente..."
                    value="<?= htmlspecialchars($search ?? '') ?>">
            </div>
            <div class="col-md-3">
                <select class="form-select" name="status">
                    <option value="">Todos os Status</option>
                    <?php
                    $statusVendas = $statusVendas ?? [];
                    if (empty($statusVendas)) {
                        // Fallback: se não houver status cadastrados
                        $statusVendas = [
                            ['codigo' => 'orcamento', 'nome' => 'Orçamento'],
                            ['codigo' => 'pendente', 'nome' => 'Pendente'],
                            ['codigo' => 'realizado', 'nome' => 'Realizado'],
                            ['codigo' => 'faturamento', 'nome' => 'Faturamento'],
                            ['codigo' => 'expedicao', 'nome' => 'Expedição'],
                            ['codigo' => 'em_entrega', 'nome' => 'Em Entrega'],
                            ['codigo' => 'finalizado', 'nome' => 'Finalizado'],
                        ];
                    }
                    foreach ($statusVendas as $s) {
                        $selected = (!empty($status) && $status === $s['codigo']) ? 'selected' : '';
                        echo "<option value=\"{$s['codigo']}\" {$selected}>{$s['nome']}</option>\n";
                    }
                    ?>
                </select>
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-secondary w-100">
                    <i class="bi bi-search"></i> Buscar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Abas Vendas / PDV -->
<?php
// Separar vendas por módulo de origem
$vendasNormais = array_filter($vendas ?? [], fn($v) => ($v['modulo_origem'] ?? '') !== 'pdv');
$vendasPdv = array_filter($vendas ?? [], fn($v) => ($v['modulo_origem'] ?? '') === 'pdv');
$moduloPdvAtivo = function_exists('moduloFrenteLojaAtivo') && moduloFrenteLojaAtivo();
$abaAtiva = $_GET['aba'] ?? 'vendas';
// Se o módulo PDV não estiver ativo, forçar aba vendas
if (!$moduloPdvAtivo && $abaAtiva === 'pdv') {
    $abaAtiva = 'vendas';
}
?>

<div class="card">
    <!-- Abas -->
    <div class="card-header p-0 border-bottom-0">
        <ul class="nav nav-tabs card-header-tabs" id="vendasTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link <?= $abaAtiva !== 'pdv' ? 'active' : '' ?> px-4 py-3" id="vendas-tab"
                    data-bs-toggle="tab" data-bs-target="#vendas-content" type="button" role="tab"
                    aria-controls="vendas-content" aria-selected="<?= $abaAtiva !== 'pdv' ? 'true' : 'false' ?>">
                    <i class="bi bi-cart-check me-2"></i>Vendas
                    <span class="badge bg-primary ms-2"><?= count($vendasNormais) ?></span>
                </button>
            </li>
            <?php if ($moduloPdvAtivo): ?>
                <li class="nav-item" role="presentation">
                    <button class="nav-link <?= $abaAtiva === 'pdv' ? 'active' : '' ?> px-4 py-3" id="pdv-tab"
                        data-bs-toggle="tab" data-bs-target="#pdv-content" type="button" role="tab"
                        aria-controls="pdv-content" aria-selected="<?= $abaAtiva === 'pdv' ? 'true' : 'false' ?>">
                        <i class="bi bi-shop me-2"></i>PDV
                        <span class="badge bg-success ms-2"><?= count($vendasPdv) ?></span>
                    </button>
                </li>
            <?php endif; ?>
        </ul>
    </div>

    <!-- Conteúdo das Abas -->
    <div class="tab-content" id="vendasTabsContent">
        <!-- Aba Vendas -->
        <div class="tab-pane fade <?= $abaAtiva !== 'pdv' ? 'show active' : '' ?>" id="vendas-content" role="tabpanel"
            aria-labelledby="vendas-tab">
            <div class="card-body p-0">
                <?php if (!empty($vendasNormais)): ?>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0" id="vendas-table">
                            <thead>
                                <tr>
                                    <th width="60">ID</th>
                                    <th>Número</th>
                                    <th>Cliente</th>
                                    <th>Data</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                    <th>Pagamento</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($vendasNormais as $venda): ?>
                                    <tr style="cursor: pointer;" data-venda-id="<?= $venda['id'] ?>"
                                        data-venda-numero="<?= htmlspecialchars($venda['sale_number'], ENT_QUOTES) ?>"
                                        data-venda-cliente="<?= htmlspecialchars($venda['customer_name'] ?? '', ENT_QUOTES) ?>"
                                        data-venda-documento="<?= htmlspecialchars($venda['customer_document'] ?? '', ENT_QUOTES) ?>"
                                        data-venda-vendedor="<?= htmlspecialchars($venda['vendor_name'] ?? '', ENT_QUOTES) ?>"
                                        data-venda-total="<?= formatCurrency($venda['total'] ?? 0) ?>"
                                        data-nfe-emitida="<?= (!empty($venda['chave_nfe']) && !empty($venda['protocolo_nfe']) && !empty($venda['numero_nfe'])) ? 'true' : 'false' ?>"
                                        data-nfe-cancelada="<?= (!empty($venda['protocolo_cancelamento']) && !empty($venda['data_cancelamento'])) ? 'true' : 'false' ?>"
                                        data-nfe-chave="<?= htmlspecialchars($venda['chave_nfe'] ?? '', ENT_QUOTES) ?>"
                                        data-nfe-numero="<?= htmlspecialchars($venda['numero_nfe'] ?? '', ENT_QUOTES) ?>"
                                        data-nfe-xml="<?= htmlspecialchars($venda['xml_path'] ?? '', ENT_QUOTES) ?>"
                                        data-nfe-xml-cancel="<?= htmlspecialchars($venda['xml_cancelamento'] ?? '', ENT_QUOTES) ?>"
                                        data-modulo-origem="<?= htmlspecialchars($venda['modulo_origem'] ?? $moduleOrigin, ENT_QUOTES) ?>"
                                        onclick="abrirOpcoesVenda(event)">
                                        <td><?= $venda['id'] ?></td>
                                        <td><strong><?= htmlspecialchars($venda['sale_number']) ?></strong></td>
                                        <td>
                                            <?php
                                            $fantasia = $venda['pessoa_trade_name'] ?? '';
                                            $razaoSocial = $venda['pessoa_name'] ?? $venda['customer_name'] ?? 'Consumidor Final';
                                            $cnpj = $venda['customer_document'] ?? '';
                                            $vendedor = !empty($venda['vendor_name']) ? $venda['vendor_name'] : null;

                                            if (!empty($fantasia) || !empty($razaoSocial) || !empty($cnpj)):
                                                ?>
                                                <div class="cliente-card">
                                                    <?php if (!empty($fantasia)): ?>
                                                        <div class="cliente-card-item">
                                                            <small>Fantasia:</small><strong><?= htmlspecialchars($fantasia) ?></strong>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if (!empty($razaoSocial)): ?>
                                                        <div class="cliente-card-item"><small>Razão
                                                                Social:</small><strong><?= htmlspecialchars($razaoSocial) ?></strong>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if (!empty($cnpj) || !empty($vendedor)): ?>
                                                        <div class="cliente-card-item cliente-card-item-inline">
                                                            <?php if (!empty($cnpj)): ?>
                                                                <small>CNPJ:</small><span><?= formatDocument($cnpj) ?></span>
                                                            <?php endif; ?>
                                                            <?php if (!empty($cnpj) && !empty($vendedor)): ?>
                                                                <span style="margin: 0 8px; color: #dee2e6;">|</span>
                                                            <?php endif; ?>
                                                            <?php if (!empty($vendedor)): ?>
                                                                <small>Vendedor:</small><span><?= htmlspecialchars($vendedor) ?></span>
                                                            <?php endif; ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            <?php else: ?>
                                                <?= htmlspecialchars($razaoSocial) ?>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= date('d/m/Y', strtotime($venda['sale_date'])) ?></td>
                                        <td><?= formatCurrency($venda['total'] ?? 0) ?></td>
                                        <td>
                                            <?php
                                            $statusBadges = [
                                                'orcamento' => '<span class="badge bg-secondary"><i class="bi bi-file-earmark me-1"></i>Orçamento</span>',
                                                'pendente' => '<span class="badge bg-warning text-dark"><i class="bi bi-clock me-1"></i>Pendente</span>',
                                                'realizado' => '<span class="badge bg-info"><i class="bi bi-check me-1"></i>Realizado</span>',
                                                'faturamento' => '<span class="badge bg-primary"><i class="bi bi-receipt me-1"></i>Faturamento</span>',
                                                'expedicao' => '<span class="badge bg-purple"><i class="bi bi-box-seam me-1"></i>Expedição</span>',
                                                'em_entrega' => '<span class="badge bg-cyan"><i class="bi bi-truck me-1"></i>Em Entrega</span>',
                                                'finalizado' => '<span class="badge bg-success"><i class="bi bi-check-circle me-1"></i>Finalizado</span>'
                                            ];
                                            echo $statusBadges[$venda['status']] ?? '-';
                                            ?>
                                        </td>
                                        <td><?= htmlspecialchars($venda['payment_method_name'] ?? '-') ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-cart-check" style="font-size: 4rem; color: var(--text-secondary);"></i>
                        <p class="text-muted mt-3">Nenhuma venda encontrada</p>
                        <a href="<?= url($routeBase . '/criar') ?>" class="btn btn-primary mt-2">
                            <i class="bi bi-cart-plus me-2"></i> Nova Venda
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Aba PDV -->
        <?php if ($moduloPdvAtivo): ?>
            <div class="tab-pane fade <?= $abaAtiva === 'pdv' ? 'show active' : '' ?>" id="pdv-content" role="tabpanel"
                aria-labelledby="pdv-tab">
                <div class="card-body p-0">
                    <?php if (!empty($vendasPdv)): ?>
                        <div class="table-responsive">
                            <table class="table table-hover mb-0" id="pdv-table">
                                <thead>
                                    <tr>
                                        <th width="60">ID</th>
                                        <th>Número</th>
                                        <th>Cliente</th>
                                        <th>Data/Hora</th>
                                        <th>Total</th>
                                        <th>Status</th>
                                        <th>Pagamento</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($vendasPdv as $venda): ?>
                                        <tr style="cursor: pointer;" data-venda-id="<?= $venda['id'] ?>"
                                            data-venda-numero="<?= htmlspecialchars($venda['sale_number'], ENT_QUOTES) ?>"
                                            data-venda-cliente="<?= htmlspecialchars($venda['customer_name'] ?? '', ENT_QUOTES) ?>"
                                            data-venda-documento="<?= htmlspecialchars($venda['customer_document'] ?? '', ENT_QUOTES) ?>"
                                            data-venda-vendedor="<?= htmlspecialchars($venda['vendor_name'] ?? '', ENT_QUOTES) ?>"
                                            data-venda-total="<?= formatCurrency($venda['total'] ?? 0) ?>"
                                            data-nfe-emitida="<?= (!empty($venda['chave_nfe']) && !empty($venda['protocolo_nfe']) && !empty($venda['numero_nfe'])) ? 'true' : 'false' ?>"
                                            data-nfe-cancelada="<?= (!empty($venda['protocolo_cancelamento']) && !empty($venda['data_cancelamento'])) ? 'true' : 'false' ?>"
                                            data-nfe-chave="<?= htmlspecialchars($venda['chave_nfe'] ?? '', ENT_QUOTES) ?>"
                                            data-nfe-numero="<?= htmlspecialchars($venda['numero_nfe'] ?? '', ENT_QUOTES) ?>"
                                            data-nfe-xml="<?= htmlspecialchars($venda['xml_path'] ?? '', ENT_QUOTES) ?>"
                                            data-nfe-xml-cancel="<?= htmlspecialchars($venda['xml_cancelamento'] ?? '', ENT_QUOTES) ?>"
                                            data-modulo-origem="pdv" onclick="abrirOpcoesVenda(event)">
                                            <td><?= $venda['id'] ?></td>
                                            <td>
                                                <span class="badge bg-success me-1"><i class="bi bi-shop"></i></span>
                                                <strong><?= htmlspecialchars($venda['sale_number']) ?></strong>
                                            </td>
                                            <td>
                                                <?php
                                                $fantasia = $venda['pessoa_trade_name'] ?? '';
                                                $razaoSocial = $venda['pessoa_name'] ?? $venda['customer_name'] ?? 'Consumidor Final';
                                                $cnpj = $venda['customer_document'] ?? '';
                                                $vendedor = !empty($venda['vendor_name']) ? $venda['vendor_name'] : null;

                                                if (!empty($fantasia) || !empty($razaoSocial) || !empty($cnpj)):
                                                    ?>
                                                    <div class="cliente-card">
                                                        <?php if (!empty($fantasia)): ?>
                                                            <div class="cliente-card-item">
                                                                <small>Fantasia:</small><strong><?= htmlspecialchars($fantasia) ?></strong>
                                                            </div>
                                                        <?php endif; ?>
                                                        <?php if (!empty($razaoSocial)): ?>
                                                            <div class="cliente-card-item"><small>Razão
                                                                    Social:</small><strong><?= htmlspecialchars($razaoSocial) ?></strong>
                                                            </div>
                                                        <?php endif; ?>
                                                        <?php if (!empty($cnpj) || !empty($vendedor)): ?>
                                                            <div class="cliente-card-item cliente-card-item-inline">
                                                                <?php if (!empty($cnpj)): ?>
                                                                    <small>CNPJ:</small><span><?= formatDocument($cnpj) ?></span>
                                                                <?php endif; ?>
                                                                <?php if (!empty($cnpj) && !empty($vendedor)): ?>
                                                                    <span style="margin: 0 8px; color: #dee2e6;">|</span>
                                                                <?php endif; ?>
                                                                <?php if (!empty($vendedor)): ?>
                                                                    <small>Vendedor:</small><span><?= htmlspecialchars($vendedor) ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php else: ?>
                                                    <?= htmlspecialchars($razaoSocial) ?>
                                                <?php endif; ?>
                                            </td>
                                            <td><?= date('d/m/Y H:i', strtotime($venda['created_at'] ?? $venda['sale_date'])) ?>
                                            </td>
                                            <td><strong class="text-success"><?= formatCurrency($venda['total'] ?? 0) ?></strong>
                                            </td>
                                            <td>
                                                <?php
                                                $statusBadges = [
                                                    'orcamento' => '<span class="badge bg-secondary"><i class="bi bi-file-earmark me-1"></i>Orçamento</span>',
                                                    'pendente' => '<span class="badge bg-warning text-dark"><i class="bi bi-clock me-1"></i>Pendente</span>',
                                                    'realizado' => '<span class="badge bg-info"><i class="bi bi-check me-1"></i>Realizado</span>',
                                                    'faturamento' => '<span class="badge bg-primary"><i class="bi bi-receipt me-1"></i>Faturamento</span>',
                                                    'expedicao' => '<span class="badge bg-purple"><i class="bi bi-box-seam me-1"></i>Expedição</span>',
                                                    'em_entrega' => '<span class="badge bg-cyan"><i class="bi bi-truck me-1"></i>Em Entrega</span>',
                                                    'finalizado' => '<span class="badge bg-success"><i class="bi bi-check-circle me-1"></i>Finalizado</span>'
                                                ];
                                                echo $statusBadges[$venda['status']] ?? '-';
                                                ?>
                                            </td>
                                            <td><?= htmlspecialchars($venda['payment_method_name'] ?? '-') ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="bi bi-shop" style="font-size: 4rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-3">Nenhuma venda do PDV encontrada</p>
                            <a href="<?= url('/pdv/caixa') ?>" class="btn btn-success mt-2">
                                <i class="bi bi-shop me-2"></i> Abrir PDV
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    const moduloOrigemAtual = '<?= htmlspecialchars($moduleOrigin, ENT_QUOTES) ?>';
    const conversionEnabled = <?= $conversionEnabled ? 'true' : 'false' ?>;
    const currentRouteBase = '<?= htmlspecialchars(rtrim($routeBase, '/'), ENT_QUOTES) ?>';
    const moduleSingular = <?= json_encode($singular ?? 'Venda') ?>;
    const moduleSingularLower = (moduleSingular || 'Venda').toLowerCase();

    function buildModuleUrl(path) {
        const base = currentRouteBase || '/vendas';
        const normalizedBase = base.startsWith('/') ? base : `/${base}`;
        const normalizedPath = path.startsWith('/') ? path : `/${path}`;
        return appUrl(`${normalizedBase}${normalizedPath}`);
    }

    async function abrirModalConferencia() {
        const { value: numeroVenda } = await Swal.fire({
            title: '<i class="bi bi-clipboard-check text-info"></i> Conferência de Venda',
            html: `
                <div class="text-start">
                    <p class="mb-3">Informe o número da venda para conferir:</p>
                    <input type="text" class="form-control" id="numero_venda_conferencia"
                           placeholder="Ex: VND-001" autofocus>
                </div>
            `,
            width: '500px',
            showCancelButton: true,
            confirmButtonText: '<i class="bi bi-search me-2"></i>Buscar',
            cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Cancelar',
            confirmButtonColor: '#0dcaf0',
            cancelButtonColor: '#6c757d',
            preConfirm: () => {
                const numero = document.getElementById('numero_venda_conferencia').value.trim();
                if (!numero) {
                    Swal.showValidationMessage('Por favor, informe o número da venda');
                    return false;
                }
                return numero;
            },
            allowOutsideClick: false
        });

        if (!numeroVenda) {
            return;
        }

        // Mostrar loading
        Swal.fire({
            title: 'Buscando venda...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        try {
            const response = await fetch(appUrl(`/vendas/buscar-conferencia?numero=${encodeURIComponent(numeroVenda)}`));
            const result = await response.json();

            if (!result.success || !result.venda) {
                Swal.fire({
                    icon: 'error',
                    title: 'Venda não encontrada',
                    text: result.message || 'Não foi possível encontrar a venda com o número informado.',
                    confirmButtonText: 'OK'
                });
                return;
            }

            const venda = result.venda;
            const itens = result.itens || [];
            const singularLabel = moduleSingular || 'Venda';

            // Formatar valor
            const formatCurrency = (value) => {
                return new Intl.NumberFormat('pt-BR', {
                    style: 'currency',
                    currency: 'BRL'
                }).format(value || 0);
            };

            // Formatar data
            const formatDate = (dateString) => {
                if (!dateString) return '-';
                const date = new Date(dateString);
                return date.toLocaleDateString('pt-BR') + ' ' + date.toLocaleTimeString('pt-BR', { hour: '2-digit', minute: '2-digit' });
            };

            // Criar HTML dos itens
            let itensHtml = '';
            if (itens.length > 0) {
                itensHtml = `
                    <div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
                        <table class="table table-sm table-bordered mb-0">
                            <thead class="table-light" style="position: sticky; top: 0;">
                                <tr>
                                    <th>Produto</th>
                                    <th class="text-center" width="80">Qtd</th>
                                    <th class="text-end" width="100">Valor Unit.</th>
                                    <th class="text-end" width="100">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                ${itens.map(item => `
                                    <tr>
                                        <td>
                                            <strong>${item.product_name || '-'}</strong><br>
                                            <small class="text-muted">${item.product_sku || '-'}</small>
                                        </td>
                                        <td class="text-center">${parseFloat(item.quantity || 0).toFixed(3).replace('.', ',')}</td>
                                        <td class="text-end">${formatCurrency(item.unit_price || 0)}</td>
                                        <td class="text-end"><strong>${formatCurrency(item.total_price || 0)}</strong></td>
                                    </tr>
                                `).join('')}
                            </tbody>
                        </table>
                    </div>
                `;
            } else {
                itensHtml = '<p class="text-muted text-center py-3">Nenhum item encontrado</p>';
            }

            // Armazenar dados da venda globalmente para uso na conferência
            window.vendaConferencia = venda;
            window.itensConferencia = itens;
            window.itensConferidos = {}; // Armazenar itens conferidos

            // Verificar itens já conferidos
            const itensJaConferidos = itens.filter(item => item.item_conferido === 'Sim');
            itensJaConferidos.forEach(item => {
                window.itensConferidos[item.id] = true;
            });

            // Criar HTML da tabela de itens conferidos
            let itensConferidosHtml = '';
            if (itensJaConferidos.length > 0) {
                itensConferidosHtml = `
                    <div class="mt-3">
                        <h6 class="mb-2 text-success"><strong>Itens Conferidos:</strong></h6>
                        <div class="table-responsive" style="max-height: 200px; overflow-y: auto;">
                            <table class="table table-sm table-bordered table-success mb-0" id="tabela_itens_conferidos">
                                <thead class="table-light" style="position: sticky; top: 0;">
                                    <tr>
                                        <th>SKU</th>
                                        <th>Produto</th>
                                        <th class="text-center" width="80">Qtd</th>
                                        <th class="text-center" width="100">Lote</th>
                                        <th class="text-center" width="100">Validade</th>
                                    </tr>
                                </thead>
                                <tbody id="tbody_itens_conferidos">
                                    ${itensJaConferidos.map(item => {
                    const validadeFormatada = item.validade ?
                        new Date(item.validade).toLocaleDateString('pt-BR') : '-';
                    return `
                                            <tr data-item-id="${item.id}">
                                                <td>${item.product_sku || '-'}</td>
                                                <td><strong>${item.product_name || '-'}</strong></td>
                                                <td class="text-center">${parseFloat(item.quantity || 0).toFixed(3).replace('.', ',')}</td>
                                                <td class="text-center">${item.lote || '-'}</td>
                                                <td class="text-center">${validadeFormatada}</td>
                                            </tr>
                                        `;
                }).join('')}
                                </tbody>
                            </table>
                        </div>
                    </div>
                `;
            }

            // Mostrar modal com dados da venda
            Swal.fire({
                title: `<i class="bi bi-clipboard-check text-info"></i> ${singularLabel} ${venda.sale_number}`,
                html: `
                    <div class="text-start">
                        <div class="alert alert-info mb-3">
                            <div class="row">
                                <div class="col-md-6">
                                    <strong>Cliente:</strong><br>
                                    ${venda.customer_name || 'Consumidor Final'}<br>
                                    ${venda.customer_document ? `<small>${venda.customer_document}</small>` : ''}
                                </div>
                                <div class="col-md-6 text-end">
                                    <strong>Data:</strong><br>
                                    ${formatDate(venda.sale_date || venda.created_at)}<br>
                                    <strong>Total:</strong> ${formatCurrency(venda.total || 0)}
                                </div>
                            </div>
                        </div>

                        <!-- Campo de Busca de Código de Barras -->
                        <div class="mb-3 p-3 bg-light border rounded">
                            <label class="form-label fw-bold mb-2">
                                <i class="bi bi-upc-scan text-primary"></i> Código de Barras:
                            </label>
                            <input type="text"
                                   class="form-control form-control-lg"
                                   id="codigo_barras_conferencia"
                                   placeholder="Leia ou digite o código de barras e pressione Enter"
                                   autocomplete="off">
                            <div id="mensagem_conferencia" class="mt-2" style="min-height: 20px; font-size: 0.875rem;"></div>
                        </div>

                        ${itensConferidosHtml}
                    </div>
                `,
                width: '900px',
                showCancelButton: true,
                confirmButtonText: '<i class="bi bi-eye me-2"></i>Visualizar Completo',
                cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Fechar',
                confirmButtonColor: '#0dcaf0',
                cancelButtonColor: '#6c757d',
                didOpen: () => {
                    // Focar no campo de código de barras
                    const codigoBarrasInput = document.getElementById('codigo_barras_conferencia');
                    if (codigoBarrasInput) {
                        codigoBarrasInput.focus();
                        codigoBarrasInput.addEventListener('keypress', function (e) {
                            if (e.key === 'Enter') {
                                e.preventDefault();
                                const codigoBarras = this.value.trim();
                                if (!codigoBarras) {
                                    mostrarMensagemConferencia('Por favor, informe o código de barras', 'error');
                                    return;
                                }
                                conferirItemModal(venda.id, codigoBarras);
                            }
                        });
                    }
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = buildModuleUrl(`/visualizar?id=${venda.id}`);
                }
            });

        } catch (error) {
            console.error('Erro ao buscar venda:', error);
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Ocorreu um erro ao buscar a venda. Tente novamente.',
                confirmButtonText: 'OK'
            });
        }
    }

    function mostrarMensagemConferencia(texto, tipo = 'info') {
        const mensagemEl = document.getElementById('mensagem_conferencia');
        if (!mensagemEl) return;

        const cor = tipo === 'error' ? '#dc3545' : tipo === 'success' ? '#28a745' : '#0dcaf0';
        mensagemEl.innerHTML = `<span style="color: ${cor}; font-weight: 600;">${texto}</span>`;
        setTimeout(() => {
            mensagemEl.innerHTML = '';
        }, 3000);
    }

    function conferirItemModal(vendaId, codigoBarras) {
        // Primeiro buscar o item
        fetch(appUrl('/vendas/buscar-item-conferencia'), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: new URLSearchParams({
                venda_id: vendaId,
                codigo_barras: codigoBarras
            })
        })
            .then(response => response.json())
            .then(result => {
                if (result.success && result.item) {
                    // Abrir modal para informar quantidade e lote
                    abrirModalQuantidadeLote(result.item, vendaId, codigoBarras);
                } else {
                    mostrarMensagemConferencia(result.message || 'Erro ao buscar item', 'error');
                }
            })
            .catch(error => {
                console.error('Erro:', error);
                mostrarMensagemConferencia('Erro ao processar busca', 'error');
            });
    }

    function abrirModalQuantidadeLote(item, vendaId, codigoBarras) {
        const quantidadePedido = parseFloat(item.quantity || 0);
        const lotePedido = (item.lote || '').trim();
        const produtoNome = item.product_name || item.product_sku || 'Produto';

        let htmlModal = `
            <div class="mb-3">
                <label class="form-label fw-bold">Produto:</label>
                <p class="form-control-plaintext">${produtoNome}</p>
            </div>
            <div id="divergencias_info" style="display: none;" class="mb-3">
                <div class="alert alert-warning">
                    <strong><i class="bi bi-exclamation-triangle me-2"></i>Divergências Detectadas:</strong>
                    <div class="mt-2">
                        <div id="divergencia_quantidade" style="display: none;">
                            <strong>Quantidade do Pedido:</strong> <span id="qtd_pedido_text">${quantidadePedido}</span><br>
                            <strong>Quantidade Informada:</strong> <span id="qtd_informada_text"></span>
                        </div>
                        ${lotePedido ? `
                        <div id="divergencia_lote" style="display: none;" class="mt-2">
                            <strong>Lote do Pedido:</strong> <span id="lote_pedido_text">${lotePedido}</span><br>
                            <strong>Lote Informado:</strong> <span id="lote_informado_text"></span>
                        </div>
                        ` : ''}
                    </div>
                </div>
            </div>
            <div class="mb-3">
                <label for="quantidade_conferencia" class="form-label fw-bold">
                    Quantidade Informada: <span class="text-danger">*</span>
                </label>
                <input type="number"
                       step="0.01"
                       min="0"
                       class="form-control"
                       id="quantidade_conferencia"
                       value=""
                       placeholder="Informe a quantidade">
            </div>
            ${lotePedido ? `
            <div class="mb-3">
                <label for="lote_conferencia" class="form-label fw-bold">
                    Lote Informado: <span class="text-danger">*</span>
                </label>
                <input type="text"
                       class="form-control"
                       id="lote_conferencia"
                       value=""
                       placeholder="Informe o lote">
            </div>
            ` : ''}
        `;

        Swal.fire({
            title: '<i class="bi bi-clipboard-check text-primary"></i> Conferir Item',
            html: htmlModal,
            width: '500px',
            showCancelButton: true,
            confirmButtonText: '<i class="bi bi-check-circle me-2"></i>Conferir',
            cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Cancelar',
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#6c757d',
            didOpen: () => {
                const quantidadeInput = document.getElementById('quantidade_conferencia');
                const loteInput = document.getElementById('lote_conferencia');
                const divergenciasInfo = document.getElementById('divergencias_info');
                const divergenciaQuantidade = document.getElementById('divergencia_quantidade');
                const divergenciaLote = document.getElementById('divergencia_lote');
                const qtdInformadaText = document.getElementById('qtd_informada_text');
                const loteInformadoText = document.getElementById('lote_informado_text');

                // Função para verificar divergências
                const verificarDivergencias = () => {
                    const quantidadeInformada = parseFloat(quantidadeInput.value) || 0;
                    const loteInformado = loteInput ? loteInput.value.trim() : '';

                    let temDivergencia = false;

                    // Verificar divergência de quantidade
                    if (quantidadeInformada > 0 && quantidadeInformada !== quantidadePedido) {
                        divergenciaQuantidade.style.display = 'block';
                        qtdInformadaText.textContent = quantidadeInformada;
                        temDivergencia = true;
                    } else {
                        divergenciaQuantidade.style.display = 'none';
                    }

                    // Verificar divergência de lote
                    if (lotePedido && loteInput) {
                        if (loteInformado && loteInformado !== lotePedido) {
                            divergenciaLote.style.display = 'block';
                            loteInformadoText.textContent = loteInformado;
                            temDivergencia = true;
                        } else {
                            divergenciaLote.style.display = 'none';
                        }
                    }

                    // Mostrar/ocultar bloco de divergências
                    if (temDivergencia) {
                        divergenciasInfo.style.display = 'block';
                    } else {
                        divergenciasInfo.style.display = 'none';
                    }
                };

                if (quantidadeInput) {
                    quantidadeInput.focus();
                    quantidadeInput.addEventListener('blur', verificarDivergencias);
                    quantidadeInput.addEventListener('keypress', function (e) {
                        if (e.key === 'Enter') {
                            e.preventDefault();
                            if (loteInput) {
                                loteInput.focus();
                            } else {
                                document.querySelector('.swal2-confirm').click();
                            }
                        }
                    });
                }

                if (loteInput) {
                    loteInput.addEventListener('blur', verificarDivergencias);
                    loteInput.addEventListener('keypress', function (e) {
                        if (e.key === 'Enter') {
                            e.preventDefault();
                            document.querySelector('.swal2-confirm').click();
                        }
                    });
                }
            },
            preConfirm: () => {
                const quantidade = parseFloat(document.getElementById('quantidade_conferencia').value) || 0;
                const lote = lotePedido ? (document.getElementById('lote_conferencia').value || '').trim() : '';

                if (quantidade <= 0) {
                    Swal.showValidationMessage('A quantidade deve ser maior que zero');
                    return false;
                }

                if (lotePedido && !lote) {
                    Swal.showValidationMessage('O lote é obrigatório');
                    return false;
                }

                return { quantidade, lote };
            }
        }).then((result) => {
            if (result.isConfirmed && result.value) {
                // Conferir o item com quantidade e lote informados
                confirmarConferenciaItem(vendaId, item.id, result.value.quantidade, result.value.lote, codigoBarras);
            }
        });
    }

    function confirmarConferenciaItem(vendaId, itemId, quantidade, lote, codigoBarras) {
        fetch(appUrl('/vendas/conferir-item-romaneio'), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: new URLSearchParams({
                venda_id: vendaId,
                item_id: itemId,
                quantidade: quantidade,
                lote: lote
            })
        })
            .then(response => response.json())
            .then(result => {
                if (result.success) {
                    mostrarMensagemConferencia('Item conferido com sucesso!', 'success');
                    adicionarItemConferidoModal(result.item);
                    const codigoBarrasInput = document.getElementById('codigo_barras_conferencia');
                    if (codigoBarrasInput) {
                        codigoBarrasInput.value = '';
                        codigoBarrasInput.focus();
                    }
                } else {
                    mostrarMensagemConferencia(result.message || 'Erro ao conferir item', 'error');
                    const codigoBarrasInput = document.getElementById('codigo_barras_conferencia');
                    if (codigoBarrasInput) {
                        codigoBarrasInput.focus();
                    }
                }
            })
            .catch(error => {
                console.error('Erro:', error);
                mostrarMensagemConferencia('Erro ao processar conferência', 'error');
            });
    }

    function adicionarItemConferidoModal(item) {
        // Verificar se já foi adicionado
        if (window.itensConferidos && window.itensConferidos[item.id]) {
            return; // Já foi adicionado
        }

        if (!window.itensConferidos) {
            window.itensConferidos = {};
        }
        window.itensConferidos[item.id] = true;

        let tbody = document.getElementById('tbody_itens_conferidos');
        if (!tbody) {
            // Criar tabela se não existir - inserir após o campo de código de barras
            const campoCodigoBarras = document.getElementById('codigo_barras_conferencia');
            if (!campoCodigoBarras) return;

            const campoContainer = campoCodigoBarras.closest('.p-3');
            const tabelaHtml = `
                <div class="mt-3">
                    <h6 class="mb-2 text-success"><strong>Itens Conferidos:</strong></h6>
                    <div class="table-responsive" style="max-height: 200px; overflow-y: auto;">
                        <table class="table table-sm table-bordered table-success mb-0" id="tabela_itens_conferidos">
                            <thead class="table-light" style="position: sticky; top: 0;">
                                <tr>
                                    <th>SKU</th>
                                    <th>Produto</th>
                                    <th class="text-center" width="80">Qtd</th>
                                    <th class="text-center" width="100">Lote</th>
                                    <th class="text-center" width="100">Validade</th>
                                </tr>
                            </thead>
                            <tbody id="tbody_itens_conferidos">
                            </tbody>
                        </table>
                    </div>
                </div>
            `;
            campoContainer.insertAdjacentHTML('afterend', tabelaHtml);
            tbody = document.getElementById('tbody_itens_conferidos');
            if (!tbody) return;
        }

        // Verificar se já existe uma linha com esse item
        const existingRow = tbody.querySelector(`tr[data-item-id="${item.id}"]`);
        if (existingRow) {
            return; // Já existe
        }

        adicionarLinhaItemConferido(tbody, item);
    }

    function adicionarLinhaItemConferido(tbody, item) {
        const validadeFormatada = item.validade ?
            new Date(item.validade).toLocaleDateString('pt-BR') : '-';

        const tr = document.createElement('tr');
        tr.setAttribute('data-item-id', item.id);
        tr.innerHTML = `
            <td>${item.product_sku || '-'}</td>
            <td><strong>${item.product_name || '-'}</strong></td>
            <td class="text-center">${parseFloat(item.quantity || 0).toFixed(3).replace('.', ',')}</td>
            <td class="text-center">${item.lote || '-'}</td>
            <td class="text-center">${validadeFormatada}</td>
        `;
        tbody.appendChild(tr);
    }

    function abrirOpcoesVenda(event) {
        // Buscar dados da linha da tabela
        const row = event.target.closest('tr');
        if (!row) return;

        const id = row.dataset.vendaId;
        const numero = row.dataset.vendaNumero;
        const cliente = row.dataset.vendaCliente;
        const cnpj = row.dataset.vendaDocumento;
        const vendedor = row.dataset.vendaVendedor;
        const total = row.dataset.vendaTotal;
        const xmlPath = row.dataset.nfeXml || '';
        const chaveNfe = row.dataset.nfeChave || '';
        const nfeEmitida = row.dataset.nfeEmitida === 'true';
        const nfeCancelada = row.dataset.nfeCancelada === 'true';
        const moduloOrigem = (row.dataset.moduloOrigem || moduloOrigemAtual || '').toLowerCase();
        const singularLabel = moduleSingular || 'Venda';
        const singularLower = moduleSingularLower || 'venda';

        const headerHtml = `
        <div style="background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);
                    padding: 1.5rem;
                    margin: 0 0 1rem 0;
                    border-radius: 12px 12px 0 0;
                    color: white;
                    text-align: left;">
            <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 0.75rem;">
                <div style="background: rgba(255,255,255,0.2);
                            padding: 0.75rem;
                            border-radius: 10px;
                            display: flex;
                            align-items: center;
                            justify-content: center;">
                    <i class="bi bi-cart-check" style="font-size: 1.5rem;"></i>
                </div>
                <div style="flex: 1; padding-right: 3rem;">
                    <div style="font-size: 0.85rem; opacity: 0.9; margin-bottom: 0.25rem;">${singularLabel}</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">${numero}</div>
                </div>
                <div style="text-align: right; min-width: 140px; padding-right: 2.5rem;">
                    <div style="font-size: 0.85rem; opacity: 0.9; margin-bottom: 0.25rem;">Valor Total</div>
                    <div style="font-size: 1.15rem; font-weight: 600;">${total}</div>
                </div>
            </div>
            <div style="background: rgba(255,255,255,0.15);
                        padding: 0.75rem 1rem;
                        border-radius: 8px;
                        display: flex;
                        align-items: center;
                        gap: 0.75rem;">
                <i class="bi bi-person-circle" style="font-size: 1.1rem; opacity: 0.9;"></i>
                <div style="flex: 1;">
                    <strong style="font-size: 0.95rem;">${cliente || 'Cliente não informado'}</strong>
                    ${cnpj ? `
                        <div style="opacity: 0.9; font-size: 0.85rem; margin-top: 0.25rem;">
                            <i class="bi bi-card-text" style="font-size: 0.85rem; margin-right: 0.25rem;"></i>
                            ${cnpj}
                        </div>
                    ` : ''}
                </div>
                ${vendedor ? `
                    <div style="text-align: right; border-left: 1px solid rgba(255,255,255,0.2); padding-left: 0.75rem;">
                        <div style="opacity: 0.8; font-size: 0.75rem; margin-bottom: 0.25rem;">Vendedor</div>
                        <div style="font-size: 0.9rem; font-weight: 600;">
                            <i class="bi bi-person-badge" style="font-size: 0.85rem; margin-right: 0.25rem;"></i>
                            ${vendedor}
                        </div>
                    </div>
                ` : ''}
            </div>
        </div>
    `;

        const vendaButtons = `
        <div class="opcoes-grupo">
            <h6 class="opcoes-titulo">${singularLabel}</h6>
            <div class="opcoes-grid">
                <button type="button" class="opcao-card opcao-card-secondary" onclick="window.location.href=buildModuleUrl(\`/visualizar?id=${id}\`)">
                    <i class="bi bi-eye"></i>
                    <span>Ver ${singularLower}</span>
                </button>
                <button type="button" class="opcao-card opcao-card-secondary" onclick="window.open(buildModuleUrl(\`/imprimir?id=${id}\`), '_blank')">
                    <i class="bi bi-printer-fill"></i>
                    <span>Imprimir ${singularLabel}</span>
                </button>
                <button type="button" class="opcao-card opcao-card-warning" onclick="window.open(buildModuleUrl(\`/romaneio-separacao?id=${id}\`), '_blank')">
                    <i class="bi bi-clipboard-check"></i>
                    <span>Romaneio Separação</span>
                </button>
                <button type="button" class="opcao-card opcao-card-info" onclick="enviarPorEmail(${id}, '${numero.replace(/'/g, "&#39;")}', '${(cliente || '').replace(/'/g, "&#39;")}')">
                    <i class="bi bi-envelope"></i>
                    <span>Enviar por e-mail</span>
                </button>
                <button type="button" class="opcao-card opcao-card-primary" onclick="window.location.href=buildModuleUrl(\`/editar?id=${id}\`)">
                    <i class="bi bi-pencil"></i>
                    <span>Editar ${singularLower}</span>
                </button>
                <button type="button" class="opcao-card opcao-card-info" onclick="duplicarVenda(${id}, '${numero.replace(/'/g, "&#39;")}')">
                    <i class="bi bi-files"></i>
                    <span>Duplicar ${singularLower}</span>
                </button>
                <button type="button" class="opcao-card opcao-card-danger" onclick="deletarVenda(${id})">
                    <i class="bi bi-trash"></i>
                    <span>Excluir ${singularLower}</span>
                </button>
                ${(['dav', 'pre_venda'].includes(moduloOrigem) && conversionEnabled) ? `
                    <button type="button" class="opcao-card opcao-card-success" onclick="converterDavParaVenda(${id}, '${numero.replace(/'/g, "&#39;")}')">
                        <i class="bi bi-arrow-left-right"></i>
                        <span>Converter em Venda</span>
                    </button>
                ` : ''}
            </div>
        </div>
    `;

        let sectionsHtml = vendaButtons;

        if (moduloOrigem !== 'dav') {
            let nfeButtons = '';
            if (nfeEmitida) {
                nfeButtons += `
                <button type="button" class="opcao-card opcao-card-success" onclick="reimprimirNFe(${id})">
                    <i class="bi bi-receipt"></i>
                    <span>Reimprimir NF-e</span>
                </button>
                <button type="button" class="opcao-card opcao-card-secondary" onclick="visualizarXmlNFe(${JSON.stringify(xmlPath)})">
                    <i class="bi bi-file-earmark-code"></i>
                    <span>Ver XML</span>
                </button>
                <button type="button" class="opcao-card opcao-card-info" onclick="enviarEmailNFe(${id}, '${numero.replace(/'/g, "&#39;")}', '${(cliente || '').replace(/'/g, "&#39;")}', '${chaveNfe}')">
                    <i class="bi bi-envelope-paper"></i>
                    <span>Enviar e-mail</span>
                </button>
            `;

                if (!nfeCancelada) {
                    nfeButtons += `
                    <button type="button" class="opcao-card opcao-card-warning" onclick="cartaCorrecaoNFe(${id})">
                        <i class="bi bi-pencil-square"></i>
                        <span>Carta de Correção</span>
                    </button>
                    <button type="button" class="opcao-card opcao-card-danger" onclick="cancelarNFe(${id})">
                        <i class="bi bi-x-circle"></i>
                        <span>Cancelar NF-e</span>
                    </button>
                `;
                }
            } else {
                const total = (function () {
                    try {
                        return parseFloat(document.querySelector(`#vendas-table tbody tr td:nth-child(5)`)?.innerText?.replace(/[^0-9,.-]/g, '').replace('.', '').replace(',', '.') || '0');
                    } catch (e) {
                        return 0;
                    }
                })();

                nfeButtons += `
                <button type="button" class="opcao-card opcao-card-success" onclick="emitirNFe(${id}, '${numero.replace(/'/g, "&#39;")}', '${(cliente || '').replace(/'/g, "&#39;")}', ${isNaN(total) ? 0 : total})">
                    <i class="bi bi-file-earmark-text"></i>
                    <span>Emitir NF-e</span>
                </button>
            `;
            }

            const nfeSection = `
            <div class="opcoes-grupo">
                <h6 class="opcoes-titulo">NF-e</h6>
                <div class="opcoes-grid">
                    ${nfeButtons || '<div class="text-muted small">Nenhuma ação disponível.</div>'}
                </div>
            </div>
        `;

            const nfceSection = `
            <div class="opcoes-grupo">
                <h6 class="opcoes-titulo">NFC-e</h6>
                <div class="opcoes-grid">
                    <button type="button" class="opcao-card opcao-card-info" onclick="emitirNFCE(${id}, '${numero.replace(/'/g, "&#39;")}', '${(cliente || '').replace(/'/g, "&#39;")}')">
                        <i class="bi bi-phone"></i>
                        <span>Emitir NFC-e</span>
                    </button>
                    <button type="button" class="opcao-card opcao-card-primary" onclick="enviarEmailNFCE(${id}, '${numero.replace(/'/g, "&#39;")}', '${(cliente || '').replace(/'/g, "&#39;")}')">
                        <i class="bi bi-envelope-open"></i>
                        <span>Enviar e-mail</span>
                    </button>
                </div>
            </div>
        `;

            const nfseSection = `
            <div class="opcoes-grupo">
                <h6 class="opcoes-titulo">NFS-e</h6>
                <div class="opcoes-grid">
                    <button type="button" class="opcao-card opcao-card-warning" onclick="emitirNFSe(${id}, '${numero.replace(/'/g, "&#39;")}', '${(cliente || '').replace(/'/g, "&#39;")}')">
                        <i class="bi bi-file-earmark-text-fill"></i>
                        <span>Emitir NFS-e</span>
                    </button>
                    <button type="button" class="opcao-card opcao-card-primary" onclick="enviarEmailNFSe(${id}, '${numero.replace(/'/g, "&#39;")}', '${(cliente || '').replace(/'/g, "&#39;")}')">
                        <i class="bi bi-envelope-open"></i>
                        <span>Enviar e-mail</span>
                    </button>
                </div>
            </div>
        `;

            sectionsHtml += nfeSection + nfceSection + nfseSection;
        }

        const html = headerHtml + sectionsHtml;

        Swal.fire({
            html: html,
            showConfirmButton: false,
            showCloseButton: true,
            width: '700px',
            padding: '0',
            customClass: {
                popup: 'swal-venda-opcoes',
                htmlContainer: 'swal-venda-container'
            }
        });
    }

    // Adicionar estilo customizado para o modal
    const style = document.createElement('style');
    style.textContent = `
    .swal-venda-opcoes {
        border-radius: 16px;
        overflow: visible !important;
    }
    .swal-venda-container {
        margin: 0 !important;
        padding: 0 !important;
        overflow: visible !important;
    }
    .swal-venda-opcoes .swal2-html-container {
        overflow: visible !important;
    }
    .swal-venda-opcoes .swal2-close {
        color: white !important;
        background: rgba(255,255,255,0.25) !important;
        border-radius: 8px !important;
        width: 36px !important;
        height: 36px !important;
        font-size: 1.5rem !important;
        transition: all 0.2s !important;
        top: 1rem !important;
        right: 1rem !important;
        box-shadow: 0 2px 8px rgba(0,0,0,0.2) !important;
        z-index: 9999 !important;
    }
    .swal-venda-opcoes .swal2-close:hover {
        background: rgba(255,255,255,0.4) !important;
        transform: scale(1.1) !important;
    }
    .swal-venda-opcoes .swal2-close:focus {
        box-shadow: 0 0 0 3px rgba(255,255,255,0.3) !important;
    }
    .opcoes-grid {
        padding: 1rem !important;
    }
`;
    if (!document.getElementById('swal-venda-custom-style')) {
        style.id = 'swal-venda-custom-style';
        document.head.appendChild(style);
    }

    async function converterDavParaVenda(vendaId, numeroVenda) {
        Swal.close();

        const confirmacao = await Swal.fire({
            icon: 'question',
            title: 'Converter em Venda?',
            html: `
            <div class="text-start">
                <p class="mb-2">Você está prestes a converter a DAV <strong>${numeroVenda}</strong> em uma Venda.</p>
                <ul class="mb-0 small text-muted">
                    <li>O módulo de origem será alterado para <strong>Venda</strong>.</li>
                    <li>O status será atualizado para <strong>Pendente</strong>.</li>
                </ul>
            </div>
        `,
            showCancelButton: true,
            confirmButtonText: '<i class="bi bi-check2-circle me-2"></i> Converter',
            cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Cancelar',
            confirmButtonColor: '#198754',
            cancelButtonColor: '#6c757d'
        });

        if (!confirmacao.isConfirmed) {
            return;
        }

        const basePath = (currentRouteBase || '/pre-vendas').replace(/\/$/, '');
        const url = appUrl(`${basePath}/converter`);

        Swal.fire({
            title: 'Convertendo...',
            html: 'Aguarde enquanto convertemos a DAV.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        try {
            const response = await fetch(url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                },
                body: new URLSearchParams({ id: vendaId })
            });

            const result = await response.json();
            Swal.close();

            if (result?.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Convertido!',
                    text: result.message || 'DAV convertida com sucesso.',
                    confirmButtonText: 'OK'
                }).then(() => {
                    if (result.data?.redirect) {
                        window.location.href = appUrl(result.data.redirect);
                    } else {
                        window.location.reload();
                    }
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: result?.message || 'Não foi possível converter a DAV.',
                    confirmButtonText: 'OK'
                });
            }
        } catch (error) {
            console.error('Erro ao converter DAV:', error);
            Swal.close();
            Swal.fire({
                icon: 'error',
                title: 'Erro inesperado',
                text: 'Ocorreu um erro ao converter a DAV. Tente novamente.',
                confirmButtonText: 'OK'
            });
        }
    }

    async function enviarPorEmail(vendaId, numeroVenda, clienteNome) {
        // Fechar modal anterior
        Swal.close();

        const singularLabel = moduleSingular || 'Venda';
        const singularLower = moduleSingularLower || 'venda';

        const { value: formValues } = await Swal.fire({
            title: `<i class="bi bi-envelope text-info"></i> Enviar ${singularLabel} por e-mail`,
            html: `
            <div class="text-start">
                <div class="alert alert-info mb-3">
                    <h6 class="mb-2"><strong>${singularLabel}: ${numeroVenda}</strong></h6>
                    <p class="mb-0 small">Cliente: ${clienteNome || 'Não informado'}</p>
                </div>

                <div class="mb-3">
                    <label class="form-label">Email do Destinatário *</label>
                    <input type="email" class="form-control" id="email_destinatario"
                           placeholder="exemplo@email.com" required>
                    <small class="text-muted">Insira o email que receberá o pedido</small>
                </div>

                <div class="mb-3">
                    <label class="form-label">Assunto</label>
                    <input type="text" class="form-control" id="assunto_email"
                           value="${singularLabel} ${numeroVenda} - ${clienteNome || ''}">
                </div>

                <div class="mb-3">
                    <label class="form-label">Mensagem (Opcional)</label>
                    <textarea class="form-control" id="mensagem_email" rows="4"
                              placeholder="Digite uma mensagem personalizada..."></textarea>
                </div>

                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="anexar_pdf" checked>
                    <label class="form-check-label" for="anexar_pdf">
                        Anexar PDF do pedido
                    </label>
                </div>
            </div>
        `,
            width: '600px',
            showCancelButton: true,
            confirmButtonText: '<i class="bi bi-send me-2"></i>Enviar Email',
            cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Cancelar',
            confirmButtonColor: '#0dcaf0',
            cancelButtonColor: '#6c757d',
            preConfirm: () => {
                const email = document.getElementById('email_destinatario').value.trim();
                const assunto = document.getElementById('assunto_email').value.trim();
                const mensagem = document.getElementById('mensagem_email').value.trim();
                const anexarPdf = document.getElementById('anexar_pdf').checked;

                if (!email) {
                    Swal.showValidationMessage('O email do destinatário é obrigatório');
                    return false;
                }

                // Validação básica de email
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(email)) {
                    Swal.showValidationMessage('Digite um email válido');
                    return false;
                }

                return {
                    email: email,
                    assunto: assunto || `${singularLabel} ${numeroVenda}`,
                    mensagem: mensagem,
                    anexar_pdf: anexarPdf
                };
            }
        });

        if (formValues) {
            // Mostrar loading
            Swal.fire({
                title: 'Enviando Email...',
                html: `Aguarde enquanto enviamos a ${singularLower} por e-mail.`,
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            // Enviar para o backend
            $.ajax({
                url: appUrl('/vendas/enviar-email'),
                type: 'POST',
                data: {
                    venda_id: vendaId,
                    email: formValues.email,
                    assunto: formValues.assunto,
                    mensagem: formValues.mensagem,
                    anexar_pdf: formValues.anexar_pdf ? 1 : 0
                },
                dataType: 'json',
                success: function (response) {
                    Swal.close();
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Email Enviado!',
                            text: response.message || 'Email enviado com sucesso',
                            confirmButtonText: 'OK'
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro ao Enviar',
                            text: response.message || 'Não foi possível enviar o email',
                            confirmButtonText: 'OK'
                        });
                    }
                },
                error: function (xhr) {
                    Swal.close();
                    const response = xhr.responseJSON;
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response?.message || 'Erro ao enviar email. Tente novamente.',
                        confirmButtonText: 'OK'
                    });
                }
            });
        }
    }

    function duplicarVenda(id, numero) {
        const singularLabel = moduleSingular || 'Venda';
        Swal.fire({
            title: 'Duplicar ' + singularLabel,
            html: `Deseja duplicar a ${singularLabel.toLowerCase()} <strong>${numero}</strong>?<br><br>
                   <small class="text-muted">Uma nova ${singularLabel.toLowerCase()} será criada com um novo número de pedido, mantendo todos os dados da original.</small>`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#0dcaf0',
            cancelButtonColor: '#6c757d',
            confirmButtonText: '<i class="bi bi-files me-2"></i>Sim, duplicar',
            cancelButtonText: 'Cancelar',
            showLoaderOnConfirm: true,
            preConfirm: () => {
                return $.ajax({
                    url: appUrl('/vendas/duplicar'),
                    method: 'POST',
                    data: {
                        id: id
                    },
                    dataType: 'json'
                }).then(response => {
                    if (!response.success) {
                        throw new Error(response.message || 'Erro ao duplicar venda');
                    }
                    return response;
                }).catch(error => {
                    Swal.showValidationMessage(error.message || 'Erro ao duplicar venda');
                });
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    icon: 'success',
                    title: 'Sucesso!',
                    text: result.value.message || `${singularLabel} duplicada com sucesso`,
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    // Redirecionar para a nova venda editável
                    if (result.value.id) {
                        window.location.href = buildModuleUrl(`/editar?id=${result.value.id}`);
                    } else {
                        location.reload();
                    }
                });
            }
        });
    }

    async function deletarVenda(id) {
        const singularLower = moduleSingularLower || 'venda';
        const confirmed = await confirmDelete(`Tem certeza que deseja excluir esta ${singularLower}?`);
        if (confirmed) {
            $.ajax({
                url: appUrl('/vendas/deletar'),
                type: 'POST',
                data: { id: id },
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        Toast.success(response.message);
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        Toast.error(response.message);
                    }
                }
            });
        }
    }

    async function previsualizarNFe(vendaId, numeroVenda, cliente, total, configs) {
        // Buscar dados completos da venda
        Swal.fire({
            title: 'Gerando pré-visualização...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        try {
            const response = await $.ajax({
                url: appUrl(`/vendas/buscar-itens?id=${vendaId}`),
                type: 'GET',
                dataType: 'json'
            });

            let itensDetalhados = '';
            let totalIcms = 0, totalPis = 0, totalCofins = 0, totalIpi = 0;

            if (response.success && response.data && response.data.itens) {
                itensDetalhados = response.data.itens.map((item, idx) => {
                    totalIcms += parseFloat(item.valor_icms || 0);
                    totalPis += parseFloat(item.valor_pis || 0);
                    totalCofins += parseFloat(item.valor_cofins || 0);
                    totalIpi += parseFloat(item.valor_ipi || 0);

                    return `
                    <tr>
                        <td>${idx + 1}</td>
                        <td>${item.product_name}</td>
                        <td class="text-center">${item.quantity}</td>
                        <td class="text-end">R$ ${parseFloat(item.unit_price).toFixed(2).replace('.', ',')}</td>
                        <td class="text-end">R$ ${parseFloat(item.total_price).toFixed(2).replace('.', ',')}</td>
                    </tr>
                `;
                }).join('');
            }

            const presencaTexto = {
                '0': 'Não se aplica',
                '1': 'Operação presencial',
                '2': 'Internet',
                '3': 'Teleatendimento',
                '4': 'Entrega a domicílio',
                '5': 'Fora do estabelecimento',
                '9': 'Outros'
            };

            Swal.fire({
                title: '<i class="bi bi-eye text-primary"></i> Pré-visualização da NF-e',
                html: `
                <div class="text-start">
                    <!-- Dados da Operação -->
                    <div class="card mb-3">
                        <div class="card-header bg-primary text-white py-2">
                            <strong>Dados da Operação</strong>
                        </div>
                        <div class="card-body p-2">
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <td width="40%"><strong>Número da Venda:</strong></td>
                                    <td>${numeroVenda}</td>
                                </tr>
                                <tr>
                                    <td><strong>Cliente:</strong></td>
                                    <td>${cliente}</td>
                                </tr>
                                <tr>
                                    <td><strong>Presença do Comprador:</strong></td>
                                    <td>${presencaTexto[configs.presenca_comprador] || configs.presenca_comprador}</td>
                                </tr>
                                <tr>
                                    <td><strong>Intermediador:</strong></td>
                                    <td>${configs.intermediador === '0' ? 'Não' : 'Sim'}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- Itens -->
                    <div class="card mb-3">
                        <div class="card-header bg-info text-white py-2">
                            <strong>Itens da NF-e</strong>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive" style="max-height: 250px; overflow-y: auto;">
                                <table class="table table-sm table-bordered mb-0">
                                    <thead class="table-light sticky-top">
                                        <tr>
                                            <th width="30">#</th>
                                            <th>Descrição</th>
                                            <th class="text-center" width="60">Qtd</th>
                                            <th class="text-end" width="100">Vlr. Unit.</th>
                                            <th class="text-end" width="100">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        ${itensDetalhados || '<tr><td colspan="5" class="text-center text-muted">Nenhum item</td></tr>'}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Totais -->
                    <div class="card mb-3">
                        <div class="card-header bg-success text-white py-2">
                            <strong>Valores e Impostos</strong>
                        </div>
                        <div class="card-body p-2">
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <td width="60%"><strong>Valor Total dos Produtos:</strong></td>
                                    <td class="text-end"><strong>R$ ${parseFloat(total).toFixed(2).replace('.', ',')}</strong></td>
                                </tr>
                                ${configs.exibir_pis_cofins_danfe ? `
                                <tr class="text-success">
                                    <td>ICMS Total:</td>
                                    <td class="text-end">R$ ${totalIcms.toFixed(2).replace('.', ',')}</td>
                                </tr>
                                <tr class="text-success">
                                    <td>PIS Total:</td>
                                    <td class="text-end">R$ ${totalPis.toFixed(2).replace('.', ',')}</td>
                                </tr>
                                <tr class="text-success">
                                    <td>COFINS Total:</td>
                                    <td class="text-end">R$ ${totalCofins.toFixed(2).replace('.', ',')}</td>
                                </tr>
                                ` : ''}
                                <tr>
                                    <td>IPI Total:</td>
                                    <td class="text-end">R$ ${totalIpi.toFixed(2).replace('.', ',')}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- Opções Configuradas -->
                    <div class="card">
                        <div class="card-header bg-secondary text-white py-2">
                            <strong>Opções Configuradas</strong>
                        </div>
                        <div class="card-body p-2">
                            <div class="row">
                                <div class="col-6">
                                    ${configs.base_pis_cofins_icms ? '✓' : '✗'} Base PIS/COFINS c/ ICMS
                                </div>
                                <div class="col-6">
                                    ${configs.exibir_pis_cofins_danfe ? '✓' : '✗'} Exibir PIS/COFINS DANFE
                                </div>
                                <div class="col-6">
                                    ${configs.subtrair_icms_desonerado ? '✓' : '✗'} Subtrair ICMS Desonerado
                                </div>
                                <div class="col-6">
                                    ${configs.exibir_financeiro ? '✓' : '✗'} Exibir Financeiro
                                </div>
                                <div class="col-12 mt-2">
                                    ${configs.enviar_por_email ? '<span class="text-success"><i class="bi bi-envelope me-1"></i>Enviar por E-mail</span>' : '<span class="text-muted">Não enviar por e-mail</span>'}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `,
                width: '800px',
                showConfirmButton: true,
                showCancelButton: true,
                confirmButtonText: '<i class="bi bi-arrow-left me-2"></i>Voltar',
                cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Fechar',
                confirmButtonColor: '#6c757d',
                cancelButtonColor: '#dc3545'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Voltar para o modal de configuração
                    emitirNFe(vendaId, numeroVenda, cliente, total);
                }
            });

        } catch (error) {
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Não foi possível carregar a pré-visualização.',
                confirmButtonText: 'OK'
            });
        }
    }

    async function emitirNFe(vendaId, numeroVenda, cliente, total) {
        // Buscar itens da venda primeiro
        Swal.fire({
            title: 'Carregando...',
            text: 'Buscando dados da venda',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        let itensHtml = '<p class="text-muted">Nenhum item encontrado</p>';

        try {
            console.log('Buscando itens da venda #' + vendaId);

            const response = await $.ajax({
                url: appUrl(`/vendas/buscar-itens?id=${vendaId}`),
                type: 'GET',
                dataType: 'json'
            });

            console.log('Resposta completa:', response);
            console.log('response.success:', response.success);
            console.log('response.data:', response.data);
            console.log('response.data.itens:', response.data?.itens);

            if (response.success && response.data && response.data.itens && response.data.itens.length > 0) {
                console.log('✓ Itens encontrados! Total:', response.data.itens.length);
                itensHtml = `
                <div class="table-responsive" style="max-height: 200px; overflow-y: auto;">
                    <table class="table table-sm table-bordered mb-0">
                        <thead class="table-light sticky-top">
                            <tr>
                                <th>Produto</th>
                                <th class="text-center">Qtd</th>
                                <th class="text-end">Valor Unit.</th>
                                <th class="text-end">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${response.data.itens.map(item => `
                                <tr>
                                    <td>${item.product_name}</td>
                                    <td class="text-center">${item.quantity}</td>
                                    <td class="text-end">R$ ${parseFloat(item.unit_price).toFixed(2).replace('.', ',')}</td>
                                    <td class="text-end">R$ ${parseFloat(item.total_price).toFixed(2).replace('.', ',')}</td>
                                </tr>
                            `).join('')}
                        </tbody>
                    </table>
                </div>
            `;
            } else {
                console.log('✗ Nenhum item encontrado ou resposta inválida');
            }
        } catch (error) {
            console.error('❌ ERRO ao buscar itens:', error);
            console.error('Status:', error.status);
            console.error('ResponseText:', error.responseText);
            itensHtml = '<p class="text-danger">Erro ao carregar itens da venda</p>';
        }

        Swal.close();

        const { value: formValues } = await Swal.fire({
            title: '<i class="bi bi-file-earmark-text text-success"></i> Emitir NF-e',
            html: `
            <div class="text-start">
                <!-- Resumo da Venda -->
                <div class="alert alert-info mb-3">
                    <h6 class="mb-2"><strong>Resumo da Venda</strong></h6>
                    <div class="row">
                        <div class="col-6"><strong>Número:</strong> ${numeroVenda}</div>
                        <div class="col-6"><strong>Cliente:</strong> ${cliente}</div>
                        <div class="col-12 mt-2"><strong>Total:</strong> R$ ${parseFloat(total).toFixed(2).replace('.', ',')}</div>
                    </div>
                </div>

                <!-- Itens da Venda -->
                <div class="mb-3">
                    <h6 class="mb-2"><i class="bi bi-box-seam me-2"></i><strong>Itens da Venda</strong></h6>
                    ${itensHtml}
                </div>

                <!-- Configurações da NF-e -->
                <h6 class="mb-3 text-primary"><i class="bi bi-gear me-2"></i>Configurações da NF-e</h6>

                <div class="row">
                    <!-- Coluna Esquerda -->
                    <div class="col-md-6">
                        <!-- Presença do Comprador -->
                        <div class="mb-3">
                            <label class="form-label small text-muted mb-1">Presença do Comprador</label>
                            <select class="form-select form-select-sm" id="presenca_comprador">
                                <option value="0">0 - Não se aplica</option>
                                <option value="1" selected>1 - Operação presencial</option>
                                <option value="2">2 - Internet</option>
                                <option value="3">3 - Teleatendimento</option>
                                <option value="4">4 - Entrega a domicílio</option>
                                <option value="5">5 - Fora do estabelecimento</option>
                                <option value="9">9 - Outros</option>
                            </select>
                        </div>

                        <!-- Intermediador -->
                        <div class="mb-3">
                            <label class="form-label small text-muted mb-1">Intermediador</label>
                            <select class="form-select form-select-sm" id="intermediador">
                                <option value="0" selected>0 - Sem intermediador</option>
                                <option value="1">1 - Com intermediador</option>
                            </select>
                        </div>
                    </div>

                    <!-- Coluna Direita - Checkboxes Modernos -->
                    <div class="col-md-6">
                        <label class="form-label small text-muted mb-2">Opções da NF-e</label>

                        <!-- Switch Base PIS/COFINS -->
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" role="switch" id="base_pis_cofins_icms" checked>
                            <label class="form-check-label" for="base_pis_cofins_icms">
                                Base PIS/COFINS c/ ICMS
                            </label>
                        </div>

                        <!-- Switch Exibir PIS/COFINS -->
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" role="switch" id="exibir_pis_cofins_danfe" checked>
                            <label class="form-check-label" for="exibir_pis_cofins_danfe">
                                Exibir PIS/COFINS DANFE
                            </label>
                        </div>

                        <!-- Switch Subtrair ICMS -->
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" role="switch" id="subtrair_icms_desonerado">
                            <label class="form-check-label" for="subtrair_icms_desonerado">
                                Subtrair ICMS Desonerado
                            </label>
                        </div>

                        <!-- Switch Exibir Financeiro -->
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" role="switch" id="exibir_financeiro" checked>
                            <label class="form-check-label" for="exibir_financeiro">
                                Exibir Financeiro DANFE
                            </label>
                        </div>

                        <!-- Switch Enviar por Email - NOVO -->
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" role="switch" id="enviar_por_email" checked>
                            <label class="form-check-label" for="enviar_por_email">
                                <i class="bi bi-envelope me-1"></i>Enviar por E-mail
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        `,
            width: '700px',
            showCancelButton: true,
            showDenyButton: true,
            confirmButtonText: '<i class="bi bi-check-circle me-2"></i>Emitir NF-e',
            denyButtonText: '<i class="bi bi-eye me-2"></i>Pré-visualizar',
            cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Cancelar',
            confirmButtonColor: '#198754',
            denyButtonColor: '#0d6efd',
            cancelButtonColor: '#6c757d',
            preConfirm: () => {
                // Validação antes de emitir
                const presencaComprador = document.getElementById('presenca_comprador').value;
                const intermediador = document.getElementById('intermediador').value;

                if (!presencaComprador) {
                    Swal.showValidationMessage('Selecione a presença do comprador');
                    return false;
                }

                return {
                    presenca_comprador: presencaComprador,
                    intermediador: intermediador,
                    base_pis_cofins_icms: document.getElementById('base_pis_cofins_icms').checked,
                    exibir_pis_cofins_danfe: document.getElementById('exibir_pis_cofins_danfe').checked,
                    subtrair_icms_desonerado: document.getElementById('subtrair_icms_desonerado').checked,
                    exibir_financeiro: document.getElementById('exibir_financeiro').checked,
                    enviar_por_email: document.getElementById('enviar_por_email').checked
                }
            },
            preDeny: () => {
                // Capturar dados para pré-visualização
                const configs = {
                    presenca_comprador: document.getElementById('presenca_comprador').value,
                    intermediador: document.getElementById('intermediador').value,
                    base_pis_cofins_icms: document.getElementById('base_pis_cofins_icms').checked,
                    exibir_pis_cofins_danfe: document.getElementById('exibir_pis_cofins_danfe').checked,
                    subtrair_icms_desonerado: document.getElementById('subtrair_icms_desonerado').checked,
                    exibir_financeiro: document.getElementById('exibir_financeiro').checked,
                    enviar_por_email: document.getElementById('enviar_por_email').checked
                };

                // Chamar pré-visualização e prevenir o fechamento do modal
                previsualizarNFe(vendaId, numeroVenda, cliente, total, configs);
                return false; // Previne fechamento do modal
            }
        });

        if (formValues) {
            // Mostra loading
            Swal.fire({
                title: 'Emitindo NF-e...',
                html: 'Aguarde enquanto geramos a nota fiscal eletrônica.',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            // Envia para o backend
            $.ajax({
                url: appUrl('/vendas/emitir-nfe'),
                type: 'POST',
                data: {
                    venda_id: vendaId,
                    ...formValues
                },
                dataType: 'json',
                success: function (response) {
                    Swal.close();
                    if (response.success) {
                        const data = response.data || {};
                        const numeroNfe = data.numero_nfe || response.numero_nfe || 'N/A';
                        const chaveNfe = data.chave_nfe || response.chave_nfe || 'N/A';
                        const protocolo = data.protocolo || data.protocolo_nfe || response.protocolo || 'N/A';
                        const pdfPath = data.pdf_path || '';

                        let htmlContent = `
                        <div class="text-start">
                            <p><strong>Número:</strong> ${numeroNfe}</p>
                            <p><strong>Chave de Acesso:</strong> <small>${chaveNfe}</small></p>
                            <p><strong>Protocolo:</strong> ${protocolo}</p>
                    `;

                        htmlContent += `</div>`;

                        Swal.fire({
                            icon: 'success',
                            title: '✅ NF-e Emitida com Sucesso!',
                            html: htmlContent,
                            confirmButtonText: 'OK',
                            width: '600px'
                        }).then(() => {
                            // CORREÇÃO: Abrir PDF automaticamente ao invés de apenas mostrar botão
                            if (pdfPath) {
                                window.open(pdfPath, '_blank');
                            }
                            location.reload();
                        });

                        // CORREÇÃO: Abrir PDF imediatamente após exibir SweetAlert
                        // Não aguardar confirmação do usuário
                        if (pdfPath) {
                            setTimeout(() => {
                                window.open(pdfPath, '_blank');
                            }, 500);
                        }
                    } else {
                        // Extrair detalhes do erro
                        const errorMessage = response.message || 'Erro desconhecido';
                        const cStat = response.data?.cStat || '';

                        // Montar HTML com detalhes
                        let errorHtml = `
                        <div class="text-start">
                            <p><strong>Erro:</strong> ${errorMessage}</p>
                    `;

                        if (cStat) {
                            errorHtml += `<p class="text-danger"><strong>Código SEFAZ:</strong> ${cStat}</p>`;
                        }

                        // Verificar se tem detalhes específicos
                        if (response.data && response.data.motivo) {
                            errorHtml += `<p class="text-danger mt-2"><strong>Motivo da Rejeição:</strong><br>${response.data.motivo}</p>`;
                        }

                        errorHtml += `</div>`;

                        Swal.fire({
                            icon: 'error',
                            title: '❌ Erro ao Emitir NF-e',
                            html: errorHtml,
                            confirmButtonText: 'Entendi',
                            width: '600px'
                        });
                    }
                },
                error: function (xhr, status, error) {
                    Swal.close();

                    let errorMessage = 'Não foi possível conectar ao servidor.';
                    let errorDetails = '';

                    // Tentar extrair mensagem do erro
                    if (xhr.responseJSON) {
                        const json = xhr.responseJSON;
                        errorMessage = json.message || errorMessage;
                        errorDetails = json.errors ? JSON.stringify(json.errors) : '';
                    }

                    Swal.fire({
                        icon: 'error',
                        title: '❌ Erro de Conexão',
                        html: `
                        <div class="text-start">
                            <p><strong>${errorMessage}</strong></p>
                            ${errorDetails ? `<p class="text-muted small mt-2"><code>${errorDetails}</code></p>` : ''}
                        </div>
                    `,
                        confirmButtonText: 'OK',
                        width: '600px'
                    });
                }
            });
        }
    }

    async function emitirNFSe(vendaId, numeroVenda, cliente) {
        const { value: formValues } = await Swal.fire({
            title: '<i class="bi bi-building"></i> Emitir NFS-e (Recife)',
            html: `
            <div class="text-start">
                <div class="mb-3">
                    <label class="form-label">Código do Serviço (Lista Municipal)</label>
                    <input type="text" id="nfse-codigo-servico" class="form-control" value="" placeholder="Ex: 0107">
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Código de Tributação no Município</label>
                        <input type="text" id="nfse-codigo-tributacao" class="form-control" value="" placeholder="Ex: 0107">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Alíquota ISS (%)</label>
                        <input type="number" id="nfse-aliquota-iss" class="form-control" value="" min="0" step="0.01">
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label">Descrição do Serviço</label>
                    <textarea id="nfse-descricao" class="form-control" rows="2">Serviços prestados conforme venda ${numeroVenda}</textarea>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Natureza da Operação</label>
                        <select id="nfse-natureza" class="form-select">
                            <option value="1">01 - Tributação no município</option>
                            <option value="2">02 - Tributação fora do município</option>
                            <option value="3">03 - Isenção</option>
                            <option value="4">04 - Imune</option>
                            <option value="5">05 - Suspensa por decisão judicial</option>
                            <option value="6">06 - Suspensa por procedimento administrativo</option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Regime Especial</label>
                        <select id="nfse-regime" class="form-select">
                            <option value="">(Não informado)</option>
                            <option value="1">01 - Microempresa Municipal</option>
                            <option value="2">02 - Estimativa</option>
                            <option value="3">03 - Sociedade de Profissionais</option>
                            <option value="4">04 - Cooperativa</option>
                            <option value="5">05 - MEI</option>
                            <option value="6">06 - ME/EPP</option>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Optante Simples Nacional</label>
                        <select id="nfse-optante" class="form-select">
                            <option value="1">Sim</option>
                            <option value="2" selected>Não</option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">ISS Retido pelo Tomador?</label>
                        <select id="nfse-iss-retido" class="form-select">
                            <option value="2" selected>Não</option>
                            <option value="1">Sim</option>
                        </select>
                    </div>
                </div>
            </div>
        `,
            showCancelButton: true,
            confirmButtonText: 'Emitir NFS-e',
            cancelButtonText: 'Cancelar',
            width: '700px',
            focusConfirm: false,
            customClass: {
                popup: 'swal2-dark'
            },
            didOpen: () => {
                const defaults = window.nfseDefaults || {};
                const codigoServicoInput = document.getElementById('nfse-codigo-servico');
                const codigoTributacaoInput = document.getElementById('nfse-codigo-tributacao');
                const aliquotaInput = document.getElementById('nfse-aliquota-iss');
                const naturezaSelect = document.getElementById('nfse-natureza');
                const regimeSelect = document.getElementById('nfse-regime');
                const optanteSelect = document.getElementById('nfse-optante');
                const issRetidoSelect = document.getElementById('nfse-iss-retido');
                const descricaoTextarea = document.getElementById('nfse-descricao');

                if (codigoServicoInput) {
                    const codigoServicoDefault = defaults.codigo_servico || codigoServicoInput.value || '0107';
                    codigoServicoInput.value = codigoServicoDefault;
                    if (codigoTributacaoInput) {
                        codigoTributacaoInput.value = defaults.codigo_tributacao || codigoTributacaoInput.value || codigoServicoDefault;
                    }
                }
                if (!codigoServicoInput && codigoTributacaoInput) {
                    codigoTributacaoInput.value = defaults.codigo_tributacao || codigoTributacaoInput.value || '0107';
                }
                if (aliquotaInput) {
                    aliquotaInput.value = (defaults.aliquota_iss || aliquotaInput.value || '2');
                }
                if (naturezaSelect && defaults.natureza_operacao) {
                    naturezaSelect.value = defaults.natureza_operacao;
                }
                if (regimeSelect && defaults.regime_tributacao !== undefined && defaults.regime_tributacao !== null) {
                    regimeSelect.value = defaults.regime_tributacao;
                }
                if (optanteSelect && defaults.optante_simples) {
                    optanteSelect.value = defaults.optante_simples;
                }
                if (issRetidoSelect && defaults.iss_retido_padrao) {
                    issRetidoSelect.value = defaults.iss_retido_padrao;
                }
                if (descricaoTextarea && !descricaoTextarea.value) {
                    descricaoTextarea.value = `Serviços prestados conforme venda ${numeroVenda}`;
                }
            },
            preConfirm: () => {
                const defaults = window.nfseDefaults || {};
                const codigoServico = document.getElementById('nfse-codigo-servico').value.trim() || defaults.codigo_servico || '';
                if (!codigoServico) {
                    Swal.showValidationMessage('Informe o código do serviço.');
                    return false;
                }

                const codigoTributacao = document.getElementById('nfse-codigo-tributacao').value.trim() || defaults.codigo_tributacao || codigoServico;
                const aliquotaField = document.getElementById('nfse-aliquota-iss').value;
                const aliquotaIss = aliquotaField !== '' ? parseFloat(aliquotaField) : parseFloat(defaults.aliquota_iss || '0');
                if (!aliquotaIss || aliquotaIss <= 0) {
                    Swal.showValidationMessage('Informe a alíquota de ISS (percentual maior que zero).');
                    return false;
                }

                const descricaoServico = document.getElementById('nfse-descricao').value.trim() || `Serviços prestados conforme venda ${numeroVenda}`;
                const naturezaOperacao = document.getElementById('nfse-natureza').value || defaults.natureza_operacao || '1';
                const regimeTributacao = document.getElementById('nfse-regime').value || defaults.regime_tributacao || '';
                const optanteSimples = document.getElementById('nfse-optante').value || defaults.optante_simples || '2';
                const issRetido = document.getElementById('nfse-iss-retido').value || defaults.iss_retido_padrao || '2';

                return {
                    codigoServico,
                    codigoTributacao,
                    aliquotaIss,
                    descricaoServico,
                    naturezaOperacao,
                    regimeTributacao,
                    optanteSimples,
                    issRetido
                };
            }
        });

        if (!formValues) {
            return;
        }

        Swal.fire({
            title: 'Processando...',
            html: 'Enviando dados para geração da NFS-e. Aguarde...',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        try {
            const response = await fetch(appUrl('/vendas/emitir-nfse'), {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    venda_id: vendaId,
                    codigo_servico: formValues.codigoServico,
                    codigo_tributacao: formValues.codigoTributacao,
                    aliquota_iss: formValues.aliquotaIss,
                    descricao_servico: formValues.descricaoServico,
                    natureza_operacao: formValues.naturezaOperacao,
                    regime_tributacao: formValues.regimeTributacao,
                    optante_simples: formValues.optanteSimples,
                    iss_retido: formValues.issRetido
                })
            });

            const data = await response.json();

            if (!response.ok || !data.success) {
                // Verificar se é o erro de NFS-e já gerada
                if (data.message && data.message.includes('já possui NFS-e gerada')) {
                    // Oferecer opção de reimpressão
                    const result = await Swal.fire({
                        icon: 'info',
                        title: 'NFS-e já gerada',
                        text: data.message,
                        showCancelButton: true,
                        confirmButtonText: '<i class="bi bi-printer me-2"></i> Reimprimir NFS-e',
                        cancelButtonText: 'Cancelar',
                        confirmButtonColor: '#0d6efd',
                        cancelButtonColor: '#6c757d'
                    });

                    if (result.isConfirmed) {
                        reimprimirNFSe(vendaId);
                    }
                    return;
                }
                throw new Error(data.message || 'Não foi possível gerar a NFS-e.');
            }

            Swal.fire({
                icon: 'success',
                title: 'NFS-e gerada!',
                text: data.message || 'XML gerado e salvo. Prossiga com o envio para a Prefeitura de Recife.',
                confirmButtonText: 'Ok'
            });

            listarVendas();
        } catch (error) {
            console.error('Erro ao gerar NFS-e:', error);
            Swal.fire({
                icon: 'error',
                title: 'Falha ao gerar NFS-e',
                text: error.message || 'Erro inesperado ao gerar NFS-e.',
                confirmButtonText: 'Entendi'
            });
        }
    }

    async function reimprimirNFSe(vendaId) {
        Swal.fire({
            title: 'Buscando NFS-e...',
            text: 'Aguarde enquanto carregamos a NFS-e',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        try {
            const response = await fetch(appUrl('/vendas/reimprimir-nfse?id=' + vendaId), {
                method: 'GET',
                headers: {
                    'Content-Type': 'application/json'
                }
            });

            const data = await response.json();

            Swal.close();

            if (!response.ok || !data.success) {
                throw new Error(data.message || 'Não foi possível encontrar a NFS-e.');
            }

            // Mostrar opções de visualização
            const numeroNfse = data.data?.numero_nfse || 'N/A';
            const codigoVerificacao = data.data?.codigo_verificacao || 'N/A';
            const pdfPath = data.data?.pdf_path || data.data?.pdf_path_alternativo;
            const xmlPath = data.data?.xml_path;

            // Sempre produção (emissão real)
            const ambienteBadge = '<span class="badge bg-success">PRODUÇÃO</span>';

            let htmlContent = `
            <div class="text-start">
                <p><strong>Número NFS-e:</strong> ${numeroNfse}</p>
                <p><strong>Código de Verificação:</strong> <small>${codigoVerificacao}</small></p>
                <p><strong>Ambiente:</strong> ${ambienteBadge} <small class="text-success">(Emissão Real)</small></p>
        `;

            if (data.data?.data_emissao) {
                htmlContent += `<p><strong>Data de Emissão:</strong> ${new Date(data.data.data_emissao).toLocaleString('pt-BR')}</p>`;
            }

            htmlContent += `</div>`;

            const buttons = {
                showCancelButton: true,
                cancelButtonText: 'Fechar'
            };

            if (pdfPath) {
                buttons.showDenyButton = true;
                buttons.denyButtonText = '<i class="bi bi-file-earmark-pdf me-2"></i> Ver PDF';
                buttons.confirmButtonText = '<i class="bi bi-download me-2"></i> Baixar PDF';
            } else if (xmlPath) {
                buttons.showDenyButton = true;
                buttons.denyButtonText = '<i class="bi bi-file-earmark-code me-2"></i> Ver XML';
                buttons.confirmButtonText = '<i class="bi bi-download me-2"></i> Baixar XML';
            } else {
                buttons.confirmButtonText = 'OK';
            }

            const result = await Swal.fire({
                icon: 'success',
                title: 'NFS-e encontrada!',
                html: htmlContent,
                ...buttons,
                confirmButtonColor: '#0d6efd',
                denyButtonColor: '#6c757d',
                cancelButtonColor: '#6c757d',
                customClass: {
                    confirmButton: 'btn btn-primary me-2',
                    denyButton: 'btn btn-secondary me-2',
                    cancelButton: 'btn btn-outline-secondary'
                },
                buttonsStyling: false,
                width: '600px'
            });

            if (result.isConfirmed) {
                if (pdfPath) {
                    // Abrir PDF em nova aba para download
                    window.open(pdfPath, '_blank');
                } else if (xmlPath) {
                    // Abrir XML em nova aba para download
                    window.open(xmlPath, '_blank');
                }
            } else if (result.isDenied) {
                if (pdfPath) {
                    // Abrir PDF em nova aba para visualização
                    window.open(pdfPath, '_blank');
                } else if (xmlPath) {
                    // Abrir XML em nova aba para visualização
                    window.open(xmlPath, '_blank');
                }
            }
        } catch (error) {
            console.error('Erro ao reimprimir NFS-e:', error);
            Swal.fire({
                icon: 'error',
                title: 'Falha ao reimprimir NFS-e',
                text: error.message || 'Erro inesperado ao buscar NFS-e.',
                confirmButtonText: 'Entendi'
            });
        }
    }

    function emitirNFCE(vendaId, numeroVenda, cliente) {
        Swal.fire({
            title: '<i class="bi bi-phone"></i> NFC-e (Consumidor)',
            html: `
            <div class="text-start">
                <p class="text-muted">Em breve vamos emitir NFC-e direto pelo PDV/Vendas. Para preparar:</p>
                <ul class="ps-3 mb-3">
                    <li>Configure série, CSC e ID Token da NFC-e nos parâmetros da empresa;</li>
                    <li>Garanta que a venda tenha meios de pagamento compatíveis com varejo;</li>
                    <li>Separe uma impressora térmica compatível (DANFCE).</li>
                </ul>
                <p class="mb-0">
                    Venda: <strong>${numeroVenda}</strong><br>
                    Cliente: <strong>${cliente || 'Consumidor'}</strong>
                </p>
            </div>
        `,
            icon: 'info',
            confirmButtonText: 'Ok'
        });
    }

    function visualizarXmlNFe(xmlPath) {
        if (!xmlPath) {
            Swal.fire({
                icon: 'warning',
                title: 'XML não disponível',
                text: 'Nenhum XML foi localizado para esta NF-e.'
            });
            return;
        }

        let url = xmlPath;
        if (xmlPath.startsWith('/pontti_nfe/')) {
            url = xmlPath.replace('/pontti_nfe/', '/src/Integrations/NFe/');
        }

        window.open(url, '_blank');
    }

    function enviarEmailNFe(vendaId, numeroVenda, cliente, chaveNfe) {
        Swal.fire({
            title: '<i class="bi bi-envelope-paper"></i> Enviar NF-e por e-mail',
            html: `
            <div class="text-start">
                <p class="text-muted">Vamos disponibilizar o envio automático do XML/PDF da NF-e para o cliente.</p>
                <ul class="ps-3 mb-3">
                    <li>Confirme o e-mail do cliente na ficha cadastral;</li>
                    <li>Informe, quando solicitado, se deseja anexar XML, DANFE ou ambos;</li>
                    <li>NF-e vinculada: <strong>${numeroVenda}</strong> (${chaveNfe || 'chave não informada'}).</li>
                </ul>
                <p class="mb-0">Cliente: <strong>${cliente || 'Consumidor Final'}</strong></p>
            </div>
        `,
            icon: 'info',
            confirmButtonText: 'Ok'
        });
    }

    function enviarEmailNFCE(vendaId, numeroVenda, cliente) {
        Swal.fire({
            title: '<i class="bi bi-envelope-open"></i> Enviar NFC-e por e-mail',
            html: `
            <div class="text-start">
                <p class="text-muted">Em breve será possível disparar o DANFCE/QR-Code direto para o consumidor.</p>
                <ul class="ps-3 mb-3">
                    <li>Certifique-se de coletar o e-mail do cliente no PDV;</li>
                    <li>Será possível anexar o PDF e enviar o link de consulta.</li>
                </ul>
                <p class="mb-0">Venda: <strong>${numeroVenda}</strong> — Cliente: <strong>${cliente || 'Consumidor'}</strong></p>
            </div>
        `,
            icon: 'info',
            confirmButtonText: 'Ok'
        });
    }

    function enviarEmailNFSe(vendaId, numeroVenda, cliente) {
        Swal.fire({
            title: '<i class="bi bi-envelope-open"></i> Enviar NFS-e por e-mail',
            html: `
            <div class="text-start">
                <p class="text-muted">Pretendemos enviar a NFS-e (PDF/XML) assim que a prefeitura autorizar.</p>
                <ul class="ps-3 mb-3">
                    <li>Valide o e-mail do tomador na ficha da venda;</li>
                    <li>Após a integração, será possível anexar comprovantes e observações.</li>
                </ul>
                <p class="mb-0">Venda: <strong>${numeroVenda}</strong> — Cliente: <strong>${cliente || 'Consumidor'}</strong></p>
            </div>
        `,
            icon: 'info',
            confirmButtonText: 'Ok'
        });
    }

    // Função para pré-visualizar DANFE
    async function previsualizarNFe(vendaId, numeroVenda, cliente, total, configs) {
        try {
            // Mostrar loading
            Swal.fire({
                title: 'Gerando Preview...',
                html: 'Aguarde enquanto geramos o preview do DANFE.',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            // Fazer requisição para preview
            const params = new URLSearchParams({
                id: String(vendaId),
                presenca_comprador: String(configs?.presenca_comprador ?? ''),
                intermediador: String(configs?.intermediador ?? ''),
                base_pis_cofins_icms: (configs?.base_pis_cofins_icms ? '1' : '0'),
                exibir_pis_cofins_danfe: (configs?.exibir_pis_cofins_danfe ? '1' : '0'),
                subtrair_icms_desonerado: (configs?.subtrair_icms_desonerado ? '1' : '0'),
                exibir_financeiro: (configs?.exibir_financeiro ? '1' : '0'),
                enviar_por_email: (configs?.enviar_por_email ? '1' : '0')
            });
            const response = await fetch(appUrl(`/vendas/preview-danfe?${params.toString()}`), {
                method: 'GET',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                }
            });

            const raw = await response.text();
            let data;
            try {
                data = JSON.parse(raw);
            } catch (e) {
                throw new Error(raw.substring(0, 500));
            }

            if (data.success) {
                // Fechar loading e abrir PDF imediatamente
                Swal.close();
                if (data.pdf_url) {
                    window.open(data.pdf_url, '_blank');
                }
                return;
            } else {
                // Mostrar erro
                Swal.fire({
                    icon: 'error',
                    title: 'Erro ao Gerar Preview',
                    text: data.error || 'Erro desconhecido ao gerar preview do DANFE.',
                    confirmButtonText: 'OK'
                });
            }

        } catch (error) {
            console.error('Erro ao gerar preview:', error);
            Swal.fire({
                icon: 'error',
                title: 'Erro de Conexão',
                text: 'Erro ao conectar com o servidor. Tente novamente.',
                confirmButtonText: 'OK'
            });
        }
    }

    // Função para reimprimir NF-e
    async function reimprimirNFe(vendaId) {
        Swal.fire({
            title: 'Buscando DANFE...',
            text: 'Aguarde enquanto carregamos o PDF',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: appUrl('/vendas/reimprimir-nfe?id=' + vendaId),
            type: 'GET',
            dataType: 'json',
            success: function (response) {
                Swal.close();

                // Verificar se a resposta foi bem-sucedida
                if (response.success && response.data) {
                    // Tentar usar pdf_path primeiro, depois pdf_path_alternativo
                    let pdfUrl = response.data.pdf_path || response.data.pdf_path_alternativo;

                    if (pdfUrl) {
                        // Garantir que a URL seja absoluta se necessário
                        if (pdfUrl.startsWith('/')) {
                            pdfUrl = window.location.origin + pdfUrl;
                        }

                        console.log('Abrindo DANFE:', pdfUrl);

                        // Método mais confiável: criar link temporário e clicar nele
                        // Isso evita bloqueio de popup
                        const link = document.createElement('a');
                        link.href = pdfUrl;
                        link.target = '_blank';
                        link.rel = 'noopener noreferrer';
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);

                        // Mostrar mensagem de sucesso
                        Swal.fire({
                            icon: 'success',
                            title: 'DANFE Aberto',
                            text: 'O DANFE foi aberto em uma nova aba.',
                            timer: 2000,
                            showConfirmButton: false
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: 'Caminho do PDF não encontrado na resposta'
                        });
                    }
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message || 'PDF não encontrado'
                    });
                }
            },
            error: function (xhr) {
                Swal.close();
                const response = xhr.responseJSON;
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: response?.message || 'Erro ao buscar PDF'
                });
            }
        });
    }

    // Função para Carta de Correção
    async function cartaCorrecaoNFe(vendaId) {
        Swal.fire({
            title: 'Carta de Correção Eletrônica',
            html: `
            <div class="text-start">
                <div class="mb-3">
                    <label class="form-label">Campo a Corrigir</label>
                    <select class="form-select" id="campo_correcao">
                        <option value="00">Descrição do produto/serviço</option>
                        <option value="01">Quantidade do produto/serviço</option>
                        <option value="02">Valor unitário do produto/serviço</option>
                        <option value="03">Valor total do produto/serviço</option>
                        <option value="04">Código da NCM</option>
                        <option value="05">Código CFOP</option>
                        <option value="06">Código CEST</option>
                        <option value="07">Dados do cliente</option>
                        <option value="08">Outros</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Correção *</label>
                    <textarea class="form-control" id="correcao" rows="4" placeholder="Descreva a correção necessária..." required></textarea>
                    <small class="text-muted">Máximo 1000 caracteres</small>
                </div>
            </div>
        `,
            showCancelButton: true,
            confirmButtonText: 'Enviar Carta de Correção',
            cancelButtonText: 'Cancelar',
            confirmButtonColor: '#ffc107',
            preConfirm: () => {
                const campo = document.getElementById('campo_correcao').value;
                const correcao = document.getElementById('correcao').value.trim();

                if (!correcao) {
                    Swal.showValidationMessage('A correção é obrigatória');
                    return false;
                }

                if (correcao.length > 1000) {
                    Swal.showValidationMessage('A correção deve ter no máximo 1000 caracteres');
                    return false;
                }

                return { campo, correcao };
            }
        }).then((result) => {
            if (result.isConfirmed) {
                const { campo, correcao } = result.value;

                Swal.fire({
                    title: 'Enviando Carta de Correção...',
                    allowOutsideClick: false,
                    didOpen: () => Swal.showLoading()
                });

                $.ajax({
                    url: appUrl('/vendas/carta-correcao-nfe'),
                    type: 'POST',
                    data: {
                        venda_id: vendaId,
                        campo_correcao: campo,
                        correcao: correcao
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Carta de Correção Enviada!',
                                text: response.message || 'Carta de correção enviada com sucesso',
                                confirmButtonText: 'OK'
                            }).then(() => location.reload());
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: response.message || 'Erro ao enviar carta de correção'
                            });
                        }
                    },
                    error: function (xhr) {
                        const response = xhr.responseJSON;
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: response?.message || 'Erro ao enviar carta de correção'
                        });
                    }
                });
            }
        });
    }

    // Função para Cancelar NF-e
    async function cancelarNFe(vendaId) {
        Swal.fire({
            title: 'Cancelar NF-e',
            html: `
            <div class="text-start">
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <strong>Atenção!</strong> O cancelamento de NF-e é irreversível e deve ser feito em até 30 dias após a autorização.
                </div>
                <div class="mb-3">
                    <label class="form-label">Justificativa do Cancelamento *</label>
                    <textarea class="form-control" id="justificativa" rows="4" placeholder="Descreva o motivo do cancelamento..." required></textarea>
                    <small class="text-muted">Mínimo 15 caracteres</small>
                </div>
            </div>
        `,
            showCancelButton: true,
            confirmButtonText: 'Confirmar Cancelamento',
            cancelButtonText: 'Cancelar',
            confirmButtonColor: '#dc3545',
            preConfirm: () => {
                const justificativa = document.getElementById('justificativa').value.trim();

                if (!justificativa) {
                    Swal.showValidationMessage('A justificativa é obrigatória');
                    return false;
                }

                if (justificativa.length < 15) {
                    Swal.showValidationMessage('A justificativa deve ter no mínimo 15 caracteres');
                    return false;
                }

                return { justificativa };
            }
        }).then((result) => {
            if (result.isConfirmed) {
                const { justificativa } = result.value;

                // Segunda confirmação
                Swal.fire({
                    title: 'Confirmar Cancelamento?',
                    text: 'Esta ação não pode ser desfeita!',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Sim, Cancelar NF-e',
                    cancelButtonText: 'Não, Manter',
                    confirmButtonColor: '#dc3545'
                }).then((confirmResult) => {
                    if (confirmResult.isConfirmed) {
                        Swal.fire({
                            title: 'Cancelando NF-e...',
                            allowOutsideClick: false,
                            didOpen: () => Swal.showLoading()
                        });

                        $.ajax({
                            url: appUrl('/vendas/cancelar-nfe'),
                            type: 'POST',
                            data: {
                                venda_id: vendaId,
                                justificativa: justificativa
                            },
                            dataType: 'json',
                            success: function (response) {
                                if (response.success) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'NF-e Cancelada!',
                                        text: response.message || 'NF-e cancelada com sucesso',
                                        confirmButtonText: 'OK'
                                    }).then(() => location.reload());
                                } else {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Erro ao Cancelar',
                                        html: `
                                        <div class="text-start">
                                            <p>${response.message || 'Erro desconhecido'}</p>
                                            ${response.data?.cStat ? `<p class="text-danger"><strong>Código SEFAZ:</strong> ${response.data.cStat}</p>` : ''}
                                        </div>
                                    `,
                                        confirmButtonText: 'OK',
                                        width: '600px'
                                    });
                                }
                            },
                            error: function (xhr) {
                                const response = xhr.responseJSON;
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Erro',
                                    text: response?.message || 'Erro ao cancelar NF-e'
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    // Função para visualizar PDF de cancelamento
    function visualizarPdfCancelamento(chaveNfe) {
        if (!chaveNfe) {
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Chave de acesso não encontrada'
            });
            return;
        }

        const url = appUrl(`/vendas/visualizar-pdf-cancelamento?chave=${encodeURIComponent(chaveNfe)}`);
        window.open(url, '_blank');
    }

    // Função para visualizar XML de cancelamento
    function visualizarXmlCancelamento(xmlPath) {
        if (!xmlPath) {
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'XML de cancelamento não encontrado'
            });
            return;
        }

        // Converter caminho relativo para absoluto se necessário
        let url = xmlPath;
        if (xmlPath.startsWith('/pontti_nfe/')) {
            url = xmlPath.replace('/pontti_nfe/', '/src/Integrations/NFe/');
        }

        // Abrir XML em nova aba
        window.open(url, '_blank');
    }
</script>

<?php
// Permitir que views filhas adicionem scripts antes do layout
if (isset($additionalScripts) && !empty($additionalScripts)) {
    echo $additionalScripts;
}

$content = ob_get_clean();
$activeMenu = $activeMenu ?? (isset($slug) && $slug === 'orcamentos-agua' ? 'orcamentos-agua' : 'vendas');
include ROOT_PATH . '/views/layouts/app.php';
?>