<?php
$isEdit = isset($venda['id']);
$module = $module ?? [];
$singular = $module['singular'] ?? 'Venda';
$plural = $module['plural'] ?? 'Vendas';
$moduleSlug = $module['slug'] ?? ($module['origin'] ?? 'vendas');
$hideDespesas = (bool) ($module['hide_despesas'] ?? ($moduleSlug === 'pre-vendas' || ($module['origin'] ?? '') === 'pre_venda'));
$hideEntrega = (bool) ($module['hide_entrega'] ?? ($moduleSlug === 'pre-vendas' || ($module['origin'] ?? '') === 'pre_venda'));
$usarLoteVenda = $usarLoteVenda ?? false;

$subtotalValor = isset($venda['subtotal']) ? (float) $venda['subtotal'] : 0.0;
$subtotalHidden = number_format($subtotalValor, 2, '.', '');
$subtotalDisplay = number_format($subtotalValor, 2, ',', '.');

$totalValor = isset($venda['total']) ? (float) $venda['total'] : $subtotalValor;
$totalHidden = number_format($totalValor, 2, '.', '');
$totalDisplay = number_format($totalValor, 2, ',', '.');

$discountValor = isset($venda['discount']) ? (float) $venda['discount'] : 0.0;
$discountInput = number_format($discountValor, 2, '.', '');

$additionsValor = isset($venda['additions']) ? (float) $venda['additions'] : 0.0;
$additionsHidden = number_format($additionsValor, 2, '.', '');

$freightValor = isset($venda['freight_value']) ? (float) $venda['freight_value'] : (isset($venda['shipping']) ? (float) $venda['shipping'] : 0.0);
$freightInput = number_format($freightValor, 2, '.', '');

$shippingValor = isset($venda['shipping']) ? (float) $venda['shipping'] : $freightValor;
$shippingHidden = number_format($shippingValor, 2, '.', '');

$parcelasValor = isset($venda['installments']) ? (int) $venda['installments'] : 1;
?>

<!-- Abas -->
<ul class="nav nav-tabs mb-4" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados" type="button"
            role="tab">
            <i class="bi bi-file-earmark-text me-2"></i> Dados da <?= htmlspecialchars($singular) ?>
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="itens-tab" data-bs-toggle="tab" data-bs-target="#itens" type="button" role="tab">
            <i class="bi bi-cart-plus me-2"></i> Itens
        </button>
    </li>
    <?php if (!$hideDespesas): ?>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="despesas-tab" data-bs-toggle="tab" data-bs-target="#despesas" type="button"
                role="tab">
                <i class="bi bi-receipt me-2"></i> Despesas
            </button>
        </li>
    <?php endif; ?>
    <?php if (!$hideEntrega): ?>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="entrega-tab" data-bs-toggle="tab" data-bs-target="#entrega" type="button"
                role="tab">
                <i class="bi bi-truck me-2"></i> Entrega
            </button>
        </li>
    <?php endif; ?>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pagamento-tab" data-bs-toggle="tab" data-bs-target="#pagamento" type="button"
            role="tab">
            <i class="bi bi-credit-card me-2"></i> Pagamento e Valores
        </button>
    </li>
</ul>

<!-- Conteúdo das Abas -->
<div class="tab-content">
    <!-- Aba: Dados da Venda -->
    <div class="tab-pane fade show active" id="dados" role="tabpanel">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-file-earmark-text me-2"></i> Informações Principais
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="sale_number" class="form-label">Número da <?= htmlspecialchars($singular) ?>
                                    *</label>
                                <input type="text" readonly class="form-control bg-light" id="sale_number"
                                    name="sale_number"
                                    value="<?= htmlspecialchars($venda['sale_number'] ?? $proximoNumero ?? 'VND-000001') ?>"
                                    title="Gerado automaticamente" required>
                                <small class="text-muted">Gerado automaticamente</small>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="sale_date" class="form-label">Data da <?= htmlspecialchars($singular) ?>
                                    *</label>
                                <input type="date" class="form-control" id="sale_date" name="sale_date"
                                    value="<?= $venda['sale_date'] ?? date('Y-m-d') ?>" required>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="empresa_id" class="form-label">
                                    <i class="bi bi-building me-1"></i> Empresa *
                                </label>
                                <select class="form-select" id="empresa_id" name="empresa_id" <?= ($isEdit && !empty($itens)) ? '' : 'required' ?>>
                                    <option value="">Selecione uma empresa...</option>
                                    <?php if (!empty($empresasVinculadas ?? [])): ?>
                                        <?php foreach ($empresasVinculadas as $empresa): ?>
                                            <?php
                                            $nome = $empresa['razao_social'] ?? $empresa['nome_fantasia'] ?? 'Empresa';
                                            $cnpj = $empresa['cnpj'] ?? '';
                                            if ($cnpj && strlen($cnpj) === 14) {
                                                $cnpj = preg_replace('/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/', '$1.$2.$3/$4-$5', $cnpj);
                                            }
                                            $empresaIdVenda = $empresaSelecionadaId ?? ($venda['company_id'] ?? '');
                                            $selected = ($empresaIdVenda == $empresa['id']) ? 'selected' : '';
                                            ?>
                                            <option value="<?= $empresa['id'] ?>" <?= $selected ?>>
                                                <?= htmlspecialchars($nome) ?>
                                                <?= $cnpj ? ' - ' . htmlspecialchars($cnpj) : '' ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                                <small class="text-muted">Empresa que está realizando a venda</small>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="status" class="form-label">Status *</label>
                                <select class="form-select" id="status" name="status" required>
                                    <?php
                                    $statusVendas = $statusVendas ?? [];
                                    $statusAtual = $venda['status'] ?? ($statusPadrao ?? 'orcamento');

                                    if (empty($statusVendas)) {
                                        $moduleSlug = $module['slug'] ?? ($module['origin'] ?? 'vendas');
                                        if ($moduleSlug === 'pre-vendas' || ($module['origin'] ?? '') === 'pre_venda') {
                                            // Fallback específico para DAV (Pré-vendas)
                                            $statusVendas = [
                                                ['codigo' => 'orcamento', 'nome' => 'Orçamento'],
                                                ['codigo' => 'pendente', 'nome' => 'Pendente'],
                                            ];
                                        } else {
                                            // Fallback padrão das vendas
                                            $statusVendas = [
                                                ['codigo' => 'orcamento', 'nome' => 'Orçamento'],
                                                ['codigo' => 'pendente', 'nome' => 'Pendente'],
                                                ['codigo' => 'realizado', 'nome' => 'Realizado'],
                                                ['codigo' => 'faturamento', 'nome' => 'Faturamento'],
                                                ['codigo' => 'expedicao', 'nome' => 'Expedição'],
                                                ['codigo' => 'em_entrega', 'nome' => 'Em Entrega'],
                                                ['codigo' => 'finalizado', 'nome' => 'Finalizado'],
                                            ];
                                        }
                                    }

                                    foreach ($statusVendas as $status) {
                                        $codigo = $status['codigo'];
                                        $nome = $status['nome'];
                                        $selected = ($statusAtual === $codigo) ? 'selected' : '';
                                        echo "<option value=\"{$codigo}\" {$selected}>{$nome}</option>\n";
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Cliente com Autocomplete -->
                        <h6 class="text-primary mb-3">
                            <i class="bi bi-person me-2"></i> Cliente
                        </h6>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="customer_search" class="form-label">
                                    Cliente
                                    <small class="text-muted">(Digite para buscar ou deixe vazio para Consumidor
                                        Final)</small>
                                </label>
                                <div class="position-relative">
                                    <input type="text" class="form-control" id="customer_search"
                                        placeholder="Digite nome, razão social ou CNPJ/CPF do cliente..."
                                        autocomplete="off"
                                        value="<?= htmlspecialchars($venda['customer_name'] ?? '') ?>">
                                    <div id="customer_dropdown" class="autocomplete-dropdown" style="display: none;">
                                    </div>
                                </div>
                                <input type="hidden" id="customer_id" name="customer_id"
                                    value="<?= $venda['customer_id'] ?? '' ?>">
                                <input type="hidden" id="customer_type" name="customer_type"
                                    value="<?= $venda['customer_type'] ?? 'pessoa' ?>">
                                <input type="hidden" id="customer_name" name="customer_name"
                                    value="<?= htmlspecialchars($venda['customer_name'] ?? '') ?>">
                                <input type="hidden" id="customer_document" name="customer_document"
                                    value="<?= htmlspecialchars($venda['customer_document'] ?? '') ?>">
                            </div>
                            <div class="col-md-12" id="customer_info" style="display: none;">
                                <div class="alert alert-info mb-3">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="flex-grow-1">
                                            <div id="customer_info_name"></div>
                                        </div>
                                        <button type="button" class="btn btn-sm btn-outline-danger ms-2"
                                            onclick="limparCliente()">
                                            <i class="bi bi-x"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Vendedores -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="vendor_id" class="form-label">
                                    <i class="bi bi-person-badge me-1"></i> Vendedor Principal
                                </label>
                                <select class="form-select" id="vendor_id" name="vendor_id">
                                    <option value="">Nenhum</option>
                                    <?php if (!empty($vendedores)): ?>
                                        <?php foreach ($vendedores as $vendedor): ?>
                                            <option value="<?= $vendedor['id'] ?>" <?= ($venda['vendor_id'] ?? '') == $vendedor['id'] ? 'selected' : '' ?>>
                                                <?= htmlspecialchars($vendedor['name']) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="auxiliary_vendor_id" class="form-label">
                                    <i class="bi bi-person-plus me-1"></i> Vendedor Auxiliar
                                </label>
                                <select class="form-select" id="auxiliary_vendor_id" name="auxiliary_vendor_id">
                                    <option value="">Nenhum</option>
                                    <?php if (!empty($vendedores)): ?>
                                        <?php foreach ($vendedores as $vendedor): ?>
                                            <option value="<?= $vendedor['id'] ?>" <?= ($venda['auxiliary_vendor_id'] ?? '') == $vendedor['id'] ? 'selected' : '' ?>>
                                                <?= htmlspecialchars($vendedor['name']) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="notes" class="form-label">Observações</label>
                                <textarea class="form-control" id="notes" name="notes" rows="3"
                                    placeholder="Observações sobre esta venda..."><?= htmlspecialchars($venda['notes'] ?? '') ?></textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="observacoes_nfe" class="form-label">
                                    <i class="bi bi-file-earmark-text me-1"></i>
                                    Observações NF-e
                                </label>
                                <textarea class="form-control" id="observacoes_nfe" name="observacoes_nfe" rows="3"
                                    placeholder="Observações específicas que aparecerão na NF-e (ex: informações fiscais, complementares, etc.)..."><?= htmlspecialchars($venda['observacoes_nfe'] ?? '') ?></textarea>
                                <small class="text-muted">
                                    <i class="bi bi-info-circle me-1"></i>
                                    Estas observações aparecerão na NF-e emitida
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Itens da Venda -->
    <div class="tab-pane fade" id="itens" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-cart-plus me-2"></i> Produtos/Serviços
            </div>
            <div class="card-body">
                <!-- Bloco fixo para adicionar item -->
                <div class="card bg-light mb-4" id="bloco-adicionar-item">
                    <div class="card-body">
                        <h6 class="mb-3"><i class="bi bi-plus-circle me-2"></i> Adicionar Item</h6>
                        <div class="row g-3 align-items-end">
                            <?php if ($usarLoteVenda): ?>
                                <?php if ($comissaoFuncionarioItem ?? false): ?>
                                    <div class="col-md-5 col-lg-4 mb-3">
                                        <label class="form-label">Item</label>
                                        <div class="position-relative">
                                            <input type="text" class="form-control item-search" id="item_search_principal"
                                                placeholder="Digite para buscar produto/serviço..." autocomplete="off">
                                            <div id="item_dropdown_principal" class="autocomplete-dropdown"
                                                style="display: none;"></div>
                                        </div>
                                        <input type="hidden" id="produto_id_principal" value="">
                                    </div>
                                    <div class="col-md-3 col-lg-2 mb-3">
                                        <label class="form-label">Profissional</label>
                                        <select class="form-select" id="vendedor_principal">
                                            <option value="">Selecione...</option>
                                            <?php
                                            $profissionaisDisponiveis = isset($profissionaisItem) ? $profissionaisItem : [];
                                            if (!empty($profissionaisDisponiveis)):
                                                foreach ($profissionaisDisponiveis as $prof):
                                                    if (isset($prof['id']) && isset($prof['name'])):
                                                        ?>
                                                        <option value="<?= (int) $prof['id'] ?>"><?= htmlspecialchars($prof['name']) ?>
                                                        </option>
                                                        <?php
                                                    endif;
                                                endforeach;
                                            endif;
                                            ?>
                                        </select>
                                    </div>
                                    <div class="col-md-4 col-lg-5 mb-3">
                                        <label class="form-label">Lote</label>
                                        <select class="form-select" id="lote_principal" disabled>
                                            <option value="">Selecione o lote</option>
                                        </select>
                                    </div>
                                <?php else: ?>
                                    <div class="col-md-8 col-lg-7 mb-3">
                                        <label class="form-label">Item</label>
                                        <div class="position-relative">
                                            <input type="text" class="form-control item-search" id="item_search_principal"
                                                placeholder="Digite para buscar produto/serviço..." autocomplete="off">
                                            <div id="item_dropdown_principal" class="autocomplete-dropdown"
                                                style="display: none;"></div>
                                        </div>
                                        <input type="hidden" id="produto_id_principal" value="">
                                    </div>
                                    <div class="col-md-4 col-lg-5 mb-3">
                                        <label class="form-label">Lote</label>
                                        <select class="form-select" id="lote_principal" disabled>
                                            <option value="">Selecione o lote</option>
                                        </select>
                                    </div>
                                <?php endif; ?>
                            <?php else: ?>
                                <?php if ($comissaoFuncionarioItem ?? false): ?>
                                    <div class="col-md-8 col-lg-9 mb-3">
                                        <label class="form-label">Item</label>
                                        <div class="position-relative">
                                            <input type="text" class="form-control item-search" id="item_search_principal"
                                                placeholder="Digite para buscar produto/serviço..." autocomplete="off">
                                            <div id="item_dropdown_principal" class="autocomplete-dropdown"
                                                style="display: none;"></div>
                                        </div>
                                        <input type="hidden" id="produto_id_principal" value="">
                                    </div>
                                    <div class="col-md-4 col-lg-3 mb-3">
                                        <label class="form-label">Profissional</label>
                                        <select class="form-select" id="vendedor_principal">
                                            <option value="">Selecione...</option>
                                            <?php
                                            $profissionaisDisponiveis = isset($profissionaisItem) ? $profissionaisItem : [];
                                            if (!empty($profissionaisDisponiveis)):
                                                foreach ($profissionaisDisponiveis as $prof):
                                                    if (isset($prof['id']) && isset($prof['name'])):
                                                        ?>
                                                        <option value="<?= (int) $prof['id'] ?>"><?= htmlspecialchars($prof['name']) ?>
                                                        </option>
                                                        <?php
                                                    endif;
                                                endforeach;
                                            endif;
                                            ?>
                                        </select>
                                    </div>
                                <?php else: ?>
                                    <div class="col-md-12 mb-3">
                                        <label class="form-label">Item</label>
                                        <div class="position-relative">
                                            <input type="text" class="form-control item-search" id="item_search_principal"
                                                placeholder="Digite para buscar produto/serviço..." autocomplete="off">
                                            <div id="item_dropdown_principal" class="autocomplete-dropdown"
                                                style="display: none;"></div>
                                        </div>
                                        <input type="hidden" id="produto_id_principal" value="">
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="row">
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Qtd</label>
                                <input type="number" class="form-control form-control-sm quantidade text-center"
                                    id="qtd_principal" min="0.001" step="0.001" value="1">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Preço Unit. (R$)</label>
                                <input type="number" class="form-control form-control-sm preco-unitario"
                                    id="preco_principal" step="0.01" min="0" value="0">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Desc. (R$)</label>
                                <input type="number" class="form-control form-control-sm desconto"
                                    id="desconto_principal" step="0.01" min="0" value="0">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Total (R$)</label>
                                <input type="number" class="form-control form-control-sm total-item fw-bold"
                                    id="total_principal" step="0.01" readonly value="0">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Obs.</label>
                                <input type="text" class="form-control form-control-sm" id="obs_principal"
                                    placeholder="Obs">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">&nbsp;</label>
                                <button type="button" class="btn btn-sm btn-success w-100"
                                    onclick="adicionarItemNaTabela()">
                                    <i class="bi bi-plus-circle me-1"></i> Adicionar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tabela de itens adicionados -->
                <div id="tabela-itens">
                    <table class="table table-hover table-sm">
                        <thead class="table-light">
                            <tr>
                                <th width="<?= ($comissaoFuncionarioItem ?? false) ? '28%' : '35%' ?>">Item</th>
                                <?php if ($comissaoFuncionarioItem ?? false): ?>
                                    <th width="12%">Profissional</th>
                                <?php endif; ?>
                                <th width="8%" class="text-center">Qtd</th>
                                <th width="10%" class="text-end">Unit.</th>
                                <th width="10%" class="text-end">Desc.</th>
                                <th width="10%" class="text-end">Total</th>
                                <th width="<?= ($comissaoFuncionarioItem ?? false) ? '22%' : '27%' ?>">Obs.</th>
                            </tr>
                        </thead>
                        <tbody id="tbody-itens">
                            <!-- Itens serão adicionados aqui -->
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="<?= ($comissaoFuncionarioItem ?? false) ? '5' : '4' ?>" class="text-end">
                                    <strong>Total:</strong>
                                </td>
                                <td class="text-end"><strong id="total-geral">R$ <?= $totalDisplay ?></strong></td>
                                <td colspan="1"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="alert alert-info" id="alert-sem-itens">
                    <i class="bi bi-info-circle me-2"></i>
                    Nenhum item adicionado. Use o formulário acima para adicionar itens.
                </div>
            </div>
        </div>
    </div>

    <?php if (!$hideDespesas): ?>
        <!-- Aba: Despesas -->
        <div class="tab-pane fade" id="despesas" role="tabpanel">
            <div class="card">
                <div class="card-header">
                    <i class="bi bi-receipt me-2"></i> Despesas Adicionais
                </div>
                <div class="card-body">
                    <!-- Bloco para adicionar despesa -->
                    <div class="card bg-light mb-4">
                        <div class="card-body">
                            <h6 class="mb-3"><i class="bi bi-plus-circle me-2"></i> Adicionar Despesa</h6>
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <label for="despesa_tipo" class="form-label">Tipo de Despesa</label>
                                    <select class="form-select" id="despesa_tipo">
                                        <option value="">Selecione...</option>
                                        <option value="comissao">Comissão</option>
                                        <option value="frete">Frete</option>
                                        <option value="taxa_administrativa">Taxa Administrativa</option>
                                        <option value="embalagem">Embalagem</option>
                                        <option value="seguro">Seguro</option>
                                        <option value="outro">Outro</option>
                                    </select>
                                </div>
                                <div class="col-md-5 mb-3">
                                    <label for="despesa_descricao" class="form-label">Descrição</label>
                                    <input type="text" class="form-control" id="despesa_descricao"
                                        placeholder="Descrição da despesa">
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="despesa_valor" class="form-label">Valor (R$)</label>
                                    <input type="number" class="form-control" id="despesa_valor" step="0.01" min="0"
                                        placeholder="0,00">
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label class="form-label">&nbsp;</label>
                                    <button type="button" class="btn btn-success w-100" onclick="adicionarDespesa()">
                                        <i class="bi bi-plus-circle me-1"></i> Adicionar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tabela de despesas -->
                    <div id="tabela-despesas" style="display: none;">
                        <table class="table table-hover table-sm">
                            <thead class="table-light">
                                <tr>
                                    <th width="20%">Tipo</th>
                                    <th width="50%">Descrição</th>
                                    <th width="20%" class="text-end">Valor</th>
                                    <th width="10%"></th>
                                </tr>
                            </thead>
                            <tbody id="tbody-despesas">
                                <!-- Despesas serão adicionadas aqui -->
                            </tbody>
                            <tfoot class="table-light">
                                <tr>
                                    <td colspan="2" class="text-end"><strong>Total Despesas:</strong></td>
                                    <td class="text-end"><strong id="total-despesas">R$ 0,00</strong></td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    <div class="alert alert-info" id="alert-sem-despesas">
                        <i class="bi bi-info-circle me-2"></i>
                        Nenhuma despesa adicionada. Use o formulário acima para adicionar despesas.
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (!$hideEntrega): ?>
        <!-- Aba: Entrega -->
        <div class="tab-pane fade" id="entrega" role="tabpanel">
            <div class="row">
                <!-- Endereço de Entrega -->
                <div class="col-lg-6">
                    <div class="card h-100">
                        <div class="card-header">
                            <i class="bi bi-geo-alt me-2"></i> Endereço de Entrega
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8 mb-3">
                                    <label for="delivery_street" class="form-label">Rua/Logradouro</label>
                                    <input type="text" class="form-control" id="delivery_street" name="delivery_street"
                                        value="<?= htmlspecialchars($venda['delivery_street'] ?? '') ?>"
                                        placeholder="Nome da rua ou avenida">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="delivery_number" class="form-label">Número</label>
                                    <input type="text" class="form-control" id="delivery_number" name="delivery_number"
                                        value="<?= htmlspecialchars($venda['delivery_number'] ?? '') ?>" placeholder="123">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label for="delivery_complement" class="form-label">Complemento</label>
                                    <input type="text" class="form-control" id="delivery_complement"
                                        name="delivery_complement"
                                        value="<?= htmlspecialchars($venda['delivery_complement'] ?? '') ?>"
                                        placeholder="Apartamento, bloco, sala...">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-5 mb-3">
                                    <label for="delivery_city" class="form-label">Cidade</label>
                                    <input type="text" class="form-control" id="delivery_city" name="delivery_city"
                                        value="<?= htmlspecialchars($venda['delivery_city'] ?? '') ?>" placeholder="Cidade">
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="delivery_state" class="form-label">UF</label>
                                    <input type="text" class="form-control text-uppercase" id="delivery_state"
                                        name="delivery_state"
                                        value="<?= htmlspecialchars($venda['delivery_state'] ?? '') ?>" placeholder="UF"
                                        maxlength="2">
                                </div>
                                <div class="col-md-5 mb-3">
                                    <label for="delivery_zip" class="form-label">CEP</label>
                                    <input type="text" class="form-control" id="delivery_zip" name="delivery_zip"
                                        value="<?= htmlspecialchars($venda['delivery_zip'] ?? '') ?>"
                                        placeholder="00000-000">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label for="delivery_date" class="form-label">Data de Entrega Prevista</label>
                                    <input type="date" class="form-control" id="delivery_date" name="delivery_date"
                                        value="<?= $venda['delivery_date'] ?? '' ?>">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label for="delivery_notes" class="form-label">Observações da Entrega</label>
                                    <textarea class="form-control" id="delivery_notes" name="delivery_notes" rows="3"
                                        placeholder="Instruções especiais para entrega..."><?= htmlspecialchars($venda['delivery_notes'] ?? '') ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transportadora e Veículo -->
                <div class="col-lg-6">
                    <div class="card h-100">
                        <div class="card-header">
                            <i class="bi bi-truck-front-fill me-2"></i> Transportadora e Veículo
                        </div>
                        <div class="card-body">
                            <h6 class="text-primary mb-3"><i class="bi bi-building me-2"></i> Transportadora</h6>

                            <div class="mb-3">
                                <label for="carrier_name" class="form-label">Nome da Transportadora</label>
                                <input type="text" class="form-control" id="carrier_name" name="carrier_name"
                                    value="<?= htmlspecialchars($venda['carrier_name'] ?? '') ?>"
                                    placeholder="Nome da transportadora">
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="carrier_cnpj" class="form-label">CNPJ</label>
                                    <input type="text" class="form-control" id="carrier_cnpj" name="carrier_cnpj"
                                        value="<?= htmlspecialchars($venda['carrier_cnpj'] ?? '') ?>"
                                        placeholder="00.000.000/0000-00">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="carrier_ie" class="form-label">Inscrição Estadual</label>
                                    <input type="text" class="form-control" id="carrier_ie" name="carrier_ie"
                                        value="<?= htmlspecialchars($venda['carrier_ie'] ?? '') ?>" placeholder="IE">
                                </div>
                            </div>

                            <hr class="my-3">

                            <h6 class="text-primary mb-3"><i class="bi bi-truck me-2"></i> Dados do Veículo</h6>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="vehicle_plate" class="form-label">Placa do Veículo</label>
                                    <input type="text" class="form-control text-uppercase" id="vehicle_plate"
                                        name="vehicle_plate" value="<?= htmlspecialchars($venda['vehicle_plate'] ?? '') ?>"
                                        placeholder="ABC-1234" maxlength="8">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="vehicle_state" class="form-label">UF Veículo</label>
                                    <input type="text" class="form-control text-uppercase" id="vehicle_state"
                                        name="vehicle_state" value="<?= htmlspecialchars($venda['vehicle_state'] ?? '') ?>"
                                        placeholder="UF" maxlength="2">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label for="driver_name" class="form-label">Nome do Motorista</label>
                                    <input type="text" class="form-control" id="driver_name" name="driver_name"
                                        value="<?= htmlspecialchars($venda['driver_name'] ?? '') ?>"
                                        placeholder="Nome completo do motorista">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label for="tracking_code" class="form-label">Código de Rastreamento</label>
                                    <input type="text" class="form-control" id="tracking_code" name="tracking_code"
                                        value="<?= htmlspecialchars($venda['tracking_code'] ?? '') ?>"
                                        placeholder="Código de rastreio da entrega">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Frete e Volumes -->
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <i class="bi bi-box-seam me-2"></i> Frete e Volumes
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <label for="freight_type" class="form-label">Tipo de Frete</label>
                                    <select class="form-select" id="freight_type" name="freight_type">
                                        <option value="">Selecione...</option>
                                        <option value="cif" <?= ($venda['freight_type'] ?? '') === 'cif' ? 'selected' : '' ?>>
                                            CIF (Por conta
                                            do remetente)</option>
                                        <option value="fob" <?= ($venda['freight_type'] ?? '') === 'fob' ? 'selected' : '' ?>>
                                            FOB (Por conta
                                            do destinatário)</option>
                                        <option value="terceiros" <?= ($venda['freight_type'] ?? '') === 'terceiros' ? 'selected' : '' ?>>
                                            Terceiros</option>
                                        <option value="proprio" <?= ($venda['freight_type'] ?? '') === 'proprio' ? 'selected' : '' ?>>Próprio
                                            (por conta do remetente)</option>
                                        <option value="proprio_destinatario" <?= ($venda['freight_type'] ?? '') === 'proprio_destinatario' ? 'selected' : '' ?>>
                                            Próprio (por conta do destinatário)</option>
                                    </select>
                                </div>

                                <div class="col-md-2 mb-3">
                                    <label for="freight_value" class="form-label">Valor Frete (R$)</label>
                                    <input type="number" class="form-control" id="freight_value" name="freight_value"
                                        step="0.01" min="0" value="<?= $freightInput ?>" placeholder="0,00">
                                </div>

                                <div class="col-md-2 mb-3">
                                    <label for="volume_quantity" class="form-label">Quantidade Volume</label>
                                    <input type="number" class="form-control" id="volume_quantity" name="volume_quantity"
                                        min="0" value="<?= $venda['volume_quantity'] ?? '' ?>" placeholder="0">
                                </div>

                                <div class="col-md-2 mb-3">
                                    <label for="volume_species" class="form-label">Espécie Volume</label>
                                    <input type="text" class="form-control" id="volume_species" name="volume_species"
                                        value="<?= htmlspecialchars($venda['volume_species'] ?? '') ?>"
                                        placeholder="Caixa, Pacote...">
                                </div>

                                <div class="col-md-2 mb-3">
                                    <label for="volume_brand" class="form-label">Marca Volume</label>
                                    <input type="text" class="form-control" id="volume_brand" name="volume_brand"
                                        value="<?= htmlspecialchars($venda['volume_brand'] ?? '') ?>" placeholder="Marca">
                                </div>

                                <div class="col-md-1 mb-3">
                                    <label for="volume_numbering" class="form-label">Numeração</label>
                                    <input type="text" class="form-control" id="volume_numbering" name="volume_numbering"
                                        value="<?= htmlspecialchars($venda['volume_numbering'] ?? '') ?>" placeholder="1/5">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Aba: Pagamento e Valores -->
    <div class="tab-pane fade" id="pagamento" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-credit-card me-2"></i> Pagamento e Valores
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Coluna Esquerda: Valores e Cálculos -->
                    <div class="col-lg-6">
                        <h6 class="text-primary mb-3"><i class="bi bi-currency-dollar me-2"></i> Valores</h6>

                        <div class="mb-3">
                            <label class="form-label"><strong>Subtotal</strong></label>
                            <div class="input-group">
                                <span class="input-group-text">R$</span>
                                <input type="text" class="form-control text-end" id="subtotal_display" readonly
                                    value="<?= $subtotalDisplay ?>">
                            </div>
                            <input type="hidden" id="subtotal" name="subtotal" value="<?= $subtotalHidden ?>">
                            <small class="text-muted">Itens + Despesas + Frete</small>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="discount_type" class="form-label">Tipo de Desconto</label>
                                <select class="form-select" id="discount_type" name="discount_type">
                                    <option value="fixed" <?= ($venda['discount_type'] ?? 'fixed') === 'fixed' ? 'selected' : '' ?>>Valor
                                        Fixo (R$)</option>
                                    <option value="percent" <?= ($venda['discount_type'] ?? '') === 'percent' ? 'selected' : '' ?>>
                                        Percentual (%)</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="discount" class="form-label">Desconto</label>
                                <input type="number" class="form-control" id="discount" name="discount" step="0.01"
                                    min="0" value="<?= $discountInput ?>" placeholder="0,00">
                            </div>
                        </div>

                        <hr class="my-3">

                        <div class="mb-3">
                            <label class="form-label"><strong class="text-success fs-5">TOTAL FINAL</strong></label>
                            <div class="input-group input-group-lg">
                                <span class="input-group-text bg-success text-white fw-bold">R$</span>
                                <input type="text" class="form-control text-end fw-bold" id="total_display" readonly
                                    value="<?= $totalDisplay ?>">
                            </div>
                            <input type="hidden" id="total" name="total" value="<?= $totalHidden ?>">
                        </div>
                    </div>

                    <!-- Coluna Direita: Forma de Pagamento e Opções -->
                    <div class="col-lg-6">
                        <h6 class="text-primary mb-3"><i class="bi bi-credit-card me-2"></i> Forma de Pagamento</h6>

                        <div class="mb-3">
                            <label for="payment_method_id" class="form-label">Método de Pagamento</label>
                            <select class="form-select" id="payment_method_id" name="payment_method_id">
                                <option value="">Selecione...</option>
                                <?php if (!empty($metodosPagamento)): ?>
                                    <?php foreach ($metodosPagamento as $metodo): ?>
                                        <option value="<?= $metodo['id'] ?>" <?= ($venda['payment_method_id'] ?? '') == $metodo['id'] ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($metodo['name']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>

                        <!-- Campos hidden para manter compatibilidade com backend -->
                        <input type="hidden" id="additions" name="additions" value="<?= $additionsHidden ?>">
                        <input type="hidden" id="shipping" name="shipping" value="<?= $shippingHidden ?>">
                        <input type="hidden" id="installments" name="installments" value="<?= $parcelasValor ?>">

                        <!-- Exibição do Parcelamento Selecionado -->
                        <div id="parcelamento-info" class="alert alert-info mb-3"
                            style="border-left: 4px solid #0dcaf0; background-color: #e7f3ff;">
                            <div class="d-flex align-items-start">
                                <i class="bi bi-calendar-check me-2 mt-1" style="font-size: 1.25rem;"></i>
                                <div class="flex-grow-1">
                                    <strong class="d-block mb-2" style="color: #0d6efd;">
                                        <i class="bi bi-receipt-cutoff me-1"></i> Parcelamento Selecionado
                                    </strong>
                                    <div id="parcelamento-detalhes" style="font-size: 0.95rem; line-height: 1.5;">
                                        <span class="text-muted">Nenhum parcelamento selecionado</span>
                                    </div>
                                </div>
                                <button type="button" class="btn btn-sm btn-link text-primary p-0 ms-2"
                                    onclick="$('#payment_method_id').trigger('change')" title="Alterar parcelamento">
                                    <i class="bi bi-pencil-fill"></i>
                                </button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($isEdit): ?>
    <input type="hidden" name="id" value="<?= $venda['id'] ?>">
<?php endif; ?>

<style>
    .autocomplete-dropdown {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: var(--bs-body-bg, #fff);
        border: 1px solid var(--bs-border-color, #dee2e6);
        border-top: none;
        border-radius: 0 0 0.375rem 0.375rem;
        max-height: 300px;
        overflow-y: auto;
        z-index: 1000;
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }

    .autocomplete-item {
        padding: 0.875rem 1rem;
        cursor: pointer;
        border-bottom: 1px solid var(--bs-border-color, #f0f0f0);
        transition: all 0.15s ease-in-out;
        line-height: 1.5;
    }

    .autocomplete-item:hover,
    .autocomplete-item.active {
        background-color: var(--bs-primary, #0d6efd);
        color: white;
        transform: translateX(3px);
    }

    .autocomplete-item:hover .text-muted {
        color: rgba(255, 255, 255, 0.8) !important;
    }

    .autocomplete-item:last-child {
        border-bottom: none;
    }

    .autocomplete-item .mb-1 {
        margin-bottom: 0.375rem;
    }

    .autocomplete-item strong {
        font-weight: 600;
    }

    .autocomplete-no-results {
        padding: 1rem;
        text-align: center;
        color: var(--bs-secondary, #6c757d);
        font-style: italic;
    }

    /* Modal de Prazos */
    .swal-wide .list-group-item {
        cursor: pointer;
        transition: all 0.2s;
        padding: 1rem;
    }

    .swal-wide .list-group-item:hover {
        background-color: #f0f8ff;
        transform: translateX(3px);
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .swal-wide .list-group-item h6 {
        color: #2c3e50;
        font-weight: 600;
        font-size: 1rem;
        margin: 0;
    }

    .swal-wide .list-group-item p {
        color: #6c757d;
        font-size: 0.875rem;
        margin: 0;
        line-height: 1.4;
    }

    .swal-wide .prazo-item .d-flex>div:first-child {
        flex: 1;
    }

    /* Info de Parcelamento */
    #parcelamento-info {
        background-color: #e7f3ff;
        border-color: #0dcaf0;
        animation: fadeInDown 0.3s;
    }

    #parcelamento-info strong {
        color: #0d6efd;
    }

    #parcelamento-info .btn-link {
        text-decoration: none;
        font-size: 1rem;
    }

    #parcelamento-info .btn-link:hover {
        opacity: 0.7;
    }

    @keyframes fadeInDown {
        from {
            opacity: 0;
            transform: translateY(-10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .payment-card {
        border-radius: 1.25rem;
        box-shadow: 0 20px 45px rgba(15, 23, 42, 0.18);
        border: 1px solid rgba(148, 163, 184, 0.2);
    }

    .payment-card .card-header {
        background: linear-gradient(135deg, rgba(37, 99, 235, 0.12), rgba(37, 99, 235, 0));
        border-bottom: 1px solid rgba(148, 163, 184, 0.15);
        font-weight: 600;
    }

    .payment-section {
        background: rgba(15, 23, 42, 0.04);
        border: 1px solid rgba(148, 163, 184, 0.18);
        border-radius: 1rem;
        padding: 1.35rem;
    }

    .payment-section-heading {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        margin-bottom: 1.35rem;
    }

    .payment-section-icon {
        width: 36px;
        height: 36px;
        border-radius: 12px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-size: 1.1rem;
    }

    .payment-section-icon.icon-blue {
        background: rgba(37, 99, 235, 0.15);
        color: #2563eb;
    }

    .payment-section-icon.icon-indigo {
        background: rgba(79, 70, 229, 0.18);
        color: #4f46e5;
    }

    .payment-section-icon.icon-teal {
        background: rgba(14, 165, 233, 0.15);
        color: #0ea5e9;
    }

    .payment-section-title {
        font-weight: 600;
        font-size: 1.05rem;
        color: #0f172a;
    }

    .input-group-flat .input-group-text {
        background: rgba(148, 163, 184, 0.2);
        border: none;
        color: #0f172a;
        font-weight: 600;
    }

    .input-group-flat .form-control {
        border-left: none;
        background: rgba(255, 255, 255, 0.85);
    }

    .payment-total .input-group-text {
        background: #16a34a;
        color: #ffffff;
        border: none;
    }

    .payment-total .form-control {
        background: rgba(22, 163, 74, 0.08);
        border: 1px solid rgba(22, 163, 74, 0.3);
        color: #14532d;
        font-size: 1.35rem;
    }

    .parcelamento-info {
        border: 1px solid rgba(37, 99, 235, 0.3);
        background: rgba(37, 99, 235, 0.12);
        border-radius: 1rem;
        padding: 1rem 1.2rem;
    }

    .parcelamento-info-header {
        display: flex;
        align-items: center;
        gap: 1rem;
    }

    .parcelamento-icon {
        width: 42px;
        height: 42px;
        border-radius: 12px;
        background: rgba(37, 99, 235, 0.2);
        color: #2563eb;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-size: 1.25rem;
    }

    .parcelamento-title {
        display: block;
        color: #1d4ed8;
        font-size: 0.95rem;
        letter-spacing: 0.03em;
    }

    .parcelamento-detalhes {
        color: #0f172a;
        font-weight: 600;
    }

    .parcelamento-info button {
        border-radius: 0.75rem;
        border: 1px solid rgba(37, 99, 235, 0.35);
        background: rgba(255, 255, 255, 0.7);
        color: #1d4ed8;
    }

    .payment-option .form-check-input {
        width: 3rem;
        height: 1.5rem;
    }

    .payment-option .form-check-label {
        margin-left: 0.75rem;
    }

    .payment-option strong {
        display: block;
        color: #0f172a;
    }

    .payment-option i {
        color: inherit;
    }

    .payment-option .text-muted {
        margin-top: 0.35rem;
    }

    @media (max-width: 991px) {
        .payment-section {
            padding: 1.1rem;
        }

        .payment-section-heading {
            margin-bottom: 1rem;
        }
    }
</style>

<script>
    // Declarar variáveis PRIMEIRO (antes de usar)
    let itensTabela = [];
    let itemIndex = 0;
    let itemTimeoutPrincipal = null;
    let despesasTabela = [];
    let despesaIndex = 0;

    // Lista de clientes e produtos do PHP
    // clientesData e produtosData serão carregados dinamicamente baseado na empresa selecionada
    let clientesData = [];
    let produtosData = [];
    const usarLoteVenda = <?= $usarLoteVenda ? 'true' : 'false' ?>;
    const comissaoFuncionarioItem = <?= ($comissaoFuncionarioItem ?? false) ? 'true' : 'false' ?>;
    const profissionaisItemData = <?= json_encode($profissionaisItem ?? []) ?>;
    let selectedCustomer = null;
    let autocompleteTimeout = null;
    let selectedProduto = null;
    let selectedLote = null;

    function escapeHtml(text) {
        const map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        };
        return String(text ?? '').replace(/[&<>"']/g, m => map[m]);
    }

    // Aguardar jQuery e inicializar
    (function aguardarJQuery() {
        if (typeof jQuery === 'undefined') {
            setTimeout(aguardarJQuery, 100);
            return;
        }
        inicializarFormularioVenda();
    })();

    // ============================================
    // AUTOCOMPLETE DE CLIENTE
    // ============================================
    function inicializarAutocompleteCliente() {
        const $search = $('#customer_search');
        const $dropdown = $('#customer_dropdown');
        const $empresaSelect = $('#empresa_id');

        // Salvar empresa inicial antes de definir event listeners
        const empresaIdInicial = '<?= $empresaSelecionadaId ?? '' ?>';
        let empresaIdAnterior = $empresaSelect.val() || empresaIdInicial;

        // Se houver empresaIdInicial mas o select não tiver valor, definir
        if (empresaIdInicial && !$empresaSelect.val()) {
            $empresaSelect.val(empresaIdInicial);
            empresaIdAnterior = empresaIdInicial;
        }

        // Verificar se já há itens carregados e desabilitar empresa se necessário
        <?php if ($isEdit && !empty($itens)): ?>
            // Se já tem itens, desabilitar empresa e remover required
            $empresaSelect.prop('disabled', true);
            $empresaSelect.removeAttr('required');
        <?php endif; ?>

        // Carregar clientes e produtos quando a empresa for selecionada
        $empresaSelect.on('change', function () {
            const empresaId = $(this).val();

            // Se o campo estiver desabilitado (cliente selecionado ou tem itens), não permitir mudança
            if ($(this).prop('disabled')) {
                console.log('Empresa desabilitada, restaurando valor anterior:', empresaIdAnterior);
                $(this).val(empresaIdAnterior);
                return false;
            }

            // Atualizar empresa anterior
            empresaIdAnterior = empresaId;

            if (empresaId) {
                // Se houver cliente selecionado, limpar antes de mudar empresa
                if (selectedCustomer && $('#customer_id').val()) {
                    limparCliente();
                }
                console.log('Carregando clientes e produtos para empresa:', empresaId);
                carregarClientesPorEmpresa(empresaId);
                carregarProdutosPorEmpresa(empresaId);
            } else {
                clientesData = [];
                produtosData = [];
                limparCliente();
            }
        });

        // Carregar clientes e produtos se já houver empresa selecionada ao carregar a página
        if (empresaIdAnterior) {
            console.log('Carregando clientes e produtos para empresa inicial:', empresaIdAnterior);
            carregarClientesPorEmpresa(empresaIdAnterior);
            carregarProdutosPorEmpresa(empresaIdAnterior);
        }

        // Ao digitar
        $search.on('input', function () {
            const query = $(this).val().trim().toLowerCase();

            clearTimeout(autocompleteTimeout);

            if (query.length < 2) {
                $dropdown.hide();
                return;
            }

            autocompleteTimeout = setTimeout(() => {
                buscarClientes(query);
            }, 300);
        });

        // Ao clicar fora, fechar dropdown
        $(document).on('click', function (e) {
            if (!$(e.target).closest('#customer_search, #customer_dropdown').length) {
                $dropdown.hide();
            }
        });

        // Ao focar no campo
        $search.on('focus', function () {
            if ($(this).val().length >= 2) {
                buscarClientes($(this).val().trim().toLowerCase());
            }
        });

        // Ao perder o foco (blur), bloquear empresa se cliente estiver selecionado
        // e preencher vendedores se existirem no cliente
        $search.on('blur', function () {
            if (selectedCustomer && $('#customer_id').val()) {
                $empresaSelect.prop('disabled', true);
                $empresaSelect.removeAttr('required'); // Remover required quando desabilitado
                // Preencher vendedores se ainda não foram preenchidos
                preencherVendedoresCliente(selectedCustomer);

                // Buscar e exibir licenças do cliente
                buscarLicencasCliente($('#customer_id').val());
            }
        });

        // Ao pressionar Enter, apenas prevenir submit
        $search.on('keydown', function (e) {
            if (e.key === 'Enter') {
                e.preventDefault();
            }
        });

        // Carregar cliente existente se estiver editando
        <?php if ($isEdit && !empty($venda['customer_id'])): ?>
            // Aguardar carregar clientes antes de selecionar
            setTimeout(() => {
                const clienteInicial = clientesData.find(c => c.id == <?= $venda['customer_id'] ?>);
                if (clienteInicial) {
                    selecionarCliente(clienteInicial);
                }
            }, 500);
        <?php endif; ?>
    }

    function carregarClientesPorEmpresa(empresaId) {
        if (!empresaId) {
            console.log('Empresa ID não fornecido');
            clientesData = [];
            return;
        }

        console.log('Carregando clientes para empresa:', empresaId);

        $.ajax({
            url: '<?= url("/vendas/buscar-clientes-por-empresa") ?>',
            method: 'GET',
            data: { empresa_id: empresaId },
            dataType: 'json',
            success: function (response) {
                console.log('Resposta do servidor:', response);
                if (response.success && response.data && response.data.clientes) {
                    clientesData = response.data.clientes;
                    console.log('Clientes carregados:', clientesData.length);
                    console.log('Primeiros clientes:', clientesData.slice(0, 3));
                } else {
                    clientesData = [];
                    console.log('Nenhum cliente encontrado para a empresa selecionada. Resposta:', response);
                }
            },
            error: function (xhr, status, error) {
                console.error('Erro ao carregar clientes:', error);
                console.error('Status:', status);
                console.error('Response:', xhr.responseText);
                clientesData = [];
            }
        });
    }

    function carregarProdutosPorEmpresa(empresaId) {
        if (!empresaId) {
            console.log('Empresa ID não fornecido para produtos');
            produtosData = [];
            return;
        }

        console.log('Carregando produtos para empresa:', empresaId);

        $.ajax({
            url: '<?= url("/vendas/buscar-produtos-por-empresa") ?>',
            method: 'GET',
            data: { empresa_id: empresaId },
            dataType: 'json',
            success: function (response) {
                console.log('Resposta do servidor (produtos):', response);
                if (response.success && response.data && response.data.produtos) {
                    produtosData = response.data.produtos;
                    console.log('Produtos carregados:', produtosData.length);
                    console.log('Primeiros produtos:', produtosData.slice(0, 3));
                } else {
                    produtosData = [];
                    console.log('Nenhum produto encontrado para a empresa selecionada. Resposta:', response);
                }
            },
            error: function (xhr, status, error) {
                console.error('Erro ao carregar produtos:', error);
                console.error('Status:', status);
                console.error('Response:', xhr.responseText);
                produtosData = [];
            }
        });
    }

    function buscarLicencasCliente(clienteId) {
        if (!clienteId) {
            return;
        }

        $.ajax({
            url: '<?= url("/vendas/buscar-licencas-cliente") ?>',
            method: 'GET',
            data: { cliente_id: clienteId },
            dataType: 'json',
            success: function (response) {
                if (response.success && response.data) {
                    const licencas = response.data.licencas || {};
                    const limiteCredito = parseFloat(response.data.limite_credito || 0);
                    const limiteUtilizado = parseFloat(response.data.limite_utilizado || 0);
                    const limiteDisponivel = parseFloat(response.data.limite_disponivel || 0);
                    const situacao = response.data.situacao || 'regular';
                    const totalVencido = parseFloat(response.data.total_vencido || 0);
                    const contasVencidas = parseInt(response.data.contas_vencidas || 0);

                    // Formatar datas para exibição
                    const formatarData = (data) => {
                        if (!data || data === '0000-00-00' || data === null) {
                            return '<span class="text-muted">Não informado</span>';
                        }
                        const date = new Date(data + 'T00:00:00');
                        return '<strong>' + date.toLocaleDateString('pt-BR') + '</strong>';
                    };

                    // Formatar valor monetário
                    const formatarMoeda = (valor) => {
                        return new Intl.NumberFormat('pt-BR', {
                            style: 'currency',
                            currency: 'BRL'
                        }).format(valor);
                    };

                    const dataAnvisa = formatarData(licencas.data_anvisa);
                    const dataConselhoFarmacia = formatarData(licencas.data_conselho_farmacia);
                    const dataVigilanciaSanitaria = formatarData(licencas.data_vigilancia_sanitaria);
                    const dataAlvaraLocalizacao = formatarData(licencas.data_alvara_localizacao);

                    // Determinar cor e ícone da situação
                    const situacaoInfo = situacao === 'inadimplente'
                        ? { texto: 'Inadimplente', cor: 'text-danger', icone: 'bi-exclamation-triangle-fill', badge: 'badge-danger' }
                        : { texto: 'Regular', cor: 'text-success', icone: 'bi-check-circle-fill', badge: 'badge-success' };

                    // Determinar cor do limite disponível
                    const corLimiteDisponivel = limiteDisponivel < 0 ? 'text-danger' : (limiteDisponivel < (limiteCredito * 0.1) ? 'text-warning' : 'text-success');

                    // Montar HTML para o SweetAlert
                    const html = `
                        <div class="text-start">
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="fw-semibold">Situação do Cliente:</span>
                                    <span class="badge ${situacaoInfo.badge}">
                                        <i class="bi ${situacaoInfo.icone} me-1"></i>${situacaoInfo.texto}
                                    </span>
                                </div>
                                ${situacao === 'inadimplente' && contasVencidas > 0 ? `
                                <div class="mt-2">
                                    <small class="text-muted">
                                        <i class="bi bi-info-circle me-1"></i>
                                        ${contasVencidas} conta(s) vencida(s) - Total: ${formatarMoeda(totalVencido)}
                                    </small>
                                </div>
                                ` : ''}
                            </div>
                            <hr class="my-3">
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="fw-semibold">Data ANVISA:</span>
                                    ${dataAnvisa}
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="fw-semibold">Data Conselho de Farmácia:</span>
                                    ${dataConselhoFarmacia}
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="fw-semibold">Data Vigilância Sanitária:</span>
                                    ${dataVigilanciaSanitaria}
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="fw-semibold">Data Alvará de Localização:</span>
                                    ${dataAlvaraLocalizacao}
                                </div>
                            </div>
                            ${limiteCredito > 0 ? `
                            <hr class="my-3">
                            <div class="mb-3">
                                <h6 class="text-primary mb-3"><i class="bi bi-credit-card me-2"></i> Limite de Crédito</h6>
                                <div class="mb-2">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <span class="fw-semibold">Limite de Crédito:</span>
                                        <strong class="text-primary">${formatarMoeda(limiteCredito)}</strong>
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <span class="fw-semibold">Limite Usado:</span>
                                        <strong class="text-warning">${formatarMoeda(limiteUtilizado)}</strong>
                                    </div>
                                </div>
                                <div class="mb-0">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <span class="fw-semibold">Limite Disponível:</span>
                                        <strong class="${corLimiteDisponivel}">${formatarMoeda(limiteDisponivel)}</strong>
                                    </div>
                                </div>
                            </div>
                            ` : ''}
                        </div>
                    `;

                    Swal.fire({
                        icon: 'info',
                        title: 'Licenças e Registros do Cliente',
                        html: html,
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#0066CC',
                        width: '500px'
                    });
                }
            },
            error: function (xhr, status, error) {
                console.error('Erro ao buscar licenças do cliente:', error);
            }
        });
    }

    function buscarClientes(query) {
        const $dropdown = $('#customer_dropdown');

        // Filtrar clientes
        const results = clientesData.filter(cliente => {
            const name = (cliente.name || '').toLowerCase();
            const tradeName = (cliente.trade_name || '').toLowerCase();
            const document = (cliente.document || '').toLowerCase();
            const email = (cliente.email || '').toLowerCase();
            const phone = (cliente.phone || '').toLowerCase();
            const mobile = (cliente.mobile || '').toLowerCase();

            // Normalizar query e documento para busca mais flexível
            const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
            const normalizedDocument = document.replace(/[^\d\w]/g, '').toLowerCase();

            return name.includes(query) || tradeName.includes(query) ||
                document.includes(query) || normalizedDocument.includes(normalizedQuery) ||
                email.includes(query) || phone.includes(query) || mobile.includes(query);
        });

        // Montar HTML
        let html = '';

        if (results.length > 0) {
            results.forEach(cliente => {
                const nomeFantasia = cliente.trade_name || '-';
                const razaoSocial = cliente.name || '-';
                const documento = cliente.document || 'Não informado';
                const codigo = String(cliente.id).padStart(4, '0');
                const telefone = cliente.phone || cliente.mobile || '-';
                const email = cliente.email || '-';

                html += `
                <div class="autocomplete-item" data-id="${cliente.id}">
                    <div class="mb-1">
                        <strong>Código: ${codigo}</strong>  |  <strong>CNPJ/CPF:</strong> ${documento}
                    </div>
                    <div class="mb-1">
                        <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                    </div>
                    <div class="text-muted small">
                        <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                    </div>
                </div>
            `;
            });
        } else {
            html = '<div class="autocomplete-no-results">Nenhum cliente encontrado</div>';
        }

        $dropdown.html(html).show();

        // Event listeners
        $dropdown.find('.autocomplete-item').on('click', function () {
            const clienteId = $(this).data('id');
            const cliente = clientesData.find(c => c.id == clienteId);
            if (cliente) {
                selecionarCliente(cliente);
            }
        });
    }

    function selecionarCliente(cliente) {
        selectedCustomer = cliente;

        const nomeFantasia = cliente.trade_name || '-';
        const razaoSocial = cliente.name || '-';
        const nomeExibir = nomeFantasia !== '-' ? nomeFantasia : razaoSocial;
        const codigo = String(cliente.id).padStart(4, '0');
        const documento = cliente.document || 'Não informado';
        const telefone = cliente.phone || cliente.mobile || '-';
        const email = cliente.email || '-';

        // Preencher campos hidden
        $('#customer_id').val(cliente.id);
        $('#customer_type').val('pessoa');
        $('#customer_name').val(razaoSocial);
        $('#customer_document').val(cliente.document || '');

        // Guardar tabela de preço do cliente para busca de preços
        selectedCustomer.tabela_preco_id = cliente.tabela_preco_id || null;

        // Atualizar campo de busca
        $('#customer_search').val(nomeExibir);

        // Bloquear seletor de empresa quando cliente for selecionado
        $('#empresa_id').prop('disabled', true);

        // Preencher vendedores do cliente
        preencherVendedoresCliente(cliente);

        // Mostrar info do cliente no formato estruturado
        let infoHtml = `
        <div style="line-height: 1.6;">
            <div class="mb-1">
                <strong>Código: ${codigo}</strong>  |  ${documento}
            </div>
            <div class="mb-1">
                <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
            </div>
            <div class="text-muted small">
                <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
            </div>
        </div>
    `;

        $('#customer_info_name').html(infoHtml);
        $('#customer_info_document').text('');
        $('#customer_info_email').text('');

        $('#customer_info').slideDown();

        // Fechar dropdown
        $('#customer_dropdown').hide();
    }

    function preencherVendedoresCliente(cliente) {
        const vendedorPrincipalId = cliente.vendedor_id || null;
        const vendedorAuxiliarId = cliente.vendedor_auxiliar_id || null;

        // Preencher vendedor principal
        if (vendedorPrincipalId) {
            const $vendorPrincipal = $('#vendor_id');
            // Verificar se a opção existe antes de definir
            if ($vendorPrincipal.find(`option[value="${vendedorPrincipalId}"]`).length > 0) {
                $vendorPrincipal.val(vendedorPrincipalId).trigger('change');
                console.log('Vendedor principal preenchido do cliente:', vendedorPrincipalId);
            }
        } else {
            // Se não houver vendedor no cliente, usar o usuário logado
            const userIdLogado = <?= json_encode($user['id'] ?? null) ?>;
            if (userIdLogado) {
                const $vendorPrincipal = $('#vendor_id');
                // Verificar se a opção existe antes de definir
                if ($vendorPrincipal.find(`option[value="${userIdLogado}"]`).length > 0) {
                    $vendorPrincipal.val(userIdLogado).trigger('change');
                    console.log('Vendedor principal preenchido com usuário logado:', userIdLogado);
                } else {
                    console.log('Usuário logado não encontrado na lista de vendedores:', userIdLogado);
                }
            }
        }

        // Preencher vendedor auxiliar se existir
        if (vendedorAuxiliarId) {
            const $vendorAuxiliar = $('#auxiliary_vendor_id');
            // Verificar se a opção existe antes de definir
            if ($vendorAuxiliar.find(`option[value="${vendedorAuxiliarId}"]`).length > 0) {
                $vendorAuxiliar.val(vendedorAuxiliarId).trigger('change');
                console.log('Vendedor auxiliar preenchido do cliente:', vendedorAuxiliarId);
            }
        }
    }

    function limparCliente() {
        selectedCustomer = null;

        $('#customer_id').val('');
        $('#customer_type').val('pessoa');
        $('#customer_name').val('');
        $('#customer_document').val('');
        $('#customer_search').val('');

        // Desbloquear seletor de empresa quando cliente for limpo
        $('#empresa_id').prop('disabled', false);
        // Adicionar required de volta se não houver itens
        if (itensTabela.length === 0) {
            $('#empresa_id').attr('required', 'required');
        }

        $('#customer_info').slideUp();
    }

    function inicializarFormularioVenda() {
        // Inicializar autocomplete de clientes
        inicializarAutocompleteCliente();

        // Calcular valores quando houver mudança
        $('#discount, #discount_type, #freight_value').on('input change', function () {
            calcularTotalGeral();
        });

        if (usarLoteVenda) {
            resetLoteSelect();
            $('#lote_principal').on('change', function () {
                const $option = $(this).find('option:selected');
                const value = $(this).val();
                if (value) {
                    selectedLote = {
                        lote: value,
                        fabricacao: $option.data('fabricacao') || '',
                        validade: $option.data('validade') || ''
                    };
                } else {
                    selectedLote = null;
                }
            });
        }

        // Evento ao selecionar método de pagamento
        $('#payment_method_id').on('change', function () {
            const metodoId = $(this).val();

            // Limpar informação de parcelamento anterior
            $('#parcelamento-detalhes').html('<span class="text-muted">Nenhum parcelamento selecionado</span>');
            $('#installments').val(1);

            if (metodoId) {
                mostrarPrazosMetodoPagamento(metodoId);
            } else {
                // Se não houver método selecionado, mostrar mensagem padrão
                $('#parcelamento-detalhes').html('<span class="text-muted">Selecione um método de pagamento para ver as opções de parcelamento</span>');
            }
        });

        // Carregar parcelamento existente se estiver editando
        <?php if ($isEdit && !empty($venda['payment_method_id']) && !empty($venda['installments']) && $venda['installments'] > 1): ?>
            $(document).ready(function () {
                const metodoId = <?= $venda['payment_method_id'] ?>;
                const parcelas = <?= $venda['installments'] ?? 1 ?>;
                const totalFinal = parseFloat($('#total').val()) || parseFloat('<?= $venda['total'] ?? 0 ?>');

                if (parcelas > 1 && totalFinal > 0) {
                    // Buscar dias do prazo se houver payment_term_id
                    <?php if (!empty($venda['payment_term_id'])): ?>
                        $.ajax({
                            url: appUrl('/metodos-pagamento/buscar-prazos'),
                            method: 'GET',
                            data: {
                                metodo_id: metodoId
                            },
                            success: function (response) {
                                if (response.success && response.data.prazos && response.data.prazos.length >
                                    0) {
                                    const prazoEncontrado = response.data.prazos.find(p => Math.ceil(p.dias /
                                        30) === parcelas);
                                    const dias = prazoEncontrado ? prazoEncontrado.dias : (parcelas * 30);

                                    // Calcular valores das parcelas
                                    const valorParcela = totalFinal / parcelas;
                                    const valorParcelaInteiro = Math.floor(valorParcela * 100) / 100;
                                    const valorUltimaParcela = totalFinal - (valorParcelaInteiro * (parcelas -
                                        1));

                                    // Montar descrição
                                    let descricaoDetalhada = '';
                                    if (parcelas === 1) {
                                        descricaoDetalhada =
                                            `<strong>${parcelas}x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
                                    } else {
                                        if (Math.abs(valorUltimaParcela - valorParcelaInteiro) < 0.01) {
                                            descricaoDetalhada =
                                                `<strong>${parcelas}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
                                        } else {
                                            descricaoDetalhada =
                                                `<strong>${parcelas - 1}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> + <strong>1x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
                                        }
                                    }

                                    $('#parcelamento-detalhes').html(descricaoDetalhada);
                                }
                            }
                        });
                    <?php else: ?>
                        // Se não houver payment_term_id, usar cálculo padrão
                        const dias = parcelas * 30;
                        const valorParcela = totalFinal / parcelas;
                        const valorParcelaInteiro = Math.floor(valorParcela * 100) / 100;
                        const valorUltimaParcela = totalFinal - (valorParcelaInteiro * (parcelas - 1));

                        let descricaoDetalhada = '';
                        if (parcelas === 1) {
                            descricaoDetalhada =
                                `<strong>${parcelas}x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong>`;
                        } else {
                            if (Math.abs(valorUltimaParcela - valorParcelaInteiro) < 0.01) {
                                descricaoDetalhada =
                                    `<strong>${parcelas}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong>`;
                            } else {
                                descricaoDetalhada =
                                    `<strong>${parcelas - 1}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> + <strong>1x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong>`;
                            }
                        }

                        $('#parcelamento-detalhes').html(descricaoDetalhada);
                    <?php endif; ?>
                }
            });
        <?php endif; ?>

        // Validação de vendedores - não permitir mesmo vendedor em ambos campos
        function atualizarSelectsVendedores() {
            const vendorPrincipal = $('#vendor_id').val();
            const vendorAuxiliar = $('#auxiliary_vendor_id').val();

            // Atualizar select do vendedor auxiliar
            $('#auxiliary_vendor_id option').each(function () {
                const optionValue = $(this).val();
                if (optionValue && optionValue === vendorPrincipal) {
                    $(this).prop('disabled', true);
                } else {
                    $(this).prop('disabled', false);
                }
            });

            // Atualizar select do vendedor principal
            $('#vendor_id option').each(function () {
                const optionValue = $(this).val();
                if (optionValue && optionValue === vendorAuxiliar) {
                    $(this).prop('disabled', true);
                } else {
                    $(this).prop('disabled', false);
                }
            });

            // Se ambos forem iguais, limpar o auxiliar e mostrar aviso
            if (vendorPrincipal && vendorAuxiliar && vendorPrincipal === vendorAuxiliar) {
                $('#auxiliary_vendor_id').val('');
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'O vendedor principal e o vendedor auxiliar não podem ser a mesma pessoa!',
                    toast: true,
                    position: 'top-end',
                    timer: 3000,
                    showConfirmButton: false
                });
            }
        }

        $('#vendor_id, #auxiliary_vendor_id').on('change', atualizarSelectsVendedores);

        // Executar na inicialização para garantir estado correto
        atualizarSelectsVendedores();

        // Ocultar tabela inicialmente apenas se não for edição
        <?php if (!$isEdit || empty($itens)): ?>
            $('#tabela-itens').hide();
            $('#alert-sem-itens').show();
        <?php else: ?>
            $('#tabela-itens').show();
            $('#alert-sem-itens').hide();
        <?php endif; ?>

        // Inicializar autocomplete de item principal
        inicializarAutocompleteItemPrincipal();

        // Atualizar bloqueio de campos na inicialização
        atualizarBloqueioCampos();

        // Calcular total ao mudar campos do item principal
        $('#qtd_principal, #preco_principal, #desconto_principal').on('input', function () {
            calcularTotalPrincipal();
        });

        // Carregar itens existentes se estiver editando
        <?php if ($isEdit && !empty($itens)): ?>
            <?php foreach ($itens as $index => $item): ?>
                const itemCarregado_<?= $index ?> = <?= json_encode($item) ?>;
                adicionarItemNaTabela(itemCarregado_<?= $index ?>, true);
            <?php endforeach; ?>
            calcularTotalGeral();
            // Atualizar bloqueio após carregar itens existentes
            atualizarBloqueioCampos();
            // Garantir que required seja removido de campos desabilitados após carregar itens
            $('#empresa_id, #customer_search, #vendor_id, #auxiliary_vendor_id').each(function () {
                if ($(this).prop('disabled')) {
                    $(this).removeAttr('required');
                }
            });
        <?php else: ?>
        <?php endif; ?>

        // Calcular totais ao inicializar (para preencher os campos mesmo sem itens)
        calcularTotalGeral();
    }

    function atualizarBloqueioCampos() {
        const temItens = itensTabela.length > 0;
        const $empresaSelect = $('#empresa_id');

        // Bloquear/desbloquear campo de cliente
        $('#customer_search').prop('disabled', temItens);

        // Bloquear/desbloquear vendedor principal
        $('#vendor_id').prop('disabled', temItens);

        // Bloquear/desbloquear vendedor auxiliar
        $('#auxiliary_vendor_id').prop('disabled', temItens);

        // Bloquear/desbloquear empresa quando houver itens
        if (temItens) {
            $empresaSelect.prop('disabled', true);
            // Remover required quando desabilitado para evitar erro de validação HTML5
            $empresaSelect.removeAttr('required');
        } else if (!$('#customer_id').val()) {
            // Não tem itens e não tem cliente selecionado, pode habilitar e adicionar required
            // Mas verificar se não está bloqueado por outro motivo
            const estaBloqueadoPorCliente = false; // Já verificado acima
            if (!estaBloqueadoPorCliente) {
                $empresaSelect.prop('disabled', false);
                $empresaSelect.attr('required', 'required');
            }
        }

        if (temItens) {
            console.log('Campos bloqueados - há itens na venda');
        } else {
            console.log('Campos desbloqueados - nenhum item na venda');
        }
    }

    // ============================================
    // AUTOCOMPLETE E GERENCIAMENTO DE ITENS
    // ============================================
    function inicializarAutocompleteItemPrincipal() {
        const $search = $('#item_search_principal');
        const $dropdown = $('#item_dropdown_principal');

        $search.on('input', function () {
            const query = $(this).val().trim().toLowerCase();
            clearTimeout(itemTimeoutPrincipal);

            if (query.length < 2) {
                $dropdown.hide();
                return;
            }

            itemTimeoutPrincipal = setTimeout(() => {
                buscarProdutosPrincipal(query);
            }, 300);
        });

        $search.on('focus', function () {
            if ($(this).val().length >= 2) {
                buscarProdutosPrincipal($(this).val().trim().toLowerCase());
            }
        });

        $search.on('keydown', function (e) {
            if (e.key === 'Enter') {
                e.preventDefault();
            }
        });

        $(document).on('click', function (e) {
            if (!$(e.target).closest('#item_search_principal, #item_dropdown_principal').length) {
                $dropdown.hide();
            }
        });
    }

    function buscarProdutosPrincipal(query) {
        const $dropdown = $('#item_dropdown_principal');
        const results = produtosData.filter(produto => {
            const name = (produto.name || '').toLowerCase();
            const sku = (produto.sku || '').toLowerCase();
            return name.includes(query) || sku.includes(query);
        });

        let html = '';
        if (results.length > 0) {
            results.forEach(produto => {
                const estoque = produto.stock_quantity || 0;
                const preco = parseFloat(produto.price || 0);
                html += `
                <div class="autocomplete-item" data-id="${produto.id}">
                    <div class="mb-1"><strong>${produto.name}</strong>${produto.sku ? ' <span class="text-muted">(' + produto.sku + ')</span>' : ''}</div>
                    <div class="text-muted small"><strong>Preço:</strong> R$ ${preco.toFixed(2).replace('.', ',')}  |  <strong>Estoque:</strong> ${estoque} ${produto.unit || 'un'}</div>
                </div>
            `;
            });
        } else {
            html = '<div class="autocomplete-no-results">Nenhum produto encontrado</div>';
        }

        $dropdown.html(html).show();

        $dropdown.find('.autocomplete-item').on('click', function () {
            const produtoId = $(this).data('id');
            const produto = produtosData.find(p => p.id == produtoId);
            if (produto) {
                selecionarProdutoPrincipal(produto);
            }
        });
    }

    function selecionarProdutoPrincipal(produto) {
        selectedProduto = {
            ...produto
        };
        selectedProduto.lotes = Array.isArray(produto.lotes) ? [...produto.lotes] : [];
        selectedProduto.fracionado = parseInt(produto.fracionado) || 0;
        selectedProduto.quantidade_embalagem = parseInt(produto.quantidade_embalagem) || 1;
        $('#produto_id_principal').val(produto.id);

        // Mostrar alerta se produto vem em embalagem com múltiplas unidades
        if (selectedProduto.quantidade_embalagem > 1) {
            // Obter nome do vendedor selecionado
            const vendorSelect = document.getElementById('vendor_id');
            const vendedorNome = vendorSelect && vendorSelect.options[vendorSelect.selectedIndex]
                ? vendorSelect.options[vendorSelect.selectedIndex].text
                : 'Vendedor';

            Swal.fire({
                icon: 'info',
                title: 'Atenção!',
                html: `<p><strong>Atenção ${vendedorNome}!</strong></p>
                       <p>Este produto contém <strong>[${selectedProduto.quantidade_embalagem}] unidades por caixa</strong>.</p>`,
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'Entendi'
            });
        }
        $('#item_search_principal').val(produto.name);
        $('#item_dropdown_principal').hide();

        // Buscar preço considerando tabela de preço do cliente
        const tabelaPrecoId = selectedCustomer?.tabela_preco_id || null;
        buscarPrecoProduto(produto.id, tabelaPrecoId, produto.price);

        $('#qtd_principal').focus().select();

        if (usarLoteVenda) {
            preencherLotesProduto(produto);
        }

        // Armazenar dados fiscais do produto
        selectedProduto.fiscal = {
            ncm: produto.ncm || '',
            cest: produto.cest || '',
            cfop: produto.cfop || '',
            origem: produto.origem || '',
            cst_icms: produto.cst_icms || '',
            aliquota_icms: produto.aliquota_icms || 0,
            cst_pis: produto.cst_pis || '',
            aliquota_pis: produto.aliquota_pis || 0,
            cst_cofins: produto.cst_cofins || '',
            aliquota_cofins: produto.aliquota_cofins || 0,
            cst_ipi: produto.cst_ipi || '',
            aliquota_ipi: produto.aliquota_ipi || 0,
            cclass: produto.cclass || '000001',
            aliquota_ibs: produto.aliquota_ibs || 0,
            reducao_aliquota_ibs: produto.reducao_aliquota_ibs || 0,
            aliquota_cbs: produto.aliquota_cbs || 0,
            reducao_aliquota_cbs: produto.reducao_aliquota_cbs || 0,
            aliquota_ibs_municipal: produto.aliquota_ibs_municipal || 0,
            reducao_aliquota_ibs_municipal: produto.reducao_aliquota_ibs_municipal || 0
        };
    }

    // Busca o preco do produto considerando a tabela de preco do cliente
    function buscarPrecoProduto(produtoId, tabelaPrecoId, precoPadrao) {
        // Se nao tiver tabela de preco do cliente, usar preco padrao
        if (!tabelaPrecoId) {
            $('#preco_principal').val(parseFloat(precoPadrao || 0).toFixed(2));
            calcularTotalPrincipal();
            return;
        }

        // Buscar preco via API
        $.ajax({
            url: appUrl('/vendas/buscar-preco-produto'),
            method: 'GET',
            data: {
                produto_id: produtoId,
                tabela_preco_id: tabelaPrecoId,
                quantidade: parseInt($('#qtd_principal').val()) || 1
            },
            success: function (response) {
                if (response.success && response.data && response.data.preco !== undefined) {
                    var preco = parseFloat(response.data.preco);
                    $('#preco_principal').val(preco.toFixed(2));
                } else {
                    $('#preco_principal').val(parseFloat(precoPadrao || 0).toFixed(2));
                }
                calcularTotalPrincipal();
            },
            error: function () {
                $('#preco_principal').val(parseFloat(precoPadrao || 0).toFixed(2));
                calcularTotalPrincipal();
            }
        });
    }

    function resetLoteSelect() {
        if (!usarLoteVenda) {
            return;
        }
        const $select = $('#lote_principal');
        if (!$select.length) {
            return;
        }
        $select.html('<option value="">Selecione o lote</option>');
        $select.prop('disabled', true);
        selectedLote = null;
    }

    function preencherLotesProduto(produto) {
        const $select = $('#lote_principal');
        if (!usarLoteVenda || !$select.length) {
            return;
        }

        resetLoteSelect();

        const lotes = produto?.lotes || [];
        if (!Array.isArray(lotes) || lotes.length === 0) {
            return;
        }

        lotes.forEach(lote => {
            if (!lote || !lote.lote) {
                return;
            }
            const validade = lote.validade ? new Date(lote.validade + 'T00:00:00').toLocaleDateString('pt-BR') :
                'Sem validade';
            const fabricacao = lote.fabricacao ? new Date(lote.fabricacao + 'T00:00:00').toLocaleDateString(
                'pt-BR') : null;
            const saldo = typeof lote.saldo !== 'undefined' ? parseFloat(lote.saldo).toFixed(3) : null;

            let label = `${lote.lote}`;
            if (saldo) {
                label += ` • Saldo: ${saldo}`;
            }
            if (validade && validade !== 'Invalid Date') {
                label += ` • Val.: ${validade}`;
            }
            if (fabricacao && fabricacao !== 'Invalid Date') {
                label += ` • Fab.: ${fabricacao}`;
            }

            const $option = $('<option>')
                .val(lote.lote)
                .text(label)
                .attr('data-fabricacao', lote.fabricacao || '')
                .attr('data-validade', lote.validade || '')
                .attr('data-saldo', saldo || '');

            $select.append($option);
        });

        $select.prop('disabled', false).val('');
        selectedLote = null;
    }

    function calcularTotalPrincipal() {
        const qtd = parseFloat($('#qtd_principal').val()) || 0;
        const preco = parseFloat($('#preco_principal').val()) || 0;
        const desconto = parseFloat($('#desconto_principal').val()) || 0;
        const total = (qtd * preco) - desconto;
        $('#total_principal').val(total.toFixed(2));
    }

    function formatarDataSimples(data) {
        if (!data) {
            return '';
        }
        const dateObj = new Date(data + 'T00:00:00');
        if (Number.isNaN(dateObj.getTime())) {
            return '';
        }
        return dateObj.toLocaleDateString('pt-BR');
    }

    function renderObservacoesCell(item) {
        const notas = (item.notes && item.notes.trim()) ? escapeHtml(item.notes) : '-';
        if (!usarLoteVenda || !item.lote) {
            return notas;
        }

        const fabricacao = formatarDataSimples(item.fabricacao);
        const validade = formatarDataSimples(item.validade);

        let detalhesHtml = `<div class="text-muted small mt-1">Lote: ${escapeHtml(item.lote)}`;
        if (fabricacao) {
            detalhesHtml += ` • Fab.: ${fabricacao}`;
        }
        if (validade) {
            detalhesHtml += ` • Val.: ${validade}`;
        }
        detalhesHtml += '</div>';

        if (notas === '-' || notas === '') {
            return detalhesHtml || '-';
        }
        return `${notas}${detalhesHtml}`;
    }

    function adicionarItemNaTabela(itemData = null, isLoad = false) {
        // Validar se cliente foi informado antes de permitir adicionar item
        if (!isLoad) {
            const customerId = $('#customer_id').val();
            const customerName = $('#customer_search').val();

            if (!customerId && !customerName) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Cliente não informado',
                    text: 'Por favor, selecione ou informe um cliente antes de adicionar itens à venda.',
                    confirmButtonColor: '#3085d6'
                });
                $('#customer_search').focus();
                return;
            }
        }

        let item;

        if (itemData) {
            // Se for carga de dados existentes (edição), garantir compatibilidade
            item = {
                product_id: itemData.product_id || '',
                product_name: itemData.product_name || '',
                product_sku: itemData.product_sku || '',
                quantity: itemData.quantity || 1,
                unit_price: itemData.unit_price || 0,
                discount: itemData.discount || 0,
                discount_type: itemData.discount_type || 'fixed',
                total_price: itemData.total_price || 0,
                notes: itemData.notes || '',
                ncm: itemData.ncm || '',
                cest: itemData.cest || '',
                cfop: itemData.cfop || '',
                origem: itemData.origem || '',
                cst_icms: itemData.cst_icms || '',
                aliquota_icms: itemData.aliquota_icms || 0,
                cst_pis: itemData.cst_pis || '',
                aliquota_pis: itemData.aliquota_pis || 0,
                cst_cofins: itemData.cst_cofins || '',
                aliquota_cofins: itemData.aliquota_cofins || 0,
                cst_ipi: itemData.cst_ipi || '',
                aliquota_ipi: itemData.aliquota_ipi || 0,
                cclass: itemData.cclass || '000001',
                aliquota_ibs: itemData.aliquota_ibs || 0,
                reducao_aliquota_ibs: itemData.reducao_aliquota_ibs || 0,
                aliquota_cbs: itemData.aliquota_cbs || 0,
                reducao_aliquota_cbs: itemData.reducao_aliquota_cbs || 0,
                aliquota_ibs_municipal: itemData.aliquota_ibs_municipal || 0,
                reducao_aliquota_ibs_municipal: itemData.reducao_aliquota_ibs_municipal || 0,
                numero_serie: itemData.numero_serie || '',
                lote: itemData.lote || '',
                fabricacao: itemData.fabricacao || '',
                validade: itemData.validade || '',
                vendedor_id: itemData.vendedor_id || '',
                profissional_id: itemData.profissional_id || itemData.vendedor_id || ''
            };
        } else {
            // Novo item do formulário

            // Validar se produto permite fracionamento
            const qtdDigitada = parseFloat($('#qtd_principal').val()) || 0;
            const produtoFracionado = selectedProduto?.fracionado || 0;

            if (produtoFracionado == 0 && qtdDigitada % 1 !== 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Quantidade inválida',
                    text: 'Este produto não pode ser fracionado. Informe uma quantidade inteira.',
                    confirmButtonColor: '#3085d6'
                });
                $('#qtd_principal').focus().select();
                return;
            }

            let loteSelecionado = '';
            let fabricacaoSelecionada = '';
            let validadeSelecionada = '';
            let numeroSerieSelecionado = '';

            if (usarLoteVenda) {
                const $loteSelect = $('#lote_principal');
                const lotesDisponiveis = selectedProduto?.lotes || [];

                if (Array.isArray(lotesDisponiveis) && lotesDisponiveis.length > 0 && !$loteSelect.val()) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Selecione o lote',
                        text: 'Escolha o lote para este produto antes de adicionar.'
                    });
                    $loteSelect.focus();
                    return;
                }

                if ($loteSelect.val()) {
                    const $option = $loteSelect.find('option:selected');
                    loteSelecionado = $loteSelect.val() || '';
                    fabricacaoSelecionada = $option.data('fabricacao') || '';
                    validadeSelecionada = $option.data('validade') || '';
                    numeroSerieSelecionado = $option.data('numero-serie') || '';
                }
            }

            item = {
                product_id: $('#produto_id_principal').val() || '',
                product_name: $('#item_search_principal').val() || '',
                product_sku: selectedProduto?.sku || '',
                quantity: $('#qtd_principal').val() || 1,
                unit_price: $('#preco_principal').val() || 0,
                discount: $('#desconto_principal').val() || 0,
                discount_type: 'fixed',
                total_price: $('#total_principal').val() || 0,
                notes: $('#obs_principal').val() || '',
                ncm: selectedProduto?.fiscal?.ncm || '',
                cest: selectedProduto?.fiscal?.cest || '',
                cfop: selectedProduto?.fiscal?.cfop || '',
                origem: selectedProduto?.fiscal?.origem || '',
                cst_icms: selectedProduto?.fiscal?.cst_icms || '',
                aliquota_icms: selectedProduto?.fiscal?.aliquota_icms || 0,
                cst_pis: selectedProduto?.fiscal?.cst_pis || '',
                aliquota_pis: selectedProduto?.fiscal?.aliquota_pis || 0,
                cst_cofins: selectedProduto?.fiscal?.cst_cofins || '',
                aliquota_cofins: selectedProduto?.fiscal?.aliquota_cofins || 0,
                cst_ipi: selectedProduto?.fiscal?.cst_ipi || '',
                aliquota_ipi: selectedProduto?.fiscal?.aliquota_ipi || 0,
                cclass: selectedProduto?.fiscal?.cclass || '000001',
                aliquota_ibs: selectedProduto?.fiscal?.aliquota_ibs || 0,
                reducao_aliquota_ibs: selectedProduto?.fiscal?.reducao_aliquota_ibs || 0,
                aliquota_cbs: selectedProduto?.fiscal?.aliquota_cbs || 0,
                reducao_aliquota_cbs: selectedProduto?.fiscal?.reducao_aliquota_cbs || 0,
                aliquota_ibs_municipal: selectedProduto?.fiscal?.aliquota_ibs_municipal || 0,
                reducao_aliquota_ibs_municipal: selectedProduto?.fiscal?.reducao_aliquota_ibs_municipal || 0,
                numero_serie: numeroSerieSelecionado,
                lote: loteSelecionado,
                fabricacao: fabricacaoSelecionada,
                validade: validadeSelecionada,
                vendedor_id: comissaoFuncionarioItem ? ($('#vendedor_principal').val() || '') : '',
                profissional_id: $('#vendedor_principal').val() || ''
            };
        }

        item.quantity = parseFloat(item.quantity) || 0;
        item.unit_price = parseFloat(item.unit_price) || 0;
        item.discount = parseFloat(item.discount) || 0;
        item.total_price = parseFloat(item.total_price) || (item.quantity * item.unit_price) - item.discount;

        if (!item.product_name && !item.product_id) {
            if (!isLoad) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Selecione ou digite um item!'
                });
                $('#item_search_principal').focus();
            }
            return;
        }

        const index = itensTabela.length;
        itensTabela.push(item);

        const $tbody = $('#tbody-itens');

        // Montar select de profissionais se necessário
        let profissionalSelectHtml = '';
        if (comissaoFuncionarioItem && profissionaisItemData && profissionaisItemData.length > 0) {
            let optionsHtml = '<option value="">Selecione...</option>';
            const selectedVendedorId = item.vendedor_id || '';
            profissionaisItemData.forEach(prof => {
                const selected = (selectedVendedorId == prof.id) ? 'selected' : '';
                optionsHtml += `<option value="${prof.id}" ${selected}>${escapeHtml(prof.name)}</option>`;
            });
            profissionalSelectHtml = `
            <td>
                <select class="form-select form-select-sm item-vendedor-select"
                        name="itens[${index}][vendedor_id]"
                        data-item-index="${index}"
                        onchange="atualizarVendedorItem(${index}, this.value)">
                    ${optionsHtml}
                </select>
            </td>
        `;
        }

        // Escapar valores para evitar problemas de HTML injection
        const $row = $(`
        <tr data-index="${index}" style="cursor: pointer;" onclick="abrirOpcoesItem(${index}, event)">
            <td>${escapeHtml(item.product_name)}</td>
            ${profissionalSelectHtml}
            <td class="text-center">${parseFloat(item.quantity).toFixed(3)}</td>
            <td class="text-end">R$ ${parseFloat(item.unit_price).toFixed(2)}</td>
            <td class="text-end">R$ ${parseFloat(item.discount).toFixed(2)}</td>
            <td class="text-end"><strong>R$ ${parseFloat(item.total_price).toFixed(2)}</strong></td>
            <td>${renderObservacoesCell(item)}</td>
            <input type="hidden" name="itens[${index}][product_id]" value="${escapeHtml(item.product_id)}">
            <input type="hidden" name="itens[${index}][product_name]" value="${escapeHtml(item.product_name)}">
            <input type="hidden" name="itens[${index}][product_sku]" value="${escapeHtml(item.product_sku)}">
            <input type="hidden" name="itens[${index}][quantity]" value="${item.quantity}">
            <input type="hidden" name="itens[${index}][unit_price]" value="${item.unit_price}">
            <input type="hidden" name="itens[${index}][discount]" value="${item.discount}">
            <input type="hidden" name="itens[${index}][discount_type]" value="fixed">
            <input type="hidden" name="itens[${index}][total_price]" value="${item.total_price}">
            <input type="hidden" name="itens[${index}][notes]" value="${escapeHtml(item.notes)}">
            <input type="hidden" name="itens[${index}][ncm]" value="${escapeHtml(item.ncm)}">
            <input type="hidden" name="itens[${index}][cest]" value="${escapeHtml(item.cest)}">
            <input type="hidden" name="itens[${index}][cfop]" value="${escapeHtml(item.cfop)}">
            <input type="hidden" name="itens[${index}][origem]" value="${escapeHtml(item.origem)}">
            <input type="hidden" name="itens[${index}][cst_icms]" value="${escapeHtml(item.cst_icms)}">
            <input type="hidden" name="itens[${index}][aliquota_icms]" value="${item.aliquota_icms || 0}">
            <input type="hidden" name="itens[${index}][cst_pis]" value="${escapeHtml(item.cst_pis)}">
            <input type="hidden" name="itens[${index}][aliquota_pis]" value="${item.aliquota_pis || 0}">
            <input type="hidden" name="itens[${index}][cst_cofins]" value="${escapeHtml(item.cst_cofins)}">
            <input type="hidden" name="itens[${index}][aliquota_cofins]" value="${item.aliquota_cofins || 0}">
            <input type="hidden" name="itens[${index}][cst_ipi]" value="${escapeHtml(item.cst_ipi)}">
            <input type="hidden" name="itens[${index}][aliquota_ipi]" value="${item.aliquota_ipi || 0}">
            <input type="hidden" name="itens[${index}][numero_serie]" value="${escapeHtml(item.numero_serie || '')}">
            <input type="hidden" name="itens[${index}][lote]" value="${escapeHtml(item.lote || '')}">
            <input type="hidden" name="itens[${index}][fabricacao]" value="${escapeHtml(item.fabricacao || '')}">
            <input type="hidden" name="itens[${index}][validade]" value="${escapeHtml(item.validade || '')}">
            <input type="hidden" name="itens[${index}][profissional_id]" value="${item.profissional_id || ''}">
        </tr>
    `);

        $tbody.append($row);

        if (!isLoad) {
            limparCamposItem();
            calcularTotalGeral();
        }
        selectedLote = null;

        // Garantir que a tabela seja exibida e o alerta ocultado
        $('#alert-sem-itens').hide();
        $('#tabela-itens').show();

        // Bloquear campos quando houver itens
        atualizarBloqueioCampos();
    }

    function removerItemDaTabela(index) {
        Swal.fire({
            title: 'Remover item?',
            text: 'Deseja realmente remover este item da venda?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sim, remover',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                itensTabela.splice(index, 1);

                // Remover linha da tabela
                $(`#tbody-itens tr[data-index="${index}"]`).remove();

                // Reindexar
                $('#tbody-itens tr').each(function (i) {
                    $(this).attr('data-index', i);
                    $(this).attr('onclick', `abrirOpcoesItem(${i}, event)`);
                });

                // Reindexar inputs hidden
                $('#tbody-itens input[type="hidden"]').each(function (i) {
                    const input = $(this);
                    const name = input.attr('name').replace(/\[\d+\]/, `[${i}]`);
                    input.attr('name', name);
                });

                calcularTotalGeral();

                if (itensTabela.length === 0) {
                    $('#alert-sem-itens').show();
                    $('#tabela-itens').hide();
                }

                // Atualizar bloqueio de campos
                atualizarBloqueioCampos();

                Swal.fire({
                    icon: 'success',
                    title: 'Item removido',
                    text: 'O item foi removido da venda.',
                    timer: 1500,
                    showConfirmButton: false
                });
            }
        });
    }

    function abrirOpcoesItem(index, event) {
        // Prevenir que o evento se propague para elementos filhos
        if (event) {
            event.stopPropagation();
        }

        const item = itensTabela[index];
        if (!item) return;

        const itemName = escapeHtml(item.product_name || 'Item');
        const itemQtd = parseFloat(item.quantity || 0).toFixed(3);
        const itemTotal = 'R$ ' + parseFloat(item.total_price || 0).toFixed(2);

        const headerHtml = `
        <div style="background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);
                    padding: 1.5rem;
                    margin: 0 0 1rem 0;
                    border-radius: 12px 12px 0 0;
                    color: white;
                    text-align: left;">
            <div style="display: flex; align-items: center; gap: 1rem;">
                <div style="background: rgba(255,255,255,0.2);
                            padding: 0.75rem;
                            border-radius: 10px;
                            display: flex;
                            align-items: center;
                            justify-content: center;">
                    <i class="bi bi-box-seam" style="font-size: 1.5rem;"></i>
                </div>
                <div style="flex: 1;">
                    <div style="font-size: 0.85rem; opacity: 0.9; margin-bottom: 0.25rem;">Item</div>
                    <div style="font-size: 1.1rem; font-weight: 700;">${itemName}</div>
                </div>
                <div style="text-align: right;">
                    <div style="font-size: 0.85rem; opacity: 0.9; margin-bottom: 0.25rem;">Total</div>
                    <div style="font-size: 1.15rem; font-weight: 600;">${itemTotal}</div>
                    <div style="font-size: 0.75rem; opacity: 0.8; margin-top: 0.25rem;">Qtd: ${itemQtd}</div>
                </div>
            </div>
        </div>
    `;

        const itemButtons = `
        <div class="opcoes-grupo">
            <h6 class="opcoes-titulo">Ações</h6>
            <div class="opcoes-grid">
                <button type="button" class="opcao-card opcao-card-primary" onclick="Swal.close(); editarItemDaTabela(${index});">
                    <i class="bi bi-pencil"></i>
                    <span>Editar item</span>
                </button>
                <button type="button" class="opcao-card opcao-card-info" onclick="simularPrecoItem(${index});">
                    <i class="bi bi-calculator"></i>
                    <span>Simular Preço</span>
                </button>
                <button type="button" class="opcao-card opcao-card-danger" onclick="Swal.close(); removerItemDaTabela(${index});">
                    <i class="bi bi-trash"></i>
                    <span>Remover item</span>
                </button>
            </div>
        </div>
    `;

        Swal.fire({
            html: headerHtml + itemButtons,
            width: '32rem',
            showConfirmButton: false,
            showCloseButton: true,
            customClass: {
                popup: 'swal-venda-opcoes',
                container: 'swal-venda-container'
            },
            didOpen: () => {
                // Adicionar estilos se ainda não existirem
                if (!document.getElementById('swal-item-opcoes-style')) {
                    const style = document.createElement('style');
                    style.id = 'swal-item-opcoes-style';
                    style.textContent = `
                    .swal-venda-opcoes {
                        border-radius: 16px;
                        overflow: visible !important;
                    }
                    .swal-venda-container {
                        margin: 0 !important;
                        padding: 0 !important;
                        overflow: visible !important;
                    }
                    .swal-venda-opcoes .swal2-html-container {
                        overflow: visible !important;
                        padding: 0 !important;
                    }
                    .swal-venda-opcoes .swal2-close {
                        color: white !important;
                        background: rgba(255,255,255,0.25) !important;
                        border-radius: 8px !important;
                        width: 36px !important;
                        height: 36px !important;
                        font-size: 1.5rem !important;
                        transition: all 0.2s !important;
                        top: 1rem !important;
                        right: 1rem !important;
                        box-shadow: 0 2px 8px rgba(0,0,0,0.2) !important;
                        z-index: 9999 !important;
                    }
                    .swal-venda-opcoes .swal2-close:hover {
                        background: rgba(255,255,255,0.4) !important;
                        transform: scale(1.1) !important;
                    }
                    .opcoes-grupo {
                        margin-bottom: 1.5rem;
                        padding: 0 0.5rem;
                    }
                    .opcoes-titulo {
                        font-size: 0.85rem;
                        font-weight: 700;
                        text-transform: uppercase;
                        letter-spacing: 0.08em;
                        color: #64748b;
                        margin-bottom: 0.6rem;
                        display: flex;
                        align-items: center;
                        gap: 0.35rem;
                    }
                    .opcoes-titulo::before {
                        content: '';
                        width: 6px;
                        height: 6px;
                        border-radius: 50%;
                        background: #cbd5f5;
                    }
                    .opcoes-grid {
                        display: grid;
                        grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
                        gap: 0.75rem;
                        padding: 1rem !important;
                    }
                    .opcao-card {
                        width: 130px;
                        height: 130px;
                        display: flex;
                        flex-direction: column;
                        align-items: center;
                        justify-content: center;
                        gap: 0.5rem;
                        border: 2px solid #e2e8f0;
                        border-radius: 12px;
                        background: white;
                        cursor: pointer;
                        transition: all 0.2s;
                        text-decoration: none;
                        color: #334155;
                    }
                    .opcao-card:hover {
                        transform: translateY(-2px);
                        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
                    }
                    .opcao-card i {
                        font-size: 2rem;
                    }
                    .opcao-card span {
                        font-size: 0.85rem;
                        font-weight: 600;
                        text-align: center;
                    }
                    .opcao-card-primary {
                        border-color: #3b82f6;
                        color: #3b82f6;
                    }
                    .opcao-card-primary:hover {
                        background: #eff6ff;
                        border-color: #2563eb;
                    }
                    .opcao-card-info {
                        border-color: #0ea5e9;
                        color: #0ea5e9;
                    }
                    .opcao-card-info:hover {
                        background: #f0f9ff;
                        border-color: #0284c7;
                    }
                    .opcao-card-danger {
                        border-color: #ef4444;
                        color: #ef4444;
                    }
                    .opcao-card-danger:hover {
                        background: #fef2f2;
                        border-color: #dc2626;
                    }
                `;
                    document.head.appendChild(style);
                }
            }
        });
    }

    // Simular preços do item em diferentes tabelas de preço
    function simularPrecoItem(index) {
        const item = itensTabela[index];
        if (!item) {
            Swal.fire({ icon: 'error', title: 'Erro', text: 'Item não encontrado!' });
            return;
        }

        Swal.fire({
            title: 'Carregando preços...',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: appUrl('/vendas/simular-precos-produto'),
            method: 'GET',
            data: { produto_id: item.product_id },
            success: function (response) {
                if (response.success && response.data) {
                    const precos = response.data.precos || [];
                    const qtdItem = parseFloat(item.quantity) || 1;

                    let html = `
                    <div class="text-start">
                        <div class="alert alert-info mb-3">
                            <strong>${escapeHtml(item.product_name)}</strong>
                            ${item.product_sku ? `<br><small class="text-muted">SKU: ${escapeHtml(item.product_sku)}</small>` : ''}
                        </div>
                        <table class="table table-sm table-striped">
                            <thead>
                                <tr>
                                    <th>Tabela de Preço</th>
                                    <th class="text-center">Qtd</th>
                                    <th class="text-end">Valor Unit.</th>
                                    <th class="text-end">Total</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                `;

                    if (precos.length > 0) {
                        precos.forEach(p => {
                            const valorUnit = parseFloat(p.valor);
                            const totalCalc = valorUnit * qtdItem;
                            html += `
                            <tr>
                                <td>${escapeHtml(p.tabela_nome || 'Padrão')}</td>
                                <td class="text-center">${qtdItem.toFixed(3).replace('.', ',')}</td>
                                <td class="text-end">R$ ${valorUnit.toFixed(2).replace('.', ',')}</td>
                                <td class="text-end fw-bold">R$ ${totalCalc.toFixed(2).replace('.', ',')}</td>
                                <td class="text-end">
                                    <button type="button" class="btn btn-sm btn-success" onclick="aplicarPrecoSimulado(${index}, ${p.valor})">
                                        <i class="bi bi-check"></i> Usar
                                    </button>
                                </td>
                            </tr>
                        `;
                        });
                    } else {
                        html += '<tr><td colspan="5" class="text-center text-muted">Nenhum preço cadastrado</td></tr>';
                    }

                    html += `
                            </tbody>
                        </table>
                    </div>
                `;

                    Swal.fire({
                        title: '<i class="bi bi-calculator me-2"></i> Simular Preço',
                        html: html,
                        width: '650px',
                        showConfirmButton: false,
                        showCloseButton: true
                    });
                } else {
                    Swal.fire({ icon: 'error', title: 'Erro', text: response.message || 'Erro ao carregar preços' });
                }
            },
            error: function () {
                Swal.fire({ icon: 'error', title: 'Erro', text: 'Erro ao consultar preços' });
            }
        });
    }

    // Aplicar preço simulado ao item
    function aplicarPrecoSimulado(index, novoPreco) {
        const item = itensTabela[index];
        if (!item) return;

        item.unit_price = parseFloat(novoPreco);
        const qtd = parseFloat(item.quantity) || 1;
        const desconto = parseFloat(item.discount) || 0;
        item.total_price = (qtd * item.unit_price) - desconto;

        // Atualizar linha na tabela usando data-index
        const $row = $(`#tabela-itens tbody tr[data-index="${index}"]`);

        // Estrutura da tabela:
        // [0] Item | [1] Profissional (opcional) | [2] Qtd | [3] Unit. | [4] Desc. | [5] Total | [6] Obs.
        // Sem profissional:
        // [0] Item | [1] Qtd | [2] Unit. | [3] Desc. | [4] Total | [5] Obs.
        const $cells = $row.find('td');
        const temProfissional = $row.find('.item-vendedor-select').length > 0;
        const precoIdx = temProfissional ? 3 : 2;
        const totalIdx = temProfissional ? 5 : 4;

        $cells.eq(precoIdx).text('R$ ' + item.unit_price.toFixed(2).replace('.', ','));
        $cells.eq(totalIdx).html('<strong>R$ ' + item.total_price.toFixed(2).replace('.', ',') + '</strong>');

        // Atualizar inputs hidden
        $row.find(`input[name="itens[${index}][unit_price]"]`).val(item.unit_price);
        $row.find(`input[name="itens[${index}][total_price]"]`).val(item.total_price);

        calcularTotalGeral();

        Swal.fire({
            icon: 'success',
            title: 'Preço aplicado!',
            text: `Novo preço: R$ ${item.unit_price.toFixed(2).replace('.', ',')}`,
            timer: 1500,
            showConfirmButton: false
        });
    }

    async function editarItemDaTabela(index) {
        // Pegar o item do array
        const item = itensTabela[index];

        if (!item) {
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Item não encontrado!'
            });
            return;
        }

        const loteInfoHtml = (usarLoteVenda && item.lote) ?
            `
            <div class="mb-3">
                <label class="form-label fw-bold">Lote</label>
                <div class="form-control bg-light">
                    ${escapeHtml(item.lote)}
                    ${item.validade ? `<small class="text-muted ms-2">Val.: ${formatarDataSimples(item.validade)}</small>` : ''}
                    ${item.fabricacao ? `<small class="text-muted ms-2">Fab.: ${formatarDataSimples(item.fabricacao)}</small>` : ''}
                </div>
            </div>
        ` :
            '';

        // Montar select de profissionais se necessário
        let profissionalSelectHtml = '';
        if (comissaoFuncionarioItem && profissionaisItemData && profissionaisItemData.length > 0) {
            let optionsHtml = '<option value="">Selecione...</option>';
            const selectedVendedorId = item.vendedor_id || '';
            profissionaisItemData.forEach(prof => {
                const selected = (selectedVendedorId == prof.id) ? 'selected' : '';
                optionsHtml += `<option value="${prof.id}" ${selected}>${escapeHtml(prof.name)}</option>`;
            });
            profissionalSelectHtml = `
            <div class="mb-3">
                <label class="form-label fw-bold">Profissional</label>
                <select class="form-select" id="swal-vendedor">
                    ${optionsHtml}
                </select>
            </div>
        `;
        }

        // Abrir modal com SweetAlert2
        const {
            value: formValues
        } = await Swal.fire({
            title: '<i class="bi bi-pencil-square me-2"></i>Alterar Item',
            html: `
            <div class="text-start">
                <div class="mb-3">
                    <label class="form-label fw-bold">Produto/Serviço</label>
                    <input type="text" id="swal-product" class="form-control" value="${item.product_name}" readonly>
                </div>
                ${loteInfoHtml}
                ${profissionalSelectHtml}

                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label fw-bold">Quantidade</label>
                        <input type="number" id="swal-quantity" class="form-control"
                               value="${parseFloat(item.quantity).toFixed(3)}"
                               min="0.001" step="0.001" required>
                    </div>

                    <div class="col-md-4 mb-3">
                        <label class="form-label fw-bold">Preço Unit. (R$)</label>
                        <input type="number" id="swal-price" class="form-control"
                               value="${parseFloat(item.unit_price).toFixed(2)}"
                               min="0" step="0.01" required>
                    </div>

                    <div class="col-md-4 mb-3">
                        <label class="form-label fw-bold">Desconto (R$)</label>
                        <input type="number" id="swal-discount" class="form-control"
                               value="${parseFloat(item.discount).toFixed(2)}"
                               min="0" step="0.01">
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Total</label>
                    <input type="text" id="swal-total" class="form-control fw-bold text-end"
                           value="R$ ${parseFloat(item.total_price).toFixed(2)}" readonly>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Observações</label>
                    <textarea id="swal-notes" class="form-control" rows="2">${item.notes || ''}</textarea>
                </div>
            </div>
        `,
            width: '600px',
            showCancelButton: true,
            confirmButtonText: '<i class="bi bi-check-circle me-2"></i>Salvar',
            cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Cancelar',
            confirmButtonColor: '#198754',
            cancelButtonColor: '#6c757d',
            didOpen: () => {
                // Calcular total automaticamente ao mudar valores
                const calcularTotal = () => {
                    const qtd = parseFloat($('#swal-quantity').val()) || 0;
                    const preco = parseFloat($('#swal-price').val()) || 0;
                    const desconto = parseFloat($('#swal-discount').val()) || 0;
                    const total = (qtd * preco) - desconto;
                    $('#swal-total').val('R$ ' + total.toFixed(2).replace('.', ','));
                };

                $('#swal-quantity, #swal-price, #swal-discount').on('input', calcularTotal);

                // Focar no campo de quantidade
                setTimeout(() => $('#swal-quantity').focus().select(), 100);
            },
            preConfirm: () => {
                const quantity = parseFloat($('#swal-quantity').val());
                const price = parseFloat($('#swal-price').val());
                const discount = parseFloat($('#swal-discount').val()) || 0;

                if (!quantity || quantity <= 0) {
                    Swal.showValidationMessage('Quantidade deve ser maior que zero');
                    return false;
                }

                if (!price || price < 0) {
                    Swal.showValidationMessage('Preço deve ser maior ou igual a zero');
                    return false;
                }

                const total = (quantity * price) - discount;

                return {
                    quantity: quantity,
                    unit_price: price,
                    discount: discount,
                    total_price: total,
                    notes: $('#swal-notes').val(),
                    vendedor_id: comissaoFuncionarioItem ? ($('#swal-vendedor').val() || '') : '',
                    profissional_id: $('#swal-vendedor').val() || ''
                };
            }
        });

        // Se o usuário confirmou
        if (formValues) {
            // Atualizar o item no array
            itensTabela[index] = {
                ...item,
                quantity: formValues.quantity,
                unit_price: formValues.unit_price,
                discount: formValues.discount,
                total_price: formValues.total_price,
                notes: formValues.notes,
                vendedor_id: formValues.vendedor_id || '',
                profissional_id: formValues.profissional_id || ''
            };

            // Atualizar a linha na tabela
            const $row = $(`#tbody-itens tr[data-index="${index}"]`);
            const colOffset = comissaoFuncionarioItem ? 1 : 0;

            // Atualizar select de profissional se existir
            if (comissaoFuncionarioItem) {
                const $select = $row.find('.item-vendedor-select');
                if ($select.length) {
                    $select.val(formValues.vendedor_id || '');
                }
            }

            $row.find(`td:eq(${1 + colOffset})`).text(parseFloat(formValues.quantity).toFixed(3));
            $row.find(`td:eq(${2 + colOffset})`).text('R$ ' + parseFloat(formValues.unit_price).toFixed(2));
            $row.find(`td:eq(${3 + colOffset})`).text('R$ ' + parseFloat(formValues.discount).toFixed(2));
            $row.find(`td:eq(${4 + colOffset})`).html('<strong>R$ ' + parseFloat(formValues.total_price).toFixed(2) +
                '</strong>');
            $row.find(`td:eq(${5 + colOffset})`).html(renderObservacoesCell(itensTabela[index]));

            // Atualizar inputs hidden
            $row.find('input[name*="[quantity]"]').val(formValues.quantity);
            $row.find('input[name*="[unit_price]"]').val(formValues.unit_price);
            $row.find('input[name*="[discount]"]').val(formValues.discount);
            $row.find('input[name*="[total_price]"]').val(formValues.total_price);
            $row.find('input[name*="[notes]"]').val(formValues.notes);
            if (comissaoFuncionarioItem) {
                $row.find('select[name*="[vendedor_id]"]').val(formValues.vendedor_id || '');
            }
            $row.find('input[name*="[profissional_id]"]').val(formValues.profissional_id || '');

            // Recalcular total geral
            calcularTotalGeral();

            Swal.fire({
                icon: 'success',
                title: 'Item Atualizado!',
                text: 'As alterações foram salvas com sucesso.',
                timer: 1500,
                showConfirmButton: false,
                toast: true,
                position: 'top-end'
            });
        }
    }

    function limparCamposItem() {
        $('#item_search_principal').val('');
        $('#produto_id_principal').val('');
        $('#qtd_principal').val('1');
        $('#preco_principal').val('0');
        $('#desconto_principal').val('0');
        $('#total_principal').val('0');
        $('#obs_principal').val('');
        if (comissaoFuncionarioItem) {
            $('#vendedor_principal').val('');
        }
        selectedProduto = null;
        selectedLote = null;
        if (usarLoteVenda) {
            resetLoteSelect();
        }
    }

    function atualizarVendedorItem(index, vendedorId) {
        if (itensTabela[index]) {
            itensTabela[index].vendedor_id = vendedorId || '';
            itensTabela[index].profissional_id = vendedorId || '';

            // Buscar comissão do usuário se vendedorId for informado
            if (vendedorId && comissaoFuncionarioItem) {
                $.ajax({
                    url: appUrl('/vendas/buscar-comissao-usuario'),
                    method: 'GET',
                    data: {
                        user_id: vendedorId
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success && response.data && response.data.comissao !== undefined) {
                            // A comissão será calculada e inserida no salvamento
                            // Aqui apenas armazenamos o percentual para referência
                            if (itensTabela[index]) {
                                itensTabela[index].percentual_comissao = response.data.comissao;
                            }
                        }
                    },
                    error: function () {
                        console.error('Erro ao buscar comissão do usuário');
                    }
                });
            }
        }
    }

    function calcularTotalGeral() {
        const totalItens = itensTabela.reduce((sum, item) => sum + (parseFloat(item.total_price) || 0), 0);
        const totalDespesas = despesasTabela.reduce((sum, despesa) => sum + parseFloat(despesa.valor || 0), 0);
        const valorFrete = parseFloat($('#freight_value').val()) || 0;

        const subtotal = totalItens + totalDespesas + valorFrete;

        const descontoTipo = $('#discount_type').val();
        const descontoValor = parseFloat($('#discount').val()) || 0;
        let desconto = 0;

        if (descontoTipo === 'percent') {
            desconto = (subtotal * descontoValor) / 100;
        } else {
            desconto = descontoValor;
        }

        const total = subtotal - desconto;

        $('#additions').val('0.00');
        $('#shipping').val(valorFrete.toFixed(2));

        $('#subtotal').val(subtotal.toFixed(2));
        $('#subtotal_display').val(formatarMoeda(subtotal));
        $('#total').val(total.toFixed(2));
        $('#total_display').val(formatarMoeda(total));
        $('#total-geral').text('R$ ' + formatarMoeda(total));
    }

    function formatarMoeda(valor) {
        if (!Number.isFinite(valor)) {
            valor = 0;
        }
        return valor.toFixed(2).replace('.', ',');
    }

    // ============================================
    // SELEÇÃO DE PRAZOS DE PAGAMENTO
    // ============================================

    function mostrarPrazosMetodoPagamento(metodoId) {
        const totalFinal = parseFloat($('#total').val()) || 0;

        if (totalFinal <= 0) {
            Swal.fire({
                icon: 'warning',
                title: 'Atenção',
                text: 'Adicione itens à venda antes de selecionar o método de pagamento!'
            });
            $('#payment_method_id').val('');
            return;
        }

        $.ajax({
            url: appUrl('/metodos-pagamento/buscar-prazos'),
            method: 'GET',
            data: {
                metodo_id: metodoId
            },
            success: function (response) {
                if (response.success && response.data.prazos && response.data.prazos.length > 0) {
                    exibirModalPrazos(response.data.prazos, totalFinal);
                } else {
                    $('#installments').val(1);
                }
            },
            error: function () {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'Não foi possível carregar os prazos de pagamento'
                });
            }
        });
    }

    function exibirModalPrazos(prazos, totalFinal) {
        let htmlPrazos = '<div class="list-group">';

        prazos.forEach((prazo) => {
            const dias = parseInt(prazo.dias);
            const quantidadeParcelas = Math.ceil(dias / 30);

            const valorParcela = totalFinal / quantidadeParcelas;
            const valorParcelaInteiro = Math.floor(valorParcela * 100) / 100;
            const valorUltimaParcela = totalFinal - (valorParcelaInteiro * (quantidadeParcelas - 1));

            let descricaoParcelas;
            if (quantidadeParcelas === 1) {
                descricaoParcelas = `1x de <strong>R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong>`;
            } else {
                if (Math.abs(valorUltimaParcela - valorParcelaInteiro) < 0.01) {
                    descricaoParcelas =
                        `${quantidadeParcelas}x de <strong>R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong>`;
                } else {
                    descricaoParcelas =
                        `${quantidadeParcelas - 1}x de <strong>R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> + 1x de <strong>R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong>`;
                }
            }

            htmlPrazos += `
            <button type="button" class="list-group-item list-group-item-action prazo-item" onclick="selecionarPrazo(${quantidadeParcelas}, ${dias})">
                <div class="d-flex w-100 justify-content-between align-items-center">
                    <div class="d-flex align-items-start">
                        <i class="bi bi-calendar-check text-primary me-3 mt-1" style="font-size: 1.5rem;"></i>
                        <div>
                            <h6 class="mb-1">${quantidadeParcelas}x - ${dias} Dias</h6>
                            <p class="mb-0 text-muted small">${descricaoParcelas}</p>
                        </div>
                    </div>
                    <div class="ms-3">
                        <i class="bi bi-chevron-right text-secondary"></i>
                    </div>
                </div>
            </button>
        `;
        });

        htmlPrazos += '</div>';

        Swal.fire({
            title: '<i class="bi bi-credit-card me-2"></i> Selecione o Prazo de Pagamento',
            html: htmlPrazos,
            width: '650px',
            showConfirmButton: false,
            showCancelButton: true,
            cancelButtonText: '<i class="bi bi-x-circle me-1"></i> Cancelar',
            customClass: {
                popup: 'swal-wide',
                cancelButton: 'btn btn-secondary'
            },
            buttonsStyling: false
        });
    }

    function selecionarPrazo(parcelas, dias) {
        const totalFinal = parseFloat($('#total').val()) || 0;

        const valorParcela = totalFinal / parcelas;
        const valorParcelaInteiro = Math.floor(valorParcela * 100) / 100;
        const valorUltimaParcela = totalFinal - (valorParcelaInteiro * (parcelas - 1));

        let descricaoDetalhada = '';
        if (parcelas === 1) {
            descricaoDetalhada =
                `<strong>${parcelas}x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
        } else {
            if (Math.abs(valorUltimaParcela - valorParcelaInteiro) < 0.01) {
                descricaoDetalhada =
                    `<strong>${parcelas}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
            } else {
                descricaoDetalhada =
                    `<strong>${parcelas - 1}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> + <strong>1x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
            }
        }

        $('#installments').val(parcelas);
        Swal.close();

        $('#parcelamento-detalhes').html(descricaoDetalhada);

        Swal.fire({
            icon: 'success',
            title: 'Prazo Selecionado!',
            text: `Pagamento em ${parcelas}x (${dias} dias)`,
            timer: 1500,
            showConfirmButton: false,
            toast: true,
            position: 'top-end'
        });
    }
</script>