<?php
ob_start();

$module = $module ?? [];
$routeBase = $module['routeBase'] ?? '/vendas';
$slug = $module['slug'] ?? 'vendas';
$plural = $module['plural'] ?? 'Vendas';
$singular = $module['singular'] ?? 'Venda';
$icon = $module['icon'] ?? 'bi bi-cart-check';
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-clipboard-check me-2"></i> Conferência de Vendas</h2>
        <p class="text-muted">Conferir e validar vendas realizadas</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url($routeBase) ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-6">
                <input type="text" class="form-control" name="search" placeholder="Buscar por número, cliente..."
                    value="<?= htmlspecialchars($search ?? '') ?>">
            </div>
            <div class="col-md-3">
                <select class="form-select" name="status">
                    <option value="">Todos os Status</option>
                    <?php foreach ($statusVendas ?? [] as $statusItem): ?>
                        <option value="<?= htmlspecialchars($statusItem['codigo']) ?>" <?= ($status ?? '') === $statusItem['codigo'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($statusItem['nome']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-secondary w-100">
                    <i class="bi bi-search"></i> Buscar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Lista de Vendas -->
<div class="card">
    <div class="card-body p-0">
        <?php if (!empty($vendas)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th>Número</th>
                            <th>Cliente</th>
                            <th>Data</th>
                            <th>Total</th>
                            <th>Status</th>
                            <th>Pagamento</th>
                            <th width="120">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($vendas as $venda): ?>
                            <tr>
                                <td><?= $venda['id'] ?></td>
                                <td><strong><?= htmlspecialchars($venda['sale_number']) ?></strong></td>
                                <td>
                                    <?php
                                    $fantasia = $venda['pessoa_trade_name'] ?? '';
                                    $razaoSocial = $venda['pessoa_name'] ?? $venda['customer_name'] ?? 'Consumidor Final';
                                    $cnpj = $venda['customer_document'] ?? '';
                                    ?>
                                    <?php if (!empty($fantasia)): ?>
                                        <div><strong><?= htmlspecialchars($fantasia) ?></strong></div>
                                    <?php endif; ?>
                                    <div><?= htmlspecialchars($razaoSocial) ?></div>
                                    <?php if (!empty($cnpj)): ?>
                                        <small class="text-muted"><?= formatDocument($cnpj) ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><?= date('d/m/Y', strtotime($venda['sale_date'])) ?></td>
                                <td><?= formatCurrency($venda['total'] ?? 0) ?></td>
                                <td>
                                    <?php
                                    $statusBadges = [
                                        'orcamento' => '<span class="badge bg-secondary"><i class="bi bi-file-earmark me-1"></i>Orçamento</span>',
                                        'pendente' => '<span class="badge bg-warning text-dark"><i class="bi bi-clock me-1"></i>Pendente</span>',
                                        'realizado' => '<span class="badge bg-info"><i class="bi bi-check me-1"></i>Realizado</span>',
                                        'faturamento' => '<span class="badge bg-primary"><i class="bi bi-receipt me-1"></i>Faturamento</span>',
                                        'expedicao' => '<span class="badge bg-purple"><i class="bi bi-box-seam me-1"></i>Expedição</span>',
                                        'em_entrega' => '<span class="badge bg-cyan"><i class="bi bi-truck me-1"></i>Em Entrega</span>',
                                        'finalizado' => '<span class="badge bg-success"><i class="bi bi-check-circle me-1"></i>Finalizado</span>'
                                    ];
                                    echo $statusBadges[$venda['status']] ?? '-';
                                    ?>
                                </td>
                                <td><?= htmlspecialchars($venda['payment_method_name'] ?? '-') ?></td>
                                <td>
                                    <a href="<?= url($routeBase . '/visualizar?id=' . $venda['id']) ?>"
                                        class="btn btn-sm btn-info" title="Visualizar">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-clipboard-check" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhuma venda encontrada para conferência</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php
$content = ob_get_clean();
$activeMenu = $activeMenu ?? 'vendas';
include ROOT_PATH . '/views/layouts/app.php';
?>