<?php
$isEdit = isset($usuario) && !empty($usuario);
$usuario = $usuario ?? [];
$funcionario = $funcionario ?? [];
?>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-person me-2"></i>
            <?= $isEdit ? 'Editar Usuário' : 'Novo Usuário' ?>
        </h5>
    </div>
    <div class="card-body">
        <!-- Navegação por Abas -->
        <ul class="nav nav-tabs mb-4" id="usuarioTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="usuario-tab" data-bs-toggle="tab" data-bs-target="#usuario" type="button" role="tab" aria-controls="usuario" aria-selected="true">
                    <i class="bi bi-person-lock me-2"></i>Dados de Usuário
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="funcionario-tab" data-bs-toggle="tab" data-bs-target="#funcionario" type="button" role="tab" aria-controls="funcionario" aria-selected="false">
                    <i class="bi bi-person-badge me-2"></i>Dados de Funcionário
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="configuracoes-tab" data-bs-toggle="tab" data-bs-target="#configuracoes" type="button" role="tab" aria-controls="configuracoes" aria-selected="false">
                    <i class="bi bi-gear me-2"></i>Configurações
                </button>
            </li>
            <?php if ($isEdit): ?>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="permissoes-tab" data-bs-toggle="tab" data-bs-target="#permissoes" type="button" role="tab" aria-controls="permissoes" aria-selected="false">
                    <i class="bi bi-shield-lock me-2"></i>Permissões
                </button>
            </li>
            <?php endif; ?>
        </ul>

        <form id="usuarioForm" method="POST" action="<?= $isEdit ? url('/usuarios/editar') : url('/usuarios/criar') ?>">
            <?php if ($isEdit): ?>
                <input type="hidden" name="id" value="<?= $usuario['id'] ?>">
            <?php endif; ?>

            <div class="tab-content" id="usuarioTabsContent">

                <!-- Aba: Dados de Usuário (Acesso ao Sistema) -->
                <div class="tab-pane fade show active" id="usuario" role="tabpanel" aria-labelledby="usuario-tab">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">Nome Completo *</label>
                                <input type="text" class="form-control" id="name" name="name"
                                       value="<?= htmlspecialchars($usuario['name'] ?? '') ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="email" class="form-label">E-mail (Login) *</label>
                                <input type="email" class="form-control" id="email" name="email"
                                       value="<?= htmlspecialchars($usuario['email'] ?? '') ?>" required>
                                <small class="form-text text-muted">Este e-mail será usado para login no sistema</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="password" class="form-label">
                                    Senha <?= $isEdit ? '' : '*' ?>
                                </label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="password" name="password"
                                           <?= $isEdit ? '' : 'required' ?>>
                                    <button class="btn btn-outline-secondary" type="button" onclick="togglePassword()">
                                        <i class="bi bi-eye" id="togglePasswordIcon"></i>
                                    </button>
                                </div>
                                <?php if ($isEdit): ?>
                                    <small class="form-text text-muted">Deixe em branco para manter a senha atual</small>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="perfil_acesso_id" class="form-label">Perfil de Acesso *</label>
                                <select class="form-select" id="perfil_acesso_id" name="perfil_acesso_id" required>
                                    <?php
                                    $perfilAcessoId = $usuario['perfil_acesso_id'] ?? '';
                                    $perfisAcesso = $perfisAcesso ?? [];
                                    ?>
                                    <option value="0" <?= (empty($perfilAcessoId) || $perfilAcessoId == 0) ? 'selected' : '' ?>>Sem perfil</option>
                                    <?php if (!empty($perfisAcesso)): ?>
                                        <?php foreach ($perfisAcesso as $perfil): ?>
                                            <option value="<?= $perfil['id'] ?>" <?= $perfilAcessoId == $perfil['id'] ? 'selected' : '' ?>>
                                                <?= htmlspecialchars($perfil['nome']) ?>
                                                <?php if (!empty($perfil['descricao'])): ?>
                                                    - <?= htmlspecialchars($perfil['descricao']) ?>
                                                <?php endif; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                                <small class="text-muted">Selecione o perfil de acesso do usuário ou "Sem perfil"</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label class="form-label">Tipos de Usuário</label>
                                <div class="d-flex gap-3 flex-wrap">
                                    <div class="modern-switch-wrapper">
                                        <input type="checkbox" class="modern-switch-input"
                                            name="is_vendedor" id="is_vendedor" value="1"
                                            <?= isset($usuario['is_vendedor']) && $usuario['is_vendedor'] ? 'checked' : '' ?>>
                                        <label class="modern-switch-label" for="is_vendedor">
                                            <span class="modern-switch-slider"></span>
                                            <span class="modern-switch-text">
                                                <i class="bi bi-cart me-1"></i>Vendedor
                                            </span>
                                        </label>
                                    </div>
                                    <div class="modern-switch-wrapper">
                                        <input type="checkbox" class="modern-switch-input"
                                            name="is_tecnico" id="is_tecnico" value="1"
                                            <?= isset($usuario['is_tecnico']) && $usuario['is_tecnico'] ? 'checked' : '' ?>>
                                        <label class="modern-switch-label" for="is_tecnico">
                                            <span class="modern-switch-slider"></span>
                                            <span class="modern-switch-text">
                                                <i class="bi bi-tools me-1"></i>Técnico
                                            </span>
                                        </label>
                                    </div>
                                    <div class="modern-switch-wrapper">
                                        <input type="checkbox" class="modern-switch-input"
                                            name="is_usuario" id="is_usuario" value="1"
                                            <?= isset($usuario['is_usuario']) && $usuario['is_usuario'] ? 'checked' : '' ?>>
                                        <label class="modern-switch-label" for="is_usuario">
                                            <span class="modern-switch-slider"></span>
                                            <span class="modern-switch-text">
                                                <i class="bi bi-person me-1"></i>Usuário
                                            </span>
                                        </label>
                                    </div>
                                    <div class="modern-switch-wrapper">
                                        <input type="checkbox" class="modern-switch-input"
                                            name="is_funcionario" id="is_funcionario" value="1"
                                            <?= isset($usuario['is_funcionario']) && $usuario['is_funcionario'] ? 'checked' : '' ?>>
                                        <label class="modern-switch-label" for="is_funcionario">
                                            <span class="modern-switch-slider"></span>
                                            <span class="modern-switch-text">
                                                <i class="bi bi-person-badge me-1"></i>Funcionário
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="is_active" class="form-label">Status do Usuário</label>
                                <select class="form-select" id="is_active" name="is_active">
                                    <option value="1" <?= ($usuario['is_active'] ?? 1) == 1 ? 'selected' : '' ?>>
                                        <i class="bi bi-check-circle"></i> Ativo - Pode acessar o sistema
                                    </option>
                                    <option value="0" <?= ($usuario['is_active'] ?? 1) == 0 ? 'selected' : '' ?>>
                                        <i class="bi bi-x-circle"></i> Inativo - Acesso bloqueado
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="mb-3">
                                <label for="notes" class="form-label">Observações sobre o Usuário</label>
                                <textarea class="form-control" id="notes" name="notes" rows="3"
                                          placeholder="Informações adicionais sobre permissões, restrições, etc."><?= htmlspecialchars($usuario['notes'] ?? '') ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Aba: Dados de Funcionário (Informações Pessoais/RH) -->
                <div class="tab-pane fade" id="funcionario" role="tabpanel" aria-labelledby="funcionario-tab">

                    <div class="alert alert-info">
                        <i class="bi bi-info-circle me-2"></i>
                        <strong>Opcional:</strong> Preencha os dados abaixo se este usuário também for um funcionário da empresa (dados para RH, folha de pagamento, etc.)
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="func_cpf" class="form-label">CPF</label>
                                <input type="text" class="form-control" id="func_cpf" name="func_cpf"
                                       value="<?= htmlspecialchars($funcionario['cpf'] ?? '') ?>"
                                       oninput="maskCPF(this)"
                                       maxlength="14"
                                       placeholder="000.000.000-00">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="func_rg" class="form-label">RG</label>
                                <input type="text" class="form-control" id="func_rg" name="func_rg"
                                       value="<?= htmlspecialchars($funcionario['rg'] ?? '') ?>"
                                       placeholder="00.000.000-0">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="func_telefone" class="form-label">Telefone</label>
                                <input type="text" class="form-control" id="func_telefone" name="func_telefone"
                                       value="<?= htmlspecialchars($funcionario['telefone'] ?? $usuario['phone'] ?? '') ?>"
                                       oninput="maskPhone(this)"
                                       maxlength="15"
                                       placeholder="(00) 00000-0000">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="func_cargo" class="form-label">Cargo/Função</label>
                                <select class="form-select" id="func_cargo" name="func_cargo">
                                    <option value="">Selecione o cargo</option>
                                    <option value="gerente" <?= ($funcionario['cargo'] ?? '') === 'gerente' ? 'selected' : '' ?>>Gerente</option>
                                    <option value="supervisor" <?= ($funcionario['cargo'] ?? '') === 'supervisor' ? 'selected' : '' ?>>Supervisor</option>
                                    <option value="vendedor" <?= ($funcionario['cargo'] ?? '') === 'vendedor' ? 'selected' : '' ?>>Vendedor</option>
                                    <option value="atendente" <?= ($funcionario['cargo'] ?? '') === 'atendente' ? 'selected' : '' ?>>Atendente</option>
                                    <option value="assistente" <?= ($funcionario['cargo'] ?? '') === 'assistente' ? 'selected' : '' ?>>Assistente Administrativo</option>
                                    <option value="analista" <?= ($funcionario['cargo'] ?? '') === 'analista' ? 'selected' : '' ?>>Analista</option>
                                    <option value="coordenador" <?= ($funcionario['cargo'] ?? '') === 'coordenador' ? 'selected' : '' ?>>Coordenador</option>
                                    <option value="outro" <?= ($funcionario['cargo'] ?? '') === 'outro' ? 'selected' : '' ?>>Outro</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="func_departamento" class="form-label">Departamento</label>
                                <select class="form-select" id="func_departamento" name="func_departamento">
                                    <option value="">Selecione o departamento</option>
                                    <option value="vendas" <?= ($funcionario['departamento'] ?? '') === 'vendas' ? 'selected' : '' ?>>Vendas</option>
                                    <option value="financeiro" <?= ($funcionario['departamento'] ?? '') === 'financeiro' ? 'selected' : '' ?>>Financeiro</option>
                                    <option value="compras" <?= ($funcionario['departamento'] ?? '') === 'compras' ? 'selected' : '' ?>>Compras</option>
                                    <option value="estoque" <?= ($funcionario['departamento'] ?? '') === 'estoque' ? 'selected' : '' ?>>Estoque</option>
                                    <option value="rh" <?= ($funcionario['departamento'] ?? '') === 'rh' ? 'selected' : '' ?>>Recursos Humanos</option>
                                    <option value="ti" <?= ($funcionario['departamento'] ?? '') === 'ti' ? 'selected' : '' ?>>TI</option>
                                    <option value="administrativo" <?= ($funcionario['departamento'] ?? '') === 'administrativo' ? 'selected' : '' ?>>Administrativo</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="func_data_admissao" class="form-label">Data de Admissão</label>
                                <input type="text" class="form-control" id="func_data_admissao" name="func_data_admissao"
                                       value="<?= htmlspecialchars($funcionario['data_admissao'] ?? '') ?>"
                                       oninput="maskDate(this)"
                                       maxlength="10"
                                       placeholder="DD/MM/AAAA">
                                <small class="form-text text-muted">Exemplo: 15/03/2024</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="func_salario" class="form-label">Salário</label>
                                <input type="text" class="form-control" id="func_salario" name="func_salario"
                                       value="<?= htmlspecialchars($funcionario['salario'] ?? '') ?>"
                                       oninput="maskMoney(this)"
                                       placeholder="R$ 0,00">
                                <small class="form-text text-muted">Digite apenas números</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="func_tipo_contrato" class="form-label">Tipo de Contrato</label>
                                <select class="form-select" id="func_tipo_contrato" name="func_tipo_contrato">
                                    <option value="">Selecione</option>
                                    <option value="clt" <?= ($funcionario['tipo_contrato'] ?? '') === 'clt' ? 'selected' : '' ?>>CLT</option>
                                    <option value="pj" <?= ($funcionario['tipo_contrato'] ?? '') === 'pj' ? 'selected' : '' ?>>PJ</option>
                                    <option value="estagio" <?= ($funcionario['tipo_contrato'] ?? '') === 'estagio' ? 'selected' : '' ?>>Estágio</option>
                                    <option value="temporario" <?= ($funcionario['tipo_contrato'] ?? '') === 'temporario' ? 'selected' : '' ?>>Temporário</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="mb-3">
                                <label for="func_observacoes" class="form-label">Observações (RH)</label>
                                <textarea class="form-control" id="func_observacoes" name="func_observacoes" rows="3"
                                          placeholder="Informações adicionais sobre o funcionário (benefícios, histórico, etc.)"><?= htmlspecialchars($funcionario['observacoes'] ?? '') ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Aba: Configurações -->
                <div class="tab-pane fade" id="configuracoes" role="tabpanel" aria-labelledby="configuracoes-tab">

                    <!-- Seção de Empresas Vinculadas -->
                    <div class="mb-3">
                        <label class="form-label mb-3">
                            <i class="bi bi-building me-1"></i> Empresas Vinculadas
                        </label>
                        <div class="card border">
                            <div class="card-body p-3" style="max-height: 350px; overflow-y: auto;">
                                <div class="mb-3 pb-3 border-bottom bg-light rounded p-2 sticky-top">
                                    <div class="modern-switch-wrapper">
                                        <input type="checkbox" class="modern-switch-input" id="marcar_todas_empresas_user">
                                        <label class="modern-switch-label" for="marcar_todas_empresas_user">
                                            <span class="modern-switch-slider"></span>
                                            <span class="modern-switch-text fw-bold">
                                                <i class="bi bi-check-all me-1"></i> Marcar todas
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div id="empresas_user_list">
                                    <?php if (!empty($todasEmpresas ?? [])): ?>
                                        <?php
                                        $empresasVinculadasIds = array_map('intval', $empresasVinculadas ?? []);
                                        foreach ($todasEmpresas as $empresa):
                                            $isChecked = in_array((int)$empresa['id'], $empresasVinculadasIds);
                                        ?>
                                            <div class="modern-switch-wrapper empresa-item-wrapper mb-2" style="padding: 10px 12px;">
                                                <input type="checkbox"
                                                       class="modern-switch-input empresa-user-checkbox"
                                                       value="<?= $empresa['id'] ?>"
                                                       id="empresa_user_<?= $empresa['id'] ?>"
                                                       <?= $isChecked ? 'checked' : '' ?>>
                                                <label class="modern-switch-label" for="empresa_user_<?= $empresa['id'] ?>">
                                                    <span class="modern-switch-slider"></span>
                                                    <span class="modern-switch-text">
                                                        <div class="fw-medium">
                                                            <?= htmlspecialchars($empresa['razao_social']) ?>
                                                        </div>
                                                        <?php if (!empty($empresa['cnpj'])): ?>
                                                            <small class="text-muted d-block mt-1">
                                                                <i class="bi bi-file-earmark-text me-1"></i>
                                                                <?= htmlspecialchars($empresa['cnpj']) ?>
                                                            </small>
                                                        <?php endif; ?>
                                                    </span>
                                                </label>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <div class="text-center text-muted py-4">
                                            <i class="bi bi-building" style="font-size: 2rem; opacity: 0.3;"></i>
                                            <p class="mb-0 mt-2">Nenhuma empresa cadastrada.</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Campo oculto para enviar os IDs das empresas vinculadas -->
                    <input type="hidden" name="empresas_vinculadas" id="empresas_vinculadas_user_input"
                        value="<?= htmlspecialchars(json_encode($empresasVinculadas ?? []), ENT_QUOTES, 'UTF-8') ?>">

                    <!-- Seção de Configurações de Vendedor -->
                    <hr class="my-4">
                    <h5 class="mb-3">
                        <i class="bi bi-sliders me-2"></i> Configurações de Vendedor
                    </h5>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="desconto" class="form-label">Desconto (%)</label>
                                <input type="number" class="form-control" id="desconto" name="desconto"
                                       value="<?= htmlspecialchars($usuario['desconto'] ?? '0') ?>"
                                       step="0.01" min="0" max="100"
                                       placeholder="0.00">
                                <small class="form-text text-muted">Percentual de desconto máximo permitido</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="comissao" class="form-label">Comissão (%)</label>
                                <input type="number" class="form-control" id="comissao" name="comissao"
                                       value="<?= htmlspecialchars($usuario['comissao'] ?? '0') ?>"
                                       step="0.01" min="0" max="100"
                                       placeholder="0.00">
                                <small class="form-text text-muted">Percentual de comissão sobre vendas</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="carteira" class="form-label">
                                    Carteira
                                    <i class="bi bi-question-circle text-info ms-1"
                                       data-bs-toggle="tooltip"
                                       data-bs-placement="top"
                                       title="Quando ativo este vendedor só pode vender para os clientes da sua carteira"></i>
                                </label>
                                <div class="modern-switch-wrapper">
                                    <input type="checkbox" class="modern-switch-input"
                                           name="carteira" id="carteira" value="1"
                                           <?= isset($usuario['carteira']) && $usuario['carteira'] ? 'checked' : '' ?>>
                                    <label class="modern-switch-label" for="carteira">
                                        <span class="modern-switch-slider"></span>
                                        <span class="modern-switch-text">
                                            <i class="bi bi-briefcase me-1"></i>Ativar Carteira
                                        </span>
                                    </label>
                                </div>
                                <small class="form-text text-muted d-block mt-2">
                                    <i class="bi bi-info-circle me-1"></i>
                                    Quando ativo, este vendedor só pode vender para os clientes da sua carteira
                                </small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Aba: Permissões (Apenas em modo de edição) -->
                <?php if ($isEdit): ?>
                <div class="tab-pane fade" id="permissoes" role="tabpanel" aria-labelledby="permissoes-tab">
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle me-2"></i>
                        <strong>Permissões por Módulos:</strong> Configure as permissões de acesso para cada módulo do sistema.
                    </div>

                    <?php
                    // Lista de módulos do sistema
                    $modulos = [
                        'dashboard' => ['nome' => 'Dashboard', 'descricao' => 'Painel principal do sistema'],
                        'pessoas' => ['nome' => 'Pessoas', 'descricao' => 'Gerenciamento de pessoas, clientes e fornecedores'],
                        'grupos-pessoas' => ['nome' => 'Grupos', 'descricao' => 'Grupos de pessoas'],
                        'contas' => ['nome' => 'Contas Bancárias', 'descricao' => 'Gerenciamento de contas bancárias'],
                        'metodos-pagamento' => ['nome' => 'Métodos de Pagamento', 'descricao' => 'Formas de pagamento'],
                        'itens' => ['nome' => 'Itens', 'descricao' => 'Cadastro de produtos e serviços'],
                        'plano-contas' => ['nome' => 'Plano de Contas', 'descricao' => 'Plano de contas contábil'],
                        'centro-custos' => ['nome' => 'Centro de Custos', 'descricao' => 'Centros de custos'],
                        'gestor-estoque' => ['nome' => 'Locais de Estoque', 'descricao' => 'Locais de armazenamento'],
                        'impostos' => ['nome' => 'Impostos', 'descricao' => 'Gestão de impostos'],
                        'pedidos' => ['nome' => 'Pedidos', 'descricao' => 'Gerenciamento de pedidos'],
                        'compras' => ['nome' => 'Compras', 'descricao' => 'Gerenciamento de compras'],
                        'orcamentos-agua' => ['nome' => 'Orçamentos Água', 'descricao' => 'Orçamentos de água mineral'],
                        'vendas' => ['nome' => 'Vendas', 'descricao' => 'Gerenciamento de vendas'],
                        'estoque' => ['nome' => 'Estoque', 'descricao' => 'Gestão de estoque'],
                        'ordem-servico' => ['nome' => 'Ordem de Serviço', 'descricao' => 'Ordens de serviço'],
                        'agenda' => ['nome' => 'Agenda', 'descricao' => 'Agenda e calendário'],
                        'entradas' => ['nome' => 'Entradas', 'descricao' => 'Entradas financeiras'],
                        'saidas' => ['nome' => 'Saídas', 'descricao' => 'Saídas financeiras'],
                        'fluxo-caixa' => ['nome' => 'Fluxo de Caixa', 'descricao' => 'Fluxo de caixa'],
                        'empresas' => ['nome' => 'Empresas', 'descricao' => 'Gerenciamento de empresas'],
                        'usuarios' => ['nome' => 'Usuários', 'descricao' => 'Gerenciamento de usuários'],
                        'relatorios' => ['nome' => 'Relatórios', 'descricao' => 'Relatórios do sistema'],
                        'parametros' => ['nome' => 'Parâmetros', 'descricao' => 'Parâmetros do sistema'],
                        'arquivos-fiscais' => ['nome' => 'Arquivos Fiscais', 'descricao' => 'Arquivos fiscais'],
                    ];

                    // Carregar permissões existentes
                    $permissoesExistentes = [];
                    if (isset($permissoes) && is_array($permissoes)) {
                        foreach ($permissoes as $perm) {
                            $permissoesExistentes[$perm['module']] = $perm;
                        }
                    }
                    ?>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 25%;">Módulo</th>
                                    <th class="text-center" style="width: 15%;">
                                        <div>
                                            <i class="bi bi-eye"></i> Visualizar
                                            <br>
                                            <button type="button" class="btn btn-sm btn-outline-primary mt-1"
                                                    onclick="toggleAllPermissions('can_view')"
                                                    title="Marcar/Desmarcar todos">
                                                <i class="bi bi-check-all"></i> Todos
                                            </button>
                                        </div>
                                    </th>
                                    <th class="text-center" style="width: 15%;">
                                        <div>
                                            <i class="bi bi-plus-circle"></i> Criar
                                            <br>
                                            <button type="button" class="btn btn-sm btn-outline-primary mt-1"
                                                    onclick="toggleAllPermissions('can_create')"
                                                    title="Marcar/Desmarcar todos">
                                                <i class="bi bi-check-all"></i> Todos
                                            </button>
                                        </div>
                                    </th>
                                    <th class="text-center" style="width: 15%;">
                                        <div>
                                            <i class="bi bi-pencil"></i> Editar
                                            <br>
                                            <button type="button" class="btn btn-sm btn-outline-primary mt-1"
                                                    onclick="toggleAllPermissions('can_edit')"
                                                    title="Marcar/Desmarcar todos">
                                                <i class="bi bi-check-all"></i> Todos
                                            </button>
                                        </div>
                                    </th>
                                    <th class="text-center" style="width: 15%;">
                                        <div>
                                            <i class="bi bi-trash"></i> Excluir
                                            <br>
                                            <button type="button" class="btn btn-sm btn-outline-primary mt-1"
                                                    onclick="toggleAllPermissions('can_delete')"
                                                    title="Marcar/Desmarcar todos">
                                                <i class="bi bi-check-all"></i> Todos
                                            </button>
                                        </div>
                                    </th>
                                    <th class="text-center" style="width: 15%;">Movimento</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($modulos as $moduloKey => $modulo):
                                    $perm = $permissoesExistentes[$moduloKey] ?? null;
                                ?>
                                <tr>
                                    <td>
                                        <strong><?= htmlspecialchars($modulo['nome']) ?></strong>
                                        <br>
                                        <small class="text-muted"><?= htmlspecialchars($modulo['descricao']) ?></small>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-check form-switch d-flex justify-content-center">
                                            <input class="form-check-input" type="checkbox"
                                                   name="permissoes[<?= $moduloKey ?>][can_view]"
                                                   id="perm_view_<?= $moduloKey ?>"
                                                   value="1"
                                                   <?= ($perm && $perm['can_view']) ? 'checked' : '' ?>>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-check form-switch d-flex justify-content-center">
                                            <input class="form-check-input" type="checkbox"
                                                   name="permissoes[<?= $moduloKey ?>][can_create]"
                                                   id="perm_create_<?= $moduloKey ?>"
                                                   value="1"
                                                   <?= ($perm && $perm['can_create']) ? 'checked' : '' ?>>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-check form-switch d-flex justify-content-center">
                                            <input class="form-check-input" type="checkbox"
                                                   name="permissoes[<?= $moduloKey ?>][can_edit]"
                                                   id="perm_edit_<?= $moduloKey ?>"
                                                   value="1"
                                                   <?= ($perm && $perm['can_edit']) ? 'checked' : '' ?>>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-check form-switch d-flex justify-content-center">
                                            <input class="form-check-input" type="checkbox"
                                                   name="permissoes[<?= $moduloKey ?>][can_delete]"
                                                   id="perm_delete_<?= $moduloKey ?>"
                                                   value="1"
                                                   <?= ($perm && $perm['can_delete']) ? 'checked' : '' ?>>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-sm btn-outline-info"
                                                onclick="abrirMovimentosModulo('<?= $moduloKey ?>', '<?= htmlspecialchars($modulo['nome'], ENT_QUOTES) ?>')"
                                                title="Movimento">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="alert alert-warning mt-3">
                        <i class="bi bi-exclamation-triangle me-2"></i>
                        <strong>Atenção:</strong> As permissões são salvas automaticamente ao atualizar o usuário.
                        Usuários com perfil "admin" têm acesso total independente das permissões configuradas.
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <hr class="my-4">

            <div class="d-flex justify-content-between">
                <a href="<?= url('/usuarios') ?>" class="btn btn-secondary">
                    <i class="bi bi-arrow-left me-2"></i> Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-lg me-2"></i>
                    <?= $isEdit ? 'Atualizar Usuário' : 'Cadastrar Usuário' ?>
                </button>
            </div>
        </form>
    </div>
</div>

<style>
.nav-tabs .nav-link {
    border: none;
    border-bottom: 3px solid transparent;
    color: #6c757d;
    font-weight: 500;
    padding: 1rem 1.5rem;
}

.nav-tabs .nav-link.active {
    border-bottom-color: #0d6efd;
    color: #0d6efd;
    background: transparent;
}

.nav-tabs .nav-link:hover {
    border-bottom-color: #0d6efd;
    color: #0d6efd;
}

    .tab-content {
        padding-top: 1rem;
    }

    .movimento-permissoes {
        padding: 10px 0;
    }

    .permissao-item {
        padding: 15px;
        background: #f8f9fa;
        border-radius: 8px;
        border: 1px solid #e9ecef;
        transition: all 0.2s;
    }

    .permissao-item:hover {
        background: #e9ecef;
        border-color: #dee2e6;
    }

    .permissao-item strong {
        font-size: 15px;
        color: #212529;
    }

    .permissao-item i {
        font-size: 18px;
    }

    .table-responsive {
        max-height: 600px;
        overflow-y: auto;
    }

    .form-check-input {
        cursor: pointer;
    }

    .form-check-input:checked {
        background-color: #0d6efd;
        border-color: #0d6efd;
    }

    .table thead th button {
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
    }

/* Modern Switch Styles - Compacto */
.modern-switch-wrapper {
    position: relative;
    display: flex;
    align-items: center;
    padding: 8px 12px;
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.modern-switch-wrapper:hover {
    border-color: #0066CC;
    background: #e7f3ff;
    transform: translateX(2px);
}

.modern-switch-input {
    position: absolute;
    opacity: 0;
    cursor: pointer;
    height: 0;
    width: 0;
}

.modern-switch-label {
    display: flex;
    align-items: center;
    cursor: pointer;
    user-select: none;
    width: 100%;
    margin: 0;
    font-weight: 500;
}

.modern-switch-slider {
    position: relative;
    width: 40px;
    height: 20px;
    background-color: #cbd5e0;
    border-radius: 20px;
    transition: all 0.2s ease;
    margin-right: 10px;
    box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.1);
}

.modern-switch-slider:before {
    content: "";
    position: absolute;
    height: 16px;
    width: 16px;
    left: 2px;
    bottom: 2px;
    background-color: white;
    border-radius: 50%;
    transition: all 0.2s ease;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
}

.modern-switch-input:checked+.modern-switch-label .modern-switch-slider {
    background: linear-gradient(135deg, #0066CC 0%, #0052a3 100%);
}

.modern-switch-input:checked+.modern-switch-label .modern-switch-slider:before {
    transform: translateX(20px);
}

.modern-switch-wrapper:has(.modern-switch-input:checked) {
    border-color: #0066CC;
    background: #e7f3ff;
}

.modern-switch-text {
    flex: 1;
    font-size: 0.9rem;
    color: #2c3e50;
}

.modern-switch-input:checked+.modern-switch-label .modern-switch-text {
    color: #0066CC;
    font-weight: 600;
}

.modern-switch-wrapper:active {
    transform: scale(0.98);
}

.empresa-item-wrapper {
    padding: 10px 12px !important;
    transition: all 0.2s ease;
}

.empresa-item-wrapper:hover {
    background: #e9ecef !important;
    transform: translateX(2px);
    border-color: #dee2e6 !important;
}

.empresa-item-wrapper.is-checked {
    background: #e7f5ff !important;
    border-color: #0d6efd !important;
}
</style>

<script>
// Aplica máscaras ao carregar a página (para modo de edição)
document.addEventListener('DOMContentLoaded', function() {
    // Verificar se há parâmetro tab na URL para abrir aba específica
    const urlParams = new URLSearchParams(window.location.search);
    const tabParam = urlParams.get('tab');
    if (tabParam) {
        const tabButton = document.querySelector(`[data-bs-target="#${tabParam}"]`);
        if (tabButton) {
            const tab = new bootstrap.Tab(tabButton);
            tab.show();
        }
    }

    // Inicializar tooltips do Bootstrap
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });

    // Aplica máscara de CPF se houver valor
    const cpfInput = document.getElementById('func_cpf');
    if (cpfInput && cpfInput.value) {
        maskCPF(cpfInput);
    }

    // Aplica máscara de telefone se houver valor
    const telefoneInput = document.getElementById('func_telefone');
    if (telefoneInput && telefoneInput.value) {
        maskPhone(telefoneInput);
    }

    // Aplica máscara de data se houver valor
    const dataInput = document.getElementById('func_data_admissao');
    if (dataInput && dataInput.value) {
        maskDate(dataInput);
    }

    // Aplica máscara de salário se houver valor
    const salarioInput = document.getElementById('func_salario');
    if (salarioInput && salarioInput.value) {
        maskMoney(salarioInput);
    }

    // Gerenciamento de empresas vinculadas
    const empresasVinculadasInput = $('#empresas_vinculadas_user_input');

    function atualizarEmpresasVinculadas() {
        const empresasIds = [];
        $('.empresa-user-checkbox:checked').each(function() {
            empresasIds.push(parseInt($(this).val()));
        });
        empresasVinculadasInput.val(JSON.stringify(empresasIds));

        // Atualizar estado visual dos itens
        $('.empresa-user-checkbox').each(function() {
            const wrapper = $(this).closest('.empresa-item-wrapper');
            if ($(this).is(':checked')) {
                wrapper.addClass('is-checked');
            } else {
                wrapper.removeClass('is-checked');
            }
        });
    }

    // "Marcar todas" empresas
    $('#marcar_todas_empresas_user').on('change', function() {
        const isChecked = $(this).is(':checked');
        $('.empresa-user-checkbox').prop('checked', isChecked).trigger('change');
        atualizarEmpresasVinculadas();
    });

    // Atualizar quando uma empresa individual for selecionada/deselecionada
    $(document).on('change', '.empresa-user-checkbox', function() {
        atualizarEmpresasVinculadas();

        // Atualizar estado do "marcar todas"
        const totalCheckboxes = $('.empresa-user-checkbox').length;
        const checkedCheckboxes = $('.empresa-user-checkbox:checked').length;
        if (checkedCheckboxes === totalCheckboxes && totalCheckboxes > 0) {
            $('#marcar_todas_empresas_user').prop('checked', true);
        } else {
            $('#marcar_todas_empresas_user').prop('checked', false);
        }
    });

    // Verificar estado inicial do "marcar todas"
    setTimeout(function() {
        const totalCheckboxes = $('.empresa-user-checkbox').length;
        const checkedCheckboxes = $('.empresa-user-checkbox:checked').length;
        if (totalCheckboxes > 0 && checkedCheckboxes === totalCheckboxes) {
            $('#marcar_todas_empresas_user').prop('checked', true);
        }

        // Inicializar estado visual dos itens
        atualizarEmpresasVinculadas();
    }, 100);
});

// Toggle password visibility
function togglePassword() {
    const passwordInput = document.getElementById('password');
    const icon = document.getElementById('togglePasswordIcon');

    if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        icon.classList.remove('bi-eye');
        icon.classList.add('bi-eye-slash');
    } else {
        passwordInput.type = 'password';
        icon.classList.remove('bi-eye-slash');
        icon.classList.add('bi-eye');
    }
}

// Máscaras
function maskPhone(input) {
    let value = input.value.replace(/\D/g, '');

    if (value.length <= 11) {
        // Aplica máscara progressivamente
        if (value.length <= 2) {
            value = value.replace(/^(\d{0,2})/, '($1');
        } else if (value.length <= 6) {
            // Telefone fixo: (00) 0000
            value = value.replace(/^(\d{2})(\d{0,4})/, '($1) $2');
        } else if (value.length <= 10) {
            // Telefone fixo completo: (00) 0000-0000
            value = value.replace(/^(\d{2})(\d{4})(\d{0,4})/, '($1) $2-$3');
        } else {
            // Celular: (00) 00000-0000
            value = value.replace(/^(\d{2})(\d{5})(\d{0,4})/, '($1) $2-$3');
        }
    } else {
        // Limita a 11 dígitos (celular)
        value = value.substring(0, 11);
        value = value.replace(/^(\d{2})(\d{5})(\d{4})/, '($1) $2-$3');
    }

    input.value = value;
}

function maskCPF(input) {
    let value = input.value.replace(/\D/g, '');

    if (value.length <= 11) {
        // Aplica máscara progressivamente
        if (value.length <= 3) {
            value = value.replace(/^(\d{0,3})/, '$1');
        } else if (value.length <= 6) {
            value = value.replace(/^(\d{3})(\d{0,3})/, '$1.$2');
        } else if (value.length <= 9) {
            value = value.replace(/^(\d{3})(\d{3})(\d{0,3})/, '$1.$2.$3');
        } else {
            value = value.replace(/^(\d{3})(\d{3})(\d{3})(\d{0,2})/, '$1.$2.$3-$4');
        }
    } else {
        // Limita a 11 dígitos
        value = value.substring(0, 11);
        value = value.replace(/^(\d{3})(\d{3})(\d{3})(\d{2})/, '$1.$2.$3-$4');
    }

    input.value = value;
}

function maskMoney(input) {
    let value = input.value.replace(/\D/g, '');

    if (value === '' || value === '0') {
        input.value = '';
        return;
    }

    // Converte para centavos
    value = (parseFloat(value) / 100).toFixed(2);

    // Formata com separadores
    value = value.replace('.', ',');
    value = value.replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1.');

    input.value = 'R$ ' + value;
}

function maskDate(input) {
    let value = input.value.replace(/\D/g, '');

    if (value.length <= 8) {
        // Aplica máscara progressivamente
        if (value.length <= 2) {
            value = value.replace(/^(\d{0,2})/, '$1');
        } else if (value.length <= 4) {
            value = value.replace(/^(\d{2})(\d{0,2})/, '$1/$2');
        } else {
            value = value.replace(/^(\d{2})(\d{2})(\d{0,4})/, '$1/$2/$3');
        }
    } else {
        // Limita a 8 dígitos
        value = value.substring(0, 8);
        value = value.replace(/^(\d{2})(\d{2})(\d{4})/, '$1/$2/$3');
    }

    input.value = value;
}

// Inicializar tooltips do Bootstrap
document.addEventListener('DOMContentLoaded', function() {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});

// Função para marcar/desmarcar todas as permissões de uma coluna
function toggleAllPermissions(permissionType) {
    const checkboxes = document.querySelectorAll(`input[name*="[${permissionType}]"]`);

    if (checkboxes.length === 0) {
        return;
    }

    // Verificar se todos estão marcados
    const allChecked = Array.from(checkboxes).every(cb => cb.checked);

    // Se todos estão marcados, desmarcar todos. Caso contrário, marcar todos
    checkboxes.forEach(checkbox => {
        checkbox.checked = !allChecked;
    });
}

// Função para abrir opções de movimento do módulo (permissões)
function abrirMovimentosModulo(moduloKey, moduloNome) {
    // Buscar os checkboxes atuais do módulo
    const checkboxCriar = document.getElementById(`perm_create_${moduloKey}`);
    const checkboxEditar = document.getElementById(`perm_edit_${moduloKey}`);
    const checkboxExcluir = document.getElementById(`perm_delete_${moduloKey}`);

    const criarChecked = checkboxCriar ? checkboxCriar.checked : false;
    const editarChecked = checkboxEditar ? checkboxEditar.checked : false;
    const excluirChecked = checkboxExcluir ? checkboxExcluir.checked : false;

    Swal.fire({
        title: `Permissões - ${moduloNome}`,
        html: `
            <div class="movimento-permissoes">
                <div class="permissao-item mb-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <i class="bi bi-plus-circle text-primary me-2"></i>
                            <strong>Incluir</strong>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox"
                                   id="swal_criar_${moduloKey}"
                                   ${criarChecked ? 'checked' : ''}
                                   style="cursor: pointer; width: 3rem; height: 1.5rem;">
                        </div>
                    </div>
                </div>
                <div class="permissao-item mb-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <i class="bi bi-pencil text-warning me-2"></i>
                            <strong>Editar</strong>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox"
                                   id="swal_editar_${moduloKey}"
                                   ${editarChecked ? 'checked' : ''}
                                   style="cursor: pointer; width: 3rem; height: 1.5rem;">
                        </div>
                    </div>
                </div>
                <div class="permissao-item">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <i class="bi bi-trash text-danger me-2"></i>
                            <strong>Excluir</strong>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox"
                                   id="swal_excluir_${moduloKey}"
                                   ${excluirChecked ? 'checked' : ''}
                                   style="cursor: pointer; width: 3rem; height: 1.5rem;">
                        </div>
                    </div>
                </div>
            </div>
        `,
        icon: 'info',
        showConfirmButton: true,
        confirmButtonText: 'Salvar',
        confirmButtonColor: '#0d6efd',
        showCancelButton: true,
        cancelButtonText: 'Fechar',
        cancelButtonColor: '#6c757d',
        width: '450px',
        customClass: {
            htmlContainer: 'text-start'
        },
        didOpen: () => {
            // Sincronizar mudanças dos switches com os checkboxes originais
            const swalCriar = document.getElementById(`swal_criar_${moduloKey}`);
            const swalEditar = document.getElementById(`swal_editar_${moduloKey}`);
            const swalExcluir = document.getElementById(`swal_excluir_${moduloKey}`);

            if (swalCriar && checkboxCriar) {
                swalCriar.addEventListener('change', function() {
                    checkboxCriar.checked = this.checked;
                });
            }

            if (swalEditar && checkboxEditar) {
                swalEditar.addEventListener('change', function() {
                    checkboxEditar.checked = this.checked;
                });
            }

            if (swalExcluir && checkboxExcluir) {
                swalExcluir.addEventListener('change', function() {
                    checkboxExcluir.checked = this.checked;
                });
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            // Sincronizar valores finais antes de fechar
            if (checkboxCriar && document.getElementById(`swal_criar_${moduloKey}`)) {
                checkboxCriar.checked = document.getElementById(`swal_criar_${moduloKey}`).checked;
            }
            if (checkboxEditar && document.getElementById(`swal_editar_${moduloKey}`)) {
                checkboxEditar.checked = document.getElementById(`swal_editar_${moduloKey}`).checked;
            }
            if (checkboxExcluir && document.getElementById(`swal_excluir_${moduloKey}`)) {
                checkboxExcluir.checked = document.getElementById(`swal_excluir_${moduloKey}`).checked;
            }

            Swal.fire({
                icon: 'success',
                title: 'Permissões atualizadas',
                text: 'As alterações serão salvas ao atualizar o usuário.',
                timer: 2000,
                showConfirmButton: false
            });
        }
    });
}

// Submit form
document.getElementById('usuarioForm').addEventListener('submit', function(e) {
    e.preventDefault();

    // Validar perfil_acesso_id antes de enviar (permitir 0 para "Sem perfil")
    const perfilAcessoSelect = document.getElementById('perfil_acesso_id');
    if (!perfilAcessoSelect || perfilAcessoSelect.value === '') {
        // Garantir que a aba com o campo perfil_acesso_id esteja visível antes de mostrar o erro
        const perfilTab = document.getElementById('usuario-tab');
        const perfilPane = document.getElementById('usuario');
        if (perfilTab && perfilPane) {
            // Ativar a aba se não estiver ativa
            if (!perfilPane.classList.contains('show')) {
                const tabTrigger = new bootstrap.Tab(perfilTab);
                tabTrigger.show();
            }
        }

        // Aguardar a transição da aba antes de focar e mostrar o erro
        setTimeout(() => {
            if (perfilAcessoSelect) {
                perfilAcessoSelect.focus();
                perfilAcessoSelect.scrollIntoView({ behavior: 'smooth', block: 'center' });
            }

            Swal.fire({
                icon: 'error',
                title: 'Campo obrigatório',
                text: 'Por favor, selecione um perfil de acesso ou "Sem perfil"',
                confirmButtonText: 'OK'
            });
        }, perfilPane && !perfilPane.classList.contains('show') ? 350 : 0);

        return;
    }

    // Validar campos obrigatórios
    const name = document.getElementById('name').value.trim();
    const email = document.getElementById('email').value.trim();
    const password = document.getElementById('password').value;
    const isEdit = <?= $isEdit ? 'true' : 'false' ?>;

    if (!name) {
        Swal.fire({
            icon: 'error',
            title: 'Campo obrigatório',
            text: 'Por favor, preencha o nome completo',
            confirmButtonText: 'OK'
        });
        document.getElementById('name').focus();
        return;
    }

    if (!email) {
        Swal.fire({
            icon: 'error',
            title: 'Campo obrigatório',
            text: 'Por favor, preencha o e-mail',
            confirmButtonText: 'OK'
        });
        document.getElementById('email').focus();
        return;
    }

    if (!isEdit && !password) {
        Swal.fire({
            icon: 'error',
            title: 'Campo obrigatório',
            text: 'Por favor, preencha a senha',
            confirmButtonText: 'OK'
        });
        document.getElementById('password').focus();
        return;
    }

    const formData = new FormData(this);

    // Garantir que perfil_acesso_id seja enviado corretamente (mesmo que seja 0 para "sem perfil")
    if (perfilAcessoSelect.value === '' || perfilAcessoSelect.value === null) {
        formData.set('perfil_acesso_id', '0'); // "Sem perfil"
    }

    // Log para debug - listar todos os campos do FormData
    console.log('=== DADOS DO FORMULÁRIO ===');
    console.log('Perfil de acesso selecionado:', perfilAcessoSelect.value);
    for (let [key, value] of formData.entries()) {
        // Não mostrar senha completa por segurança
        if (key === 'password') {
            console.log(`${key}: ${value ? '***' + value.length + ' caracteres***' : 'VAZIO'}`);
        } else {
            console.log(`${key}:`, value);
        }
    }
    console.log('==========================');

    // Loading overlay
    Swal.fire({
        title: '<?= $isEdit ? 'Atualizando...' : 'Cadastrando...' ?>',
        text: 'Por favor, aguarde',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    // Construir URL correta usando appUrl()
    const actionPath = this.action;
    // Extrair apenas o path (remover domínio se houver)
    const pathMatch = actionPath.match(/\/usuarios\/(editar|criar)/);
    const finalPath = pathMatch ? pathMatch[0] : '/usuarios/editar';
    const finalUrl = appUrl(finalPath);

    console.log('Action original:', actionPath);
    console.log('Path extraído:', finalPath);
    console.log('URL final:', finalUrl);

    fetch(finalUrl, {
        method: 'POST',
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: formData
    })
    .then(async response => {
        // Tentar parsear como JSON primeiro, mesmo em caso de erro (400, 500, etc)
        // O servidor pode retornar JSON mesmo com status de erro
        let data;
        let responseText = '';

        try {
            // Sempre tentar ler como texto primeiro para ter a resposta completa
            responseText = await response.clone().text();

            // Tentar parsear como JSON
            if (responseText.trim().startsWith('{') || responseText.trim().startsWith('[')) {
                try {
                    data = JSON.parse(responseText);
                } catch (e) {
                    // Não é JSON válido, continuar como texto
                    console.warn('Resposta não é JSON válido, mas parece tentar ser:', e);
                }
            }
        } catch (e) {
            console.error('Erro ao ler resposta:', e);
        }

        // Se não conseguiu parsear como JSON, verificar Content-Type
        if (!data) {
            const contentType = response.headers.get('content-type') || '';
            console.error('Não foi possível parsear como JSON');
            console.error('Content-Type:', contentType);
            console.error('Status:', response.status, response.statusText);
            console.error('Resposta (primeiros 500 chars):', responseText.substring(0, 500));

            if (!response.ok) {
                // Tentar extrair mensagem de erro do HTML se for uma página de erro
                let errorMsg = `Erro ${response.status}: ${response.statusText}`;
                if (responseText) {
                    // Tentar extrair mensagem de erro de tags HTML comuns
                    const errorMatch = responseText.match(/<h1[^>]*>(.*?)<\/h1>/i) ||
                                     responseText.match(/<title[^>]*>(.*?)<\/title>/i) ||
                                     responseText.match(/Erro[:\s]+(.*?)(?:<|$)/i);
                    if (errorMatch && errorMatch[1]) {
                        errorMsg += ' - ' + errorMatch[1].trim();
                    }
                }
                throw new Error(errorMsg);
            }
            throw new Error('Resposta não é JSON. Pode ser um erro de roteamento.');
        }

        // Retornar dados mesmo se não foi OK (para processar erros JSON do servidor)
        return data;
    })
    .then(data => {
        Swal.close();

        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Sucesso!',
                text: data.message,
                confirmButtonText: 'OK'
            }).then(() => {
                window.location.href = appUrl('/usuarios');
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Erro!',
                text: data.message || 'Erro ao salvar usuário',
                confirmButtonText: 'OK'
            });
        }
    })
    .catch(error => {
        Swal.close();
        console.error('Erro:', error);
        console.error('URL da requisição:', finalUrl);

        let errorMessage = 'Ocorreu um erro inesperado';
        if (error.message) {
            errorMessage = error.message;
        }

        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: errorMessage,
            confirmButtonText: 'OK'
        });
    });
});
</script>