<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-eye me-2"></i> Visualizar Transferência</h2>
        <p class="text-muted">Detalhes da transferência de estoque</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/estoque/transferencia') ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
        <a href="<?= url('/estoque/transferencia/editar?id=' . $transferencia['id']) ?>" class="btn btn-primary">
            <i class="bi bi-pencil me-2"></i> Editar
        </a>
    </div>
</div>

<!-- Dados da Transferência -->
<div class="card mb-4">
    <div class="card-header bg-primary text-white">
        <i class="bi bi-file-earmark-text me-2"></i> Dados da Transferência
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="form-label text-muted">Número</label>
                <p class="fw-bold"><?= htmlspecialchars($transferencia['numero'] ?? '-') ?></p>
            </div>
            <div class="col-md-3 mb-3">
                <label class="form-label text-muted">Data</label>
                <p class="fw-bold"><?= date('d/m/Y', strtotime($transferencia['data_transferencia'])) ?></p>
            </div>
            <div class="col-md-3 mb-3">
                <label class="form-label text-muted">Local de Origem</label>
                <p class="fw-bold">
                    <i class="bi bi-box-arrow-up text-danger me-1"></i>
                    <?php if (!empty($transferencia['empresa_origem_nome'])): ?>
                        <strong><?= htmlspecialchars($transferencia['empresa_origem_nome']) ?></strong><br>
                        <small
                            class="text-muted"><?= htmlspecialchars($transferencia['local_origem_nome'] ?? '-') ?></small>
                    <?php else: ?>
                        <?= htmlspecialchars($transferencia['local_origem_nome'] ?? '-') ?>
                    <?php endif; ?>
                </p>
            </div>
            <div class="col-md-3 mb-3">
                <label class="form-label text-muted">Local de Destino</label>
                <p class="fw-bold">
                    <i class="bi bi-box-arrow-in-down text-success me-1"></i>
                    <?php if (!empty($transferencia['empresa_destino_nome'])): ?>
                        <strong><?= htmlspecialchars($transferencia['empresa_destino_nome']) ?></strong><br>
                        <small
                            class="text-muted"><?= htmlspecialchars($transferencia['local_destino_nome'] ?? '-') ?></small>
                    <?php else: ?>
                        <?= htmlspecialchars($transferencia['local_destino_nome'] ?? '-') ?>
                    <?php endif; ?>
                </p>
            </div>
        </div>
        <?php if (!empty($transferencia['observacoes'])): ?>
            <div class="row">
                <div class="col-md-12">
                    <label class="form-label text-muted">Observações</label>
                    <p><?= nl2br(htmlspecialchars($transferencia['observacoes'])) ?></p>
                </div>
            </div>
        <?php endif; ?>
        <div class="row">
            <div class="col-md-6">
                <label class="form-label text-muted">Criado por</label>
                <p><?= htmlspecialchars($transferencia['usuario_nome'] ?? '-') ?></p>
            </div>
            <div class="col-md-6">
                <label class="form-label text-muted">Data de Criação</label>
                <p><?= date('d/m/Y H:i', strtotime($transferencia['created_at'])) ?></p>
            </div>
        </div>
    </div>
</div>

<!-- Itens -->
<div class="card">
    <div class="card-header bg-success text-white">
        <i class="bi bi-box-seam me-2"></i> Itens da Transferência
    </div>
    <div class="card-body p-0">
        <?php if (!empty($itens)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="5%">#</th>
                            <th width="35%">Item</th>
                            <th width="15%">Código</th>
                            <th width="15%">Quantidade</th>
                            <th width="30%">Observações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($itens as $index => $item): ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><strong><?= htmlspecialchars($item['item_nome'] ?? '-') ?></strong></td>
                                <td><?= htmlspecialchars($item['item_codigo'] ?? '-') ?></td>
                                <td>
                                    <span class="badge bg-info">
                                        <?= number_format($item['quantidade'] ?? 0, 3, ',', '.') ?>
                                        <?= htmlspecialchars($item['item_unidade'] ?? 'UN') ?>
                                    </span>
                                </td>
                                <td><?= htmlspecialchars($item['observacoes'] ?? '-') ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <tr class="table-light">
                            <td colspan="3" class="text-end fw-bold">Total de Itens:</td>
                            <td colspan="2">
                                <span class="badge bg-primary"><?= count($itens) ?> item(ns)</span>
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-inbox" style="font-size: 3rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhum item encontrado nesta transferência</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php
$content = ob_get_clean();
$activeMenu = 'estoque';
include ROOT_PATH . '/views/layouts/app.php';
?>