<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-arrow-left-right me-2"></i> Transferências de Estoque</h2>
        <p class="text-muted">Gerencie transferências entre locais de estoque</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/estoque/transferencia/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Nova Transferência
        </a>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-9">
                <input type="text" class="form-control" name="search"
                    placeholder="Buscar por número, local origem, local destino..."
                    value="<?= htmlspecialchars($search ?? '') ?>">
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-secondary w-100">
                    <i class="bi bi-search"></i> Buscar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Lista de Transferências</span>
        <span class="badge bg-primary"><?= count($transferencias ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($transferencias)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th>Número</th>
                            <th>Data</th>
                            <th>Origem</th>
                            <th>Destino</th>
                            <th>Itens</th>
                            <th>Usuário</th>
                            <th width="150">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transferencias as $transferencia): ?>
                            <tr>
                                <td><?= $transferencia['id'] ?></td>
                                <td><strong><?= htmlspecialchars($transferencia['numero'] ?? '-') ?></strong></td>
                                <td><?= date('d/m/Y', strtotime($transferencia['data_transferencia'])) ?></td>
                                <td>
                                    <i class="bi bi-box-arrow-up text-danger me-1"></i>
                                    <?php if (!empty($transferencia['empresa_origem_nome'])): ?>
                                        <strong><?= htmlspecialchars($transferencia['empresa_origem_nome']) ?></strong><br>
                                        <small
                                            class="text-muted"><?= htmlspecialchars($transferencia['local_origem_nome'] ?? '-') ?></small>
                                    <?php else: ?>
                                        <?= htmlspecialchars($transferencia['local_origem_nome'] ?? '-') ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <i class="bi bi-box-arrow-in-down text-success me-1"></i>
                                    <?php if (!empty($transferencia['empresa_destino_nome'])): ?>
                                        <strong><?= htmlspecialchars($transferencia['empresa_destino_nome']) ?></strong><br>
                                        <small
                                            class="text-muted"><?= htmlspecialchars($transferencia['local_destino_nome'] ?? '-') ?></small>
                                    <?php else: ?>
                                        <?= htmlspecialchars($transferencia['local_destino_nome'] ?? '-') ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-info"><?= $transferencia['total_itens'] ?? 0 ?> item(ns)</span>
                                </td>
                                <td><?= htmlspecialchars($transferencia['usuario_nome'] ?? '-') ?></td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?= url('/estoque/transferencia/visualizar?id=' . $transferencia['id']) ?>"
                                            class="btn btn-info" title="Visualizar">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <button type="button" class="btn btn-danger"
                                            onclick="deletarTransferencia(<?= $transferencia['id'] ?>, '<?= htmlspecialchars($transferencia['numero']) ?>')"
                                            title="Excluir">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-arrow-left-right" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhuma transferência encontrada</p>
                <a href="<?= url('/estoque/transferencia/criar') ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle me-2"></i> Criar Primeira Transferência
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    function deletarTransferencia(id, numero) {
        Swal.fire({
            title: 'Confirmar Exclusão',
            text: `Deseja realmente excluir a transferência ${numero}? Esta ação não pode ser desfeita.`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Sim, excluir',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: appUrl('/estoque/transferencia/deletar'),
                    type: 'POST',
                    data: { id: id },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message || 'Transferência excluída com sucesso',
                                timer: 1500,
                                showConfirmButton: false
                            }).then(() => {
                                window.location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: response.message || 'Erro ao excluir transferência'
                            });
                        }
                    },
                    error: function (xhr) {
                        const response = xhr.responseJSON;
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: response?.message || 'Erro ao excluir transferência'
                        });
                    }
                });
            }
        });
    }
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'estoque';
include ROOT_PATH . '/views/layouts/app.php';
?>