<?php
$isEdit = isset($transferencia['id']);
$itens = $itens ?? [];
?>

<div class="row mb-4">
    <div class="col-md-8">
        <h2><i class="bi bi-arrow-left-right me-2"></i> <?= $isEdit ? 'Editar' : 'Nova' ?> Transferência de Estoque</h2>
        <p class="text-muted">Transfira produtos entre locais de estoque ou entre empresas</p>
    </div>
</div>

<form id="formTransferencia" method="POST"
    action="<?= url($isEdit ? '/estoque/transferencia/editar' : '/estoque/transferencia/criar') ?>">
    <?php if ($isEdit): ?>
        <input type="hidden" name="id" value="<?= $transferencia['id'] ?>">
    <?php endif; ?>

    <div class="card mb-4">
        <div class="card-header text-white"
            style="background-color: #001122 !important; border-color: #001122 !important;">
            <i class="bi bi-file-earmark-text me-2"></i> Dados da Transferência
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-3 mb-3">
                    <label for="numero" class="form-label">Número *</label>
                    <input type="text" class="form-control" id="numero" name="numero"
                        value="<?= htmlspecialchars($transferencia['numero'] ?? $proximoNumero ?? 'TRF-000001') ?>"
                        required <?= $isEdit ? 'readonly' : '' ?>>
                </div>
                <div class="col-md-3 mb-3">
                    <label for="data_transferencia" class="form-label">Data *</label>
                    <input type="date" class="form-control" id="data_transferencia" name="data_transferencia"
                        value="<?= $transferencia['data_transferencia'] ?? date('Y-m-d') ?>" required readonly>
                </div>
                <div class="col-md-3 mb-3">
                    <label for="local_origem_id" class="form-label">Local de Origem *</label>
                    <select class="form-select" id="local_origem_id" name="local_origem_id" required>
                        <option value="">Selecione...</option>
                        <?php foreach ($locais ?? [] as $local): ?>
                            <option value="<?= $local['id'] ?>" <?= ($transferencia['local_origem_id'] ?? '') == $local['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($local['name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <label for="local_destino_id" class="form-label">Local de Destino *</label>
                    <select class="form-select" id="local_destino_id" name="local_destino_id" required>
                        <option value="">Selecione...</option>
                        <?php foreach ($locais ?? [] as $local): ?>
                            <option value="<?= $local['id'] ?>" <?= ($transferencia['local_destino_id'] ?? '') == $local['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($local['name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="empresa_origem_id" class="form-label">
                        <i class="bi bi-building me-1"></i> Empresa de Origem
                    </label>
                    <select class="form-select" id="empresa_origem_id" name="empresa_origem_id">
                        <option value="">Selecione uma empresa (opcional)...</option>
                        <?php if (!empty($empresasVinculadas ?? [])): ?>
                            <?php foreach ($empresasVinculadas as $empresa): ?>
                                <?php
                                $nome = $empresa['razao_social'] ?? $empresa['nome_fantasia'] ?? 'Empresa';
                                $cnpj = $empresa['cnpj'] ?? '';
                                if ($cnpj && strlen($cnpj) === 14) {
                                    $cnpj = preg_replace('/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/', '$1.$2.$3/$4-$5', $cnpj);
                                }
                                $selected = (isset($transferencia) && isset($transferencia['empresa_origem_id']) && $transferencia['empresa_origem_id'] == $empresa['id']) ? 'selected' : '';
                                ?>
                                <option value="<?= $empresa['id'] ?>" <?= $selected ?>>
                                    <?= htmlspecialchars($nome) ?>
                                    <?= $cnpj ? ' - ' . htmlspecialchars($cnpj) : '' ?>
                                </option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                    <small class="text-muted">Deixe em branco para transferência entre locais da mesma empresa</small>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="empresa_destino_id" class="form-label">
                        <i class="bi bi-building me-1"></i> Empresa de Destino
                    </label>
                    <select class="form-select" id="empresa_destino_id" name="empresa_destino_id">
                        <option value="">Selecione uma empresa (opcional)...</option>
                        <?php if (!empty($empresasVinculadas ?? [])): ?>
                            <?php foreach ($empresasVinculadas as $empresa): ?>
                                <?php
                                $nome = $empresa['razao_social'] ?? $empresa['nome_fantasia'] ?? 'Empresa';
                                $cnpj = $empresa['cnpj'] ?? '';
                                if ($cnpj && strlen($cnpj) === 14) {
                                    $cnpj = preg_replace('/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/', '$1.$2.$3/$4-$5', $cnpj);
                                }
                                $selected = (isset($transferencia) && isset($transferencia['empresa_destino_id']) && $transferencia['empresa_destino_id'] == $empresa['id']) ? 'selected' : '';
                                ?>
                                <option value="<?= $empresa['id'] ?>" <?= $selected ?>>
                                    <?= htmlspecialchars($nome) ?>
                                    <?= $cnpj ? ' - ' . htmlspecialchars($cnpj) : '' ?>
                                </option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                    <small class="text-muted">Deixe em branco para transferência entre locais da mesma empresa</small>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 mb-3">
                    <label for="observacoes" class="form-label">Observações</label>
                    <textarea class="form-control" id="observacoes" name="observacoes" rows="2"
                        placeholder="Observações sobre esta transferência..."><?= htmlspecialchars($transferencia['observacoes'] ?? '') ?></textarea>
                </div>
            </div>
        </div>
    </div>

    <!-- Itens -->
    <div class="card mb-4">
        <div class="card-header text-white"
            style="background-color: #001122 !important; border-color: #001122 !important;">
            <span><i class="bi bi-box-seam me-2"></i> Itens da Transferência</span>
        </div>
        <div class="card-body">
            <?php if ($isEdit): ?>
                <!-- Modo visualização (edição) -->
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Item</th>
                                <th>Código</th>
                                <th>Quantidade</th>
                                <th>Observações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($itens as $item): ?>
                                <tr>
                                    <td><?= htmlspecialchars($item['item_nome'] ?? '-') ?></td>
                                    <td><?= htmlspecialchars($item['item_codigo'] ?? '-') ?></td>
                                    <td><?= number_format($item['quantidade'] ?? 0, 3, ',', '.') ?>
                                        <?= htmlspecialchars($item['item_unidade'] ?? 'UN') ?>
                                    </td>
                                    <td><?= htmlspecialchars($item['observacoes'] ?? '-') ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <!-- Modo edição (criação) -->
                <!-- Bloco para adicionar item -->
                <div class="card bg-light mb-4" id="bloco-adicionar-item">
                    <div class="card-body">
                        <h6 class="mb-3"><i class="bi bi-plus-circle me-2"></i> Adicionar Item</h6>
                        <div class="row g-3 align-items-end">
                            <?php if (!empty($usarLoteEstoque ?? false)): ?>
                                <!-- Layout com Lote -->
                                <div class="col-md-4">
                                    <label class="form-label">Produto</label>
                                    <div class="position-relative">
                                        <input type="text" class="form-control item-search" id="item_search_principal"
                                            placeholder="Digite para buscar produto..." autocomplete="off">
                                        <div id="item_dropdown_principal" class="autocomplete-dropdown" style="display: none;">
                                        </div>
                                    </div>
                                    <input type="hidden" id="produto_id_principal" value="">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Lote</label>
                                    <select class="form-select" id="lote_principal" disabled>
                                        <option value="">Selecione o produto primeiro</option>
                                    </select>
                                    <small class="text-muted" id="info_lote_principal"></small>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label">Quantidade</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" id="quantidade_principal" step="0.001"
                                            min="0.001" placeholder="0.000" value="1">
                                        <span class="input-group-text" id="unidade_principal">UN</span>
                                    </div>
                                    <small class="text-muted" id="estoque_disponivel_principal"
                                        style="font-size: 0.75rem;">Estoque: -</small>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">&nbsp;</label>
                                    <button type="button" class="btn w-100" id="btn-adicionar-item"
                                        style="background-color: #001122 !important; border-color: #001122 !important; color: white !important;">
                                        <i class="bi bi-plus-circle me-1"></i> Adicionar
                                    </button>
                                </div>
                            <?php else: ?>
                                <!-- Layout sem Lote -->
                                <div class="col-md-6">
                                    <label class="form-label">Produto</label>
                                    <div class="position-relative">
                                        <input type="text" class="form-control item-search" id="item_search_principal"
                                            placeholder="Digite para buscar produto..." autocomplete="off">
                                        <div id="item_dropdown_principal" class="autocomplete-dropdown" style="display: none;">
                                        </div>
                                    </div>
                                    <input type="hidden" id="produto_id_principal" value="">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Quantidade</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" id="quantidade_principal" step="0.001"
                                            min="0.001" placeholder="0.000" value="1">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <button type="button" class="btn w-100" id="btn-adicionar-item"
                                        style="background-color: #001122 !important; border-color: #001122 !important; color: white !important;">
                                        <i class="bi bi-plus-circle me-1"></i> Adicionar
                                    </button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Tabela de itens -->
                <div id="itens-container">
                    <div class="table-responsive">
                        <table class="table table-hover" id="tabela-itens">
                            <thead>
                                <tr>
                                    <th width="35%">Item</th>
                                    <?php if ($usarLoteEstoque): ?>
                                        <th width="15%">Lote</th>
                                    <?php endif; ?>
                                    <th width="15%">Estoque</th>
                                    <th width="15%">Quantidade</th>
                                    <th width="15%">Observações</th>
                                    <th width="5%"></th>
                                </tr>
                            </thead>
                            <tbody id="itens-tbody">
                                <!-- Itens serão adicionados aqui via JavaScript -->
                            </tbody>
                        </table>
                    </div>
                    <p class="text-muted mt-3">
                        <i class="bi bi-info-circle me-1"></i>
                        Adicione os itens que serão transferidos entre os locais de estoque.
                    </p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Botões -->
    <div class="row">
        <div class="col-md-12 text-end">
            <a href="<?= url('/estoque/transferencia') ?>" class="btn btn-secondary">
                <i class="bi bi-x-circle me-2"></i> Cancelar
            </a>
            <button type="submit" class="btn" style="background-color: #001122; border-color: #001122; color: white;">
                <i class="bi bi-check-circle me-2"></i> <?= $isEdit ? 'Atualizar' : 'Salvar' ?> Transferência
            </button>
        </div>
    </div>

    <input type="hidden" name="itens" id="itens-json" value="[]">
</form>

<?php if (!$isEdit): ?>
    <style>
        .autocomplete-dropdown {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: white;
            border: 1px solid #ddd;
            border-top: none;
            border-radius: 0 0 4px 4px;
            max-height: 300px;
            overflow-y: auto;
            z-index: 1000;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .autocomplete-item {
            padding: 10px;
            cursor: pointer;
            border-bottom: 1px solid #eee;
        }

        .autocomplete-item:hover,
        .autocomplete-item.active {
            background-color: #f8f9fa;
        }

        .autocomplete-no-results {
            padding: 10px;
            color: #999;
            text-align: center;
        }

        /* Estilos para botões seguindo a paleta #001122 */
        #btn-adicionar-item {
            background-color: #001122 !important;
            border-color: #001122 !important;
            color: white !important;
        }

        #btn-adicionar-item:hover {
            background-color: #002244 !important;
            border-color: #002244 !important;
            color: white !important;
        }

        /* Garantir que os headers dos cards usem a cor correta */
        .card-header {
            background-color: #001122 !important;
            border-color: #001122 !important;
        }

        /* Sobrescrever qualquer classe Bootstrap que possa estar interferindo */
        .card-header.bg-success,
        .card-header.bg-primary {
            background-color: #001122 !important;
            border-color: #001122 !important;
        }

        button[type="submit"].btn:hover {
            background-color: #002244 !important;
            border-color: #002244 !important;
        }

        .btn-sm[onclick*="removerItem"]:hover {
            background-color: #003366 !important;
            border-color: #003366 !important;
        }

        /* Input group text seguindo a paleta */
        #unidade_principal,
        .unidade-text {
            background-color: #001122 !important;
            border-color: #001122 !important;
            color: white !important;
        }
    </style>
    <script>
        const usarLoteEstoque = <?= json_encode(!empty($usarLoteEstoque ?? false)) ?>;
        let produtosData = [];
        let selectedProduto = null;
        let selectedLote = null;
        let itemTimeoutPrincipal = null;
        let itens = [];

        // Inicializar autocomplete de produtos
        function inicializarAutocompleteItemPrincipal() {
            const $search = $('#item_search_principal');
            const $dropdown = $('#item_dropdown_principal');

            $search.on('input', function () {
                const query = $(this).val().trim().toLowerCase();
                clearTimeout(itemTimeoutPrincipal);

                if (query.length < 2) {
                    $dropdown.hide();
                    return;
                }

                itemTimeoutPrincipal = setTimeout(() => {
                    buscarProdutosPrincipal(query);
                }, 300);
            });

            $search.on('focus', function () {
                if ($(this).val().length >= 2) {
                    buscarProdutosPrincipal($(this).val().trim().toLowerCase());
                }
            });

            $(document).on('click', function (e) {
                if (!$(e.target).closest('#item_search_principal, #item_dropdown_principal').length) {
                    $dropdown.hide();
                }
            });
        }

        // Carregar produtos quando página carregar
        function carregarTodosProdutos() {
            $.ajax({
                url: appUrl('/estoque/transferencia/buscar-produtos'),
                method: 'GET',
                dataType: 'json',
                success: function (response) {
                    if (response.success && response.data && response.data.produtos) {
                        produtosData = response.data.produtos;
                        console.log('Produtos carregados:', produtosData.length);
                    } else {
                        produtosData = [];
                    }
                },
                error: function (xhr, status, error) {
                    console.error('Erro ao carregar produtos:', error);
                    produtosData = [];
                }
            });
        }

        function buscarProdutosPrincipal(query) {
            const $dropdown = $('#item_dropdown_principal');

            if (!query || query.length < 2) {
                $dropdown.hide();
                return;
            }

            // Se produtosData estiver vazio, carregar primeiro
            if (produtosData.length === 0) {
                carregarTodosProdutos();
                // Aguardar um pouco e tentar novamente
                setTimeout(() => buscarProdutosPrincipal(query), 500);
                return;
            }

            // Busca LOCAL no array (igual vendas)
            const results = produtosData.filter(produto => {
                const name = (produto.name || '').toLowerCase();
                const sku = (produto.sku || '').toLowerCase();
                const code = (produto.code || '').toLowerCase();
                return name.includes(query) || sku.includes(query) || code.includes(query);
            });

            let html = '';
            if (results.length > 0) {
                results.forEach(produto => {
                    const estoque = parseFloat(produto.stock_quantity || 0);
                    const codigo = produto.code || produto.sku || '';
                    html += `
                        <div class="autocomplete-item" data-id="${produto.id}">
                            <div class="mb-1"><strong>${produto.name}</strong>${codigo ? ' <span class="text-muted">(' + codigo + ')</span>' : ''}</div>
                            <div class="text-muted small"><strong>Estoque:</strong> ${estoque.toFixed(3)} ${produto.unit || 'UN'}</div>
                        </div>
                    `;
                });
            } else {
                html = '<div class="autocomplete-no-results">Nenhum produto encontrado</div>';
            }

            $dropdown.html(html).show();

            $dropdown.find('.autocomplete-item').on('click', function () {
                const produtoId = $(this).data('id');
                const produto = produtosData.find(p => p.id == produtoId);
                if (produto) {
                    selecionarProdutoPrincipal(produto);
                }
            });
        }

        function selecionarProdutoPrincipal(produto) {
            selectedProduto = { ...produto };
            selectedProduto.lotes = [];
            $('#produto_id_principal').val(produto.id);
            $('#item_search_principal').val(produto.name);
            $('#item_dropdown_principal').hide();

            const estoque = parseFloat(produto.stock_quantity || 0);
            const unidade = produto.unit || 'UN';
            $('#estoque_disponivel_principal').text(`Estoque: ${estoque.toFixed(3)} ${unidade}`);
            $('#unidade_principal').text(unidade);
            $('#unidade_principal_sem_lote').text(unidade);
            $('#quantidade_principal').attr('max', estoque);

            if (usarLoteEstoque) {
                buscarLotesProduto(produto.id);
            } else {
                $('#quantidade_principal').focus().select();
            }
        }

        function buscarLotesProduto(produtoId) {
            const localOrigemId = $('#local_origem_id').val() || 0;

            $.ajax({
                url: appUrl('/estoque/transferencia/buscar-lotes'),
                method: 'GET',
                data: {
                    produto_id: produtoId,
                    local_id: localOrigemId
                },
                success: function (response) {
                    if (response.success && response.data && response.data.lotes) {
                        preencherLotesProduto(response.data.lotes);
                    } else {
                        preencherLotesProduto([]);
                    }
                },
                error: function () {
                    preencherLotesProduto([]);
                }
            });
        }

        function preencherLotesProduto(lotes) {
            const $select = $('#lote_principal');
            const $infoLote = $('#info_lote_principal');
            $select.html('<option value="">Selecione o lote</option>');

            if (Array.isArray(lotes) && lotes.length > 0) {
                lotes.forEach(lote => {
                    if (!lote || !lote.lote) return;
                    const validade = lote.validade ? new Date(lote.validade + 'T00:00:00').toLocaleDateString('pt-BR') : 'Sem validade';
                    const quantidade = parseFloat(lote.quantidade || 0);
                    $select.append(`<option value="${lote.lote}" data-quantidade="${quantidade}" data-validade="${lote.validade || ''}" data-fabricacao="${lote.fabricacao || ''}">${lote.lote} - Qtd: ${quantidade.toFixed(3)} - Val: ${validade}</option>`);
                });
                $select.prop('disabled', false);
                $infoLote.text(`${lotes.length} lote(s) disponível(is)`).removeClass('text-danger').addClass('text-success');

                // Atualizar lotes no selectedProduto
                if (selectedProduto) {
                    selectedProduto.lotes = lotes;
                }

                // Focar no seletor de lote
                setTimeout(() => {
                    $('#lote_principal').focus();
                }, 100);
            } else {
                $select.prop('disabled', true);
                $infoLote.text('Nenhum lote disponível para este produto').removeClass('text-success').addClass('text-danger');

                // Focar na quantidade se não houver lotes
                setTimeout(() => {
                    $('#quantidade_principal').focus().select();
                }, 100);
            }
            selectedLote = null;
        }

        // Adicionar item à tabela
        $('#btn-adicionar-item').on('click', function () {
            adicionarItemATabela();
        });

        function adicionarItemATabela() {
            const produtoId = $('#produto_id_principal').val();
            const quantidade = parseFloat($('#quantidade_principal').val() || 0);
            const lote = usarLoteEstoque ? $('#lote_principal').val() : '';

            if (!produtoId || !selectedProduto) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Selecione um produto primeiro'
                });
                return;
            }

            if (quantidade <= 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Informe uma quantidade válida'
                });
                return;
            }

            const estoque = parseFloat(selectedProduto.stock_quantity || 0);
            if (quantidade > estoque) {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: `A quantidade não pode ser maior que o estoque disponível (${estoque.toFixed(3)})`
                });
                return;
            }

            if (usarLoteEstoque && !lote) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Selecione um lote para este produto'
                });
                $('#lote_principal').focus();
                return;
            }

            // Validar quantidade do lote se usar lote
            if (usarLoteEstoque && lote) {
                const selectedOption = $('#lote_principal').find('option:selected');
                const quantidadeLote = parseFloat(selectedOption.data('quantidade') || 0);
                if (quantidade > quantidadeLote) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: `A quantidade não pode ser maior que a disponível no lote (${quantidadeLote.toFixed(3)})`
                    });
                    return;
                }
            }

            // Verificar se produto já foi adicionado (se usando lote, verificar por lote também)
            let produtoJaExiste = false;
            $('#itens-tbody tr').each(function () {
                const itemProdutoId = $(this).data('produto-id');
                const itemLote = $(this).data('lote') || '';
                if (itemProdutoId == produtoId) {
                    if (!usarLoteEstoque || (usarLoteEstoque && itemLote === lote)) {
                        produtoJaExiste = true;
                        return false;
                    }
                }
            });

            if (produtoJaExiste) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: usarLoteEstoque ? 'Este produto com este lote já foi adicionado' : 'Este produto já foi adicionado'
                });
                return;
            }

            const itemId = 'item_' + Date.now();
            const codigo = selectedProduto.code || selectedProduto.sku || '-';
            const unidade = selectedProduto.unit || 'UN';
            const loteHtml = usarLoteEstoque ? `<td>${lote || '-'}</td>` : '';

            const row = `
                <tr id="${itemId}" data-produto-id="${produtoId}" data-lote="${lote || ''}">
                    <td>
                        <strong>${selectedProduto.name}</strong>
                        ${codigo !== '-' ? '<br><small class="text-muted">' + codigo + '</small>' : ''}
                        <input type="hidden" class="produto-id-input" value="${produtoId}">
                        ${usarLoteEstoque ? `<input type="hidden" class="lote-input" value="${lote}">` : ''}
                    </td>
                    ${loteHtml}
                    <td><span class="estoque-disponivel">${estoque.toFixed(3)} ${unidade}</span></td>
                    <td>
                        <div class="input-group">
                            <input type="number" class="form-control quantidade-input" step="0.001" min="0.001"
                                   max="${estoque}" value="${quantidade.toFixed(3)}" required>
                            <span class="input-group-text unidade-text">${unidade}</span>
                        </div>
                    </td>
                    <td>
                        <input type="text" class="form-control observacoes-input" placeholder="Observações...">
                    </td>
                    <td>
                        <button type="button" class="btn btn-sm" onclick="removerItem('${itemId}')" style="background-color: #001122; border-color: #001122; color: white;">
                            <i class="bi bi-trash"></i>
                        </button>
                    </td>
                </tr>
            `;

            $('#itens-tbody').append(row);
            atualizarItensJson();
            limparCamposItem();
        }

        function limparCamposItem() {
            $('#item_search_principal').val('');
            $('#produto_id_principal').val('');
            $('#quantidade_principal').val('1');
            $('#estoque_disponivel_principal').text('Estoque: -');
            $('#unidade_principal').text('UN');
            $('#unidade_principal_sem_lote').text('UN');
            selectedProduto = null;
            if (usarLoteEstoque) {
                $('#lote_principal').html('<option value="">Selecione o produto primeiro</option>').prop('disabled', true);
                $('#info_lote_principal').text('').removeClass('text-success text-danger');
                selectedLote = null;
            }
        }

        function removerItem(itemId) {
            $(`#${itemId}`).remove();
            atualizarItensJson();
        }

        function atualizarItensJson() {
            itens = [];
            $('#itens-tbody tr').each(function () {
                const produtoId = $(this).find('.produto-id-input').val();
                const quantidade = parseFloat($(this).find('.quantidade-input').val() || 0);
                const observacoes = $(this).find('.observacoes-input').val() || '';
                const lote = usarLoteEstoque ? $(this).find('.lote-input').val() : '';

                if (produtoId && quantidade > 0) {
                    const item = {
                        item_id: parseInt(produtoId),
                        product_id: parseInt(produtoId),
                        quantidade: quantidade,
                        observacoes: observacoes
                    };
                    if (usarLoteEstoque && lote) {
                        item.lote = lote;
                    }
                    itens.push(item);
                }
            });

            $('#itens-json').val(JSON.stringify(itens));
        }

        // Atualizar JSON quando houver mudanças
        $(document).on('change', '.quantidade-input, .observacoes-input', function () {
            atualizarItensJson();
        });

        // Inicializar quando documento estiver pronto
        $(document).ready(function () {
            inicializarAutocompleteItemPrincipal();
            carregarTodosProdutos();

            // Limpar campos quando local de origem mudar
            $('#local_origem_id').on('change', function () {
                limparCamposItem();
                $('#item_dropdown_principal').hide();
            });

            // Quando lote for selecionado, atualizar quantidade máxima
            if (usarLoteEstoque) {
                $('#lote_principal').on('change', function () {
                    const selectedOption = $(this).find('option:selected');
                    const quantidadeLote = parseFloat(selectedOption.data('quantidade') || 0);
                    selectedLote = $(this).val();

                    if (quantidadeLote > 0) {
                        $('#quantidade_principal').attr('max', quantidadeLote);
                        $('#estoque_disponivel_principal').text(`Estoque do lote: ${quantidadeLote.toFixed(3)} ${$('#unidade_principal').text()}`);
                    } else if (selectedProduto) {
                        const estoque = parseFloat(selectedProduto.stock_quantity || 0);
                        $('#quantidade_principal').attr('max', estoque);
                        $('#estoque_disponivel_principal').text(`Estoque: ${estoque.toFixed(3)} ${$('#unidade_principal').text()}`);
                    }
                });
            }
        });

        $('#formTransferencia').on('submit', function (e) {
            e.preventDefault();

            atualizarItensJson();

            if (itens.length === 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Adicione pelo menos um item à transferência'
                });
                return;
            }

            const localOrigem = $('#local_origem_id').val();
            const localDestino = $('#local_destino_id').val();
            const empresaOrigem = $('#empresa_origem_id').val();
            const empresaDestino = $('#empresa_destino_id').val();

            if (localOrigem === localDestino && !empresaOrigem && !empresaDestino) {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'O local de origem e destino não podem ser iguais quando não há transferência entre empresas'
                });
                return;
            }

            if (empresaOrigem && empresaDestino && empresaOrigem === empresaDestino && localOrigem === localDestino) {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'A empresa e o local de origem e destino não podem ser iguais'
                });
                return;
            }

            Swal.fire({
                title: 'Processando...',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            const formData = new FormData(this);

            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            text: response.message || 'Transferência salva com sucesso',
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = appUrl(response.data?.redirect || response.redirect || '/estoque/transferencia');
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: response.message || 'Erro ao salvar transferência'
                        });
                    }
                },
                error: function (xhr) {
                    const response = xhr.responseJSON;
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response?.message || 'Erro ao salvar transferência'
                    });
                }
            });
        });
    </script>
<?php endif; ?>

<?php
$content = ob_get_clean();
$activeMenu = 'estoque';
include ROOT_PATH . '/views/layouts/app.php';
?>
?>