<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-ticket-perforated me-2"></i> Ticket: <?= htmlspecialchars($ticket['numero_ticket']) ?></h2>
    </div>
    <div class="col-md-6 text-end">
        <button type="button" class="btn btn-info me-2" onclick="atualizarStatusRapido(<?= $ticket['id'] ?>)">
            <i class="bi bi-arrow-repeat me-2"></i> Alterar Status
        </button>
        <a href="<?= url('/tickets/editar?id=' . $ticket['id']) ?>" class="btn btn-primary me-2">
            <i class="bi bi-pencil me-2"></i> Editar
        </a>
        <a href="<?= url('/tickets') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span><i class="bi bi-info-circle me-2"></i> Informações do Ticket</span>
                <div>
                    <?php
                    // Valores do enum: Aberto, Em Análise, Programação, Pendente, Retorno, Concluído
                    $statusClasses = [
                        'Aberto' => 'primary',
                        'Em Análise' => 'info',
                        'Programação' => 'danger',
                        'Pendente' => 'warning',
                        'Retorno' => 'success',
                        'Concluído' => 'dark'
                    ];
                    $class = $statusClasses[$ticket['status']] ?? 'secondary';
                    $label = $ticket['status'];
                    ?>
                    <span class="badge bg-<?= $class ?> fs-6"><?= $label ?></span>
                </div>
            </div>
            <div class="card-body">
                <h4 class="mb-3"><?= htmlspecialchars($ticket['titulo']) ?></h4>

                <div class="row mb-3">
                    <div class="col-md-3">
                        <strong>Categoria:</strong><br>
                        <?php
                        $categorias = [
                            'suporte' => 'Suporte',
                            'bug' => 'Bug',
                            'melhoria' => 'Melhoria',
                            'duvida' => 'Dúvida',
                            'outro' => 'Outro'
                        ];
                        echo $categorias[$ticket['categoria']] ?? $ticket['categoria'];
                        ?>
                    </div>
                    <div class="col-md-3">
                        <strong>Prioridade:</strong><br>
                        <?php
                        $prioridades = [
                            'baixa' => 'Baixa',
                            'normal' => 'Normal',
                            'alta' => 'Alta',
                            'urgente' => 'Urgente'
                        ];
                        $pri = $prioridades[$ticket['prioridade']] ?? $ticket['prioridade'];
                        $priClass = [
                            'baixa' => 'secondary',
                            'normal' => 'primary',
                            'alta' => 'warning',
                            'urgente' => 'danger'
                        ][$ticket['prioridade']] ?? 'secondary';
                        ?>
                        <span class="badge bg-<?= $priClass ?>"><?= $pri ?></span>
                    </div>
                    <div class="col-md-3">
                        <strong>Data de Abertura:</strong><br>
                        <?= date('d/m/Y H:i', strtotime($ticket['data_abertura'])) ?>
                    </div>
                    <div class="col-md-3">
                        <strong>Atribuído Para:</strong><br>
                        <?= $ticket['atribuido_para_nome'] ? htmlspecialchars($ticket['atribuido_para_nome']) : '<span class="text-muted">Não atribuído</span>' ?>
                    </div>
                </div>

                <hr>

                <div class="mb-3">
                    <strong>Descrição:</strong>
                    <div class="mt-2 p-3 bg-light rounded">
                        <?= nl2br(htmlspecialchars($ticket['descricao'])) ?>
                    </div>
                </div>

                <?php if ($ticket['solucao']): ?>
                <div class="mb-3">
                    <strong>Solução:</strong>
                    <div class="mt-2 p-3 bg-success bg-opacity-10 rounded">
                        <?= nl2br(htmlspecialchars($ticket['solucao'])) ?>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Anexos -->
                <?php if (!empty($anexos)): ?>
                <div class="mb-3">
                    <strong>Anexos:</strong>
                    <div class="mt-2">
                        <div class="row g-2" id="anexos-container">
                            <?php foreach ($anexos as $anexo): ?>
                            <div class="col-md-3 col-sm-4 col-6">
                                <div class="anexo-item position-relative">
                                    <a href="<?= asset($anexo['caminho']) ?>" target="_blank" class="d-block">
                                        <img src="<?= asset($anexo['caminho']) ?>"
                                             alt="<?= htmlspecialchars($anexo['nome']) ?>"
                                             class="img-thumbnail w-100"
                                             style="height: 150px; object-fit: cover; cursor: pointer;">
                                    </a>
                                    <div class="anexo-info p-2 bg-light">
                                        <small class="text-muted d-block" style="font-size: 0.75rem;">
                                            <?= htmlspecialchars($anexo['nome']) ?>
                                        </small>
                                        <small class="text-muted" style="font-size: 0.7rem;">
                                            <?= $anexo['data'] ?>
                                        </small>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <i class="bi bi-chat-left-text me-2"></i> Comentários
            </div>
            <div class="card-body">
                <div id="comentarios-list">
                    <?php
                    // Separar comentários normais dos de atualização de status
                    $comentariosNormais = array_filter($comentarios ?? [], function($c) {
                        return ($c['tipo'] ?? 'comentario') !== 'atualizacao_status';
                    });
                    ?>
                    <?php if (!empty($comentariosNormais)): ?>
                        <?php foreach ($comentariosNormais as $comentario): ?>
                        <div class="mb-3 p-3 border rounded <?= $comentario['is_interno'] ? 'bg-light' : '' ?>">
                            <div class="d-flex justify-content-between mb-2">
                                <div>
                                    <strong><?= htmlspecialchars($comentario['usuario_nome'] ?? 'Sistema') ?></strong>
                                    <?php if ($comentario['is_interno']): ?>
                                        <span class="badge bg-secondary ms-2">Interno</span>
                                    <?php endif; ?>
                                </div>
                                <small class="text-muted"><?= date('d/m/Y H:i', strtotime($comentario['created_at'])) ?></small>
                            </div>
                            <p class="mb-0"><?= nl2br(htmlspecialchars($comentario['comentario'])) ?></p>
                        </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p class="text-muted text-center py-3">Nenhum comentário ainda</p>
                    <?php endif; ?>
                </div>
                <hr>
                <div class="mb-3">
                    <label for="novo_comentario" class="form-label">Adicionar Comentário</label>
                    <textarea class="form-control" id="novo_comentario" rows="3" placeholder="Digite seu comentário..."></textarea>
                </div>
                <div class="form-check mb-3">
                    <input class="form-check-input" type="checkbox" id="comentario_interno">
                    <label class="form-check-label" for="comentario_interno">
                        Comentário interno (não visível para cliente)
                    </label>
                </div>
                <button type="button" class="btn btn-primary" onclick="adicionarComentario(<?= $ticket['id'] ?>)">
                    <i class="bi bi-plus-circle me-2"></i> Adicionar Comentário
                </button>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card mb-3">
            <div class="card-header">
                <i class="bi bi-building me-2"></i> Cliente/Empresa
            </div>
            <div class="card-body">
                <?php if ($ticket['cliente_nome']): ?>
                    <p><strong>Cliente:</strong> <?= htmlspecialchars($ticket['cliente_nome']) ?></p>
                    <?php if ($ticket['cliente_document']): ?>
                        <p><strong>CNPJ:</strong> <?= htmlspecialchars($ticket['cliente_document']) ?></p>
                    <?php endif; ?>
                    <?php
                    $clienteFone = $ticket['cliente_mobile'] ?? $ticket['cliente_phone'] ?? '';
                    if ($clienteFone): ?>
                        <p><strong>Fone:</strong> <?= htmlspecialchars($clienteFone) ?></p>
                    <?php endif; ?>
                    <?php if ($ticket['cliente_email']): ?>
                        <p><strong>Contato:</strong> <?= htmlspecialchars($ticket['cliente_email']) ?></p>
                    <?php endif; ?>
                <?php elseif ($ticket['empresa_nome']): ?>
                    <p><strong>Cliente:</strong> <?= htmlspecialchars($ticket['empresa_nome']) ?></p>
                    <?php if ($ticket['empresa_cnpj']): ?>
                        <p><strong>CNPJ:</strong> <?= htmlspecialchars($ticket['empresa_cnpj']) ?></p>
                    <?php endif; ?>
                    <?php if ($ticket['empresa_telefone']): ?>
                        <p><strong>Fone:</strong> <?= htmlspecialchars($ticket['empresa_telefone']) ?></p>
                    <?php endif; ?>
                    <?php if ($ticket['empresa_email']): ?>
                        <p><strong>Contato:</strong> <?= htmlspecialchars($ticket['empresa_email']) ?></p>
                    <?php endif; ?>
                <?php else: ?>
                    <p class="text-muted">Nenhum cliente/empresa associado</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="card mb-3">
            <div class="card-header">
                <i class="bi bi-clock-history me-2"></i> Histórico
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <strong>Criado por:</strong><br>
                    <small><?= htmlspecialchars($ticket['criado_por_nome'] ?? 'Sistema') ?></small>
                </div>
                <div class="mb-2">
                    <strong>Data de Abertura:</strong><br>
                    <small><?= date('d/m/Y H:i', strtotime($ticket['data_abertura'])) ?></small>
                </div>
                <?php if ($ticket['data_resolucao']): ?>
                <div class="mb-2">
                    <strong>Data de Resolução:</strong><br>
                    <small><?= date('d/m/Y H:i', strtotime($ticket['data_resolucao'])) ?></small>
                </div>
                <?php endif; ?>
                <?php if ($ticket['data_fechamento']): ?>
                <div class="mb-2">
                    <strong>Data de Fechamento:</strong><br>
                    <small><?= date('d/m/Y H:i', strtotime($ticket['data_fechamento'])) ?></small>
                </div>
                <?php endif; ?>
                <?php if ($ticket['tempo_resolucao']): ?>
                <div class="mb-2">
                    <strong>Tempo de Resolução:</strong><br>
                    <small><?= $ticket['tempo_resolucao'] ?> minutos</small>
                </div>
                <?php endif; ?>

                <hr>

                <div class="mb-2">
                    <strong>Alterações de Status:</strong>
                </div>
                <div id="historico-status" style="max-height: 300px; overflow-y: auto;">
                    <?php
                    // Filtrar apenas comentários de atualização de status
                    $historicoStatus = array_filter($comentarios ?? [], function($c) {
                        return ($c['tipo'] ?? 'comentario') === 'atualizacao_status';
                    });
                    ?>
                    <?php if (!empty($historicoStatus)): ?>
                        <?php foreach ($historicoStatus as $item): ?>
                        <div class="mb-2 p-2 bg-light rounded border-start border-info border-3">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <small class="text-muted">
                                        <i class="bi bi-arrow-repeat me-1"></i>
                                        <?= nl2br(htmlspecialchars($item['comentario'])) ?>
                                    </small>
                                </div>
                                <small class="text-muted">
                                    <?= date('d/m/Y H:i', strtotime($item['created_at'])) ?>
                                </small>
                            </div>
                            <?php if ($item['usuario_nome']): ?>
                                <small class="text-muted d-block mt-1">
                                    <i class="bi bi-person me-1"></i>
                                    <?= htmlspecialchars($item['usuario_nome']) ?>
                                </small>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p class="text-muted text-center py-2 small">Nenhuma alteração de status registrada</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function adicionarComentario(ticketId) {
    const comentario = $('#novo_comentario').val();
    const isInterno = $('#comentario_interno').is(':checked') ? 1 : 0;

    if (!comentario.trim()) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção!',
            text: 'Digite um comentário'
        });
        return;
    }

    $.ajax({
        url: appUrl('/tickets/adicionar-comentario'),
        type: 'POST',
        data: {
            ticket_id: ticketId,
            comentario: comentario,
            is_interno: isInterno
        },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Sucesso!',
                    text: 'Comentário adicionado',
                    timer: 1000,
                    showConfirmButton: false
                }).then(() => {
                    window.location.reload();
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: response.message || 'Erro ao adicionar comentário'
                });
            }
        },
        error: function(xhr) {
            let message = 'Erro ao processar requisição';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                message = xhr.responseJSON.message;
            }
            Swal.fire({
                icon: 'error',
                title: 'Erro!',
                text: message
            });
        }
    });
}

function atualizarStatusRapido(ticketId) {
    Swal.fire({
        title: 'Alterar Status',
        input: 'select',
        inputOptions: {
            'Aberto': 'Aberto',
            'Em Análise': 'Em Análise',
            'Programação': 'Programação',
            'Pendente': 'Pendente',
            'Retorno': 'Retorno',
            'Concluído': 'Concluído'
        },
        inputPlaceholder: 'Selecione o novo status',
        showCancelButton: true,
        confirmButtonText: 'Alterar',
        cancelButtonText: 'Cancelar',
        inputValidator: (value) => {
            if (!value) {
                return 'Selecione um status'
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: appUrl('/tickets/atualizar-status'),
                type: 'POST',
                data: {
                    id: ticketId,
                    status: result.value
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            text: 'Status atualizado',
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: response.message || 'Erro ao atualizar status'
                        });
                    }
                },
                error: function(xhr) {
                    let message = 'Erro ao processar requisição';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        message = xhr.responseJSON.message;
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: message
                    });
                }
            });
        }
    });
}

// Lightbox para imagens
document.addEventListener('DOMContentLoaded', function() {
    const anexosContainer = document.getElementById('anexos-container');
    if (anexosContainer) {
        anexosContainer.addEventListener('click', function(e) {
            if (e.target.tagName === 'IMG') {
                e.preventDefault();
                const imgSrc = e.target.src;
                const imgAlt = e.target.alt;

                // Criar modal lightbox
                const lightbox = document.createElement('div');
                lightbox.className = 'lightbox-modal';
                lightbox.style.cssText = `
                    position: fixed;
                    top: 0;
                    left: 0;
                    width: 100%;
                    height: 100%;
                    background: rgba(0,0,0,0.9);
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    z-index: 9999;
                    cursor: pointer;
                `;

                const img = document.createElement('img');
                img.src = imgSrc;
                img.alt = imgAlt;
                img.style.cssText = `
                    max-width: 90%;
                    max-height: 90%;
                    object-fit: contain;
                `;

                lightbox.appendChild(img);
                document.body.appendChild(lightbox);

                lightbox.addEventListener('click', function() {
                    document.body.removeChild(lightbox);
                });
            }
        });
    }
});
</script>

<style>
.anexo-item {
    border: 1px solid #dee2e6;
    border-radius: 4px;
    overflow: hidden;
    transition: transform 0.2s, box-shadow 0.2s;
}

.anexo-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.anexo-info {
    border-top: 1px solid #dee2e6;
}
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'tickets';
include ROOT_PATH . '/views/layouts/app.php';
?>

