<?php
ob_start();

// Mapeamento de status - os valores do enum do banco são exatamente:
// Aberto, Em Análise, Programação, Pendente, Retorno, Concluído
// Não precisa de conversão, usar os valores diretos
$statusMap = [
    'Aberto' => 'Aberto',
    'Em Análise' => 'Em Análise',
    'Programação' => 'Programação',
    'Pendente' => 'Pendente',
    'Retorno' => 'Retorno',
    'Concluído' => 'Concluído'
];

// Cores para cada coluna
$colunaCores = [
    'Aberto' => '#4285f4',
    'Em Análise' => '#fbbc04',
    'Programação' => '#ea4335',
    'Pendente' => '#ff6d01',
    'Retorno' => '#34a853',
    'Concluído' => '#6c757d'
];

$colunas = ['Aberto', 'Em Análise', 'Programação', 'Pendente', 'Retorno', 'Concluído'];
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-ticket-perforated me-2"></i> Tickets</h2>
        <p class="text-muted">Gerencie chamados e suporte - Visualização tipo Trello</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/tickets/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Novo Ticket
        </a>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-4">
                <input type="text" class="form-control" id="search-tickets" placeholder="Buscar tickets..."
                    onkeyup="filtrarTickets()">
            </div>
            <div class="col-md-2">
                <select class="form-select" id="filter-prioridade" onchange="filtrarTickets()">
                    <option value="">Todas as Prioridades</option>
                    <option value="baixa" <?= ($filtros['prioridade'] ?? '') === 'baixa' ? 'selected' : '' ?>>Baixa
                    </option>
                    <option value="normal" <?= ($filtros['prioridade'] ?? '') === 'normal' ? 'selected' : '' ?>>Normal
                    </option>
                    <option value="alta" <?= ($filtros['prioridade'] ?? '') === 'alta' ? 'selected' : '' ?>>Alta
                    </option>
                    <option value="urgente" <?= ($filtros['prioridade'] ?? '') === 'urgente' ? 'selected' : '' ?>>
                        Urgente</option>
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select" id="filter-categoria" onchange="filtrarTickets()">
                    <option value="">Todos os Módulos</option>
                    <option value="cadastros" <?= ($filtros['categoria'] ?? '') === 'cadastros' ? 'selected' : '' ?>>
                        Cadastros</option>
                    <option value="venda" <?= ($filtros['categoria'] ?? '') === 'venda' ? 'selected' : '' ?>>Venda
                    </option>
                    <option value="nota_fiscal"
                        <?= ($filtros['categoria'] ?? '') === 'nota_fiscal' ? 'selected' : '' ?>>Nota Fiscal</option>
                    <option value="estoque" <?= ($filtros['categoria'] ?? '') === 'estoque' ? 'selected' : '' ?>>Estoque
                    </option>
                    <option value="relatorios" <?= ($filtros['categoria'] ?? '') === 'relatorios' ? 'selected' : '' ?>>
                        Relatórios</option>
                    <option value="outros" <?= strpos($filtros['categoria'] ?? '', 'outros') === 0 ? 'selected' : '' ?>>
                        Outros</option>
                </select>
            </div>
            <div class="col-md-2">
                <button class="btn btn-outline-secondary w-100" onclick="limparFiltros()">
                    <i class="bi bi-x-circle me-1"></i> Limpar
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Board tipo Trello -->
<div class="trello-board-wrapper">
    <div class="trello-board" id="trello-board">
        <?php foreach ($colunas as $coluna): ?>
        <div class="trello-column" data-status="<?= htmlspecialchars($coluna) ?>">
            <div class="trello-column-header" style="background-color: <?= $colunaCores[$coluna] ?>">
                <h5 class="mb-0">
                    <span class="trello-column-title"><?= htmlspecialchars($coluna) ?></span>
                    <span class="badge bg-light text-dark ms-2"
                        id="count-<?= str_replace(' ', '-', strtolower($coluna)) ?>">
                        <?= count($ticketsPorStatus[$coluna] ?? []) ?>
                    </span>
                </h5>
            </div>
            <div class="trello-column-body" data-status="<?= htmlspecialchars($coluna) ?>">
                <?php if (!empty($ticketsPorStatus[$coluna])): ?>
                <?php foreach ($ticketsPorStatus[$coluna] as $ticket): ?>
                <div class="trello-card" draggable="true" data-ticket-id="<?= $ticket['id'] ?>"
                    data-status="<?= htmlspecialchars($coluna) ?>"
                    data-prioridade="<?= htmlspecialchars($ticket['prioridade']) ?>"
                    data-categoria="<?= htmlspecialchars($ticket['categoria']) ?>">
                    <div class="trello-card-header">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <strong
                                    class="trello-card-number">#<?= htmlspecialchars($ticket['numero_ticket']) ?></strong>
                                <?php
                                            $prioridades = [
                                                'baixa' => ['label' => 'Baixa', 'class' => 'secondary'],
                                                'normal' => ['label' => 'Normal', 'class' => 'primary'],
                                                'alta' => ['label' => 'Alta', 'class' => 'warning'],
                                                'urgente' => ['label' => 'Urgente', 'class' => 'danger']
                                            ];
                                            $pri = $prioridades[$ticket['prioridade']] ?? ['label' => $ticket['prioridade'], 'class' => 'secondary'];
                                            ?>
                                <span class="badge bg-<?= $pri['class'] ?> ms-1"><?= $pri['label'] ?></span>
                            </div>
                            <div class="trello-card-actions">
                                <a href="<?= url('/tickets/visualizar?id=' . $ticket['id']) ?>"
                                    class="btn btn-sm btn-link p-0" title="Visualizar">
                                    <i class="bi bi-eye"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="trello-card-body">
                        <a href="<?= url('/tickets/visualizar?id=' . $ticket['id']) ?>" class="trello-card-title">
                            <?= htmlspecialchars($ticket['titulo']) ?>
                        </a>
                        <div class="trello-card-meta mt-2">
                            <?php
                                        // Mapeamento de módulos
                                        $modulos = [
                                            'cadastros' => ['label' => 'Cadastros', 'class' => 'info'],
                                            'venda' => ['label' => 'Venda', 'class' => 'primary'],
                                            'nota_fiscal' => ['label' => 'Nota Fiscal', 'class' => 'success'],
                                            'estoque' => ['label' => 'Estoque', 'class' => 'warning'],
                                            'relatorios' => ['label' => 'Relatórios', 'class' => 'info']
                                        ];

                                        $categoriaTicket = $ticket['categoria'];
                                        // Verificar se começa com "outros: "
                                        if (strpos($categoriaTicket, 'outros: ') === 0) {
                                            $moduloTexto = substr($categoriaTicket, 8);
                                            $modulo = ['label' => 'Outros: ' . htmlspecialchars($moduloTexto), 'class' => 'secondary'];
                                        } else {
                                            $modulo = $modulos[$categoriaTicket] ?? ['label' => htmlspecialchars($categoriaTicket), 'class' => 'secondary'];
                                        }
                                        ?>
                            <span class="badge bg-<?= $modulo['class'] ?> badge-sm"><?= $modulo['label'] ?></span>
                        </div>
                    </div>
                    <div class="trello-card-footer">
                        <div class="d-flex justify-content-between align-items-center">
                            <small class="text-muted">
                                <?php if ($ticket['cliente_nome']): ?>
                                <i class="bi bi-person"></i>
                                <?= htmlspecialchars(mb_substr($ticket['cliente_nome'], 0, 15)) ?>
                                <?php elseif ($ticket['empresa_nome']): ?>
                                <i class="bi bi-building"></i>
                                <?= htmlspecialchars(mb_substr($ticket['empresa_nome'], 0, 15)) ?>
                                <?php endif; ?>
                            </small>
                            <small class="text-muted">
                                <i class="bi bi-chat-dots"></i> <?= $ticket['total_comentarios'] ?? 0 ?>
                            </small>
                        </div>
                        <div class="mt-1">
                            <small class="text-muted">
                                <i class="bi bi-calendar"></i> <?= date('d/m/Y', strtotime($ticket['data_abertura'])) ?>
                            </small>
                            <?php if ($ticket['atribuido_para_nome']): ?>
                            <small class="text-muted ms-2">
                                <i class="bi bi-person-check"></i>
                                <?= htmlspecialchars(mb_substr($ticket['atribuido_para_nome'], 0, 10)) ?>
                            </small>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
                <?php else: ?>
                <div class="trello-column-empty">
                    <i class="bi bi-inbox"></i>
                    <p class="text-muted mb-0">Nenhum ticket</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<style>
/* Garantir que não haja overflow horizontal */
.trello-board-wrapper {
    width: 100%;
    overflow-x: hidden;
    margin: 0;
    padding: 0;
}

.trello-board {
    display: flex;
    gap: 0.75rem;
    padding: 1rem 0;
    min-height: 600px;
    width: 100%;
    max-width: 100%;
    box-sizing: border-box;
}

.trello-column {
    flex: 1 1 0;
    min-width: 0;
    width: calc((100% - 3.75rem) / 6);
    background: #f4f5f7;
    border-radius: 8px;
    display: flex;
    flex-direction: column;
    height: fit-content;
    max-height: calc(100vh - 250px);
}

.trello-column-header {
    padding: 1rem;
    color: white;
    border-radius: 8px 8px 0 0;
    font-weight: 600;
    position: sticky;
    top: 0;
    z-index: 10;
    min-height: 60px;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.trello-column-header h5 {
    margin: 0;
    display: flex;
    align-items: center;
    justify-content: space-between;
    width: 100%;
    font-size: 0.95rem;
    line-height: 1.4;
    white-space: nowrap;
}

.trello-column-title {
    flex: 1;
    overflow: hidden;
    text-overflow: ellipsis;
}

.trello-column-body {
    padding: 0.75rem;
    flex: 1;
    overflow-y: auto;
    min-height: 200px;
}

.trello-column-empty {
    text-align: center;
    padding: 2rem 1rem;
    color: #999;
}

.trello-card {
    background: white;
    border-radius: 6px;
    padding: 1rem;
    margin-bottom: 0.75rem;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.12);
    cursor: grab;
    transition: all 0.2s;
    display: flex;
    flex-direction: column;
    height: 200px;
}

.trello-card:hover {
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.16);
    transform: translateY(-2px);
}

.trello-card.dragging {
    opacity: 0.5;
    cursor: grabbing;
}

.trello-card-header {
    margin-bottom: 0.75rem;
    flex-shrink: 0;
    height: 40px;
    display: flex;
    align-items: center;
}

.trello-card-number {
    font-size: 0.85rem;
    color: #666;
}

.trello-card-title {
    font-weight: 600;
    color: #172b4d;
    text-decoration: none;
    display: block;
    margin-bottom: 0.5rem;
    line-height: 1.4;
    min-height: 2.8em;
    max-height: 2.8em;
    overflow: hidden;
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    line-clamp: 2;
    -webkit-box-orient: vertical;
}

.trello-card-title:hover {
    color: #0052cc;
    text-decoration: underline;
}

.trello-card-body {
    margin-bottom: 0.75rem;
    flex: 1 1 auto;
    display: flex;
    flex-direction: column;
    overflow: hidden;
}

.trello-card-meta {
    margin-top: auto;
}

.trello-card-footer {
    border-top: 1px solid #e0e0e0;
    padding-top: 0.75rem;
    font-size: 0.85rem;
    flex-shrink: 0;
    height: 60px;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
}

.trello-card-actions {
    display: flex;
    gap: 0.25rem;
}

.badge-sm {
    font-size: 0.7rem;
    padding: 0.2rem 0.4rem;
}

.trello-column-body.drag-over {
    background: #e3f2fd;
    border: 2px dashed #2196f3;
}

/* Garantir que o container principal não tenha overflow */
.content-wrapper {
    overflow-x: hidden;
}

/* Ajustes para telas menores */
@media (max-width: 1200px) {
    .trello-column {
        min-width: 200px;
    }
}

@media (max-width: 992px) {
    .trello-column {
        min-width: 180px;
    }

    .trello-card {
        padding: 0.75rem;
    }

    .trello-card-title {
        font-size: 0.9rem;
    }
}

@media (max-width: 768px) {
    .trello-board {
        flex-direction: column;
        gap: 1rem;
    }

    .trello-column {
        min-width: 100%;
        max-width: 100%;
    }
}
</style>

<script>
// Drag and Drop
let draggedElement = null;

document.addEventListener('DOMContentLoaded', function() {
    const cards = document.querySelectorAll('.trello-card');
    const columns = document.querySelectorAll('.trello-column-body');

    cards.forEach(card => {
        card.addEventListener('dragstart', handleDragStart);
        card.addEventListener('dragend', handleDragEnd);
    });

    columns.forEach(column => {
        column.addEventListener('dragover', handleDragOver);
        column.addEventListener('drop', handleDrop);
        column.addEventListener('dragleave', handleDragLeave);
    });
});

function handleDragStart(e) {
    draggedElement = this;
    this.classList.add('dragging');
    e.dataTransfer.effectAllowed = 'move';
    e.dataTransfer.setData('text/html', this.innerHTML);
}

function handleDragEnd(e) {
    this.classList.remove('dragging');
    document.querySelectorAll('.trello-column-body').forEach(col => {
        col.classList.remove('drag-over');
    });
}

function handleDragOver(e) {
    if (e.preventDefault) {
        e.preventDefault();
    }
    e.dataTransfer.dropEffect = 'move';
    this.classList.add('drag-over');
    return false;
}

function handleDragLeave(e) {
    this.classList.remove('drag-over');
}

function handleDrop(e) {
    if (e.stopPropagation) {
        e.stopPropagation();
    }

    this.classList.remove('drag-over');

    if (draggedElement != null) {
        const newStatus = this.getAttribute('data-status');
        const oldStatus = draggedElement.getAttribute('data-status');

        if (newStatus !== oldStatus) {
            const ticketId = draggedElement.getAttribute('data-ticket-id');
            atualizarStatusTicket(ticketId, newStatus, draggedElement);
        } else {
            // Se for a mesma coluna, apenas reposiciona
            this.appendChild(draggedElement);
        }
    }

    return false;
}

function atualizarStatusTicket(ticketId, novoStatus, cardElement) {
    // Os valores do enum do banco são exatamente: Aberto, Em Análise, Programação, Pendente, Retorno, Concluído
    // Não precisa de conversão, usar o valor direto
    const statusBanco = novoStatus;

    // Mostrar loading
    cardElement.style.opacity = '0.5';

    $.ajax({
        url: appUrl('/tickets/atualizar-status'),
        type: 'POST',
        data: {
            id: ticketId,
            status: statusBanco
        },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                // Se houver redirect na resposta, usar ele, senão recarregar página
                if (response.data && response.data.redirect) {
                    if (typeof Swal !== 'undefined') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Status atualizado!',
                            text: 'Ticket movido para ' + novoStatus,
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = response.data.redirect;
                        });
                    } else {
                        window.location.href = response.data.redirect;
                    }
                } else {
                    // Fallback: recarregar página
                    if (typeof Swal !== 'undefined') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Status atualizado!',
                            text: 'Ticket movido para ' + novoStatus,
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.reload();
                        });
                    } else {
                        window.location.reload();
                    }
                }
            } else {
                // Reverter mudança
                window.location.reload();
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message || 'Erro ao atualizar status'
                    });
                }
            }
        },
        error: function(xhr) {
            window.location.reload();
            const response = xhr.responseJSON || {};
            if (typeof Swal !== 'undefined') {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: response.message || 'Erro ao atualizar status'
                });
            }
        },
        complete: function() {
            cardElement.style.opacity = '1';
        }
    });
}

function atualizarContadores() {
    const colunas = ['Aberto', 'Em Análise', 'Programação', 'Pendente', 'Retorno', 'Concluído'];
    colunas.forEach(coluna => {
        const colunaId = coluna.toLowerCase().replace(/\s+/g, '-');
        const colunaBody = document.querySelector(`.trello-column-body[data-status="${coluna}"]`);
        const count = colunaBody ? colunaBody.querySelectorAll('.trello-card').length : 0;
        const countElement = document.getElementById(`count-${colunaId}`);
        if (countElement) {
            countElement.textContent = count;
        }
    });
}

function filtrarTickets() {
    const search = document.getElementById('search-tickets').value.toLowerCase();
    const prioridade = document.getElementById('filter-prioridade').value;
    const categoria = document.getElementById('filter-categoria').value;

    const cards = document.querySelectorAll('.trello-card');

    cards.forEach(card => {
        const titulo = card.querySelector('.trello-card-title').textContent.toLowerCase();
        const numero = card.querySelector('.trello-card-number').textContent.toLowerCase();
        const cardPrioridade = card.getAttribute('data-prioridade');
        const cardCategoria = card.getAttribute('data-categoria');

        let matchSearch = !search || titulo.includes(search) || numero.includes(search);
        let matchPrioridade = !prioridade || cardPrioridade === prioridade;
        let matchCategoria = !categoria || cardCategoria === categoria;

        if (matchSearch && matchPrioridade && matchCategoria) {
            card.style.display = 'block';
        } else {
            card.style.display = 'none';
        }
    });

    atualizarContadores();
}

function limparFiltros() {
    document.getElementById('search-tickets').value = '';
    document.getElementById('filter-prioridade').value = '';
    document.getElementById('filter-categoria').value = '';
    filtrarTickets();
}

function deletarTicket(id, numero) {
    if (typeof Swal === 'undefined') {
        if (confirm(`Deseja realmente excluir o ticket ${numero}?`)) {
            $.ajax({
                url: appUrl('/tickets/deletar'),
                type: 'POST',
                data: {
                    id: id
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        window.location.reload();
                    } else {
                        alert(response.message || 'Erro ao excluir ticket');
                    }
                },
                error: function() {
                    alert('Erro ao processar requisição');
                }
            });
        }
        return;
    }

    Swal.fire({
        title: 'Confirmar exclusão',
        text: `Deseja realmente excluir o ticket ${numero}?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sim, excluir',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: appUrl('/tickets/deletar'),
                type: 'POST',
                data: {
                    id: id
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            text: response.message || 'Ticket excluído com sucesso',
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: response.message || 'Erro ao excluir ticket'
                        });
                    }
                },
                error: function(xhr) {
                    let message = 'Erro ao processar requisição';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        message = xhr.responseJSON.message;
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: message
                    });
                }
            });
        }
    });
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'tickets';
include ROOT_PATH . '/views/layouts/app.php';
?>