<?php
$isEdit = isset($ticket['id']);
$actionUrl = $isEdit ? url('/tickets/editar') : url('/tickets/criar');
?>

<form id="formTicket" action="<?= $actionUrl ?>" method="POST">
    <?php if ($isEdit): ?>
        <input type="hidden" name="id" value="<?= $ticket['id'] ?>">
    <?php endif; ?>

    <div class="row">
        <div class="col-md-8">
            <div class="card mb-3">
                <div class="card-header">
                    <i class="bi bi-info-circle me-2"></i> Informações do Ticket
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- Número do Ticket -->
                        <div class="col-md-4 mb-3">
                            <label for="numero_ticket" class="form-label">Número do Ticket *</label>
                            <input type="text" class="form-control" id="numero_ticket" name="numero_ticket"
                                value="<?= htmlspecialchars($ticket['numero_ticket'] ?? $numeroTicket ?? '') ?>" required readonly>
                        </div>

                        <!-- Módulo (da tabela módulos) -->
                        <div class="col-md-6 mb-3">
                            <label for="modulo_id" class="form-label">Módulo *</label>
                            <select class="form-select" id="modulo_id" name="modulo_id" required>
                                <option value="">Selecione um módulo...</option>
                                <?php if (!empty($modulos)): ?>
                                    <?php foreach ($modulos as $modulo): ?>
                                        <option value="<?= $modulo['id'] ?>" <?= ($ticket['modulo_id'] ?? '') == $modulo['id'] ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($modulo['nome']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>

                        <!-- Tipo -->
                        <div class="col-md-6 mb-3">
                            <label for="tipo" class="form-label">Tipo *</label>
                            <?php
                            // Verificar se o tipo começa com "outros: " para determinar o valor selecionado
                            $tipoAtual = $ticket['categoria'] ?? 'normal';
                            $isOutrosTipo = strpos($tipoAtual, 'outros: ') === 0;
                            $outrosTipoTexto = $isOutrosTipo ? substr($tipoAtual, 8) : '';
                            $tipoSelecionado = $isOutrosTipo ? 'outros' : $tipoAtual;
                            ?>
                            <select class="form-select" id="tipo" name="tipo" required onchange="toggleOutrosTipo()">
                                <option value="cadastros" <?= $tipoSelecionado === 'cadastros' ? 'selected' : '' ?>>Cadastros</option>
                                <option value="venda" <?= $tipoSelecionado === 'venda' ? 'selected' : '' ?>>Venda</option>
                                <option value="nota_fiscal" <?= $tipoSelecionado === 'nota_fiscal' ? 'selected' : '' ?>>Nota Fiscal</option>
                                <option value="estoque" <?= $tipoSelecionado === 'estoque' ? 'selected' : '' ?>>Estoque</option>
                                <option value="relatorios" <?= $tipoSelecionado === 'relatorios' ? 'selected' : '' ?>>Relatórios</option>
                                <option value="outros" <?= $tipoSelecionado === 'outros' ? 'selected' : '' ?>>Outros</option>
                            </select>
                        </div>

                        <!-- Campo Outros Tipo (aparece quando "Outros" é selecionado) -->
                        <div class="col-md-6 mb-3" id="outros-tipo-container" style="display: <?= $isOutrosTipo ? 'block' : 'none' ?>;">
                            <label for="outros_tipo" class="form-label">Especifique o tipo *</label>
                            <input type="text" class="form-control" id="outros_tipo" name="outros_tipo"
                                value="<?= htmlspecialchars($outrosTipoTexto) ?>"
                                placeholder="Digite o tipo" <?= $isOutrosTipo ? 'required' : '' ?>>
                        </div>

                        <!-- Prioridade -->
                        <div class="col-md-6 mb-3">
                            <label for="prioridade" class="form-label">Prioridade *</label>
                            <select class="form-select" id="prioridade" name="prioridade" required>
                                <option value="baixa" <?= ($ticket['prioridade'] ?? 'normal') === 'baixa' ? 'selected' : '' ?>>Baixa</option>
                                <option value="normal" <?= ($ticket['prioridade'] ?? 'normal') === 'normal' ? 'selected' : '' ?>>Normal</option>
                                <option value="alta" <?= ($ticket['prioridade'] ?? '') === 'alta' ? 'selected' : '' ?>>Alta</option>
                                <option value="urgente" <?= ($ticket['prioridade'] ?? '') === 'urgente' ? 'selected' : '' ?>>Urgente</option>
                            </select>
                        </div>

                        <!-- Título -->
                        <div class="col-md-12 mb-3">
                            <label for="titulo" class="form-label">Título *</label>
                            <input type="text" class="form-control" id="titulo" name="titulo"
                                value="<?= htmlspecialchars($ticket['titulo'] ?? '') ?>" required>
                        </div>

                        <!-- Descrição -->
                        <div class="col-md-12 mb-3">
                            <label for="descricao" class="form-label">Descrição *</label>
                            <textarea class="form-control" id="descricao" name="descricao" rows="6" required><?= htmlspecialchars($ticket['descricao'] ?? '') ?></textarea>
                        </div>

                        <!-- Solução (apenas se editando e status resolvido/fechado) -->
                        <?php if ($isEdit && in_array($ticket['status'] ?? '', ['resolvido', 'fechado'])): ?>
                        <div class="col-md-12 mb-3">
                            <label for="solucao" class="form-label">Solução</label>
                            <textarea class="form-control" id="solucao" name="solucao" rows="4"><?= htmlspecialchars($ticket['solucao'] ?? '') ?></textarea>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <?php if ($isEdit && !empty($comentarios)): ?>
            <div class="card mb-3">
                <div class="card-header">
                    <i class="bi bi-chat-left-text me-2"></i> Comentários
                </div>
                <div class="card-body">
                    <div id="comentarios-list">
                        <?php foreach ($comentarios as $comentario): ?>
                        <div class="mb-3 p-3 border rounded <?= $comentario['is_interno'] ? 'bg-light' : '' ?>">
                            <div class="d-flex justify-content-between mb-2">
                                <div>
                                    <strong><?= htmlspecialchars($comentario['usuario_nome'] ?? 'Sistema') ?></strong>
                                    <?php if ($comentario['is_interno']): ?>
                                        <span class="badge bg-secondary ms-2">Interno</span>
                                    <?php endif; ?>
                                </div>
                                <small class="text-muted"><?= date('d/m/Y H:i', strtotime($comentario['created_at'])) ?></small>
                            </div>
                            <p class="mb-0"><?= nl2br(htmlspecialchars($comentario['comentario'])) ?></p>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label for="novo_comentario" class="form-label">Adicionar Comentário</label>
                        <textarea class="form-control" id="novo_comentario" rows="3" placeholder="Digite seu comentário..."></textarea>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="comentario_interno">
                        <label class="form-check-label" for="comentario_interno">
                            Comentário interno (não visível para cliente)
                        </label>
                    </div>
                    <button type="button" class="btn btn-primary" onclick="adicionarComentario(<?= $ticket['id'] ?>)">
                        <i class="bi bi-plus-circle me-2"></i> Adicionar Comentário
                    </button>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <div class="col-md-4">
            <div class="card mb-3">
                <div class="card-header">
                    <i class="bi bi-gear me-2"></i> Configurações
                </div>
                <div class="card-body">
                    <!-- Status -->
                    <div class="mb-3">
                        <label for="status" class="form-label">Status *</label>
                        <?php
                        // Mapeamento de status da index para valores do banco
                        $statusAtual = $ticket['status'] ?? 'aberto';
                        $statusMap = [
                            'aberto' => 'Aberto',
                            'em_andamento' => 'Em Análise',
                            'analise_programacao' => 'Análise Programação',
                            'aguardando_cliente' => 'Pendente',
                            'retorno' => 'Retorno',
                            'resolvido' => 'Concluído',
                            'fechado' => 'Concluído'
                        ];
                        $statusLabel = $statusMap[$statusAtual] ?? 'Aberto';
                        ?>
                        <select class="form-select" id="status" name="status" required>
                            <option value="aberto" <?= $statusAtual === 'aberto' ? 'selected' : '' ?>>Aberto</option>
                            <option value="em_andamento" <?= $statusAtual === 'em_andamento' ? 'selected' : '' ?>>Em Análise</option>
                            <option value="analise_programacao" <?= $statusAtual === 'analise_programacao' ? 'selected' : '' ?>>Análise Programação</option>
                            <option value="aguardando_cliente" <?= $statusAtual === 'aguardando_cliente' ? 'selected' : '' ?>>Pendente</option>
                            <option value="retorno" <?= $statusAtual === 'retorno' ? 'selected' : '' ?>>Retorno</option>
                            <option value="resolvido" <?= in_array($statusAtual, ['resolvido', 'fechado']) ? 'selected' : '' ?>>Concluído</option>
                        </select>
                    </div>

                    <!-- Cliente com Autocomplete -->
                    <div class="mb-3">
                        <label for="cliente_search" class="form-label">Cliente</label>
                        <div class="position-relative">
                            <input type="text" class="form-control" id="cliente_search"
                                placeholder="Digite nome, razão social ou CNPJ/CPF do cliente..." autocomplete="off"
                                value="<?= htmlspecialchars($ticket['cliente_nome'] ?? '') ?>">
                            <div id="cliente_dropdown" class="autocomplete-dropdown" style="display: none;"></div>
                        </div>
                        <input type="hidden" id="cliente_id" name="cliente_id" value="<?= $ticket['cliente_id'] ?? '' ?>">
                        <div id="cliente_info" style="display: <?= !empty($ticket['cliente_id']) ? 'block' : 'none' ?>;" class="mt-2">
                            <div class="alert alert-info mb-0 py-2">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div class="flex-grow-1">
                                        <div id="cliente_info_name"><?= htmlspecialchars($ticket['cliente_nome'] ?? '') ?></div>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-danger ms-2" onclick="limparCliente()">
                                        <i class="bi bi-x"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Empresa com Autocomplete -->
                    <div class="mb-3">
                        <label for="empresa_search" class="form-label">Empresa</label>
                        <div class="position-relative">
                            <input type="text" class="form-control" id="empresa_search"
                                placeholder="Digite razão social ou CNPJ da empresa..." autocomplete="off"
                                value="<?= htmlspecialchars($ticket['empresa_nome'] ?? '') ?>">
                            <div id="empresa_dropdown" class="autocomplete-dropdown" style="display: none;"></div>
                        </div>
                        <input type="hidden" id="empresa_id" name="empresa_id" value="<?= $ticket['empresa_id'] ?? '' ?>">
                        <div id="empresa_info" style="display: <?= !empty($ticket['empresa_id']) ? 'block' : 'none' ?>;" class="mt-2">
                            <div class="alert alert-info mb-0 py-2">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div class="flex-grow-1">
                                        <div id="empresa_info_name"><?= htmlspecialchars($ticket['empresa_nome'] ?? '') ?></div>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-danger ms-2" onclick="limparEmpresa()">
                                        <i class="bi bi-x"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Atribuído Para -->
                    <div class="mb-3">
                        <label for="atribuido_para" class="form-label">Atribuído Para</label>
                        <select class="form-select" id="atribuido_para" name="atribuido_para">
                            <option value="">Não atribuído</option>
                            <?php if (!empty($usuarios)): ?>
                                <?php foreach ($usuarios as $usuario): ?>
                                    <option value="<?= $usuario['id'] ?>" <?= ($ticket['atribuido_para'] ?? '') == $usuario['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($usuario['name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>

                    <?php if ($isEdit): ?>
                    <hr>
                    <div class="mb-2">
                        <strong>Data de Abertura:</strong><br>
                        <small><?= date('d/m/Y H:i', strtotime($ticket['data_abertura'])) ?></small>
                    </div>
                    <?php if ($ticket['data_resolucao']): ?>
                    <div class="mb-2">
                        <strong>Data de Resolução:</strong><br>
                        <small><?= date('d/m/Y H:i', strtotime($ticket['data_resolucao'])) ?></small>
                    </div>
                    <?php endif; ?>
                    <?php if ($ticket['tempo_resolucao']): ?>
                    <div class="mb-2">
                        <strong>Tempo de Resolução:</strong><br>
                        <small><?= $ticket['tempo_resolucao'] ?> minutos</small>
                    </div>
                    <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-footer">
            <div class="d-flex justify-content-end gap-2">
                <a href="<?= url('/tickets') ?>" class="btn btn-secondary">Cancelar</a>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle me-2"></i> Salvar
                </button>
            </div>
        </div>
    </div>
</form>

<style>
.autocomplete-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: white;
    border: 1px solid #ddd;
    border-radius: 4px;
    max-height: 300px;
    overflow-y: auto;
    z-index: 1000;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    margin-top: 2px;
}

.autocomplete-item {
    padding: 0.75rem;
    cursor: pointer;
    border-bottom: 1px solid #f0f0f0;
    transition: background-color 0.2s;
}

.autocomplete-item:hover,
.autocomplete-item.active {
    background-color: #f8f9fa;
}

.autocomplete-item:last-child {
    border-bottom: none;
}

.autocomplete-no-results {
    padding: 0.75rem;
    text-align: center;
    color: #999;
}
</style>

<script>
// Dados para autocomplete
const clientesData = <?= json_encode($pessoas ?? []) ?>;
const empresasData = <?= json_encode($empresas ?? []) ?>;

let autocompleteTimeout = null;
let selectedCliente = null;
let selectedEmpresa = null;

function toggleOutrosTipo() {
    const tipo = document.getElementById('tipo').value;
    const outrosContainer = document.getElementById('outros-tipo-container');
    const outrosInput = document.getElementById('outros_tipo');

    if (tipo === 'outros') {
        outrosContainer.style.display = 'block';
        outrosInput.setAttribute('required', 'required');
    } else {
        outrosContainer.style.display = 'none';
        outrosInput.removeAttribute('required');
        outrosInput.value = '';
    }
}

// Autocomplete de Cliente
function inicializarAutocompleteCliente() {
    const $search = $('#cliente_search');
    const $dropdown = $('#cliente_dropdown');

    $search.on('input', function() {
        const query = $(this).val().trim().toLowerCase();
        clearTimeout(autocompleteTimeout);

        if (query.length < 2) {
            $dropdown.hide();
            return;
        }

        autocompleteTimeout = setTimeout(() => {
            buscarClientes(query);
        }, 300);
    });

    $(document).on('click', function(e) {
        if (!$(e.target).closest('#cliente_search, #cliente_dropdown').length) {
            $dropdown.hide();
        }
    });

    $search.on('focus', function() {
        if ($(this).val().length >= 2) {
            buscarClientes($(this).val().trim().toLowerCase());
        }
    });

    $search.on('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
        }
    });

    <?php if ($isEdit && !empty($ticket['cliente_id'])): ?>
    const clienteInicial = clientesData.find(c => c.id == <?= $ticket['cliente_id'] ?>);
    if (clienteInicial) {
        selecionarCliente(clienteInicial);
    }
    <?php endif; ?>
}

function buscarClientes(query) {
    const $dropdown = $('#cliente_dropdown');
    const results = clientesData.filter(cliente => {
        const name = (cliente.name || '').toLowerCase();
        const tradeName = (cliente.trade_name || '').toLowerCase();
        const document = (cliente.document || '').toLowerCase();
        const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
        const normalizedDocument = document.replace(/[^\d\w]/g, '').toLowerCase();
        return name.includes(query) || tradeName.includes(query) ||
               document.includes(query) || normalizedDocument.includes(normalizedQuery);
    });

    let html = '';
    if (results.length > 0) {
        results.forEach(cliente => {
            const nomeFantasia = cliente.trade_name || '-';
            const razaoSocial = cliente.name || '-';
            const documento = cliente.document || 'Não informado';
            const codigo = String(cliente.id).padStart(4, '0');
            html += `
                <div class="autocomplete-item" data-id="${cliente.id}">
                    <div class="mb-1">
                        <strong>Código: ${codigo}</strong> | <strong>CNPJ/CPF:</strong> ${documento}
                    </div>
                    <div class="mb-1">
                        <strong>Razão Social:</strong> ${razaoSocial} | <strong>Fantasia:</strong> ${nomeFantasia}
                    </div>
                </div>
            `;
        });
    } else {
        html = '<div class="autocomplete-no-results">Nenhum cliente encontrado</div>';
    }

    $dropdown.html(html).show();
    $dropdown.find('.autocomplete-item').on('click', function() {
        const clienteId = $(this).data('id');
        const cliente = clientesData.find(c => c.id == clienteId);
        if (cliente) {
            selecionarCliente(cliente);
        }
    });
}

function selecionarCliente(cliente) {
    selectedCliente = cliente;
    const nomeExibir = cliente.trade_name || cliente.name || '-';
    $('#cliente_id').val(cliente.id);
    $('#cliente_search').val(nomeExibir);
    $('#cliente_info_name').html(`
        <strong>${cliente.name || '-'}</strong> ${cliente.document ? '(' + cliente.document + ')' : ''}
    `);
    $('#cliente_info').show();
    $('#cliente_dropdown').hide();
}

function limparCliente() {
    selectedCliente = null;
    $('#cliente_id').val('');
    $('#cliente_search').val('');
    $('#cliente_info').hide();
}

// Autocomplete de Empresa
function inicializarAutocompleteEmpresa() {
    const $search = $('#empresa_search');
    const $dropdown = $('#empresa_dropdown');

    $search.on('input', function() {
        const query = $(this).val().trim().toLowerCase();
        clearTimeout(autocompleteTimeout);

        if (query.length < 2) {
            $dropdown.hide();
            return;
        }

        autocompleteTimeout = setTimeout(() => {
            buscarEmpresas(query);
        }, 300);
    });

    $(document).on('click', function(e) {
        if (!$(e.target).closest('#empresa_search, #empresa_dropdown').length) {
            $dropdown.hide();
        }
    });

    $search.on('focus', function() {
        if ($(this).val().length >= 2) {
            buscarEmpresas($(this).val().trim().toLowerCase());
        }
    });

    $search.on('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
        }
    });

    <?php if ($isEdit && !empty($ticket['empresa_id'])): ?>
    const empresaInicial = empresasData.find(e => e.id == <?= $ticket['empresa_id'] ?>);
    if (empresaInicial) {
        selecionarEmpresa(empresaInicial);
    }
    <?php endif; ?>
}

function buscarEmpresas(query) {
    const $dropdown = $('#empresa_dropdown');
    const results = empresasData.filter(empresa => {
        const razaoSocial = (empresa.razao_social || '').toLowerCase();
        const nomeFantasia = (empresa.nome_fantasia || '').toLowerCase();
        const cnpj = (empresa.cnpj || '').toLowerCase();
        const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
        const normalizedCnpj = cnpj.replace(/[^\d\w]/g, '').toLowerCase();
        return razaoSocial.includes(query) || nomeFantasia.includes(query) ||
               cnpj.includes(query) || normalizedCnpj.includes(normalizedQuery);
    });

    let html = '';
    if (results.length > 0) {
        results.forEach(empresa => {
            const razaoSocial = empresa.razao_social || '-';
            const nomeFantasia = empresa.nome_fantasia || '-';
            const cnpj = empresa.cnpj || 'Não informado';
            html += `
                <div class="autocomplete-item" data-id="${empresa.id}">
                    <div class="mb-1">
                        <strong>CNPJ:</strong> ${cnpj}
                    </div>
                    <div class="mb-1">
                        <strong>Razão Social:</strong> ${razaoSocial} | <strong>Fantasia:</strong> ${nomeFantasia}
                    </div>
                </div>
            `;
        });
    } else {
        html = '<div class="autocomplete-no-results">Nenhuma empresa encontrada</div>';
    }

    $dropdown.html(html).show();
    $dropdown.find('.autocomplete-item').on('click', function() {
        const empresaId = $(this).data('id');
        const empresa = empresasData.find(e => e.id == empresaId);
        if (empresa) {
            selecionarEmpresa(empresa);
        }
    });
}

function selecionarEmpresa(empresa) {
    selectedEmpresa = empresa;
    const nomeExibir = empresa.nome_fantasia || empresa.razao_social || '-';
    $('#empresa_id').val(empresa.id);
    $('#empresa_search').val(nomeExibir);
    $('#empresa_info_name').html(`
        <strong>${empresa.razao_social || '-'}</strong> ${empresa.cnpj ? '(' + empresa.cnpj + ')' : ''}
    `);
    $('#empresa_info').show();
    $('#empresa_dropdown').hide();
}

function limparEmpresa() {
    selectedEmpresa = null;
    $('#empresa_id').val('');
    $('#empresa_search').val('');
    $('#empresa_info').hide();
}

// Executar ao carregar a página
$(document).ready(function() {
    toggleOutrosTipo();
    inicializarAutocompleteCliente();
    inicializarAutocompleteEmpresa();

    $('#formTicket').on('submit', function(e) {
        e.preventDefault();

        const formData = $(this).serialize();
        const url = $(this).attr('action');

        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message || 'Ticket salvo com sucesso',
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        window.location.href = response.data?.redirect || appUrl('/tickets');
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: response.message || 'Erro ao salvar ticket'
                    });
                }
            },
            error: function(xhr) {
                let message = 'Erro ao processar requisição';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: message
                });
            }
        });
    });
});

<?php if ($isEdit): ?>
function adicionarComentario(ticketId) {
    const comentario = $('#novo_comentario').val();
    const isInterno = $('#comentario_interno').is(':checked') ? 1 : 0;

    if (!comentario.trim()) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção!',
            text: 'Digite um comentário'
        });
        return;
    }

    $.ajax({
        url: appUrl('/tickets/adicionar-comentario'),
        type: 'POST',
        data: {
            ticket_id: ticketId,
            comentario: comentario,
            is_interno: isInterno
        },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Sucesso!',
                    text: 'Comentário adicionado',
                    timer: 1000,
                    showConfirmButton: false
                }).then(() => {
                    window.location.reload();
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: response.message || 'Erro ao adicionar comentário'
                });
            }
        },
        error: function(xhr) {
            let message = 'Erro ao processar requisição';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                message = xhr.responseJSON.message;
            }
            Swal.fire({
                icon: 'error',
                title: 'Erro!',
                text: message
            });
        }
    });
}
<?php endif; ?>
</script>

