<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-ticket-perforated me-2"></i> Ticket: <?= htmlspecialchars($ticket['numero_ticket']) ?></h2>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/tickets/acompanhar') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span><i class="bi bi-info-circle me-2"></i> Informações do Ticket</span>
                <div>
                    <?php
                    $statusClasses = [
                        'Aberto' => 'primary',
                        'Em Análise' => 'info',
                        'Programação' => 'danger',
                        'Pendente' => 'warning',
                        'Retorno' => 'success',
                        'Concluído' => 'dark'
                    ];
                    $class = $statusClasses[$ticket['status']] ?? 'secondary';
                    $label = $ticket['status'];
                    ?>
                    <span class="badge bg-<?= $class ?> fs-6"><?= $label ?></span>
                </div>
            </div>
            <div class="card-body">
                <h4 class="mb-3"><?= htmlspecialchars($ticket['titulo']) ?></h4>

                <div class="row mb-3">
                    <div class="col-md-3">
                        <strong>Categoria:</strong><br>
                        <?php
                        $categorias = [
                            'suporte' => 'Suporte',
                            'bug' => 'Bug',
                            'melhoria' => 'Melhoria',
                            'duvida' => 'Dúvida',
                            'outro' => 'Outro'
                        ];
                        echo $categorias[$ticket['categoria']] ?? $ticket['categoria'];
                        ?>
                    </div>
                    <div class="col-md-3">
                        <strong>Prioridade:</strong><br>
                        <?php
                        $prioridades = [
                            'baixa' => 'Baixa',
                            'normal' => 'Normal',
                            'alta' => 'Alta',
                            'urgente' => 'Urgente'
                        ];
                        $pri = $prioridades[$ticket['prioridade']] ?? $ticket['prioridade'];
                        $priClass = [
                            'baixa' => 'secondary',
                            'normal' => 'primary',
                            'alta' => 'warning',
                            'urgente' => 'danger'
                        ][$ticket['prioridade']] ?? 'secondary';
                        ?>
                        <span class="badge bg-<?= $priClass ?>"><?= $pri ?></span>
                    </div>
                    <div class="col-md-3">
                        <strong>Data de Abertura:</strong><br>
                        <?= date('d/m/Y H:i', strtotime($ticket['data_abertura'])) ?>
                    </div>
                    <div class="col-md-3">
                        <strong>Atribuído Para:</strong><br>
                        <?= $ticket['atribuido_para_nome'] ? htmlspecialchars($ticket['atribuido_para_nome']) : '<span class="text-muted">Não atribuído</span>' ?>
                    </div>
                </div>

                <hr>

                <div class="mb-3">
                    <strong>Descrição:</strong>
                    <div class="mt-2 p-3 bg-light rounded">
                        <?= nl2br(htmlspecialchars($ticket['descricao'])) ?>
                    </div>
                </div>

                <?php if ($ticket['solucao']): ?>
                <div class="mb-3">
                    <strong>Solução:</strong>
                    <div class="mt-2 p-3 bg-success bg-opacity-10 rounded">
                        <?= nl2br(htmlspecialchars($ticket['solucao'])) ?>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Anexos -->
                <?php if (!empty($anexos)): ?>
                <div class="mb-3">
                    <strong>Anexos:</strong>
                    <div class="mt-2">
                        <div class="row g-2" id="anexos-container">
                            <?php foreach ($anexos as $anexo): ?>
                            <div class="col-md-3 col-sm-4 col-6">
                                <div class="anexo-item position-relative">
                                    <a href="<?= asset($anexo['caminho']) ?>" target="_blank" class="d-block">
                                        <img src="<?= asset($anexo['caminho']) ?>"
                                             alt="<?= htmlspecialchars($anexo['nome']) ?>"
                                             class="img-thumbnail w-100"
                                             style="height: 150px; object-fit: cover; cursor: pointer;">
                                    </a>
                                    <div class="anexo-info p-2 bg-light">
                                        <small class="text-muted d-block" style="font-size: 0.75rem;">
                                            <?= htmlspecialchars($anexo['nome']) ?>
                                        </small>
                                        <small class="text-muted" style="font-size: 0.7rem;">
                                            <?= $anexo['data'] ?>
                                        </small>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <i class="bi bi-chat-left-text me-2"></i> Comentários
            </div>
            <div class="card-body">
                <div id="comentarios-list">
                    <?php
                    // Filtrar apenas comentários não internos para clientes
                    $comentariosPublicos = array_filter($comentarios ?? [], function($c) {
                        return ($c['is_interno'] ?? 0) == 0 && ($c['tipo'] ?? 'comentario') !== 'atualizacao_status';
                    });
                    ?>
                    <?php if (!empty($comentariosPublicos)): ?>
                        <?php foreach ($comentariosPublicos as $comentario): ?>
                        <div class="mb-3 p-3 border rounded">
                            <div class="d-flex justify-content-between mb-2">
                                <div>
                                    <strong><?= htmlspecialchars($comentario['usuario_nome'] ?? 'Sistema') ?></strong>
                                </div>
                                <small class="text-muted"><?= date('d/m/Y H:i', strtotime($comentario['created_at'])) ?></small>
                            </div>
                            <p class="mb-0"><?= nl2br(htmlspecialchars($comentario['comentario'])) ?></p>
                        </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p class="text-muted text-center py-3">Nenhum comentário ainda</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card mb-3">
            <div class="card-header">
                <i class="bi bi-clock-history me-2"></i> Histórico
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <strong>Criado por:</strong><br>
                    <small><?= htmlspecialchars($ticket['criado_por_nome'] ?? 'Sistema') ?></small>
                </div>
                <div class="mb-2">
                    <strong>Data de Abertura:</strong><br>
                    <small><?= date('d/m/Y H:i', strtotime($ticket['data_abertura'])) ?></small>
                </div>
                <?php if ($ticket['data_resolucao']): ?>
                <div class="mb-2">
                    <strong>Data de Resolução:</strong><br>
                    <small><?= date('d/m/Y H:i', strtotime($ticket['data_resolucao'])) ?></small>
                </div>
                <?php endif; ?>
                <?php if ($ticket['data_fechamento']): ?>
                <div class="mb-2">
                    <strong>Data de Fechamento:</strong><br>
                    <small><?= date('d/m/Y H:i', strtotime($ticket['data_fechamento'])) ?></small>
                </div>
                <?php endif; ?>
                <?php if ($ticket['tempo_resolucao']): ?>
                <div class="mb-2">
                    <strong>Tempo de Resolução:</strong><br>
                    <small><?= $ticket['tempo_resolucao'] ?> minutos</small>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<style>
.anexo-item {
    border: 1px solid #dee2e6;
    border-radius: 4px;
    overflow: hidden;
    transition: transform 0.2s, box-shadow 0.2s;
}

.anexo-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.anexo-info {
    border-top: 1px solid #dee2e6;
}
</style>

<script>
// Lightbox para imagens
document.addEventListener('DOMContentLoaded', function() {
    const anexosContainer = document.getElementById('anexos-container');
    if (anexosContainer) {
        anexosContainer.addEventListener('click', function(e) {
            if (e.target.tagName === 'IMG') {
                e.preventDefault();
                const imgSrc = e.target.src;
                const imgAlt = e.target.alt;

                const lightbox = document.createElement('div');
                lightbox.className = 'lightbox-modal';
                lightbox.style.cssText = `
                    position: fixed;
                    top: 0;
                    left: 0;
                    width: 100%;
                    height: 100%;
                    background: rgba(0,0,0,0.9);
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    z-index: 9999;
                    cursor: pointer;
                `;

                const img = document.createElement('img');
                img.src = imgSrc;
                img.alt = imgAlt;
                img.style.cssText = `
                    max-width: 90%;
                    max-height: 90%;
                    object-fit: contain;
                `;

                lightbox.appendChild(img);
                document.body.appendChild(lightbox);

                lightbox.addEventListener('click', function() {
                    document.body.removeChild(lightbox);
                });
            }
        });
    }
});
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'acompanhar-tickets';
include ROOT_PATH . '/views/layouts/app.php';
?>

