<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <h2><i class="bi bi-plus-circle me-2"></i> Abrir Ticket</h2>
        <p class="text-muted">Preencha os dados abaixo para abrir um novo chamado</p>
    </div>
</div>

<div class="row justify-content-center">
    <div class="col-lg-12 col-xl-12">
        <div class="card shadow-sm">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-info-circle me-2"></i> Informações do Ticket</h5>
            </div>
            <div class="card-body">
                <form id="formAbrirTicket" action="<?= url('/tickets/abrir') ?>" method="POST"
                    enctype="multipart/form-data">
                    <!-- Primeira linha: Número e Prioridade -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="numero_ticket" class="form-label">Número do Ticket *</label>
                            <input type="text" class="form-control" id="numero_ticket" name="numero_ticket"
                                value="<?= htmlspecialchars($numeroTicket ?? '') ?>" required readonly
                                style="background-color: #f8f9fa;">
                        </div>
                        <div class="col-md-6">
                            <label for="prioridade" class="form-label">Prioridade *</label>
                            <select class="form-select" id="prioridade" name="prioridade" required>
                                <option value="baixa">Baixa</option>
                                <option value="normal" selected>Normal</option>
                                <option value="alta">Alta</option>
                                <option value="urgente">Urgente</option>
                            </select>
                        </div>
                    </div>

                    <!-- Segunda linha: Módulo e Tipo -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="modulo_id" class="form-label">Módulo *</label>
                            <select class="form-select" id="modulo_id" name="modulo_id" required>
                                <option value="">Selecione um módulo...</option>
                                <?php if (!empty($modulos)): ?>
                                <?php foreach ($modulos as $modulo): ?>
                                <option value="<?= $modulo['id'] ?>">
                                    <?= htmlspecialchars($modulo['nome']) ?>
                                </option>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="tipo" class="form-label">Tipo *</label>
                            <select class="form-select" id="tipo" name="tipo" required onchange="toggleOutrosTipo()">
                                <option value="cadastros">Cadastros</option>
                                <option value="venda">Venda</option>
                                <option value="nota_fiscal">Nota Fiscal</option>
                                <option value="estoque">Estoque</option>
                                <option value="relatorios">Relatórios</option>
                                <option value="outros">Outros</option>
                            </select>
                        </div>
                    </div>

                    <!-- Campo Outros Tipo (full width quando visível) -->
                    <div class="row mb-3" id="outros-tipo-container" style="display: none;">
                        <div class="col-12">
                            <label for="outros_tipo" class="form-label">Especifique o tipo *</label>
                            <input type="text" class="form-control" id="outros_tipo" name="outros_tipo"
                                placeholder="Digite o tipo">
                        </div>
                    </div>

                    <hr class="my-4">

                    <!-- Título -->
                    <div class="mb-3">
                        <label for="titulo" class="form-label">Título *</label>
                        <input type="text" class="form-control form-control-lg" id="titulo" name="titulo"
                            placeholder="Descreva brevemente o problema" required>
                    </div>

                    <!-- Descrição -->
                    <div class="mb-3">
                        <label for="descricao" class="form-label">Descrição *</label>
                        <textarea class="form-control" id="descricao" name="descricao" rows="6"
                            placeholder="Descreva detalhadamente o problema ou solicitação" required></textarea>
                        <small class="text-muted">Forneça o máximo de detalhes possível para facilitar o
                            atendimento.</small>
                    </div>

                    <hr class="my-4">

                    <!-- Upload de Imagens -->
                    <div class="mb-4">
                        <label for="imagens" class="form-label">
                            <i class="bi bi-image me-2"></i> Imagens (opcional)
                        </label>
                        <input type="file" class="form-control" id="imagens" name="imagens[]" multiple
                            accept="image/jpeg,image/jpg,image/png,image/gif,image/webp">
                        <small class="text-muted d-block mt-1">
                            <i class="bi bi-info-circle me-1"></i>
                            Você pode selecionar múltiplas imagens. Tamanho máximo: 5MB por imagem.
                        </small>
                        <div id="preview-imagens" class="mt-3"></div>
                    </div>

                    <!-- Botões -->
                    <div class="d-flex justify-content-between align-items-center pt-3 border-top">
                        <small class="text-muted">
                            <i class="bi bi-asterisk text-danger"></i> Campos obrigatórios
                        </small>
                        <button type="submit" class="btn btn-primary btn-lg px-4">
                            <i class="bi bi-check-circle me-2"></i> Abrir Ticket
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
#preview-imagens {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
    gap: 1rem;
}

.preview-image {
    position: relative;
    border: 1px solid #ddd;
    border-radius: 4px;
    overflow: hidden;
}

.preview-image img {
    width: 100%;
    height: 150px;
    object-fit: cover;
}

.preview-image .remove-btn {
    position: absolute;
    top: 5px;
    right: 5px;
    background: rgba(220, 53, 69, 0.9);
    color: white;
    border: none;
    border-radius: 50%;
    width: 25px;
    height: 25px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
}
</style>

<script>
function toggleOutrosTipo() {
    const tipo = document.getElementById('tipo').value;
    const outrosContainer = document.getElementById('outros-tipo-container');
    const outrosInput = document.getElementById('outros_tipo');

    if (tipo === 'outros') {
        outrosContainer.style.display = 'block';
        outrosInput.setAttribute('required', 'required');
    } else {
        outrosContainer.style.display = 'none';
        outrosInput.removeAttribute('required');
        outrosInput.value = '';
    }
}

// Preview de imagens
const fileInput = document.getElementById('imagens');
const previewContainer = document.getElementById('preview-imagens');
const selectedFiles = [];

fileInput.addEventListener('change', function(e) {
    previewContainer.innerHTML = '';
    selectedFiles.length = 0;

    Array.from(e.target.files).forEach((file, index) => {
        if (file.type.startsWith('image/')) {
            selectedFiles.push(file);
            const reader = new FileReader();

            reader.onload = function(e) {
                const div = document.createElement('div');
                div.className = 'preview-image';
                div.innerHTML = `
                    <img src="${e.target.result}" alt="Preview">
                    <button type="button" class="remove-btn" onclick="removeImage(${index})">
                        <i class="bi bi-x"></i>
                    </button>
                `;
                previewContainer.appendChild(div);
            };

            reader.readAsDataURL(file);
        }
    });
});

function removeImage(index) {
    selectedFiles.splice(index, 1);
    updateFileInput();
    updatePreview();
}

function updateFileInput() {
    const dt = new DataTransfer();
    selectedFiles.forEach(file => dt.items.add(file));
    fileInput.files = dt.files;
}

function updatePreview() {
    previewContainer.innerHTML = '';
    selectedFiles.forEach((file, index) => {
        const reader = new FileReader();
        reader.onload = function(e) {
            const div = document.createElement('div');
            div.className = 'preview-image';
            div.innerHTML = `
                <img src="${e.target.result}" alt="Preview">
                <button type="button" class="remove-btn" onclick="removeImage(${index})">
                    <i class="bi bi-x"></i>
                </button>
            `;
            previewContainer.appendChild(div);
        };
        reader.readAsDataURL(file);
    });
}

// Submissão do formulário
$(document).ready(function() {
    $('#formAbrirTicket').on('submit', function(e) {
        e.preventDefault();

        // Validação de campos obrigatórios antes de enviar
        const numeroTicket = $('#numero_ticket').val().trim();
        const titulo = $('#titulo').val().trim();
        const descricao = $('#descricao').val().trim();
        const moduloId = $('#modulo_id').val();
        const tipo = $('#tipo').val();
        const outrosTipo = $('#outros_tipo').val().trim();

        if (!numeroTicket) {
            Swal.fire({
                icon: 'error',
                title: 'Campo obrigatório',
                text: 'O número do ticket é obrigatório',
                confirmButtonText: 'OK'
            });
            $('#numero_ticket').focus();
            return;
        }

        if (!titulo) {
            Swal.fire({
                icon: 'error',
                title: 'Campo obrigatório',
                text: 'O título é obrigatório',
                confirmButtonText: 'OK'
            });
            $('#titulo').focus();
            return;
        }

        if (!descricao) {
            Swal.fire({
                icon: 'error',
                title: 'Campo obrigatório',
                text: 'A descrição é obrigatória',
                confirmButtonText: 'OK'
            });
            $('#descricao').focus();
            return;
        }

        if (!moduloId) {
            Swal.fire({
                icon: 'error',
                title: 'Campo obrigatório',
                text: 'Por favor, selecione um módulo',
                confirmButtonText: 'OK'
            });
            $('#modulo_id').focus();
            return;
        }

        if (tipo === 'outros' && !outrosTipo) {
            Swal.fire({
                icon: 'error',
                title: 'Campo obrigatório',
                text: 'Por favor, especifique o tipo',
                confirmButtonText: 'OK'
            });
            $('#outros_tipo').focus();
            return;
        }

        const formData = new FormData(this);
        const url = $(this).attr('action');

        // Log para debug
        console.log('=== ENVIANDO FORMULÁRIO DE TICKET ===');
        console.log('URL:', url);
        for (let [key, value] of formData.entries()) {
            if (key.startsWith('imagens')) {
                console.log(`${key}: [arquivo]`);
            } else {
                console.log(`${key}:`, value);
            }
        }
        console.log('====================================');

        // Mostrar loading
        Swal.fire({
            title: 'Processando...',
            text: 'Aguarde enquanto processamos seu ticket',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                Swal.close();
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message || 'Ticket criado com sucesso!',
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        if (response.data && response.data.redirect) {
                            window.location.href = response.data.redirect;
                        } else {
                            $('#formAbrirTicket')[0].reset();
                            previewContainer.innerHTML = '';
                            selectedFiles.length = 0;
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: response.message || 'Erro ao criar ticket'
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close();

                console.error('=== ERRO NA REQUISIÇÃO ===');
                console.error('Status:', xhr.status);
                console.error('Status Text:', xhr.statusText);
                console.error('Error:', error);
                console.error('Response Text:', xhr.responseText);

                let message = 'Erro ao processar requisição';
                let responseData = null;

                // Tentar parsear a resposta como JSON
                try {
                    if (xhr.responseText) {
                        // Remover possíveis espaços ou HTML antes do JSON
                        const text = xhr.responseText.trim();
                        if (text.startsWith('{') || text.startsWith('[')) {
                            responseData = JSON.parse(text);
                            console.log('Response JSON parseado:', responseData);
                        }
                    }
                } catch (e) {
                    console.error('Erro ao parsear resposta JSON:', e);
                    console.error('Resposta bruta (primeiros 500 chars):', xhr.responseText.substring(0, 500));
                }

                // Usar mensagem do JSON se disponível
                if (responseData) {
                    if (responseData.message) {
                        message = responseData.message;
                    } else if (responseData.error) {
                        message = responseData.error;
                    } else if (responseData.success === false && responseData.message) {
                        message = responseData.message;
                    }
                } else if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                } else if (xhr.status === 400) {
                    message = 'Erro 400: Dados inválidos. Verifique se todos os campos obrigatórios foram preenchidos.';
                } else if (xhr.status === 403) {
                    message = 'Acesso negado. Você não tem permissão para realizar esta ação.';
                } else if (xhr.status === 401) {
                    message = 'Não autenticado. Faça login novamente.';
                } else if (xhr.status === 500) {
                    message = 'Erro interno do servidor. Tente novamente mais tarde.';
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: message,
                    footer: xhr.status ? `Status: ${xhr.status}` : ''
                });
            }
        });
    });
});
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'abrir-ticket';
include ROOT_PATH . '/views/layouts/app.php';
?>