<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Configuração Inicial' ?> - Systhema ERP</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- SweetAlert2 -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">

    <style>
        :root {
            --primary: #1e40af;
            --primary-light: #3b82f6;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
        }

        .setup-container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 500px;
            width: 100%;
            padding: 3rem 2.5rem;
        }

        .setup-header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .setup-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            color: white;
            font-size: 2.5rem;
        }

        .setup-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 0.5rem;
        }

        .setup-subtitle {
            color: #64748b;
            font-size: 1rem;
        }

        .tenant-info {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 2rem;
            text-align: center;
        }

        .tenant-info strong {
            color: var(--primary);
            font-size: 1.1rem;
        }

        .form-label {
            font-weight: 600;
            color: #334155;
            margin-bottom: 0.5rem;
        }

        .form-control {
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            padding: 0.75rem 1rem;
            transition: all 0.3s;
        }

        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(30, 64, 175, 0.1);
        }

        .btn-setup {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
            color: white;
            border: none;
            padding: 0.875rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            width: 100%;
            transition: transform 0.2s;
        }

        .btn-setup:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(30, 64, 175, 0.3);
        }

        .info-box {
            background: #eff6ff;
            border: 1px solid #bfdbfe;
            border-radius: 8px;
            padding: 1rem;
            margin-top: 1.5rem;
        }

        .info-box i {
            color: var(--primary);
            margin-right: 0.5rem;
        }
    </style>
</head>

<body>
    <div class="setup-container">
        <div class="setup-header">
            <div class="setup-icon">
                <i class="bi bi-gear"></i>
            </div>
            <h1 class="setup-title">Configuração Inicial</h1>
            <p class="setup-subtitle">Configure o primeiro acesso ao seu tenant</p>
        </div>

        <div class="tenant-info">
            <div class="text-muted small mb-1">Configurando tenant:</div>
            <strong><?= htmlspecialchars($tenantName ?? 'Desconhecido') ?></strong>
            <div class="text-muted small mt-1">
                <i class="bi bi-link-45deg"></i>
                <?= htmlspecialchars($tenantSubdomain ?? 'desconhecido') ?>.localhost
            </div>
        </div>

        <form id="setupForm" method="POST" action="setup">
            <div class="mb-3">
                <label for="name" class="form-label">
                    <i class="bi bi-person"></i> Nome Completo
                </label>
                <input type="text" class="form-control" id="name" name="name" placeholder="Seu nome completo" required>
            </div>

            <div class="mb-3">
                <label for="email" class="form-label">
                    <i class="bi bi-envelope"></i> Email
                </label>
                <input type="email" class="form-control" id="email" name="email" placeholder="seu@email.com" required>
            </div>

            <div class="mb-3">
                <label for="password" class="form-label">
                    <i class="bi bi-lock"></i> Senha
                </label>
                <input type="password" class="form-control" id="password" name="password"
                    placeholder="Mínimo 6 caracteres" required>
            </div>

            <div class="mb-3">
                <label for="password_confirmation" class="form-label">
                    <i class="bi bi-lock-fill"></i> Confirmar Senha
                </label>
                <input type="password" class="form-control" id="password_confirmation" name="password_confirmation"
                    placeholder="Digite a senha novamente" required>
            </div>

            <button type="submit" class="btn btn-setup mt-3" id="submitBtn">
                <i class="bi bi-check-circle me-2"></i>Criar Usuário Admin
            </button>
        </form>

        <div class="info-box">
            <i class="bi bi-info-circle-fill"></i>
            <small>Este será o primeiro usuário administrador do sistema.</small>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        $(document).ready(function () {
            $('#setupForm').on('submit', function (e) {
                e.preventDefault();

                const password = $('#password').val();
                const passwordConfirmation = $('#password_confirmation').val();

                if (password !== passwordConfirmation) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Senhas não conferem',
                        text: 'As senhas digitadas não são iguais.',
                        confirmButtonColor: '#1e40af'
                    });
                    return;
                }

                if (password.length < 6) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Senha muito curta',
                        text: 'A senha deve ter no mínimo 6 caracteres.',
                        confirmButtonColor: '#1e40af'
                    });
                    return;
                }

                const submitBtn = $('#submitBtn');
                submitBtn.prop('disabled', true).html('<i class="bi bi-arrow-clockwise spin me-2"></i>Criando...');

                $.ajax({
                    url: 'setup',
                    type: 'POST',
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message || 'Usuário criado com sucesso!',
                                confirmButtonColor: '#10b981',
                                showConfirmButton: false,
                                timer: 2000
                            }).then(() => {
                                window.location.href = response.redirect || 'login';
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: response.message || 'Erro ao criar usuário',
                                confirmButtonColor: '#ef4444'
                            });
                            submitBtn.prop('disabled', false).html('<i class="bi bi-check-circle me-2"></i>Criar Usuário Admin');
                        }
                    },
                    error: function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: 'Erro ao processar solicitação',
                            confirmButtonColor: '#ef4444'
                        });
                        submitBtn.prop('disabled', false).html('<i class="bi bi-check-circle me-2"></i>Criar Usuário Admin');
                    }
                });
            });
        });
    </script>
</body>

</html>