<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item active">Tabelas de Preço</li>
            </ol>
        </nav>
        <h2><i class="bi bi-table me-2"></i> Tabelas de Preço</h2>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="bi bi-list-ul me-2"></i> Lista de Tabelas de Preço</h5>
                <div class="d-flex gap-2">
                    <button class="btn btn-outline-secondary" onclick="filtrarTabelas()">
                        <i class="bi bi-funnel"></i> Filtrar
                    </button>
                    <a href="<?= url('/tabelas-preco/criar') ?>" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-2"></i> Nova Tabela de Preço
                    </a>
                </div>
            </div>
            <div class="card-body">
                <!-- Filtros -->
                <div class="row mb-3" id="filtrosTabelas" style="display: none;">
                    <div class="col-md-3">
                        <label for="filtroEmpresa" class="form-label">Empresa</label>
                        <select class="form-select" id="filtroEmpresa">
                            <option value="">Todas</option>
                            <?php foreach ($empresas as $empresa): ?>
                                <option value="<?= $empresa['id'] ?>" <?= $empresa_id == $empresa['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($empresa['razao_social']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="filtroStatus" class="form-label">Status</label>
                        <select class="form-select" id="filtroStatus">
                            <option value="">Todos</option>
                            <option value="1" <?= $status === '1' ? 'selected' : '' ?>>Ativas</option>
                            <option value="0" <?= $status === '0' ? 'selected' : '' ?>>Inativas</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="filtroBusca" class="form-label">Buscar</label>
                        <input type="text" class="form-control" id="filtroBusca" placeholder="Nome ou descrição..."
                            value="<?= htmlspecialchars($search) ?>">
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button class="btn btn-primary w-100" onclick="aplicarFiltros()">
                            <i class="bi bi-search"></i> Buscar
                        </button>
                    </div>
                </div>

                <!-- Tabela -->
                <div class="table-responsive">
                    <table class="table table-hover" id="tabelaPrecos">
                        <thead class="table-light">
                            <tr>
                                <th>Nome</th>
                                <th>Empresa</th>
                                <th>Descrição</th>
                                <th>Tipo</th>
                                <th>Ordem</th>
                                <th>Status</th>
                                <th width="120">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($tabelas)): ?>
                                <?php foreach ($tabelas as $tabela): ?>
                                    <tr>
                                        <td>
                                            <strong><?= htmlspecialchars($tabela['nome']) ?></strong>
                                        </td>
                                        <td>
                                            <?= htmlspecialchars($tabela['empresa_nome'] ?? $tabela['empresa_fantasia'] ?? 'N/A') ?>
                                        </td>
                                        <td><?= htmlspecialchars($tabela['descricao'] ?? '') ?></td>
                                        <td>
                                            <span class="badge bg-info">
                                                <?= ucfirst($tabela['tipo'] ?? 'padrao') ?>
                                            </span>
                                        </td>
                                        <td><?= $tabela['ordem'] ?? 0 ?></td>
                                        <td>
                                            <span class="badge bg-<?= $tabela['ativo'] ? 'success' : 'danger' ?>">
                                                <?= $tabela['ativo'] ? 'Ativa' : 'Inativa' ?>
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="<?= url('/tabelas-preco/editar?id=' . $tabela['id']) ?>"
                                                    class="btn btn-outline-primary" title="Editar">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <button class="btn btn-outline-info"
                                                    onclick="abrirModalClonar(<?= $tabela['id'] ?>, '<?= htmlspecialchars($tabela['nome'], ENT_QUOTES) ?>', <?= $tabela['company_id'] ?>)"
                                                    title="Clonar">
                                                    <i class="bi bi-files"></i>
                                                </button>
                                                <button class="btn btn-outline-danger"
                                                    onclick="deletarTabela(<?= $tabela['id'] ?>, '<?= htmlspecialchars($tabela['nome'], ENT_QUOTES) ?>')"
                                                    title="Excluir">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="7" class="text-center text-muted py-4">
                                        <i class="bi bi-inbox display-6 d-block mb-2"></i>
                                        Nenhuma tabela de preço encontrada
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal para Clonar Tabela de Preço -->
<div class="modal fade" id="modalClonarTabela" tabindex="-1" aria-labelledby="modalClonarTabelaLabel"
    aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalClonarTabelaLabel">
                    <i class="bi bi-files me-2"></i> Clonar Tabela de Preço
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <p class="text-muted">
                        Clonando: <strong id="nome-tabela-clonar"></strong>
                    </p>
                </div>
                <div class="mb-3">
                    <label class="form-label">Clonar para:</label>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="tipoClonagem" id="clonarEmpresaEspecifica"
                            value="empresa" checked>
                        <label class="form-check-label" for="clonarEmpresaEspecifica">
                            Uma empresa específica
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="tipoClonagem" id="clonarTodasEmpresas"
                            value="todas">
                        <label class="form-check-label" for="clonarTodasEmpresas">
                            Todas as empresas
                        </label>
                    </div>
                </div>
                <div class="mb-3" id="selectEmpresaContainer">
                    <label for="empresaDestino" class="form-label">Selecione a empresa:</label>
                    <select class="form-select" id="empresaDestino">
                        <option value="">Selecione uma empresa</option>
                        <?php foreach ($empresas as $empresa): ?>
                            <option value="<?= $empresa['id'] ?>">
                                <?= htmlspecialchars($empresa['razao_social']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="alert alert-info" id="infoClonagemTodas" style="display: none;">
                    <i class="bi bi-info-circle me-2"></i>
                    A tabela será clonada para todas as empresas cadastradas no sistema.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="confirmarClonagem()">
                    <i class="bi bi-files me-1"></i> Clonar
                </button>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        // Filtros
        $('#filtroEmpresa, #filtroStatus, #filtroBusca').on('change keyup', function (e) {
            if (e.type === 'keyup' && e.key !== 'Enter') {
                return;
            }
            aplicarFiltros();
        });
    });

    function filtrarTabelas() {
        $('#filtrosTabelas').toggle();
    }

    function aplicarFiltros() {
        const empresa = $('#filtroEmpresa').val();
        const status = $('#filtroStatus').val();
        const busca = $('#filtroBusca').val();

        let url = '<?= url('/tabelas-preco') ?>?';
        const params = [];

        if (empresa) {
            params.push('empresa_id=' + encodeURIComponent(empresa));
        }
        if (status !== '') {
            params.push('status=' + encodeURIComponent(status));
        }
        if (busca) {
            params.push('search=' + encodeURIComponent(busca));
        }

        if (params.length > 0) {
            url += params.join('&');
        }

        window.location.href = url;
    }

    let tabelaIdClonar = null;
    let empresaOrigemClonar = null;

    function abrirModalClonar(id, nome, empresaOrigem) {
        tabelaIdClonar = id;
        empresaOrigemClonar = empresaOrigem;
        $('#nome-tabela-clonar').text(nome);
        $('#empresaDestino').val('');
        $('#clonarEmpresaEspecifica').prop('checked', true);
        $('#selectEmpresaContainer').show();
        $('#infoClonagemTodas').hide();

        // Remover empresa de origem da lista de destino
        $('#empresaDestino option').each(function () {
            if ($(this).val() == empresaOrigem) {
                $(this).hide();
            } else {
                $(this).show();
            }
        });

        const modal = new bootstrap.Modal(document.getElementById('modalClonarTabela'));
        modal.show();
    }

    $(document).ready(function () {
        // Toggle entre empresa específica e todas
        $('input[name="tipoClonagem"]').on('change', function () {
            if ($(this).val() === 'todas') {
                $('#selectEmpresaContainer').hide();
                $('#infoClonagemTodas').show();
            } else {
                $('#selectEmpresaContainer').show();
                $('#infoClonagemTodas').hide();
            }
        });
    });

    function confirmarClonagem() {
        const tipoClonagem = $('input[name="tipoClonagem"]:checked').val();
        let empresaDestino = null;

        if (tipoClonagem === 'empresa') {
            empresaDestino = $('#empresaDestino').val();
            if (!empresaDestino) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Selecione uma empresa de destino'
                });
                return;
            }
        }

        Swal.fire({
            title: 'Confirmar clonagem',
            html: tipoClonagem === 'todas'
                ? 'Deseja clonar esta tabela de preço para <strong>todas as empresas</strong>?'
                : `Deseja clonar esta tabela de preço para a empresa selecionada?`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sim, clonar',
            cancelButtonText: 'Cancelar',
            showLoaderOnConfirm: true,
            preConfirm: () => {
                return $.ajax({
                    url: '<?= url('/tabelas-preco/clonar') ?>',
                    method: 'POST',
                    data: {
                        id: tabelaIdClonar,
                        tipo: tipoClonagem,
                        empresa_destino: empresaDestino
                    },
                    dataType: 'json'
                }).then(response => {
                    if (!response.success) {
                        throw new Error(response.message || 'Erro ao clonar tabela');
                    }
                    return response;
                }).catch(error => {
                    Swal.showValidationMessage(error.message || 'Erro ao clonar tabela');
                });
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    icon: 'success',
                    title: 'Sucesso!',
                    text: result.value.message || 'Tabela(s) clonada(s) com sucesso',
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    location.reload();
                });
            }
        });
    }

    function deletarTabela(id, nome) {
        Swal.fire({
            title: 'Confirmar exclusão',
            html: `Deseja realmente excluir a tabela de preço <strong>"${nome}"</strong>?<br><br>
               <small class="text-muted">Esta ação não pode ser desfeita.</small>`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sim, excluir',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?= url('/tabelas-preco/excluir') ?>',
                    method: 'POST',
                    data: {
                        id: id
                    },
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message || 'Tabela de preço excluída com sucesso',
                                timer: 2000,
                                showConfirmButton: false
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: response.message || 'Erro ao excluir tabela de preço'
                            });
                        }
                    },
                    error: function (xhr) {
                        let errorMsg = 'Erro ao excluir tabela de preço';
                        try {
                            const response = JSON.parse(xhr.responseText);
                            errorMsg = response.message || errorMsg;
                        } catch (e) {
                            errorMsg = xhr.responseText || errorMsg;
                        }
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: errorMsg
                        });
                    }
                });
            }
        });
    }
</script>

<?php
$content = ob_get_clean();
include ROOT_PATH . '/views/layouts/app.php';
?>