<?php
ob_start();
$isEdit = isset($tabela) && !empty($tabela);
$tabela = $tabela ?? [];
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/tabelas-preco') ?>">Tabelas de Preço</a></li>
                <li class="breadcrumb-item active"><?= $isEdit ? 'Editar' : 'Nova' ?></li>
            </ol>
        </nav>
        <h2><i class="bi bi-<?= $isEdit ? 'pencil' : 'plus-circle' ?> me-2"></i> <?= $isEdit ? 'Editar' : 'Nova' ?> Tabela de Preço</h2>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-info-circle me-2"></i> Informações da Tabela de Preço</h5>
            </div>
            <div class="card-body">
                <form id="formTabelaPreco" method="POST" action="<?= url($isEdit ? '/tabelas-preco/editar' : '/tabelas-preco/criar') ?>">
                    <?php if ($isEdit): ?>
                        <input type="hidden" name="id" value="<?= $tabela['id'] ?>">
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="company_id" class="form-label">Empresa <span class="text-danger">*</span></label>
                            <select class="form-select" id="company_id" name="company_id" required>
                                <option value="">Selecione uma empresa</option>
                                <?php foreach ($empresas as $empresa): ?>
                                    <option value="<?= $empresa['id'] ?>"
                                            <?= ($isEdit && $tabela['company_id'] == $empresa['id']) ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($empresa['razao_social']) ?>
                                        <?= $empresa['nome_fantasia'] ? ' (' . htmlspecialchars($empresa['nome_fantasia']) . ')' : '' ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="form-text">Selecione a empresa para a qual esta tabela de preço será aplicada</div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="nome" class="form-label">Nome da Tabela <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="nome" name="nome"
                                   value="<?= htmlspecialchars($tabela['nome'] ?? '') ?>"
                                   required maxlength="255" placeholder="Ex: Tabela Atacado, Tabela Varejo">
                            <div class="form-text">Nome único para identificar esta tabela de preço</div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="tipo" class="form-label">Tipo</label>
                            <select class="form-select" id="tipo" name="tipo">
                                <option value="padrao" <?= ($tabela['tipo'] ?? 'padrao') === 'padrao' ? 'selected' : '' ?>>Padrão</option>
                                <option value="atacado" <?= ($tabela['tipo'] ?? '') === 'atacado' ? 'selected' : '' ?>>Atacado</option>
                                <option value="varejo" <?= ($tabela['tipo'] ?? '') === 'varejo' ? 'selected' : '' ?>>Varejo</option>
                                <option value="promocional" <?= ($tabela['tipo'] ?? '') === 'promocional' ? 'selected' : '' ?>>Promocional</option>
                                <option value="especial" <?= ($tabela['tipo'] ?? '') === 'especial' ? 'selected' : '' ?>>Especial</option>
                            </select>
                            <div class="form-text">Tipo de tabela de preço</div>
                        </div>

                        <div class="col-md-3 mb-3">
                            <label for="ordem" class="form-label">Ordem</label>
                            <input type="number" class="form-control" id="ordem" name="ordem"
                                   value="<?= $tabela['ordem'] ?? 0 ?>"
                                   min="0" step="1">
                            <div class="form-text">Ordem de exibição (menor número aparece primeiro)</div>
                        </div>

                        <div class="col-md-3 mb-3">
                            <label class="form-label">Status</label>
                            <div class="form-check form-switch mt-2">
                                <input class="form-check-input" type="checkbox" id="ativo" name="ativo"
                                       <?= ($tabela['ativo'] ?? 1) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="ativo">
                                    <?= ($tabela['ativo'] ?? 1) ? 'Ativa' : 'Inativa' ?>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="descricao" class="form-label">Descrição</label>
                            <textarea class="form-control" id="descricao" name="descricao"
                                      rows="3" maxlength="500"
                                      placeholder="Descrição opcional sobre esta tabela de preço"><?= htmlspecialchars($tabela['descricao'] ?? '') ?></textarea>
                            <div class="form-text">Descrição opcional sobre a tabela de preço</div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="d-flex justify-content-between">
                                <a href="<?= url('/tabelas-preco') ?>" class="btn btn-secondary">
                                    <i class="bi bi-arrow-left me-2"></i> Voltar
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-<?= $isEdit ? 'check-circle' : 'plus-circle' ?> me-2"></i>
                                    <?= $isEdit ? 'Atualizar' : 'Criar' ?> Tabela de Preço
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Atualizar label do switch quando mudar
    $('#ativo').on('change', function() {
        $(this).next('label').text($(this).is(':checked') ? 'Ativa' : 'Inativa');
    });

    // Validação e envio do formulário
    $('#formTabelaPreco').on('submit', function(e) {
        e.preventDefault();

        const formData = $(this).serialize();
        const url = $(this).attr('action');

        // Mostrar loading
        Swal.fire({
            title: '<?= $isEdit ? 'Atualizando' : 'Criando' ?>...',
            text: 'Por favor, aguarde',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            url: url,
            method: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message || 'Tabela de preço <?= $isEdit ? 'atualizada' : 'criada' ?> com sucesso',
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        window.location.href = '<?= url('/tabelas-preco') ?>';
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: response.message || 'Erro ao <?= $isEdit ? 'atualizar' : 'criar' ?> tabela de preço'
                    });
                }
            },
            error: function(xhr) {
                let errorMsg = 'Erro ao <?= $isEdit ? 'atualizar' : 'criar' ?> tabela de preço';
                try {
                    const response = JSON.parse(xhr.responseText);
                    errorMsg = response.message || errorMsg;

                    // Se houver erros de validação
                    if (response.errors) {
                        let errorsHtml = '<ul class="text-start">';
                        for (const field in response.errors) {
                            response.errors[field].forEach(error => {
                                errorsHtml += '<li>' + error + '</li>';
                            });
                        }
                        errorsHtml += '</ul>';
                        errorMsg = errorsHtml;
                    }
                } catch (e) {
                    errorMsg = xhr.responseText || errorMsg;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    html: errorMsg
                });
            }
        });
    });
});
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'tabelas-preco';
include ROOT_PATH . '/views/layouts/app.php';
?>

