<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/suporte') ?>">Suporte</a></li>
                <li class="breadcrumb-item active">Limpar Tabelas</li>
            </ol>
        </nav>
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="bi bi-trash me-2"></i> Limpar Tabelas</h2>
                <p class="text-muted">Selecione as tabelas que deseja limpar</p>
            </div>
            <a href="<?= url('/suporte') ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i> Voltar
            </a>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header bg-danger text-white">
        <h6 class="mb-0"><i class="bi bi-exclamation-triangle me-2"></i> Atenção: Esta operação é irreversível!</h6>
    </div>
    <div class="card-body">
        <form id="formLimparTabelas">
            <div class="mb-3">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <label class="form-label mb-0">Ative os switches para limpar as tabelas:</label>
                </div>
                <div class="table-responsive" style="max-height: 600px; overflow-y: auto;">
                    <table class="table table-sm table-hover">
                        <thead class="table-light sticky-top">
                            <tr>
                                <th style="width: 80px;">Ação</th>
                                <th>Tabela</th>
                                <th>Registros</th>
                                <th>Auxiliares</th>
                                <th>Tem Company ID</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($tabelas)): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted">Nenhuma tabela encontrada</td>
                            </tr>
                            <?php else: ?>
                            <?php foreach ($tabelas as $tabela): ?>
                            <tr>
                                <td>
                                    <div class="form-check form-switch">
                                        <input
                                            class="form-check-input tabela-switch"
                                            type="checkbox"
                                            role="switch"
                                            data-tabela="<?= htmlspecialchars($tabela['nome']) ?>"
                                            data-auxiliares="<?= htmlspecialchars(json_encode($tabela['auxiliares'] ?? [])) ?>"
                                            id="switch-<?= htmlspecialchars($tabela['nome']) ?>">
                                    </div>
                                </td>
                                <td>
                                    <code><?= htmlspecialchars($tabela['nome']) ?></code>
                                </td>
                                <td>
                                    <span class="badge bg-info"><?= number_format($tabela['total'], 0, ',', '.') ?></span>
                                </td>
                                <td>
                                    <?php if (!empty($tabela['auxiliares'])): ?>
                                        <span class="badge bg-secondary">
                                            <?= count($tabela['auxiliares']) ?> tabela(s)
                                            <?php if ($tabela['total_auxiliares'] > 0): ?>
                                                (<?= number_format($tabela['total_auxiliares'], 0, ',', '.') ?> registros)
                                            <?php endif; ?>
                                        </span>
                                        <br>
                                        <small class="text-muted">
                                            <?= implode(', ', array_slice($tabela['auxiliares'], 0, 3)) ?>
                                            <?php if (count($tabela['auxiliares']) > 3): ?>...<?php endif; ?>
                                        </small>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($tabela['tem_company_id']): ?>
                                    <span class="badge bg-success"><i class="bi bi-check-circle me-1"></i> Sim</span>
                                    <?php else: ?>
                                    <span class="badge bg-warning"><i class="bi bi-x-circle me-1"></i> Não</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="alert alert-warning">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <strong>Atenção:</strong> Esta operação irá <strong>permanentemente</strong> remover todos os dados das tabelas selecionadas.
                Tabelas com <code>company_id</code> terão apenas os registros da empresa atual removidos.
                Tabelas sem <code>company_id</code> terão <strong>todos</strong> os registros removidos.
                <br><strong>As tabelas auxiliares serão limpas automaticamente junto com a tabela principal.</strong>
            </div>

            <div class="d-flex justify-content-end gap-2">
                <a href="<?= url('/suporte') ?>" class="btn btn-secondary">
                    <i class="bi bi-x-circle me-2"></i> Voltar
                </a>
            </div>
        </form>
    </div>
</div>

<style>
.form-check-input:checked {
    background-color: #dc3545;
    border-color: #dc3545;
}

.form-check-input:focus {
    border-color: #dc3545;
    box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);
}
</style>

<script>
$(document).ready(function() {
    $('.tabela-switch').on('change', function() {
        const $switch = $(this);
        const tabela = $switch.data('tabela');
        const auxiliares = $switch.data('auxiliares') || [];
        const isChecked = $switch.is(':checked');

        if (!isChecked) {
            return; // Se desmarcou, não faz nada
        }

        // Perguntar se deseja limpar
        let mensagem = `Deseja limpar a tabela <strong>${tabela}</strong>?`;
        if (auxiliares.length > 0) {
            mensagem += `<br><br><strong>Tabelas auxiliares que também serão limpas:</strong><br>`;
            mensagem += auxiliares.map(a => `• ${a}`).join('<br>');
        }
        mensagem += `<br><br><strong>Esta ação é irreversível!</strong>`;

        Swal.fire({
            icon: 'warning',
            title: 'Confirmar limpeza',
            html: mensagem,
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sim, limpar',
            cancelButtonText: 'Cancelar',
            reverseButtons: true
        }).then((result) => {
            if (!result.isConfirmed) {
                // Se cancelou, desmarca o switch
                $switch.prop('checked', false);
                return;
            }

            // Executar limpeza
            Swal.fire({
                title: 'Limpando...',
                text: 'Aguarde enquanto limpamos a tabela',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: appUrl('/suporte/limpar-tabelas'),
                type: 'POST',
                data: {
                    tabela: tabela
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        let mensagem = `<strong>Tabela limpa com sucesso!</strong><br><br>`;

                        if (response.data && response.data.limpas) {
                            mensagem += `<strong>Tabelas limpas:</strong><br>`;
                            response.data.limpas.forEach(function(item) {
                                mensagem += `• ${item.tabela}: ${item.linhas} registro(s)<br>`;
                            });
                        }

                        if (response.data && response.data.erros && response.data.erros.length > 0) {
                            mensagem += `<br><strong>Erros:</strong><br>`;
                            response.data.erros.forEach(function(item) {
                                mensagem += `• ${item.tabela}: ${item.erro}<br>`;
                            });
                        }

                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            html: mensagem,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            // Desmarca o switch após sucesso
                            $switch.prop('checked', false);
                            // Recarrega a página para atualizar contadores
                            window.location.reload();
                        });
                    } else {
                        $switch.prop('checked', false);
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: response.message || 'Erro ao executar limpeza'
                        });
                    }
                },
                error: function(xhr) {
                    $switch.prop('checked', false);
                    let mensagem = 'Erro ao processar requisição';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        mensagem = xhr.responseJSON.message;
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: mensagem
                    });
                }
            });
        });
    });
});
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'suporte';
include ROOT_PATH . '/views/layouts/app.php';
?>

