<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item active">Suporte</li>
            </ol>
        </nav>
        <h2><i class="bi bi-headset me-2"></i> Suporte</h2>
        <p class="text-muted">Ferramentas administrativas reservadas ao suporte técnico</p>
    </div>
</div>

<div class="row">
    <div class="col-md-6 mb-4">
        <div class="card h-100">
            <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                    <div class="icon-box bg-danger text-white me-3">
                        <i class="bi bi-trash fs-4"></i>
                    </div>
                    <div>
                        <h5 class="mb-0">Limpar Tabelas</h5>
                        <small class="text-muted">Remover dados das tabelas do banco</small>
                    </div>
                </div>
                <p class="text-muted">Utilize esta ferramenta para limpar dados das tabelas selecionadas do banco de dados.</p>
                <a href="<?= url('/suporte/limpar-tabelas') ?>" class="btn btn-outline-danger">
                    <i class="bi bi-arrow-right me-2"></i> Acessar
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-6 mb-4">
        <div class="card h-100">
            <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                    <div class="icon-box bg-primary text-white me-3">
                        <i class="bi bi-upload fs-4"></i>
                    </div>
                    <div>
                        <h5 class="mb-0">Importar Banco de Dados</h5>
                        <small class="text-muted">Importar arquivo SQL para o banco</small>
                    </div>
                </div>
                <p class="text-muted">Utilize esta ferramenta para importar um arquivo SQL e executar comandos no banco de dados.</p>
                <a href="<?= url('/suporte/importar-banco') ?>" class="btn btn-outline-primary">
                    <i class="bi bi-arrow-right me-2"></i> Acessar
                </a>
            </div>
        </div>
    </div>
</div>

<style>
.icon-box {
    width: 60px;
    height: 60px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
}
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'suporte';
include ROOT_PATH . '/views/layouts/app.php';
?>

