<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/suporte') ?>">Suporte</a></li>
                <li class="breadcrumb-item active">Importar Banco de Dados</li>
            </ol>
        </nav>
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="bi bi-upload me-2"></i> Importar Banco de Dados</h2>
                <p class="text-muted">Importe um arquivo SQL para executar comandos no banco de dados</p>
            </div>
            <a href="<?= url('/suporte') ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i> Voltar
            </a>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header bg-warning text-dark">
        <h6 class="mb-0"><i class="bi bi-exclamation-triangle me-2"></i> Atenção: Use com cuidado!</h6>
    </div>
    <div class="card-body">
        <form id="formImportarBanco" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="arquivo_sql" class="form-label">Arquivo SQL *</label>
                <input type="file" class="form-control" id="arquivo_sql" name="arquivo_sql" accept=".sql" required>
                <small class="text-muted">Apenas arquivos .sql são aceitos. Tamanho máximo: 50MB</small>
            </div>

            <div class="alert alert-info">
                <i class="bi bi-info-circle me-2"></i>
                <strong>Instruções:</strong>
                <ul class="mb-0 mt-2">
                    <li>O arquivo SQL será processado linha por linha</li>
                    <li>Comandos SQL serão executados na ordem que aparecem no arquivo</li>
                    <li>Recomenda-se fazer backup do banco antes de importar</li>
                    <li>Erros durante a execução serão registrados, mas a importação continuará</li>
                </ul>
            </div>

            <div class="alert alert-warning">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <strong>Atenção:</strong> Certifique-se de que o arquivo SQL é confiável e não contém comandos maliciosos.
                Esta operação pode modificar ou excluir dados do banco de dados.
            </div>

            <div class="d-flex justify-content-end gap-2">
                <a href="<?= url('/suporte') ?>" class="btn btn-secondary">
                    <i class="bi bi-x-circle me-2"></i> Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-upload me-2"></i> Importar Arquivo
                </button>
            </div>
        </form>
    </div>
</div>

<script>
$('#formImportarBanco').on('submit', function(e) {
    e.preventDefault();

    const arquivo = document.getElementById('arquivo_sql').files[0];

    if (!arquivo) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção!',
            text: 'Selecione um arquivo SQL para importar.'
        });
        return;
    }

    // Validar extensão
    if (!arquivo.name.toLowerCase().endsWith('.sql')) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: 'Apenas arquivos .sql são permitidos.'
        });
        return;
    }

    // Validar tamanho (50MB)
    const tamanhoMaximo = 50 * 1024 * 1024; // 50MB em bytes
    if (arquivo.size > tamanhoMaximo) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: 'O arquivo é muito grande. Tamanho máximo: 50MB.'
        });
        return;
    }

    Swal.fire({
        icon: 'warning',
        title: 'Tem certeza?',
        html: `Você está prestes a importar o arquivo <strong>${arquivo.name}</strong>.<br>Esta operação executará comandos SQL no banco de dados.`,
        showCancelButton: true,
        confirmButtonColor: '#0066cc',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sim, importar',
        cancelButtonText: 'Cancelar',
        reverseButtons: true
    }).then((result) => {
        if (!result.isConfirmed) return;

        Swal.fire({
            title: 'Importando...',
            html: 'Aguarde enquanto o arquivo é processado. Isso pode levar alguns minutos.',
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        const formData = new FormData(this);

        $.ajax({
            url: appUrl('/suporte/importar-banco'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            timeout: 300000, // 5 minutos
            success: function(response) {
                if (response.success) {
                    let mensagem = `<strong>Importação concluída!</strong><br><br>`;
                    mensagem += `<strong>Comandos executados:</strong> ${response.executados}<br>`;

                    if (response.erros && response.erros.length > 0) {
                        mensagem += `<strong>Erros encontrados:</strong> ${response.erros.length}`;

                        // Mostrar detalhes dos erros se houver
                        if (response.erros.length > 0) {
                            let detalhesErros = '<br><br><strong>Detalhes dos erros:</strong><ul>';
                            response.erros.slice(0, 5).forEach(erro => {
                                detalhesErros += `<li>${erro.erro}</li>`;
                            });
                            if (response.erros.length > 5) {
                                detalhesErros += `<li>... e mais ${response.erros.length - 5} erro(s)</li>`;
                            }
                            detalhesErros += '</ul>';
                            mensagem += detalhesErros;
                        }
                    }

                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        html: mensagem,
                        confirmButtonText: 'OK'
                    }).then(() => {
                        $('#formImportarBanco')[0].reset();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: response.message || 'Erro ao processar importação'
                    });
                }
            },
            error: function(xhr) {
                let mensagem = 'Erro ao processar requisição';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    mensagem = xhr.responseJSON.message;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: mensagem
                });
            }
        });
    });
});
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'suporte';
include ROOT_PATH . '/views/layouts/app.php';
?>

