<?php
/**
 * View: Contrato de Licença de Uso de Software
 */

$empresaNome = $empresa['razao_social'] ?? $empresa['nome'] ?? '[Inserir razão social da empresa contratante]';
$empresaCnpj = $empresa['cnpj'] ?? $empresa['document'] ?? '[●]';
$empresaEndereco = ($empresa['endereco'] ?? '') . ($empresa['numero'] ? ', ' . $empresa['numero'] : '') . ($empresa['bairro'] ? ' - ' . $empresa['bairro'] : '') . ($empresa['cidade'] ? ' - ' . $empresa['cidade'] : '') . ($empresa['uf'] ? '/' . $empresa['uf'] : '') . ($empresa['cep'] ? ' - CEP ' . $empresa['cep'] : '');
if (empty(trim($empresaEndereco))) {
    $empresaEndereco = '[●]';
}
$empresaRepresentante = $empresa['representante_legal'] ?? '[●]';

ob_start();
?>

<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">
                            <i class="bi bi-file-earmark-text me-2"></i>Contrato de Licença de Uso de Software
                        </h4>
                        <button onclick="window.print()" class="btn btn-outline-primary btn-sm">
                            <i class="bi bi-printer me-1"></i>Imprimir
                        </button>
                    </div>
                </div>
                <div class="card-body"
                    style="font-family: 'Times New Roman', serif; font-size: 12pt; line-height: 1.6;">
                    <div class="text-center mb-4">
                        <h3 class="mb-3"><strong>CONTRATO DE LICENÇA DE USO DE SOFTWARE, SUPORTE TÉCNICO E SERVIÇOS
                                CORRELATOS</strong></h3>
                    </div>

                    <p class="mb-4">Pelo presente instrumento, as partes:</p>

                    <div class="mb-4">
                        <p class="mb-2"><strong>CONTRATADA</strong></p>
                        <p class="mb-1"><strong>Systhema Tecnologia Ltda.</strong></p>
                        <p class="mb-1">CNPJ: 30.305.332/0001-45</p>
                        <p class="mb-1">Endereço: Av. Recife, 3250 – Sala 402 – Areias – Recife/PE – CEP 50781-001</p>
                        <p class="mb-1">E-mail: contato@Systhema.com.br</p>
                        <p class="mb-3">Telefone: (81) 99710-2197</p>

                        <p class="mb-2"><strong>CONTRATANTE</strong></p>
                        <p class="mb-1"><strong><?= htmlspecialchars($empresaNome) ?></strong></p>
                        <p class="mb-1">CNPJ: <?= htmlspecialchars($empresaCnpj) ?></p>
                        <p class="mb-1">Endereço: <?= htmlspecialchars($empresaEndereco) ?></p>
                        <p class="mb-3">Representante legal: <?= htmlspecialchars($empresaRepresentante) ?></p>
                    </div>

                    <p class="mb-4">Têm entre si justo e contratado o seguinte:</p>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>1. OBJETO DO CONTRATO</strong></h5>
                        <p class="mb-2"><strong>1.1.</strong> O presente contrato tem por objeto a concessão de licença
                            de uso não exclusiva, não transferível e limitada do software Systhema ERP, bem como a
                            prestação dos serviços de suporte, manutenção, atualizações e demais serviços acessórios
                            descritos neste instrumento e em seus anexos.</p>
                        <p class="mb-2"><strong>1.2.</strong> O software Systhema é composto pelos módulos,
                            funcionalidades e características técnicas descritas no <strong>ANEXO I – Descrição Técnica
                                do ERP</strong>.</p>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>2. CONCESSÃO DE LICENÇA</strong></h5>
                        <p class="mb-2"><strong>2.1.</strong> A CONTRATADA concede à CONTRATANTE licença de uso do Erp
                            Aurion ERP pelo prazo de vigência deste contrato, restrita aos usuários e limites descritos
                            na Cláusula 6 deste instrumento.</p>
                        <p class="mb-2"><strong>2.2.</strong> A licença não implica transferência de propriedade
                            intelectual, permanecendo o software integralmente sob titularidade da CONTRATADA.</p>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>3. SUPORTE E ATUALIZAÇÕES</strong></h5>
                        <p class="mb-2"><strong>3.1.</strong> O suporte será prestado de segunda a sexta-feira, das 08h
                            às 18h, por chat, e-mail ou telefone.</p>
                        <p class="mb-2"><strong>3.2.</strong> O suporte cobre:</p>
                        <ul class="mb-2">
                            <li>esclarecimento de dúvidas;</li>
                            <li>correções de falhas;</li>
                            <li>orientações de uso;</li>
                            <li>atualizações periódicas de segurança e melhorias.</li>
                        </ul>
                        <p class="mb-2"><strong>3.3.</strong> Customizações, integrações externas, relatórios
                            personalizados e desenvolvimentos específicos não estão incluídos no suporte, sendo
                            contratados à parte.</p>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>4. DISPONIBILIDADE E ACESSO</strong></h5>
                        <p class="mb-2"><strong>4.1.</strong> O Systhema permanecerá disponível 24 horas por dia, 7
                            dias por semana, salvo interrupções motivadas por:</p>
                        <ul class="mb-2">
                            <li>manutenção programada;</li>
                            <li>caso fortuito ou força maior;</li>
                            <li>falhas externas fora do controle da CONTRATADA.</li>
                        </ul>
                        <p class="mb-2"><strong>4.2.</strong> Manutenções programadas serão informadas com antecedência
                            mínima de 24 horas.</p>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>5. OBRIGAÇÕES DAS PARTES</strong></h5>
                        <p class="mb-2"><strong>5.1.</strong> Obrigações da CONTRATADA:</p>
                        <ul class="mb-2">
                            <li>fornecer acesso ao ERP dentro dos parâmetros contratados;</li>
                            <li>manter integridade e segurança dos dados;</li>
                            <li>realizar backups conforme <strong>ANEXO II – Política de Backup</strong>;</li>
                            <li>prestar suporte técnico.</li>
                        </ul>
                        <p class="mb-2"><strong>5.2.</strong> Obrigações da CONTRATANTE:</p>
                        <ul class="mb-2">
                            <li>utilizar o sistema conforme orientações técnicas;</li>
                            <li>preservar sigilo de logins e senhas;</li>
                            <li>manter seus equipamentos e internet em condições adequadas;</li>
                            <li>pagar pontualmente os valores contratados.</li>
                        </ul>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>6. VALORES, PLANOS E LIMITES</strong></h5>
                        <p class="mb-2"><strong>6.1.</strong> A CONTRATANTE opta pelo plano:</p>
                        <ul class="mb-2">
                            <li>Plano escolhido: [●] (ex.: Plano Professional / Enterprise / Ilimitado)</li>
                            <li>Quantidade de usuários: [●]</li>
                            <li>Valor mensal da licença: R$ [●],00</li>
                            <li>Valor da implantação (quando houver): R$ [●],00</li>
                            <li>Valor por usuário adicional: R$ [●],00</li>
                        </ul>
                        <p class="mb-2"><strong>6.2.</strong> A cobrança ocorrerá mensalmente por boleto, Pix ou cartão,
                            conforme escolha da CONTRATANTE.</p>
                        <p class="mb-2"><strong>6.3.</strong> O não pagamento por 15 dias permite a suspensão temporária
                            do acesso; por 30 dias, permite o cancelamento definitivo.</p>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>7. PRAZO E RESCISÃO</strong></h5>
                        <p class="mb-2"><strong>7.1.</strong> O contrato tem vigência inicial de 12 (doze) meses,
                            renovado automaticamente por igual período.</p>
                        <p class="mb-2"><strong>7.2.</strong> Pode ser rescindido por qualquer das partes mediante aviso
                            prévio de 30 dias.</p>
                        <p class="mb-2"><strong>7.3.</strong> Em caso de rescisão por inadimplência, os valores vencidos
                            permanecem exigíveis.</p>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>8. PROPRIEDADE INTELECTUAL</strong></h5>
                        <p class="mb-2"><strong>8.1.</strong> O software, seus módulos, código-fonte, layout e estrutura
                            pertencem exclusivamente à CONTRATADA.</p>
                        <p class="mb-2"><strong>8.2.</strong> É vedado à CONTRATANTE:</p>
                        <ul class="mb-2">
                            <li>copiar, distribuir ou comercializar o ERP;</li>
                            <li>permitir engenharia reversa;</li>
                            <li>usar o sistema para fins ilícitos.</li>
                        </ul>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>9. PROTEÇÃO DE DADOS E LGPD</strong></h5>
                        <p class="mb-2"><strong>9.1.</strong> As partes cumprem a Lei Geral de Proteção de Dados (Lei
                            13.709/2018).</p>
                        <p class="mb-2"><strong>9.2.</strong> A CONTRATADA adota medidas técnicas e administrativas
                            adequadas para proteção dos dados processados pelo ERP.</p>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>10. BACKUP E SEGURANÇA</strong></h5>
                        <p class="mb-2"><strong>10.1.</strong> A rotina completa de backup aplicada ao ambiente está
                            descrita detalhadamente no <strong>ANEXO II – Política de Backup</strong>.</p>
                        <p class="mb-2"><strong>10.2.</strong> A CONTRATADA não se responsabiliza por perdas de dados
                            decorrentes de ações da CONTRATANTE, como exclusões, alterações indevidas ou inserção
                            incorreta de informações.</p>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>11. DISPOSIÇÕES GERAIS</strong></h5>
                        <p class="mb-2"><strong>11.1.</strong> Este contrato não gera vínculo societário ou empregatício
                            entre as partes.</p>
                        <p class="mb-2"><strong>11.2.</strong> Alterações só terão validade se realizadas por termo
                            aditivo assinado por ambas as partes.</p>
                        <p class="mb-2"><strong>11.3.</strong> O foro eleito é o da Comarca de Recife/PE.</p>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>ANEXO I – DESCRIÇÃO TÉCNICA DO ERP Systhema</strong></h5>

                        <p class="mb-2"><strong>1. Arquitetura e Tecnologia</strong></p>
                        <ul class="mb-2">
                            <li>Linguagem: PHP 8</li>
                            <li>Banco de dados: MySQL</li>
                            <li>Interface: Bootstrap 3 + AdminLTE</li>
                            <li>Ambiente: Web / Cloud</li>
                            <li>Padrão modular e escalável.</li>
                        </ul>

                        <p class="mb-2"><strong>2. Módulos Disponíveis</strong></p>
                        <ul class="mb-2">
                            <li>Cadastro de Empresas</li>
                            <li>Cadastros de Pessoas (PF/PJ)</li>
                            <li>Cadastro de Produtos</li>
                            <li>Estoque e Almoxarifado</li>
                            <li>Compras</li>
                            <li>Vendas e Pedidos</li>
                            <li>Financeiro: Contas a Pagar e Receber</li>
                            <li>Controle de Caixa</li>
                            <li>PDV para loja física</li>
                            <li>Auditoria e Log de Ações</li>
                            <li>Permissões por módulos</li>
                            <li>Agenda de visitas</li>
                            <li>Administração do sistema</li>
                            <li>Importação de NF-e via SEFAZ (NFePHP)</li>
                            <li>Consulta de notas contra o CNPJ</li>
                            <li>Emissão de cobrança via API Asaas</li>
                        </ul>

                        <p class="mb-2"><strong>3. Funcionalidades Gerais</strong></p>
                        <ul class="mb-2">
                            <li>Telas responsivas</li>
                            <li>Máscaras de formulário</li>
                            <li>DataTables com exportações</li>
                            <li>Suporte para múltiplas empresas</li>
                            <li>Integrações externas via API</li>
                            <li>Módulos dinâmicos e parametrizáveis</li>
                        </ul>

                        <p class="mb-2"><strong>4. Limites Operacionais (ajustáveis)</strong></p>
                        <ul class="mb-2">
                            <li>Usuários simultâneos conforme plano contratado</li>
                            <li>Armazenamento conforme servidor contratado</li>
                            <li>Operações diárias ilimitadas</li>
                        </ul>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-2"><strong>ANEXO II – POLÍTICA DE BACKUP</strong></h5>

                        <p class="mb-2"><strong>1. Objetivo</strong></p>
                        <p class="mb-2">Garantir proteção, redundância e recuperabilidade dos dados armazenados no ERP
                            Systhema.</p>

                        <p class="mb-2"><strong>2. Tipos de Backup</strong></p>
                        <ul class="mb-2">
                            <li>Backup diário completo do banco de dados</li>
                            <li>Backup incremental a cada 6 horas</li>
                            <li>Backup semanal consolidado</li>
                            <li>Retenção padrão: 30 dias</li>
                        </ul>

                        <p class="mb-2"><strong>3. Armazenamento</strong></p>
                        <ul class="mb-2">
                            <li>Local seguro em storage criptografado</li>
                            <li>Servidor secundário geograficamente distinto</li>
                            <li>Criptografia AES-256</li>
                        </ul>

                        <p class="mb-2"><strong>4. Restauração</strong></p>
                        <ul class="mb-2">
                            <li>Solicitações podem ser feitas pela CONTRATANTE</li>
                            <li>Tempo médio de restauração: até 48 horas úteis</li>
                            <li>Recuperações específicas estão sujeitas a análise técnica</li>
                        </ul>

                        <p class="mb-2"><strong>5. Responsabilidades</strong></p>
                        <ul class="mb-2">
                            <li><strong>CONTRATADA:</strong> manter integridade, agendamento e segurança dos backups
                            </li>
                            <li><strong>CONTRATANTE:</strong> preservar logins, não comprometer banco com uso indevido,
                                manter acesso aos relatórios</li>
                        </ul>
                    </div>

                    <div class="mt-5 pt-4 border-top">
                        <div class="row">
                            <div class="col-md-6 text-center">
                                <p class="mb-4"><strong>Systhema Tecnologia e Consultoria Ltda.</strong></p>
                                <p class="mb-2">CONTRATADA</p>
                                <div class="mt-5"
                                    style="border-top: 1px solid #000; width: 80%; margin: 0 auto; padding-top: 5px;">
                                    <p class="mb-0">Assinatura</p>
                                </div>
                            </div>
                            <div class="col-md-6 text-center">
                                <p class="mb-4"><strong><?= htmlspecialchars($empresaNome) ?></strong></p>
                                <p class="mb-2">CONTRATANTE</p>
                                <div class="mt-5"
                                    style="border-top: 1px solid #000; width: 80%; margin: 0 auto; padding-top: 5px;">
                                    <p class="mb-0">Assinatura</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    @media print {

        .card-header,
        .btn {
            display: none !important;
        }

        .card {
            border: none !important;
            box-shadow: none !important;
        }

        .card-body {
            padding: 0 !important;
        }
    }
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'suporte';

// Garantir que ROOT_PATH está definido
if (!defined('ROOT_PATH')) {
    define('ROOT_PATH', dirname(dirname(__DIR__)));
}

$layoutPath = ROOT_PATH . '/views/layouts/app.php';
if (!file_exists($layoutPath)) {
    // Fallback: tentar caminho relativo
    $layoutPath = __DIR__ . '/../../layouts/app.php';
}

include $layoutPath;

