<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/gestao/backup') ?>">Gestão</a></li>
                <li class="breadcrumb-item active">Backup</li>
            </ol>
        </nav>
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="bi bi-database-check me-2"></i> Backup do Banco de Dados</h2>
                <p class="text-muted">Crie e gerencie backups do banco de dados</p>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h6 class="mb-0"><i class="bi bi-plus-circle me-2"></i> Criar Novo Backup</h6>
            </div>
            <div class="card-body">
                <p class="text-muted">Clique no botão abaixo para criar um novo backup do banco de dados.</p>
                <p class="text-muted mb-3">
                    <small><i class="bi bi-info-circle me-1"></i> O arquivo será salvo com o formato: <code>bkp_[dia_mes_ano_hora_minuto_segundo].sql</code></small>
                </p>
                <button type="button" class="btn btn-primary" id="btnCriarBackup">
                    <i class="bi bi-database-add me-2"></i> Criar Backup Agora
                </button>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="bi bi-archive me-2"></i> Backups Existentes</h6>
            </div>
            <div class="card-body">
                <?php if (empty($backups)): ?>
                <div class="alert alert-info">
                    <i class="bi bi-info-circle me-2"></i> Nenhum backup encontrado. Crie o primeiro backup acima.
                </div>
                <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Nome do Arquivo</th>
                                <th>Tamanho</th>
                                <th>Data de Criação</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($backups as $backup): ?>
                            <tr>
                                <td>
                                    <code><?= htmlspecialchars($backup['nome']) ?></code>
                                </td>
                                <td>
                                    <?php
                                    $bytes = $backup['tamanho'];
                                    if ($bytes === 0) {
                                        echo '0 Bytes';
                                    } else {
                                        $k = 1024;
                                        $sizes = ['Bytes', 'KB', 'MB', 'GB'];
                                        $i = floor(log($bytes) / log($k));
                                        echo number_format($bytes / pow($k, $i), 2, ',', '.') . ' ' . $sizes[$i];
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?= htmlspecialchars($backup['data']) ?>
                                </td>
                                <td>
                                    <a href="<?= url('/gestao/backup/download?arquivo=' . urlencode($backup['nome'])) ?>"
                                       class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-download me-1"></i> Download
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#btnCriarBackup').on('click', function() {
        const $btn = $(this);
        const textoOriginal = $btn.html();

        // Desabilitar botão e mostrar loading
        $btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>Criando backup...');

        Swal.fire({
            title: 'Criando backup...',
            text: 'Aguarde enquanto o backup é criado. Isso pode levar alguns minutos.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            url: appUrl('/gestao/backup/criar'),
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Backup criado!',
                        html: `
                            <p><strong>Backup criado com sucesso!</strong></p>
                            <p><strong>Arquivo:</strong> ${response.data.arquivo}</p>
                            <p><strong>Tamanho:</strong> ${formatarTamanho(response.data.tamanho)}</p>
                            <p><strong>Data:</strong> ${response.data.data}</p>
                        `,
                        confirmButtonText: 'OK'
                    }).then(() => {
                        window.location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: response.message || 'Erro ao criar backup'
                    });
                    $btn.prop('disabled', false).html(textoOriginal);
                }
            },
            error: function(xhr) {
                let mensagem = 'Erro ao processar requisição';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    mensagem = xhr.responseJSON.message;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: mensagem
                });
                $btn.prop('disabled', false).html(textoOriginal);
            }
        });
    });
});

function formatarTamanho(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB', 'GB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return Math.round(bytes / Math.pow(k, i) * 100) / 100 + ' ' + sizes[i];
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'backup';
include ROOT_PATH . '/views/layouts/app.php';
?>

