<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-calendar-check me-2"></i> Provisionamento</h2>
        <p class="text-muted">Visualize as contas provisionadas por período</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/saidas') ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-5">
                <label class="form-label">Período</label>
                <div class="input-group">
                    <input type="date" class="form-control" name="data_inicio"
                        value="<?= htmlspecialchars($dataInicio ?? date('Y-m-01')) ?>">
                    <span class="input-group-text">até</span>
                    <input type="date" class="form-control" name="data_fim"
                        value="<?= htmlspecialchars($dataFim ?? date('Y-m-t')) ?>">
                </div>
            </div>
            <div class="col-md-3 d-flex align-items-end">
                <button type="submit" class="btn btn-secondary w-100">
                    <i class="bi bi-search"></i> Filtrar
                </button>
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <div class="w-100">
                    <?php
                    $totalPeriodo = 0;
                    foreach ($contas ?? [] as $c) {
                        $totalPeriodo += ($c['amount'] ?? 0);
                    }
                    ?>
                    <div class="alert alert-info mb-0 py-2">
                        <strong>Total do Período: R$ <?= number_format($totalPeriodo, 2, ',', '.') ?></strong>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Calendário de Provisionamento -->
<div class="card">
    <div class="card-header">
        <i class="bi bi-calendar3 me-2"></i> Contas por Data de Vencimento
    </div>
    <div class="card-body">
        <?php if (!empty($contasPorData ?? [])): ?>
            <?php foreach ($contasPorData as $data => $contasData): ?>
                <?php
                $dataFormatada = date('d/m/Y', strtotime($data));
                $totalDia = 0;
                foreach ($contasData as $c) {
                    $totalDia += ($c['amount'] ?? 0);
                }
                ?>
                <div class="card mb-3 border-left-primary" style="border-left: 4px solid var(--primary-color);">
                    <div class="card-header bg-light d-flex justify-content-between align-items-center">
                        <strong>
                            <i class="bi bi-calendar-event me-2"></i>
                            <?= $dataFormatada ?>
                            <span class="badge bg-primary ms-2"><?= count($contasData) ?> conta(s)</span>
                        </strong>
                        <strong class="text-primary">Total: R$ <?= number_format($totalDia, 2, ',', '.') ?></strong>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Fornecedor</th>
                                    <th>Descrição</th>
                                    <th>Valor</th>
                                    <th>Status</th>
                                    <th width="100">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($contasData as $conta): ?>
                                    <tr>
                                        <td><?= $conta['id'] ?></td>
                                        <td><?= htmlspecialchars($conta['supplier_name'] ?? 'Fornecedor não informado') ?></td>
                                        <td><?= htmlspecialchars($conta['description']) ?></td>
                                        <td>R$ <?= number_format($conta['amount'] ?? 0, 2, ',', '.') ?></td>
                                        <td>
                                            <?php
                                            $statusBadges = [
                                                'pendente' => '<span class="badge bg-warning">Pendente</span>',
                                                'pago_parcial' => '<span class="badge bg-info">Pago Parcial</span>',
                                                'pago' => '<span class="badge bg-success">Pago</span>',
                                                'vencido' => '<span class="badge bg-danger">Vencido</span>'
                                            ];
                                            echo $statusBadges[$conta['status']] ?? '<span class="badge bg-secondary">-</span>';
                                            ?>
                                        </td>
                                        <td>
                                            <a href="<?= url('/saidas/visualizar?id=' . $conta['id']) ?>"
                                                class="btn btn-sm btn-outline-primary" title="Visualizar">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-calendar-check" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhuma conta encontrada para o período selecionado</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .border-left-primary {
        border-left: 4px solid var(--primary-color) !important;
    }
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'saidas';
include ROOT_PATH . '/views/layouts/app.php';
?>