<?php
$isEdit = isset($conta['id']);
$pessoas = $pessoas ?? [];
$fornecedores = $fornecedores ?? [];
$metodosPagamento = $metodosPagamento ?? [];
$contasBancarias = $contasBancarias ?? [];
$planoContas = $planoContas ?? [];
$centroCustos = $centroCustos ?? [];
$statusSaidas = $statusSaidas ?? [];
?>

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-receipt me-2"></i> Dados da Conta a Pagar
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Fornecedor com Autocomplete -->
                    <div class="col-md-6 mb-3">
                        <label for="supplier_search" class="form-label">
                            Fornecedor
                            <small class="text-muted">(Digite para buscar)</small>
                        </label>
                        <div class="position-relative">
                            <input type="text" class="form-control" id="supplier_search"
                                placeholder="Digite o nome ou documento do fornecedor..." autocomplete="off"
                                value="<?= htmlspecialchars($conta['supplier_name'] ?? '') ?>">
                            <div id="supplier_dropdown" class="autocomplete-dropdown" style="display: none;">
                            </div>
                        </div>
                        <input type="hidden" id="pessoa_id" name="pessoa_id"
                            value="<?= $conta['pessoa_id'] ?? $conta['supplier_id'] ?? '' ?>">
                        <input type="hidden" id="supplier_name" name="supplier_name"
                            value="<?= htmlspecialchars($conta['supplier_name'] ?? '') ?>">
                        <input type="hidden" id="supplier_document" name="supplier_document"
                            value="<?= htmlspecialchars($conta['supplier_document'] ?? '') ?>">
                    </div>

                    <!-- ID (somente na edição) -->
                    <?php if ($isEdit && !empty($conta['id'])): ?>
                    <div class="col-md-3 mb-3">
                        <label for="id_display" class="form-label">ID do Lançamento</label>
                        <input type="text" class="form-control bg-light" id="id_display" value="#<?= $conta['id'] ?>"
                            readonly>
                    </div>
                    <?php endif; ?>

                    <!-- Número/Número do Documento -->
                    <div class="col-md-<?= $isEdit && !empty($conta['id']) ? '3' : '6' ?> mb-3">
                        <label for="numero" class="form-label">Número do Documento</label>
                        <input type="text" class="form-control" id="numero" name="numero" placeholder="Ex: 001/2025"
                            value="<?= htmlspecialchars($conta['numero'] ?? '') ?>">
                    </div>

                    <!-- Descrição -->
                    <div class="col-md-12 mb-3">
                        <label for="description" class="form-label">Descrição <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="description" name="description"
                            value="<?= htmlspecialchars($conta['description'] ?? '') ?>" required>
                    </div>

                    <!-- Valor e Vencimento -->
                    <div class="col-md-6 mb-3">
                        <label for="amount" class="form-label">Valor <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text">R$</span>
                            <input type="number" class="form-control<?= $isEdit ? ' bg-light' : '' ?>" id="amount" name="amount" step="0.01" min="0"
                                value="<?= $conta['amount'] ?? '' ?>" <?= $isEdit ? 'readonly' : 'required' ?>>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="due_date" class="form-label">Data de Vencimento <span
                                class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="due_date" name="due_date"
                            value="<?= $conta['due_date'] ?? date('Y-m-d') ?>" required>
                    </div>

                    <!-- Juros, Multa, Desconto, Despesa -->
                    <div class="col-md-3 mb-3">
                        <label for="juros" class="form-label">Juros (R$)</label>
                        <div class="input-group">
                            <span class="input-group-text">R$</span>
                            <input type="number" class="form-control" id="juros" name="juros" step="0.01" min="0"
                                value="<?= $conta['juros'] ?? 0 ?>">
                        </div>
                    </div>

                    <div class="col-md-3 mb-3">
                        <label for="multa" class="form-label">Multa (R$)</label>
                        <div class="input-group">
                            <span class="input-group-text">R$</span>
                            <input type="number" class="form-control" id="multa" name="multa" step="0.01" min="0"
                                value="<?= $conta['multa'] ?? 0 ?>">
                        </div>
                    </div>

                    <div class="col-md-3 mb-3">
                        <label for="desconto" class="form-label">Desconto (R$)</label>
                        <div class="input-group">
                            <span class="input-group-text">R$</span>
                            <input type="number" class="form-control" id="desconto" name="desconto" step="0.01" min="0"
                                value="<?= $conta['desconto'] ?? 0 ?>">
                        </div>
                    </div>

                    <div class="col-md-3 mb-3">
                        <label for="despesa" class="form-label">Despesa (R$)</label>
                        <div class="input-group">
                            <span class="input-group-text">R$</span>
                            <input type="number" class="form-control" id="despesa" name="despesa" step="0.01" min="0"
                                value="<?= $conta['despesa'] ?? 0 ?>">
                        </div>
                    </div>

                    <!-- Valor Pago e Data de Pagamento (somente na edição) -->
                    <?php if ($isEdit): ?>
                    <div class="col-md-6 mb-3">
                        <label for="amount_paid" class="form-label">Valor Pago</label>
                        <div class="input-group">
                            <span class="input-group-text">R$</span>
                            <input type="number" class="form-control" id="amount_paid" name="amount_paid" step="0.01"
                                min="0" value="<?= $conta['amount_paid'] ?? 0 ?>">
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="payment_date" class="form-label">Data de Pagamento</label>
                        <input type="date" class="form-control" id="payment_date" name="payment_date"
                            value="<?= $conta['payment_date'] ?? '' ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="amount_remaining" class="form-label">Valor Restante</label>
                        <div class="input-group">
                            <span class="input-group-text">R$</span>
                            <input type="text" class="form-control bg-light" id="amount_remaining"
                                value="<?= number_format($conta['amount_remaining'] ?? 0, 2, ',', '.') ?>" readonly>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Status -->
                    <div class="col-md-6 mb-3">
                        <label for="status_id" class="form-label">Status</label>
                        <select class="form-select" id="status_id" name="status_id" required>
                            <?php
                            $statusAtualId = $conta['status_id'] ?? '';
                            $temStatusAtual = false;

                            // Verificar se há status padrão
                            $statusPadraoId = '';
                            if (!empty($statusSaidas)) {
                                foreach ($statusSaidas as $status) {
                                    if (!empty($status['is_default'])) {
                                        $statusPadraoId = $status['id'] ?? $status['codigo'] ?? '';
                                        break;
                                    }
                                }
                                if (empty($statusPadraoId) && !empty($statusSaidas[0])) {
                                    $statusPadraoId = $statusSaidas[0]['id'] ?? $statusSaidas[0]['codigo'] ?? '';
                                }
                            }

                            if (!empty($statusSaidas)) {
                                foreach ($statusSaidas as $status):
                                    $statusId = $status['id'] ?? $status['codigo'] ?? '';
                                    $selected = false;
                                    if (!empty($statusAtualId)) {
                                        $selected = ($statusAtualId == $statusId);
                                        if ($selected) $temStatusAtual = true;
                                    } else {
                                        $selected = ($statusId == $statusPadraoId);
                                    }
                            ?>
                            <option value="<?= htmlspecialchars($statusId) ?>"
                                <?= $selected ? 'selected' : '' ?>>
                                <?= htmlspecialchars($status['nome'] ?? '') ?>
                            </option>
                            <?php
                                endforeach;
                            }

                            // Se o status atual não foi encontrado, adicionar como opção
                            if (!empty($statusAtualId) && !$temStatusAtual):
                            ?>
                            <option value="<?= $statusAtualId ?>" selected>
                                ID #<?= $statusAtualId ?> (Não encontrado)
                            </option>
                            <?php endif; ?>
                        </select>
                    </div>

                    <!-- Método de Pagamento -->
                    <div class="col-md-6 mb-3">
                        <label for="metodo_pagamento_id" class="form-label">Método de Pagamento</label>
                        <select class="form-select" id="metodo_pagamento_id" name="metodo_pagamento_id">
                            <option value="">Selecione...</option>
                            <?php if (!empty($metodosPagamento)): ?>
                            <?php foreach ($metodosPagamento as $metodo): ?>
                            <option value="<?= $metodo['id'] ?>"
                                <?= ($conta['payment_method'] ?? $conta['metodo_pagamento_id'] ?? $conta['payment_method_id'] ?? '') == $metodo['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($metodo['name'] ?? '') ?>
                            </option>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>

                    <!-- Conta Bancária -->
                    <div class="col-md-6 mb-3">
                        <label for="conta_bancaria_id" class="form-label">Conta Bancária</label>
                        <select class="form-select" id="conta_bancaria_id" name="conta_bancaria_id">
                            <option value="">Selecione...</option>
                            <?php if (!empty($contasBancarias)): ?>
                            <?php foreach ($contasBancarias as $contaBancaria): ?>
                            <option value="<?= $contaBancaria['id'] ?>"
                                <?= ($conta['conta_bancaria_id'] ?? '') == $contaBancaria['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($contaBancaria['bank_name'] ?? '') ?> -
                                Ag: <?= htmlspecialchars($contaBancaria['agency'] ?? '') ?> /
                                Conta: <?= htmlspecialchars($contaBancaria['account_number'] ?? '') ?>
                            </option>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>

                    <!-- Plano de Contas -->
                    <div class="col-md-6 mb-3">
                        <label for="plano_conta_id" class="form-label">Plano de Contas</label>
                        <select class="form-select" id="plano_conta_id" name="plano_conta_id">
                            <option value="">Selecione...</option>
                            <?php if (!empty($planoContas)): ?>
                            <?php foreach ($planoContas as $plano): ?>
                            <option value="<?= $plano['id'] ?>"
                                <?= ($conta['plano_conta_id'] ?? '') == $plano['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($plano['codigo'] ?? '') ?> -
                                <?= htmlspecialchars($plano['nome'] ?? $plano['name'] ?? '') ?>
                            </option>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>

                    <!-- Centro de Custo -->
                    <div class="col-md-6 mb-3">
                        <label for="centro_custo_id" class="form-label">Centro de Custo</label>
                        <select class="form-select" id="centro_custo_id" name="centro_custo_id">
                            <option value="">Selecione...</option>
                            <?php if (!empty($centroCustos)): ?>
                            <?php foreach ($centroCustos as $centro): ?>
                            <option value="<?= $centro['id'] ?>"
                                <?= ($conta['centro_custo_id'] ?? '') == $centro['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($centro['code'] ?? '') ?> -
                                <?= htmlspecialchars($centro['name'] ?? '') ?>
                            </option>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>

                    <!-- Observações -->
                    <div class="col-md-12 mb-3">
                        <label for="notes" class="form-label">Observações</label>
                        <textarea class="form-control" id="notes" name="notes"
                            rows="3"><?= htmlspecialchars($conta['notes'] ?? '') ?></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Resumo Financeiro (somente na edição) -->
    <?php if ($isEdit && isset($conta['amount'])): ?>
    <div class="card mt-3">
        <div class="card-header">
            <i class="bi bi-calculator me-2"></i> Resumo Financeiro
        </div>
        <div class="card-body">
            <div class="d-flex justify-content-between mb-2">
                <span class="text-muted">Valor Total:</span>
                <strong>R$ <?= number_format($conta['amount'], 2, ',', '.') ?></strong>
            </div>
            <div class="d-flex justify-content-between mb-2">
                <span class="text-muted">Valor Pago:</span>
                <strong class="text-success">R$
                    <?= number_format($conta['amount_paid'] ?? 0, 2, ',', '.') ?></strong>
            </div>
            <hr>
            <div class="d-flex justify-content-between">
                <span class="text-muted"><strong>Restante:</strong></span>
                <strong class="text-primary">R$
                    <?= number_format($conta['amount_remaining'] ?? 0, 2, ',', '.') ?></strong>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Seção de Anexos (apenas na edição) -->
<?php if ($isEdit && !empty($conta['id'])): ?>
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-paperclip me-2"></i> Anexos
            </div>
            <div class="card-body">
                <!-- Upload de Anexo -->
                <div class="mb-4">
                    <form id="formUploadAnexo" enctype="multipart/form-data">
                        <input type="hidden" name="conta_id" value="<?= $conta['id'] ?>">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="arquivo_anexo" class="form-label">Selecionar Arquivo</label>
                                    <input type="file" class="form-control" id="arquivo_anexo" name="arquivo"
                                        accept=".jpg,.jpeg,.png,.pdf">
                                    <small class="text-muted">Formatos permitidos: JPG, JPEG, PNG e PDF (máx. 10MB)</small>
                            </div>
                            <div class="col-md-4">
                                <label for="descricao_anexo" class="form-label">Descrição (opcional)</label>
                                <input type="text" class="form-control" id="descricao_anexo" name="descricao"
                                    placeholder="Ex: Nota fiscal, comprovante...">
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="bi bi-upload me-1"></i> Enviar
                                </button>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- Lista de Anexos -->
                <div id="listaAnexos">
                    <div class="text-center text-muted py-3">
                        <i class="bi bi-hourglass-split"></i> Carregando anexos...
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if ($isEdit): ?>
<input type="hidden" name="id" value="<?= $conta['id'] ?>">
<?php endif; ?>

<style>
.autocomplete-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: var(--bs-body-bg, #fff);
    border: 1px solid var(--bs-border-color, #dee2e6);
    border-top: none;
    border-radius: 0 0 0.375rem 0.375rem;
    max-height: 300px;
    overflow-y: auto;
    z-index: 1000;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

.autocomplete-item {
    padding: 0.875rem 1rem;
    cursor: pointer;
    border-bottom: 1px solid var(--bs-border-color, #f0f0f0);
    transition: all 0.15s ease-in-out;
    line-height: 1.5;
}

.autocomplete-item:hover,
.autocomplete-item.active {
    background-color: var(--bs-primary, #0d6efd);
    color: white;
    transform: translateX(3px);
}

.autocomplete-item:hover .text-muted {
    color: rgba(255, 255, 255, 0.8) !important;
}

.autocomplete-item:last-child {
    border-bottom: none;
}

.autocomplete-item .mb-1 {
    margin-bottom: 0.375rem;
}

.autocomplete-item strong {
    font-weight: 600;
}

.autocomplete-no-results {
    padding: 1rem;
    text-align: center;
    color: var(--bs-secondary, #6c757d);
}
</style>

<script>
// Lista de fornecedores do PHP
const fornecedoresData = <?= json_encode($fornecedores ?? []) ?>;
let selectedSupplier = null;
let autocompleteTimeout = null;

// Aguardar jQuery e inicializar
(function aguardarJQuery() {
    if (typeof jQuery === 'undefined') {
        setTimeout(aguardarJQuery, 100);
        return;
    }
    inicializarAutocompleteFornecedor();
    inicializarCalculoRestante();
})();

// ============================================
// AUTOCOMPLETE DE FORNECEDOR
// ============================================
function inicializarAutocompleteFornecedor() {
    const $search = $('#supplier_search');
    const $dropdown = $('#supplier_dropdown');

    // Ao digitar
    $search.on('input', function() {
        const query = $(this).val().trim().toLowerCase();

        clearTimeout(autocompleteTimeout);

        if (query.length < 2) {
            $dropdown.hide();
            return;
        }

        autocompleteTimeout = setTimeout(() => {
            buscarFornecedores(query);
        }, 300);
    });

    // Ao clicar fora, fechar dropdown
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#supplier_search, #supplier_dropdown').length) {
            $dropdown.hide();
        }
    });

    // Ao focar no campo
    $search.on('focus', function() {
        if ($(this).val().length >= 2) {
            buscarFornecedores($(this).val().trim().toLowerCase());
        }
    });

    // Ao pressionar Enter, apenas prevenir submit
    $search.on('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
        }
    });

    // Carregar fornecedor existente se estiver editando
    <?php if ($isEdit && !empty($conta['pessoa_id'] ?? $conta['supplier_id'])): ?>
    const fornecedorInicial = fornecedoresData.find(f => f.id == <?= $conta['pessoa_id'] ?? $conta['supplier_id'] ?>);
    if (fornecedorInicial) {
        selecionarFornecedor(fornecedorInicial);
    }
    <?php endif; ?>
}

function buscarFornecedores(query) {
    const $dropdown = $('#supplier_dropdown');

    // Filtrar fornecedores
    const results = fornecedoresData.filter(fornecedor => {
        const name = (fornecedor.name || '').toLowerCase();
        const tradeName = (fornecedor.trade_name || '').toLowerCase();
        const document = (fornecedor.document || '').toLowerCase();
        const email = (fornecedor.email || '').toLowerCase();
        const phone = (fornecedor.phone || '').toLowerCase();
        const mobile = (fornecedor.mobile || '').toLowerCase();

        return name.includes(query) || tradeName.includes(query) ||
            document.includes(query) || email.includes(query) ||
            phone.includes(query) || mobile.includes(query);
    });

    // Montar HTML
    let html = '';

    if (results.length > 0) {
        results.forEach(fornecedor => {
            const nomeFantasia = fornecedor.trade_name || '-';
            const razaoSocial = fornecedor.name || '-';
            const documento = fornecedor.document || 'Não informado';
            const codigo = String(fornecedor.id).padStart(4, '0');
            const telefone = fornecedor.phone || fornecedor.mobile || '-';
            const email = fornecedor.email || '-';

            html += `
                <div class="autocomplete-item" data-id="${fornecedor.id}">
                    <div class="mb-1">
                        <strong>Código: ${codigo}</strong>  |  ${documento}
                    </div>
                    <div class="mb-1">
                        <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                    </div>
                    <div class="text-muted small">
                        <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                    </div>
                </div>
            `;
        });
    } else {
        html = '<div class="autocomplete-no-results">Nenhum fornecedor encontrado</div>';
    }

    $dropdown.html(html).show();

    // Event listeners
    $dropdown.find('.autocomplete-item').on('click', function() {
        const fornecedorId = $(this).data('id');
        const fornecedor = fornecedoresData.find(f => f.id == fornecedorId);
        if (fornecedor) {
            selecionarFornecedor(fornecedor);
        }
    });
}

function selecionarFornecedor(fornecedor) {
    selectedSupplier = fornecedor;

    const nomeFantasia = fornecedor.trade_name || '-';
    const razaoSocial = fornecedor.name || '-';
    const nomeExibir = nomeFantasia !== '-' ? nomeFantasia : razaoSocial;

    // Preencher campos hidden
    $('#pessoa_id').val(fornecedor.id);
    $('#supplier_name').val(razaoSocial);
    $('#supplier_document').val(fornecedor.document || '');

    // Atualizar campo de busca
    $('#supplier_search').val(nomeExibir);

    // Fechar dropdown
    $('#supplier_dropdown').hide();
}

function limparFornecedor() {
    selectedSupplier = null;

    $('#pessoa_id').val('');
    $('#supplier_name').val('');
    $('#supplier_document').val('');
    $('#supplier_search').val('');
}

// ============================================
// CÁLCULO DE VALOR RESTANTE
// Valor Restante = Valor + Juros + Multa + Despesa - Desconto - Valor Pago
// ============================================
function inicializarCalculoRestante() {
    const amountInput = document.getElementById('amount');
    const amountPaidInput = document.getElementById('amount_paid');
    const jurosInput = document.getElementById('juros');
    const multaInput = document.getElementById('multa');
    const descontoInput = document.getElementById('desconto');
    const despesaInput = document.getElementById('despesa');
    const amountRemainingInput = document.getElementById('amount_remaining');

    function calcularRestante() {
        if (!amountInput) return;

        const valor = parseFloat(amountInput.value || 0);
        const juros = parseFloat(jurosInput?.value || 0);
        const multa = parseFloat(multaInput?.value || 0);
        const despesa = parseFloat(despesaInput?.value || 0);
        const desconto = parseFloat(descontoInput?.value || 0);
        const pago = parseFloat(amountPaidInput?.value || 0);

        // Valor Restante = Valor + Juros + Multa + Despesa - Desconto - Valor Pago
        const restante = valor + juros + multa + despesa - desconto - pago;

        if (amountRemainingInput) {
            amountRemainingInput.value = restante.toLocaleString('pt-BR', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });
        }
    }

    // Adicionar listeners para todos os campos
    if (amountInput) amountInput.addEventListener('input', calcularRestante);
    if (amountPaidInput) amountPaidInput.addEventListener('input', calcularRestante);
    if (jurosInput) jurosInput.addEventListener('input', calcularRestante);
    if (multaInput) multaInput.addEventListener('input', calcularRestante);
    if (descontoInput) descontoInput.addEventListener('input', calcularRestante);
    if (despesaInput) despesaInput.addEventListener('input', calcularRestante);

    // Calcular inicial
    calcularRestante();
}

// ============================================
// GERENCIAMENTO DE ANEXOS
// ============================================
<?php if ($isEdit && !empty($conta['id'])): ?>
$(document).ready(function() {
    const contaId = <?= $conta['id'] ?>;

    // Carregar anexos ao abrir a página
    carregarAnexos(contaId);

    // Upload de anexo
    $('#formUploadAnexo').on('submit', function(e) {
        e.preventDefault();

        const formData = new FormData(this);
        const descricao = $('#descricao_anexo').val();
        formData.append('descricao', descricao);

        $.ajax({
            url: appUrl('/saidas/anexos/upload'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function() {
                $('#formUploadAnexo button[type="submit"]').prop('disabled', true).html('<i class="bi bi-hourglass-split"></i> Enviando...');
            },
            success: function(response) {
                $('#formUploadAnexo button[type="submit"]').prop('disabled', false).html('<i class="bi bi-upload me-1"></i> Enviar');

                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message,
                        timer: 1500,
                        showConfirmButton: false
                    });

                    // Limpar formulário
                    $('#formUploadAnexo')[0].reset();

                    // Recarregar lista
                    carregarAnexos(contaId);
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message
                    });
                }
            },
            error: function() {
                $('#formUploadAnexo button[type="submit"]').prop('disabled', false).html('<i class="bi bi-upload me-1"></i> Enviar');
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'Erro ao fazer upload do anexo'
                });
            }
        });
    });
});

function carregarAnexos(contaId) {
    $.ajax({
        url: appUrl('/saidas/anexos/listar'),
        type: 'GET',
        data: { conta_id: contaId },
        success: function(response) {
            if (response.success) {
                exibirAnexos(response.data.anexos || []);
            }
        },
        error: function() {
            $('#listaAnexos').html('<div class="alert alert-danger">Erro ao carregar anexos</div>');
        }
    });
}

function exibirAnexos(anexos) {
    if (anexos.length === 0) {
        $('#listaAnexos').html('<div class="text-center text-muted py-3"><i class="bi bi-inbox"></i> Nenhum anexo cadastrado</div>');
        return;
    }

    let html = '<div class="table-responsive"><table class="table table-hover">';
    html += '<thead><tr><th>Arquivo</th><th>Descrição</th><th>Tamanho</th><th>Enviado por</th><th>Data</th><th width="120">Ações</th></tr></thead>';
    html += '<tbody>';

    anexos.forEach(function(anexo) {
        const tamanho = formatarTamanho(anexo.tamanho);
        const data = new Date(anexo.created_at).toLocaleString('pt-BR');
        const icone = obterIconeArquivo(anexo.nome_original);

        html += '<tr>';
        html += '<td><i class="bi ' + icone + ' me-2"></i>' + anexo.nome_original + '</td>';
        html += '<td>' + (anexo.descricao || '<span class="text-muted">-</span>') + '</td>';
        html += '<td>' + tamanho + '</td>';
        html += '<td>' + (anexo.usuario_nome || '-') + '</td>';
        html += '<td>' + data + '</td>';
        html += '<td>';
        html += '<a href="' + appUrl('/saidas/anexos/download?id=' + anexo.id) + '" class="btn btn-sm btn-outline-primary me-1" title="Download">';
        html += '<i class="bi bi-download"></i></a>';
        html += '<button onclick="deletarAnexo(' + anexo.id + ', ' + anexo.conta_id + ')" class="btn btn-sm btn-outline-danger" title="Excluir">';
        html += '<i class="bi bi-trash"></i></button>';
        html += '</td>';
        html += '</tr>';
    });

    html += '</tbody></table></div>';
    $('#listaAnexos').html(html);
}

function deletarAnexo(anexoId, contaId) {
    Swal.fire({
        title: 'Confirmar Exclusão',
        text: 'Tem certeza que deseja excluir este anexo?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Sim, excluir',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#dc3545'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: appUrl('/saidas/anexos/deletar'),
                type: 'POST',
                data: { anexo_id: anexoId },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            text: response.message,
                            timer: 1500,
                            showConfirmButton: false
                        });
                        carregarAnexos(contaId);
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: response.message
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Erro ao excluir anexo'
                    });
                }
            });
        }
    });
}

function formatarTamanho(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB', 'GB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return Math.round(bytes / Math.pow(k, i) * 100) / 100 + ' ' + sizes[i];
}

function obterIconeArquivo(nomeArquivo) {
    const extensao = nomeArquivo.split('.').pop().toLowerCase();
    const icones = {
        'pdf': 'bi-file-pdf',
        'jpg': 'bi-file-image',
        'jpeg': 'bi-file-image',
        'png': 'bi-file-image'
    };
    return icones[extensao] || 'bi-file';
}
<?php endif; ?>
</script>
