<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-cash-stack me-2"></i> Folha de Pagamento</h2>
        <p class="text-muted">Gerencie a folha de pagamento dos funcionários</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/saidas') ?>" class="btn btn-secondary me-2">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
        <a href="<?= url('/saidas/criar') ?>?tipo=folha" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Adicionar Pagamento
        </a>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Mês/Ano</label>
                <input type="month" class="form-control" name="mes" value="<?= htmlspecialchars($mes ?? date('Y-m')) ?>"
                    onchange="this.form.submit()">
            </div>
            <div class="col-md-8 d-flex align-items-end">
                <?php
                $totalFolha = 0;
                foreach ($contasFolha ?? [] as $c) {
                    $totalFolha += ($c['amount'] ?? 0);
                }
                ?>
                <div class="alert alert-info mb-0 w-100 py-2">
                    <strong>Total da Folha do Mês: R$ <?= number_format($totalFolha, 2, ',', '.') ?></strong>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Lista de Funcionários -->
<div class="card mb-4">
    <div class="card-header">
        <i class="bi bi-people me-2"></i> Funcionários Cadastrados
    </div>
    <div class="card-body">
        <?php if (!empty($funcionarios ?? [])): ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>CPF/CNPJ</th>
                            <th>Telefone</th>
                            <th>E-mail</th>
                            <th>Salário</th>
                            <th>Admissão</th>
                            <th width="100">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($funcionarios as $func): ?>
                            <tr>
                                <td><strong><?= htmlspecialchars($func['name']) ?></strong></td>
                                <td><?= htmlspecialchars($func['document'] ?? '-') ?></td>
                                <td><?= htmlspecialchars($func['phone'] ?? '-') ?></td>
                                <td><?= htmlspecialchars($func['email'] ?? '-') ?></td>
                                <td>R$ <?= number_format($func['salary'] ?? 0, 2, ',', '.') ?></td>
                                <td><?= $func['admission_date'] ? date('d/m/Y', strtotime($func['admission_date'])) : '-' ?>
                                </td>
                                <td>
                                    <a href="<?= url('/saidas/criar') ?>?tipo=folha&funcionario_id=<?= $func['id'] ?>"
                                        class="btn btn-sm btn-primary" title="Gerar Pagamento">
                                        <i class="bi bi-cash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-4">
                <i class="bi bi-people" style="font-size: 3rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhum funcionário cadastrado</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Contas da Folha -->
<div class="card">
    <div class="card-header">
        <i class="bi bi-list-check me-2"></i> Pagamentos do Mês (<?= date('F Y', strtotime($mes . '-01')) ?>)
    </div>
    <div class="card-body p-0">
        <?php if (!empty($contasFolha ?? [])): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Funcionário/Fornecedor</th>
                            <th>Descrição</th>
                            <th>Valor</th>
                            <th>Vencimento</th>
                            <th>Status</th>
                            <th width="100">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($contasFolha as $conta): ?>
                            <tr>
                                <td><?= $conta['id'] ?></td>
                                <td><?= htmlspecialchars($conta['supplier_name'] ?? 'Fornecedor não informado') ?></td>
                                <td><?= htmlspecialchars($conta['description']) ?></td>
                                <td>R$ <?= number_format($conta['amount'] ?? 0, 2, ',', '.') ?></td>
                                <td><?= date('d/m/Y', strtotime($conta['due_date'])) ?></td>
                                <td>
                                    <?php
                                    $statusBadges = [
                                        'pendente' => '<span class="badge bg-warning">Pendente</span>',
                                        'pago_parcial' => '<span class="badge bg-info">Pago Parcial</span>',
                                        'pago' => '<span class="badge bg-success">Pago</span>',
                                        'vencido' => '<span class="badge bg-danger">Vencido</span>'
                                    ];
                                    echo $statusBadges[$conta['status']] ?? '<span class="badge bg-secondary">-</span>';
                                    ?>
                                </td>
                                <td>
                                    <a href="<?= url('/saidas/visualizar?id=' . $conta['id']) ?>"
                                        class="btn btn-sm btn-outline-primary" title="Visualizar">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-cash-stack" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhum pagamento encontrado para o mês selecionado</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php
$content = ob_get_clean();
$activeMenu = 'saidas';
include ROOT_PATH . '/views/layouts/app.php';
?>