<?php
ob_start();
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="<?= url('/saidas') ?>">Saídas</a></li>
                        <li class="breadcrumb-item active">Editar Saída</li>
                    </ol>
                </div>
                <h4 class="page-title">
                    <i class="bi bi-pencil me-2"></i> Editar Saída (Conta a Pagar)
                </h4>
            </div>
        </div>
    </div>

    <form id="saidaForm" method="POST" action="<?= url('/saidas/editar') ?>">
        <input type="hidden" name="id" value="<?= $conta['id'] ?? '' ?>">

        <?php include ROOT_PATH . '/views/saidas/form.php'; ?>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-footer">
                        <button type="button" class="btn btn-primary" onclick="atualizarSaida()">
                            <i class="bi bi-check-lg me-2"></i> Atualizar Saída
                        </button>
                        <a href="<?= url('/saidas') ?>" class="btn btn-secondary">
                            <i class="bi bi-arrow-left me-2"></i> Voltar
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
    function atualizarSaida() {
        const form = document.getElementById('saidaForm');
        if (!form) {
            alert('Formulário não encontrado');
            return;
        }

        const formData = new FormData(form);
        const btn = event.target;
        const btnOriginalText = btn.innerHTML;

        btn.disabled = true;
        btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Atualizando...';

        fetch('<?= url('/saidas/editar') ?>', {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: formData
        })
            .then(response => {
                return response.json();
            })
            .then(data => {
                if (data && data.success) {
                    window.location.href = data.data?.redirect || '<?= url('/saidas') ?>';
                } else {
                    btn.disabled = false;
                    btn.innerHTML = btnOriginalText;
                    alert(data?.message || 'Erro ao atualizar');
                }
            })
            .catch(error => {
                btn.disabled = false;
                btn.innerHTML = btnOriginalText;
                console.error('Erro:', error);
                alert('Erro ao atualizar saída');
            });
    }
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'saidas';
include ROOT_PATH . '/views/layouts/app.php';
?>