<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Revenda | Aurion ERP</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary: #1e40af;
            --primary-dark: #1e3a8a;
            --primary-light: #3b82f6;
            --secondary: #64748b;
            --accent: #0ea5e9;
            --success: #059669;
            --warning: #d97706;
            --danger: #dc2626;
            --bg-dark: #0f172a;
            --bg-light: #f8fafc;
            --bg-white: #ffffff;
            --text-dark: #0f172a;
            --text-gray: #475569;
            --text-light: #64748b;
            --border: #e2e8f0;
            --border-light: #f1f5f9;
            --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #334155 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 1rem;
            position: relative;
            overflow: hidden;
        }

        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background:
                radial-gradient(circle at 20% 50%, rgba(30, 64, 175, 0.15) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(14, 165, 233, 0.15) 0%, transparent 50%),
                radial-gradient(circle at 40% 80%, rgba(99, 102, 241, 0.15) 0%, transparent 50%);
            pointer-events: none;
        }

        .login-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 24px;
            box-shadow: var(--shadow-lg);
            overflow: hidden;
            width: 90vw;
            height: 90vh;
            max-height: 90vh;
            position: relative;
            z-index: 1;
            display: grid;
            grid-template-columns: 1fr 1fr;
        }

        .login-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
            padding: 2rem;
            text-align: center;
            color: white;
            position: relative;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            overflow-y: auto;
        }

        .login-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="rgba(255,255,255,0.1)"/><circle cx="75" cy="75" r="1" fill="rgba(255,255,255,0.1)"/><circle cx="50" cy="10" r="0.5" fill="rgba(255,255,255,0.1)"/><circle cx="10" cy="60" r="0.5" fill="rgba(255,255,255,0.1)"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            opacity: 0.2;
        }

        .login-header-content {
            position: relative;
            z-index: 1;
        }

        .logo-container {
            margin-bottom: 1.5rem;
        }

        .logo-image {
            height: 130px;
            width: auto;
            object-fit: contain;
            filter: brightness(0) invert(1);
        }

        .login-title {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
            letter-spacing: -0.5px;
        }

        .login-subtitle {
            font-size: 1.2rem;
            opacity: 0.9;
            font-weight: 400;
            max-width: 300px;
            line-height: 1.5;
        }

        .login-header .d-flex {
            opacity: 0.9;
            font-size: 0.95rem;
            font-weight: 400;
        }

        .login-header .d-flex:hover {
            opacity: 1;
        }

        .login-body {
            padding: 2rem;
            display: flex;
            flex-direction: column;
            justify-content: center;
            overflow-y: auto;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            font-weight: 600;
            color: var(--text-dark);
            margin-bottom: 0.75rem;
            display: block;
            font-size: 0.95rem;
        }

        .form-control {
            border: 2px solid var(--border-light);
            border-radius: 12px;
            padding: 1.25rem 1.5rem 1.25rem 4rem;
            font-size: 1.1rem;
            transition: all 0.3s ease;
            background-color: var(--bg-white);
            box-shadow: var(--shadow);
        }

        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 4px rgba(30, 64, 175, 0.1), var(--shadow);
            outline: none;
            background-color: var(--bg-white);
        }

        .input-group {
            position: relative;
        }

        .input-group-icon {
            position: absolute;
            left: 1.5rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-light);
            z-index: 3;
            font-size: 1.3rem;
        }

        .btn-login {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
            color: white;
            border: none;
            border-radius: 12px;
            padding: 1.25rem 2.5rem;
            font-weight: 600;
            font-size: 1.1rem;
            width: 100%;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            box-shadow: var(--shadow);
        }

        .btn-login::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s;
        }

        .btn-login:hover::before {
            left: 100%;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(30, 64, 175, 0.3);
        }

        .btn-login:active {
            transform: translateY(0);
        }

        .btn-login:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }

        .login-footer {
            text-align: center;
            padding: 1rem 2rem;
            background: linear-gradient(135deg, var(--bg-light) 0%, var(--border-light) 100%);
            border-top: 1px solid var(--border);
        }

        .login-footer a {
            color: var(--primary);
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .login-footer a:hover {
            color: var(--primary-dark);
            text-decoration: underline;
        }

        .demo-info {
            background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
            border: 1px solid #f59e0b;
            border-radius: 12px;
            padding: 1.25rem;
            margin-bottom: 2rem;
            text-align: center;
            box-shadow: var(--shadow);
        }

        .demo-info .demo-title {
            font-weight: 600;
            color: #92400e;
            margin-bottom: 0.75rem;
            font-size: 1rem;
        }

        .demo-info .demo-credentials {
            font-size: 0.9rem;
            color: #78350f;
            line-height: 1.5;
        }

        .back-to-home {
            position: absolute;
            top: 1.5rem;
            left: 1.5rem;
            color: rgba(255, 255, 255, 0.9);
            text-decoration: none;
            font-size: 0.9rem;
            font-weight: 500;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .back-to-home:hover {
            color: white;
            transform: translateX(-2px);
        }

        .security-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            background: rgba(5, 150, 105, 0.1);
            color: var(--success);
            padding: 0.5rem 1rem;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 500;
            margin-top: 1rem;
        }

        .divider {
            display: flex;
            align-items: center;
            margin: 2rem 0;
            color: var(--text-light);
            font-size: 0.9rem;
        }

        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            height: 1px;
            background: var(--border);
        }

        .divider::before {
            margin-right: 1rem;
        }

        .divider::after {
            margin-left: 1rem;
        }

        @media (max-width: 768px) {
            .login-container {
                margin: 1rem;
                border-radius: 20px;
                width: 95vw;
                height: 95vh;
                grid-template-columns: 1fr;
            }

            .login-header {
                padding: 2rem 1.5rem;
            }

            .login-body {
                padding: 2rem 1.5rem;
            }

            .login-footer {
                padding: 1.5rem;
            }

            .login-title {
                font-size: 2rem;
            }

            .login-subtitle {
                font-size: 1rem;
            }

            .logo-image {
                height: 120px;
            }

            .form-control {
                padding: 1rem 1.25rem 1rem 3.5rem;
                font-size: 1rem;
            }

            .btn-login {
                padding: 1rem 2rem;
                font-size: 1rem;
            }

            .login-header .mt-4 {
                display: none;
            }
        }

        @media (max-width: 480px) {
            .login-container {
                margin: 0.5rem;
                border-radius: 16px;
                width: 98vw;
                height: 98vh;
            }

            .login-header {
                padding: 1.5rem;
            }

            .login-body {
                padding: 1.5rem;
            }

            .login-footer {
                padding: 1rem;
            }
        }
    </style>
</head>

<body>
    <div class="login-container">
        <a href="../" class="back-to-home">
            <i class="bi bi-arrow-left me-1"></i>Voltar ao Site
        </a>

        <div class="login-header">
            <div class="login-header-content">
                <div class="logo-container">
                    <img src="../storage/uploads/logo.png" alt="Systhema" class="logo-image">
                </div>
                <h1 class="login-title">Portal de Revendas</h1>
                <p class="login-subtitle">Área exclusiva para parceiros comerciais</p>

                <div class="mt-4">
                    <div class="d-flex align-items-center justify-content-center mb-3">
                        <i class="bi bi-shield-check me-2" style="font-size: 1.2rem;"></i>
                        <span>Ambiente seguro e confiável</span>
                    </div>
                    <div class="d-flex align-items-center justify-content-center mb-3">
                        <i class="bi bi-graph-up me-2" style="font-size: 1.2rem;"></i>
                        <span>Relatórios em tempo real</span>
                    </div>
                    <div class="d-flex align-items-center justify-content-center">
                        <i class="bi bi-headset me-2" style="font-size: 1.2rem;"></i>
                        <span>Suporte especializado</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="login-body">
            <!-- Informações de Demonstração -->
            <div class="demo-info">
                <div class="demo-title">
                    <i class="bi bi-shield-check me-1"></i>Ambiente de Demonstração
                </div>
                <div class="demo-credentials">
                    <strong>Credenciais de Acesso:</strong><br>
                    <strong>Email:</strong> revenda@demo.com<br>
                    <strong>Senha:</strong> demo123
                </div>
            </div>

            <form id="loginForm">
                <div class="form-group">
                    <label for="email" class="form-label">Email</label>
                    <div class="input-group">
                        <i class="bi bi-envelope input-group-icon"></i>
                        <input type="email" class="form-control" id="email" name="email" placeholder="seu@email.com"
                            value="revenda@demo.com" required>
                    </div>
                </div>

                <div class="form-group">
                    <label for="password" class="form-label">Senha</label>
                    <div class="input-group">
                        <i class="bi bi-lock input-group-icon"></i>
                        <input type="password" class="form-control" id="password" name="password" placeholder="••••••••"
                            value="demo123" required>
                    </div>
                </div>

                <button type="submit" class="btn-login" id="loginBtn">
                    <span class="btn-text">
                        <i class="bi bi-shield-lock me-2"></i>Acessar Portal
                    </span>
                    <span class="btn-loading d-none">
                        <i class="bi bi-arrow-clockwise spin me-2"></i>Autenticando...
                    </span>
                </button>

                <div class="security-badge">
                    <i class="bi bi-lock-fill"></i>
                    Conexão segura SSL/TLS
                </div>
            </form>

            <div class="login-footer">
                <p class="mb-0">
                    Não possui credenciais de revendedor?
                    <a href="../register">Solicite acesso</a>
                </p>
                <div class="mt-2">
                    <small class="text-muted">
                        © 2025 Systhema. Todos os direitos reservados.
                    </small>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const loginForm = document.getElementById('loginForm');
            const loginBtn = document.getElementById('loginBtn');
            const btnText = loginBtn.querySelector('.btn-text');
            const btnLoading = loginBtn.querySelector('.btn-loading');

            loginForm.addEventListener('submit', function (e) {
                e.preventDefault();

                const email = document.getElementById('email').value;
                const password = document.getElementById('password').value;

                if (!email || !password) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Campos Obrigatórios',
                        text: 'Por favor, preencha todos os campos de acesso.',
                        confirmButtonColor: '#1e40af',
                        confirmButtonText: 'Entendido'
                    });
                    return;
                }

                // Mostrar loading
                loginBtn.disabled = true;
                btnText.classList.add('d-none');
                btnLoading.classList.remove('d-none');

                // Fazer login via AJAX
                fetch('../revenda/login', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        email: email,
                        password: password
                    })
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Autenticação Bem-sucedida',
                                text: 'Redirecionando para o portal de revendas...',
                                confirmButtonColor: '#059669',
                                showConfirmButton: false,
                                timer: 1500
                            }).then(() => {
                                window.location.href = data.redirect || '../revenda/dashboard';
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Falha na Autenticação',
                                text: data.message ||
                                    'Credenciais inválidas. Verifique seu email e senha.',
                                confirmButtonColor: '#dc2626',
                                confirmButtonText: 'Tentar Novamente'
                            });

                            // Restaurar botão
                            loginBtn.disabled = false;
                            btnText.classList.remove('d-none');
                            btnLoading.classList.add('d-none');
                        }
                    })
                    .catch(error => {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro na Autenticação',
                            text: 'Ocorreu um erro ao processar sua solicitação. Tente novamente.',
                            confirmButtonColor: '#dc2626',
                            confirmButtonText: 'Tentar Novamente'
                        });

                        // Restaurar botão
                        loginBtn.disabled = false;
                        btnText.classList.remove('d-none');
                        btnLoading.classList.add('d-none');
                    });
            });

            // Adicionar classe de animação para o spinner
            const style = document.createElement('style');
            style.textContent = `
                .spin {
                    animation: spin 1s linear infinite;
                }
                @keyframes spin {
                    from { transform: rotate(0deg); }
                    to { transform: rotate(360deg); }
                }
            `;
            document.head.appendChild(style);
        });
    </script>
</body>

</html>