<?php
ob_start();

// Preparar logo da empresa
$logoPath = null;
if (!empty($empresa) && is_array($empresa)) {
    if (!empty($empresa['logo'])) {
        $logoPath = $empresa['logo'];
    }
    $cnpjLimpo = preg_replace('/\D/', '', $empresa['cnpj'] ?? $empresa['document'] ?? '');
    if ($cnpjLimpo && file_exists(ROOT_PATH . '/storage/uploads/logos/' . $cnpjLimpo . '.jpg')) {
        $logoPath = 'storage/uploads/logos/' . $cnpjLimpo . '.jpg';
    }
    if (!$logoPath && file_exists(ROOT_PATH . '/public/assets/images/logo.png')) {
        $logoPath = 'public/assets/images/logo.png';
    }
}

$empresaNome = !empty($empresa) && is_array($empresa) ? ($empresa['razao_social'] ?? $empresa['nome'] ?? $empresa['name'] ?? 'Empresa') : 'Empresa';
$empresaDoc = !empty($empresa) && is_array($empresa) ? ($empresa['cnpj'] ?? $empresa['document'] ?? '') : '';

$dataInicio = $dataInicio ?? date('Y-m-01');
$dataFim = $dataFim ?? date('Y-m-t');
$totalMovimentacoes = count($dados ?? []);
?>

<div class="row mb-4 no-print">
    <div class="col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/relatorios') ?>">Relatórios</a></li>
                <li class="breadcrumb-item active">Movimentação de Estoque</li>
            </ol>
        </nav>
        <div class="d-flex justify-content-between align-items-center">
            <h2 class="mb-0"><i class="bi bi-arrow-left-right me-2 text-warning"></i> Relatório de Movimentação de
                Estoque</h2>
            <a href="<?= url('/relatorios') ?>" class="btn btn-outline-secondary no-print">
                <i class="bi bi-arrow-left me-2"></i> Voltar
            </a>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4 no-print">
    <div class="card-header bg-warning text-dark">
        <i class="bi bi-funnel me-2"></i> Filtros
    </div>
    <div class="card-body">
        <form method="GET" action="<?= url('/relatorios/movimentacao-estoque') ?>" class="row g-3 align-items-end">
            <div class="col-md-2">
                <label for="data_inicio" class="form-label">Data Início</label>
                <input type="date" class="form-control" id="data_inicio" name="data_inicio"
                    value="<?= htmlspecialchars($dataInicio) ?>" required>
            </div>
            <div class="col-md-2">
                <label for="data_fim" class="form-label">Data Fim</label>
                <input type="date" class="form-control" id="data_fim" name="data_fim"
                    value="<?= htmlspecialchars($dataFim) ?>" required>
            </div>
            <div class="col-md-4">
                <label for="produto_search" class="form-label">Produto</label>
                <div class="position-relative" style="z-index: 1000;">
                    <input type="text" class="form-control" id="produto_search" name="produto_search"
                        placeholder="Digite o nome ou código do produto..."
                        value="<?= htmlspecialchars($produtoNome ?? '') ?>" autocomplete="off">
                    <input type="hidden" id="produto_id" name="produto_id"
                        value="<?= htmlspecialchars($_GET['produto_id'] ?? '') ?>">
                    <div id="produto_dropdown" class="autocomplete-dropdown"
                        style="display: none; position: absolute; top: 100%; left: 0; right: 0; background: white; border: 1px solid #ddd; border-top: none; border-radius: 0 0 4px 4px; max-height: 300px; overflow-y: auto; z-index: 1001; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);">
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <label for="lote" class="form-label">Lote</label>
                <input type="text" class="form-control" id="lote" name="lote" placeholder="Digite o lote..."
                    value="<?= htmlspecialchars($_GET['lote'] ?? '') ?>">
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-warning w-100">
                    <i class="bi bi-search me-2"></i> Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Cabeçalho de Impressão (só aparece na impressão) -->
<div class="print-header" style="display: none;">
    <div class="print-header-content">
        <div style="display: flex; align-items: center;">
            <?php if ($logoPath && file_exists(ROOT_PATH . '/' . $logoPath)): ?>
                <img src="<?= asset($logoPath) ?>" alt="Logo" class="print-logo">
            <?php endif; ?>
            <div class="print-empresa-info">
                <div class="print-empresa-nome"><?= strtoupper(htmlspecialchars($empresaNome)) ?></div>
                <?php if ($empresaDoc): ?>
                    <div class="print-empresa-doc">CNPJ: <?= htmlspecialchars($empresaDoc) ?></div>
                <?php endif; ?>
            </div>
        </div>
        <div class="print-relatorio-info">
            <div class="print-relatorio-titulo">Relatório de Movimentação de Estoque</div>
            <div class="print-relatorio-periodo">Período: <?= date('d/m/Y', strtotime($dataInicio)) ?> a
                <?= date('d/m/Y', strtotime($dataFim)) ?>
            </div>
        </div>
    </div>
</div>

<!-- Tabela de Resultados -->
<div class="card mb-4 resumo-card">
    <div class="card-header d-flex justify-content-between align-items-center bg-warning text-dark no-print">
        <span><i class="bi bi-table me-2"></i> Resultados</span>
        <div>
            <button onclick="window.print()" class="btn btn-light btn-sm no-print">
                <i class="bi bi-printer me-2"></i> Imprimir
            </button>
            <span class="badge bg-light text-dark ms-2"><?= $totalMovimentacoes ?> movimentação(ões)</span>
        </div>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($dados)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th style="min-width: 200px;">Produto</th>
                            <th class="text-center" style="min-width: 120px;">Tipo</th>
                            <th class="text-center" style="min-width: 100px;">Quantidade</th>
                            <th style="min-width: 120px;">Lote</th>
                            <th style="min-width: 150px;">Referência</th>
                            <th style="min-width: 150px;">Data/Hora</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($dados as $item): ?>
                            <?php
                            $tipo = $item['tipo'] ?? '';
                            $tipoClass = '';
                            $tipoLabel = '';
                            switch (strtolower($tipo)) {
                                case 'entrada':
                                case 'in':
                                    $tipoClass = 'success';
                                    $tipoLabel = 'Entrada';
                                    break;
                                case 'saida':
                                case 'out':
                                    $tipoClass = 'danger';
                                    $tipoLabel = 'Saída';
                                    break;
                                default:
                                    $tipoClass = 'secondary';
                                    $tipoLabel = ucfirst($tipo ?: 'Indefinido');
                            }
                            $quantidade = (float) ($item['quantidade'] ?? 0);
                            $dataMov = $item['data'] ?? '';
                            ?>
                            <tr>
                                <td>
                                    <strong><?= htmlspecialchars($item['produto'] ?? 'Não informado') ?></strong>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-<?= $tipoClass ?> no-print"><?= htmlspecialchars($tipoLabel) ?></span>
                                    <span class="print-only"><?= htmlspecialchars($tipoLabel) ?></span>
                                </td>
                                <td class="text-center">
                                    <?php if ($quantidade > 0): ?>
                                        <span class="text-success">+<?= number_format($quantidade, 2, ',', '.') ?></span>
                                    <?php elseif ($quantidade < 0): ?>
                                        <span class="text-danger"><?= number_format($quantidade, 2, ',', '.') ?></span>
                                    <?php else: ?>
                                        <span><?= number_format($quantidade, 2, ',', '.') ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if (!empty($item['lote'])): ?>
                                        <span class="badge bg-info"><?= htmlspecialchars($item['lote']) ?></span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($item['referencia'] ?? '-') ?></td>
                                <td><?= $dataMov ? date('d/m/Y H:i', strtotime($dataMov)) : '-' ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-inbox fs-1 text-muted d-block mb-3"></i>
                <p class="text-muted">Nenhuma movimentação encontrada no período.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Rodapé de Impressão -->
<div class="print-footer">
    <div>Impresso em <?= date('d/m/Y H:i:s') ?> - Systhema ERP</div>
</div>

<style>
    .print-header,
    .print-only,
    .print-footer {
        display: none;
    }

    @media print {
        @page {
            size: A4;
            margin: 0cm 2.5cm 2cm 2.5cm;
        }

        * {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }

        html,
        body,
        body>main,
        body>main>.content-wrapper,
        .container,
        .container-fluid,
        .row,
        .main-content,
        .content-wrapper,
        main,
        .sidebar,
        .topbar {
            margin: 0 !important;
            padding: 0 !important;
            height: auto !important;
        }

        body {
            font-size: 9pt;
            line-height: 1.3;
        }

        .no-print,
        .breadcrumb,
        .btn,
        form,
        .sidebar,
        .topbar,
        header,
        nav,
        .row.no-print,
        .card.no-print,
        .no-print.card,
        .no-print.row,
        div.no-print {
            display: none !important;
            margin: 0 !important;
            padding: 0 !important;
            height: 0 !important;
            visibility: hidden !important;
            opacity: 0 !important;
            position: absolute !important;
            left: -9999px !important;
            width: 0 !important;
            border: none !important;
            box-shadow: none !important;
        }

        .print-header {
            display: block !important;
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            right: 0 !important;
            width: 98% !important;
            max-width: 98% !important;
            margin: 0 auto !important;
            background-color: white !important;
            z-index: 1000 !important;
            border-bottom: 2px solid #333;
            padding: 8px 0 !important;
            page-break-after: avoid;
            page-break-inside: avoid;
            min-height: 60px !important;
        }

        .print-footer {
            display: block !important;
            position: fixed !important;
            bottom: 0 !important;
            left: 0 !important;
            right: 0 !important;
            width: 98% !important;
            max-width: 98% !important;
            margin: 0 auto !important;
            background-color: white !important;
            z-index: 999 !important;
            border-top: 1px solid #ddd;
            padding: 10px 0 !important;
            font-size: 8pt !important;
            color: #666 !important;
            text-align: center !important;
            page-break-inside: avoid !important;
            min-height: 30px !important;
        }

        .resumo-card {
            margin-top: 70px !important;
            margin-bottom: 50px !important;
            padding-top: 10px !important;
            padding-bottom: 10px !important;
        }

        .print-only {
            display: block !important;
        }

        .badge {
            background: transparent !important;
            color: #000 !important;
            padding: 0 !important;
            border: none !important;
            font-weight: normal !important;
        }

        .print-header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 100% !important;
        }

        .print-logo {
            max-width: 120px;
            max-height: 50px;
            object-fit: contain;
        }

        .print-empresa-info {
            flex: 1;
            margin-left: 15px;
        }

        .print-empresa-nome {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 2px;
        }

        .print-empresa-doc {
            font-size: 8pt;
            color: #666;
        }

        .print-relatorio-info {
            text-align: right;
        }

        .print-relatorio-titulo {
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 3px;
        }

        .print-relatorio-periodo {
            font-size: 9pt;
            color: #666;
        }

        .card {
            border: 1px solid #ddd !important;
            box-shadow: none !important;
            page-break-inside: avoid;
        }

        .card-header {
            background-color: #f8f9fa !important;
            border-bottom: 2px solid #ddd !important;
            padding: 8px 12px !important;
        }

        .table-responsive {
            width: 98% !important;
            margin: 0 auto !important;
            overflow: visible !important;
        }

        table {
            width: 98% !important;
            margin: 0 auto !important;
            border-collapse: collapse !important;
            font-size: 8pt;
            table-layout: auto;
        }

        .card-body table,
        .resumo-card table {
            width: 98% !important;
            margin: 0 auto !important;
        }

        th,
        td {
            padding: 6px 8px !important;
            border: 1px solid #ddd !important;
            vertical-align: middle;
            word-wrap: break-word;
        }

        th {
            background-color: #f8f9fa !important;
            font-weight: bold;
            text-align: center;
            white-space: nowrap;
        }

        td.text-end,
        td.text-center,
        th.text-end,
        th.text-center {
            white-space: nowrap !important;
        }

        td:first-child,
        th:first-child {
            max-width: 250px;
            white-space: normal;
            word-break: break-word;
        }

        .text-end {
            text-align: right !important;
        }

        .text-center {
            text-align: center !important;
        }

        tr {
            page-break-inside: avoid;
        }
    }

    /* Estilos para autocomplete */
    .autocomplete-dropdown {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: white;
        border: 1px solid #ddd;
        border-top: none;
        border-radius: 0 0 4px 4px;
        max-height: 300px;
        overflow-y: auto;
        z-index: 1000;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }

    .autocomplete-item {
        padding: 10px 15px;
        cursor: pointer;
        border-bottom: 1px solid #f0f0f0;
    }

    .autocomplete-item:hover {
        background-color: #f8f9fa;
    }

    .autocomplete-item:last-child {
        border-bottom: none;
    }

    .autocomplete-no-results {
        padding: 10px 15px;
        color: #6c757d;
        text-align: center;
    }
</style>

<script>
    $(document).ready(function () {
        let produtoTimeout = null;
        const $produtoSearch = $('#produto_search');
        const $produtoId = $('#produto_id');
        const $produtoDropdown = $('#produto_dropdown');

        // Carregar produto selecionado se houver
        <?php if (!empty($_GET['produto_id']) && !empty($produtoNome)): ?>
            $produtoSearch.val('<?= htmlspecialchars($produtoNome, ENT_QUOTES) ?>');
            $produtoId.val('<?= htmlspecialchars($_GET['produto_id'], ENT_QUOTES) ?>');
        <?php endif; ?>

        $produtoSearch.on('input', function () {
            const query = $(this).val().trim();
            clearTimeout(produtoTimeout);

            // Limpar produto_id se o campo estiver vazio
            if (query === '') {
                $produtoId.val('');
                $produtoDropdown.hide();
                return;
            }

            // Se o usuário apagou tudo, limpar seleção
            if (query.length < 2) {
                $produtoDropdown.hide();
                return;
            }

            produtoTimeout = setTimeout(() => {
                buscarProdutos(query);
            }, 300);
        });

        $produtoSearch.on('focus', function () {
            const query = $(this).val().trim();
            if (query.length >= 2) {
                buscarProdutos(query);
            }
        });

        // Fechar dropdown ao clicar fora
        $(document).on('click', function (e) {
            if (!$(e.target).closest('#produto_search, #produto_dropdown').length) {
                $produtoDropdown.hide();
            }
        });

        function buscarProdutos(query) {
            $.ajax({
                url: appUrl('/produtos/buscar'),
                type: 'GET',
                data: { q: query },
                dataType: 'json',
                success: function (response) {
                    if (response.success && response.data && response.data.length > 0) {
                        let html = '';
                        response.data.forEach(function (produto) {
                            const nome = produto.name || '';
                            const sku = produto.sku || '';
                            const preco = parseFloat(produto.price || 0);
                            const estoque = parseFloat(produto.stock_quantity || 0);

                            html += `
                            <div class="autocomplete-item" data-id="${produto.id}" data-nome="${nome}">
                                <div class="mb-1"><strong>${nome}</strong>${sku ? ' <span class="text-muted">(' + sku + ')</span>' : ''}</div>
                                <div class="text-muted small">
                                    <strong>Preço:</strong> R$ ${preco.toFixed(2).replace('.', ',')} |
                                    <strong>Estoque:</strong> ${estoque.toFixed(2).replace('.', ',')}
                                </div>
                            </div>
                        `;
                        });
                        $produtoDropdown.html(html).show();

                        // Adicionar evento de clique nos itens
                        $produtoDropdown.find('.autocomplete-item').on('click', function () {
                            const id = $(this).data('id');
                            const nome = $(this).data('nome');
                            const sku = $(this).closest('.autocomplete-item').find('span.text-muted').text().replace(/[()]/g, '');
                            const nomeCompleto = sku ? nome + ' (' + sku + ')' : nome;

                            $produtoId.val(id);
                            $produtoSearch.val(nomeCompleto);
                            $produtoDropdown.hide();
                        });
                    } else {
                        $produtoDropdown.html('<div class="autocomplete-no-results">Nenhum produto encontrado</div>').show();
                    }
                },
                error: function () {
                    $produtoDropdown.html('<div class="autocomplete-no-results">Erro ao buscar produtos</div>').show();
                }
            });
        }
    });
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'relatorios';
include ROOT_PATH . '/views/layouts/app.php';
?>