<?php
ob_start();

// Definir categorias de relatórios
$categorias = [
    'vendas' => [
        'nome' => 'Vendas',
        'icone' => 'bi-cart-check',
        'cor' => 'primary',
        'relatorios' => [
            [
                'nome' => 'Vendas por Período',
                'descricao' => 'Relatório de vendas por período personalizado',
                'url' => url('/relatorios/vendas-por-periodo'),
                'icone' => 'bi-calendar-range'
            ],
            [
                'nome' => 'Vendas por Produto',
                'descricao' => 'Produtos mais vendidos e menos vendidos',
                'url' => url('/relatorios/vendas-por-produto'),
                'icone' => 'bi-box'
            ],
            [
                'nome' => 'Vendas por Cliente',
                'descricao' => 'Ranking de clientes por volume de compras',
                'url' => url('/relatorios/vendas-por-cliente'),
                'icone' => 'bi-person'
            ],
            [
                'nome' => 'Vendas por Vendedor',
                'descricao' => 'Performance dos vendedores',
                'url' => url('/relatorios/vendas-por-vendedor'),
                'icone' => 'bi-person-badge'
            ]
        ]
    ],
    'comissoes' => [
        'nome' => 'Comissões',
        'icone' => 'bi-cash-coin',
        'cor' => 'danger',
        'relatorios' => [
            [
                'nome' => 'Comissões por Vendedor',
                'descricao' => 'Relatório de comissões por vendedor',
                'url' => url('/relatorios/comissoes-vendedor'),
                'icone' => 'bi-person-badge'
            ],
            [
                'nome' => 'Comissões por Profissional',
                'descricao' => 'Relatório de comissões por profissional/item',
                'url' => url('/relatorios/comissoes-profissional'),
                'icone' => 'bi-person-workspace'
            ],
            [
                'nome' => 'Comissões por Período',
                'descricao' => 'Comissões pagas em um período específico',
                'url' => url('/relatorios/comissoes-periodo'),
                'icone' => 'bi-calendar-range'
            ],
            [
                'nome' => 'Comissões por Produto',
                'descricao' => 'Análise de comissões por produto vendido',
                'url' => url('/relatorios/comissoes-produto'),
                'icone' => 'bi-box'
            ],
            [
                'nome' => 'Resumo de Comissões',
                'descricao' => 'Visão geral de todas as comissões',
                'url' => url('/relatorios/comissoes-resumo'),
                'icone' => 'bi-cash-stack'
            ]
        ]
    ],
    'financeiro' => [
        'nome' => 'Financeiro',
        'icone' => 'bi-currency-dollar',
        'cor' => 'success',
        'relatorios' => [
            [
                'nome' => 'Fluxo de Caixa',
                'descricao' => 'Entradas e saídas de dinheiro',
                'url' => url('/relatorios/fluxo-caixa'),
                'icone' => 'bi-arrow-left-right'
            ],
            [
                'nome' => 'Contas a Receber',
                'descricao' => 'Relatório de contas a receber',
                'url' => url('/relatorios/entradas'),
                'icone' => 'bi-arrow-down-circle'
            ],
            [
                'nome' => 'Contas a Pagar',
                'descricao' => 'Relatório de contas a pagar',
                'url' => url('/relatorios/contas-pagar'),
                'icone' => 'bi-arrow-up-circle'
            ],
            [
                'nome' => 'DRE',
                'descricao' => 'Demonstrativo de Resultado do Exercício',
                'url' => url('/relatorios/dre'),
                'icone' => 'bi-graph-up'
            ],
            [
                'nome' => 'Balanço Patrimonial',
                'descricao' => 'Balanço patrimonial da empresa',
                'url' => url('/relatorios/balanco'),
                'icone' => 'bi-pie-chart'
            ]
        ]
    ],
    'estoque' => [
        'nome' => 'Estoque',
        'icone' => 'bi-boxes',
        'cor' => 'warning',
        'relatorios' => [
            [
                'nome' => 'Estoque Atual',
                'descricao' => 'Posição atual do estoque',
                'url' => url('/relatorios/estoque-atual'),
                'icone' => 'bi-box'
            ],
            [
                'nome' => 'Movimentação de Estoque',
                'descricao' => 'Entradas e saídas do estoque',
                'url' => url('/relatorios/movimentacao-estoque'),
                'icone' => 'bi-arrow-repeat'
            ],
            [
                'nome' => 'Produtos em Falta',
                'descricao' => 'Produtos com estoque zero ou baixo',
                'url' => url('/relatorios/produtos-zerados'),
                'icone' => 'bi-exclamation-triangle'
            ],
            [
                'nome' => 'Produtos Próximos a Vencer',
                'descricao' => 'Produtos que vencem em até 120 dias',
                'url' => url('/relatorios/produtos-proximos-vencer'),
                'icone' => 'bi-clock-history'
            ],
            [
                'nome' => 'Inventário',
                'descricao' => 'Relatório de inventário completo',
                'url' => url('/relatorios/inventario'),
                'icone' => 'bi-clipboard-check'
            ],
            [
                'nome' => 'Valorização de Estoque',
                'descricao' => 'Valor total do estoque por categoria',
                'url' => url('/relatorios/valorizacao-estoque'),
                'icone' => 'bi-calculator'
            ]
        ]
    ],
    'compras' => [
        'nome' => 'Compras',
        'icone' => 'bi-cart-plus',
        'cor' => 'info',
        'relatorios' => [
            [
                'nome' => 'Compras por Período',
                'descricao' => 'Relatório de compras por período',
                'url' => url('/relatorios/compras-periodo'),
                'icone' => 'bi-calendar-range'
            ],
            [
                'nome' => 'Compras por Fornecedor',
                'descricao' => 'Análise de compras por fornecedor',
                'url' => url('/relatorios/compras-fornecedor'),
                'icone' => 'bi-truck'
            ],
            [
                'nome' => 'Produtos Mais Comprados',
                'descricao' => 'Ranking de produtos mais comprados',
                'url' => url('/relatorios/produtos-comprados'),
                'icone' => 'bi-box-seam'
            ]
        ]
    ],
    'clientes' => [
        'nome' => 'Clientes',
        'icone' => 'bi-people',
        'cor' => 'purple',
        'relatorios' => [
            [
                'nome' => 'Cadastro de Clientes',
                'descricao' => 'Lista completa de clientes cadastrados',
                'url' => url('/relatorios/clientes-cadastro'),
                'icone' => 'bi-person-lines-fill'
            ],
            [
                'nome' => 'Clientes por Segmento',
                'descricao' => 'Clientes agrupados por segmento',
                'url' => url('/relatorios/clientes-segmento'),
                'icone' => 'bi-diagram-3'
            ],
            [
                'nome' => 'Inadimplência',
                'descricao' => 'Relatório de clientes inadimplentes',
                'url' => url('/relatorios/inadimplencia'),
                'icone' => 'bi-exclamation-octagon'
            ]
        ]
    ],
    'produtos' => [
        'nome' => 'Produtos',
        'icone' => 'bi-box-seam',
        'cor' => 'secondary',
        'relatorios' => [
            [
                'nome' => 'Catálogo de Produtos',
                'descricao' => 'Lista completa de produtos',
                'url' => url('/relatorios/produtos-catalogo'),
                'icone' => 'bi-list-ul'
            ],
            [
                'nome' => 'Produtos por Categoria',
                'descricao' => 'Produtos agrupados por categoria',
                'url' => url('/relatorios/produtos-categoria'),
                'icone' => 'bi-tags'
            ],
            [
                'nome' => 'Margem de Lucro',
                'descricao' => 'Análise de margem de lucro por produto',
                'url' => url('/relatorios/margem-lucro'),
                'icone' => 'bi-percent'
            ]
        ]
    ],
    'fiscal' => [
        'nome' => 'Fiscal',
        'icone' => 'bi-receipt',
        'cor' => 'dark',
        'relatorios' => [
            [
                'nome' => 'Apuração de Impostos',
                'descricao' => 'Apuração de ICMS, PIS, COFINS e IPI nas vendas',
                'url' => url('/relatorios/apuracao-impostos'),
                'icone' => 'bi-calculator'
            ]
        ]
    ]
];
?>

<style>
    .relatorio-categoria {
        border-left: 4px solid;
        transition: all 0.3s ease;
    }

    .relatorio-categoria:hover {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        transform: translateY(-2px);
    }

    .relatorio-item {
        border-left: 3px solid transparent;
        transition: all 0.2s ease;
        cursor: pointer;
    }

    .relatorio-item:hover {
        border-left-color: var(--bs-primary);
        background-color: rgba(var(--bs-primary-rgb), 0.05);
        transform: translateX(5px);
    }

    .relatorio-item-icon {
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 8px;
        font-size: 1.25rem;
    }

    .categoria-header {
        cursor: pointer;
        user-select: none;
    }

    .categoria-header:hover {
        background-color: rgba(0, 0, 0, 0.02);
    }

    .categoria-content {
        transition: max-height 0.3s ease;
        overflow: hidden;
    }

    .categoria-content.collapsed {
        max-height: 0;
        padding: 0 !important;
    }

    .search-highlight {
        background-color: #fff3cd;
        padding: 2px 4px;
        border-radius: 3px;
    }

    /* Ocultar elementos durante impressão */
    @media print {

        .no-print,
        nav.breadcrumb,
        .row.mb-4:has(#buscaRelatorios),
        .row.mb-4:has(.border-primary),
        .row.mb-4:has(.border-danger),
        .row.mb-4:has(.border-success),
        .row.mb-4:has(.border-warning),
        .row.mb-4:has(.border-info),
        .row.mb-4:has(.border-secondary),
        .categoria-header,
        #semResultados {
            display: none !important;
        }

        .categoria-content {
            display: block !important;
            max-height: none !important;
        }

        .card {
            border: 1px solid #ddd !important;
            page-break-inside: avoid;
        }

        body {
            background: white !important;
        }
    }
</style>

<div class="row mb-4">
    <div class="col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item active">Relatórios</li>
            </ol>
        </nav>
        <div class="d-flex justify-content-between align-items-center">
            <h2 class="mb-0"><i class="bi bi-graph-up me-2"></i> Relatórios</h2>
        </div>
    </div>
</div>

<!-- Barra de Busca -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="input-group input-group-lg">
                    <span class="input-group-text bg-light">
                        <i class="bi bi-search"></i>
                    </span>
                    <input type="text" class="form-control" id="buscaRelatorios"
                        placeholder="Buscar relatórios por nome, categoria ou descrição...">
                    <button class="btn btn-outline-secondary" type="button" id="limparBusca" style="display: none;">
                        <i class="bi bi-x-circle"></i> Limpar
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Categorias de Relatórios -->
<div id="categoriasRelatorios">
    <?php foreach ($categorias as $key => $categoria): ?>
        <div class="card mb-3 relatorio-categoria categoria-card" data-categoria="<?= $key ?>"
            style="border-left-color: var(--bs-<?= $categoria['cor'] ?>);">
            <div class="card-header categoria-header bg-<?= $categoria['cor'] ?> bg-opacity-10" data-bs-toggle="collapse"
                data-bs-target="#categoria-<?= $key ?>" aria-expanded="true">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center">
                        <i class="bi <?= $categoria['icone'] ?> fs-4 text-<?= $categoria['cor'] ?> me-3"></i>
                        <h5 class="mb-0"><?= $categoria['nome'] ?></h5>
                        <span class="badge bg-<?= $categoria['cor'] ?> ms-2">
                            <?= count($categoria['relatorios']) ?>
                        </span>
                    </div>
                    <i class="bi bi-chevron-down collapse-icon"></i>
                </div>
            </div>
            <div class="collapse show categoria-content" id="categoria-<?= $key ?>">
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        <?php foreach ($categoria['relatorios'] as $relatorio): ?>
                            <a href="<?= $relatorio['url'] ?>" class="list-group-item list-group-item-action relatorio-item"
                                data-nome="<?= strtolower($relatorio['nome']) ?>"
                                data-descricao="<?= strtolower($relatorio['descricao']) ?>"
                                data-categoria="<?= strtolower($categoria['nome']) ?>">
                                <div class="d-flex align-items-center">
                                    <div
                                        class="relatorio-item-icon bg-<?= $categoria['cor'] ?> bg-opacity-10 text-<?= $categoria['cor'] ?> me-3">
                                        <i class="bi <?= $relatorio['icone'] ?>"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1 relatorio-nome"><?= htmlspecialchars($relatorio['nome']) ?></h6>
                                        <p class="mb-0 text-muted small relatorio-descricao">
                                            <?= htmlspecialchars($relatorio['descricao']) ?>
                                        </p>
                                    </div>
                                    <i class="bi bi-arrow-right text-muted"></i>
                                </div>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<!-- Mensagem quando não há resultados -->
<div id="semResultados" class="alert alert-info text-center" style="display: none;">
    <i class="bi bi-info-circle fs-3 d-block mb-2"></i>
    <h5>Nenhum relatório encontrado</h5>
    <p class="mb-0">Tente buscar com outros termos ou <a href="#" id="mostrarTodos">mostrar todos os relatórios</a></p>
</div>

<script>
    $(document).ready(function () {
        const $busca = $('#buscaRelatorios');
        const $limparBusca = $('#limparBusca');
        const $semResultados = $('#semResultados');
        const $categorias = $('.categoria-card');

        // Função para destacar texto na busca
        function highlightText(text, query) {
            if (!query) return text;
            const regex = new RegExp(`(${query})`, 'gi');
            return text.replace(regex, '<span class="search-highlight">$1</span>');
        }

        // Função de busca
        function realizarBusca(query) {
            const termo = query.trim().toLowerCase();

            if (!termo) {
                // Mostrar todos
                $categorias.show();
                $categorias.find('.categoria-content').collapse('show');
                $categorias.find('.relatorio-item').show();
                $semResultados.hide();
                $limparBusca.hide();
                return;
            }

            $limparBusca.show();
            let totalEncontrados = 0;
            let categoriasComResultados = 0;

            $categorias.each(function () {
                const $categoria = $(this);
                const $itens = $categoria.find('.relatorio-item');
                let itensEncontrados = 0;

                $itens.each(function () {
                    const $item = $(this);
                    const nome = $item.data('nome') || '';
                    const descricao = $item.data('descricao') || '';
                    const categoria = $item.data('categoria') || '';

                    const match = nome.includes(termo) ||
                        descricao.includes(termo) ||
                        categoria.includes(termo);

                    if (match) {
                        $item.show();
                        itensEncontrados++;
                        totalEncontrados++;

                        // Destacar texto
                        const $nomeEl = $item.find('.relatorio-nome');
                        const $descEl = $item.find('.relatorio-descricao');
                        $nomeEl.html(highlightText($nomeEl.text(), termo));
                        $descEl.html(highlightText($descEl.text(), termo));
                    } else {
                        $item.hide();
                    }
                });

                if (itensEncontrados > 0) {
                    $categoria.show();
                    $categoria.find('.categoria-content').collapse('show');
                    categoriasComResultados++;
                } else {
                    $categoria.hide();
                }
            });

            if (totalEncontrados === 0) {
                $semResultados.show();
            } else {
                $semResultados.hide();
            }
        }

        // Event listeners
        $busca.on('input', function () {
            realizarBusca($(this).val());
        });

        $limparBusca.on('click', function () {
            $busca.val('');
            realizarBusca('');
            $busca.focus();
        });

        $('#mostrarTodos').on('click', function (e) {
            e.preventDefault();
            $busca.val('');
            realizarBusca('');
        });

        // Animar ícone de collapse
        $('.categoria-header').on('click', function () {
            const $icon = $(this).find('.collapse-icon');
            const $target = $($(this).data('bs-target'));

            setTimeout(() => {
                if ($target.hasClass('show')) {
                    $icon.removeClass('bi-chevron-down').addClass('bi-chevron-up');
                } else {
                    $icon.removeClass('bi-chevron-up').addClass('bi-chevron-down');
                }
            }, 100);
        });

        // Focar no campo de busca ao carregar
        $busca.focus();
    });
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'relatorios';
include ROOT_PATH . '/views/layouts/app.php';
?>