<?php
ob_start();

if (!function_exists('formatPercent')) {
    function formatPercent($value)
    {
        return number_format((float) $value, 2, ',', '.') . '%';
    }
}

// Preparar logo da empresa
$logoPath = null;
if (!empty($empresa)) {
    // Tentar logo do campo logo
    if (!empty($empresa['logo'])) {
        $logoPath = $empresa['logo'];
    }
    // Tentar logo por CNPJ
    $cnpjLimpo = preg_replace('/\D/', '', $empresa['cnpj'] ?? $empresa['document'] ?? '');
    if ($cnpjLimpo && file_exists(ROOT_PATH . '/storage/uploads/logos/' . $cnpjLimpo . '.jpg')) {
        $logoPath = 'storage/uploads/logos/' . $cnpjLimpo . '.jpg';
    }
    // Fallback para logo padrão
    if (!$logoPath && file_exists(ROOT_PATH . '/public/assets/images/logo.png')) {
        $logoPath = 'public/assets/images/logo.png';
    }
}

$empresaNome = $empresa['razao_social'] ?? $empresa['nome'] ?? $empresa['name'] ?? 'Empresa';
$empresaDoc = $empresa['cnpj'] ?? $empresa['document'] ?? '';
?>

<div class="row mb-4 no-print">
    <div class="col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/relatorios') ?>">Relatórios</a></li>
                <li class="breadcrumb-item active">Comissões por Vendedor</li>
            </ol>
        </nav>
        <div class="d-flex justify-content-between align-items-center">
            <h2 class="mb-0"><i class="bi bi-cash-coin me-2 text-danger"></i> Relatório de Comissões por Vendedor</h2>
            <a href="<?= url('/relatorios') ?>" class="btn btn-outline-secondary no-print">
                <i class="bi bi-arrow-left me-2"></i> Voltar
            </a>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4 no-print">
    <div class="card-header bg-danger text-white">
        <i class="bi bi-funnel me-2"></i> Filtros
    </div>
    <div class="card-body">
        <form method="GET" action="<?= url('/relatorios/comissoes-vendedor') ?>" class="row g-3">
            <div class="col-md-4">
                <label for="data_inicio" class="form-label">Data Início</label>
                <input type="date" class="form-control" id="data_inicio" name="data_inicio"
                    value="<?= htmlspecialchars($dataInicio ?? date('Y-m-01')) ?>" required>
            </div>
            <div class="col-md-4">
                <label for="data_fim" class="form-label">Data Fim</label>
                <input type="date" class="form-control" id="data_fim" name="data_fim"
                    value="<?= htmlspecialchars($dataFim ?? date('Y-m-t')) ?>" required>
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-danger me-2">
                    <i class="bi bi-search me-2"></i> Filtrar
                </button>
                <a href="<?= url('/relatorios/comissoes-vendedor') ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-clockwise me-2"></i> Limpar
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Resumo - Oculto na impressão -->
<?php if (!empty($totalComissao) && $totalComissao > 0): ?>
    <div class="row mb-4 no-print">
        <div class="col-md-4">
            <div class="card border-danger">
                <div class="card-body text-center">
                    <i class="bi bi-cash-stack fs-1 text-danger mb-2"></i>
                    <h3 class="mb-0">R$ <?= formatCurrency($totalComissao) ?></h3>
                    <small class="text-muted">Total de Comissões</small>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-info">
                <div class="card-body text-center">
                    <i class="bi bi-people fs-1 text-info mb-2"></i>
                    <h3 class="mb-0"><?= count($dados) ?></h3>
                    <small class="text-muted">Vendedores com Comissão</small>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-success">
                <div class="card-body text-center">
                    <i class="bi bi-cart-check fs-1 text-success mb-2"></i>
                    <h3 class="mb-0"><?= array_sum(array_column($dados, 'total_vendas')) ?></h3>
                    <small class="text-muted">Total de Vendas</small>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Cabeçalho de Impressão (só aparece na impressão) -->
<div class="print-header" style="display: none;">
    <div class="print-header-content">
        <div style="display: flex; align-items: center;">
            <?php if ($logoPath && file_exists(ROOT_PATH . '/' . $logoPath)): ?>
                <img src="<?= asset($logoPath) ?>" alt="Logo" class="print-logo">
            <?php endif; ?>
            <div class="print-empresa-info">
                <div class="print-empresa-nome"><?= strtoupper(htmlspecialchars($empresaNome)) ?></div>
                <?php if ($empresaDoc): ?>
                    <div class="print-empresa-doc">CNPJ: <?= htmlspecialchars($empresaDoc) ?></div>
                <?php endif; ?>
            </div>
        </div>
        <div class="print-relatorio-info">
            <div class="print-relatorio-titulo">Relatório de Comissões por Vendedor</div>
            <div class="print-relatorio-periodo">
                Período: <?= date('d/m/Y', strtotime($dataInicio)) ?> até <?= date('d/m/Y', strtotime($dataFim)) ?>
            </div>
        </div>
    </div>
</div>

<!-- Tabela de Resultados -->
<div class="card mb-4 resumo-card">
    <div class="card-header d-flex justify-content-between align-items-center bg-danger text-white no-print">
        <span><i class="bi bi-table me-2"></i> Resultados</span>
        <div>
            <button onclick="window.print()" class="btn btn-light btn-sm no-print">
                <i class="bi bi-printer me-2"></i> Imprimir
            </button>
            <span class="badge bg-light text-dark ms-2"><?= count($dados ?? []) ?> registro(s)</span>
        </div>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($dados)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th style="min-width: 200px;">Vendedor</th>
                            <th class="text-center" style="min-width: 80px;">Vendas</th>
                            <th class="text-center" style="min-width: 80px;">Itens</th>
                            <th class="text-end" style="min-width: 120px;">Valor Vendido</th>
                            <th class="text-end" style="min-width: 100px;">% Média</th>
                            <th class="text-end" style="min-width: 120px;">Comissão</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($dados as $item): ?>
                            <tr>
                                <td>
                                    <strong><?= htmlspecialchars($item['vendedor'] ?? 'Não informado') ?></strong>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-primary no-print"><?= (int) $item['total_vendas'] ?></span>
                                    <span class="print-only"><?= (int) $item['total_vendas'] ?></span>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-info no-print"><?= (int) $item['total_itens'] ?></span>
                                    <span class="print-only"><?= (int) $item['total_itens'] ?></span>
                                </td>
                                <td class="text-end">
                                    R$ <?= formatCurrency($item['total_vendido'] ?? 0) ?>
                                </td>
                                <td class="text-end">
                                    <?= formatPercent($item['media_percentual'] ?? 0) ?>
                                </td>
                                <td class="text-end">
                                    <strong class="text-danger">R$ <?= formatCurrency($item['total_comissao'] ?? 0) ?></strong>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot class="table-light">
                        <tr style="background-color: #f8f9fa !important;">
                            <th style="font-weight: bold; border-top: 2px solid #333 !important;">TOTAL</th>
                            <th class="text-center" style="font-weight: bold; border-top: 2px solid #333 !important;">
                                <span class="no-print"><?= array_sum(array_column($dados, 'total_vendas')) ?></span>
                                <span class="print-only"><?= array_sum(array_column($dados, 'total_vendas')) ?></span>
                            </th>
                            <th class="text-center" style="font-weight: bold; border-top: 2px solid #333 !important;">
                                <span class="no-print"><?= array_sum(array_column($dados, 'total_itens')) ?></span>
                                <span class="print-only"><?= array_sum(array_column($dados, 'total_itens')) ?></span>
                            </th>
                            <th class="text-end" style="font-weight: bold; border-top: 2px solid #333 !important;">
                                R$ <?= formatCurrency(array_sum(array_column($dados, 'total_vendido'))) ?>
                            </th>
                            <th style="border-top: 2px solid #333 !important;"></th>
                            <th class="text-end" style="font-weight: bold; border-top: 2px solid #333 !important;">
                                <strong class="text-danger">R$ <?= formatCurrency($totalComissao ?? 0) ?></strong>
                            </th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-inbox fs-1 text-muted d-block mb-3"></i>
                <p class="text-muted">Nenhuma comissão encontrada no período selecionado.</p>
                <p class="text-muted small">Tente ajustar os filtros de data.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Rodapé de Impressão -->
<div class="print-footer">
    <div>Impresso em <?= date('d/m/Y H:i:s') ?> - Systhema ERP</div>
</div>

<style>
    /* Cabeçalho de impressão - oculto na tela */
    .print-header {
        display: none;
    }

    .print-only {
        display: none;
    }

    .print-footer {
        display: none;
    }

    @media print {
        @page {
            size: A4;
            margin: 0cm 2.5cm 2cm 2.5cm;
            /* Topo sem margem - cabeçalho fixo ocupará esse espaço */
        }

        * {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }

        html {
            margin: 0 !important;
            padding: 0 !important;
            height: auto !important;
        }

        body {
            font-size: 9pt;
            line-height: 1.3;
            margin: 0 !important;
            padding: 0 !important;
            height: auto !important;
            position: relative !important;
            top: 0 !important;
        }

        /* Remover completamente espaço no topo */
        body {
            padding-top: 0 !important;
            margin-top: 0 !important;
        }

        /* Remover qualquer espaço do layout principal */
        body>main,
        body>main>.content-wrapper {
            margin: 0 !important;
            padding: 0 !important;
        }

        /* Forçar que o primeiro elemento visível comece no topo */
        .content-wrapper {
            padding-top: 0 !important;
            margin-top: 0 !important;
        }

        .content-wrapper::before {
            content: none !important;
            display: none !important;
        }

        /* Remover margens e paddings de containers */
        .container,
        .container-fluid,
        .row,
        .main-content,
        .content-wrapper,
        main,
        .sidebar,
        .topbar {
            margin: 0 !important;
            padding: 0 !important;
        }

        /* Garantir que o primeiro elemento visível não tenha margem superior */
        .content-wrapper>*:first-child,
        .content-wrapper>.print-header:first-child {
            margin-top: 0 !important;
            padding-top: 0 !important;
        }

        /* Remover espaçamento de elementos antes do print-header */
        .print-header {
            margin-top: 0 !important;
            padding-top: 0 !important;
            padding-bottom: 8px !important;
        }

        /* Garantir que não há espaço antes do primeiro elemento */
        body>*:first-child,
        .content-wrapper>*:first-child,
        .content-wrapper>.print-header:first-child,
        .print-header:first-of-type {
            margin-top: 0 !important;
            padding-top: 0 !important;
        }

        /* Remover qualquer espaço do topo da página */
        html {
            margin: 0 !important;
            padding: 0 !important;
        }

        /* Forçar que o primeiro elemento visível comece exatamente no topo */
        body {
            margin: 0 !important;
            padding: 0 !important;
        }

        .content-wrapper {
            margin: 0 !important;
            padding: 0 !important;
        }

        /* Primeiro elemento visível sem espaço - garantir que é o cabeçalho */
        .content-wrapper>*:first-child,
        .print-header:first-of-type {
            margin-top: 0 !important;
            padding-top: 0 !important;
            border-top: none !important;
            position: relative !important;
            top: 0 !important;
        }

        /* Remover margin-bottom de elementos antes do print-header */
        .no-print+.print-header,
        .card+.print-header {
            margin-top: 0 !important;
        }

        .no-print,
        .breadcrumb,
        .btn,
        form,
        .sidebar,
        .topbar,
        header,
        nav {
            display: none !important;
            margin: 0 !important;
            padding: 0 !important;
            height: 0 !important;
            min-height: 0 !important;
            max-height: 0 !important;
            overflow: hidden !important;
            visibility: hidden !important;
            opacity: 0 !important;
            position: absolute !important;
            left: -9999px !important;
            width: 0 !important;
            max-width: 0 !important;
        }

        /* Garantir que elementos no-print não deixem espaços */
        .row.no-print,
        .card.no-print,
        .no-print.card,
        .no-print.row,
        div.no-print {
            display: none !important;
            margin: 0 !important;
            padding: 0 !important;
            height: 0 !important;
            min-height: 0 !important;
            max-height: 0 !important;
            line-height: 0 !important;
            font-size: 0 !important;
            overflow: hidden !important;
            visibility: hidden !important;
            opacity: 0 !important;
            position: absolute !important;
            left: -9999px !important;
            width: 0 !important;
            max-width: 0 !important;
            border: none !important;
            box-shadow: none !important;
        }

        /* Mostrar rodapé na impressão - fixo no rodapé de todas as páginas */
        .print-footer {
            display: block !important;
            margin: 0 !important;
            padding: 10px 0 !important;
            border-top: 1px solid #ddd !important;
            font-size: 8pt !important;
            color: #666 !important;
            text-align: center !important;
            position: fixed !important;
            bottom: 0 !important;
            left: 0 !important;
            right: 0 !important;
            width: 98% !important;
            max-width: 98% !important;
            margin-left: auto !important;
            margin-right: auto !important;
            background-color: white !important;
            z-index: 999 !important;
            page-break-inside: avoid !important;
            height: auto !important;
            min-height: 30px !important;
        }

        /* Ocultar rodapé que está dentro do cabeçalho */
        .print-header .print-footer,
        .print-header-content .print-footer,
        .print-header~.print-footer:first-of-type {
            display: none !important;
        }

        /* Rodapé deve aparecer apenas após o conteúdo principal */
        .resumo-card+.print-footer,
        .resumo-card~.print-footer {
            display: block !important;
        }

        /* Mostrar elementos print-only na impressão */
        .print-only {
            display: block !important;
        }

        /* Ocultar badges na impressão, mostrar apenas números */
        .badge {
            background: transparent !important;
            color: #000 !important;
            padding: 0 !important;
            border: none !important;
            font-weight: normal !important;
        }

        /* Remover qualquer espaço antes do primeiro elemento visível */
        .content-wrapper>.no-print {
            display: none !important;
            margin: 0 !important;
            padding: 0 !important;
            height: 0 !important;
        }

        /* Garantir que o print-header seja o primeiro elemento sem espaço acima */
        .content-wrapper>.print-header:first-child,
        .content-wrapper>*:first-child.print-header {
            margin-top: 0 !important;
            padding-top: 0 !important;
        }

        /* Cabeçalho de impressão - sempre mostrar na impressão e colocar no topo absoluto - usar 98% da largura */
        /* Usar position fixed para aparecer em todas as páginas */
        .print-header {
            display: block !important;
            border-bottom: 2px solid #333;
            padding: 8px 0 8px 0 !important;
            margin: 0 !important;
            page-break-after: avoid;
            page-break-inside: avoid;
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            right: 0 !important;
            width: 98% !important;
            max-width: 98% !important;
            margin-left: auto !important;
            margin-right: auto !important;
            background-color: white !important;
            z-index: 1000 !important;
            height: auto !important;
            min-height: 60px !important;
        }

        /* Adicionar espaço no topo do conteúdo para não ficar atrás do cabeçalho fixo */
        /* E espaço no rodapé para não ficar atrás do rodapé fixo */
        .resumo-card {
            margin-top: 70px !important;
            padding-top: 10px !important;
            margin-bottom: 50px !important;
            padding-bottom: 10px !important;
        }

        .print-header~.resumo-card {
            margin-top: 70px !important;
            padding-top: 10px !important;
            margin-bottom: 50px !important;
            padding-bottom: 10px !important;
        }

        /* Garantir que não há espaço antes do cabeçalho - ABSOLUTO TOPO */
        body>*:first-child,
        .content-wrapper>*:first-child,
        .content-wrapper>.print-header:first-child,
        .print-header:first-of-type {
            margin-top: 0 !important;
            padding-top: 0 !important;
            position: relative !important;
            top: 0 !important;
        }

        /* O primeiro elemento visível deve ser o cabeçalho */
        body>*:first-child:not(.no-print),
        .content-wrapper>*:first-child:not(.no-print) {
            margin-top: 0 !important;
            padding-top: 0 !important;
        }

        .print-header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: relative;
            width: 100% !important;
            max-width: 100% !important;
        }

        .print-logo {
            max-width: 120px;
            max-height: 50px;
            object-fit: contain;
        }

        .print-empresa-info {
            flex: 1;
            margin-left: 15px;
        }

        .print-empresa-nome {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 2px;
        }

        .print-empresa-doc {
            font-size: 8pt;
            color: #666;
        }

        .print-relatorio-info {
            text-align: right;
        }

        .print-relatorio-titulo {
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 3px;
        }

        .print-relatorio-periodo {
            font-size: 9pt;
            color: #666;
        }

        .card {
            border: 1px solid #ddd !important;
            page-break-inside: avoid;
            box-shadow: none !important;
        }

        .card-header {
            background-color: #f8f9fa !important;
            border-bottom: 2px solid #ddd !important;
            padding: 8px 12px !important;
        }

        .no-print {
            display: none !important;
        }

        /* Usar 98% da largura para evitar cortes na impressão */
        .table-responsive {
            width: 98% !important;
            margin: 0 auto !important;
            overflow: visible !important;
        }

        /* Evitar quebra de texto nas colunas - usar 98% para evitar cortes */
        table {
            width: 98% !important;
            border-collapse: collapse !important;
            font-size: 8pt;
            table-layout: auto;
            margin: 0 auto !important;
        }

        /* Garantir que tabelas dentro de cards usem 98% */
        .card-body table,
        .resumo-card table {
            width: 98% !important;
            margin: 0 auto !important;
        }

        th,
        td {
            padding: 6px 8px !important;
            border: 1px solid #ddd !important;
            vertical-align: middle;
            word-wrap: break-word;
        }

        th {
            background-color: #f8f9fa !important;
            font-weight: bold;
            text-align: center;
            white-space: nowrap;
        }

        /* Evitar quebra em colunas numéricas e códigos */
        td.text-end,
        td.text-center,
        th.text-end,
        th.text-center {
            white-space: nowrap !important;
        }

        /* Primeira coluna (nomes) - pode quebrar se necessário mas com limite */
        td:first-child,
        th:first-child {
            max-width: 250px;
            white-space: normal;
            word-break: break-word;
        }

        /* Colunas numéricas alinhadas à direita */
        .text-end {
            text-align: right !important;
        }

        .text-center {
            text-align: center !important;
        }

        .table-bordered {
            border-collapse: collapse !important;
        }

        .table-bordered th,
        .table-bordered td {
            border: 1px solid #ddd !important;
        }

        /* Evitar quebra de página dentro de linhas */
        tr {
            page-break-inside: avoid;
        }

        /* Melhorar visual da linha TOTAL */
        tfoot tr {
            background-color: #f8f9fa !important;
        }

        tfoot th {
            border-top: 2px solid #333 !important;
            font-weight: bold !important;
        }
    }
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'relatorios';
include ROOT_PATH . '/views/layouts/app.php';
?>