<?php
ob_start();

if (!function_exists('formatPercent')) {
    function formatPercent($value)
    {
        return number_format((float) $value, 2, ',', '.') . '%';
    }
}

// Preparar logo da empresa
$logoPath = null;
if (!empty($empresa)) {
    // Tentar logo do campo logo
    if (!empty($empresa['logo'])) {
        $logoPath = $empresa['logo'];
    }
    // Tentar logo por CNPJ
    $cnpjLimpo = preg_replace('/\D/', '', $empresa['cnpj'] ?? $empresa['document'] ?? '');
    if ($cnpjLimpo && file_exists(ROOT_PATH . '/storage/uploads/logos/' . $cnpjLimpo . '.jpg')) {
        $logoPath = 'storage/uploads/logos/' . $cnpjLimpo . '.jpg';
    }
    // Fallback para logo padrão
    if (!$logoPath && file_exists(ROOT_PATH . '/storage/uploads/logo.png')) {
        $logoPath = 'storage/uploads/logo.png';
    }
}

$empresaNome = $empresa['razao_social'] ?? $empresa['nome'] ?? $empresa['name'] ?? 'Empresa';
$empresaDoc = $empresa['cnpj'] ?? $empresa['document'] ?? '';


// Preparar dados detalhados para impressão - agrupar por profissional e venda
$itensPorProfissionalVenda = [];
if (!empty($dadosDetalhados)) {
    foreach ($dadosDetalhados as $item) {
        $profId = $item['profissional_id'] ?? 'sem_profissional';
        $profNome = $item['profissional_nome'] ?? 'Não informado';
        $vendaKey = $item['venda_id'];

        // Chave única: profissional + venda
        $key = $profId . '_' . $vendaKey;

        if (!isset($itensPorProfissionalVenda[$key])) {
            $itensPorProfissionalVenda[$key] = [
                'profissional_id' => $profId,
                'profissional_nome' => $profNome,
                'venda_id' => $item['venda_id'],
                'venda_numero' => $item['venda_numero'],
                'venda_data' => $item['venda_data'],
                'itens' => []
            ];
        }
        $itensPorProfissionalVenda[$key]['itens'][] = $item;
    }
}
?>

<div class="row mb-4 no-print">
    <div class="col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/relatorios') ?>">Relatórios</a></li>
                <li class="breadcrumb-item active">Comissões por Profissional</li>
            </ol>
        </nav>
        <div class="d-flex justify-content-between align-items-center">
            <h2 class="mb-0"><i class="bi bi-person-workspace me-2 text-danger"></i> Relatório de Comissões por
                Profissional</h2>
            <a href="<?= url('/relatorios') ?>" class="btn btn-outline-secondary no-print">
                <i class="bi bi-arrow-left me-2"></i> Voltar
            </a>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4 no-print">
    <div class="card-header bg-danger text-white">
        <i class="bi bi-funnel me-2"></i> Filtros
    </div>
    <div class="card-body">
        <form method="GET" action="<?= url('/relatorios/comissoes-profissional') ?>" class="row g-3">
            <div class="col-md-3">
                <label for="data_inicio" class="form-label">Data Início</label>
                <input type="date" class="form-control" id="data_inicio" name="data_inicio"
                    value="<?= htmlspecialchars($dataInicio ?? date('Y-m-01')) ?>" required>
            </div>
            <div class="col-md-3">
                <label for="data_fim" class="form-label">Data Fim</label>
                <input type="date" class="form-control" id="data_fim" name="data_fim"
                    value="<?= htmlspecialchars($dataFim ?? date('Y-m-t')) ?>" required>
            </div>
            <div class="col-md-4">
                <label for="profissional_id" class="form-label">Profissional</label>
                <select class="form-select" id="profissional_id" name="profissional_id">
                    <option value="">Todos os profissionais</option>
                    <?php foreach ($profissionais ?? [] as $prof): ?>
                        <option value="<?= $prof['id'] ?>" <?= ($profissionalId ?? null) == $prof['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($prof['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-danger w-100">
                    <i class="bi bi-search me-2"></i> Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Cabeçalho de Impressão Resumo (só aparece na impressão) -->
<div class="print-header resumo-print-header" style="display: none;">
    <div class="print-header-content">
        <div style="display: flex; align-items: center;">
            <?php if ($logoPath && file_exists(ROOT_PATH . '/' . $logoPath)): ?>
                <img src="<?= asset($logoPath) ?>" alt="Logo" class="print-logo">
            <?php endif; ?>
            <div class="print-empresa-info">
                <div class="print-empresa-nome"><?= strtoupper(htmlspecialchars($empresaNome)) ?></div>
                <?php if ($empresaDoc): ?>
                    <div class="print-empresa-doc">CNPJ: <?= htmlspecialchars($empresaDoc) ?></div>
                <?php endif; ?>
            </div>
        </div>
        <div class="print-relatorio-info">
            <div class="print-relatorio-titulo">Relatório de Comissões por Profissional</div>
            <div class="print-relatorio-periodo">
                Período: <?= date('d/m/Y', strtotime($dataInicio)) ?> até <?= date('d/m/Y', strtotime($dataFim)) ?>
                <?php if (!empty($profissionalId) && !empty($dados[0]['profissional'])): ?>
                    <br>Profissional: <?= htmlspecialchars($dados[0]['profissional']) ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Tabela de Resultados (Sempre visível na tela) -->
<div class="card mb-4 resumo-card">
    <div class="card-header d-flex justify-content-between align-items-center bg-danger text-white no-print">
        <span><i class="bi bi-table me-2"></i>
            <?= !empty($profissionalId) ? 'Resumo - ' . htmlspecialchars($dados[0]['profissional'] ?? 'Profissional') : 'Resumo por Profissional' ?></span>
        <div>
            <button onclick="window.print()" class="btn btn-light btn-sm no-print">
                <i class="bi bi-printer me-2"></i> Imprimir
            </button>
            <button onclick="imprimirDetalhado()" class="btn btn-outline-light btn-sm no-print"
                id="btnImprimirDetalhado">
                <i class="bi bi-file-text me-2"></i> Imprimir Detalhado
            </button>
            <span class="badge bg-light text-dark ms-2"><?= count($dados ?? []) ?> registro(s)</span>
        </div>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($dados)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th style="min-width: 200px;">Profissional</th>
                            <th class="text-center" style="min-width: 80px;">Vendas</th>
                            <th class="text-center" style="min-width: 80px;">Itens</th>
                            <th class="text-end" style="min-width: 120px;">Valor Vendido</th>
                            <th class="text-end" style="min-width: 100px;">% Média</th>
                            <th class="text-end" style="min-width: 120px;">Comissão</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($dados as $item): ?>
                            <tr>
                                <td>
                                    <strong><?= htmlspecialchars($item['profissional'] ?? 'Não informado') ?></strong>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-primary no-print"><?= (int) $item['total_vendas'] ?></span>
                                    <span class="print-only"><?= (int) $item['total_vendas'] ?></span>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-info no-print"><?= (int) $item['total_itens'] ?></span>
                                    <span class="print-only"><?= (int) $item['total_itens'] ?></span>
                                </td>
                                <td class="text-end">
                                    R$ <?= formatCurrency($item['total_vendido'] ?? 0) ?>
                                </td>
                                <td class="text-end">
                                    <?= formatPercent($item['media_percentual'] ?? 0) ?>
                                </td>
                                <td class="text-end">
                                    <strong class="text-danger">R$ <?= formatCurrency($item['total_comissao'] ?? 0) ?></strong>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot class="table-light">
                        <tr style="background-color: #f8f9fa !important;">
                            <th style="font-weight: bold; border-top: 2px solid #333 !important;">TOTAL</th>
                            <th class="text-center" style="font-weight: bold; border-top: 2px solid #333 !important;">
                                <?= array_sum(array_column($dados, 'total_vendas')) ?>
                            </th>
                            <th class="text-center" style="font-weight: bold; border-top: 2px solid #333 !important;">
                                <?= array_sum(array_column($dados, 'total_itens')) ?>
                            </th>
                            <th class="text-end" style="font-weight: bold; border-top: 2px solid #333 !important;">R$
                                <?= formatCurrency(array_sum(array_column($dados, 'total_vendido'))) ?>
                            </th>
                            <th style="border-top: 2px solid #333 !important;"></th>
                            <th class="text-end" style="font-weight: bold; border-top: 2px solid #333 !important;">
                                <strong class="text-danger">R$ <?= formatCurrency($totalComissao ?? 0) ?></strong>
                            </th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-inbox fs-1 text-muted d-block mb-3"></i>
                <p class="text-muted">Nenhuma comissão encontrada no período selecionado.</p>
                <p class="text-muted small">Tente ajustar os filtros de data.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Rodapé de Impressão -->
<div class="print-footer">
    <div>Impresso em <?= date('d/m/Y H:i:s') ?> - Systhema ERP</div>
</div>

<!-- Versão Detalhada (Só aparece na impressão detalhada) -->
<?php if (!empty($itensPorProfissionalVenda)):
    // Agrupar por profissional para facilitar a exibição
    $porProfissional = [];
    foreach ($itensPorProfissionalVenda as $item) {
        $profId = $item['profissional_id'];
        if (!isset($porProfissional[$profId])) {
            $porProfissional[$profId] = [
                'profissional_nome' => $item['profissional_nome'],
                'vendas' => []
            ];
        }
        $porProfissional[$profId]['vendas'][] = $item;
    }
    ?>
    <div class="detalhado-card" style="display: none;">
        <!-- Cabeçalho de Impressão Detalhada -->
        <div class="print-header">
            <div class="print-header-content">
                <div style="display: flex; align-items: center;">
                    <?php if ($logoPath && file_exists(ROOT_PATH . '/' . $logoPath)): ?>
                        <img src="<?= asset($logoPath) ?>" alt="Logo" class="print-logo">
                    <?php endif; ?>
                    <div class="print-empresa-info">
                        <div class="print-empresa-nome"><?= strtoupper(htmlspecialchars($empresaNome)) ?></div>
                        <?php if ($empresaDoc): ?>
                            <div class="print-empresa-doc">CNPJ: <?= htmlspecialchars($empresaDoc) ?></div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="print-relatorio-info">
                    <div class="print-relatorio-titulo">Detalhamento de Comissões por Profissional</div>
                    <div class="print-relatorio-periodo">
                        Período: <?= date('d/m/Y', strtotime($dataInicio)) ?> até <?= date('d/m/Y', strtotime($dataFim)) ?>
                        <?php if (!empty($profissionalId) && !empty($dados[0]['profissional'])): ?>
                            <br>Profissional: <?= htmlspecialchars($dados[0]['profissional']) ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <!-- Não colocar rodapé aqui - apenas após o conteúdo -->
        </div>

        <!-- Conteúdo detalhado (visível na impressão) -->
        <div class="detalhado-content">
            <?php
            $totalGeralComissao = 0;
            $firstProfissional = true;
            foreach ($porProfissional as $profId => $profData):
                $totalProfissionalComissao = 0;
                ?>
                <!-- Seção do profissional (uma página por profissional) -->
                <div class="profissional-section <?= $firstProfissional ? 'first-profissional' : '' ?>">
                    <!-- Título do profissional para impressão -->
                    <div class="print-profissional-title"
                        style="font-weight: bold; font-size: 11pt; margin: 15px 0 10px 0; padding-bottom: 5px; border-bottom: 1px solid #ddd;">
                        <?= htmlspecialchars($profData['profissional_nome']) ?>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-bordered mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th style="min-width: 100px;">Venda</th>
                                    <th style="min-width: 90px;">Data</th>
                                    <th style="min-width: 200px;">Produto</th>
                                    <th style="min-width: 100px;">SKU</th>
                                    <th class="text-center" style="min-width: 70px;">Qtd</th>
                                    <th class="text-end" style="min-width: 100px;">Vlr. Unit.</th>
                                    <th class="text-end" style="min-width: 100px;">Total</th>
                                    <th class="text-end" style="min-width: 70px;">%</th>
                                    <th class="text-end" style="min-width: 100px;">Comissão</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($profData['vendas'] as $venda):
                                    $totalVenda = 0;
                                    $totalComissaoVenda = 0;
                                    foreach ($venda['itens'] as $item) {
                                        $totalVenda += (float) $item['total_price'];
                                        $totalComissaoVenda += (float) $item['comissao'];
                                        $totalProfissionalComissao += (float) $item['comissao'];
                                        $totalGeralComissao += (float) $item['comissao'];
                                    }
                                    $rowspan = count($venda['itens']);
                                    ?>
                                    <?php foreach ($venda['itens'] as $idx => $item): ?>
                                        <tr>
                                            <?php if ($idx === 0): ?>
                                                <td rowspan="<?= $rowspan ?>" class="align-middle">
                                                    <strong><?= htmlspecialchars($item['venda_numero']) ?></strong>
                                                </td>
                                                <td rowspan="<?= $rowspan ?>" class="align-middle">
                                                    <?= date('d/m/Y', strtotime($item['venda_data'])) ?>
                                                </td>
                                            <?php endif; ?>
                                            <td><?= htmlspecialchars($item['product_name']) ?></td>
                                            <td>
                                                <span
                                                    class="badge bg-secondary"><?= htmlspecialchars($item['product_sku'] ?? '-') ?></span>
                                            </td>
                                            <td class="text-center"><?= number_format((float) $item['quantity'], 2, ',', '.') ?></td>
                                            <td class="text-end">R$ <?= formatCurrency($item['unit_price']) ?></td>
                                            <td class="text-end">R$ <?= formatCurrency($item['total_price']) ?></td>
                                            <td class="text-end"><?= formatPercent($item['comissao_percentual'] ?? 0) ?></td>
                                            <td class="text-end">
                                                <strong class="text-danger">R$ <?= formatCurrency($item['comissao'] ?? 0) ?></strong>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                    <tr class="table-secondary">
                                        <td colspan="7" class="text-end"><strong>Subtotal Venda: R$
                                                <?= formatCurrency($totalVenda) ?></strong></td>
                                        <td class="text-end"></td>
                                        <td class="text-end"><strong class="text-danger">R$
                                                <?= formatCurrency($totalComissaoVenda) ?></strong></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot class="table-light">
                                <tr>
                                    <th colspan="7" class="text-end">TOTAL</th>
                                    <th class="text-end"></th>
                                    <th class="text-end">
                                        <strong class="text-danger">R$
                                            <?= formatCurrency($totalProfissionalComissao) ?></strong>
                                    </th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div> <!-- Fim da seção do profissional -->
                <?php
                $firstProfissional = false;
            endforeach; ?>
            <?php if (count($porProfissional) > 1): ?>
                <div class="p-3 bg-light">
                    <table class="table table-bordered mb-0">
                        <tfoot class="table-light">
                            <tr>
                                <th colspan="7" class="text-end">TOTAL GERAL</th>
                                <th class="text-end"></th>
                                <th class="text-end">
                                    <strong class="text-danger">R$ <?= formatCurrency($totalGeralComissao) ?></strong>
                                </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            <?php endif; ?>
        </div>

        <!-- Rodapé de Impressão Detalhada -->
        <div class="print-footer">
            <div>Impresso em <?= date('d/m/Y H:i:s') ?> - Systhema ERP</div>
        </div>
    </div>
<?php endif; ?>

<script>
    // Função para imprimir versão detalhada
    function imprimirDetalhado() {
        // Verificar se existe conteúdo detalhado
        var detalhadoCard = $('.detalhado-card');
        if (detalhadoCard.length === 0 || detalhadoCard.is(':empty') || detalhadoCard.find('table').length === 0) {
            if (typeof Swal !== 'undefined') {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Não há dados detalhados para imprimir. Filtre os dados primeiro.'
                });
            } else {
                alert('Não há dados detalhados para imprimir. Filtre os dados primeiro.');
            }
            return;
        }

        // Adicionar classe ao body para identificar que é impressão detalhada
        $('body').addClass('imprimindo-detalhado');
        // Esconder resumo
        $('.resumo-card').addClass('ocultar-impressao-detalhada');
        // Mostrar versão detalhada
        $('.detalhado-card').show();
        // Aguardar um pouco para o DOM atualizar
        setTimeout(function () {
            window.print();
            // Restaurar após impressão
            setTimeout(function () {
                $('body').removeClass('imprimindo-detalhado');
                $('.resumo-card').removeClass('ocultar-impressao-detalhada');
                $('.detalhado-card').hide();
            }, 500);
        }, 100);
    }
</script>

<style>
    .ocultar-impressao-detalhada {
        display: none !important;
    }

    .detalhado-card {
        display: none;
    }

    /* Cabeçalho de impressão - oculto na tela */
    .print-header {
        display: none;
    }

    .resumo-print-header {
        display: none;
    }

    .print-only {
        display: none;
    }

    .print-footer {
        display: none;
    }

    /* Na impressão, sempre mostrar rodapé */
    @media print {
        .print-footer {
            display: block !important;
            margin-top: 20px !important;
            padding-top: 10px !important;
            border-top: 1px solid #ddd !important;
            font-size: 8pt !important;
            color: #666 !important;
            text-align: center !important;
            page-break-inside: avoid !important;
        }
    }

    @media print {
        @page {
            size: A4;
            margin: 0cm 2.5cm 2cm 2.5cm;
            /* Topo sem margem - cabeçalho fixo ocupará esse espaço */
        }

        * {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }

        html {
            margin: 0 !important;
            padding: 0 !important;
            height: auto !important;
        }

        body {
            font-size: 9pt;
            line-height: 1.3;
            margin: 0 !important;
            padding: 0 !important;
            height: auto !important;
            position: relative !important;
            top: 0 !important;
        }

        /* Remover completamente espaço no topo */
        body {
            padding-top: 0 !important;
            margin-top: 0 !important;
        }

        /* Remover qualquer espaço do layout principal */
        body>main,
        body>main>.content-wrapper {
            margin: 0 !important;
            padding: 0 !important;
        }

        /* Forçar que o primeiro elemento visível comece no topo */
        .content-wrapper {
            padding-top: 0 !important;
            margin-top: 0 !important;
        }

        .content-wrapper::before {
            content: none !important;
            display: none !important;
        }

        /* Remover margens e paddings de containers */
        .container,
        .container-fluid,
        .row,
        .main-content,
        .content-wrapper,
        main,
        .sidebar,
        .topbar {
            margin: 0 !important;
            padding: 0 !important;
        }

        /* Garantir que o primeiro elemento visível não tenha margem superior */
        .content-wrapper>*:first-child,
        .content-wrapper>.print-header:first-child {
            margin-top: 0 !important;
            padding-top: 0 !important;
        }

        /* Remover espaçamento de elementos antes do print-header */
        .print-header {
            margin-top: 0 !important;
            padding-top: 0 !important;
            padding-bottom: 8px !important;
        }

        /* Garantir que não há espaço antes do primeiro elemento */
        body>*:first-child,
        .content-wrapper>*:first-child,
        .content-wrapper>.print-header:first-child,
        .print-header:first-of-type {
            margin-top: 0 !important;
            padding-top: 0 !important;
        }

        /* Remover qualquer espaço do topo da página */
        html {
            margin: 0 !important;
            padding: 0 !important;
        }

        /* Forçar que o primeiro elemento visível comece exatamente no topo */
        body {
            margin: 0 !important;
            padding: 0 !important;
        }

        .content-wrapper {
            margin: 0 !important;
            padding: 0 !important;
        }

        /* Primeiro elemento visível sem espaço - garantir que é o cabeçalho */
        .content-wrapper>*:first-child,
        .print-header:first-of-type,
        .detalhado-card>.print-header:first-child {
            margin-top: 0 !important;
            padding-top: 0 !important;
            border-top: none !important;
            position: relative !important;
            top: 0 !important;
        }

        /* Quando imprimindo detalhado, garantir que o cabeçalho detalhado está no topo e fixo */
        body.imprimindo-detalhado .detalhado-card>.print-header:first-child {
            margin-top: 0 !important;
            padding-top: 8px !important;
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            right: 0 !important;
            width: 98% !important;
            max-width: 98% !important;
            margin-left: auto !important;
            margin-right: auto !important;
            background-color: white !important;
            z-index: 1000 !important;
        }

        /* Remover margin-bottom de elementos antes do print-header */
        .no-print+.print-header,
        .card+.print-header {
            margin-top: 0 !important;
        }

        .no-print,
        .breadcrumb,
        .btn,
        form,
        .sidebar,
        .topbar,
        header,
        nav {
            display: none !important;
            margin: 0 !important;
            padding: 0 !important;
            height: 0 !important;
            min-height: 0 !important;
            max-height: 0 !important;
            overflow: hidden !important;
            visibility: hidden !important;
            opacity: 0 !important;
            position: absolute !important;
            left: -9999px !important;
            width: 0 !important;
            max-width: 0 !important;
        }

        /* Garantir que elementos no-print não deixem espaços */
        .row.no-print,
        .card.no-print,
        .no-print.card,
        .no-print.row,
        div.no-print {
            display: none !important;
            margin: 0 !important;
            padding: 0 !important;
            height: 0 !important;
            min-height: 0 !important;
            max-height: 0 !important;
            line-height: 0 !important;
            font-size: 0 !important;
            overflow: hidden !important;
            visibility: hidden !important;
            opacity: 0 !important;
            position: absolute !important;
            left: -9999px !important;
            width: 0 !important;
            max-width: 0 !important;
            border: none !important;
            box-shadow: none !important;
        }

        /* Mostrar rodapé na impressão - fixo no rodapé de todas as páginas */
        .print-footer {
            display: block !important;
            margin: 0 !important;
            padding: 10px 0 !important;
            border-top: 1px solid #ddd !important;
            font-size: 8pt !important;
            color: #666 !important;
            text-align: center !important;
            position: fixed !important;
            bottom: 0 !important;
            left: 0 !important;
            right: 0 !important;
            width: 98% !important;
            max-width: 98% !important;
            margin-left: auto !important;
            margin-right: auto !important;
            background-color: white !important;
            z-index: 999 !important;
            page-break-inside: avoid !important;
            height: auto !important;
            min-height: 30px !important;
        }

        /* Ocultar rodapé que está dentro do cabeçalho */
        .print-header .print-footer,
        .print-header-content .print-footer,
        .print-header~.print-footer:first-of-type {
            display: none !important;
        }

        /* Garantir que rodapé apareça apenas após o conteúdo */
        .detalhado-content~.print-footer,
        .detalhado-card>.print-footer:last-child,
        body.imprimindo-detalhado .detalhado-card>.print-footer:last-child {
            display: block !important;
        }

        /* Rodapé deve aparecer apenas após o conteúdo principal */
        /* Impressão normal (resumo) */
        .resumo-card+.print-footer,
        .resumo-card~.print-footer:not(.detalhado-card .print-footer) {
            display: block !important;
            margin-top: 30px !important;
        }

        /* Impressão detalhada - rodapé após o detalhado-content */
        body.imprimindo-detalhado .detalhado-content~.print-footer,
        body.imprimindo-detalhado .detalhado-card>.print-footer:last-child {
            display: block !important;
            margin-top: 30px !important;
        }

        /* Ocultar rodapé do resumo quando imprimindo detalhado */
        body.imprimindo-detalhado .resumo-card+.print-footer,
        body.imprimindo-detalhado .resumo-card~.print-footer {
            display: none !important;
        }

        /* Mostrar elementos print-only na impressão */
        .print-only {
            display: block !important;
        }

        .print-profissional-title {
            display: block !important;
        }

        /* Ocultar badges na impressão, mostrar apenas números */
        .badge {
            background: transparent !important;
            color: #000 !important;
            padding: 0 !important;
            border: none !important;
            font-weight: normal !important;
        }

        /* Remover qualquer espaço antes do primeiro elemento visível */
        .content-wrapper>.no-print {
            display: none !important;
            margin: 0 !important;
            padding: 0 !important;
            height: 0 !important;
        }

        /* Garantir que o print-header seja o primeiro elemento sem espaço acima */
        .content-wrapper>.print-header:first-child,
        .content-wrapper>*:first-child.print-header {
            margin-top: 0 !important;
            padding-top: 0 !important;
        }

        /* Cabeçalho de impressão - sempre mostrar na impressão e colocar no topo absoluto - usar 98% da largura */
        /* Usar position fixed para aparecer em todas as páginas */
        .print-header {
            display: block !important;
            border-bottom: 2px solid #333;
            padding: 8px 0 8px 0 !important;
            margin: 0 !important;
            page-break-after: avoid;
            page-break-inside: avoid;
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            right: 0 !important;
            width: 98% !important;
            max-width: 98% !important;
            margin-left: auto !important;
            margin-right: auto !important;
            background-color: white !important;
            z-index: 1000 !important;
            height: auto !important;
            min-height: 60px !important;
        }

        /* Adicionar espaço no topo do conteúdo para não ficar atrás do cabeçalho fixo */
        /* E espaço no rodapé para não ficar atrás do rodapé fixo */
        .detalhado-content {
            margin-top: 70px !important;
            padding-top: 10px !important;
            margin-bottom: 50px !important;
            padding-bottom: 10px !important;
        }

        body.imprimindo-detalhado .detalhado-content {
            margin-top: 70px !important;
            padding-top: 10px !important;
            margin-bottom: 50px !important;
            padding-bottom: 10px !important;
        }

        .resumo-card {
            margin-top: 70px !important;
            padding-top: 10px !important;
            margin-bottom: 50px !important;
            padding-bottom: 10px !important;
        }

        /* Para impressão resumo também */
        .resumo-print-header~.resumo-card {
            margin-top: 70px !important;
            padding-top: 10px !important;
            margin-bottom: 50px !important;
            padding-bottom: 10px !important;
        }

        /* Garantir que não há espaço antes do cabeçalho - ABSOLUTO TOPO */
        body>*:first-child,
        .content-wrapper>*:first-child,
        .content-wrapper>.print-header:first-child,
        .print-header:first-of-type,
        .detalhado-card>.print-header:first-child,
        .resumo-print-header:first-of-type {
            margin-top: 0 !important;
            padding-top: 0 !important;
            position: relative !important;
            top: 0 !important;
        }

        /* O primeiro elemento visível deve ser o cabeçalho */
        body>*:first-child:not(.no-print),
        .content-wrapper>*:first-child:not(.no-print) {
            margin-top: 0 !important;
            padding-top: 0 !important;
        }

        .resumo-print-header {
            display: block !important;
        }

        /* Ocultar cabeçalho do resumo quando imprimindo detalhado */
        body.imprimindo-detalhado .resumo-print-header {
            display: none !important;
        }

        /* Mostrar cabeçalho do detalhado apenas quando imprimindo detalhado */
        /* Garantir que o cabeçalho detalhado também fique fixo em todas as páginas */
        body.imprimindo-detalhado .detalhado-card .print-header {
            display: block !important;
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            right: 0 !important;
            width: 98% !important;
            max-width: 98% !important;
            margin-left: auto !important;
            margin-right: auto !important;
            background-color: white !important;
            z-index: 1000 !important;
            border-bottom: 2px solid #333 !important;
            padding: 8px 0 8px 0 !important;
            margin: 0 !important;
            page-break-after: avoid !important;
            page-break-inside: avoid !important;
        }

        .print-header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: relative;
            width: 100% !important;
            max-width: 100% !important;
        }

        /* Ocultar qualquer rodapé dentro do cabeçalho */
        .print-header .print-footer,
        .print-header-content .print-footer,
        .print-header~.print-footer:first-of-type,
        .detalhado-card>.print-header~.print-footer {
            display: none !important;
        }

        .print-logo {
            max-width: 120px;
            max-height: 50px;
            object-fit: contain;
        }

        .print-empresa-info {
            flex: 1;
            margin-left: 15px;
        }

        .print-empresa-nome {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 2px;
        }

        .print-empresa-doc {
            font-size: 8pt;
            color: #666;
        }

        .print-relatorio-info {
            text-align: right;
        }

        .print-relatorio-titulo {
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 3px;
        }

        .print-relatorio-periodo {
            font-size: 9pt;
            color: #666;
        }

        /* Por padrão, ocultar detalhado */
        .detalhado-card {
            display: none !important;
        }

        /* Mostrar conteúdo detalhado quando imprimindo detalhado */
        body.imprimindo-detalhado .detalhado-content {
            display: block !important;
        }

        /* Ocultar resumo quando tiver classe ocultar-impressao-detalhada */
        .ocultar-impressao-detalhada {
            display: none !important;
        }

        .card {
            border: 1px solid #ddd !important;
            page-break-inside: avoid;
            box-shadow: none !important;
        }

        .card-header {
            background-color: #f8f9fa !important;
            border-bottom: 2px solid #ddd !important;
            padding: 8px 12px !important;
        }

        .no-print {
            display: none !important;
        }

        /* Usar 98% da largura para evitar cortes na impressão */
        .table-responsive {
            width: 98% !important;
            margin: 0 auto !important;
            overflow: visible !important;
        }

        /* Evitar quebra de texto nas colunas - usar 98% para evitar cortes */
        table {
            width: 98% !important;
            border-collapse: collapse !important;
            font-size: 8pt;
            table-layout: auto;
            margin: 0 auto !important;
        }

        /* Garantir que tabelas dentro de cards usem 98% */
        .card-body table,
        .resumo-card table,
        .detalhado-content table {
            width: 98% !important;
            margin: 0 auto !important;
        }

        /* Garantir que todas as colunas aparecem na impressão detalhada */
        body.imprimindo-detalhado table {
            table-layout: auto !important;
            width: 98% !important;
            margin: 0 auto !important;
        }

        body.imprimindo-detalhado table th,
        body.imprimindo-detalhado table td {
            display: table-cell !important;
            visibility: visible !important;
            opacity: 1 !important;
            overflow: visible !important;
        }

        th,
        td {
            padding: 6px 8px !important;
            border: 1px solid #ddd !important;
            vertical-align: middle;
            word-wrap: break-word;
        }

        th {
            background-color: #f8f9fa !important;
            font-weight: bold;
            text-align: center;
            white-space: nowrap;
        }

        /* Evitar quebra em colunas numéricas e códigos */
        td.text-end,
        td.text-center,
        th.text-end,
        th.text-center {
            white-space: nowrap !important;
        }

        /* Primeira coluna (nomes) - pode quebrar se necessário mas com limite */
        td:first-child,
        th:first-child {
            max-width: 250px;
            white-space: normal;
            word-break: break-word;
        }

        /* Colunas de produto/nome em tabelas detalhadas */
        table td:nth-child(3) {
            max-width: 200px;
            white-space: normal;
            word-break: break-word;
        }

        /* Demais colunas de texto - evitar quebra mas não ocultar */
        td:not(.text-end):not(.text-center):not(:first-child):not(:nth-child(3)) {
            white-space: nowrap;
            overflow: visible !important;
            text-overflow: clip !important;
            max-width: none !important;
        }

        /* Colunas numéricas alinhadas à direita */
        .text-end {
            text-align: right !important;
        }

        .text-center {
            text-align: center !important;
        }

        .table-bordered {
            border-collapse: collapse !important;
        }

        .table-bordered th,
        .table-bordered td {
            border: 1px solid #ddd !important;
        }

        /* Evitar quebra de página dentro de linhas */
        tr {
            page-break-inside: avoid;
        }

        /* Quebrar página por profissional na impressão detalhada */
        body.imprimindo-detalhado .profissional-section {
            page-break-inside: avoid !important;
        }

        body.imprimindo-detalhado .profissional-section:not(.first-profissional) {
            page-break-before: always !important;
        }

        /* Títulos de seção */
        h5 {
            page-break-after: avoid;
            margin-top: 15px;
            margin-bottom: 10px;
        }

        /* Rodapé de impressão */
        .print-footer {
            margin-top: 20px;
            padding-top: 10px;
            border-top: 1px solid #ddd;
            font-size: 8pt;
            color: #666;
            text-align: center;
        }

        /* Melhorar visual da linha TOTAL */
        tfoot tr {
            background-color: #f8f9fa !important;
        }

        tfoot th {
            border-top: 2px solid #333 !important;
            font-weight: bold !important;
        }
    }

    /* Quando está imprimindo detalhado, mostrar detalhado e ocultar resumo */
    body.imprimindo-detalhado .detalhado-card {
        display: block !important;
    }

    .detalhado-content {
        display: none;
    }

    .print-profissional-title {
        display: none;
    }

    @media print {
        body.imprimindo-detalhado .detalhado-card {
            display: block !important;
        }

        body.imprimindo-detalhado .detalhado-content {
            display: block !important;
        }

        body.imprimindo-detalhado .detalhado-content .table-responsive {
            display: block !important;
            width: 98% !important;
            margin: 0 auto !important;
        }

        body.imprimindo-detalhado .detalhado-content table {
            display: table !important;
            width: 98% !important;
            margin: 0 auto !important;
        }

        body.imprimindo-detalhado .detalhado-content tr {
            display: table-row !important;
        }

        body.imprimindo-detalhado .detalhado-content td,
        body.imprimindo-detalhado .detalhado-content th {
            display: table-cell !important;
            visibility: visible !important;
            opacity: 1 !important;
        }

        /* Garantir que todas as colunas aparecem */
        body.imprimindo-detalhado .detalhado-content table th,
        body.imprimindo-detalhado .detalhado-content table td {
            display: table-cell !important;
            visibility: visible !important;
            opacity: 1 !important;
            width: auto !important;
            max-width: none !important;
            overflow: visible !important;
        }

        /* Garantir que as colunas de comissão (% e Comissão) aparecem */
        body.imprimindo-detalhado .detalhado-content table th:nth-child(8),
        body.imprimindo-detalhado .detalhado-content table th:nth-child(9),
        body.imprimindo-detalhado .detalhado-content table td:nth-child(8),
        body.imprimindo-detalhado .detalhado-content table td:nth-child(9) {
            display: table-cell !important;
            visibility: visible !important;
            opacity: 1 !important;
            width: auto !important;
        }

        body.imprimindo-detalhado .print-profissional-title {
            display: block !important;
        }

        /* Quebrar página antes de cada seção de profissional (exceto a primeira) */
        body.imprimindo-detalhado .profissional-section {
            page-break-inside: avoid !important;
            page-break-after: auto !important;
            margin-bottom: 20px !important;
        }

        body.imprimindo-detalhado .profissional-section:not(.first-profissional) {
            page-break-before: always !important;
        }

        /* Garantir que toda a seção do profissional fique junto */
        body.imprimindo-detalhado .profissional-section .print-profissional-title,
        body.imprimindo-detalhado .profissional-section .table-responsive,
        body.imprimindo-detalhado .profissional-section table {
            page-break-inside: avoid !important;
        }

        body.imprimindo-detalhado .resumo-card {
            display: none !important;
        }

        body.imprimindo-detalhado .ocultar-impressao-detalhada {
            display: none !important;
        }

        body.imprimindo-detalhado .resumo-print-header {
            display: none !important;
        }

        /* FORÇAR VISIBILIDADE DE TODAS AS COLUNAS NA IMPRESSÃO DETALHADA */
        body.imprimindo-detalhado .detalhado-content table {
            border-collapse: collapse !important;
            width: 98% !important;
            table-layout: auto !important;
            margin: 0 auto !important;
        }

        body.imprimindo-detalhado .detalhado-content thead th,
        body.imprimindo-detalhado .detalhado-content tbody td,
        body.imprimindo-detalhado .detalhado-content tfoot th {
            display: table-cell !important;
            visibility: visible !important;
            opacity: 1 !important;
            width: auto !important;
            min-width: auto !important;
            max-width: none !important;
            overflow: visible !important;
            text-overflow: clip !important;
            white-space: normal !important;
        }

        /* ESPECIFICAMENTE PARA COLUNAS DE COMISSÃO (8 e 9) */
        body.imprimindo-detalhado .detalhado-content table th:nth-child(8),
        body.imprimindo-detalhado .detalhado-content table th:nth-child(9),
        body.imprimindo-detalhado .detalhado-content table td:nth-child(8),
        body.imprimindo-detalhado .detalhado-content table td:nth-child(9) {
            display: table-cell !important;
            visibility: visible !important;
            opacity: 1 !important;
            width: auto !important;
            min-width: 70px !important;
        }
    }

    .align-middle {
        vertical-align: middle !important;
    }

    .table-bordered {
        border-collapse: collapse;
    }

    .table-bordered th,
    .table-bordered td {
        border: 1px solid #dee2e6;
    }
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'relatorios';
include ROOT_PATH . '/views/layouts/app.php';
?>