<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-box-seam me-2"></i> Produtos</h2>
        <p class="text-muted">Gerencie seus produtos e serviços</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/produtos/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Novo Produto
        </a>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-8">
                <input type="text" class="form-control" name="search"
                    placeholder="Buscar por nome, SKU, código de barras..."
                    value="<?= htmlspecialchars($search ?? '') ?>">
            </div>
            <div class="col-md-2">
                <select class="form-select" name="type">
                    <option value="">Todos os Tipos</option>
                    <option value="produto" <?= ($type ?? '') === 'produto' ? 'selected' : '' ?>>Produtos</option>
                    <option value="servico" <?= ($type ?? '') === 'servico' ? 'selected' : '' ?>>Serviços</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-secondary w-100">
                    <i class="bi bi-search"></i> Buscar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Lista de Produtos</span>
        <span class="badge bg-primary"><?= count($produtos ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($produtos)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th>Nome</th>
                            <th>SKU/Código</th>
                            <th>Grupo</th>
                            <th>Estoque</th>
                            <th>Preço</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($produtos as $produto): ?>
                            <tr style="cursor: pointer;" data-produto-id="<?= $produto['id'] ?>"
                                data-produto-nome="<?= htmlspecialchars($produto['name'], ENT_QUOTES) ?>"
                                data-produto-sku="<?= htmlspecialchars($produto['sku'] ?? '', ENT_QUOTES) ?>"
                                data-produto-tipo="<?= htmlspecialchars($produto['type'] ?? '', ENT_QUOTES) ?>"
                                data-produto-preco="<?= number_format($produto['price'] ?? 0, 2, ',', '.') ?>"
                                data-produto-estoque="<?= $produto['stock_quantity'] ?? 0 ?>"
                                onclick="abrirOpcoesProduto(event)">
                                <td><?= $produto['id'] ?></td>
                                <td>
                                    <strong><?= htmlspecialchars($produto['name']) ?></strong>
                                    <?php if (!empty($produto['description'])): ?>
                                        <br><small
                                            class="text-muted"><?= htmlspecialchars(substr($produto['description'], 0, 50)) ?><?= strlen($produto['description']) > 50 ? '...' : '' ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($produto['sku'] ?? '-') ?></td>
                                <td><small class="text-muted"><?= htmlspecialchars($produto['grupo_name'] ?? '-') ?></small>
                                </td>
                                <td>
                                    <?php if ($produto['type'] === 'produto'): ?>
                                        <?php
                                        $estoque = $produto['stock_quantity'] ?? 0;
                                        $minEstoque = $produto['min_stock'] ?? 0;
                                        $classe = $estoque <= $minEstoque ? 'text-danger' : 'text-success';
                                        ?>
                                        <span class="<?= $classe ?>"><strong><?= $estoque ?></strong></span>
                                    <?php else: ?>
                                        <span class="text-muted">N/A</span>
                                    <?php endif; ?>
                                </td>
                                <td><strong>R$ <?= number_format($produto['price'] ?? 0, 2, ',', '.') ?></strong></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-box-seam" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhum produto encontrado</p>
                <a href="<?= url('/produtos/criar') ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeiro Produto
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    /* Cards de opções (padrão semelhante ao módulo Vendas) */
    .opcoes-grupo {
        margin-bottom: 1.5rem;
        padding: 0 0.5rem;
    }

    .opcoes-grupo:last-child {
        margin-bottom: 0.5rem;
    }

    .opcoes-titulo {
        font-size: 0.85rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.08em;
        color: #64748b;
        margin-bottom: 0.6rem;
        display: flex;
        align-items: center;
        gap: 0.35rem;
    }

    .opcoes-titulo::before {
        content: '';
        width: 6px;
        height: 6px;
        border-radius: 50%;
        background: #cbd5f5;
    }

    .opcoes-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
        gap: 0.75rem;
    }

    .opcao-card {
        width: 130px;
        height: 130px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        gap: 0.75rem;
        border: 2px solid #e0e0e0;
        border-radius: 12px;
        background: white;
        cursor: pointer;
        transition: all 0.2s ease-in-out;
        padding: 1rem;
    }

    .opcao-card i {
        font-size: 2rem;
    }

    .opcao-card span {
        font-size: 0.9rem;
        font-weight: 600;
        text-align: center;
    }

    .opcao-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 18px rgba(0, 0, 0, 0.12);
    }

    .opcao-card-primary {
        border-color: #0d6efd;
        color: #0d6efd;
    }

    .opcao-card-primary:hover {
        background: #0d6efd;
        color: #fff;
    }

    .opcao-card-danger {
        border-color: #dc3545;
        color: #dc3545;
    }

    .opcao-card-danger:hover {
        background: #dc3545;
        color: #fff;
    }

    .opcao-card-secondary {
        border-color: #6c757d;
        color: #6c757d;
    }

    .opcao-card-secondary:hover {
        background: #6c757d;
        color: #fff;
    }

    .swal-produto-opcoes {
        border-radius: 16px;
        overflow: visible !important;
    }

    .swal-produto-container {
        margin: 0 !important;
        padding: 0 !important;
        overflow: visible !important;
    }

    .swal-produto-opcoes .swal2-html-container {
        overflow: visible !important;
    }

    .swal-produto-opcoes .swal2-close {
        color: white !important;
        background: rgba(255, 255, 255, 0.25) !important;
        border-radius: 8px !important;
        width: 36px !important;
        height: 36px !important;
        font-size: 1.5rem !important;
        transition: all 0.2s !important;
        top: 1rem !important;
        right: 1rem !important;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2) !important;
        z-index: 9999 !important;
    }

    .swal-produto-opcoes .swal2-close:hover {
        background: rgba(255, 255, 255, 0.4) !important;
        transform: scale(1.1) !important;
    }

    .swal-produto-opcoes .swal2-close:focus {
        box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.3) !important;
    }

    .opcoes-grid {
        padding: 1rem !important;
    }
</style>

<script>
    function abrirOpcoesProduto(event) {
        // Buscar dados da linha da tabela
        const row = event.target.closest('tr');
        if (!row) return;

        const id = row.dataset.produtoId;
        const nome = row.dataset.produtoNome;
        const sku = row.dataset.produtoSku;
        const tipo = row.dataset.produtoTipo;
        const preco = row.dataset.produtoPreco;
        const estoque = row.dataset.produtoEstoque;

        const tipoLabel = tipo === 'servico' ? 'Serviço' : 'Produto';
        const tipoIcon = tipo === 'servico' ? 'bi-tools' : 'bi-box-seam';

        const headerHtml = `
        <div style="background: linear-gradient(135deg, #059669 0%, #10b981 100%);
                    padding: 1.5rem;
                    margin: 0 0 1rem 0;
                    border-radius: 12px 12px 0 0;
                    color: white;
                    text-align: left;">
            <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 0.75rem;">
                <div style="background: rgba(255,255,255,0.2);
                            padding: 0.75rem;
                            border-radius: 10px;
                            display: flex;
                            align-items: center;
                            justify-content: center;">
                    <i class="bi ${tipoIcon}" style="font-size: 1.5rem;"></i>
                </div>
                <div style="flex: 1; padding-right: 3rem;">
                    <div style="font-size: 0.85rem; opacity: 0.9; margin-bottom: 0.25rem;">${tipoLabel}</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">${nome}</div>
                </div>
                <div style="text-align: right; min-width: 140px; padding-right: 2.5rem;">
                    <div style="font-size: 0.85rem; opacity: 0.9; margin-bottom: 0.25rem;">Preço</div>
                    <div style="font-size: 1.15rem; font-weight: 600;">R$ ${preco}</div>
                </div>
            </div>
            <div style="background: rgba(255,255,255,0.15);
                        padding: 0.75rem 1rem;
                        border-radius: 8px;
                        display: flex;
                        align-items: center;
                        gap: 0.75rem;">
                <i class="bi bi-upc-scan" style="font-size: 1.1rem; opacity: 0.9;"></i>
                <div style="flex: 1;">
                    <strong style="font-size: 0.95rem;">SKU: ${sku || 'Não informado'}</strong>
                    ${tipo === 'produto' ? `
                        <div style="opacity: 0.9; font-size: 0.85rem; margin-top: 0.25rem;">
                            <i class="bi bi-box" style="font-size: 0.85rem; margin-right: 0.25rem;"></i>
                            Estoque: <strong>${estoque}</strong>
                        </div>
                    ` : ''}
                </div>
            </div>
        </div>
    `;

        const opcoesHtml = `
        <div class="opcoes-grupo">
            <h6 class="opcoes-titulo">Ações</h6>
            <div class="opcoes-grid">
                <button type="button" class="opcao-card opcao-card-primary" onclick="window.location.href=appUrl('/produtos/editar?id=${id}')">
                    <i class="bi bi-pencil"></i>
                    <span>Editar</span>
                </button>
                <button type="button" class="opcao-card opcao-card-secondary" onclick="visualizarProduto(${id})">
                    <i class="bi bi-eye"></i>
                    <span>Visualizar</span>
                </button>
                <button type="button" class="opcao-card opcao-card-danger" onclick="deletarProdutoModal(${id}, '${nome.replace(/'/g, "&#39;")}')">
                    <i class="bi bi-trash"></i>
                    <span>Excluir</span>
                </button>
            </div>
        </div>
    `;

        const html = headerHtml + opcoesHtml;

        Swal.fire({
            html: html,
            showConfirmButton: false,
            showCloseButton: true,
            width: '700px',
            padding: '0',
            customClass: {
                popup: 'swal-produto-opcoes',
                htmlContainer: 'swal-produto-container'
            }
        });
    }

    function visualizarProduto(id) {
        Swal.close();
        window.location.href = appUrl('/produtos/editar?id=' + id);
    }

    async function deletarProdutoModal(id, nome) {
        Swal.close();

        const confirmed = await confirmDelete('Tem certeza que deseja excluir o produto "' + nome + '"?');
        if (confirmed) {
            $.ajax({
                url: appUrl('/produtos/deletar'),
                type: 'POST',
                data: {
                    id: id
                },
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        Toast.success(response.message);
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        Toast.error(response.message);
                    }
                }
            });
        }
    }

    // Manter função antiga para compatibilidade
    async function deletarProduto(id) {
        await deletarProdutoModal(id, '');
    }
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'produtos';
include ROOT_PATH . '/views/layouts/app.php';
?>