<?php
$produto = $produto ?? [];
$isEdit = isset($produto['id']) && !empty($produto['id']);

$heightValue = $produto['height_cm'] ?? null;
$widthValue = $produto['width_cm'] ?? null;
$lengthValue = $produto['length_cm'] ?? null;
$weightValue = $produto['weight'] ?? null;

if ($isEdit && $heightValue === null && $widthValue === null && $lengthValue === null && !empty($produto['dimensions'])) {
    $legacyDimensions = (string) $produto['dimensions'];
    $normalized = str_replace(['CM', 'cm', ' '], '', $legacyDimensions);
    $normalized = str_replace(['×', 'X'], 'x', $normalized);

    $parts = array_values(array_filter(explode('x', $normalized), static function ($part) {
        return $part !== '';
    }));
    $toFloat = static function (string $value): ?float {
        $value = str_replace(',', '.', $value);
        return is_numeric($value) ? (float) $value : null;
    };

    if (isset($parts[0]) && $widthValue === null) {
        $widthValue = $toFloat($parts[0]);
    }
    if (isset($parts[1]) && $heightValue === null) {
        $heightValue = $toFloat($parts[1]);
    }
    if (isset($parts[2]) && $lengthValue === null) {
        $lengthValue = $toFloat($parts[2]);
    }
}

$formatDecimal = static function ($value): string {
    if ($value === null || $value === '') {
        return '';
    }

    $formatted = number_format((float) $value, 2, '.', '');
    return rtrim(rtrim($formatted, '0'), '.');
};

$heightValueFormatted = $formatDecimal($heightValue);
$widthValueFormatted = $formatDecimal($widthValue);
$lengthValueFormatted = $formatDecimal($lengthValue);
$weightValueFormatted = $formatDecimal($weightValue);
?>

<div class="row mb-4">
    <div class="col-12">
        <ul class="nav nav-tabs" id="produtoTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados"
                    type="button" role="tab">
                    <i class="bi bi-info-circle me-2"></i> Dados Principais
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="precos-tab" data-bs-toggle="tab" data-bs-target="#precos" type="button"
                    role="tab">
                    <i class="bi bi-currency-dollar me-2"></i> Preços e Custos
                </button>
            </li>
            <!-- Aba Tributação oculta -->
            <!-- <li class="nav-item" role="presentation">
                <button class="nav-link" id="tributacao-tab" data-bs-toggle="tab" data-bs-target="#tributacao"
                    type="button" role="tab">
                    <i class="bi bi-file-earmark-text me-2"></i> Tributação
                </button>
            </li> -->
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="estoque-tab" data-bs-toggle="tab" data-bs-target="#estoque" type="button"
                    role="tab">
                    <i class="bi bi-box me-2"></i> Estoque
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="configuracoes-tab" data-bs-toggle="tab" data-bs-target="#configuracoes"
                    type="button" role="tab">
                    <i class="bi bi-gear me-2"></i> Configurações
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="kit-tab" data-bs-toggle="tab" data-bs-target="#kit" type="button"
                    role="tab">
                    <i class="bi bi-box-seam me-2"></i> Montagem de Kit
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="formulacao-tab" data-bs-toggle="tab" data-bs-target="#formulacao"
                    type="button" role="tab">
                    <i class="bi bi-clipboard-data me-2"></i> Formulação
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="empresas-tab" data-bs-toggle="tab" data-bs-target="#empresas" type="button"
                    role="tab">
                    <i class="bi bi-building me-2"></i> Empresas
                </button>
            </li>
        </ul>
    </div>
</div>

<div class="tab-content" id="produtoTabsContent">
    <!-- Aba: Dados Principais -->
    <div class="tab-pane fade show active" id="dados" role="tabpanel">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-info-circle me-2"></i> Informações do Produto
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="name" class="form-label">Nome do Produto *</label>
                                <input type="text" class="form-control" id="name" name="name"
                                    value="<?= htmlspecialchars($produto['name'] ?? '') ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="type" class="form-label">Tipo *</label>
                                <select class="form-select" id="type" name="type" required>
                                    <option value="">Selecione...</option>
                                    <option value="produto" <?= ($produto['type'] ?? '') === 'produto' ? 'selected' : '' ?>>Produto</option>
                                    <option value="servico" <?= ($produto['type'] ?? '') === 'servico' ? 'selected' : '' ?>>Serviço</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="sku" class="form-label">SKU/Código</label>
                                <input type="text" class="form-control" id="sku" name="sku" readonly
                                    placeholder="<?= $isEdit ? '' : 'Será gerado automaticamente' ?>"
                                    value="<?= htmlspecialchars($produto['sku'] ?? '') ?>">
                                <small class="text-muted">
                                    <?= $isEdit ? 'Código gerado automaticamente' : 'Será gerado após salvar' ?>
                                </small>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="barcode" class="form-label">Código de Barras</label>
                                <input type="text" class="form-control" id="barcode" name="barcode"
                                    placeholder="7891234567890"
                                    value="<?= htmlspecialchars($produto['barcode'] ?? '') ?>">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="grupo_id" class="form-label">Grupo</label>
                                <select class="form-select" id="grupo_id" name="grupo_id">
                                    <option value="">Selecione um grupo...</option>
                                    <?php if (isset($gruposItens) && !empty($gruposItens)): ?>
                                        <?php foreach ($gruposItens as $grupo): ?>
                                            <option value="<?= $grupo['id'] ?>" <?= ($produto['grupo_id'] ?? '') == $grupo['id'] ? 'selected' : '' ?>>
                                                <?= htmlspecialchars($grupo['nome']) ?>
                                                <?php if (!empty($grupo['subtipo'])): ?>
                                                    (<?= ucfirst($grupo['subtipo']) ?>)
                                                <?php endif; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="subgrupo_id" class="form-label">Subgrupo</label>
                                <select class="form-select" id="subgrupo_id" name="subgrupo_id">
                                    <option value="">Selecione um subgrupo...</option>
                                    <?php if (isset($subgruposItens) && !empty($subgruposItens)): ?>
                                        <?php foreach ($subgruposItens as $subgrupo): ?>
                                            <option value="<?= $subgrupo['id'] ?>" data-grupo="<?= $subgrupo['grupo_id'] ?>"
                                                <?= ($produto['subgrupo_id'] ?? '') == $subgrupo['id'] ? 'selected' : '' ?>>
                                                <?= htmlspecialchars($subgrupo['nome']) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="comissao" class="form-label">
                                    Comissão (%)
                                    <small class="text-muted">(Percentual de comissão)</small>
                                </label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="comissao" name="comissao"
                                        placeholder="0.00" step="0.01" min="0" max="100"
                                        value="<?= !empty($produto['comissao']) ? number_format((float) $produto['comissao'], 2, '.', '') : '' ?>">
                                    <span class="input-group-text">%</span>
                                </div>
                                <small class="text-muted">Ex: 5.00 para 5% de comissão</small>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="grupo_tributacao_id" class="form-label">
                                    Grupo de Impostos
                                    <small class="text-muted">(Tributação do produto)</small>
                                </label>
                                <select class="form-select" id="grupo_tributacao_id" name="grupo_tributacao_id">
                                    <option value="">Selecione um grupo de impostos...</option>
                                    <?php if (isset($gruposTributacao) && !empty($gruposTributacao)): ?>
                                        <?php foreach ($gruposTributacao as $grupo): ?>
                                            <option value="<?= $grupo['id'] ?>" <?= (isset($produto['grupo_tributacao_id']) && (string) $produto['grupo_tributacao_id'] === (string) $grupo['id']) ? 'selected' : '' ?> data-ncm="<?= htmlspecialchars($grupo['ncm'] ?? '') ?>"
                                                data-cst-icms="<?= htmlspecialchars($grupo['cst_csosn'] ?? '') ?>"
                                                data-icms="<?= $grupo['icms'] ?? '0' ?>"
                                                data-cst-pis="<?= htmlspecialchars($grupo['cst_pis'] ?? '') ?>"
                                                data-pis="<?= $grupo['pis'] ?? '0' ?>"
                                                data-cst-cofins="<?= htmlspecialchars($grupo['cst_cofins'] ?? '') ?>"
                                                data-cofins="<?= $grupo['cofins'] ?? '0' ?>"
                                                data-cst-ipi="<?= htmlspecialchars($grupo['cst_ipi'] ?? '') ?>"
                                                data-ipi="<?= $grupo['ipi'] ?? '0' ?>">
                                                <?= htmlspecialchars($grupo['nome']) ?>
                                                <?php if (!empty($grupo['ncm'])): ?>
                                                    - NCM: <?= htmlspecialchars($grupo['ncm']) ?>
                                                <?php endif; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                                <small class="text-muted">Selecione um grupo de impostos cadastrado no sistema</small>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label for="description" class="form-label">Descrição</label>
                                <textarea class="form-control" id="description" name="description" rows="4"
                                    placeholder="Descrição detalhada do produto..."><?= htmlspecialchars($produto['description'] ?? '') ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Preços e Custos -->
    <div class="tab-pane fade" id="precos" role="tabpanel">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-currency-dollar me-2"></i> Preços e Custos
                    </div>
                    <div class="card-body">
                        <!-- Script inline para garantir que funções estejam disponíveis -->
                        <script>
                            // Garantir que maskMoneyInput esteja disponível
                            if (typeof window.maskMoneyInput === 'undefined') {
                                window.maskMoneyInput = function (input) {
                                    if (!input || input._masking) return;
                                    input._masking = true;

                                    let currentValue = String(input.value || '').trim();

                                    // Se já está formatado, não reformatar
                                    if (currentValue.includes('R$') && currentValue.includes(',')) {
                                        input._masking = false;
                                        return;
                                    }

                                    const cursorPos = input.selectionStart || 0;

                                    // Remover tudo exceto números, vírgula e ponto
                                    let cleanValue = currentValue.replace('R$', '').replace(/\s/g, '');

                                    // Se tem vírgula ou ponto, tratar como decimal já formatado
                                    let numValue = 0;
                                    if (cleanValue.includes(',') || cleanValue.includes('.')) {
                                        // Remove pontos (separadores de milhar) e converte vírgula para ponto
                                        cleanValue = cleanValue.replace(/\./g, '').replace(',', '.');
                                        numValue = parseFloat(cleanValue) || 0;
                                    } else {
                                        // Apenas números - tratar como valor inteiro
                                        let digits = cleanValue.replace(/\D/g, '');
                                        if (digits === '' || digits === '0') {
                                            input.value = '';
                                            input._masking = false;
                                            return;
                                        }
                                        numValue = parseFloat(digits) || 0;
                                    }

                                    // Formatar: garantir 2 casas decimais
                                    let formatted = numValue.toFixed(2);
                                    // Separar parte inteira e decimal
                                    let parts = formatted.split('.');
                                    let parteInteira = parts[0];
                                    let parteDecimal = parts[1] || '00';

                                    // Garantir que parte decimal tenha exatamente 2 dígitos
                                    parteDecimal = parteDecimal.substring(0, 2).padEnd(2, '0');

                                    // Aplicar separador de milhar APENAS na parte inteira (se tiver mais de 3 dígitos)
                                    if (parteInteira.length > 3) {
                                        parteInteira = parteInteira.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
                                    }

                                    // Juntar: parte inteira + vírgula + parte decimal
                                    let finalValue = parteInteira + ',' + parteDecimal;
                                    input.value = 'R$ ' + finalValue;

                                    try {
                                        const lengthDiff = input.value.length - currentValue.length;
                                        const newCursorPos = Math.min(Math.max(cursorPos + lengthDiff, 0), input.value.length);
                                        input.setSelectionRange(newCursorPos, newCursorPos);
                                    } catch (e) { }

                                    input._masking = false;

                                    // Disparar cálculo se for o campo custo
                                    if (input.id === 'tabela_custo' && window.calcularPrecoVenda) {
                                        setTimeout(function () {
                                            window.calcularPrecoVenda();
                                        }, 150);
                                    }
                                };
                            }

                            // Função para formatar percentual
                            if (typeof window.maskPercent === 'undefined') {
                                window.maskPercent = function (input) {
                                    if (!input || input._masking) return;
                                    input._masking = true;

                                    let currentValue = String(input.value || '').trim();

                                    if (currentValue.includes('%') && currentValue.includes(',')) {
                                        input._masking = false;
                                        return;
                                    }

                                    const cursorPos = input.selectionStart || 0;

                                    let numValue = 0;
                                    if (currentValue.includes(',') || currentValue.includes('.')) {
                                        let cleanValue = currentValue.replace('%', '').replace(/\s/g, '');
                                        cleanValue = cleanValue.replace(/\./g, '').replace(',', '.');
                                        numValue = parseFloat(cleanValue) || 0;
                                    } else {
                                        let value = currentValue.replace(/\D/g, '');
                                        if (value === '' || value === '0') {
                                            input.value = '';
                                            input._masking = false;
                                            return;
                                        }
                                        numValue = parseFloat(value) || 0;
                                    }

                                    let value = numValue.toFixed(2);
                                    let parts = value.split('.');
                                    let parteInteira = parts[0];
                                    let parteDecimal = parts[1] || '00';
                                    parteInteira = parteInteira.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
                                    value = parteInteira + ',' + parteDecimal;

                                    input.value = value;

                                    try {
                                        const lengthDiff = input.value.length - currentValue.length;
                                        const newCursorPos = Math.min(Math.max(cursorPos + lengthDiff, 0), input.value.length);
                                        input.setSelectionRange(newCursorPos, newCursorPos);
                                    } catch (e) { }

                                    input._masking = false;
                                };
                            }

                            // Função SIMPLES para calcular venda - disponível IMEDIATAMENTE
                            window.calcularVendaSimples = function () {
                                var custoInput = document.getElementById('tabela_custo');
                                var margemInput = document.getElementById('tabela_margem');
                                var vendaInput = document.getElementById('tabela_venda');

                                if (!custoInput || !margemInput || !vendaInput) {
                                    console.log('Campos não encontrados');
                                    return;
                                }

                                // Pegar valores
                                var custoStr = custoInput.value || '0';
                                var margemStr = margemInput.value || '0';

                                // Limpar formatação do custo: "R$ 5,00" -> "5.00"
                                custoStr = custoStr.replace('R$', '').replace(/\s/g, '').replace(/\./g, '').replace(',', '.');
                                var custo = parseFloat(custoStr) || 0;

                                // Limpar formatação da margem: "8,00" -> "8.00"
                                margemStr = margemStr.replace(/\./g, '').replace(',', '.');
                                var margem = parseFloat(margemStr) || 0;

                                // CALCULAR: Venda = Custo + (Custo * Margem / 100)
                                var venda = 0;
                                if (custo > 0) {
                                    if (margem > 0) {
                                        venda = custo + (custo * margem / 100);
                                    } else {
                                        venda = custo;
                                    }
                                }

                                // Formatar resultado: "5.40" -> "R$ 5,40"
                                var vendaFormatado = 'R$ ' + venda.toFixed(2).replace('.', ',');
                                vendaInput.value = vendaFormatado;
                                console.log('Cálculo executado:', { custo, margem, venda, vendaFormatado });
                            };

                            // Variáveis globais para tabelas
                            if (typeof window.tabelasTemp === 'undefined') {
                                window.tabelasTemp = [];
                                window.tabelaIndex = 0;
                            }

                            // Função para normalizar valores monetários
                            function normalizarValor(valor) {
                                if (!valor) return '0.00';
                                let str = String(valor).replace(/R\$/g, '').replace(/\s/g, '').replace(/\./g, '').replace(',', '.');
                                let num = parseFloat(str) || 0;
                                return num.toFixed(2);
                            }

                            // Função para normalizar percentual
                            function normalizarPercentual(valor) {
                                if (!valor) return '0.00';
                                let str = String(valor).replace(/\./g, '').replace(',', '.');
                                let num = parseFloat(str) || 0;
                                return num.toFixed(2);
                            }

                            // Adicionar tabela de preço - RECONSTRUÍDA
                            window.adicionarTabela = function (tabelaExistente = null) {
                                console.log('adicionarTabela chamada', tabelaExistente);

                                if (typeof jQuery === 'undefined' || typeof $ === 'undefined') {
                                    console.log('jQuery não disponível, aguardando...');
                                    setTimeout(function () {
                                        if (typeof window.adicionarTabela === 'function') {
                                            window.adicionarTabela(tabelaExistente);
                                        }
                                    }, 100);
                                    return;
                                }

                                console.log('jQuery disponível, continuando...');

                                // Inicializar variáveis
                                if (!window.tabelasTemp) window.tabelasTemp = [];
                                if (typeof window.tabelaIndex === 'undefined') window.tabelaIndex = 0;

                                let tabelaPrecoId = '';
                                let nome = '';
                                let compra = '0.00';
                                let custo = '0.00';
                                let margem = '0.00';
                                let venda = '0.00';

                                // Se for tabela existente (carregando do banco)
                                if (tabelaExistente) {
                                    tabelaPrecoId = String(tabelaExistente.tabela_preco_id || '');
                                    nome = String(tabelaExistente.nome || '');
                                    compra = normalizarValor(tabelaExistente.compra);
                                    custo = normalizarValor(tabelaExistente.custo);
                                    margem = normalizarPercentual(tabelaExistente.margem);
                                    venda = normalizarValor(tabelaExistente.venda);
                                } else {
                                    // Pegar valores dos campos do formulário
                                    const selectTabela = $('#tabela_nome');
                                    const selectedOption = selectTabela.find('option:selected');
                                    tabelaPrecoId = String(selectedOption.val() || '');
                                    nome = String(selectedOption.data('nome') || selectedOption.text().trim() || '');

                                    // Validar se selecionou uma tabela
                                    if (!tabelaPrecoId || tabelaPrecoId === '') {
                                        if (typeof Swal !== 'undefined') {
                                            Swal.fire({
                                                icon: 'error',
                                                title: 'Erro',
                                                text: 'Selecione uma tabela de preço'
                                            });
                                        } else {
                                            alert('Selecione uma tabela de preço');
                                        }
                                        return;
                                    }

                                    // Pegar e normalizar valores dos campos
                                    compra = normalizarValor($('#tabela_compra').val());
                                    custo = normalizarValor($('#tabela_custo').val());
                                    margem = normalizarPercentual($('#tabela_margem').val());
                                    venda = normalizarValor($('#tabela_venda').val());

                                    // Validar se tem venda
                                    if (parseFloat(venda) <= 0) {
                                        if (typeof Swal !== 'undefined') {
                                            Swal.fire({
                                                icon: 'error',
                                                title: 'Erro',
                                                text: 'O valor de venda deve ser maior que zero'
                                            });
                                        } else {
                                            alert('O valor de venda deve ser maior que zero');
                                        }
                                        return;
                                    }
                                }

                                // Validar nome
                                if (!nome || nome.trim() === '') {
                                    if (typeof Swal !== 'undefined') {
                                        Swal.fire({
                                            icon: 'error',
                                            title: 'Erro',
                                            text: 'Nome da tabela não encontrado'
                                        });
                                    } else {
                                        alert('Nome da tabela não encontrado');
                                    }
                                    return;
                                }

                                // Criar objeto da tabela
                                const tabela = {
                                    index: window.tabelaIndex,
                                    nome: nome.trim(),
                                    tabela_preco_id: tabelaPrecoId,
                                    compra: compra,
                                    custo: custo,
                                    margem: margem,
                                    venda: venda
                                };

                                // Adicionar ao array
                                window.tabelasTemp.push(tabela);
                                window.tabelaIndex++;

                                // Formatar para exibição
                                const compraFormatado = parseFloat(compra).toFixed(2).replace('.', ',');
                                const custoFormatado = parseFloat(custo).toFixed(2).replace('.', ',');
                                const margemFormatado = parseFloat(margem).toFixed(2);
                                const vendaFormatado = parseFloat(venda).toFixed(2).replace('.', ',');

                                // Criar linha HTML
                                const row = `
                                <tr data-index="${tabela.index}">
                                    <td><strong>${nome}</strong></td>
                                    <td>R$ ${compraFormatado}</td>
                                    <td>R$ ${custoFormatado}</td>
                                    <td>${margemFormatado}%</td>
                                    <td><strong class="text-success">R$ ${vendaFormatado}</strong></td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerTabela(${tabela.index})">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </td>
                                    <input type="hidden" name="tabelas[${tabela.index}][nome]" value="${nome}">
                                    <input type="hidden" name="tabelas[${tabela.index}][tabela_preco_id]" value="${tabelaPrecoId}">
                                    <input type="hidden" name="tabelas[${tabela.index}][compra]" value="${compra}">
                                    <input type="hidden" name="tabelas[${tabela.index}][custo]" value="${custo}">
                                    <input type="hidden" name="tabelas[${tabela.index}][margem]" value="${margem}">
                                    <input type="hidden" name="tabelas[${tabela.index}][venda]" value="${venda}">
                                </tr>
                            `;

                                // Adicionar ao DOM
                                const tbodyTabelas = $('#tbody-tabelas');
                                console.log('tbodyTabelas encontrado?', tbodyTabelas.length > 0);

                                if (tbodyTabelas.length > 0) {
                                    tbodyTabelas.append(row);
                                    $('#alert-sem-tabelas').hide();
                                    $('#tabela-tabelas').show();
                                    $('#total-tabelas').text(window.tabelasTemp.length);
                                    console.log('✓ Tabela adicionada com sucesso! Total:', window.tabelasTemp.length);
                                } else {
                                    console.error('✗ ERRO: #tbody-tabelas não encontrado no DOM!');
                                }

                                // Limpar campos se não for tabela existente
                                if (!tabelaExistente) {
                                    $('#tabela_nome').val('');
                                    $('#tabela_compra').val('');
                                    $('#tabela_custo').val('');
                                    $('#tabela_margem').val('');
                                    $('#tabela_venda').val('');
                                    $('#tabela_nome').focus();
                                }
                            };

                            // Remover tabela
                            window.removerTabela = function (index) {
                                if (typeof jQuery === 'undefined' || typeof $ === 'undefined') {
                                    setTimeout(function () {
                                        if (typeof window.removerTabela === 'function') {
                                            window.removerTabela(index);
                                        }
                                    }, 100);
                                    return;
                                }

                                // Encontrar a tabela que será removida para pegar o tabela_preco_id
                                const tr = $(`#tbody-tabelas tr[data-index="${index}"]`);
                                const tabelaPrecoIdInput = tr.find('input[name*="[tabela_preco_id]"]');
                                const tabelaPrecoId = tabelaPrecoIdInput.length > 0 ? tabelaPrecoIdInput.val() : null;

                                // Remover da tabela
                                tr.remove();

                                // Remover do array
                                if (window.tabelasTemp) {
                                    window.tabelasTemp = window.tabelasTemp.filter(t => t.index !== index);
                                }
                                $('#total-tabelas').text(window.tabelasTemp ? window.tabelasTemp.length : 0);

                                // Reabilitar a opção no select quando a tabela for removida
                                if (tabelaPrecoId) {
                                    const option = $('#tabela_nome option[value="' + tabelaPrecoId + '"]');
                                    if (option.length > 0) {
                                        option.prop('disabled', false);
                                        option.css({ 'color': '', 'font-style': '' });
                                        let optionText = option.text().replace(' (já adicionada)', '');
                                        option.text(optionText);
                                    }
                                }

                                if (!window.tabelasTemp || window.tabelasTemp.length === 0) {
                                    $('#tabela-tabelas').hide();
                                    $('#alert-sem-tabelas').show();
                                }
                            };
                        </script>
                        <!-- Campos hidden obrigatórios para o banco -->
                        <input type="hidden" id="price" name="price" value="<?= $produto['price'] ?? '0.00' ?>">
                        <input type="hidden" id="cost_price" name="cost_price"
                            value="<?= $produto['cost_price'] ?? '0.00' ?>">
                        <input type="hidden" id="purchase_price" name="purchase_price"
                            value="<?= $produto['purchase_price'] ?? '0.00' ?>">
                        <input type="hidden" id="profit_margin" name="profit_margin"
                            value="<?= $produto['profit_margin'] ?? '0.00' ?>">

                        <!-- Tabelas de Preço Padrão -->
                        <h6 class="text-success mb-3"><i class="bi bi-table me-2"></i> Tabelas de Preço</h6>
                        <p class="text-muted small mb-3">
                            <i class="bi bi-info-circle me-1"></i>
                            Crie múltiplas tabelas de preço (Ex: Tabela 1, Tabela 2, Tabela Especial)
                        </p>

                        <div class="row">
                            <div class="col-md-3">
                                <label for="tabela_nome" class="form-label">Nome da Tabela</label>
                                <select class="form-select" id="tabela_nome">
                                    <option value="">Selecione...</option>
                                    <?php
                                    // Lista de IDs de tabelas já adicionadas
                                    $tabelasJaAdicionadas = [];
                                    if (!empty($tabelasPrecoProduto ?? [])) {
                                        foreach ($tabelasPrecoProduto as $tabelaAdicionada) {
                                            if (!empty($tabelaAdicionada['tabela_preco_id'])) {
                                                $tabelasJaAdicionadas[] = (string) $tabelaAdicionada['tabela_preco_id'];
                                            }
                                        }
                                    }
                                    ?>
                                    <?php if (isset($tabelasPreco) && !empty($tabelasPreco)): ?>
                                        <?php foreach ($tabelasPreco as $tabela): ?>
                                            <?php
                                            $tabelaId = (string) $tabela['id'];
                                            $jaAdicionada = in_array($tabelaId, $tabelasJaAdicionadas, true);
                                            ?>
                                            <option value="<?= htmlspecialchars($tabela['id']) ?>"
                                                data-nome="<?= htmlspecialchars($tabela['nome']) ?>"
                                                title="<?= htmlspecialchars($tabela['descricao'] ?? '') ?>" <?= $jaAdicionada ? 'disabled style="color: #999; font-style: italic;"' : '' ?>>
                                                <?= htmlspecialchars($tabela['nome']) ?>
                                                <?= $jaAdicionada ? ' (já adicionada)' : '' ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="tabela_compra" class="form-label">Compra (R$)</label>
                                <input type="text" class="form-control" id="tabela_compra" placeholder="R$ 0,00"
                                    oninput="maskMoneyInput(this)">
                            </div>
                            <div class="col-md-2">
                                <label for="tabela_custo" class="form-label">Custo (R$)</label>
                                <input type="text" class="form-control" id="tabela_custo" placeholder="R$ 0,00"
                                    oninput="maskMoneyInput(this)">
                            </div>
                            <div class="col-md-2">
                                <label for="tabela_margem" class="form-label">Margem (%)</label>
                                <input type="text" class="form-control" id="tabela_margem" placeholder="0,00"
                                    oninput="maskPercent(this)" onblur="calcularVendaSimples()">
                            </div>
                            <div class="col-md-2">
                                <label for="tabela_venda" class="form-label">Venda (R$)</label>
                                <input type="text" class="form-control" id="tabela_venda" placeholder="R$ 0,00" readonly
                                    style="background-color: #f8f9fa;" readonly>
                            </div>
                            <div class="col-md-1">
                                <label class="form-label d-block">&nbsp;</label>
                                <button type="button" class="btn btn-success w-100" onclick="adicionarTabela()">
                                    <i class="bi bi-plus-circle"></i>
                                </button>
                            </div>
                        </div>

                        <div id="lista-tabelas" class="mt-3">
                            <?php
                            $tabelasExistentes = $tabelasPrecoProduto ?? [];
                            $temTabelasSalvas = !empty($tabelasExistentes);
                            ?>
                            <div class="alert alert-info" id="alert-sem-tabelas" style="<?= $temTabelasSalvas ? 'display:none;' : '' ?>">
                                <i class="bi bi-info-circle me-2"></i>
                                Nenhuma tabela de preço adicional configurada.
                            </div>
                            <div id="tabela-tabelas" style="<?= !$temTabelasSalvas ? 'display:none;' : '' ?>">
                                <table class="table table-sm table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Nome da Tabela</th>
                                            <th width="120">Compra</th>
                                            <th width="120">Custo</th>
                                            <th width="100">Margem</th>
                                            <th width="120">Venda</th>
                                            <th width="80">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tbody-tabelas">
                                            <?php
                                            $tabelaIndexInicial = 0;
                                            foreach ($tabelasExistentes as $tabela):
                                                $tabelaIndexInicial++;
                                                $nome = htmlspecialchars($tabela['nome'] ?? '');
                                                $tabelaPrecoId = htmlspecialchars($tabela['tabela_preco_id'] ?? '');
                                                $compra = number_format((float) ($tabela['compra'] ?? 0), 2, ',', '.');
                                                $custo = number_format((float) ($tabela['custo'] ?? 0), 2, ',', '.');
                                                $margem = number_format((float) ($tabela['margem'] ?? 0), 2, ',', '.');
                                                $venda = number_format((float) ($tabela['venda'] ?? 0), 2, ',', '.');
                                                ?>
                                                <tr data-index="<?= $tabelaIndexInicial ?>">
                                                    <td><strong><?= $nome ?></strong></td>
                                                    <td>R$ <?= $compra ?></td>
                                                    <td>R$ <?= $custo ?></td>
                                                    <td><?= $margem ?>%</td>
                                                    <td><strong class="text-success">R$ <?= $venda ?></strong></td>
                                                    <td>
                                                        <button type="button" class="btn btn-sm btn-outline-danger"
                                                            onclick="removerTabela(<?= $tabelaIndexInicial ?>)">
                                                            <i class="bi bi-trash"></i>
                                                        </button>
                                                    </td>
                                                    <input type="hidden" name="tabelas[<?= $tabelaIndexInicial ?>][nome]"
                                                        value="<?= $nome ?>">
                                                    <input type="hidden"
                                                        name="tabelas[<?= $tabelaIndexInicial ?>][tabela_preco_id]"
                                                        value="<?= $tabelaPrecoId ?>">
                                                    <input type="hidden" name="tabelas[<?= $tabelaIndexInicial ?>][compra]"
                                                        value="<?= $tabela['compra'] ?? 0 ?>">
                                                    <input type="hidden" name="tabelas[<?= $tabelaIndexInicial ?>][custo]"
                                                        value="<?= $tabela['custo'] ?? 0 ?>">
                                                    <input type="hidden" name="tabelas[<?= $tabelaIndexInicial ?>][margem]"
                                                        value="<?= $tabela['margem'] ?? 0 ?>">
                                                    <input type="hidden" name="tabelas[<?= $tabelaIndexInicial ?>][venda]"
                                                        value="<?= $tabela['venda'] ?? 0 ?>">
                                                </tr>
                                            <?php endforeach; ?>
                                    </tbody>
                                </table>
                                <div class="alert alert-success mt-2">
                                    <i class="bi bi-check-circle me-2"></i>
                                    <strong id="total-tabelas"><?= count($tabelasExistentes) ?></strong> tabela(s) de
                                    preço
                                </div>
                            </div>
                        </div>

                        <script>
                            // Inicializar arrays JavaScript com tabelas já existentes
                            <?php if ($temTabelasSalvas): ?>
                                if (typeof window.tabelasTemp === 'undefined') {
                                    window.tabelasTemp = [];
                                }
                                if (typeof window.tabelaIndex === 'undefined') {
                                    window.tabelaIndex = <?= $tabelaIndexInicial + 1 ?>;
                                } else {
                                    window.tabelaIndex = Math.max(window.tabelaIndex, <?= $tabelaIndexInicial + 1 ?>);
                                }

                                // Popular array JavaScript com tabelas existentes
                                <?php foreach ($tabelasExistentes as $index => $tabela): ?>
                                    window.tabelasTemp.push({
                                        index: <?= $index + 1 ?>,
                                        nome: <?= json_encode($tabela['nome'] ?? '') ?>,
                                        tabela_preco_id: <?= json_encode($tabela['tabela_preco_id'] ?? '') ?>,
                                        compra: <?= json_encode($tabela['compra'] ?? 0) ?>,
                                        custo: <?= json_encode($tabela['custo'] ?? 0) ?>,
                                        margem: <?= json_encode($tabela['margem'] ?? 0) ?>,
                                        venda: <?= json_encode($tabela['venda'] ?? 0) ?>
                                    });
                                <?php endforeach; ?>

                                console.log('Tabelas carregadas diretamente do PHP:', window.tabelasTemp.length);

                                // Desabilitar tabelas já adicionadas no select
                                <?php foreach ($tabelasExistentes as $tabela): ?>
                                    <?php if (!empty($tabela['tabela_preco_id'])): ?>
                                        const option<?= $tabela['tabela_preco_id'] ?> = $('#tabela_nome option[value="<?= $tabela['tabela_preco_id'] ?>"]');
                                        if (option<?= $tabela['tabela_preco_id'] ?>.length > 0) {
                                            option<?= $tabela['tabela_preco_id'] ?>.prop('disabled', true);
                                            option<?= $tabela['tabela_preco_id'] ?>.css({ 'color': '#999', 'font-style': 'italic' });
                                            if (!option<?= $tabela['tabela_preco_id'] ?>.text().includes('(já adicionada)')) {
                                                option<?= $tabela['tabela_preco_id'] ?>.text(option<?= $tabela['tabela_preco_id'] ?>.text() + ' (já adicionada)');
                                            }
                                        }
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </script>

                        <hr class="my-4">

                        <!-- Preços por Quantidade -->
                        <h6 class="text-warning mb-3"><i class="bi bi-percent me-2"></i> Preços por Quantidade</h6>
                        <p class="text-muted small mb-3">
                            <i class="bi bi-info-circle me-1"></i>
                            Configure descontos por quantidade (Ex: Atacado 10+ unidades, Varejo 1+ unidade)
                        </p>

                        <div class="row">
                            <div class="col-md-4">
                                <label for="preco_descricao" class="form-label">Descrição</label>
                                <input type="text" class="form-control" id="preco_descricao" placeholder="Ex: Atacado">
                            </div>
                            <div class="col-md-3">
                                <label for="preco_quantidade_min" class="form-label">Qtd. Mínima</label>
                                <input type="number" class="form-control" id="preco_quantidade_min" placeholder="1"
                                    min="1" value="1">
                            </div>
                            <div class="col-md-3">
                                <label for="preco_valor" class="form-label">Preço (R$)</label>
                                <input type="number" class="form-control" id="preco_valor" step="0.01"
                                    placeholder="0,00" min="0">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label d-block">&nbsp;</label>
                                <button type="button" class="btn btn-success w-100" onclick="adicionarPreco()">
                                    <i class="bi bi-plus-circle me-1"></i> Add
                                </button>
                            </div>
                        </div>

                        <div id="lista-precos" class="mt-3">
                            <div class="alert alert-info" id="alert-sem-precos">
                                <i class="bi bi-info-circle me-2"></i>
                                Nenhum preço adicional configurado.
                            </div>
                            <div id="tabela-precos" style="display: none;">
                                <table class="table table-sm table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Descrição</th>
                                            <th width="120">Qtd. Mínima</th>
                                            <th width="150">Preço</th>
                                            <th width="80">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tbody-precos">
                                    </tbody>
                                </table>
                                <div class="alert alert-success mt-2">
                                    <i class="bi bi-check-circle me-2"></i>
                                    <strong id="total-precos">0</strong> preço(s) adicional(is)
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Tributação (OCULTA - movida para Dados Principais) -->
    <div class="tab-pane fade" id="tributacao" role="tabpanel" style="display: none !important;">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-file-earmark-text me-2"></i> Informações Fiscais
                    </div>
                    <div class="card-body">
                        <!-- Tipo de Tributação -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary mb-3">
                                    <i class="bi bi-list-check me-2"></i> Tipo de Tributação
                                </h6>
                                <div class="btn-group w-100" role="group">
                                    <input type="radio" class="btn-check" name="tipo_tributacao" id="tipo_produto"
                                        value="produto" checked>
                                    <label class="btn btn-outline-primary" for="tipo_produto">
                                        <i class="bi bi-box me-2"></i> Por Produto
                                    </label>

                                    <input type="radio" class="btn-check" name="tipo_tributacao" id="tipo_grupo"
                                        value="grupo">
                                    <label class="btn btn-outline-primary" for="tipo_grupo">
                                        <i class="bi bi-collection me-2"></i> Por Grupo de Impostos
                                    </label>
                                </div>
                                <small class="text-muted d-block mt-2">
                                    <i class="bi bi-info-circle me-1"></i>
                                    Escolha se deseja configurar a tributação individualmente ou usar um grupo
                                    pré-configurado
                                </small>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Select de Grupo de Tributação REMOVIDO - Movido para aba Dados Principais -->

                        <!-- Campos de Tributação Individual -->
                        <div id="div_campos_tributacao">
                            <div class="row">
                                <!-- NCM -->
                                <div class="col-md-6 mb-3">
                                    <label for="ncm" class="form-label">NCM <small class="text-muted">(Nomenclatura
                                            Comum do
                                            Mercosul)</small></label>
                                    <input type="text" class="form-control" id="ncm" name="ncm" placeholder="0000.00.00"
                                        maxlength="10" value="<?= htmlspecialchars($produto['ncm'] ?? '') ?>">
                                </div>

                                <!-- CEST -->
                                <div class="col-md-6 mb-3">
                                    <label for="cest" class="form-label">CEST <small class="text-muted">(Código
                                            Especificador da Substituição Tributária)</small></label>
                                    <input type="text" class="form-control" id="cest" name="cest"
                                        placeholder="00.000.00" maxlength="9"
                                        value="<?= htmlspecialchars($produto['cest'] ?? '') ?>">
                                </div>

                                <!-- CFOP Padrão -->
                                <div class="col-md-6 mb-3">
                                    <label for="cfop" class="form-label">CFOP Padrão <small class="text-muted">(Código
                                            Fiscal de Operações)</small></label>
                                    <input type="text" class="form-control" id="cfop" name="cfop" placeholder="5102"
                                        maxlength="4" value="<?= htmlspecialchars($produto['cfop'] ?? '') ?>">
                                </div>

                                <!-- Origem da Mercadoria -->
                                <div class="col-md-6 mb-3">
                                    <label for="origem" class="form-label">Origem da Mercadoria</label>
                                    <select class="form-select" id="origem" name="origem">
                                        <option value="">Selecione...</option>
                                        <option value="0" <?= ($produto['origem'] ?? '') === '0' ? 'selected' : '' ?>>0
                                            -
                                            Nacional</option>
                                        <option value="1" <?= ($produto['origem'] ?? '') === '1' ? 'selected' : '' ?>>1
                                            -
                                            Estrangeira (Importação direta)</option>
                                        <option value="2" <?= ($produto['origem'] ?? '') === '2' ? 'selected' : '' ?>>2
                                            -
                                            Estrangeira (Adquirida no mercado interno)</option>
                                        <option value="3" <?= ($produto['origem'] ?? '') === '3' ? 'selected' : '' ?>>3
                                            -
                                            Nacional com mais de 40% de conteúdo estrangeiro</option>
                                        <option value="4" <?= ($produto['origem'] ?? '') === '4' ? 'selected' : '' ?>>4
                                            -
                                            Nacional produzida através de processos produtivos básicos</option>
                                        <option value="5" <?= ($produto['origem'] ?? '') === '5' ? 'selected' : '' ?>>5
                                            -
                                            Nacional com menos de 40% de conteúdo estrangeiro</option>
                                        <option value="6" <?= ($produto['origem'] ?? '') === '6' ? 'selected' : '' ?>>6
                                            -
                                            Estrangeira (Importação direta) sem similar nacional</option>
                                        <option value="7" <?= ($produto['origem'] ?? '') === '7' ? 'selected' : '' ?>>7
                                            -
                                            Estrangeira (Adquirida no mercado interno) sem similar nacional</option>
                                        <option value="8" <?= ($produto['origem'] ?? '') === '8' ? 'selected' : '' ?>>8
                                            -
                                            Nacional com mais de 70% de conteúdo estrangeiro</option>
                                    </select>
                                </div>

                                <div class="col-12">
                                    <hr class="my-3">
                                </div>

                                <!-- ICMS -->
                                <div class="col-12 mb-3">
                                    <h6 class="text-primary"><i class="bi bi-receipt me-2"></i> ICMS</h6>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="cst_icms" class="form-label">CST/CSOSN ICMS</label>
                                    <select class="form-select" id="cst_icms" name="cst_icms">
                                        <option value="">Selecione...</option>
                                        <optgroup label="CST - Regime Normal">
                                            <option value="00" <?= ($produto['cst_icms'] ?? '') === '00' ? 'selected' : '' ?>>00 -
                                                Tributada integralmente</option>
                                            <option value="10" <?= ($produto['cst_icms'] ?? '') === '10' ? 'selected' : '' ?>>10 -
                                                Tributada com cobrança de ICMS por ST</option>
                                            <option value="20" <?= ($produto['cst_icms'] ?? '') === '20' ? 'selected' : '' ?>>20 -
                                                Com
                                                redução de BC</option>
                                            <option value="30" <?= ($produto['cst_icms'] ?? '') === '30' ? 'selected' : '' ?>>30 -
                                                Isenta ou não tributada com cobrança de ICMS por ST</option>
                                            <option value="40" <?= ($produto['cst_icms'] ?? '') === '40' ? 'selected' : '' ?>>40 -
                                                Isenta</option>
                                            <option value="41" <?= ($produto['cst_icms'] ?? '') === '41' ? 'selected' : '' ?>>41 -
                                                Não
                                                tributada</option>
                                            <option value="50" <?= ($produto['cst_icms'] ?? '') === '50' ? 'selected' : '' ?>>50 -
                                                Suspensão</option>
                                            <option value="51" <?= ($produto['cst_icms'] ?? '') === '51' ? 'selected' : '' ?>>51 -
                                                Diferimento</option>
                                            <option value="60" <?= ($produto['cst_icms'] ?? '') === '60' ? 'selected' : '' ?>>60 -
                                                ICMS
                                                cobrado anteriormente por ST</option>
                                            <option value="70" <?= ($produto['cst_icms'] ?? '') === '70' ? 'selected' : '' ?>>70 -
                                                Com
                                                redução de BC e cobrança de ICMS por ST</option>
                                            <option value="90" <?= ($produto['cst_icms'] ?? '') === '90' ? 'selected' : '' ?>>90 -
                                                Outras</option>
                                        </optgroup>
                                        <optgroup label="CSOSN - Simples Nacional">
                                            <option value="101" <?= ($produto['cst_icms'] ?? '') === '101' ? 'selected' : '' ?>>101
                                                -
                                                Tributada com permissão de crédito</option>
                                            <option value="102" <?= ($produto['cst_icms'] ?? '') === '102' ? 'selected' : '' ?>>102
                                                -
                                                Tributada sem permissão de crédito</option>
                                            <option value="103" <?= ($produto['cst_icms'] ?? '') === '103' ? 'selected' : '' ?>>103
                                                -
                                                Isenção do ICMS para faixa de receita bruta</option>
                                            <option value="201" <?= ($produto['cst_icms'] ?? '') === '201' ? 'selected' : '' ?>>201
                                                -
                                                Tributada com permissão de crédito e com cobrança do ICMS por ST
                                            </option>
                                            <option value="202" <?= ($produto['cst_icms'] ?? '') === '202' ? 'selected' : '' ?>>202
                                                -
                                                Tributada sem permissão de crédito e com cobrança do ICMS por ST
                                            </option>
                                            <option value="203" <?= ($produto['cst_icms'] ?? '') === '203' ? 'selected' : '' ?>>203
                                                -
                                                Isenção do ICMS para faixa de receita bruta e com cobrança do ICMS
                                                por
                                                ST</option>
                                            <option value="300" <?= ($produto['cst_icms'] ?? '') === '300' ? 'selected' : '' ?>>300
                                                -
                                                Imune</option>
                                            <option value="400" <?= ($produto['cst_icms'] ?? '') === '400' ? 'selected' : '' ?>>400
                                                -
                                                Não tributada</option>
                                            <option value="500" <?= ($produto['cst_icms'] ?? '') === '500' ? 'selected' : '' ?>>500
                                                -
                                                ICMS cobrado anteriormente por ST ou por antecipação</option>
                                            <option value="900" <?= ($produto['cst_icms'] ?? '') === '900' ? 'selected' : '' ?>>900
                                                -
                                                Outras</option>
                                        </optgroup>
                                    </select>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="aliquota_icms" class="form-label">Alíquota ICMS (%)</label>
                                    <input type="number" class="form-control" id="aliquota_icms" name="aliquota_icms"
                                        step="0.01" min="0" max="100" placeholder="0,00"
                                        value="<?= $produto['aliquota_icms'] ?? '' ?>">
                                </div>

                                <div class="col-12">
                                    <hr class="my-3">
                                </div>

                                <!-- PIS -->
                                <div class="col-12 mb-3">
                                    <h6 class="text-success"><i class="bi bi-calculator me-2"></i> PIS</h6>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="cst_pis" class="form-label">CST PIS</label>
                                    <select class="form-select" id="cst_pis" name="cst_pis">
                                        <option value="">Selecione...</option>
                                        <option value="01" <?= ($produto['cst_pis'] ?? '') === '01' ? 'selected' : '' ?>>01
                                            -
                                            Operação
                                            Tributável com Alíquota Básica</option>
                                        <option value="02" <?= ($produto['cst_pis'] ?? '') === '02' ? 'selected' : '' ?>>02
                                            -
                                            Operação
                                            Tributável com Alíquota Diferenciada</option>
                                        <option value="03" <?= ($produto['cst_pis'] ?? '') === '03' ? 'selected' : '' ?>>03
                                            -
                                            Operação
                                            Tributável com Alíquota por Unidade de Medida</option>
                                        <option value="04" <?= ($produto['cst_pis'] ?? '') === '04' ? 'selected' : '' ?>>04
                                            -
                                            Operação
                                            Tributável Monofásica</option>
                                        <option value="05" <?= ($produto['cst_pis'] ?? '') === '05' ? 'selected' : '' ?>>05
                                            -
                                            Operação
                                            Tributável por Substituição Tributária</option>
                                        <option value="06" <?= ($produto['cst_pis'] ?? '') === '06' ? 'selected' : '' ?>>06
                                            -
                                            Operação
                                            Tributável a Alíquota Zero</option>
                                        <option value="07" <?= ($produto['cst_pis'] ?? '') === '07' ? 'selected' : '' ?>>07
                                            -
                                            Operação
                                            Isenta da Contribuição</option>
                                        <option value="08" <?= ($produto['cst_pis'] ?? '') === '08' ? 'selected' : '' ?>>08
                                            -
                                            Operação
                                            sem Incidência da Contribuição</option>
                                        <option value="09" <?= ($produto['cst_pis'] ?? '') === '09' ? 'selected' : '' ?>>09
                                            -
                                            Operação
                                            com Suspensão da Contribuição</option>
                                        <option value="49" <?= ($produto['cst_pis'] ?? '') === '49' ? 'selected' : '' ?>>49
                                            -
                                            Outras
                                            Operações de Saída</option>
                                        <option value="50" <?= ($produto['cst_pis'] ?? '') === '50' ? 'selected' : '' ?>>50
                                            -
                                            Operação
                                            com Direito a Crédito - Vinculada a Receita Tributada</option>
                                        <option value="99" <?= ($produto['cst_pis'] ?? '') === '99' ? 'selected' : '' ?>>99
                                            -
                                            Outras
                                            Operações</option>
                                    </select>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="aliquota_pis" class="form-label">Alíquota PIS (%)</label>
                                    <input type="number" class="form-control" id="aliquota_pis" name="aliquota_pis"
                                        step="0.01" min="0" max="100" placeholder="0,00"
                                        value="<?= $produto['aliquota_pis'] ?? '' ?>">
                                </div>

                                <div class="col-12">
                                    <hr class="my-3">
                                </div>

                                <!-- COFINS -->
                                <div class="col-12 mb-3">
                                    <h6 class="text-info"><i class="bi bi-cash-stack me-2"></i> COFINS</h6>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="cst_cofins" class="form-label">CST COFINS</label>
                                    <select class="form-select" id="cst_cofins" name="cst_cofins">
                                        <option value="">Selecione...</option>
                                        <option value="01" <?= ($produto['cst_cofins'] ?? '') === '01' ? 'selected' : '' ?>>01 -
                                            Operação Tributável com Alíquota Básica</option>
                                        <option value="02" <?= ($produto['cst_cofins'] ?? '') === '02' ? 'selected' : '' ?>>02 -
                                            Operação Tributável com Alíquota Diferenciada</option>
                                        <option value="03" <?= ($produto['cst_cofins'] ?? '') === '03' ? 'selected' : '' ?>>03 -
                                            Operação Tributável com Alíquota por Unidade de Medida</option>
                                        <option value="04" <?= ($produto['cst_cofins'] ?? '') === '04' ? 'selected' : '' ?>>04 -
                                            Operação Tributável Monofásica</option>
                                        <option value="05" <?= ($produto['cst_cofins'] ?? '') === '05' ? 'selected' : '' ?>>05 -
                                            Operação Tributável por Substituição Tributária</option>
                                        <option value="06" <?= ($produto['cst_cofins'] ?? '') === '06' ? 'selected' : '' ?>>06 -
                                            Operação Tributável a Alíquota Zero</option>
                                        <option value="07" <?= ($produto['cst_cofins'] ?? '') === '07' ? 'selected' : '' ?>>07 -
                                            Operação Isenta da Contribuição</option>
                                        <option value="08" <?= ($produto['cst_cofins'] ?? '') === '08' ? 'selected' : '' ?>>08 -
                                            Operação sem Incidência da Contribuição</option>
                                        <option value="09" <?= ($produto['cst_cofins'] ?? '') === '09' ? 'selected' : '' ?>>09 -
                                            Operação com Suspensão da Contribuição</option>
                                        <option value="49" <?= ($produto['cst_cofins'] ?? '') === '49' ? 'selected' : '' ?>>49 -
                                            Outras
                                            Operações de Saída</option>
                                        <option value="50" <?= ($produto['cst_cofins'] ?? '') === '50' ? 'selected' : '' ?>>50 -
                                            Operação com Direito a Crédito - Vinculada a Receita Tributada</option>
                                        <option value="99" <?= ($produto['cst_cofins'] ?? '') === '99' ? 'selected' : '' ?>>99 -
                                            Outras
                                            Operações</option>
                                    </select>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="aliquota_cofins" class="form-label">Alíquota COFINS (%)</label>
                                    <input type="number" class="form-control" id="aliquota_cofins"
                                        name="aliquota_cofins" step="0.01" min="0" max="100" placeholder="0,00"
                                        value="<?= $produto['aliquota_cofins'] ?? '' ?>">
                                </div>

                                <div class="col-12">
                                    <hr class="my-3">
                                </div>

                                <!-- IPI -->
                                <div class="col-12 mb-3">
                                    <h6 class="text-warning"><i class="bi bi-tag me-2"></i> IPI</h6>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="cst_ipi" class="form-label">CST IPI</label>
                                    <select class="form-select" id="cst_ipi" name="cst_ipi">
                                        <option value="">Selecione...</option>
                                        <option value="00" <?= ($produto['cst_ipi'] ?? '') === '00' ? 'selected' : '' ?>>00
                                            -
                                            Entrada
                                            com Recuperação de Crédito</option>
                                        <option value="01" <?= ($produto['cst_ipi'] ?? '') === '01' ? 'selected' : '' ?>>01
                                            -
                                            Entrada
                                            Tributada com Alíquota Zero</option>
                                        <option value="02" <?= ($produto['cst_ipi'] ?? '') === '02' ? 'selected' : '' ?>>02
                                            -
                                            Entrada
                                            Isenta</option>
                                        <option value="03" <?= ($produto['cst_ipi'] ?? '') === '03' ? 'selected' : '' ?>>03
                                            -
                                            Entrada
                                            Não-Tributada</option>
                                        <option value="04" <?= ($produto['cst_ipi'] ?? '') === '04' ? 'selected' : '' ?>>04
                                            -
                                            Entrada
                                            Imune</option>
                                        <option value="05" <?= ($produto['cst_ipi'] ?? '') === '05' ? 'selected' : '' ?>>05
                                            -
                                            Entrada
                                            com Suspensão</option>
                                        <option value="49" <?= ($produto['cst_ipi'] ?? '') === '49' ? 'selected' : '' ?>>49
                                            -
                                            Outras
                                            Entradas</option>
                                        <option value="50" <?= ($produto['cst_ipi'] ?? '') === '50' ? 'selected' : '' ?>>50
                                            - Saída
                                            Tributada</option>
                                        <option value="51" <?= ($produto['cst_ipi'] ?? '') === '51' ? 'selected' : '' ?>>51
                                            - Saída
                                            Tributada com Alíquota Zero</option>
                                        <option value="52" <?= ($produto['cst_ipi'] ?? '') === '52' ? 'selected' : '' ?>>52
                                            - Saída
                                            Isenta</option>
                                        <option value="53" <?= ($produto['cst_ipi'] ?? '') === '53' ? 'selected' : '' ?>>53
                                            - Saída
                                            Não-Tributada</option>
                                        <option value="54" <?= ($produto['cst_ipi'] ?? '') === '54' ? 'selected' : '' ?>>54
                                            - Saída
                                            Imune</option>
                                        <option value="55" <?= ($produto['cst_ipi'] ?? '') === '55' ? 'selected' : '' ?>>55
                                            - Saída
                                            com
                                            Suspensão</option>
                                        <option value="99" <?= ($produto['cst_ipi'] ?? '') === '99' ? 'selected' : '' ?>>99
                                            -
                                            Outras
                                            Saídas</option>
                                    </select>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="aliquota_ipi" class="form-label">Alíquota IPI (%)</label>
                                    <input type="number" class="form-control" id="aliquota_ipi" name="aliquota_ipi"
                                        step="0.01" min="0" max="100" placeholder="0,00"
                                        value="<?= $produto['aliquota_ipi'] ?? '' ?>">
                                </div>
                            </div>
                        </div>
                        <!-- Fim div_campos_tributacao -->

                        <!-- Tributação NFS-e (apenas para serviços) -->
                        <div id="nfse-tributacao-section" style="display: none;">
                            <div class="row mt-4">
                                <div class="col-12">
                                    <hr class="my-4">
                                    <h6 class="text-info mb-3">
                                        <i class="bi bi-building me-2"></i> Tributação NFS-e (Nota Fiscal de Serviço
                                        Eletrônica)
                                    </h6>
                                    <div class="alert alert-info">
                                        <small>
                                            <i class="bi bi-info-circle me-1"></i>
                                            Configure a tributação NFS-e para que os dados sejam preenchidos
                                            automaticamente ao emitir nota fiscal de serviço.
                                        </small>
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="nfse_codigo_servico" class="form-label">Código do Serviço (Item Lista
                                        Municipal)</label>
                                    <input type="text" class="form-control" id="nfse_codigo_servico"
                                        name="nfse_codigo_servico" placeholder="Ex: 0107" maxlength="20"
                                        value="<?= htmlspecialchars($produto['nfse_codigo_servico'] ?? '') ?>">
                                    <small class="text-muted">Código da lista de serviços do município</small>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="nfse_codigo_tributacao" class="form-label">Código de Tributação</label>
                                    <input type="text" class="form-control" id="nfse_codigo_tributacao"
                                        name="nfse_codigo_tributacao" placeholder="Código municipal" maxlength="20"
                                        value="<?= htmlspecialchars($produto['nfse_codigo_tributacao'] ?? '') ?>">
                                    <small class="text-muted">Código de tributação municipal (se diferente do código do
                                        serviço)</small>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="nfse_aliquota_iss" class="form-label">Alíquota ISS (%)</label>
                                    <input type="number" class="form-control" id="nfse_aliquota_iss"
                                        name="nfse_aliquota_iss" step="0.01" min="0" max="100" placeholder="0.00"
                                        value="<?= htmlspecialchars($produto['nfse_aliquota_iss'] ?? '') ?>">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="nfse_natureza_operacao" class="form-label">Natureza da Operação</label>
                                    <select class="form-select" id="nfse_natureza_operacao"
                                        name="nfse_natureza_operacao">
                                        <option value="1" <?= ($produto['nfse_natureza_operacao'] ?? '1') === '1' ? 'selected' : '' ?>>01 - Tributação no município</option>
                                        <option value="2" <?= ($produto['nfse_natureza_operacao'] ?? '') === '2' ? 'selected' : '' ?>>02 - Tributação fora do município</option>
                                        <option value="3" <?= ($produto['nfse_natureza_operacao'] ?? '') === '3' ? 'selected' : '' ?>>03 - Isenção</option>
                                        <option value="4" <?= ($produto['nfse_natureza_operacao'] ?? '') === '4' ? 'selected' : '' ?>>04 - Imune</option>
                                        <option value="5" <?= ($produto['nfse_natureza_operacao'] ?? '') === '5' ? 'selected' : '' ?>>05 - Suspensa por decisão judicial</option>
                                        <option value="6" <?= ($produto['nfse_natureza_operacao'] ?? '') === '6' ? 'selected' : '' ?>>06 - Suspensa por procedimento administrativo</option>
                                    </select>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="nfse_regime_tributacao" class="form-label">Regime Especial de
                                        Tributação</label>
                                    <select class="form-select" id="nfse_regime_tributacao"
                                        name="nfse_regime_tributacao">
                                        <option value="" <?= empty($produto['nfse_regime_tributacao'] ?? '') ? 'selected' : '' ?>>(Não informado)</option>
                                        <option value="1" <?= ($produto['nfse_regime_tributacao'] ?? '') === '1' ? 'selected' : '' ?>>01 - Microempresa Municipal</option>
                                        <option value="2" <?= ($produto['nfse_regime_tributacao'] ?? '') === '2' ? 'selected' : '' ?>>02 - Estimativa</option>
                                        <option value="3" <?= ($produto['nfse_regime_tributacao'] ?? '') === '3' ? 'selected' : '' ?>>03 - Sociedade de Profissionais</option>
                                        <option value="4" <?= ($produto['nfse_regime_tributacao'] ?? '') === '4' ? 'selected' : '' ?>>04 - Cooperativa</option>
                                        <option value="5" <?= ($produto['nfse_regime_tributacao'] ?? '') === '5' ? 'selected' : '' ?>>05 - MEI</option>
                                        <option value="6" <?= ($produto['nfse_regime_tributacao'] ?? '') === '6' ? 'selected' : '' ?>>06 - ME/EPP</option>
                                    </select>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="nfse_optante_simples" class="form-label">Optante Simples
                                        Nacional</label>
                                    <select class="form-select" id="nfse_optante_simples" name="nfse_optante_simples">
                                        <option value="1" <?= ($produto['nfse_optante_simples'] ?? '2') === '1' ? 'selected' : '' ?>>Sim</option>
                                        <option value="2" <?= ($produto['nfse_optante_simples'] ?? '2') === '2' ? 'selected' : '' ?>>Não</option>
                                    </select>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="nfse_iss_retido" class="form-label">ISS Retido</label>
                                    <select class="form-select" id="nfse_iss_retido" name="nfse_iss_retido">
                                        <option value="1" <?= ($produto['nfse_iss_retido'] ?? '2') === '1' ? 'selected' : '' ?>>Sim</option>
                                        <option value="2" <?= ($produto['nfse_iss_retido'] ?? '2') === '2' ? 'selected' : '' ?>>Não</option>
                                    </select>
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label for="nfse_descricao" class="form-label">Descrição do Serviço (NFS-e)</label>
                                    <textarea class="form-control" id="nfse_descricao" name="nfse_descricao" rows="3"
                                        placeholder="Descrição padrão do serviço que será usada na NFS-e"><?= htmlspecialchars($produto['nfse_descricao'] ?? '') ?></textarea>
                                    <small class="text-muted">Deixe em branco para usar a descrição padrão ou a
                                        descrição do produto</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Estoque -->
    <div class="tab-pane fade" id="estoque" role="tabpanel">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-box me-2"></i> Controle de Estoque
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <?php if (!$isEdit): ?>
                                <div class="col-md-4 mb-3">
                                    <label for="stock_quantity" class="form-label">
                                        Quantidade Inicial
                                    </label>
                                    <input type="number" class="form-control" id="stock_quantity" name="stock_quantity"
                                        min="0" placeholder="0" value="<?= $produto['stock_quantity'] ?? '' ?>">
                                </div>
                            <?php endif; ?>
                            <div class="col-md-4 mb-3">
                                <label for="min_stock" class="form-label">Estoque Mínimo</label>
                                <input type="number" class="form-control" id="min_stock" name="min_stock" min="0"
                                    placeholder="0" value="<?= $produto['min_stock'] ?? '' ?>">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="max_stock" class="form-label">Estoque Máximo</label>
                                <input type="number" class="form-control" id="max_stock" name="max_stock" min="0"
                                    placeholder="0" value="<?= $produto['max_stock'] ?? '' ?>">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="weight" class="form-label">Peso (kg)</label>
                                <input type="number" class="form-control" id="weight" name="weight" step="0.001" min="0"
                                    placeholder="0,000" value="<?= $weightValueFormatted ?>">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="quantidade_embalagem" class="form-label">Quantidade da Embalagem</label>
                                <?php
                                $qtdEmbalagem = $produto['quantidade_embalagem'] ?? '';
                                $qtdEmbalagem = ($qtdEmbalagem === '' || $qtdEmbalagem === null || $qtdEmbalagem === '0') ? '1' : $qtdEmbalagem;
                                ?>
                                <input type="number" class="form-control" id="quantidade_embalagem"
                                    name="quantidade_embalagem" step="1" min="1" placeholder="1"
                                    value="<?= htmlspecialchars($qtdEmbalagem) ?>">
                                <small class="text-muted">Quantidade de unidades por embalagem</small>
                            </div>

                            <div class="col-12">
                                <hr class="my-3">
                            </div>

                            <div class="col-12 mb-3">
                                <h6 class="text-info"><i class="bi bi-geo-alt me-2"></i> Localização do Estoque</h6>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="stock_entry_location" class="form-label">Local de Entrada</label>
                                <select class="form-select" id="stock_entry_location" name="stock_entry_location">
                                    <option value="">Selecione um local...</option>
                                    <?php if (!empty($locaisEstoque)): ?>
                                        <?php foreach ($locaisEstoque as $local): ?>
                                            <?php
                                            // Mostrar apenas locais de entrada ou ambos
                                            $mostrar = in_array($local['tipo'] ?? '', ['entrada', 'ambos', 'geral']);
                                            if ($mostrar):
                                                // Verificar se o valor atual é ID (numérico) ou nome (texto antigo)
                                                $valorAtual = $produto['stock_entry_location'] ?? '';
                                                $isSelected = false;
                                                if (is_numeric($valorAtual)) {
                                                    $isSelected = ($valorAtual == $local['id']);
                                                } else {
                                                    // Compatibilidade com valores antigos (texto)
                                                    $isSelected = ($valorAtual == $local['name']);
                                                }
                                                ?>
                                                <option value="<?= htmlspecialchars($local['id']) ?>" <?= $isSelected ? 'selected' : '' ?>>
                                                    <?= htmlspecialchars($local['name']) ?>
                                                </option>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                                <small class="text-muted">Selecione o local de entrada do estoque</small>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="stock_exit_location" class="form-label">Local de Saída</label>
                                <select class="form-select" id="stock_exit_location" name="stock_exit_location">
                                    <option value="">Selecione um local...</option>
                                    <?php if (!empty($locaisEstoque)): ?>
                                        <?php foreach ($locaisEstoque as $local): ?>
                                            <?php
                                            // Mostrar apenas locais de saída ou ambos
                                            $mostrar = in_array($local['tipo'] ?? '', ['saida', 'ambos', 'geral']);
                                            if ($mostrar):
                                                // Verificar se o valor atual é ID (numérico) ou nome (texto antigo)
                                                $valorAtual = $produto['stock_exit_location'] ?? '';
                                                $isSelected = false;
                                                if (is_numeric($valorAtual)) {
                                                    $isSelected = ($valorAtual == $local['id']);
                                                } else {
                                                    // Compatibilidade com valores antigos (texto)
                                                    $isSelected = ($valorAtual == $local['name']);
                                                }
                                                ?>
                                                <option value="<?= htmlspecialchars($local['id']) ?>" <?= $isSelected ? 'selected' : '' ?>>
                                                    <?= htmlspecialchars($local['name']) ?>
                                                </option>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                                <small class="text-muted">Selecione o local de saída do estoque</small>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label for="stock_address" class="form-label">Armazenagem</label>
                                <?php
                                // Valor atual salvo para passar para o JavaScript
                                $stockAddressValue = $produto['stock_address'] ?? '';
                                ?>
                                <select class="form-select" id="stock_address" name="stock_address">
                                    <option value="">Selecione uma posição...</option>
                                </select>
                                <small class="text-muted">Selecione a posição de armazenagem baseada no local de
                                    saída</small>
                            </div>

                            <div class="col-12">
                                <hr class="my-3">
                            </div>

                            <script>
                                    (function () {
                                        // Função para carregar posições do local de estoque
                                        function carregarPosicoesEstoque(localEstoqueId, valorSelecionado) {
                                            console.log('=== carregarPosicoesEstoque ===');
                                            console.log('localEstoqueId:', localEstoqueId);
                                            console.log('valorSelecionado:', valorSelecionado);

                                            const selectArmazenagem = $('#stock_address');

                                            if (!localEstoqueId) {
                                                console.log('Nenhum local selecionado, desabilitando campo');
                                                selectArmazenagem.html('<option value="">Selecione uma posição...</option>');
                                                selectArmazenagem.prop('disabled', true);
                                                return;
                                            }

                                            selectArmazenagem.prop('disabled', false);
                                            selectArmazenagem.html('<option value="">Carregando posições...</option>');

                                            // Determinar a rota base (produtos ou itens)
                                            const routeBase = window.location.pathname.includes('/itens') ? '/itens' : '/produtos';

                                            // Montar URL - tentar usar appUrl se existir
                                            let url;
                                            if (typeof window.appUrl === 'function') {
                                                url = window.appUrl(routeBase + '/buscar-posicoes-estoque?local_estoque_id=' + localEstoqueId);
                                            } else if (typeof appUrl === 'function') {
                                                url = appUrl(routeBase + '/buscar-posicoes-estoque?local_estoque_id=' + localEstoqueId);
                                            } else {
                                                // Montar URL manualmente usando pathname atual
                                                const pathParts = window.location.pathname.split('/').filter(p => p);
                                                // Encontrar se está em /itens ou /produtos
                                                const currentRoute = pathParts.includes('itens') ? 'itens' : (pathParts.includes('produtos') ? 'produtos' : 'produtos');
                                                // Remover 'itens' ou 'produtos' e 'editar' ou 'criar' do path
                                                const baseParts = pathParts.filter(p => !['itens', 'produtos', 'editar', 'criar'].includes(p));
                                                const basePath = baseParts.length > 0 ? '/' + baseParts.join('/') : '';
                                                url = basePath + '/' + currentRoute + '/buscar-posicoes-estoque?local_estoque_id=' + localEstoqueId;
                                            }

                                            console.log('Fazendo requisição para:', url);
                                            console.log('routeBase:', routeBase);
                                            console.log('localEstoqueId:', localEstoqueId);
                                            console.log('window.location.pathname:', window.location.pathname);

                                            $.ajax({
                                                url: url,
                                                type: 'GET',
                                                dataType: 'json',
                                                success: function (response) {
                                                    console.log('Resposta recebida:', response);
                                                    if (response.success && response.data && response.data.length > 0) {
                                                        console.log('Posições encontradas:', response.data.length);
                                                        let options = '<option value="">Selecione uma posição...</option>';
                                                        response.data.forEach(function (posicao) {
                                                            const selected = (valorSelecionado && valorSelecionado == posicao.posicao) ? 'selected' : '';
                                                            options += `<option value="${posicao.posicao}" ${selected}>${posicao.posicao}</option>`;
                                                        });
                                                        selectArmazenagem.html(options);
                                                        console.log('Posições adicionadas ao select:', response.data.length);
                                                    } else {
                                                        console.warn('Nenhuma posição encontrada para este local');
                                                        selectArmazenagem.html('<option value="">Nenhuma posição cadastrada para este local</option>');
                                                    }
                                                },
                                                error: function (xhr, status, error) {
                                                    console.error('✗ ERRO ao carregar posições:');
                                                    console.error('Status:', status);
                                                    console.error('Error:', error);
                                                    console.error('Response Text:', xhr.responseText);
                                                    console.error('Status Code:', xhr.status);
                                                    selectArmazenagem.html('<option value="">Erro ao carregar posições. Verifique o console.</option>');
                                                }
                                            });
                                        }

                                        // Aguardar jQuery estar disponível
                                        (function aguardarJQuery() {
                                            if (typeof jQuery === 'undefined' || typeof $ === 'undefined') {
                                                setTimeout(aguardarJQuery, 100);
                                                return;
                                            }

                                            // Quando o documento estiver pronto
                                            $(document).ready(function () {
                                                console.log('Documento pronto, inicializando eventos de local de estoque...');
                                                const selectLocalSaida = $('#stock_exit_location');
                                                const selectArmazenagem = $('#stock_address');

                                                // Verificar se os elementos existem
                                                if (selectLocalSaida.length === 0) {
                                                    console.error('Select #stock_exit_location não encontrado!');
                                                    return;
                                                }
                                                if (selectArmazenagem.length === 0) {
                                                    console.error('Select #stock_address não encontrado!');
                                                    return;
                                                }

                                                // Valor atual salvo
                                                const valorAtualArmazenagem = '<?= htmlspecialchars($stockAddressValue ?? '') ?>';
                                                const valorAtualLocalSaida = selectLocalSaida.val();

                                                console.log('Valor atual local saída:', valorAtualLocalSaida);
                                                console.log('Valor atual armazenagem:', valorAtualArmazenagem);

                                                // Carregar posições se já houver um local de saída selecionado
                                                if (valorAtualLocalSaida) {
                                                    console.log('Carregando posições para local já selecionado:', valorAtualLocalSaida);
                                                    carregarPosicoesEstoque(valorAtualLocalSaida, valorAtualArmazenagem);
                                                } else {
                                                    // Se não houver local selecionado, desabilitar o campo
                                                    selectArmazenagem.prop('disabled', true);
                                                }

                                                // Evento quando o local de saída mudar (jQuery)
                                                selectLocalSaida.on('change', function (e) {
                                                    console.log('✓ Evento change jQuery disparado no select de local de saída');
                                                    const localEstoqueId = $(this).val();
                                                    console.log('Local de estoque selecionado:', localEstoqueId);
                                                    if (localEstoqueId) {
                                                        carregarPosicoesEstoque(localEstoqueId, '');
                                                    } else {
                                                        selectArmazenagem.prop('disabled', true);
                                                        selectArmazenagem.html('<option value="">Selecione uma posição...</option>');
                                                    }
                                                });

                                                // Também adicionar listener com evento nativo para garantir (fallback)
                                                if (selectLocalSaida[0]) {
                                                    selectLocalSaida[0].addEventListener('change', function (e) {
                                                        console.log('✓ Evento change nativo disparado');
                                                        const localEstoqueId = this.value;
                                                        console.log('Valor do select (nativo):', localEstoqueId);
                                                        if (localEstoqueId) {
                                                            carregarPosicoesEstoque(localEstoqueId, '');
                                                        }
                                                    }, true);
                                                }
                                            });
                                        })();
                                    })();
                            </script>

                            <div class="col-12 mb-3">
                                <h6 class="text-warning"><i class="bi bi-rulers me-2"></i> Dimensões (cm)</h6>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="height_cm" class="form-label">Altura (cm)</label>
                                <input type="number" class="form-control" id="height_cm" name="height_cm" step="0.01"
                                    min="0" placeholder="0,00" value="<?= $heightValueFormatted ?>">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="width_cm" class="form-label">Largura (cm)</label>
                                <input type="number" class="form-control" id="width_cm" name="width_cm" step="0.01"
                                    min="0" placeholder="0,00" value="<?= $widthValueFormatted ?>">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="length_cm" class="form-label">Comprimento (cm)</label>
                                <input type="number" class="form-control" id="length_cm" name="length_cm" step="0.01"
                                    min="0" placeholder="0,00" value="<?= $lengthValueFormatted ?>">
                            </div>
                        </div>
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle me-2"></i>
                            <strong>Atenção:</strong> Configure os limites de estoque para receber alertas
                            automáticos.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Configurações -->
    <div class="tab-pane fade" id="configuracoes" role="tabpanel">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-gear me-2"></i> Configurações do Produto
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Status e Flags -->
                            <div class="col-md-3 mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="is_active" name="is_active"
                                        value="1" <?= ($produto['is_active'] ?? 1) ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="is_active">
                                        <i class="bi bi-toggle-on me-1"></i> Ativo
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-3 mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="consumo_proprio"
                                        name="consumo_proprio" value="1" <?= ($produto['consumo_proprio'] ?? 0) ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="consumo_proprio">
                                        <i class="bi bi-house me-1"></i> Consumo Próprio
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-3 mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="balanca" name="balanca"
                                        value="1" <?= ($produto['balanca'] ?? 0) ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="balanca">
                                        <i class="bi bi-speedometer me-1"></i> Balança
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-3 mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="fracionado" name="fracionado"
                                        value="1" <?= ($produto['fracionado'] ?? 0) ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="fracionado">
                                        <i class="bi bi-scissors me-1"></i> Fracionado
                                    </label>
                                </div>
                            </div>

                            <div class="col-12">
                                <hr class="my-3">
                            </div>

                            <!-- Campos ANVISA -->
                            <div class="col-md-12 mb-3">
                                <h6 class="mb-3">
                                    <i class="bi bi-file-medical me-2"></i> Dados ANVISA
                                </h6>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="anvisa" class="form-label">Anvisa</label>
                                <input type="text" class="form-control" id="anvisa" name="anvisa"
                                    value="<?= htmlspecialchars($produto['anvisa'] ?? '') ?>"
                                    placeholder="Número Anvisa">
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="validade_anvisa" class="form-label">Validade Anvisa</label>
                                <div class="input-group">
                                    <input type="date" class="form-control" id="validade_anvisa" name="validade_anvisa"
                                        value="<?= !empty($produto['validade_anvisa']) ? date('Y-m-d', strtotime($produto['validade_anvisa'])) : '' ?>"
                                        placeholder="DD/MM/AAAA">
                                    <span class="input-group-text">
                                        <i class="bi bi-calendar"></i>
                                    </span>
                                </div>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="classificacao_risco" class="form-label">Classificação Risco</label>
                                <input type="text" class="form-control" id="classificacao_risco"
                                    name="classificacao_risco"
                                    value="<?= htmlspecialchars($produto['classificacao_risco'] ?? '') ?>"
                                    placeholder="Classificação de risco">
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="codigo_simpro" class="form-label">Código SIMPRO</label>
                                <input type="text" class="form-control" id="codigo_simpro" name="codigo_simpro"
                                    value="<?= htmlspecialchars($produto['codigo_simpro'] ?? '') ?>"
                                    placeholder="Código SIMPRO">
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="codigo_sus" class="form-label">Código SUS</label>
                                <input type="text" class="form-control" id="codigo_sus" name="codigo_sus"
                                    value="<?= htmlspecialchars($produto['codigo_sus'] ?? '') ?>"
                                    placeholder="Código SUS">
                            </div>

                            <div class="col-12">
                                <hr class="my-3">
                            </div>

                            <div class="col-md-12 mb-3">
                                <label for="image" class="form-label">Imagem do Produto</label>
                                <input type="file" class="form-control" id="image" name="image" accept="image/*">
                                <?php if ($isEdit && !empty($produto['image'])): ?>
                                    <div class="mt-2">
                                        <img src="<?= htmlspecialchars($produto['image']) ?>" alt="Imagem atual"
                                            class="img-thumbnail" style="max-width: 150px;">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Montagem de Kit -->
    <div class="tab-pane fade" id="kit" role="tabpanel">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-box-seam me-2"></i> Montagem de Kit
                    </div>
                    <div class="card-body">
                        <p class="text-muted mb-4">
                            <i class="bi bi-info-circle me-2"></i>
                            Adicione produtos que compõem este kit. O sistema calculará automaticamente o custo
                            total
                            baseado nos produtos selecionados.
                        </p>

                        <!-- Bloco para adicionar produto ao kit -->
                        <div class="card bg-light mb-4">
                            <div class="card-body">
                                <h6 class="mb-3"><i class="bi bi-plus-circle me-2"></i> Adicionar Produto ao Kit
                                </h6>
                                <div class="row g-3 align-items-end">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Produto *</label>
                                        <div class="position-relative">
                                            <input type="text" class="form-control" id="kit_produto_search"
                                                placeholder="Digite para buscar produto..." autocomplete="off">
                                            <div id="kit_produto_dropdown" class="autocomplete-dropdown"
                                                style="display: none;"></div>
                                        </div>
                                        <input type="hidden" id="kit_produto_id" value="">
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">Quantidade *</label>
                                        <input type="number" class="form-control" id="kit_quantidade" step="0.01"
                                            min="0.01" placeholder="1,00" value="1">
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label d-block">&nbsp;</label>
                                        <button type="button" class="btn btn-success w-100"
                                            onclick="adicionarItemKit()">
                                            <i class="bi bi-plus-circle me-1"></i> Adicionar
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Lista de produtos do kit -->
                        <div id="lista-kit">
                            <div class="alert alert-info" id="alert-sem-kit">
                                <i class="bi bi-info-circle me-2"></i>
                                Nenhum produto adicionado ao kit.
                            </div>
                            <div id="tabela-kit" style="display: none;">
                                <table class="table table-sm table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Produto</th>
                                            <th width="120">SKU</th>
                                            <th width="120">Quantidade</th>
                                            <th width="120">Preço Unit.</th>
                                            <th width="120">Subtotal</th>
                                            <th width="80">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tbody-kit">
                                        <!-- Itens do kit serão adicionados aqui via JavaScript -->
                                    </tbody>
                                    <tfoot class="table-light">
                                        <tr>
                                            <th colspan="4" class="text-end">Total do Kit:</th>
                                            <th class="text-success" id="kit-total">R$ 0,00</th>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                                <div class="alert alert-success mt-2">
                                    <i class="bi bi-check-circle me-2"></i>
                                    <strong id="total-kit">0</strong> produto(s) no kit
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Formulação (Ficha Técnica) -->
    <div class="tab-pane fade" id="formulacao" role="tabpanel">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-clipboard-data me-2"></i> Formulação de Produto (Ficha Técnica)
                    </div>
                    <div class="card-body">
                        <p class="text-muted mb-4">
                            <i class="bi bi-info-circle me-2"></i>
                            Defina os ingredientes e componentes necessários para produzir este produto.
                            Esta ficha técnica será usada para calcular custos de produção e controlar estoque de
                            matérias-primas.
                        </p>

                        <!-- Bloco para adicionar ingrediente -->
                        <div class="card bg-light mb-4">
                            <div class="card-body">
                                <h6 class="mb-3"><i class="bi bi-plus-circle me-2"></i> Adicionar Ingrediente</h6>
                                <div class="row g-3 align-items-end">
                                    <div class="col-md-5 mb-3">
                                        <label class="form-label">Ingrediente/Matéria-Prima *</label>
                                        <div class="position-relative">
                                            <input type="text" class="form-control" id="formulacao_ingrediente_search"
                                                placeholder="Digite para buscar produto/ingrediente..."
                                                autocomplete="off">
                                            <div id="formulacao_ingrediente_dropdown" class="autocomplete-dropdown"
                                                style="display: none;"></div>
                                        </div>
                                        <input type="hidden" id="formulacao_ingrediente_id" value="">
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <label class="form-label">Quantidade *</label>
                                        <input type="number" class="form-control" id="formulacao_quantidade"
                                            step="0.0001" min="0.0001" placeholder="0,0000" value="1">
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <label class="form-label">Unidade</label>
                                        <select class="form-select" id="formulacao_unidade">
                                            <option value="UN">UN</option>
                                            <option value="KG">KG</option>
                                            <option value="G">G</option>
                                            <option value="L">L</option>
                                            <option value="ML">ML</option>
                                            <option value="M">M</option>
                                            <option value="M2">M²</option>
                                            <option value="M3">M³</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label d-block">&nbsp;</label>
                                        <button type="button" class="btn btn-success w-100"
                                            onclick="adicionarIngredienteFormulacao()">
                                            <i class="bi bi-plus-circle me-1"></i> Adicionar
                                        </button>
                                    </div>
                                    <div class="col-md-12 mb-3">
                                        <label class="form-label">Observações (opcional)</label>
                                        <input type="text" class="form-control" id="formulacao_observacoes"
                                            placeholder="Ex: Adicionar no início do processo, temperatura ambiente, etc.">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Lista de ingredientes da formulação -->
                        <div id="lista-formulacao">
                            <div class="alert alert-info" id="alert-sem-formulacao">
                                <i class="bi bi-info-circle me-2"></i>
                                Nenhum ingrediente adicionado à formulação.
                            </div>
                            <div id="tabela-formulacao" style="display: none;">
                                <table class="table table-sm table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th width="50">#</th>
                                            <th>Ingrediente</th>
                                            <th width="120">SKU</th>
                                            <th width="150">Quantidade</th>
                                            <th width="100">Unidade</th>
                                            <th>Observações</th>
                                            <th width="100">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tbody-formulacao">
                                        <!-- Ingredientes serão adicionados aqui via JavaScript -->
                                    </tbody>
                                </table>
                                <div class="alert alert-success mt-2">
                                    <i class="bi bi-check-circle me-2"></i>
                                    <strong id="total-formulacao">0</strong> ingrediente(s) na formulação
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Empresas -->
    <div class="tab-pane fade" id="empresas" role="tabpanel">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-building me-2"></i> Empresas que podem vender este produto
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label mb-3">
                                <i class="bi bi-building me-1"></i> Empresas Vinculadas
                            </label>
                            <div class="card border">
                                <div class="card-body p-3" style="max-height: 350px; overflow-y: auto;">
                                    <div class="mb-3 pb-3 border-bottom bg-light rounded p-2 sticky-top">
                                        <div class="modern-switch-wrapper">
                                            <input type="checkbox" class="modern-switch-input"
                                                id="marcar_todas_empresas_produto">
                                            <label class="modern-switch-label" for="marcar_todas_empresas_produto">
                                                <span class="modern-switch-slider"></span>
                                                <span class="modern-switch-text fw-bold">
                                                    <i class="bi bi-check-all me-1"></i> Marcar todas
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                    <div id="empresas_produto_list">
                                        <?php if (!empty($todasEmpresas ?? [])): ?>
                                            <?php
                                            $empresasVinculadasIds = array_map('intval', $empresasVinculadas ?? []);
                                            foreach ($todasEmpresas as $empresa):
                                                $isChecked = in_array((int) $empresa['id'], $empresasVinculadasIds);
                                                ?>
                                                <div class="modern-switch-wrapper empresa-item-wrapper mb-2"
                                                    style="padding: 10px 12px;">
                                                    <input type="checkbox" class="modern-switch-input empresa-produto-checkbox"
                                                        value="<?= $empresa['id'] ?>" id="empresa_produto_<?= $empresa['id'] ?>"
                                                        <?= $isChecked ? 'checked' : '' ?>>
                                                    <label class="modern-switch-label"
                                                        for="empresa_produto_<?= $empresa['id'] ?>">
                                                        <span class="modern-switch-slider"></span>
                                                        <span class="modern-switch-text">
                                                            <div class="fw-medium">
                                                                <?= htmlspecialchars($empresa['razao_social']) ?>
                                                            </div>
                                                            <?php if (!empty($empresa['cnpj'])): ?>
                                                                <small class="text-muted d-block mt-1">
                                                                    <i class="bi bi-file-earmark-text me-1"></i>
                                                                    <?= htmlspecialchars($empresa['cnpj']) ?>
                                                                </small>
                                                            <?php endif; ?>
                                                        </span>
                                                    </label>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <div class="text-center text-muted py-4">
                                                <i class="bi bi-building" style="font-size: 2rem; opacity: 0.3;"></i>
                                                <p class="mb-0 mt-2">Nenhuma empresa cadastrada.</p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Campo oculto para enviar os IDs das empresas vinculadas -->
                        <input type="hidden" name="empresas_vinculadas" id="empresas_vinculadas_produto_input"
                            value="<?= htmlspecialchars(json_encode($empresasVinculadas ?? []), ENT_QUOTES, 'UTF-8') ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($isEdit): ?>
    <input type="hidden" name="id" value="<?= $produto['id'] ?>">
<?php endif; ?>

<style>
    .autocomplete-dropdown {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: var(--bs-body-bg, #fff);
        border: 1px solid var(--bs-border-color, #dee2e6);
        border-top: none;
        border-radius: 0 0 0.375rem 0.375rem;
        max-height: 300px;
        overflow-y: auto;
        z-index: 1000;
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }

    .autocomplete-item {
        padding: 0.75rem 1rem;
        cursor: pointer;
        border-bottom: 1px solid var(--bs-border-color, #f0f0f0);
        transition: all 0.15s ease-in-out;
    }

    .autocomplete-item:hover,
    .autocomplete-item.active {
        background-color: var(--bs-primary, #0d6efd);
        color: white;
    }

    .autocomplete-item:hover .text-muted {
        color: rgba(255, 255, 255, 0.8) !important;
    }

    .autocomplete-item:last-child {
        border-bottom: none;
    }

    .autocomplete-no-results {
        padding: 1rem;
        text-align: center;
        color: var(--bs-secondary, #6c757d);
        font-style: italic;
    }

    /* Estilo moderno para empresas vinculadas com toggle switches */
    .empresa-item-wrapper {
        border: 1px solid #e9ecef;
    }

    .empresa-item-wrapper:hover {
        border-color: #0066CC;
        box-shadow: 0 2px 4px rgba(0, 102, 204, 0.1);
    }

    .empresa-item-wrapper:has(.modern-switch-input:checked) {
        background-color: #e7f3ff;
        border-color: #0066CC;
    }

    .empresa-item-wrapper .modern-switch-text .fw-medium {
        color: #2c3e50;
    }

    .empresa-item-wrapper:has(.modern-switch-input:checked) .modern-switch-text .fw-medium {
        color: #0066CC;
    }

    /* Modern Switch Styles - Compacto */
    .modern-switch-wrapper {
        position: relative;
        display: flex;
        align-items: center;
        padding: 8px 12px;
        background: #f8f9fa;
        border: 1px solid #e9ecef;
        border-radius: 8px;
    }

    .modern-switch-input {
        position: absolute;
        opacity: 0;
        width: 0;
        height: 0;
    }

    .modern-switch-label {
        display: flex;
        align-items: center;
        cursor: pointer;
        width: 100%;
    }

    .modern-switch-slider {
        position: relative;
        width: 50px;
        height: 26px;
        background-color: #ccc;
        border-radius: 26px;
        transition: background-color 0.3s;
        flex-shrink: 0;
    }

    .modern-switch-slider:before {
        content: "";
        position: absolute;
        width: 22px;
        height: 22px;
        left: 2px;
        bottom: 2px;
        background-color: white;
        border-radius: 50%;
        transition: transform 0.3s;
    }

    .modern-switch-input:checked+.modern-switch-label .modern-switch-slider {
        background-color: #0066CC;
    }

    .modern-switch-input:checked+.modern-switch-label .modern-switch-slider:before {
        transform: translateX(24px);
    }

    .modern-switch-text {
        margin-left: 12px;
        flex: 1;
    }
</style>

<script>
    // ============================================
    // FUNÇÕES GLOBAIS - DEFINIDAS IMEDIATAMENTE
    // ============================================

    // Variáveis globais para tabelas - usar window para garantir acesso global
    if (typeof window.tabelasTemp === 'undefined') {
        window.tabelasTemp = [];
    }
    if (typeof window.tabelaIndex === 'undefined') {
        window.tabelaIndex = 0;
    }

    // Adicionar tabela de preço (global) - redefinir se necessário (já definida no script inline)
    if (typeof window.adicionarTabela === 'undefined') {
        window.adicionarTabela = function (tabelaExistente = null) {
            // Verificar se jQuery está disponível
            if (typeof jQuery === 'undefined' || typeof $ === 'undefined') {
                console.error('jQuery não está disponível');
                return;
            }

            let tabelaPrecoId = '';
            let nome = '';
            let compra = '0';
            let custo = '0';
            let margem = '0';
            let venda = '0';

            if (tabelaExistente) {
                tabelaPrecoId = tabelaExistente.tabela_preco_id || '';
                nome = tabelaExistente.nome || '';
                const compraNum = parseFloat(tabelaExistente.compra || 0);
                const custoNum = parseFloat(tabelaExistente.custo || 0);
                const vendaNum = parseFloat(tabelaExistente.venda || 0);
                compra = compraNum.toFixed(2);
                custo = custoNum.toFixed(2);
                margem = parseFloat(tabelaExistente.margem || 0).toFixed(2);
                venda = vendaNum.toFixed(2);
            } else {
                const selectTabela = $('#tabela_nome');
                const selectedOption = selectTabela.find('option:selected');
                tabelaPrecoId = selectedOption.val();
                nome = selectedOption.data('nome') || selectedOption.text().trim();

                if (!tabelaPrecoId) {
                    if (typeof Swal !== 'undefined') {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: 'Selecione uma tabela de preço'
                        });
                    } else {
                        alert('Selecione uma tabela de preço');
                    }
                    return;
                }

                const parseFn = window.parseMoneyValue || function (v) {
                    let str = String(v).replace('R$', '').replace(/\s/g, '').replace(/\./g, '').replace(',', '.');
                    return parseFloat(str) || 0;
                };
                const compraVal = $('#tabela_compra').val() || '0';
                const custoVal = $('#tabela_custo').val() || '0';
                const vendaVal = $('#tabela_venda').val() || '0';
                compra = parseFn(compraVal).toFixed(2);
                custo = parseFn(custoVal).toFixed(2);
                const margemVal = $('#tabela_margem').val() || '0';
                const margemClean = margemVal.toString().replace(/\./g, '').replace(',', '.');
                margem = parseFloat(margemClean || '0').toFixed(2);
                venda = parseFn(vendaVal).toFixed(2);
            }

            if (!nome) {
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Informe o nome da tabela'
                    });
                } else {
                    alert('Informe o nome da tabela');
                }
                return;
            }

            // IMPORTANTE: Valores devem ser números com ponto, não strings formatadas
            const compraNum = parseFloat(compra) || 0;
            const custoNum = parseFloat(custo) || 0;
            const margemNum = parseFloat(margem) || 0;
            const vendaNum = parseFloat(venda) || 0;

            const tabela = {
                index: window.tabelaIndex,
                nome: nome,
                tabela_preco_id: tabelaPrecoId,
                compra: compraNum.toFixed(2),
                custo: custoNum.toFixed(2),
                margem: margemNum.toFixed(2),
                venda: vendaNum.toFixed(2)
            };

            window.tabelasTemp.push(tabela);
            window.tabelaIndex++;

            // Desabilitar a opção no select
            if (tabelaPrecoId) {
                const option = $('#tabela_nome option[value="' + tabelaPrecoId + '"]');
                if (option.length > 0) {
                    option.prop('disabled', true);
                    option.css({ 'color': '#999', 'font-style': 'italic' });
                    if (!option.text().includes('(já adicionada)')) {
                        option.text(option.text() + ' (já adicionada)');
                    }
                }
            }

            const compraFormatado = compraNum.toFixed(2).replace('.', ',');
            const custoFormatado = custoNum.toFixed(2).replace('.', ',');
            const margemFormatado = margemNum.toFixed(2);
            const vendaFormatado = vendaNum.toFixed(2).replace('.', ',');

            const row = `
        <tr data-index="${tabela.index}">
            <td><strong>${nome}</strong></td>
            <td>R$ ${compraFormatado}</td>
            <td>R$ ${custoFormatado}</td>
            <td>${margemFormatado}%</td>
            <td><strong class="text-success">R$ ${vendaFormatado}</strong></td>
            <td>
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerTabela(${tabela.index})">
                    <i class="bi bi-trash"></i>
                </button>
            </td>
            <input type="hidden" name="tabelas[${tabela.index}][nome]" value="${nome}">
            <input type="hidden" name="tabelas[${tabela.index}][tabela_preco_id]" value="${tabelaPrecoId || ''}">
            <input type="hidden" name="tabelas[${tabela.index}][compra]" value="${compraNum.toFixed(2)}">
            <input type="hidden" name="tabelas[${tabela.index}][custo]" value="${custoNum.toFixed(2)}">
            <input type="hidden" name="tabelas[${tabela.index}][margem]" value="${margemNum.toFixed(2)}">
            <input type="hidden" name="tabelas[${tabela.index}][venda]" value="${vendaNum.toFixed(2)}">
        </tr>
    `;

            const tbodyTabelas = $('#tbody-tabelas');
            const alertSemTabelas = $('#alert-sem-tabelas');
            const tabelaTabelas = $('#tabela-tabelas');

            console.log('Verificando elementos DOM...');
            console.log('#tbody-tabelas encontrado?', tbodyTabelas.length > 0);
            console.log('#alert-sem-tabelas encontrado?', alertSemTabelas.length > 0);
            console.log('#tabela-tabelas encontrado?', tabelaTabelas.length > 0);

            if (tbodyTabelas.length > 0) {
                tbodyTabelas.append(row);
                alertSemTabelas.hide();
                tabelaTabelas.show();
                $('#total-tabelas').text(window.tabelasTemp.length);
                console.log('✓ Tabela adicionada à view:', nome, 'Total:', window.tabelasTemp.length);
                console.log('Tabela HTML adicionada:', row.substring(0, 100) + '...');
            } else {
                console.error('✗ Elemento #tbody-tabelas não encontrado no DOM!');
                console.error('Tentando encontrar elementos relacionados...');
                console.log('Elementos encontrados com "tabela" no id:', $('[id*="tabela"]').length);
            }

            if (!tabelaExistente) {
                $('#tabela_nome').val('');
                $('#tabela_compra').val('');
                $('#tabela_custo').val('');
                $('#tabela_margem').val('');
                $('#tabela_venda').val('');
                $('#tabela_nome').focus();
            } else {
                // Se for uma tabela existente sendo recarregada, desabilitar no select
                if (tabelaPrecoId) {
                    const option = $('#tabela_nome option[value="' + tabelaPrecoId + '"]');
                    if (option.length > 0) {
                        option.prop('disabled', true);
                        option.css({ 'color': '#999', 'font-style': 'italic' });
                        if (!option.text().includes('(já adicionada)')) {
                            option.text(option.text() + ' (já adicionada)');
                        }
                    }
                }
            }
        };

        // Função para formatar moeda durante a digitação em inputs (global)
        // Definida imediatamente para estar disponível quando o HTML chamar
        window.maskMoneyInput = function (input) {
            if (!input || input._masking) return;
            input._masking = true;

            // Garantir que input.value seja sempre uma string
            let currentValue = String(input.value || '').trim();

            // Se já está formatado, não reformatar
            if (currentValue.includes('R$') && currentValue.includes(',')) {
                input._masking = false;
                return;
            }

            // Salvar posição do cursor
            const cursorPos = input.selectionStart || 0;

            // Remover tudo exceto números, vírgula e ponto
            let cleanValue = currentValue.replace('R$', '').replace(/\s/g, '');

            // Se tem vírgula ou ponto, tratar como decimal já formatado
            let numValue = 0;
            if (cleanValue.includes(',') || cleanValue.includes('.')) {
                // Remove pontos (separadores de milhar) e converte vírgula para ponto
                cleanValue = cleanValue.replace(/\./g, '').replace(',', '.');
                numValue = parseFloat(cleanValue) || 0;
            } else {
                // Apenas números - tratar como valor inteiro
                let digits = cleanValue.replace(/\D/g, '');
                if (digits === '' || digits === '0') {
                    input.value = '';
                    input._masking = false;
                    return;
                }
                numValue = parseFloat(digits) || 0;
            }

            // Formatar: garantir 2 casas decimais
            let formatted = numValue.toFixed(2);
            // Separar parte inteira e decimal
            let parts = formatted.split('.');
            let parteInteira = parts[0];
            let parteDecimal = parts[1] || '00';

            // Garantir que parte decimal tenha exatamente 2 dígitos
            parteDecimal = parteDecimal.substring(0, 2).padEnd(2, '0');

            // Aplicar separador de milhar APENAS na parte inteira (se tiver mais de 3 dígitos)
            if (parteInteira.length > 3) {
                parteInteira = parteInteira.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
            }

            // Juntar: parte inteira + vírgula + parte decimal
            let finalValue = parteInteira + ',' + parteDecimal;
            input.value = 'R$ ' + finalValue;

            // Restaurar posição do cursor (ajustada para o novo formato)
            try {
                const lengthDiff = input.value.length - currentValue.length;
                const newCursorPos = Math.min(Math.max(cursorPos + lengthDiff, 0), input.value.length);
                input.setSelectionRange(newCursorPos, newCursorPos);
            } catch (e) {
                // Ignora erro se não conseguir definir posição
            }

            input._masking = false;

            // Disparar cálculo após formatar (sem causar loop)
            if (input.id === 'tabela_custo' && window.calcularPrecoVenda) {
                setTimeout(function () {
                    window.calcularPrecoVenda();
                }, 100);
            }
        };

        (function aguardarJQuery() {
            if (typeof jQuery === 'undefined') {
                setTimeout(aguardarJQuery, 100);
                return;
            }

            $(document).ready(function () {
                // Máscara para NCM: 0000.00.00
                $('#ncm').on('input', function (e) {
                    let value = this.value.replace(/\D/g, ''); // Remove tudo que não é número

                    if (value.length > 8) {
                        value = value.substring(0, 8);
                    }

                    // Aplicar máscara: 0000.00.00
                    if (value.length > 6) {
                        this.value = value.substring(0, 4) + '.' + value.substring(4, 6) + '.' + value
                            .substring(6);
                    } else if (value.length > 4) {
                        this.value = value.substring(0, 4) + '.' + value.substring(4);
                    } else {
                        this.value = value;
                    }
                });

                // Máscara para CEST: 00.000.00
                $('#cest').on('input', function (e) {
                    let value = this.value.replace(/\D/g, ''); // Remove tudo que não é número

                    if (value.length > 7) {
                        value = value.substring(0, 7);
                    }

                    // Aplicar máscara: 00.000.00
                    if (value.length > 5) {
                        this.value = value.substring(0, 2) + '.' + value.substring(2, 5) + '.' + value
                            .substring(5);
                    } else if (value.length > 2) {
                        this.value = value.substring(0, 2) + '.' + value.substring(2);
                    } else {
                        this.value = value;
                    }
                });

                // Máscara para CFOP: 0000
                $('#cfop').on('input', function (e) {
                    this.value = this.value.replace(/\D/g, '').substring(0, 4);
                });

                // Máscara para campos decimais
                ['#weight', '#height_cm', '#width_cm', '#length_cm'].forEach(function (selector) {
                    $(selector).on('input', function () {
                        this.value = this.value.replace(/[^\d.,]/g, '');
                    });
                });

                // Filtrar subgrupos baseado no grupo selecionado
                $('#grupo_id').on('change', function () {
                    const grupoId = $(this).val();
                    const $subgrupoSelect = $('#subgrupo_id');
                    const $options = $subgrupoSelect.find('option');

                    if (!grupoId) {
                        $options.show();
                        $subgrupoSelect.val('');
                        return;
                    }

                    $options.each(function () {
                        const $option = $(this);
                        if ($option.val() === '') {
                            $option.show();
                        } else if ($option.data('grupo') == grupoId) {
                            $option.show();
                        } else {
                            $option.hide();
                        }
                    });

                    // Limpar seleção se o subgrupo não pertence ao grupo
                    const selectedSubgrupo = $subgrupoSelect.val();
                    if (selectedSubgrupo) {
                        const selectedOption = $subgrupoSelect.find('option:selected');
                        if (selectedOption.data('grupo') != grupoId) {
                            $subgrupoSelect.val('');
                        }
                    }
                });

                // Inicializar filtro se houver grupo selecionado
                if ($('#grupo_id').val()) {
                    $('#grupo_id').trigger('change');
                }
            });
        })();

        // ============================================
        // GERENCIAMENTO DE TRIBUTAÇÃO
        // ============================================
        // Nota: Aba de tributação foi ocultada e o seletor de grupo de impostos
        // foi movido para a aba "Dados Principais"
        // O JavaScript abaixo foi simplificado pois agora só temos o seletor de grupo
        $(document).ready(function () {
            // Quando selecionar um grupo de impostos, pode preencher campos ocultos se necessário
            $('#grupo_tributacao_id').on('change', function () {
                const $selected = $(this).find('option:selected');
                // Os dados do grupo estão disponíveis via data-attributes se necessário no futuro
                if ($selected.val()) {
                    // Dados disponíveis:
                    // $selected.data('ncm')
                    // $selected.data('cst-icms')
                    // $selected.data('icms')
                    // $selected.data('cst-pis')
                    // $selected.data('pis')
                    // $selected.data('cst-cofins')
                    // $selected.data('cofins')
                    // $selected.data('cst-ipi')
                    // $selected.data('ipi')
                }
            });
        });

        // ============================================
        // GERENCIAMENTO DE TABELAS DE PREÇO
        // ============================================
        // Variáveis já definidas no início do script - não redefinir

        // Função para converter valor formatado (R$ 12,00) ou não formatado (1250) para número (global)
        window.parseMoneyValue = function (value) {
            if (!value && value !== 0) return 0;

            // Se for número, retornar direto
            if (typeof value === 'number') {
                return value;
            }

            // Garantir que seja string
            let strValue = String(value).trim();

            // Se não tem formatação (R$ ou vírgula), é um número direto
            if (!strValue.includes('R$') && !strValue.includes(',') && !strValue.includes('.')) {
                return parseFloat(strValue) || 0;
            }

            // Se tem formatação, remover e converter
            let numValue = strValue
                .replace('R$', '')
                .replace(/\s/g, '')
                .replace(/\./g, '')  // Remove separador de milhar
                .replace(',', '.'); // Converte vírgula decimal para ponto
            return parseFloat(numValue) || 0;
        };

        // Função para formatar número para moeda brasileira (global)
        window.formatMoney = function (value) {
            if (!value && value !== 0) return '';
            const numValue = parseFloat(value);
            if (isNaN(numValue)) return '';
            if (numValue === 0) return 'R$ 0,00';

            // Formatar com 2 casas decimais
            let formatted = numValue.toFixed(2);
            // Separar parte inteira e decimal
            let parts = formatted.split('.');
            let parteInteira = parts[0];
            let parteDecimal = parts[1] || '00';

            // Garantir que parte decimal tenha exatamente 2 dígitos
            parteDecimal = parteDecimal.substring(0, 2).padEnd(2, '0');

            // Aplicar separador de milhar APENAS na parte inteira (se tiver mais de 3 dígitos)
            if (parteInteira.length > 3) {
                parteInteira = parteInteira.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
            }

            // Juntar: parte inteira + vírgula + parte decimal
            return 'R$ ' + parteInteira + ',' + parteDecimal;
        };

        // Calcular venda baseado em custo e margem (para tabelas)
        // Recalcula quando Compra, Custo ou Margem são alterados
        window.calcularPrecoVenda = function () {
            try {
                const custoInput = document.getElementById('tabela_custo');
                const margemInput = document.getElementById('tabela_margem');
                const vendaInput = document.getElementById('tabela_venda');

                if (!custoInput || !margemInput || !vendaInput) {
                    return;
                }

                const custoStr = custoInput.value || '';
                const margemStr = margemInput.value || '0';

                // Converter custo formatado para número
                let custo = 0;
                if (custoStr) {
                    // Remove R$, espaços, pontos (milhar) e converte vírgula para ponto
                    let custoNum = custoStr.toString()
                        .replace('R$', '')
                        .replace(/\s/g, '')
                        .replace(/\./g, '')
                        .replace(',', '.');
                    custo = parseFloat(custoNum) || 0;
                }

                // Converter margem para número (remover formatação se houver)
                let margemClean = margemStr.toString().replace(/\./g, '').replace(',', '.');
                const margem = parseFloat(margemClean) || 0;

                // Calcular venda
                if (custo > 0 && margem >= 0) {
                    const venda = custo * (1 + margem / 100);
                    const formatFn = window.formatMoney;
                    if (formatFn) {
                        vendaInput.value = formatFn(venda);
                    } else {
                        // Fallback se formatMoney não estiver disponível
                        vendaInput.value = 'R$ ' + venda.toFixed(2).replace('.', ',');
                    }
                } else if (custo > 0 && margem === 0) {
                    const formatFn = window.formatMoney;
                    if (formatFn) {
                        vendaInput.value = formatFn(custo);
                    } else {
                        vendaInput.value = 'R$ ' + custo.toFixed(2).replace('.', ',');
                    }
                } else {
                    vendaInput.value = 'R$ 0,00';
                }
            } catch (e) {
                console.error('Erro ao calcular preço de venda:', e);
                const vendaInput = document.getElementById('tabela_venda');
                if (vendaInput) {
                    vendaInput.value = 'R$ 0,00';
                }
            }
        };

        // Eventos para recalcular quando qualquer campo for alterado
        $(document).ready(function () {
            // Formatar valores existentes ao carregar a página
            function formatarValoresExistentes() {
                // Formatar Compra
                const compraInput = document.getElementById('tabela_compra');
                if (compraInput) {
                    const compraVal = compraInput.value;
                    if (compraVal && compraVal.toString().trim() !== '' && !compraVal.toString().includes('R$')) {
                        const compraNum = parseFloat(compraVal) || 0;
                        if (compraNum > 0) {
                            // Formatar diretamente
                            compraInput.value = (window.formatMoney || formatMoney)(compraNum);
                        }
                    }
                }

                // Formatar Custo e calcular Venda
                const custoInput = document.getElementById('tabela_custo');
                if (custoInput) {
                    const custoVal = custoInput.value;
                    if (custoVal && custoVal.toString().trim() !== '' && !custoVal.toString().includes('R$')) {
                        const custoNum = parseFloat(custoVal) || 0;
                        if (custoNum > 0) {
                            custoInput.value = (window.formatMoney || formatMoney)(custoNum);
                            // Calcular venda após formatar
                            setTimeout(function () {
                                (window.calcularPrecoVenda || calcularPrecoVenda)();
                            }, 100);
                        }
                    } else if (custoVal && custoVal.toString().includes('R$')) {
                        // Se já está formatado, apenas calcular
                        setTimeout(function () {
                            (window.calcularPrecoVenda || calcularPrecoVenda)();
                        }, 100);
                    } else if (custoVal && parseFloat(custoVal) > 0) {
                        // Tentar calcular mesmo sem formatação
                        setTimeout(function () {
                            (window.calcularPrecoVenda || calcularPrecoVenda)();
                        }, 100);
                    }
                }
            }

            // Formatar imediatamente e depois novamente após um delay
            formatarValoresExistentes();
            setTimeout(formatarValoresExistentes, 200);
            setTimeout(formatarValoresExistentes, 500);

            // Eventos para cálculo - disparar em tempo real
            $('#tabela_custo').on('blur change', function () {
                setTimeout(function () {
                    if (window.calcularPrecoVenda) {
                        window.calcularPrecoVenda();
                    }
                }, 50);
            });

            // ============================================
            // CÁLCULO SIMPLES: VENDA = CUSTO + (CUSTO * MARGEM / 100)
            // ============================================

            // Função SIMPLES e DIRETA
            function calcularVenda() {
                var custoInput = document.getElementById('tabela_custo');
                var margemInput = document.getElementById('tabela_margem');
                var vendaInput = document.getElementById('tabela_venda');

                if (!custoInput || !margemInput || !vendaInput) {
                    return;
                }

                // Pegar valores dos campos
                var custoStr = custoInput.value || '0';
                var margemStr = margemInput.value || '0';

                // Limpar formatação do custo: "R$ 5,00" -> "5.00"
                custoStr = custoStr.replace('R$', '').replace(/\s/g, '').replace(/\./g, '').replace(',', '.');
                var custo = parseFloat(custoStr) || 0;

                // Limpar formatação da margem: "8,00" -> "8.00"
                margemStr = margemStr.replace(/\./g, '').replace(',', '.');
                var margem = parseFloat(margemStr) || 0;

                // CALCULAR: Venda = Custo + (Custo * Margem / 100)
                var venda = 0;
                if (custo > 0) {
                    if (margem > 0) {
                        venda = custo + (custo * margem / 100);
                    } else {
                        venda = custo;
                    }
                }

                // Formatar resultado: "5.40" -> "R$ 5,40"
                var vendaFormatado = 'R$ ' + venda.toFixed(2).replace('.', ',');
                vendaInput.value = vendaFormatado;
            }

            // Disparar cálculo quando sair do campo MARGEM (blur)
            $('#tabela_margem').on('blur', function () {
                calcularVenda();
            });

            // Disparar cálculo quando sair do campo CUSTO (blur)
            $('#tabela_custo').on('blur', function () {
                calcularVenda();
            });

            // Monitorar mudanças no campo custo via MutationObserver
            const custoInput = document.getElementById('tabela_custo');
            if (custoInput && window.MutationObserver) {
                const observer = new MutationObserver(function (mutations) {
                    if (!custoInput._masking && window.calcularPrecoVenda) {
                        setTimeout(function () {
                            window.calcularPrecoVenda();
                        }, 100);
                    }
                });
                observer.observe(custoInput, { attributes: false, childList: false, characterData: true, subtree: true });
            }

            // Forçar cálculo inicial
            setTimeout(function () {
                (window.calcularPrecoVenda || calcularPrecoVenda)();
            }, 300);
        }); // Fim do $(document).ready

        // ============================================
        // FUNÇÕES GLOBAIS - FORA DO $(document).ready
        // ============================================

        // Variáveis globais já definidas no início do script
        // Não redefinir aqui para evitar conflitos

        // Remover tabela de preço - usar window se não estiver definida
        if (typeof window.removerTabela === 'undefined') {
            window.removerTabela = function (index) {
                // Encontrar a tabela que será removida para pegar o tabela_preco_id
                const tr = $(`#tbody-tabelas tr[data-index="${index}"]`);
                const tabelaPrecoIdInput = tr.find('input[name*="[tabela_preco_id]"]');
                const tabelaPrecoId = tabelaPrecoIdInput.length > 0 ? tabelaPrecoIdInput.val() : null;

                // Remover da tabela
                tr.remove();

                // Remover do array
                if (window.tabelasTemp) {
                    window.tabelasTemp = window.tabelasTemp.filter(t => t.index !== index);
                }
                $('#total-tabelas').text(window.tabelasTemp ? window.tabelasTemp.length : 0);

                // Reabilitar a opção no select
                if (tabelaPrecoId) {
                    const option = $('#tabela_nome option[value="' + tabelaPrecoId + '"]');
                    if (option.length > 0) {
                        option.prop('disabled', false);
                        option.css({ 'color': '', 'font-style': '' });
                        let optionText = option.text().replace(' (já adicionada)', '');
                        option.text(optionText);
                    }
                }

                if (!window.tabelasTemp || window.tabelasTemp.length === 0) {
                    $('#tabela-tabelas').hide();
                    $('#alert-sem-tabelas').show();
                }
            };
        }

        // ============================================
        // GERENCIAMENTO DE PREÇOS POR QUANTIDADE
        // ============================================
        let precosTemp = [];
        let precoIndex = 0;

        // Adicionar preço à tabela
        function adicionarPreco() {
            const descricao = $('#preco_descricao').val();
            const quantidadeMin = $('#preco_quantidade_min').val() || '1';
            const valor = $('#preco_valor').val();

            if (!descricao || !valor) {
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Preencha a descrição e o preço'
                    });
                } else {
                    alert('Preencha a descrição e o preço');
                }
                return;
            }

            const preco = {
                index: precoIndex,
                descricao: descricao,
                quantidade_min: quantidadeMin,
                valor: valor
            };

            precosTemp.push(preco);
            precoIndex++;

            const valorFormatado = parseFloat(valor).toFixed(2).replace('.', ',');
            const row = `
        <tr data-index="${preco.index}">
            <td><strong>${descricao}</strong></td>
            <td>${quantidadeMin} un.</td>
            <td>R$ ${valorFormatado}</td>
            <td>
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerPreco(${preco.index})">
                    <i class="bi bi-trash"></i>
                </button>
            </td>
            <input type="hidden" name="precos[${preco.index}][descricao]" value="${descricao}">
            <input type="hidden" name="precos[${preco.index}][quantidade_min]" value="${quantidadeMin}">
            <input type="hidden" name="precos[${preco.index}][valor]" value="${valor}">
        </tr>
    `;

            $('#tbody-precos').append(row);
            $('#alert-sem-precos').hide();
            $('#tabela-precos').show();
            $('#total-precos').text(precosTemp.length);

            // Limpar campos
            $('#preco_descricao').val('');
            $('#preco_quantidade_min').val('');
            $('#preco_valor').val('');
            $('#preco_descricao').focus();
        }

        // Remover preço da tabela
        function removerPreco(index) {
            $(`tr[data-index="${index}"]`).remove();
            precosTemp = precosTemp.filter(p => p.index !== index);
            $('#total-precos').text(precosTemp.length);

            if (precosTemp.length === 0) {
                $('#tabela-precos').hide();
                $('#alert-sem-precos').show();
            }
        }

        // ============================================
        // GERENCIAMENTO DE KIT
        // ============================================
        const produtosData = <?= json_encode($produtos ?? []) ?>;
        let kitItens = [];
        let kitIndex = 0;
        let kitProdutoTimeout = null;
        let selectedKitProduto = null;

        $(document).ready(function () {
            const $search = $('#kit_produto_search');
            const $dropdown = $('#kit_produto_dropdown');

            // Verificar se o campo existe
            if ($search.length === 0) {
                return;
            }

            // Ao digitar
            $search.on('input', function () {
                const query = $(this).val().trim();

                clearTimeout(kitProdutoTimeout);

                if (query.length < 2) {
                    $dropdown.hide();
                    return;
                }

                kitProdutoTimeout = setTimeout(() => {
                    buscarProdutosKit(query);
                }, 300);
            });

            // Ao clicar fora, fechar dropdown
            $(document).on('click', function (e) {
                if (!$(e.target).closest('#kit_produto_search, #kit_produto_dropdown').length) {
                    $dropdown.hide();
                }
            });

            // Ao focar no campo
            $search.on('focus', function () {
                const query = $(this).val().trim();
                if (query.length >= 2) {
                    buscarProdutosKit(query);
                }
            });

            // Ao pressionar E            nter, apenas prevenir submit
            $search.on('keydown', function (e) {
                if (e.key === 'Enter') {
                    e.preventDefault();
                }
            });

            // Carregar itens do kit existentes se estiver editando
            <?php if ($isEdit && !empty($produto['id']) && !empty($kitItens)): ?>
                const kitItensExistentes = <?= json_encode($kitItens) ?>;
                kitItensExistentes.forEach(function (item) {
                    const produto = {
                        id: item.produto_id,
                        name: item.produto_nome,
                        sku: item.produto_sku,
                        price: item.produto_preco || 0
                    };

                    selectedKitProduto = produto;
                    $('#kit_produto_id').val(produto.id);
                    $('#kit_produto_search').val(produto.name + ' (SKU: ' + produto.sku + ')');
                    $('#kit_quantidade').val(item.quantidade);

                    // Adicionar item sem validação de duplicata (já está carregando)
                    const precoUnitario = parseFloat(produto.price || 0);
                    const quantidade = parseFloat(item.quantidade || 1);
                    const subtotal = precoUnitario * quantidade;

                    const itemKit = {
                        index: kitIndex,
                        produto_id: produto.id,
                        produto_nome: produto.name,
                        produto_sku: produto.sku,
                        quantidade: quantidade,
                        preco_unitario: precoUnitario,
                        subtotal: subtotal
                    };

                    kitItens.push(itemKit);
                    kitIndex++;

                    const precoUnitarioFormatado = precoUnitario.toFixed(2).replace('.', ',');
                    const subtotalFormatado = subtotal.toFixed(2).replace('.', ',');

                    const row = `
            <tr data-index="${itemKit.index}">
                <td><strong>${itemKit.produto_nome}</strong></td>
                <td>${itemKit.produto_sku || '-'}</td>
                <td>${quantidade.toFixed(2).replace('.', ',')}</td>
                <td>R$ ${precoUnitarioFormatado}</td>
                <td><strong>R$ ${subtotalFormatado}</strong></td>
                <td>
                    <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerItemKit(${itemKit.index})">
                        <i class="bi bi-trash"></i>
                    </button>
                </td>
                <input type="hidden" name="kit_itens[${itemKit.index}][produto_id]" value="${produto.id}">
                <input type="hidden" name="kit_itens[${itemKit.index}][quantidade]" value="${quantidade}">
            </tr>
        `;

                    $('#tbody-kit').append(row);
                    selectedKitProduto = null;
                });

                if (kitItensExistentes.length > 0) {
                    $('#alert-sem-kit').hide();
                    $('#tabela-kit').show();
                    atualizarTotalKit();
                }
            <?php endif; ?>
        });

        function buscarProdutosKit(query) {
            const $dropdown = $('#kit_produto_dropdown');
            const queryLower = query.toLowerCase();

            // Buscar localmente no array (igual na venda)
            const results = produtosData.filter(produto => {
                const name = (produto.name || '').toLowerCase();
                const sku = (produto.sku || '').toLowerCase();
                return name.includes(queryLower) || sku.includes(queryLower);
            });

            let html = '';
            if (results.length > 0) {
                results.forEach(produto => {
                    const nome = produto.name || '-';
                    const sku = produto.sku || 'Sem SKU';
                    const preco = parseFloat(produto.price || 0).toFixed(2).replace('.', ',');
                    const estoque = produto.stock_quantity || 0;

                    html += `
                <div class="autocomplete-item" data-id="${produto.id}" data-name="${nome}" data-sku="${sku}" data-price="${produto.price || 0}">
                    <div class="mb-1">
                        <strong>${nome}</strong>
                        ${sku !== 'Sem SKU' ? ' <span class="text-muted">(' + sku + ')</span>' : ''}
                    </div>
                    <div class="text-muted small">
                        <strong>Preço:</strong> R$ ${preco}  |  <strong>Estoque:</strong> ${estoque}
                    </div>
                </div>
            `;
                });
            } else {
                html = '<div class="autocomplete-no-results">Nenhum produto encontrado</div>';
            }

            $dropdown.html(html).show();

            // Event listeners
            $dropdown.find('.autocomplete-item').on('click', function () {
                const produtoId = $(this).data('id');
                const produto = produtosData.find(p => p.id == produtoId);
                if (produto) {
                    selecionarProdutoKit(produto);
                }
            });
        }

        function selecionarProdutoKit(produto) {
            selectedKitProduto = produto;
            $('#kit_produto_id').val(produto.id);
            $('#kit_produto_search').val(produto.name + ' (SKU: ' + produto.sku + ')');
            $('#kit_produto_dropdown').hide();
        }

        function adicionarItemKit() {
            const produtoId = $('#kit_produto_id').val();
            const quantidade = parseFloat($('#kit_quantidade').val()) || 0;

            if (!produtoId || !selectedKitProduto) {
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Selecione um produto'
                    });
                } else {
                    alert('Selecione um produto');
                }
                return;
            }

            if (quantidade <= 0) {
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Informe uma quantidade válida'
                    });
                } else {
                    alert('Informe uma quantidade válida');
                }
                return;
            }

            // Verificar se o produto já foi adicionado
            const produtoJaExiste = kitItens.find(item => item.produto_id == produtoId);
            if (produtoJaExiste) {
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Atenção',
                        text: 'Este produto já está no kit. Remova-o primeiro para adicionar novamente.'
                    });
                } else {
                    alert('Este produto já está no kit');
                }
                return;
            }

            const precoUnitario = parseFloat(selectedKitProduto.price || 0);
            const subtotal = precoUnitario * quantidade;

            const item = {
                index: kitIndex,
                produto_id: produtoId,
                produto_nome: selectedKitProduto.name,
                produto_sku: selectedKitProduto.sku,
                quantidade: quantidade,
                preco_unitario: precoUnitario,
                subtotal: subtotal
            };

            kitItens.push(item);
            kitIndex++;

            const precoUnitarioFormatado = precoUnitario.toFixed(2).replace('.', ',');
            const subtotalFormatado = subtotal.toFixed(2).replace('.', ',');

            const row = `
        <tr data-index="${item.index}">
            <td><strong>${item.produto_nome}</strong></td>
            <td>${item.produto_sku || '-'}</td>
            <td>${quantidade.toFixed(2).replace('.', ',')}</td>
            <td>R$ ${precoUnitarioFormatado}</td>
            <td><strong>R$ ${subtotalFormatado}</strong></td>
            <td>
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerItemKit(${item.index})">
                    <i class="bi bi-trash"></i>
                </button>
            </td>
            <input type="hidden" name="kit_itens[${item.index}][produto_id]" value="${produtoId}">
            <input type="hidden" name="kit_itens[${item.index}][quantidade]" value="${quantidade}">
        </tr>
    `;

            $('#tbody-kit').append(row);
            $('#alert-sem-kit').hide();
            $('#tabela-kit').show();
            atualizarTotalKit();

            // Limpar campos
            $('#kit_produto_id').val('');
            $('#kit_produto_search').val('');
            $('#kit_quantidade').val('1');
            selectedKitProduto = null;
        }

        function removerItemKit(index) {
            $(`#tbody-kit tr[data-index="${index}"]`).remove();
            kitItens = kitItens.filter(item => item.index !== index);
            atualizarTotalKit();

            if (kitItens.length === 0) {
                $('#tabela-kit').hide();
                $('#alert-sem-kit').show();
            }
        }

        function atualizarTotalKit() {
            const total = kitItens.reduce((sum, item) => sum + item.subtotal, 0);
            const totalFormatado = total.toFixed(2).replace('.', ',');
            $('#kit-total').text('R$ ' + totalFormatado);
            $('#total-kit').text(kitItens.length);
        }
        // ============================================
        // FIM GERENCIAMENTO DE KIT
        // ============================================

        // ============================================
        // GERENCIAMENTO DE FORMULAÇÃO
        // ============================================
        let formulacaoItens = [];
        let formulacaoIndex = 0;
        let formulacaoIngredienteTimeout = null;
        let selectedFormulacaoIngrediente = null;

        $(document).ready(function () {
            const $search = $('#formulacao_ingrediente_search');
            const $dropdown = $('#formulacao_ingrediente_dropdown');

            // Verificar se o campo existe
            if ($search.length === 0) {
                return;
            }

            // Ao digitar
            $search.on('input', function () {
                const query = $(this).val().trim();

                clearTimeout(formulacaoIngredienteTimeout);

                if (query.length < 2) {
                    $dropdown.hide();
                    return;
                }

                formulacaoIngredienteTimeout = setTimeout(() => {
                    buscarIngredientesFormulacao(query);
                }, 300);
            });

            // Ao clicar fora, fechar dropdown
            $(document).on('click', function (e) {
                if (!$(e.target).closest('#formulacao_ingrediente_search, #formulacao_ingrediente_dropdown').length) {
                    $dropdown.hide();
                }
            });

            // Ao focar no campo
            $search.on('focus', function () {
                const query = $(this).val().trim();
                if (query.length >= 2) {
                    buscarIngredientesFormulacao(query);
                }
            });

            // Ao pressionar Enter, apenas prevenir submit
            $search.on('keydown', function (e) {
                if (e.key === 'Enter') {
                    e.preventDefault();
                }
            });

            // Carregar ingredientes existentes se estiver editando
            <?php if ($isEdit && !empty($produto['id']) && !empty($formulacaoItens)): ?>
                const formulacaoItensExistentes = <?= json_encode($formulacaoItens) ?>;
                formulacaoItensExistentes.forEach(function (item) {
                    const produto = {
                        id: item.ingrediente_id,
                        name: item.ingrediente_nome,
                        sku: item.ingrediente_sku
                    };

                    selectedFormulacaoIngrediente = produto;
                    $('#formulacao_ingrediente_id').val(produto.id);
                    $('#formulacao_ingrediente_search').val(produto.name + ' (SKU: ' + produto.sku + ')');
                    $('#formulacao_quantidade').val(item.quantidade);
                    $('#formulacao_unidade').val(item.unidade || 'UN');
                    $('#formulacao_observacoes').val(item.observacoes || '');

                    // Adicionar item sem validação de duplicata (já está carregando)
                    const itemFormulacao = {
                        index: formulacaoIndex,
                        ingrediente_id: produto.id,
                        ingrediente_nome: produto.name,
                        ingrediente_sku: produto.sku,
                        quantidade: parseFloat(item.quantidade || 1),
                        unidade: item.unidade || 'UN',
                        observacoes: item.observacoes || ''
                    };

                    formulacaoItens.push(itemFormulacao);
                    formulacaoIndex++;

                    const quantidadeFormatada = itemFormulacao.quantidade.toFixed(4).replace('.', ',');

                    const row = `
            <tr data-index="${itemFormulacao.index}">
                <td>${formulacaoItens.length}</td>
                <td><strong>${itemFormulacao.ingrediente_nome}</strong></td>
                <td>${itemFormulacao.ingrediente_sku || '-'}</td>
                <td>${quantidadeFormatada}</td>
                <td>${itemFormulacao.unidade}</td>
                <td><small class="text-muted">${itemFormulacao.observacoes || '-'}</small></td>
                <td>
                    <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerIngredienteFormulacao(${itemFormulacao.index})">
                        <i class="bi bi-trash"></i>
                    </button>
                </td>
                <input type="hidden" name="formulacao_itens[${itemFormulacao.index}][ingrediente_id]" value="${produto.id}">
                <input type="hidden" name="formulacao_itens[${itemFormulacao.index}][quantidade]" value="${itemFormulacao.quantidade}">
                <input type="hidden" name="formulacao_itens[${itemFormulacao.index}][unidade]" value="${itemFormulacao.unidade}">
                <input type="hidden" name="formulacao_itens[${itemFormulacao.index}][observacoes]" value="${itemFormulacao.observacoes}">
            </tr>
        `;

                    $('#tbody-formulacao').append(row);
                    selectedFormulacaoIngrediente = null;
                });

                if (formulacaoItensExistentes.length > 0) {
                    $('#alert-sem-formulacao').hide();
                    $('#tabela-formulacao').show();
                    atualizarTotalFormulacao();
                }
            <?php endif; ?>
        });

        function buscarIngredientesFormulacao(query) {
            const $dropdown = $('#formulacao_ingrediente_dropdown');
            const queryLower = query.toLowerCase();

            // Buscar localmente no array
            const results = produtosData.filter(produto => {
                const name = (produto.name || '').toLowerCase();
                const sku = (produto.sku || '').toLowerCase();
                return name.includes(queryLower) || sku.includes(queryLower);
            });

            let html = '';
            if (results.length > 0) {
                results.forEach(produto => {
                    const nome = produto.name || '-';
                    const sku = produto.sku || 'Sem SKU';
                    const estoque = produto.stock_quantity || 0;

                    html += `
                <div class="autocomplete-item" data-id="${produto.id}" data-name="${nome}" data-sku="${sku}">
                    <div class="mb-1">
                        <strong>${nome}</strong>
                        ${sku !== 'Sem SKU' ? ' <span class="text-muted">(' + sku + ')</span>' : ''}
                    </div>
                    <div class="text-muted small">
                        <strong>Estoque:</strong> ${estoque}
                    </div>
                </div>
            `;
                });
            } else {
                html = '<div class="autocomplete-no-results">Nenhum produto encontrado</div>';
            }

            $dropdown.html(html).show();

            // Event listeners
            $dropdown.find('.autocomplete-item').on('click', function () {
                const produtoId = $(this).data('id');
                const produto = produtosData.find(p => p.id == produtoId);
                if (produto) {
                    selecionarIngredienteFormulacao(produto);
                }
            });
        }

        function selecionarIngredienteFormulacao(produto) {
            selectedFormulacaoIngrediente = produto;
            $('#formulacao_ingrediente_id').val(produto.id);
            $('#formulacao_ingrediente_search').val(produto.name + ' (SKU: ' + produto.sku + ')');
            $('#formulacao_ingrediente_dropdown').hide();
        }

        function adicionarIngredienteFormulacao() {
            const ingredienteId = $('#formulacao_ingrediente_id').val();
            const quantidade = parseFloat($('#formulacao_quantidade').val()) || 0;
            const unidade = $('#formulacao_unidade').val() || 'UN';
            const observacoes = $('#formulacao_observacoes').val() || '';

            if (!ingredienteId || !selectedFormulacaoIngrediente) {
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Selecione um ingrediente'
                    });
                } else {
                    alert('Selecione um ingrediente');
                }
                return;
            }

            if (quantidade <= 0) {
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Informe uma quantidade válida'
                    });
                } else {
                    alert('Informe uma quantidade válida');
                }
                return;
            }

            // Verificar se o ingrediente já foi adicionado
            const ingredienteJaExiste = formulacaoItens.find(item => item.ingrediente_id == ingredienteId);
            if (ingredienteJaExiste) {
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Atenção',
                        text: 'Este ingrediente já está na formulação. Remova-o primeiro para adicionar novamente.'
                    });
                } else {
                    alert('Este ingrediente já está na formulação');
                }
                return;
            }

            const item = {
                index: formulacaoIndex,
                ingrediente_id: ingredienteId,
                ingrediente_nome: selectedFormulacaoIngrediente.name,
                ingrediente_sku: selectedFormulacaoIngrediente.sku,
                quantidade: quantidade,
                unidade: unidade,
                observacoes: observacoes
            };

            formulacaoItens.push(item);
            formulacaoIndex++;

            const quantidadeFormatada = quantidade.toFixed(4).replace('.', ',');

            const row = `
        <tr data-index="${item.index}">
            <td>${formulacaoItens.length}</td>
            <td><strong>${item.ingrediente_nome}</strong></td>
            <td>${item.ingrediente_sku || '-'}</td>
            <td>${quantidadeFormatada}</td>
            <td>${unidade}</td>
            <td><small class="text-muted">${observacoes || '-'}</small></td>
            <td>
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerIngredienteFormulacao(${item.index})">
                    <i class="bi bi-trash"></i>
                </button>
            </td>
            <input type="hidden" name="formulacao_itens[${item.index}][ingrediente_id]" value="${ingredienteId}">
            <input type="hidden" name="formulacao_itens[${item.index}][quantidade]" value="${quantidade}">
            <input type="hidden" name="formulacao_itens[${item.index}][unidade]" value="${unidade}">
            <input type="hidden" name="formulacao_itens[${item.index}][observacoes]" value="${observacoes}">
        </tr>
    `;

            $('#tbody-formulacao').append(row);
            $('#alert-sem-formulacao').hide();
            $('#tabela-formulacao').show();
            atualizarTotalFormulacao();

            // Limpar campos
            selectedFormulacaoIngrediente = null;
            $('#formulacao_ingrediente_id').val('');
            $('#formulacao_ingrediente_search').val('');
            $('#formulacao_quantidade').val('1');
            $('#formulacao_unidade').val('UN');
            $('#formulacao_observacoes').val('');
        }

        function removerIngredienteFormulacao(index) {
            formulacaoItens = formulacaoItens.filter(item => item.index !== index);
            $(`tr[data-index="${index}"]`).remove();
            atualizarTotalFormulacao();
            reordenarFormulacao();

            if (formulacaoItens.length === 0) {
                $('#alert-sem-formulacao').show();
                $('#tabela-formulacao').hide();
            }
        }

        function atualizarTotalFormulacao() {
            $('#total-formulacao').text(formulacaoItens.length);
        }

        function reordenarFormulacao() {
            $('#tbody-formulacao tr').each(function (index) {
                $(this).find('td:first').text(index + 1);
            });
        }
        // ============================================
        // FIM GERENCIAMENTO DE FORMULAÇÃO
        // ============================================

        // ============================================
        // CARREGAR DADOS SALVOS AO EDITAR
        // ============================================
        <?php if ($isEdit): ?>
            // Passar dados salvos para JavaScript
            const precosSalvos = <?= json_encode($precosPorQuantidade ?? [], JSON_UNESCAPED_UNICODE) ?>;
            const tabelasSalvas = <?= json_encode($tabelasPrecoProduto ?? [], JSON_UNESCAPED_UNICODE) ?>;
            let dadosCarregados = false;

            // Debug: verificar se os dados foram carregados
            console.log('=== DEBUG PRECOS E CUSTOS ===');
            console.log('Preços por quantidade salvos:', precosSalvos);
            console.log('Total de preços por quantidade:', precosSalvos?.length || 0);
            console.log('Tabelas de preço salvas:', tabelasSalvas);
            console.log('Total de tabelas:', tabelasSalvas?.length || 0);
            console.log('Tipo de tabelasSalvas:', typeof tabelasSalvas);
            console.log('É array?', Array.isArray(tabelasSalvas));
            if (tabelasSalvas && tabelasSalvas.length > 0) {
                console.log('✓ DADOS ENCONTRADOS! Primeira tabela:', JSON.stringify(tabelasSalvas[0], null, 2));
            } else {
                console.error('✗ PROBLEMA: tabelasSalvas está vazio ou não é um array!');
            }
            console.log('window.adicionarTabela existe?', typeof window.adicionarTabela);
            console.log('window.tabelasTemp existe?', typeof window.tabelasTemp);
            console.log('window.tabelaIndex existe?', typeof window.tabelaIndex);
            console.log('=============================');

            // Função para carregar dados salvos
            function carregarDadosSalvos() {
                if (dadosCarregados) {
                    return; // Já foi carregado, não carregar novamente
                }

                // Carregar preços por quantidade salvos
                if (precosSalvos && precosSalvos.length > 0) {
                    console.log('Carregando preços por quantidade:', precosSalvos.length);
                    precosSalvos.forEach(function (preco) {
                        // Aceitar registros com valor, mesmo que descricao esteja vazia/null
                        const temDescricao = preco.descricao && preco.descricao.trim() !== '';
                        const temValor = preco.valor !== null && preco.valor !== undefined && preco.valor !== '' && parseFloat(preco.valor) > 0;

                        // Se tem valor, exibir (mesmo sem descrição)
                        if (temValor) {
                            // Criar preço diretamente sem usar campos do formulário
                            // Usar descrição do banco ou valor padrão
                            let descricaoPreco = (preco.descricao || '').trim();
                            if (!descricaoPreco) {
                                descricaoPreco = 'Preço ' + (precosTemp.length + 1);
                            }

                            const precoObj = {
                                index: precoIndex,
                                descricao: descricaoPreco,
                                quantidade_min: preco.quantidade_min || '1',
                                valor: preco.valor
                            };

                            precosTemp.push(precoObj);

                            const valorFormatado = parseFloat(preco.valor || 0).toFixed(2).replace('.', ',');
                            const descricaoEscapada = (preco.descricao || 'Preço').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
                            const row = `
                        <tr data-index="${precoObj.index}">
                            <td><strong>${descricaoEscapada}</strong></td>
                            <td>${precoObj.quantidade_min} un.</td>
                            <td>R$ ${valorFormatado}</td>
                            <td>
                                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerPreco(${precoObj.index})">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </td>
                            <input type="hidden" name="precos[${precoObj.index}][descricao]" value="${descricaoEscapada}">
                            <input type="hidden" name="precos[${precoObj.index}][quantidade_min]" value="${precoObj.quantidade_min}">
                            <input type="hidden" name="precos[${precoObj.index}][valor]" value="${preco.valor}">
                        </tr>
                    `;

                            const tbodyPrecos = $('#tbody-precos');
                            if (tbodyPrecos.length > 0) {
                                tbodyPrecos.append(row);
                                $('#alert-sem-precos').hide();
                                $('#tabela-precos').show();
                                $('#total-precos').text(precosTemp.length);
                                precoIndex++;
                            } else {
                                console.error('Elemento #tbody-precos não encontrado no DOM');
                            }
                        } else {
                            console.log('Preço ignorado (sem descrição ou valor):', preco);
                        }
                    });

                    // Atualizar índice inicial se houver preços carregados
                    if (precosTemp.length > 0) {
                        precoIndex = Math.max(...precosTemp.map(p => p.index)) + 1;
                    }
                } else {
                    console.log('Nenhum preço salvo encontrado ou array vazio');
                }

                // Tabelas já foram renderizadas diretamente no PHP acima
                // Não precisa mais carregar via JavaScript

                dadosCarregados = true;
            }

            // Aguardar jQuery e todas as funções estarem disponíveis
            (function aguardarJQuery() {
                if (typeof jQuery === 'undefined' || typeof $ === 'undefined') {
                    setTimeout(aguardarJQuery, 100);
                    return;
                }

                $(document).ready(function () {
                    // Aguardar um pouco para garantir que todas as funções estejam definidas
                    setTimeout(function () {
                        // Verificar se a função está disponível
                        if (typeof window.adicionarTabela !== 'function') {
                            console.error('Função window.adicionarTabela não está definida!');
                            // Tentar novamente após mais tempo
                            setTimeout(function () {
                                if (typeof window.adicionarTabela === 'function') {
                                    console.log('Função window.adicionarTabela agora está disponível');
                                }
                            }, 1000);
                        }

                        // Carregar dados quando a aba de preços for mostrada
                        $('#precos-tab').on('shown.bs.tab', function () {
                            console.log('Aba de preços mostrada, carregando dados...');
                            carregarDadosSalvos();
                        });

                        // Também tentar carregar quando clicar (antes de mostrar)
                        $('#precos-tab').on('click', function () {
                            setTimeout(function () {
                                console.log('Click na aba de preços, carregando dados...');
                                carregarDadosSalvos();
                            }, 100);
                        });

                        // Se a aba já estiver ativa (raro, mas possível), carregar imediatamente
                        if ($('#precos-tab').hasClass('active') || $('#precos').hasClass('show')) {
                            console.log('Aba de preços já está ativa, carregando dados...');
                            carregarDadosSalvos();
                        }

                        // Tentar carregar após um tempo maior também (fallback)
                        setTimeout(function () {
                            if (!dadosCarregados && (precosSalvos && precosSalvos.length > 0 || tabelasSalvas && tabelasSalvas.length > 0)) {
                                console.log('Fallback: tentando carregar dados novamente');
                                carregarDadosSalvos();
                            }
                        }, 1500);
                    }, 500);
                });
            })();
        <?php endif; ?>

        // ============================================
        // MOSTRAR/OCULTAR SEÇÃO NFS-e BASEADO NO TIPO
        // ============================================
        $(document).ready(function () {
            function toggleNfseSection() {
                const tipo = $('#type').val();
                if (tipo === 'servico') {
                    $('#nfse-tributacao-section').show();
                } else {
                    $('#nfse-tributacao-section').hide();
                }
            }

            // Verificar tipo ao carregar página
            toggleNfseSection();

            // Verificar tipo ao mudar
            $('#type').on('change', function () {
                toggleNfseSection();
            });

            // Gerenciar empresas vinculadas
            const empresasVinculadasInput = $('#empresas_vinculadas_produto_input');

            if (empresasVinculadasInput.length === 0) {
                console.warn('Campo empresas_vinculadas_produto_input não encontrado');
            }

            // Função para atualizar o campo hidden com os IDs das empresas selecionadas
            window.atualizarEmpresasVinculadasProduto = function () {
                const empresasSelecionadas = [];
                $('.empresa-produto-checkbox:checked').each(function () {
                    empresasSelecionadas.push(parseInt($(this).val()));
                });
                if (empresasVinculadasInput.length > 0) {
                    empresasVinculadasInput.val(JSON.stringify(empresasSelecionadas));
                }
            };

            // Verificar se o elemento existe antes de anexar eventos
            const marcarTodasCheckbox = $('#marcar_todas_empresas_produto');
            const marcarTodasLabel = $('label[for="marcar_todas_empresas_produto"]');

            // Função para marcar/desmarcar todas as empresas
            function marcarDesmarcarTodas(isChecked) {
                const checkboxes = $('.empresa-produto-checkbox');
                if (checkboxes.length === 0) {
                    console.warn('Nenhum checkbox de empresa encontrado');
                    return;
                }

                checkboxes.each(function () {
                    $(this).prop('checked', isChecked);
                });

                // Atualizar empresas vinculadas após marcar/desmarcar todas
                atualizarEmpresasVinculadasProduto();
            }

            if (marcarTodasCheckbox.length > 0) {
                // Função para atualizar o estado de "Marcar todas" baseado nos checkboxes individuais
                function atualizarEstadoMarcarTodas() {
                    const totalCheckboxes = $('.empresa-produto-checkbox').length;
                    const checkedCheckboxes = $('.empresa-produto-checkbox:checked').length;
                    if (totalCheckboxes > 0) {
                        marcarTodasCheckbox.prop('checked', checkedCheckboxes === totalCheckboxes);
                    }
                }

                // Checkbox "Marcar todas" - evento change
                marcarTodasCheckbox.on('change', function (e) {
                    e.stopPropagation();
                    const isChecked = $(this).is(':checked');
                    marcarDesmarcarTodas(isChecked);
                });

                // Evento click no label - não usar preventDefault para permitir o comportamento padrão
                if (marcarTodasLabel.length > 0) {
                    marcarTodasLabel.on('click', function (e) {
                        // Não usar preventDefault - deixar o label funcionar normalmente
                        // O evento change do checkbox será disparado automaticamente
                        setTimeout(function () {
                            const isChecked = marcarTodasCheckbox.is(':checked');
                            marcarDesmarcarTodas(isChecked);
                        }, 50);
                    });
                }

                // Delegação de eventos para garantir que funcione mesmo se o elemento for adicionado dinamicamente
                $(document).off('change', '#marcar_todas_empresas_produto').on('change', '#marcar_todas_empresas_produto', function (e) {
                    e.stopPropagation();
                    const isChecked = $(this).is(':checked');
                    marcarDesmarcarTodas(isChecked);
                });
            } else {
                console.warn('Checkbox marcar_todas_empresas_produto não encontrado');
            }

            // Checkboxes individuais de empresas - usar delegação de eventos
            $(document).on('change', '.empresa-produto-checkbox', function () {
                atualizarEmpresasVinculadasProduto();

                // Atualizar estado do checkbox "Marcar todas" baseado nos checkboxes individuais
                const totalCheckboxes = $('.empresa-produto-checkbox').length;
                const checkedCheckboxes = $('.empresa-produto-checkbox:checked').length;

                if (marcarTodasCheckbox.length > 0) {
                    if (checkedCheckboxes === totalCheckboxes && totalCheckboxes > 0) {
                        marcarTodasCheckbox.prop('checked', true);
                    } else {
                        marcarTodasCheckbox.prop('checked', false);
                    }
                }
            });

            // Inicializar estado do checkbox "Marcar todas" após um pequeno delay
            setTimeout(function () {
                const totalCheckboxesProduto = $('.empresa-produto-checkbox').length;
                const checkedCheckboxesProduto = $('.empresa-produto-checkbox:checked').length;
                if (marcarTodasCheckbox.length > 0 && totalCheckboxesProduto > 0) {
                    if (checkedCheckboxesProduto === totalCheckboxesProduto) {
                        marcarTodasCheckbox.prop('checked', true);
                    } else {
                        marcarTodasCheckbox.prop('checked', false);
                    }
                }
            }, 100);
        });
</script>