<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-box-seam me-2"></i> Novo Produto/Item</h2>
        <p class="text-muted">Cadastre um novo produto ou serviço</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/produtos') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<form id="formProduto" method="POST" action="<?= url('/produtos/criar') ?>" enctype="multipart/form-data">
    <?php include __DIR__ . '/form.php'; ?>

    <div class="row mt-4">
        <div class="col-12">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="bi bi-check-circle me-2"></i> Salvar Produto
            </button>
            <a href="<?= url('/produtos') ?>" class="btn btn-outline-secondary btn-lg ms-2">
                <i class="bi bi-x-circle me-2"></i> Cancelar
            </a>
        </div>
    </div>
</form>

<script>
    (function aguardarJQuery() {
        if (typeof jQuery === 'undefined') {
            setTimeout(aguardarJQuery, 100);
            return;
        }

        $(document).ready(function () {
            $('#formProduto').on('submit', function (e) {
                e.preventDefault();

                // Atualizar empresas vinculadas antes de enviar
                if (typeof atualizarEmpresasVinculadasProduto === 'function') {
                    atualizarEmpresasVinculadasProduto();
                }

                // Atualizar campo hidden com empresas selecionadas
                const empresasInput = $('#empresas_vinculadas_produto_input');
                if (empresasInput.length > 0) {
                    const empresasSelecionadas = [];
                    $('.empresa-produto-checkbox:checked').each(function () {
                        empresasSelecionadas.push(parseInt($(this).val()));
                    });
                    empresasInput.val(JSON.stringify(empresasSelecionadas));
                }

                const formData = new FormData(this);

                // Garantir checkboxes não marcados
                $('input[type="checkbox"]').each(function () {
                    if (!$(this).is(':checked')) {
                        formData.append($(this).attr('name'), '0');
                    }
                });

                $.ajax({
                    url: appUrl('/produtos/criar'),
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message,
                                timer: 1500
                            }).then(() => {
                                const redirectPath = response.redirect || '/produtos';
                                if (redirectPath.startsWith('http')) {
                                    window.location.href = redirectPath;
                                } else {
                                    window.location.href = appUrl(redirectPath);
                                }
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: response.message
                            });
                        }
                    },
                    error: function (xhr) {
                        console.error('Erro:', xhr);
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: 'Erro ao salvar produto. Verifique os dados.'
                        });
                    }
                });
            });
        });
    })();
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'produtos';
include ROOT_PATH . '/views/layouts/app.php';
?>