<?php
$isEdit = isset($venda['id']);
$module = $module ?? [];
$singular = $module['singular'] ?? 'DAV';
$plural = $module['plural'] ?? 'DAVs';
$moduleSlug = $module['slug'] ?? ($module['origin'] ?? 'pre-vendas');
$isDav = in_array($module['origin'] ?? '', ['dav', 'pre_venda'], true) || $moduleSlug === 'pre-vendas';
$hideDespesas = (bool) ($module['hide_despesas'] ?? ($moduleSlug === 'pre-vendas' || ($module['origin'] ?? '') === 'pre_venda'));
$hideEntrega = (bool) ($module['hide_entrega'] ?? ($moduleSlug === 'pre-vendas' || ($module['origin'] ?? '') === 'pre_venda'));
?>

<!-- Abas -->
<ul class="nav nav-tabs mb-4" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados" type="button"
            role="tab">
            <i class="bi bi-file-earmark-text me-2"></i> Dados da <?= htmlspecialchars($singular) ?>
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="itens-tab" data-bs-toggle="tab" data-bs-target="#itens" type="button" role="tab">
            <i class="bi bi-cart-plus me-2"></i> Itens
        </button>
    </li>
    <?php if (!$hideDespesas): ?>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="despesas-tab" data-bs-toggle="tab" data-bs-target="#despesas" type="button"
            role="tab">
            <i class="bi bi-receipt me-2"></i> Despesas
        </button>
    </li>
    <?php endif; ?>
    <?php if (!$hideEntrega): ?>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="entrega-tab" data-bs-toggle="tab" data-bs-target="#entrega" type="button"
            role="tab">
            <i class="bi bi-truck me-2"></i> Entrega
        </button>
    </li>
    <?php endif; ?>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pagamento-tab" data-bs-toggle="tab" data-bs-target="#pagamento" type="button"
            role="tab">
            <i class="bi bi-credit-card me-2"></i> Pagamento e Valores
        </button>
    </li>
</ul>

<!-- Conteúdo das Abas -->
<div class="tab-content">
    <!-- Aba: Dados da Venda -->
    <div class="tab-pane fade show active" id="dados" role="tabpanel">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-file-earmark-text me-2"></i> Informações Principais
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="sale_number" class="form-label">Número da <?= htmlspecialchars($singular) ?> *</label>
                                <input type="text" readonly class="form-control bg-light" id="sale_number" name="sale_number"
                                    value="<?= htmlspecialchars($venda['sale_number'] ?? $proximoNumero ?? 'VND-000001') ?>"
                                    title="Gerado automaticamente" required>
                                <small class="text-muted">Gerado automaticamente</small>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="sale_date" class="form-label">Data da <?= htmlspecialchars($singular) ?> *</label>
                                <input type="date" class="form-control" id="sale_date" name="sale_date"
                                    value="<?= $venda['sale_date'] ?? date('Y-m-d') ?>" required>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="status" class="form-label">Status *</label>
                                <select class="form-select" id="status" name="status" required>
                                    <?php
                                    $statusVendas = $statusVendas ?? [];
                                    $statusAtual = $venda['status'] ?? ($statusPadrao ?? 'orcamento');

                                    if (empty($statusVendas)) {
                                        $moduleSlug = $module['slug'] ?? ($module['origin'] ?? 'vendas');
                                        if ($moduleSlug === 'pre-vendas' || ($module['origin'] ?? '') === 'pre_venda') {
                                            // Fallback específico para DAV (Pré-vendas)
                                            $statusVendas = [
                                                ['codigo' => 'orcamento', 'nome' => 'Orçamento'],
                                                ['codigo' => 'pendente', 'nome' => 'Pendente'],
                                            ];
                                        } else {
                                            // Fallback padrão das vendas
                                            $statusVendas = [
                                                ['codigo' => 'orcamento', 'nome' => 'Orçamento'],
                                                ['codigo' => 'pendente', 'nome' => 'Pendente'],
                                                ['codigo' => 'realizado', 'nome' => 'Realizado'],
                                                ['codigo' => 'faturamento', 'nome' => 'Faturamento'],
                                                ['codigo' => 'expedicao', 'nome' => 'Expedição'],
                                                ['codigo' => 'em_entrega', 'nome' => 'Em Entrega'],
                                                ['codigo' => 'finalizado', 'nome' => 'Finalizado'],
                                            ];
                                        }
                                    }

                                    foreach ($statusVendas as $status) {
                                        $codigo = $status['codigo'];
                                        $nome = $status['nome'];
                                        $selected = ($statusAtual === $codigo) ? 'selected' : '';
                                        echo "<option value=\"{$codigo}\" {$selected}>{$nome}</option>\n";
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Cliente com Autocomplete -->
                        <h6 class="text-primary mb-3">
                            <i class="bi bi-person me-2"></i> Cliente
                        </h6>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="customer_search" class="form-label">
                                    Cliente
                                    <small class="text-muted">(Digite para buscar ou deixe vazio para Consumidor
                                        Final)</small>
                                </label>
                                <div class="position-relative">
                                    <input type="text" class="form-control" id="customer_search"
                                        placeholder="Digite nome, razão social ou CNPJ/CPF do cliente..." autocomplete="off"
                                        value="<?= htmlspecialchars($venda['customer_name'] ?? '') ?>">
                                    <div id="customer_dropdown" class="autocomplete-dropdown" style="display: none;">
                                    </div>
                                </div>
                                <input type="hidden" id="customer_id" name="customer_id"
                                    value="<?= $venda['customer_id'] ?? '' ?>">
                                <input type="hidden" id="customer_type" name="customer_type"
                                    value="<?= $venda['customer_type'] ?? 'pessoa' ?>">
                                <input type="hidden" id="customer_name" name="customer_name"
                                    value="<?= htmlspecialchars($venda['customer_name'] ?? '') ?>">
                                <input type="hidden" id="customer_document" name="customer_document"
                                    value="<?= htmlspecialchars($venda['customer_document'] ?? '') ?>">
                            </div>
                            <div class="col-md-12" id="customer_info" style="display: none;">
                                <div class="alert alert-info mb-3">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="flex-grow-1">
                                            <div id="customer_info_name"></div>
                                        </div>
                                        <button type="button" class="btn btn-sm btn-outline-danger ms-2"
                                            onclick="limparCliente()">
                                            <i class="bi bi-x"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Vendedores -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="vendor_id" class="form-label">
                                    <i class="bi bi-person-badge me-1"></i> Vendedor Principal
                                </label>
                                <select class="form-select" id="vendor_id" name="vendor_id">
                                    <option value="">Nenhum</option>
                                    <?php if (!empty($vendedores)): ?>
                                    <?php foreach ($vendedores as $vendedor): ?>
                                    <option value="<?= $vendedor['id'] ?>"
                                        <?= ($venda['vendor_id'] ?? '') == $vendedor['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($vendedor['name']) ?>
                                    </option>
                                    <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="auxiliary_vendor_id" class="form-label">
                                    <i class="bi bi-person-plus me-1"></i> Vendedor Auxiliar
                                </label>
                                <select class="form-select" id="auxiliary_vendor_id" name="auxiliary_vendor_id">
                                    <option value="">Nenhum</option>
                                    <?php if (!empty($vendedores)): ?>
                                    <?php foreach ($vendedores as $vendedor): ?>
                                    <option value="<?= $vendedor['id'] ?>"
                                        <?= ($venda['auxiliary_vendor_id'] ?? '') == $vendedor['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($vendedor['name']) ?>
                                    </option>
                                    <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="notes" class="form-label">Observações</label>
                                <textarea class="form-control" id="notes" name="notes" rows="3"
                                    placeholder="Observações sobre esta venda..."><?= htmlspecialchars($venda['notes'] ?? '') ?></textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="observacoes_nfe" class="form-label">
                                    <i class="bi bi-file-earmark-text me-1"></i>
                                    Observações NF-e
                                </label>
                                <textarea class="form-control" id="observacoes_nfe" name="observacoes_nfe" rows="3"
                                    placeholder="Observações específicas que aparecerão na NF-e (ex: informações fiscais, complementares, etc.)..."><?= htmlspecialchars($venda['observacoes_nfe'] ?? '') ?></textarea>
                                <small class="text-muted">
                                    <i class="bi bi-info-circle me-1"></i>
                                    Estas observações aparecerão na NF-e emitida
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Itens da Venda -->
    <div class="tab-pane fade" id="itens" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-cart-plus me-2"></i> Produtos/Serviços
            </div>
            <div class="card-body">
                <!-- Bloco fixo para adicionar item -->
                <div class="card bg-light mb-4" id="bloco-adicionar-item">
                    <div class="card-body">
                        <h6 class="mb-3"><i class="bi bi-plus-circle me-2"></i> Adicionar Item</h6>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label class="form-label">Item</label>
                                <div class="position-relative">
                                    <input type="text" class="form-control item-search" id="item_search_principal"
                                        placeholder="Digite para buscar produto/serviço..." autocomplete="off">
                                    <div id="item_dropdown_principal" class="autocomplete-dropdown"
                                        style="display: none;"></div>
                                </div>
                                <input type="hidden" id="produto_id_principal" value="">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Qtd</label>
                                <input type="number" class="form-control form-control-sm quantidade text-center"
                                    id="qtd_principal" min="0.001" step="0.001" value="1">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Preço Unit. (R$)</label>
                                <input type="number" class="form-control form-control-sm preco-unitario"
                                    id="preco_principal" step="0.01" min="0" value="0">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Desc. (R$)</label>
                                <input type="number" class="form-control form-control-sm desconto"
                                    id="desconto_principal" step="0.01" min="0" value="0">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Total (R$)</label>
                                <input type="number" class="form-control form-control-sm total-item fw-bold"
                                    id="total_principal" step="0.01" readonly value="0">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Obs.</label>
                                <input type="text" class="form-control form-control-sm" id="obs_principal"
                                    placeholder="Obs">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">&nbsp;</label>
                                <button type="button" class="btn btn-sm btn-success w-100"
                                    onclick="adicionarItemNaTabela()">
                                    <i class="bi bi-plus-circle me-1"></i> Adicionar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tabela de itens adicionados -->
                <div id="tabela-itens">
                    <table class="table table-hover table-sm">
                        <thead class="table-light">
                            <tr>
                                <th width="35%">Item</th>
                                <th width="8%" class="text-center">Qtd</th>
                                <th width="10%" class="text-end">Unit.</th>
                                <th width="10%" class="text-end">Desc.</th>
                                <th width="10%" class="text-end">Total</th>
                                <th width="17%">Obs.</th>
                                <th width="10%"></th>
                            </tr>
                        </thead>
                        <tbody id="tbody-itens">
                            <!-- Itens serão adicionados aqui -->
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="4" class="text-end"><strong>Total:</strong></td>
                                <td class="text-end"><strong id="total-geral">R$ 0,00</strong></td>
                                <td colspan="2"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="alert alert-info" id="alert-sem-itens">
                    <i class="bi bi-info-circle me-2"></i>
                    Nenhum item adicionado. Use o formulário acima para adicionar itens.
                </div>
            </div>
        </div>
    </div>

    <?php if (!$hideDespesas): ?>
    <!-- Aba: Despesas -->
    <div class="tab-pane fade" id="despesas" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-receipt me-2"></i> Despesas Adicionais
            </div>
            <div class="card-body">
                <!-- Bloco para adicionar despesa -->
                <div class="card bg-light mb-4">
                    <div class="card-body">
                        <h6 class="mb-3"><i class="bi bi-plus-circle me-2"></i> Adicionar Despesa</h6>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="despesa_tipo" class="form-label">Tipo de Despesa</label>
                                <select class="form-select" id="despesa_tipo">
                                    <option value="">Selecione...</option>
                                    <option value="comissao">Comissão</option>
                                    <option value="frete">Frete</option>
                                    <option value="taxa_administrativa">Taxa Administrativa</option>
                                    <option value="embalagem">Embalagem</option>
                                    <option value="seguro">Seguro</option>
                                    <option value="outro">Outro</option>
                                </select>
                            </div>
                            <div class="col-md-5 mb-3">
                                <label for="despesa_descricao" class="form-label">Descrição</label>
                                <input type="text" class="form-control" id="despesa_descricao"
                                    placeholder="Descrição da despesa">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label for="despesa_valor" class="form-label">Valor (R$)</label>
                                <input type="number" class="form-control" id="despesa_valor" step="0.01" min="0"
                                    placeholder="0,00">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">&nbsp;</label>
                                <button type="button" class="btn btn-success w-100" onclick="adicionarDespesa()">
                                    <i class="bi bi-plus-circle me-1"></i> Adicionar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tabela de despesas -->
                <div id="tabela-despesas" style="display: none;">
                    <table class="table table-hover table-sm">
                        <thead class="table-light">
                            <tr>
                                <th width="20%">Tipo</th>
                                <th width="50%">Descrição</th>
                                <th width="20%" class="text-end">Valor</th>
                                <th width="10%"></th>
                            </tr>
                        </thead>
                        <tbody id="tbody-despesas">
                            <!-- Despesas serão adicionadas aqui -->
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="2" class="text-end"><strong>Total Despesas:</strong></td>
                                <td class="text-end"><strong id="total-despesas">R$ 0,00</strong></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="alert alert-info" id="alert-sem-despesas">
                    <i class="bi bi-info-circle me-2"></i>
                    Nenhuma despesa adicionada. Use o formulário acima para adicionar despesas.
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if (!$hideEntrega): ?>
    <!-- Aba: Entrega -->
    <div class="tab-pane fade" id="entrega" role="tabpanel">
        <div class="row">
            <!-- Endereço de Entrega -->
            <div class="col-lg-6">
                <div class="card h-100">
                    <div class="card-header">
                        <i class="bi bi-geo-alt me-2"></i> Endereço de Entrega
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8 mb-3">
                                <label for="delivery_street" class="form-label">Rua/Logradouro</label>
                                <input type="text" class="form-control" id="delivery_street" name="delivery_street"
                                    value="<?= htmlspecialchars($venda['delivery_street'] ?? '') ?>"
                                    placeholder="Nome da rua ou avenida">
                                </div>
                            <div class="col-md-4 mb-3">
                                <label for="delivery_number" class="form-label">Número</label>
                                <input type="text" class="form-control" id="delivery_number" name="delivery_number"
                                    value="<?= htmlspecialchars($venda['delivery_number'] ?? '') ?>"
                                    placeholder="123">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="delivery_complement" class="form-label">Complemento</label>
                                <input type="text" class="form-control" id="delivery_complement" name="delivery_complement"
                                    value="<?= htmlspecialchars($venda['delivery_complement'] ?? '') ?>"
                                    placeholder="Apartamento, bloco, sala...">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-5 mb-3">
                                <label for="delivery_city" class="form-label">Cidade</label>
                                <input type="text" class="form-control" id="delivery_city" name="delivery_city"
                                    value="<?= htmlspecialchars($venda['delivery_city'] ?? '') ?>" placeholder="Cidade">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label for="delivery_state" class="form-label">UF</label>
                                <input type="text" class="form-control text-uppercase" id="delivery_state" name="delivery_state"
                                    value="<?= htmlspecialchars($venda['delivery_state'] ?? '') ?>" placeholder="UF" maxlength="2">
                            </div>
                            <div class="col-md-5 mb-3">
                                <label for="delivery_zip" class="form-label">CEP</label>
                                <input type="text" class="form-control" id="delivery_zip" name="delivery_zip"
                                    value="<?= htmlspecialchars($venda['delivery_zip'] ?? '') ?>" placeholder="00000-000">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="delivery_date" class="form-label">Data de Entrega Prevista</label>
                                <input type="date" class="form-control" id="delivery_date" name="delivery_date"
                                    value="<?= $venda['delivery_date'] ?? '' ?>">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="delivery_notes" class="form-label">Observações da Entrega</label>
                                <textarea class="form-control" id="delivery_notes" name="delivery_notes" rows="3"
                                    placeholder="Instruções especiais para entrega..."><?= htmlspecialchars($venda['delivery_notes'] ?? '') ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Transportadora e Veículo -->
            <div class="col-lg-6">
                <div class="card h-100">
                    <div class="card-header">
                        <i class="bi bi-truck-front-fill me-2"></i> Transportadora e Veículo
                    </div>
                    <div class="card-body">
                        <h6 class="text-primary mb-3"><i class="bi bi-building me-2"></i> Transportadora</h6>

                        <div class="mb-3">
                            <label for="carrier_name" class="form-label">Nome da Transportadora</label>
                            <input type="text" class="form-control" id="carrier_name" name="carrier_name"
                                value="<?= htmlspecialchars($venda['carrier_name'] ?? '') ?>"
                                placeholder="Nome da transportadora">
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="carrier_cnpj" class="form-label">CNPJ</label>
                                <input type="text" class="form-control" id="carrier_cnpj" name="carrier_cnpj"
                                    value="<?= htmlspecialchars($venda['carrier_cnpj'] ?? '') ?>"
                                    placeholder="00.000.000/0000-00">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="carrier_ie" class="form-label">Inscrição Estadual</label>
                                <input type="text" class="form-control" id="carrier_ie" name="carrier_ie"
                                    value="<?= htmlspecialchars($venda['carrier_ie'] ?? '') ?>"
                                    placeholder="IE">
                            </div>
                        </div>

                        <hr class="my-3">

                        <h6 class="text-primary mb-3"><i class="bi bi-truck me-2"></i> Dados do Veículo</h6>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="vehicle_plate" class="form-label">Placa do Veículo</label>
                                <input type="text" class="form-control text-uppercase" id="vehicle_plate" name="vehicle_plate"
                                    value="<?= htmlspecialchars($venda['vehicle_plate'] ?? '') ?>"
                                    placeholder="ABC-1234" maxlength="8">
                                </div>
                            <div class="col-md-6 mb-3">
                                <label for="vehicle_state" class="form-label">UF Veículo</label>
                                <input type="text" class="form-control text-uppercase" id="vehicle_state" name="vehicle_state"
                                    value="<?= htmlspecialchars($venda['vehicle_state'] ?? '') ?>"
                                    placeholder="UF" maxlength="2">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="driver_name" class="form-label">Nome do Motorista</label>
                                <input type="text" class="form-control" id="driver_name" name="driver_name"
                                    value="<?= htmlspecialchars($venda['driver_name'] ?? '') ?>"
                                    placeholder="Nome completo do motorista">
                                </div>
                            </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="tracking_code" class="form-label">Código de Rastreamento</label>
                                <input type="text" class="form-control" id="tracking_code" name="tracking_code"
                                    value="<?= htmlspecialchars($venda['tracking_code'] ?? '') ?>"
                                    placeholder="Código de rastreio da entrega">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

    <!-- Aba: Pagamento e Valores -->
    <div class="tab-pane fade" id="pagamento" role="tabpanel">
        <!-- Card Único com 2 Colunas -->
                <div class="card">
                    <div class="card-header">
                <i class="bi bi-credit-card me-2"></i> Pagamento e Valores
                    </div>
                    <div class="card-body">
                        <div class="row">
                    <!-- Coluna Esquerda: Valores e Cálculos -->
                    <div class="col-lg-6">
                        <h6 class="text-primary mb-3"><i class="bi bi-currency-dollar me-2"></i> Valores</h6>

                        <div class="mb-3">
                            <label class="form-label"><strong>Subtotal</strong></label>
                            <div class="input-group">
                                <span class="input-group-text">R$</span>
                                <input type="text" class="form-control text-end" id="subtotal_display" readonly
                                    value="0,00">
                            </div>
                            <input type="hidden" id="subtotal" name="subtotal" value="0.00">
                            <small class="text-muted">Itens + Despesas</small>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="discount_type" class="form-label">Tipo de Desconto</label>
                                <select class="form-select" id="discount_type" name="discount_type">
                                    <option value="fixed"
                                        <?= ($venda['discount_type'] ?? 'fixed') === 'fixed' ? 'selected' : '' ?>>Valor
                                        Fixo (R$)</option>
                                    <option value="percent"
                                        <?= ($venda['discount_type'] ?? '') === 'percent' ? 'selected' : '' ?>>
                                        Percentual (%)</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="discount" class="form-label">Desconto</label>
                                <input type="number" class="form-control" id="discount" name="discount" step="0.01"
                                    min="0" value="<?= $venda['discount'] ?? '0.00' ?>" placeholder="0,00">
                            </div>
                        </div>

                        <hr class="my-3">

                        <div class="mb-3">
                            <label class="form-label"><strong class="text-success fs-5">TOTAL FINAL</strong></label>
                            <div class="input-group input-group-lg">
                                <span class="input-group-text bg-success text-white fw-bold">R$</span>
                                <input type="text" class="form-control text-end fw-bold" id="total_display" readonly
                                    value="0,00">
                            </div>
                            <input type="hidden" id="total" name="total" value="0.00">
                        </div>
                    </div>

                    <!-- Coluna Direita: Forma de Pagamento e Opções -->
                    <div class="col-lg-6">
                        <h6 class="text-primary mb-3"><i class="bi bi-credit-card me-2"></i> Forma de Pagamento</h6>

                        <div class="mb-3">
                                <label for="payment_method_id" class="form-label">Método de Pagamento</label>
                                <select class="form-select" id="payment_method_id" name="payment_method_id">
                                    <option value="">Selecione...</option>
                                    <?php if (!empty($metodosPagamento)): ?>
                                    <?php foreach ($metodosPagamento as $metodo): ?>
                                    <option value="<?= $metodo['id'] ?>"
                                        <?= ($venda['payment_method_id'] ?? '') == $metodo['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($metodo['name']) ?>
                                    </option>
                                    <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>

                        <!-- Campos hidden para manter compatibilidade com backend -->
                        <input type="hidden" id="additions" name="additions" value="0.00">
                        <input type="hidden" id="shipping" name="shipping" value="<?= $venda['shipping'] ?? '0.00' ?>">
                        <input type="hidden" id="installments" name="installments" value="<?= $venda['installments'] ?? 1 ?>">

                        <!-- Exibição do Parcelamento Selecionado -->
                        <div id="parcelamento-info" class="alert alert-info mb-3 d-none" style="border-left: 4px solid #0dcaf0; background-color: #e7f3ff;">
                            <div class="d-flex align-items-start">
                                <i class="bi bi-calendar-check me-2 mt-1" style="font-size: 1.25rem;"></i>
                                <div class="flex-grow-1">
                                    <strong class="d-block mb-2" style="color: #0d6efd;">
                                        <i class="bi bi-receipt-cutoff me-1"></i> Parcelamento Selecionado
                                    </strong>
                                    <div id="parcelamento-detalhes" style="font-size: 0.95rem; line-height: 1.5;"></div>
                                </div>
                                <button type="button" class="btn btn-sm btn-link text-primary p-0 ms-2" onclick="$('#payment_method_id').trigger('change')" title="Alterar parcelamento">
                                    <i class="bi bi-pencil-fill"></i>
                                </button>
                            </div>
                        </div>

                        <hr class="my-3">

                        <?php if ($isDav): ?>
                        <input type="hidden" name="generate_receivables" value="0">
                        <input type="hidden" name="update_stock" value="0">
                        <h6 class="text-primary mb-3"><i class="bi bi-clipboard-data me-2"></i> Resumo do Pagamento</h6>
                        <div id="resumo-pagamento" class="resumo-pagamento-card resumo-pagamento-vazio">
                            <div id="resumo-placeholder" class="text-muted small">
                                Defina o método de pagamento para visualizar o resumo.
                            </div>
                            <div id="resumo-dados" class="d-none">
                                <div class="resumo-info-linha">
                                    <span class="resumo-label"><i class="bi bi-credit-card me-2"></i>Forma de Pagamento</span>
                                    <strong id="resumo-metodo">—</strong>
                                </div>
                                <div class="resumo-info-linha">
                                    <span class="resumo-label"><i class="bi bi-cash-coin me-2"></i>Total da DAV</span>
                                    <strong id="resumo-total">R$ 0,00</strong>
                                </div>
                                <div class="resumo-info-parcelas">
                                    <span class="resumo-label d-block mb-1"><i class="bi bi-calendar-check me-2"></i>Parcelamento</span>
                                    <div id="resumo-parcelamento" class="small text-muted">
                                        Pagamento à vista
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php else: ?>
                        <h6 class="text-primary mb-3"><i class="bi bi-gear me-2"></i> Opções</h6>

                        <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="generate_receivables"
                                        name="generate_receivables" value="1"
                                        <?= ($venda['generate_receivables'] ?? 1) ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="generate_receivables">
                                    <strong><i class="bi bi-receipt me-1"></i> Gerar Contas a Receber</strong>
                                    </label>
                                </div>
                            <small class="text-muted">Se ativado, serão criadas parcelas no módulo de Contas a
                                Receber</small>
                            </div>

                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="update_stock" name="update_stock"
                                    value="1" <?= ($venda['update_stock'] ?? 1) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="update_stock">
                                    <strong><i class="bi bi-box-seam me-1"></i> Atualizar Estoque</strong>
                                </label>
                            </div>
                            <small class="text-muted">Se ativado, o estoque dos produtos será baixado
                                automaticamente</small>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($isEdit): ?>
<input type="hidden" name="id" value="<?= $venda['id'] ?>">
<?php endif; ?>

<style>
.autocomplete-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: var(--bs-body-bg, #fff);
    border: 1px solid var(--bs-border-color, #dee2e6);
    border-top: none;
    border-radius: 0 0 0.375rem 0.375rem;
    max-height: 300px;
    overflow-y: auto;
    z-index: 1000;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

.autocomplete-item {
    padding: 0.875rem 1rem;
    cursor: pointer;
    border-bottom: 1px solid var(--bs-border-color, #f0f0f0);
    transition: all 0.15s ease-in-out;
    line-height: 1.5;
}

.autocomplete-item:hover,
.autocomplete-item.active {
    background-color: var(--bs-primary, #0d6efd);
    color: white;
    transform: translateX(3px);
}

.autocomplete-item:hover .text-muted {
    color: rgba(255, 255, 255, 0.8) !important;
}

.autocomplete-item:last-child {
    border-bottom: none;
}

.autocomplete-item .mb-1 {
    margin-bottom: 0.375rem;
}

.autocomplete-item strong {
    font-weight: 600;
}

.autocomplete-no-results {
    padding: 1rem;
    text-align: center;
    color: var(--bs-secondary, #6c757d);
    font-style: italic;
}

/* Modal de Prazos */
.swal-wide .list-group-item {
    cursor: pointer;
    transition: all 0.2s;
    padding: 1rem;
}

.swal-wide .list-group-item:hover {
    background-color: #f0f8ff;
    transform: translateX(3px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.swal-wide .list-group-item h6 {
    color: #2c3e50;
    font-weight: 600;
    font-size: 1rem;
    margin: 0;
}

.swal-wide .list-group-item p {
    color: #6c757d;
    font-size: 0.875rem;
    margin: 0;
    line-height: 1.4;
}

.swal-wide .prazo-item .d-flex > div:first-child {
    flex: 1;
}

/* Info de Parcelamento */
#parcelamento-info {
    background-color: #e7f3ff;
    border-color: #0dcaf0;
    animation: fadeInDown 0.3s;
}

#parcelamento-info strong {
    color: #0d6efd;
}

#parcelamento-info .btn-link {
    text-decoration: none;
    font-size: 1rem;
}

#parcelamento-info .btn-link:hover {
    opacity: 0.7;
}

@keyframes fadeInDown {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.resumo-pagamento-card {
    border: 1px solid rgba(13, 110, 253, 0.2);
    background: rgba(13, 110, 253, 0.08);
    border-radius: 0.75rem;
    padding: 1.25rem;
    transition: all 0.2s ease-in-out;
}

.resumo-pagamento-card.resumo-pagamento-vazio {
    border-style: dashed;
    opacity: 0.85;
    background: rgba(255, 255, 255, 0.03);
}

.resumo-info-linha {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 0.85rem;
}

.resumo-info-linha:last-of-type {
    margin-bottom: 1rem;
}

.resumo-label {
    font-weight: 500;
    color: var(--bs-body-color);
    display: flex;
    align-items: center;
    gap: 0.35rem;
}

#resumo-parcelamento {
    border-radius: 0.6rem;
    background: rgba(13, 110, 253, 0.12);
    padding: 0.75rem 0.85rem;
    color: var(--bs-body-color);
}

#resumo-parcelamento strong {
    color: var(--bs-body-color);
}
</style>

<script>
// Declarar variáveis PRIMEIRO (antes de usar)
let itensTabela = [];
let itemIndex = 0;
let itemTimeoutPrincipal = null;
let despesasTabela = [];
let despesaIndex = 0;
const isDav = <?= $isDav ? 'true' : 'false' ?>;

// Lista de clientes e produtos do PHP
const clientesData = <?= json_encode($clientes ?? []) ?>;
const produtosData = <?= json_encode($produtos ?? []) ?>;
let selectedCustomer = null;
let autocompleteTimeout = null;
let selectedProduto = null;

// Aguardar jQuery e inicializar
(function aguardarJQuery() {
    if (typeof jQuery === 'undefined') {
        setTimeout(aguardarJQuery, 100);
        return;
    }
    inicializarFormularioVenda();
})();

// ============================================
// AUTOCOMPLETE DE CLIENTE
// ============================================
function inicializarAutocompleteCliente() {
    const $search = $('#customer_search');
    const $dropdown = $('#customer_dropdown');

    // Ao digitar
    $search.on('input', function() {
        const query = $(this).val().trim().toLowerCase();

        clearTimeout(autocompleteTimeout);

        if (query.length < 2) {
            $dropdown.hide();
            return;
        }

        autocompleteTimeout = setTimeout(() => {
            buscarClientes(query);
        }, 300);
    });

    // Ao clicar fora, fechar dropdown
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#customer_search, #customer_dropdown').length) {
            $dropdown.hide();
        }
    });

    // Ao focar no campo
    $search.on('focus', function() {
        if ($(this).val().length >= 2) {
            buscarClientes($(this).val().trim().toLowerCase());
        }
    });

    // Ao pressionar Enter, apenas prevenir submit
    $search.on('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
        }
    });

    // Carregar cliente existente se estiver editando
    <?php if ($isEdit && !empty($venda['customer_id'])): ?>
    const clienteInicial = clientesData.find(c => c.id == <?= $venda['customer_id'] ?>);
    if (clienteInicial) {
        selecionarCliente(clienteInicial);
    }
    <?php endif; ?>
}

function buscarClientes(query) {
    const $dropdown = $('#customer_dropdown');

    // Filtrar clientes
    const results = clientesData.filter(cliente => {
        const name = (cliente.name || '').toLowerCase();
        const tradeName = (cliente.trade_name || '').toLowerCase();
        const document = (cliente.document || '').toLowerCase();
        const email = (cliente.email || '').toLowerCase();
        const phone = (cliente.phone || '').toLowerCase();
        const mobile = (cliente.mobile || '').toLowerCase();

        // Normalizar query e documento para busca mais flexível
        const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
        const normalizedDocument = document.replace(/[^\d\w]/g, '').toLowerCase();

        return name.includes(query) || tradeName.includes(query) ||
            document.includes(query) || normalizedDocument.includes(normalizedQuery) ||
            email.includes(query) || phone.includes(query) || mobile.includes(query);
    });

    // Montar HTML
    let html = '';

    if (results.length > 0) {
        results.forEach(cliente => {
            const nomeFantasia = cliente.trade_name || '-';
            const razaoSocial = cliente.name || '-';
            const documento = cliente.document || 'Não informado';
            const codigo = String(cliente.id).padStart(4, '0');
            const telefone = cliente.phone || cliente.mobile || '-';
            const email = cliente.email || '-';

            html += `
                <div class="autocomplete-item" data-id="${cliente.id}">
                    <div class="mb-1">
                        <strong>Código: ${codigo}</strong>  |  <strong>CNPJ/CPF:</strong> ${documento}
                    </div>
                    <div class="mb-1">
                        <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                    </div>
                    <div class="text-muted small">
                        <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                    </div>
                </div>
            `;
        });
    } else {
        html = '<div class="autocomplete-no-results">Nenhum cliente encontrado</div>';
    }

    $dropdown.html(html).show();

    // Event listeners
    $dropdown.find('.autocomplete-item').on('click', function() {
        const clienteId = $(this).data('id');
        const cliente = clientesData.find(c => c.id == clienteId);
        if (cliente) {
            selecionarCliente(cliente);
        }
    });
}

function selecionarCliente(cliente) {
    selectedCustomer = cliente;

    const nomeFantasia = cliente.trade_name || '-';
    const razaoSocial = cliente.name || '-';
    const nomeExibir = nomeFantasia !== '-' ? nomeFantasia : razaoSocial;
    const codigo = String(cliente.id).padStart(4, '0');
    const documento = cliente.document || 'Não informado';
    const telefone = cliente.phone || cliente.mobile || '-';
    const email = cliente.email || '-';

    // Preencher campos hidden
    $('#customer_id').val(cliente.id);
    $('#customer_type').val('pessoa');
    $('#customer_name').val(razaoSocial);
    $('#customer_document').val(cliente.document || '');

    // Atualizar campo de busca
    $('#customer_search').val(nomeExibir);

    // Mostrar info do cliente no formato estruturado
    let infoHtml = `
        <div style="line-height: 1.6;">
            <div class="mb-1">
                <strong>Código: ${codigo}</strong>  |  ${documento}
            </div>
            <div class="mb-1">
                <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
            </div>
            <div class="text-muted small">
                <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
            </div>
        </div>
    `;

    $('#customer_info_name').html(infoHtml);
    $('#customer_info_document').text('');
    $('#customer_info_email').text('');

    $('#customer_info').slideDown();

    // Fechar dropdown
    $('#customer_dropdown').hide();
}

function limparCliente() {
    selectedCustomer = null;

    $('#customer_id').val('');
    $('#customer_type').val('pessoa');
    $('#customer_name').val('');
    $('#customer_document').val('');
    $('#customer_search').val('');

    $('#customer_info').slideUp();
}

function inicializarFormularioVenda() {
    // Inicializar autocomplete de clientes
    inicializarAutocompleteCliente();

    // Calcular valores quando houver mudança
    $('#discount, #discount_type').on('input change', function() {
        calcularTotalGeral();
    });

    // Evento ao selecionar método de pagamento
    $('#payment_method_id').on('change', function() {
        const metodoId = $(this).val();

        // Limpar informação de parcelamento anterior
        $('#parcelamento-info').addClass('d-none');
        $('#installments').val(1);

        if (metodoId) {
            mostrarPrazosMetodoPagamento(metodoId);
        } else {
            // Se não houver método selecionado, ocultar parcelamento
            $('#parcelamento-info').addClass('d-none');
        }

        atualizarResumoPagamento();
    });

    // Carregar parcelamento existente se estiver editando
    <?php if ($isEdit && !empty($venda['payment_method_id']) && !empty($venda['installments']) && $venda['installments'] > 1): ?>
    $(document).ready(function() {
        const metodoId = <?= $venda['payment_method_id'] ?>;
        const parcelas = <?= $venda['installments'] ?? 1 ?>;
        const totalFinal = parseFloat($('#total').val()) || parseFloat('<?= $venda['total'] ?? 0 ?>');

        if (parcelas > 1 && totalFinal > 0) {
            // Buscar dias do prazo se houver payment_term_id
            <?php if (!empty($venda['payment_term_id'])): ?>
            $.ajax({
                url: appUrl('/metodos-pagamento/buscar-prazos'),
                method: 'GET',
                data: { metodo_id: metodoId },
                success: function(response) {
                    if (response.success && response.data.prazos && response.data.prazos.length > 0) {
                        const prazoEncontrado = response.data.prazos.find(p => Math.ceil(p.dias / 30) === parcelas);
                        const dias = prazoEncontrado ? prazoEncontrado.dias : (parcelas * 30);

                        // Calcular valores das parcelas
                        const valorParcela = totalFinal / parcelas;
                        const valorParcelaInteiro = Math.floor(valorParcela * 100) / 100;
                        const valorUltimaParcela = totalFinal - (valorParcelaInteiro * (parcelas - 1));

                        // Montar descrição
                        let descricaoDetalhada = '';
                        if (parcelas === 1) {
                            descricaoDetalhada = `<strong>${parcelas}x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
                        } else {
                            if (Math.abs(valorUltimaParcela - valorParcelaInteiro) < 0.01) {
                                descricaoDetalhada = `<strong>${parcelas}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
                            } else {
                                descricaoDetalhada = `<strong>${parcelas - 1}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> + <strong>1x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
                            }
                        }

                        $('#parcelamento-detalhes').html(descricaoDetalhada);
                        $('#parcelamento-info').removeClass('d-none');
                    }
                }
            });
            <?php else: ?>
            // Se não houver payment_term_id, usar cálculo padrão
            const dias = parcelas * 30;
            const valorParcela = totalFinal / parcelas;
            const valorParcelaInteiro = Math.floor(valorParcela * 100) / 100;
            const valorUltimaParcela = totalFinal - (valorParcelaInteiro * (parcelas - 1));

            let descricaoDetalhada = '';
            if (parcelas === 1) {
                descricaoDetalhada = `<strong>${parcelas}x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong>`;
            } else {
                if (Math.abs(valorUltimaParcela - valorParcelaInteiro) < 0.01) {
                    descricaoDetalhada = `<strong>${parcelas}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong>`;
                } else {
                    descricaoDetalhada = `<strong>${parcelas - 1}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> + <strong>1x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong>`;
                }
            }

            $('#parcelamento-detalhes').html(descricaoDetalhada);
            $('#parcelamento-info').removeClass('d-none');
            <?php endif; ?>
        }
    });
    <?php endif; ?>

    // Validação de vendedores - não permitir mesmo vendedor em ambos campos
    function atualizarSelectsVendedores() {
        const vendorPrincipal = $('#vendor_id').val();
        const vendorAuxiliar = $('#auxiliary_vendor_id').val();

        // Atualizar select do vendedor auxiliar
        $('#auxiliary_vendor_id option').each(function() {
            const optionValue = $(this).val();
            if (optionValue && optionValue === vendorPrincipal) {
                $(this).prop('disabled', true);
            } else {
                $(this).prop('disabled', false);
            }
        });

        // Atualizar select do vendedor principal
        $('#vendor_id option').each(function() {
            const optionValue = $(this).val();
            if (optionValue && optionValue === vendorAuxiliar) {
                $(this).prop('disabled', true);
            } else {
                $(this).prop('disabled', false);
            }
        });

        // Se ambos forem iguais, limpar o auxiliar e mostrar aviso
        if (vendorPrincipal && vendorAuxiliar && vendorPrincipal === vendorAuxiliar) {
            $('#auxiliary_vendor_id').val('');
            Swal.fire({
                icon: 'warning',
                title: 'Atenção',
                text: 'O vendedor principal e o vendedor auxiliar não podem ser a mesma pessoa!',
                toast: true,
                position: 'top-end',
                timer: 3000,
                showConfirmButton: false
            });
        }
    }

    $('#vendor_id, #auxiliary_vendor_id').on('change', atualizarSelectsVendedores);

    // Executar na inicialização para garantir estado correto
    atualizarSelectsVendedores();

    // Ocultar tabela inicialmente apenas se não for edição
    <?php if (!$isEdit || empty($itens)): ?>
    $('#tabela-itens').hide();
    $('#alert-sem-itens').show();
    <?php else: ?>
    $('#tabela-itens').show();
    $('#alert-sem-itens').hide();
    console.log('Tabela deve estar visível (modo edição com itens)');
    <?php endif; ?>

    // Inicializar autocomplete de item principal
    inicializarAutocompleteItemPrincipal();

    // Calcular total ao mudar campos do item principal
    $('#qtd_principal, #preco_principal, #desconto_principal').on('input', function() {
        calcularTotalPrincipal();
    });

    // Carregar itens existentes se estiver editando
    <?php if ($isEdit && !empty($itens)): ?>
    console.log('=== INICIANDO CARGA DE ITENS ===');
    console.log('Modo de edição: SIM');
    console.log('Total de itens a carregar: <?= count($itens) ?>');
    console.log('Itens do PHP:', <?= json_encode($itens) ?>);

    <?php foreach ($itens as $index => $item): ?>
    console.log('--- Processando item <?= $index + 1 ?> ---');
    const itemCarregado_<?= $index ?> = <?= json_encode($item) ?>;
    console.log('Dados do item:', itemCarregado_<?= $index ?>);
    // Não adicionar aqui - a função adicionarItemNaTabela já faz isso
    adicionarItemNaTabela(itemCarregado_<?= $index ?>, true);
    console.log('Item processado. Total no array:', itensTabela.length);
    <?php endforeach; ?>

    console.log('=== FINALIZANDO CARGA DE ITENS ===');
    console.log('Total de itens no array:', itensTabela.length);
    atualizarTotalGeral();
    <?php else: ?>
    console.log('=== MODO CRIAR NOVA VENDA ===');
    console.log('Modo de edição:', <?= $isEdit ? 'true' : 'false' ?>);
    console.log('Itens disponíveis:', <?= json_encode($itens ?? []) ?>);
    <?php endif; ?>

    // Calcular totais ao inicializar (para preencher os campos mesmo sem itens)
    calcularTotalGeral();
    atualizarResumoPagamento();
}

// ============================================
// AUTOCOMPLETE E GERENCIAMENTO DE ITENS
// ============================================
function inicializarAutocompleteItemPrincipal() {
    const $search = $('#item_search_principal');
    const $dropdown = $('#item_dropdown_principal');

    $search.on('input', function() {
        const query = $(this).val().trim().toLowerCase();
        clearTimeout(itemTimeoutPrincipal);

        if (query.length < 2) {
            $dropdown.hide();
            return;
        }

        itemTimeoutPrincipal = setTimeout(() => {
            buscarProdutosPrincipal(query);
        }, 300);
    });

    $search.on('focus', function() {
        if ($(this).val().length >= 2) {
            buscarProdutosPrincipal($(this).val().trim().toLowerCase());
        }
    });

    $search.on('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
        }
    });

    $(document).on('click', function(e) {
        if (!$(e.target).closest('#item_search_principal, #item_dropdown_principal').length) {
            $dropdown.hide();
        }
    });
}

function buscarProdutosPrincipal(query) {
    const $dropdown = $('#item_dropdown_principal');
    const results = produtosData.filter(produto => {
        const name = (produto.name || '').toLowerCase();
        const sku = (produto.sku || '').toLowerCase();
        return name.includes(query) || sku.includes(query);
    });

    let html = '';
    if (results.length > 0) {
        results.forEach(produto => {
            const estoque = produto.stock_quantity || 0;
            const preco = parseFloat(produto.price || 0);
            html += `
                <div class="autocomplete-item" data-id="${produto.id}">
                    <div class="mb-1"><strong>${produto.name}</strong>${produto.sku ? ' <span class="text-muted">(' + produto.sku + ')</span>' : ''}</div>
                    <div class="text-muted small"><strong>Preço:</strong> R$ ${preco.toFixed(2).replace('.', ',')}  |  <strong>Estoque:</strong> ${estoque} ${produto.unit || 'un'}</div>
                </div>
            `;
        });
    } else {
        html = '<div class="autocomplete-no-results">Nenhum produto encontrado</div>';
    }

    $dropdown.html(html).show();

    $dropdown.find('.autocomplete-item').on('click', function() {
        const produtoId = $(this).data('id');
        const produto = produtosData.find(p => p.id == produtoId);
        if (produto) {
            selecionarProdutoPrincipal(produto);
        }
    });
}

function selecionarProdutoPrincipal(produto) {
    selectedProduto = produto;
    $('#produto_id_principal').val(produto.id);
    $('#item_search_principal').val(produto.name);
    $('#preco_principal').val(parseFloat(produto.price || 0).toFixed(2));
    $('#item_dropdown_principal').hide();
    $('#qtd_principal').focus().select();
    calcularTotalPrincipal();

    // Armazenar dados fiscais do produto
    selectedProduto.fiscal = {
        ncm: produto.ncm || '',
        cest: produto.cest || '',
        cfop: produto.cfop || '',
        origem: produto.origem || '',
        cst_icms: produto.cst_icms || '',
        aliquota_icms: produto.aliquota_icms || 0,
        cst_pis: produto.cst_pis || '',
        aliquota_pis: produto.aliquota_pis || 0,
        cst_cofins: produto.cst_cofins || '',
        aliquota_cofins: produto.aliquota_cofins || 0,
        cst_ipi: produto.cst_ipi || '',
        aliquota_ipi: produto.aliquota_ipi || 0
    };
}

function calcularTotalPrincipal() {
    const qtd = parseFloat($('#qtd_principal').val()) || 0;
    const preco = parseFloat($('#preco_principal').val()) || 0;
    const desconto = parseFloat($('#desconto_principal').val()) || 0;
    const total = (qtd * preco) - desconto;
    $('#total_principal').val(total.toFixed(2));
}

function adicionarItemNaTabela(itemData = null, isLoad = false) {
    let item;

    if (itemData) {
        // Se for carga de dados existentes (edição), garantir compatibilidade
        item = {
            product_id: itemData.product_id || '',
            product_name: itemData.product_name || '',
            product_sku: itemData.product_sku || '',
            quantity: itemData.quantity || 1,
            unit_price: itemData.unit_price || 0,
            discount: itemData.discount || 0,
            discount_type: itemData.discount_type || 'fixed',
            total_price: itemData.total_price || 0,
            notes: itemData.notes || '',
            ncm: itemData.ncm || '',
            cest: itemData.cest || '',
            cfop: itemData.cfop || '',
            origem: itemData.origem || '',
            cst_icms: itemData.cst_icms || '',
            aliquota_icms: itemData.aliquota_icms || 0,
            cst_pis: itemData.cst_pis || '',
            aliquota_pis: itemData.aliquota_pis || 0,
            cst_cofins: itemData.cst_cofins || '',
            aliquota_cofins: itemData.aliquota_cofins || 0,
            cst_ipi: itemData.cst_ipi || '',
            aliquota_ipi: itemData.aliquota_ipi || 0
        };
    } else {
        // Novo item do formulário
        item = {
        product_id: $('#produto_id_principal').val() || '',
        product_name: $('#item_search_principal').val() || '',
        product_sku: selectedProduto?.sku || '',
        quantity: $('#qtd_principal').val() || 1,
        unit_price: $('#preco_principal').val() || 0,
        discount: $('#desconto_principal').val() || 0,
        discount_type: 'fixed',
        total_price: $('#total_principal').val() || 0,
        notes: $('#obs_principal').val() || '',
        ncm: selectedProduto?.fiscal?.ncm || '',
        cest: selectedProduto?.fiscal?.cest || '',
        cfop: selectedProduto?.fiscal?.cfop || '',
        origem: selectedProduto?.fiscal?.origem || '',
        cst_icms: selectedProduto?.fiscal?.cst_icms || '',
        aliquota_icms: selectedProduto?.fiscal?.aliquota_icms || 0,
        cst_pis: selectedProduto?.fiscal?.cst_pis || '',
        aliquota_pis: selectedProduto?.fiscal?.aliquota_pis || 0,
        cst_cofins: selectedProduto?.fiscal?.cst_cofins || '',
        aliquota_cofins: selectedProduto?.fiscal?.aliquota_cofins || 0,
        cst_ipi: selectedProduto?.fiscal?.cst_ipi || '',
        aliquota_ipi: selectedProduto?.fiscal?.aliquota_ipi || 0
    };
    }

    if (!item.product_name && !item.product_id) {
        if (!isLoad) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção',
            text: 'Selecione ou digite um item!'
        });
        $('#item_search_principal').focus();
        }
        return;
    }

    const index = itensTabela.length;
    itensTabela.push(item);

    const $tbody = $('#tbody-itens');

    // Escapar valores para evitar problemas de HTML injection
    const escapeHtml = (text) => {
        const map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        };
        return String(text || '').replace(/[&<>"']/g, m => map[m]);
    };

    const $row = $(`
        <tr data-index="${index}">
            <td>${escapeHtml(item.product_name)}</td>
            <td class="text-center">${parseFloat(item.quantity).toFixed(3)}</td>
            <td class="text-end">R$ ${parseFloat(item.unit_price).toFixed(2)}</td>
            <td class="text-end">R$ ${parseFloat(item.discount).toFixed(2)}</td>
            <td class="text-end"><strong>R$ ${parseFloat(item.total_price).toFixed(2)}</strong></td>
            <td>${escapeHtml(item.notes) || '-'}</td>
            <td class="text-center">
                <div class="btn-group btn-group-sm" role="group">
                    <button type="button" class="btn btn-outline-primary" onclick="editarItemDaTabela(${index})" title="Alterar item">
                        <i class="bi bi-pencil"></i>
                    </button>
                    <button type="button" class="btn btn-outline-danger" onclick="removerItemDaTabela(${index})" title="Remover item">
                    <i class="bi bi-trash"></i>
                </button>
                </div>
            </td>
            <input type="hidden" name="itens[${index}][product_id]" value="${escapeHtml(item.product_id)}">
            <input type="hidden" name="itens[${index}][product_name]" value="${escapeHtml(item.product_name)}">
            <input type="hidden" name="itens[${index}][product_sku]" value="${escapeHtml(item.product_sku)}">
            <input type="hidden" name="itens[${index}][quantity]" value="${item.quantity}">
            <input type="hidden" name="itens[${index}][unit_price]" value="${item.unit_price}">
            <input type="hidden" name="itens[${index}][discount]" value="${item.discount}">
            <input type="hidden" name="itens[${index}][discount_type]" value="fixed">
            <input type="hidden" name="itens[${index}][total_price]" value="${item.total_price}">
            <input type="hidden" name="itens[${index}][notes]" value="${escapeHtml(item.notes)}">
            <input type="hidden" name="itens[${index}][ncm]" value="${escapeHtml(item.ncm)}">
            <input type="hidden" name="itens[${index}][cest]" value="${escapeHtml(item.cest)}">
            <input type="hidden" name="itens[${index}][cfop]" value="${escapeHtml(item.cfop)}">
            <input type="hidden" name="itens[${index}][origem]" value="${escapeHtml(item.origem)}">
            <input type="hidden" name="itens[${index}][cst_icms]" value="${escapeHtml(item.cst_icms)}">
            <input type="hidden" name="itens[${index}][aliquota_icms]" value="${item.aliquota_icms || 0}">
            <input type="hidden" name="itens[${index}][cst_pis]" value="${escapeHtml(item.cst_pis)}">
            <input type="hidden" name="itens[${index}][aliquota_pis]" value="${item.aliquota_pis || 0}">
            <input type="hidden" name="itens[${index}][cst_cofins]" value="${escapeHtml(item.cst_cofins)}">
            <input type="hidden" name="itens[${index}][aliquota_cofins]" value="${item.aliquota_cofins || 0}">
            <input type="hidden" name="itens[${index}][cst_ipi]" value="${escapeHtml(item.cst_ipi)}">
            <input type="hidden" name="itens[${index}][aliquota_ipi]" value="${item.aliquota_ipi || 0}">
        </tr>
    `);

    $tbody.append($row);

    console.log('Item adicionado à tabela. Total de itens:', itensTabela.length);

    if (!isLoad) {
        limparCamposItem();
        atualizarTotalGeral();
    }

    // Garantir que a tabela seja exibida e o alerta ocultado
    $('#alert-sem-itens').hide();
    $('#tabela-itens').show();
}

function removerItemDaTabela(index) {
    itensTabela.splice(index, 1);

    // Remover linha da tabela
    $(`#tbody-itens tr[data-index="${index}"]`).remove();

    // Reindexar
    $('#tbody-itens tr').each(function(i) {
        $(this).attr('data-index', i);
        // Atualizar onclick de ambos os botões
        $(this).find('button').eq(0).attr('onclick', `editarItemDaTabela(${i})`);
        $(this).find('button').eq(1).attr('onclick', `removerItemDaTabela(${i})`);
    });

    // Reindexar inputs hidden
    $('#tbody-itens input[type="hidden"]').each(function(i) {
        const input = $(this);
        const name = input.attr('name').replace(/\[\d+\]/, `[${i}]`);
        input.attr('name', name);
    });

    atualizarTotalGeral();

    if (itensTabela.length === 0) {
        $('#alert-sem-itens').show();
        $('#tabela-itens').hide();
    }
}

async function editarItemDaTabela(index) {
    console.log('=== EDITANDO ITEM ===');
    console.log('Índice:', index);

    // Pegar o item do array
    const item = itensTabela[index];

    if (!item) {
        Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: 'Item não encontrado!'
        });
        return;
    }

    console.log('Item a editar:', item);

    // Abrir modal com SweetAlert2
    const {
        value: formValues
    } = await Swal.fire({
        title: '<i class="bi bi-pencil-square me-2"></i>Alterar Item',
        html: `
            <div class="text-start">
                <div class="mb-3">
                    <label class="form-label fw-bold">Produto/Serviço</label>
                    <input type="text" id="swal-product" class="form-control" value="${item.product_name}" readonly>
                </div>

                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label fw-bold">Quantidade</label>
                        <input type="number" id="swal-quantity" class="form-control"
                               value="${parseFloat(item.quantity).toFixed(3)}"
                               min="0.001" step="0.001" required>
                    </div>

                    <div class="col-md-4 mb-3">
                        <label class="form-label fw-bold">Preço Unit. (R$)</label>
                        <input type="number" id="swal-price" class="form-control"
                               value="${parseFloat(item.unit_price).toFixed(2)}"
                               min="0" step="0.01" required>
                    </div>

                    <div class="col-md-4 mb-3">
                        <label class="form-label fw-bold">Desconto (R$)</label>
                        <input type="number" id="swal-discount" class="form-control"
                               value="${parseFloat(item.discount).toFixed(2)}"
                               min="0" step="0.01">
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Total</label>
                    <input type="text" id="swal-total" class="form-control fw-bold text-end"
                           value="R$ ${parseFloat(item.total_price).toFixed(2)}" readonly>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Observações</label>
                    <textarea id="swal-notes" class="form-control" rows="2">${item.notes || ''}</textarea>
                </div>
            </div>
        `,
        width: '600px',
        showCancelButton: true,
        confirmButtonText: '<i class="bi bi-check-circle me-2"></i>Salvar',
        cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Cancelar',
        confirmButtonColor: '#198754',
        cancelButtonColor: '#6c757d',
        didOpen: () => {
            // Calcular total automaticamente ao mudar valores
            const calcularTotal = () => {
                const qtd = parseFloat($('#swal-quantity').val()) || 0;
                const preco = parseFloat($('#swal-price').val()) || 0;
                const desconto = parseFloat($('#swal-discount').val()) || 0;
                const total = (qtd * preco) - desconto;
                $('#swal-total').val('R$ ' + total.toFixed(2).replace('.', ','));
            };

            $('#swal-quantity, #swal-price, #swal-discount').on('input', calcularTotal);

            // Focar no campo de quantidade
            setTimeout(() => $('#swal-quantity').focus().select(), 100);
        },
        preConfirm: () => {
            const quantity = parseFloat($('#swal-quantity').val());
            const price = parseFloat($('#swal-price').val());
            const discount = parseFloat($('#swal-discount').val()) || 0;

            if (!quantity || quantity <= 0) {
                Swal.showValidationMessage('Quantidade deve ser maior que zero');
                return false;
            }

            if (!price || price < 0) {
                Swal.showValidationMessage('Preço deve ser maior ou igual a zero');
                return false;
            }

            const total = (quantity * price) - discount;

            return {
                quantity: quantity,
                unit_price: price,
                discount: discount,
                total_price: total,
                notes: $('#swal-notes').val()
            };
        }
    });

    // Se o usuário confirmou
    if (formValues) {
        console.log('Valores alterados:', formValues);

        // Atualizar o item no array
        itensTabela[index] = {
            ...item,
            quantity: formValues.quantity,
            unit_price: formValues.unit_price,
            discount: formValues.discount,
            total_price: formValues.total_price,
            notes: formValues.notes
        };

        console.log('Item atualizado:', itensTabela[index]);

        // Atualizar a linha na tabela
        const $row = $(`#tbody-itens tr[data-index="${index}"]`);
        $row.find('td:eq(1)').text(parseFloat(formValues.quantity).toFixed(3));
        $row.find('td:eq(2)').text('R$ ' + parseFloat(formValues.unit_price).toFixed(2));
        $row.find('td:eq(3)').text('R$ ' + parseFloat(formValues.discount).toFixed(2));
        $row.find('td:eq(4)').html('<strong>R$ ' + parseFloat(formValues.total_price).toFixed(2) + '</strong>');
        $row.find('td:eq(5)').text(formValues.notes || '-');

        // Atualizar inputs hidden
        $row.find('input[name*="[quantity]"]').val(formValues.quantity);
        $row.find('input[name*="[unit_price]"]').val(formValues.unit_price);
        $row.find('input[name*="[discount]"]').val(formValues.discount);
        $row.find('input[name*="[total_price]"]').val(formValues.total_price);
        $row.find('input[name*="[notes]"]').val(formValues.notes);

        // Recalcular total geral
        atualizarTotalGeral();

        Swal.fire({
            icon: 'success',
            title: 'Item Atualizado!',
            text: 'As alterações foram salvas com sucesso.',
            timer: 1500,
            showConfirmButton: false,
            toast: true,
            position: 'top-end'
        });
    }
}

function limparCamposItem() {
    $('#item_search_principal').val('');
    $('#produto_id_principal').val('');
    $('#qtd_principal').val('1');
    $('#preco_principal').val('0');
    $('#desconto_principal').val('0');
    $('#total_principal').val('0');
    $('#obs_principal').val('');
    selectedProduto = null;
}

function atualizarTotalGeral() {
    console.log('=== CALCULANDO TOTAL GERAL ===');
    console.log('Quantidade de itens no array:', itensTabela.length);
    console.log('Itens:', itensTabela);

    // Atualizar total da tabela
    const total = itensTabela.reduce((sum, item) => {
        const itemTotal = parseFloat(item.total_price || 0);
        console.log(`Item: ${item.product_name} - Total: R$ ${itemTotal.toFixed(2)}`);
        return sum + itemTotal;
    }, 0);

    console.log('Total calculado: R$', total.toFixed(2));
    $('#total-geral').text('R$ ' + total.toFixed(2).replace('.', ','));

    // Atualizar totais na aba de valores
    calcularTotalGeral();
}

function calcularTotalGeral() {
    // Calcular total dos itens
    const totalItens = itensTabela.reduce((sum, item) => sum + parseFloat(item.total_price || 0), 0);

    // Calcular total das despesas
    const totalDespesas = despesasTabela.reduce((sum, despesa) => sum + parseFloat(despesa.valor || 0), 0);

    const valorFreteAtual = parseFloat($('#shipping').val()) || 0;

    // Subtotal = Itens + Despesas (frete removido)
    const subtotal = totalItens + totalDespesas;

    // Calcular desconto
    const descontoTipo = $('#discount_type').val();
    const descontoValor = parseFloat($('#discount').val()) || 0;
    let desconto = 0;

    if (descontoTipo === 'percent') {
        desconto = (subtotal * descontoValor) / 100;
    } else {
        desconto = descontoValor;
    }

    // Total Final = Subtotal - Desconto
    const total = subtotal - desconto;

    // Atualizar campos hidden para compatibilidade
    $('#additions').val('0.00');
    $('#shipping').val(valorFreteAtual.toFixed(2));

    // Atualizar campos exibidos
    $('#subtotal').val(subtotal.toFixed(2));
    $('#subtotal_display').val(formatarMoeda(subtotal));
    $('#total').val(total.toFixed(2));
    $('#total_display').val(formatarMoeda(total));

    if (isDav) {
        atualizarResumoPagamento();
    }
}

function formatarMoeda(valor) {
    return valor.toFixed(2).replace('.', ',');
}

function atualizarResumoPagamento() {
    if (!isDav) {
        return;
    }

    const $resumo = $('#resumo-pagamento');
    if ($resumo.length === 0) {
        return;
    }

    const metodoId = $('#payment_method_id').val();
    const metodoNome = metodoId ? ($('#payment_method_id option:selected').text() || '').trim() : '';
    const totalValor = parseFloat($('#total').val()) || 0;
    const totalFormatado = formatarMoeda(totalValor);
    const parcelasVisiveis = !$('#parcelamento-info').hasClass('d-none');
    const detalhesParcelamento = parcelasVisiveis ? $('#parcelamento-detalhes').html() : '<span class="text-muted">Pagamento à vista</span>';

    if (metodoId) {
        $('#resumo-metodo').text(metodoNome || '—');
        $('#resumo-total').text('R$ ' + totalFormatado);
        $('#resumo-parcelamento').html(detalhesParcelamento);
        $('#resumo-placeholder').addClass('d-none');
        $('#resumo-dados').removeClass('d-none');
        $resumo.removeClass('resumo-pagamento-vazio');
    } else {
        $('#resumo-placeholder').removeClass('d-none');
        $('#resumo-dados').addClass('d-none');
        $resumo.addClass('resumo-pagamento-vazio');
    }
}

// ============================================
// SELEÇÃO DE PRAZOS DE PAGAMENTO
// ============================================

function mostrarPrazosMetodoPagamento(metodoId) {
    // Buscar total final da venda
    const totalFinal = parseFloat($('#total').val()) || 0;

    if (totalFinal <= 0) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção',
            text: 'Adicione itens à venda antes de selecionar o método de pagamento!'
        });
        $('#payment_method_id').val('');
        atualizarResumoPagamento();
        return;
    }

    // Buscar prazos do método via AJAX
    $.ajax({
        url: appUrl('/metodos-pagamento/buscar-prazos'),
        method: 'GET',
        data: { metodo_id: metodoId },
        success: function(response) {
            if (response.success && response.data.prazos && response.data.prazos.length > 0) {
                exibirModalPrazos(response.data.prazos, totalFinal);
            } else {
                // Método sem prazos configurados - usar pagamento simples
                $('#installments').val(1);
                atualizarResumoPagamento();
            }
        },
        error: function() {
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Não foi possível carregar os prazos de pagamento'
            });
        }
    });
}

function exibirModalPrazos(prazos, totalFinal) {
    let htmlPrazos = '<div class="list-group">';

    prazos.forEach((prazo, index) => {
        const dias = parseInt(prazo.dias);
        const quantidadeParcelas = Math.ceil(dias / 30); // 1 parcela a cada 30 dias

        // Calcular valor das parcelas
        const valorParcela = totalFinal / quantidadeParcelas;
        const valorParcelaInteiro = Math.floor(valorParcela * 100) / 100; // Arredondar para baixo
        const valorUltimaParcela = totalFinal - (valorParcelaInteiro * (quantidadeParcelas - 1));

        let descricaoParcelas;
        if (quantidadeParcelas === 1) {
            descricaoParcelas = `1x de <strong>R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong>`;
        } else {
            if (Math.abs(valorUltimaParcela - valorParcelaInteiro) < 0.01) {
                descricaoParcelas = `${quantidadeParcelas}x de <strong>R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong>`;
            } else {
                descricaoParcelas = `${quantidadeParcelas - 1}x de <strong>R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> + 1x de <strong>R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong>`;
            }
        }

        htmlPrazos += `
            <button type="button" class="list-group-item list-group-item-action prazo-item" onclick="selecionarPrazo(${quantidadeParcelas}, ${dias})">
                <div class="d-flex w-100 justify-content-between align-items-center">
                    <div class="d-flex align-items-start">
                        <i class="bi bi-calendar-check text-primary me-3 mt-1" style="font-size: 1.5rem;"></i>
                        <div>
                            <h6 class="mb-1">${quantidadeParcelas}x - ${dias} Dias</h6>
                            <p class="mb-0 text-muted small">${descricaoParcelas}</p>
                        </div>
                    </div>
                    <div class="ms-3">
                        <i class="bi bi-chevron-right text-secondary"></i>
                    </div>
                </div>
            </button>
        `;
    });

    htmlPrazos += '</div>';

    Swal.fire({
        title: '<i class="bi bi-credit-card me-2"></i> Selecione o Prazo de Pagamento',
        html: htmlPrazos,
        width: '650px',
        showConfirmButton: false,
        showCancelButton: true,
        cancelButtonText: '<i class="bi bi-x-circle me-1"></i> Cancelar',
        customClass: {
            popup: 'swal-wide',
            cancelButton: 'btn btn-secondary'
        },
        buttonsStyling: false
    });
}

function selecionarPrazo(parcelas, dias) {
    const totalFinal = parseFloat($('#total').val()) || 0;

    console.log('=== SELECIONANDO PRAZO ===');
    console.log('Parcelas:', parcelas);
    console.log('Dias:', dias);
    console.log('Total:', totalFinal);

    // Calcular valores das parcelas
    const valorParcela = totalFinal / parcelas;
    const valorParcelaInteiro = Math.floor(valorParcela * 100) / 100;
    const valorUltimaParcela = totalFinal - (valorParcelaInteiro * (parcelas - 1));

    console.log('Valor por parcela:', valorParcelaInteiro);
    console.log('Última parcela:', valorUltimaParcela);

    // Montar descrição detalhada
    let descricaoDetalhada = '';
    if (parcelas === 1) {
        descricaoDetalhada = `<strong>${parcelas}x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
    } else {
        if (Math.abs(valorUltimaParcela - valorParcelaInteiro) < 0.01) {
            descricaoDetalhada = `<strong>${parcelas}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
        } else {
            descricaoDetalhada = `<strong>${parcelas - 1}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> + <strong>1x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
        }
    }

    console.log('Descrição:', descricaoDetalhada);

    // Atualizar campo hidden
    $('#installments').val(parcelas);

    // Fechar o modal primeiro
    Swal.close();

    // Exibir informações do parcelamento
    console.log('Elemento #parcelamento-detalhes existe?', $('#parcelamento-detalhes').length);
    console.log('Elemento #parcelamento-info existe?', $('#parcelamento-info').length);

    $('#parcelamento-detalhes').html(descricaoDetalhada);
    $('#parcelamento-info').removeClass('d-none').slideDown();

    console.log('Parcelamento deve estar visível agora');

    atualizarResumoPagamento();

    // Toast de confirmação
    Swal.fire({
        icon: 'success',
        title: 'Prazo Selecionado!',
        text: `Pagamento em ${parcelas}x (${dias} dias)`,
        timer: 1500,
        showConfirmButton: false,
        toast: true,
        position: 'top-end'
    });
}

// ============================================
// GERENCIAMENTO DE DESPESAS
// ============================================

function adicionarDespesa() {
    const tipo = $('#despesa_tipo').val();
    const descricao = $('#despesa_descricao').val().trim();
    const valor = parseFloat($('#despesa_valor').val()) || 0;

    if (!tipo) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção',
            text: 'Selecione o tipo de despesa!'
        });
        $('#despesa_tipo').focus();
        return;
    }

    if (!descricao) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção',
            text: 'Informe a descrição da despesa!'
        });
        $('#despesa_descricao').focus();
        return;
    }

    if (valor <= 0) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção',
            text: 'Informe um valor válido para a despesa!'
        });
        $('#despesa_valor').focus();
        return;
    }

    const despesa = {
        index: despesaIndex,
        tipo: tipo,
        descricao: descricao,
        valor: valor
    };

    despesasTabela.push(despesa);

    const tipoTexto = $('#despesa_tipo option:selected').text();
    const valorFormatado = valor.toFixed(2).replace('.', ',');

    const $row = $(`
        <tr data-index="${despesaIndex}">
            <td>${tipoTexto}</td>
            <td>${descricao}</td>
            <td class="text-end"><strong>R$ ${valorFormatado}</strong></td>
            <td class="text-center">
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerDespesa(${despesaIndex})">
                    <i class="bi bi-trash"></i>
                </button>
            </td>
            <input type="hidden" name="despesas[${despesaIndex}][tipo]" value="${tipo}">
            <input type="hidden" name="despesas[${despesaIndex}][descricao]" value="${descricao}">
            <input type="hidden" name="despesas[${despesaIndex}][valor]" value="${valor}">
        </tr>
    `);

    $('#tbody-despesas').append($row);
    $('#alert-sem-despesas').hide();
    $('#tabela-despesas').show();

    despesaIndex++;
    limparCamposDespesa();
    atualizarTotalDespesas();
}

function removerDespesa(index) {
    despesasTabela = despesasTabela.filter(d => d.index !== index);
    $(`#tbody-despesas tr[data-index="${index}"]`).remove();
    atualizarTotalDespesas();

    if (despesasTabela.length === 0) {
        $('#alert-sem-despesas').show();
        $('#tabela-despesas').hide();
    }
}

function limparCamposDespesa() {
    $('#despesa_tipo').val('');
    $('#despesa_descricao').val('');
    $('#despesa_valor').val('');
}

function atualizarTotalDespesas() {
    const total = despesasTabela.reduce((sum, despesa) => sum + parseFloat(despesa.valor || 0), 0);
    $('#total-despesas').text('R$ ' + total.toFixed(2).replace('.', ','));

    // Recalcular total geral quando despesas mudarem
    calcularTotalGeral();
}
</script>