<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-list-nested me-2"></i> Plano de Contas</h2>
        <p class="text-muted">Organize suas contas contábeis</p>
    </div>
    <div class="col-md-6 text-end">
        <button type="button" class="btn btn-outline-info me-2" onclick="abrirTutorialPlanoContas()"
            title="Tutorial do Módulo">
            <i class="bi bi-question-circle me-2"></i> Tutorial
        </button>
        <a href="<?= url('/plano-contas/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Nova Conta
        </a>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Lista de Contas</span>
        <span class="badge bg-primary"><?= count($contas ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($contas)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th width="100">Código</th>
                            <th>Nome</th>
                            <th>Tipo</th>
                            <th>Conta Pai</th>
                            <th>Status</th>
                            <th width="120" class="text-center">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($contas as $conta): ?>
                            <tr>
                                <td><?= $conta['id'] ?></td>
                                <td><code><?= htmlspecialchars($conta['code']) ?></code></td>
                                <td>
                                    <strong><?= htmlspecialchars($conta['name']) ?></strong>
                                    <?php if (!empty($conta['description'])): ?>
                                        <br><small class="text-muted"><?= htmlspecialchars(substr($conta['description'], 0, 50)) ?><?= strlen($conta['description']) > 50 ? '...' : '' ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                    $typeBadges = [
                                        'receita' => '<span class="badge bg-success">Receita</span>',
                                        'despesa' => '<span class="badge bg-danger">Despesa</span>',
                                        'ativo' => '<span class="badge bg-primary">Ativo</span>',
                                        'passivo' => '<span class="badge bg-warning">Passivo</span>'
                                    ];
                                    echo $typeBadges[$conta['type']] ?? '-';
                                    ?>
                                </td>
                                <td><small class="text-muted"><?= htmlspecialchars($conta['parent_name'] ?? '-') ?></small></td>
                                <td>
                                    <?php if ($conta['is_active']): ?>
                                        <span class="badge bg-success">Ativa</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Inativa</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?= url('/plano-contas/editar?id=' . $conta['id']) ?>" class="btn btn-outline-primary" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button class="btn btn-outline-danger" onclick="deletarConta(<?= $conta['id'] ?>)" title="Excluir">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php if (!empty($contas) && isset($totalPages) && $totalPages > 1): ?>
                <div class="d-flex justify-content-between align-items-center p-3 border-top">
                    <div class="text-muted">
                        Mostrando <?= (($page ?? 1) - 1) * ($perPage ?? 50) + 1 ?> a <?= min(($page ?? 1) * ($perPage ?? 50), $total ?? 0) ?> de <?= $total ?? 0 ?> contas
                    </div>
                    <nav>
                        <ul class="pagination pagination-sm mb-0">
                            <li class="page-item <?= ($page ?? 1) <= 1 ? 'disabled' : '' ?>">
                                <a class="page-link" href="?page=<?= max(1, ($page ?? 1) - 1) ?>" aria-label="Anterior">
                                    <span aria-hidden="true">&laquo;</span>
                                </a>
                            </li>
                            <?php for ($i = max(1, ($page ?? 1) - 2); $i <= min($totalPages, ($page ?? 1) + 2); $i++): ?>
                                <li class="page-item <?= ($i === ($page ?? 1)) ? 'active' : '' ?>">
                                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                                </li>
                            <?php endfor; ?>
                            <li class="page-item <?= ($page ?? 1) >= $totalPages ? 'disabled' : '' ?>">
                                <a class="page-link" href="?page=<?= min($totalPages, ($page ?? 1) + 1) ?>" aria-label="Próximo">
                                    <span aria-hidden="true">&raquo;</span>
                                </a>
                            </li>
                        </ul>
                    </nav>
                </div>
            <?php elseif (!empty($contas) && isset($total) && $total > 0): ?>
                <div class="text-center p-3 border-top">
                    <small class="text-muted">Mostrando todos os <?= $total ?> conta(s)</small>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-list-nested" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhuma conta encontrada</p>
                <a href="<?= url('/plano-contas/criar') ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeira Conta
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
async function deletarConta(id) {
    const confirmed = await confirmDelete('Tem certeza que deseja excluir esta conta?');
    if (confirmed) {
        $.ajax({
            url: appUrl('/plano-contas/deletar'),
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Toast.success(response.message);
                    setTimeout(() => location.reload(), 1500);
                } else {
                    Toast.error(response.message);
                }
            }
        });
    }
}

// Função para abrir tutorial do módulo de Plano de Contas
function abrirTutorialPlanoContas() {
    Swal.fire({
        title: '<i class="bi bi-list-nested text-primary"></i> Tutorial Completo: Plano de Contas',
        html: `
            <div class="text-start" style="max-height: 70vh; overflow-y: auto;">
                <div class="mb-4">
                    <h5 class="text-primary mb-3"><i class="bi bi-info-circle me-2"></i>Visão Geral</h5>
                    <p class="text-muted">O Plano de Contas é a estrutura hierárquica que organiza todas as movimentações financeiras e contábeis da empresa. Ele permite classificar receitas, despesas, ativos e passivos de forma organizada.</p>
                </div>

                <div class="accordion" id="tutorialAccordionPlanoContas">
                    <!-- O QUE É PLANO DE CONTAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#oQueEPlanoContas">
                                <i class="bi bi-question-circle me-2"></i> <strong>1. O que é Plano de Contas?</strong>
                            </button>
                        </h2>
                        <div id="oQueEPlanoContas" class="accordion-collapse collapse show" data-bs-parent="#tutorialAccordionPlanoContas">
                            <div class="accordion-body">
                                <p class="mb-3">O Plano de Contas é uma estrutura hierárquica que organiza todas as contas contábeis da empresa. Ele permite:</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Organizar:</strong> Classificar todas as movimentações financeiras</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Hierarquia:</strong> Criar contas pai e filhas para organização detalhada</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Relatórios:</strong> Gerar relatórios contábeis organizados</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Controle:</strong> Controlar receitas, despesas, ativos e passivos</li>
                                </ul>
                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Exemplo:</strong> Você pode ter uma conta "Despesas Operacionais" (pai) com contas filhas como "Salários", "Aluguel", "Energia Elétrica".</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ESTRUTURA HIERÁRQUICA -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#estruturaHierarquica">
                                <i class="bi bi-diagram-3 me-2"></i> <strong>2. Estrutura Hierárquica</strong>
                            </button>
                        </h2>
                        <div id="estruturaHierarquica" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionPlanoContas">
                            <div class="accordion-body">
                                <p class="mb-3">O Plano de Contas usa uma estrutura hierárquica com contas pai e filhas:</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-folder me-2"></i>Contas Raiz (Pai)</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Contas Raiz:</strong> Contas principais que não têm conta pai
                                        <br><small class="text-muted">Exemplo: "1 - Ativo", "2 - Passivo", "3 - Receitas"</small>
                                    </li>
                                    <li><strong>Contas Sintéticas:</strong> Contas que agrupam outras contas
                                        <br><small class="text-info">Geralmente não permitem lançamentos diretos</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-folder2 me-2"></i>Contas Filhas</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Contas Analíticas:</strong> Contas detalhadas que permitem lançamentos
                                        <br><small class="text-muted">Exemplo: "1.1.01 - Caixa", "1.1.02 - Banco"</small>
                                    </li>
                                    <li><strong>Hierarquia:</strong> Podem ter múltiplos níveis (pai, filho, neto, etc.)</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-123 me-2"></i>Código Hierárquico</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Formato:</strong> Usa pontos para separar níveis (ex: 1.1.01)
                                        <br><small class="text-muted">1 = Nível 1 (pai), 1.1 = Nível 2 (filho), 1.1.01 = Nível 3 (neto)</small>
                                    </li>
                                    <li><strong>Exemplo de Estrutura:</strong>
                                        <br><small class="text-info">1 - Ativo</small>
                                        <br><small class="text-info ms-3">1.1 - Ativo Circulante</small>
                                        <br><small class="text-info ms-4">1.1.01 - Caixa</small>
                                        <br><small class="text-info ms-4">1.1.02 - Banco</small>
                                    </li>
                                </ul>

                                <div class="alert alert-warning mt-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small><strong>Importante:</strong> O código deve seguir uma lógica hierárquica. Contas filhas devem ter códigos que começam com o código da conta pai.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- TIPOS DE CONTAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#tiposContas">
                                <i class="bi bi-tags me-2"></i> <strong>3. Tipos de Contas</strong>
                            </button>
                        </h2>
                        <div id="tiposContas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionPlanoContas">
                            <div class="accordion-body">
                                <p class="mb-3">Ao criar uma conta, você deve selecionar o <strong>Tipo</strong>. Os tipos disponíveis são:</p>

                                <h6 class="text-success mb-3"><i class="bi bi-arrow-up-circle me-2"></i>Receita</h6>
                                <p class="ms-3 mb-3">Contas que representam entradas de recursos (vendas, serviços prestados, etc.)
                                    <br><small class="text-muted">Exemplos: "Vendas de Produtos", "Receita de Serviços", "Receitas Financeiras"</small>
                                </p>

                                <h6 class="text-danger mb-3"><i class="bi bi-arrow-down-circle me-2"></i>Despesa</h6>
                                <p class="ms-3 mb-3">Contas que representam saídas de recursos (custos, despesas operacionais, etc.)
                                    <br><small class="text-muted">Exemplos: "Salários", "Aluguel", "Energia Elétrica", "Material de Escritório"</small>
                                </p>

                                <h6 class="text-primary mb-3"><i class="bi bi-building me-2"></i>Ativo</h6>
                                <p class="ms-3 mb-3">Contas que representam bens e direitos da empresa
                                    <br><small class="text-muted">Exemplos: "Caixa", "Bancos", "Estoque", "Imóveis", "Veículos"</small>
                                </p>

                                <h6 class="text-warning mb-3"><i class="bi bi-file-earmark-text me-2"></i>Passivo</h6>
                                <p class="ms-3 mb-3">Contas que representam obrigações e dívidas da empresa
                                    <br><small class="text-muted">Exemplos: "Fornecedores", "Empréstimos", "Contas a Pagar", "Impostos a Recolher"</small>
                                </p>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <small><strong>Dica:</strong> O tipo da conta determina como ela aparece em relatórios contábeis como DRE (Demonstração do Resultado do Exercício) e Balanço Patrimonial.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CAMPOS DO FORMULÁRIO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#camposFormulario">
                                <i class="bi bi-card-text me-2"></i> <strong>4. Campos do Formulário</strong>
                            </button>
                        </h2>
                        <div id="camposFormulario" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionPlanoContas">
                            <div class="accordion-body">
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Código *:</strong> Código hierárquico da conta
                                        <br><small class="text-danger">Campo obrigatório</small>
                                        <br><small class="text-muted">Formato: números separados por pontos (ex: 1.1.01)</small>
                                        <br><small class="text-info">Deve seguir a hierarquia: contas filhas começam com o código da conta pai</small>
                                    </li>
                                    <li><strong>Nome da Conta *:</strong> Nome que identifica a conta
                                        <br><small class="text-danger">Campo obrigatório</small>
                                        <br><small class="text-muted">Exemplos: "Caixa", "Bancos", "Vendas de Produtos", "Salários"</small>
                                    </li>
                                    <li><strong>Conta Pai:</strong> Selecione a conta pai (se houver)
                                        <br><small class="text-muted">Opcional, deixe vazio para criar uma conta raiz</small>
                                        <br><small class="text-info">Selecione uma conta existente para criar uma subconta</small>
                                    </li>
                                    <li><strong>Tipo *:</strong> Selecione o tipo da conta
                                        <br><small class="text-danger">Campo obrigatório</small>
                                        <br><small class="text-info">Escolha entre: Receita, Despesa, Ativo ou Passivo</small>
                                    </li>
                                    <li><strong>Permite Lançamentos?:</strong> Marque se a conta permite lançamentos diretos
                                        <br><small class="text-muted">Contas sintéticas (que têm filhas) geralmente não permitem lançamentos</small>
                                        <br><small class="text-info">Contas analíticas (detalhadas) geralmente permitem lançamentos</small>
                                    </li>
                                    <li><strong>Conta Ativa:</strong> Marque para manter a conta ativa
                                        <br><small class="text-muted">Contas inativas não aparecem em seleções</small>
                                        <br><small class="text-info">Disponível apenas ao editar</small>
                                    </li>
                                    <li><strong>Observações:</strong> Campo de texto livre para informações adicionais
                                        <br><small class="text-muted">Opcional, use para documentar a conta</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- CONTAS SINTÉTICAS VS ANALÍTICAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sinteticasAnaliticas">
                                <i class="bi bi-diagram-2 me-2"></i> <strong>5. Contas Sintéticas vs Analíticas</strong>
                            </button>
                        </h2>
                        <div id="sinteticasAnaliticas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionPlanoContas">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-folder me-2"></i>Contas Sintéticas</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Definição:</strong> Contas que agrupam outras contas (têm contas filhas)</li>
                                    <li><strong>Permite Lançamentos:</strong> Geralmente NÃO</li>
                                    <li><strong>Função:</strong> Organizar e agrupar contas relacionadas</li>
                                    <li><strong>Exemplo:</strong> "1.1 - Ativo Circulante" (agrupa Caixa, Banco, Estoque)</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-file-text me-2"></i>Contas Analíticas</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Definição:</strong> Contas detalhadas que não têm contas filhas</li>
                                    <li><strong>Permite Lançamentos:</strong> Geralmente SIM</li>
                                    <li><strong>Função:</strong> Receber lançamentos contábeis diretos</li>
                                    <li><strong>Exemplo:</strong> "1.1.01 - Caixa" (recebe lançamentos de movimentações de caixa)</li>
                                </ul>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Regra:</strong> Se uma conta tem contas filhas, ela é sintética e geralmente não deve permitir lançamentos. Se não tem filhas, é analítica e deve permitir lançamentos.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- COMO USAR -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#comoUsar">
                                <i class="bi bi-play-circle me-2"></i> <strong>6. Como Usar</strong>
                            </button>
                        </h2>
                        <div id="comoUsar" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionPlanoContas">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-plus-circle me-2"></i>Criando uma Conta</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Clique em "Nova Conta"</li>
                                    <li>Digite o <strong>Código</strong> hierárquico (ex: 1.1.01)</li>
                                    <li>Digite o <strong>Nome</strong> da conta</li>
                                    <li>Selecione a <strong>Conta Pai</strong> (opcional, deixe vazio para conta raiz)</li>
                                    <li>Selecione o <strong>Tipo</strong> (Receita, Despesa, Ativo ou Passivo)</li>
                                    <li>Marque "Permite Lançamentos" se for uma conta analítica</li>
                                    <li>Adicione <strong>Observações</strong> (opcional)</li>
                                    <li>Clique em "Salvar"</li>
                                </ol>

                                <h6 class="text-primary mb-3"><i class="bi bi-pencil me-2"></i>Editando uma Conta</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Na lista de contas, clique no ícone de editar (lápis)</li>
                                    <li>Modifique os campos desejados</li>
                                    <li><strong>Nota:</strong> Cuidado ao alterar o código ou conta pai, pois pode afetar a hierarquia</li>
                                    <li>Clique em "Atualizar"</li>
                                </ol>

                                <h6 class="text-warning mb-3"><i class="bi bi-x-circle me-2"></i>Desativando uma Conta</h6>
                                <p class="ms-3 mb-3">Para desativar uma conta sem excluir:</p>
                                <ol class="ms-3 mb-3">
                                    <li>Edite a conta</li>
                                    <li>Desmarque "Conta Ativa"</li>
                                    <li>Salve as alterações</li>
                                    <li>A conta não aparecerá mais em seleções, mas os dados permanecem</li>
                                </ol>

                                <h6 class="text-info mb-3"><i class="bi bi-diagram-3 me-2"></i>Criando Estrutura Hierárquica</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Primeiro, crie as contas raiz (sem conta pai)</li>
                                    <li>Depois, crie as contas filhas selecionando a conta pai</li>
                                    <li>Use códigos que sigam a hierarquia (ex: pai "1", filho "1.1", neto "1.1.01")</li>
                                    <li>Contas sintéticas (pai) geralmente não permitem lançamentos</li>
                                    <li>Contas analíticas (filhas) geralmente permitem lançamentos</li>
                                </ol>
                            </div>
                        </div>
                    </div>

                    <!-- BOAS PRÁTICAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#boasPraticas">
                                <i class="bi bi-lightbulb me-2"></i> <strong>7. Boas Práticas</strong>
                            </button>
                        </h2>
                        <div id="boasPraticas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionPlanoContas">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-check-circle me-2"></i>Nomenclatura</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Use nomes claros e descritivos</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Siga padrões contábeis quando possível</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Mantenha consistência na nomenclatura</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-123 me-2"></i>Códigos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Use códigos hierárquicos lógicos</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Deixe espaços entre códigos para futuras inserções</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Exemplo: Use 1.1, 1.2, 1.3 (não 1.1, 1.1.1, 1.1.2)</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-diagram-3 me-2"></i>Hierarquia</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Não crie muitos níveis desnecessários</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Mantenha a estrutura organizada e lógica</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Contas sintéticas não devem permitir lançamentos</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-shield-check me-2"></i>Manutenção</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Revise periodicamente a estrutura do plano</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Desative contas não utilizadas em vez de excluir</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Mantenha o plano organizado e atualizado</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- EXEMPLOS PRÁTICOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#exemplos">
                                <i class="bi bi-book me-2"></i> <strong>8. Exemplos Práticos</strong>
                            </button>
                        </h2>
                        <div id="exemplos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionPlanoContas">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-building me-2"></i>Estrutura de Ativo</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>1 - Ativo</strong> (Tipo: Ativo, Permite Lançamentos: Não)
                                        <br><small class="text-muted ms-3">1.1 - Ativo Circulante (Tipo: Ativo, Permite Lançamentos: Não)</small>
                                        <br><small class="text-muted ms-4">1.1.01 - Caixa (Tipo: Ativo, Permite Lançamentos: Sim)</small>
                                        <br><small class="text-muted ms-4">1.1.02 - Bancos (Tipo: Ativo, Permite Lançamentos: Sim)</small>
                                        <br><small class="text-muted ms-4">1.1.03 - Estoque (Tipo: Ativo, Permite Lançamentos: Sim)</small>
                                    </li>
                                </ul>

                                <h6 class="text-success mb-3"><i class="bi bi-arrow-up-circle me-2"></i>Estrutura de Receitas</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>3 - Receitas</strong> (Tipo: Receita, Permite Lançamentos: Não)
                                        <br><small class="text-muted ms-3">3.1 - Receitas Operacionais (Tipo: Receita, Permite Lançamentos: Não)</small>
                                        <br><small class="text-muted ms-4">3.1.01 - Vendas de Produtos (Tipo: Receita, Permite Lançamentos: Sim)</small>
                                        <br><small class="text-muted ms-4">3.1.02 - Receita de Serviços (Tipo: Receita, Permite Lançamentos: Sim)</small>
                                    </li>
                                </ul>

                                <h6 class="text-danger mb-3"><i class="bi bi-arrow-down-circle me-2"></i>Estrutura de Despesas</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>4 - Despesas</strong> (Tipo: Despesa, Permite Lançamentos: Não)
                                        <br><small class="text-muted ms-3">4.1 - Despesas Operacionais (Tipo: Despesa, Permite Lançamentos: Não)</small>
                                        <br><small class="text-muted ms-4">4.1.01 - Salários (Tipo: Despesa, Permite Lançamentos: Sim)</small>
                                        <br><small class="text-muted ms-4">4.1.02 - Aluguel (Tipo: Despesa, Permite Lançamentos: Sim)</small>
                                        <br><small class="text-muted ms-4">4.1.03 - Energia Elétrica (Tipo: Despesa, Permite Lançamentos: Sim)</small>
                                    </li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-file-earmark-text me-2"></i>Estrutura de Passivo</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>2 - Passivo</strong> (Tipo: Passivo, Permite Lançamentos: Não)
                                        <br><small class="text-muted ms-3">2.1 - Passivo Circulante (Tipo: Passivo, Permite Lançamentos: Não)</small>
                                        <br><small class="text-muted ms-4">2.1.01 - Fornecedores (Tipo: Passivo, Permite Lançamentos: Sim)</small>
                                        <br><small class="text-muted ms-4">2.1.02 - Contas a Pagar (Tipo: Passivo, Permite Lançamentos: Sim)</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="alert alert-success mt-4">
                    <i class="bi bi-check-circle me-2"></i>
                    <strong>Pronto para começar!</strong> Agora você conhece todos os recursos do módulo de Plano de Contas e pode criar uma estrutura contábil organizada e hierárquica.
                </div>
            </div>
        `,
        width: '90%',
        heightAuto: false,
        confirmButtonText: 'Entendi, obrigado!',
        confirmButtonColor: '#0d6efd',
        icon: null,
        customClass: {
            popup: 'tutorial-popup',
            container: 'tutorial-container'
        }
    });
}
</script>

<style>
/* Estilos para o Tutorial */
.tutorial-container {
    max-height: 90vh !important;
}

.tutorial-popup {
    max-width: 90vw !important;
    max-height: 90vh !important;
    width: 90% !important;
}

.tutorial-popup .swal2-html-container {
    padding: 0;
    max-height: calc(90vh - 150px);
    overflow-y: auto;
}

.tutorial-popup .accordion-button {
    font-size: 0.95rem;
    font-weight: 600;
    padding: 0.75rem 1rem;
    background-color: #f8f9fa;
    border: 1px solid #dee2e6;
}

.tutorial-popup .accordion-button:not(.collapsed) {
    background-color: #e7f3ff;
    color: #0d6efd;
    border-color: #0d6efd;
}

.tutorial-popup .accordion-button:focus {
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.tutorial-popup .accordion-body {
    padding: 1.25rem;
    background-color: #ffffff;
    border-left: 3px solid #0d6efd;
}

.tutorial-popup .accordion-item {
    border: 1px solid #dee2e6;
    border-radius: 8px;
    overflow: hidden;
    margin-bottom: 0.5rem;
}

.tutorial-popup .list-unstyled li {
    padding: 0.25rem 0;
    line-height: 1.6;
}

.tutorial-popup .alert {
    margin-top: 1rem;
    border-left: 4px solid;
}

.tutorial-popup .text-muted {
    font-size: 0.875rem;
}

.tutorial-popup .text-info {
    color: #0dcaf0 !important;
}

.tutorial-popup .text-success {
    color: #198754 !important;
}

.tutorial-popup .text-warning {
    color: #ffc107 !important;
}

.tutorial-popup .text-primary {
    color: #0d6efd !important;
}
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'plano-contas';
include ROOT_PATH . '/views/layouts/app.php';
?>

