<?php
$isEdit = isset($conta['id']);
?>

<!-- Formulário simples sem tabs para Plano de Contas -->
<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-diagram-3 me-2"></i> Dados da Conta
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Código -->
                    <div class="col-md-4 mb-3">
                        <label for="code" class="form-label">Código *</label>
                        <input type="text" class="form-control" id="code" name="code"
                            placeholder="Ex: 1.1.01"
                            value="<?= htmlspecialchars($conta['code'] ?? '') ?>" required>
                        <small class="text-muted">Código hierárquico da conta</small>
                    </div>

                    <!-- Nome -->
                    <div class="col-md-8 mb-3">
                        <label for="name" class="form-label">Nome da Conta *</label>
                        <input type="text" class="form-control" id="name" name="name"
                            placeholder="Ex: Caixa, Bancos, Fornecedores..."
                            value="<?= htmlspecialchars($conta['name'] ?? '') ?>" required>
                    </div>

                    <!-- Conta Pai -->
                    <div class="col-md-6 mb-3">
                        <label for="parent_id" class="form-label">Conta Pai</label>
                        <select class="form-select" id="parent_id" name="parent_id">
                            <option value="">Nenhuma (Conta Raiz)</option>
                            <?php if (isset($contas)): ?>
                                <?php foreach ($contas as $c): ?>
                                    <option value="<?= $c['id'] ?>" <?= ($conta['parent_id'] ?? '') == $c['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($c['code'] . ' - ' . $c['name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                        <small class="text-muted">Estrutura hierárquica do plano de contas</small>
                    </div>

                    <!-- Tipo -->
                    <div class="col-md-6 mb-3">
                        <label for="type" class="form-label">Tipo *</label>
                        <select class="form-select" id="type" name="type" required>
                            <option value="">Selecione...</option>
                            <option value="receita" <?= ($conta['type'] ?? '') === 'receita' ? 'selected' : '' ?>>Receita</option>
                            <option value="despesa" <?= ($conta['type'] ?? '') === 'despesa' ? 'selected' : '' ?>>Despesa</option>
                            <option value="ativo" <?= ($conta['type'] ?? '') === 'ativo' ? 'selected' : '' ?>>Ativo</option>
                            <option value="passivo" <?= ($conta['type'] ?? '') === 'passivo' ? 'selected' : '' ?>>Passivo</option>
                        </select>
                    </div>

                    <!-- Permite Lançamentos -->
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Permite Lançamentos?</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="allows_entries" name="allows_entries" value="1"
                                <?= ($conta['allows_entries'] ?? 1) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="allows_entries">
                                Sim, permite lançamentos diretos
                            </label>
                        </div>
                        <small class="text-muted">Contas sintéticas (que têm filhas) geralmente não permitem lançamentos</small>
                    </div>

                    <!-- Status -->
                    <?php if ($isEdit): ?>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Status da Conta</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                                <?= ($conta['is_active'] ?? 1) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="is_active">
                                Conta Ativa
                            </label>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Observações -->
                    <div class="col-md-12 mb-3">
                        <label for="notes" class="form-label">Observações</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3"
                            placeholder="Informações adicionais sobre a conta..."><?= htmlspecialchars($conta['notes'] ?? '') ?></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-info-circle me-2"></i> Informações
            </div>
            <div class="card-body">
                <div class="alert alert-info">
                    <i class="bi bi-lightbulb me-2"></i>
                    <strong>Dica:</strong> O plano de contas é a estrutura que organiza todas as movimentações financeiras e contábeis da empresa.
                </div>

                <?php if ($isEdit): ?>
                <p class="small text-muted">
                    <strong>Criado em:</strong><br>
                    <?= date('d/m/Y H:i', strtotime($conta['created_at'])) ?>
                </p>
                <p class="small text-muted">
                    <strong>Atualizado em:</strong><br>
                    <?= date('d/m/Y H:i', strtotime($conta['updated_at'])) ?>
                </p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php if ($isEdit): ?>
<input type="hidden" name="id" value="<?= $conta['id'] ?>">
<?php endif; ?>

