<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-12">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
            <div>
                <h2 class="h4 mb-1"><i class="bi bi-person-vcard me-2"></i> Ficha - <?= htmlspecialchars($pessoa['name']) ?></h2>
                <p class="text-muted mb-0 small">Informações detalhadas do cadastro</p>
            </div>
            <div class="d-flex flex-wrap gap-2">
                <a href="<?= url('/pessoas') ?>" class="btn btn-outline-secondary btn-sm">
                    <i class="bi bi-arrow-left me-1"></i> <span class="d-none d-sm-inline">Voltar</span>
                </a>
                <a href="<?= url('/pessoas/editar?id=' . $pessoa['id']) ?>" class="btn btn-primary btn-sm">
                    <i class="bi bi-pencil me-1"></i> <span class="d-none d-sm-inline">Editar</span>
                </a>
                <button onclick="window.print()" class="btn btn-outline-primary btn-sm">
                    <i class="bi bi-printer me-1"></i> <span class="d-none d-sm-inline">Imprimir</span>
                </button>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Coluna Esquerda -->
    <div class="col-12 col-md-6">
        <!-- Informações Básicas -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-info-circle me-2"></i> Informações Básicas</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-borderless mb-0">
                        <tbody>
                            <tr>
                                <td class="text-muted" style="min-width: 140px;"><strong>ID:</strong></td>
                                <td>#<?= $pessoa['id'] ?></td>
                            </tr>
                            <tr>
                                <td class="text-muted"><strong>Tipo:</strong></td>
                                <td>
                                    <?php if ($pessoa['tipo_cliente']): ?>
                                    <span class="badge bg-primary me-1">Cliente</span>
                                    <?php endif; ?>
                                    <?php if ($pessoa['tipo_fornecedor']): ?>
                                    <span class="badge bg-warning me-1">Fornecedor</span>
                                    <?php endif; ?>
                                    <?php if ($pessoa['tipo_transportadora']): ?>
                                    <span class="badge bg-success me-1">Transportadora</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="text-muted"><strong>Pessoa:</strong></td>
                                <td><?= $pessoa['person_type'] === 'fisica' ? 'Física' : 'Jurídica' ?></td>
                            </tr>
                            <tr>
                                <td class="text-muted"><strong>Nome/Razão Social:</strong></td>
                                <td><?= htmlspecialchars($pessoa['name']) ?></td>
                            </tr>
                            <?php if (!empty($pessoa['trade_name'])): ?>
                            <tr>
                                <td class="text-muted"><strong>Nome Fantasia:</strong></td>
                                <td><?= htmlspecialchars($pessoa['trade_name']) ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <td class="text-muted"><strong>CPF/CNPJ:</strong></td>
                                <td><?= htmlspecialchars($pessoa['document'] ?? '-') ?></td>
                            </tr>
                            <?php if (!empty($pessoa['rg_ie'])): ?>
                            <tr>
                                <td class="text-muted"><strong>RG/IE:</strong></td>
                                <td><?= htmlspecialchars($pessoa['rg_ie']) ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <td class="text-muted"><strong>Status:</strong></td>
                                <td>
                                    <?php if ($pessoa['is_active']): ?>
                                    <span class="badge bg-success">Ativo</span>
                                    <?php else: ?>
                                    <span class="badge bg-danger">Inativo</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Contato -->
        <div class="card mb-4">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="bi bi-telephone me-2"></i> Contato</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-borderless mb-0">
                        <tbody>
                            <?php if (!empty($pessoa['email'])): ?>
                            <tr>
                                <td class="text-muted" style="min-width: 140px;"><strong>Email:</strong></td>
                                <td>
                                    <a href="mailto:<?= $pessoa['email'] ?>" class="text-break"><?= htmlspecialchars($pessoa['email']) ?></a>
                                </td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($pessoa['phone'])): ?>
                            <tr>
                                <td class="text-muted"><strong>Telefone:</strong></td>
                                <td><?= htmlspecialchars($pessoa['phone']) ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($pessoa['mobile'])): ?>
                            <tr>
                                <td class="text-muted"><strong>Celular:</strong></td>
                                <td><?= htmlspecialchars($pessoa['mobile']) ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($pessoa['website'])): ?>
                            <tr>
                                <td class="text-muted"><strong>Website:</strong></td>
                                <td>
                                    <a href="<?= $pessoa['website'] ?>" target="_blank" class="text-break"><?= htmlspecialchars($pessoa['website']) ?></a>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Coluna Direita -->
    <div class="col-12 col-md-6">
        <!-- Endereço -->
        <div class="card mb-4">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-geo-alt me-2"></i> Endereço</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-borderless mb-0">
                        <tbody>
                            <?php if (!empty($pessoa['zip_code'])): ?>
                            <tr>
                                <td class="text-muted" style="min-width: 140px;"><strong>CEP:</strong></td>
                                <td><?= htmlspecialchars($pessoa['zip_code']) ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($pessoa['address'])): ?>
                            <tr>
                                <td class="text-muted"><strong>Endereço:</strong></td>
                                <td><?= htmlspecialchars($pessoa['address']) ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($pessoa['numero'])): ?>
                            <tr>
                                <td class="text-muted"><strong>Número:</strong></td>
                                <td><?= htmlspecialchars($pessoa['numero']) ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($pessoa['complemento'])): ?>
                            <tr>
                                <td class="text-muted"><strong>Complemento:</strong></td>
                                <td><?= htmlspecialchars($pessoa['complemento']) ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($pessoa['bairro'])): ?>
                            <tr>
                                <td class="text-muted"><strong>Bairro:</strong></td>
                                <td><?= htmlspecialchars($pessoa['bairro']) ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($pessoa['city'])): ?>
                            <tr>
                                <td class="text-muted"><strong>Cidade:</strong></td>
                                <td><?= htmlspecialchars($pessoa['city']) ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (!empty($pessoa['state'])): ?>
                            <tr>
                                <td class="text-muted"><strong>Estado:</strong></td>
                                <td><?= htmlspecialchars($pessoa['state']) ?></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Informações Comerciais -->
        <div class="card mb-4">
            <div class="card-header bg-warning text-dark">
                <h5 class="mb-0"><i class="bi bi-cash-coin me-2"></i> Informações Comerciais</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-borderless mb-0">
                        <tbody>
                            <tr>
                                <td class="text-muted" style="min-width: 140px;"><strong>Limite de Crédito:</strong></td>
                                <td>
                                    <strong class="text-primary">
                                        R$ <?= number_format($pessoa['credit_limit'] ?? 0, 2, ',', '.') ?>
                                    </strong>
                                </td>
                            </tr>
                            <tr>
                                <td class="text-muted"><strong>Prazo de Pagamento:</strong></td>
                                <td><?= $pessoa['payment_terms'] ?? 0 ?> dias</td>
                            </tr>
                            <?php if ($pessoa['is_vip']): ?>
                            <tr>
                                <td class="text-muted"><strong>Cliente VIP:</strong></td>
                                <td><span class="badge bg-warning">VIP</span></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <td class="text-muted"><strong>Recebe Email:</strong></td>
                                <td>
                                    <?php if ($pessoa['send_email']): ?>
                                    <i class="bi bi-check-circle text-success"></i> Sim
                                    <?php else: ?>
                                    <i class="bi bi-x-circle text-danger"></i> Não
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="text-muted"><strong>Recebe SMS:</strong></td>
                                <td>
                                    <?php if ($pessoa['send_sms']): ?>
                                    <i class="bi bi-check-circle text-success"></i> Sim
                                    <?php else: ?>
                                    <i class="bi bi-x-circle text-danger"></i> Não
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Observações -->
<?php if (!empty($pessoa['notes'])): ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-secondary text-white">
                <h5 class="mb-0"><i class="bi bi-sticky me-2"></i> Observações</h5>
            </div>
            <div class="card-body">
                <p class="mb-0"><?= nl2br(htmlspecialchars($pessoa['notes'])) ?></p>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Grupos -->
<?php if (!empty($grupos)): ?>
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-collection me-2"></i> Grupos</h5>
            </div>
            <div class="card-body">
                <?php foreach ($grupos as $grupo): ?>
                <span class="badge bg-primary me-2 mb-2"><?= htmlspecialchars($grupo['name']) ?></span>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Ações Rápidas -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h5 class="mb-3"><i class="bi bi-lightning me-2"></i> Ações Rápidas</h5>
                <div class="d-flex flex-column flex-sm-row gap-2">
                    <a href="<?= url('/pessoas/extrato?id=' . $pessoa['id']) ?>" class="btn btn-info">
                        <i class="bi bi-file-text me-2"></i> Ver Extrato
                    </a>
                    <a href="<?= url('/vendas/criar?cliente=' . $pessoa['id']) ?>" class="btn btn-primary">
                        <i class="bi bi-cart-plus me-2"></i> Nova Venda
                    </a>
                    <a href="<?= url('/entradas/criar?cliente=' . $pessoa['id']) ?>" class="btn btn-success">
                        <i class="bi bi-cash-stack me-2"></i> Nova Conta a Receber
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Responsividade Mobile */
@media (max-width: 767.98px) {
    .card {
        margin-bottom: 1rem;
    }

    .card-header h5 {
        font-size: 1rem;
    }

    .table-responsive {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }

    .table td {
        word-break: break-word;
    }
}

@media print {
    .btn {
        display: none !important;
    }

    .card {
        border: 1px solid #dee2e6 !important;
        box-shadow: none !important;
        page-break-inside: avoid;
    }
}
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'pessoas';
include ROOT_PATH . '/views/layouts/app.php';
?>

