<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-people me-2"></i> Pessoas</h2>
        <p class="text-muted">Gerencie clientes, fornecedores e transportadoras</p>
    </div>
    <div class="col-md-6 text-end">
        <button type="button" class="btn btn-outline-info me-2" onclick="abrirTutorialPessoas()"
            title="Tutorial do Módulo">
            <i class="bi bi-question-circle me-2"></i> Tutorial
        </button>
        <?php if (isset($canCreate) && $canCreate): ?>
        <a href="<?= url('/pessoas/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Nova Pessoa
        </a>
        <?php endif; ?>
    </div>
</div>

<!-- Navegação por Abas -->
<div class="card">
    <div class="card-header">
        <ul class="nav nav-tabs card-header-tabs" id="pessoasTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="clientes-tab" data-bs-toggle="tab" data-bs-target="#clientes"
                    type="button" role="tab" aria-controls="clientes" aria-selected="true">
                    <i class="bi bi-person-heart me-2"></i>Clientes
                    <span class="badge bg-primary ms-2" id="count-clientes"><?= $clientesTotal ?? count($clientes ?? []) ?></span>
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="fornecedores-tab" data-bs-toggle="tab" data-bs-target="#fornecedores"
                    type="button" role="tab" aria-controls="fornecedores" aria-selected="false">
                    <i class="bi bi-building me-2"></i>Fornecedores
                    <span class="badge bg-warning ms-2" id="count-fornecedores"><?= $fornecedoresTotal ?? count($fornecedores ?? []) ?></span>
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="transportadoras-tab" data-bs-toggle="tab" data-bs-target="#transportadoras"
                    type="button" role="tab" aria-controls="transportadoras" aria-selected="false">
                    <i class="bi bi-truck me-2"></i>Transportadoras
                    <span class="badge bg-success ms-2"
                        id="count-transportadoras"><?= $transportadorasTotal ?? count($transportadoras ?? []) ?></span>
                </button>
            </li>
        </ul>
    </div>
    <div class="card-body">
        <div class="tab-content" id="pessoasTabsContent">

            <!-- Aba Clientes -->
            <div class="tab-pane fade show active" id="clientes" role="tabpanel" aria-labelledby="clientes-tab">
                <!-- Filtros para Clientes -->
                <div class="row mb-3">
                    <div class="col-md-8">
                        <input type="text" class="form-control" id="search-clientes"
                            placeholder="Buscar clientes por nome, CPF/CNPJ, email..."
                            onkeyup="filterTable('clientes-table', this.value)">
                    </div>
                    <div class="col-md-4">
                        <select class="form-select" id="filter-clientes"
                            onchange="filterTableByStatus('clientes-table', this.value)">
                            <option value="">Todos os Status</option>
                            <option value="1" selected>Ativos</option>
                            <option value="0">Inativos</option>
                        </select>
                    </div>
                </div>

                <!-- Tabela de Clientes -->
                <div class="table-responsive">
                    <table class="table table-hover" id="clientes-table" style="table-layout: fixed; width: 100%;">
                        <thead>
                            <tr>
                                <th style="width: 60px;">ID</th>
                                <th>Nome</th>
                                <th style="width: 150px; min-width: 150px;">CPF/CNPJ</th>
                                <th style="width: 130px; min-width: 130px;">Telefone</th>
                                <th style="width: 60px; text-align: center;">WhatsApp</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($clientes)): ?>
                            <?php foreach ($clientes as $cliente): ?>
                            <tr style="cursor: pointer;"
                                data-status="<?= (isset($cliente['is_active']) && $cliente['is_active']) ? '1' : '0' ?>"
                                onclick="abrirOpcoesPessoa(<?= $cliente['id'] ?>, '<?= addslashes(htmlspecialchars($cliente['name'])) ?>', '<?= addslashes(formatDocument($cliente['document'] ?? '')) ?>', 'cliente')">
                                <td><?= $cliente['id'] ?></td>
                                <td>
                                    <div class="d-flex align-items-start">
                                        <div class="avatar-sm bg-primary rounded-circle d-flex align-items-center justify-content-center me-2 flex-shrink-0">
                                            <i class="bi bi-person-heart text-white"></i>
                                        </div>
                                        <div>
                                            <?php if (!empty($cliente['trade_name'])): ?>
                                                <div class="fw-bold text-primary"><?= htmlspecialchars($cliente['trade_name']) ?></div>
                                            <?php endif; ?>
                                            <div class="text-muted small"><?= htmlspecialchars($cliente['name']) ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-nowrap" style="font-size: 0.9rem;"><?= formatDocument($cliente['document'] ?? '') ?></td>
                                <td class="text-nowrap"><?= htmlspecialchars($cliente['mobile'] ?? $cliente['phone'] ?? '') ?></td>
                                <td class="text-center" onclick="event.stopPropagation();">
                                    <?php
                                    $whatsapp = $cliente['whatsapp'] ?? $cliente['mobile'] ?? $cliente['phone'] ?? '';
                                    if (!empty($whatsapp)):
                                        $whatsappNumero = preg_replace('/\D/', '', $whatsapp);
                                    ?>
                                        <a href="https://wa.me/55<?= $whatsappNumero ?>" target="_blank"
                                           class="btn btn-sm btn-success"
                                           title="Abrir WhatsApp">
                                            <i class="bi bi-whatsapp"></i>
                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted" title="WhatsApp não informado">
                                            <i class="bi bi-whatsapp"></i>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center py-4">
                                    <i class="bi bi-person-x" style="font-size: 3rem; opacity: 0.3;"></i>
                                    <p class="text-muted mt-2">Nenhum cliente encontrado</p>
                                    <?php if (isset($canCreate) && $canCreate): ?>
                                    <a href="<?= url('/pessoas/criar') ?>" class="btn btn-primary btn-sm mt-2">
                                        <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeiro Cliente
                                    </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Paginação Clientes -->
                <?php
                $clientesTotal = $clientesTotal ?? 0;
                $clientesPerPage = $clientesPerPage ?? 40;
                $clientesTotalPages = $clientesTotalPages ?? 1;
                $clientesPage = $clientesPage ?? 1;
                ?>
                <?php if ($clientesTotalPages > 1 || $clientesTotal > $clientesPerPage): ?>
                <nav aria-label="Paginação de Clientes" class="mt-3">
                    <ul class="pagination justify-content-center mb-0">
                        <li class="page-item <?= $clientesPage <= 1 ? 'disabled' : '' ?>">
                            <a class="page-link" href="?page_clientes=<?= max(1, $clientesPage - 1) ?>&tab=clientes" onclick="event.preventDefault(); navegarPagina('clientes', <?= max(1, $clientesPage - 1) ?>);">
                                <i class="bi bi-chevron-left"></i>
                            </a>
                        </li>
                        <?php for ($i = max(1, $clientesPage - 2); $i <= min($clientesTotalPages, $clientesPage + 2); $i++): ?>
                        <li class="page-item <?= $clientesPage == $i ? 'active' : '' ?>">
                            <a class="page-link" href="?page_clientes=<?= $i ?>&tab=clientes" onclick="event.preventDefault(); navegarPagina('clientes', <?= $i ?>);"><?= $i ?></a>
                        </li>
                        <?php endfor; ?>
                        <li class="page-item <?= $clientesPage >= $clientesTotalPages ? 'disabled' : '' ?>">
                            <a class="page-link" href="?page_clientes=<?= min($clientesTotalPages, $clientesPage + 1) ?>&tab=clientes" onclick="event.preventDefault(); navegarPagina('clientes', <?= min($clientesTotalPages, $clientesPage + 1) ?>);">
                                <i class="bi bi-chevron-right"></i>
                            </a>
                        </li>
                    </ul>
                    <div class="text-center mt-2">
                        <small class="text-muted">
                            Mostrando <?= min($clientesPage * $clientesPerPage - $clientesPerPage + 1, $clientesTotal) ?>
                            até <?= min($clientesPage * $clientesPerPage, $clientesTotal) ?>
                            de <?= $clientesTotal ?> clientes
                        </small>
                    </div>
                </nav>
                <?php elseif (isset($clientesTotal) && $clientesTotal > 0): ?>
                <!-- Informação de paginação quando há apenas uma página -->
                <div class="text-center mt-3">
                    <small class="text-muted">
                        Mostrando todos os <?= $clientesTotal ?> cliente(s)
                    </small>
                </div>
                <?php endif; ?>
            </div>

            <!-- Aba Fornecedores -->
            <div class="tab-pane fade" id="fornecedores" role="tabpanel" aria-labelledby="fornecedores-tab">
                <!-- Filtros para Fornecedores -->
                <div class="row mb-3">
                    <div class="col-md-8">
                        <input type="text" class="form-control" id="search-fornecedores"
                            placeholder="Buscar fornecedores por nome, CNPJ, email..."
                            onkeyup="filterTable('fornecedores-table', this.value)">
                    </div>
                    <div class="col-md-4">
                        <select class="form-select" id="filter-fornecedores"
                            onchange="filterTableByStatus('fornecedores-table', this.value)">
                            <option value="">Todos os Status</option>
                            <option value="1">Ativos</option>
                            <option value="0">Inativos</option>
                        </select>
                    </div>
                </div>

                <!-- Tabela de Fornecedores -->
                <div class="table-responsive">
                    <table class="table table-hover" id="fornecedores-table" style="table-layout: fixed; width: 100%;">
                        <thead>
                            <tr>
                                <th style="width: 60px;">ID</th>
                                <th>Nome</th>
                                <th style="width: 150px; min-width: 150px;">CNPJ</th>
                                <th>Email</th>
                                <th style="width: 130px; min-width: 130px;">Telefone</th>
                                <th style="width: 60px; text-align: center;">WhatsApp</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($fornecedores)): ?>
                            <?php foreach ($fornecedores as $fornecedor): ?>
                            <tr style="cursor: pointer;"
                                data-status="<?= (isset($fornecedor['is_active']) && $fornecedor['is_active']) ? '1' : '0' ?>"
                                onclick="abrirOpcoesPessoa(<?= $fornecedor['id'] ?>, '<?= addslashes(htmlspecialchars($fornecedor['name'])) ?>', '<?= addslashes(formatDocument($fornecedor['document'] ?? '')) ?>', 'fornecedor')">
                                <td><?= $fornecedor['id'] ?></td>
                                <td>
                                    <div class="d-flex align-items-start">
                                        <div class="avatar-sm bg-warning rounded-circle d-flex align-items-center justify-content-center me-2 flex-shrink-0">
                                            <i class="bi bi-building text-white"></i>
                                        </div>
                                        <div>
                                            <?php if (!empty($fornecedor['trade_name'])): ?>
                                                <div class="fw-bold text-warning"><?= htmlspecialchars($fornecedor['trade_name']) ?></div>
                                            <?php endif; ?>
                                            <div class="text-muted small"><?= htmlspecialchars($fornecedor['name']) ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-nowrap" style="font-size: 0.9rem;"><?= formatDocument($fornecedor['document'] ?? '') ?></td>
                                <td><?= htmlspecialchars($fornecedor['email'] ?? '') ?></td>
                                <td class="text-nowrap"><?= htmlspecialchars($fornecedor['mobile'] ?? $fornecedor['phone'] ?? '') ?></td>
                                <td class="text-center" onclick="event.stopPropagation();">
                                    <?php
                                    $whatsapp = $fornecedor['whatsapp'] ?? $fornecedor['mobile'] ?? $fornecedor['phone'] ?? '';
                                    if (!empty($whatsapp)):
                                        $whatsappNumero = preg_replace('/\D/', '', $whatsapp);
                                    ?>
                                        <a href="https://wa.me/55<?= $whatsappNumero ?>" target="_blank"
                                           class="btn btn-sm btn-success"
                                           title="Abrir WhatsApp">
                                            <i class="bi bi-whatsapp"></i>
                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted" title="WhatsApp não informado">
                                            <i class="bi bi-whatsapp"></i>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center py-4">
                                    <i class="bi bi-building" style="font-size: 3rem; opacity: 0.3;"></i>
                                    <p class="text-muted mt-2">Nenhum fornecedor encontrado</p>
                                    <a href="<?= url('/pessoas/criar') ?>" class="btn btn-warning btn-sm mt-2">
                                        <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeiro Fornecedor
                                    </a>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Paginação Fornecedores -->
                <?php
                $fornecedoresTotal = $fornecedoresTotal ?? 0;
                $fornecedoresPerPage = $fornecedoresPerPage ?? 40;
                $fornecedoresTotalPages = $fornecedoresTotalPages ?? 1;
                $fornecedoresPage = $fornecedoresPage ?? 1;
                ?>
                <?php if ($fornecedoresTotalPages > 1 || $fornecedoresTotal > $fornecedoresPerPage): ?>
                <nav aria-label="Paginação de Fornecedores" class="mt-3">
                    <ul class="pagination justify-content-center mb-0">
                        <li class="page-item <?= $fornecedoresPage <= 1 ? 'disabled' : '' ?>">
                            <a class="page-link" href="?page_fornecedores=<?= max(1, $fornecedoresPage - 1) ?>&tab=fornecedores" onclick="event.preventDefault(); navegarPagina('fornecedores', <?= max(1, $fornecedoresPage - 1) ?>);">
                                <i class="bi bi-chevron-left"></i>
                            </a>
                        </li>
                        <?php for ($i = max(1, $fornecedoresPage - 2); $i <= min($fornecedoresTotalPages, $fornecedoresPage + 2); $i++): ?>
                        <li class="page-item <?= $fornecedoresPage == $i ? 'active' : '' ?>">
                            <a class="page-link" href="?page_fornecedores=<?= $i ?>&tab=fornecedores" onclick="event.preventDefault(); navegarPagina('fornecedores', <?= $i ?>);"><?= $i ?></a>
                        </li>
                        <?php endfor; ?>
                        <li class="page-item <?= $fornecedoresPage >= $fornecedoresTotalPages ? 'disabled' : '' ?>">
                            <a class="page-link" href="?page_fornecedores=<?= min($fornecedoresTotalPages, $fornecedoresPage + 1) ?>&tab=fornecedores" onclick="event.preventDefault(); navegarPagina('fornecedores', <?= min($fornecedoresTotalPages, $fornecedoresPage + 1) ?>);">
                                <i class="bi bi-chevron-right"></i>
                            </a>
                        </li>
                    </ul>
                    <div class="text-center mt-2">
                        <small class="text-muted">
                            Mostrando <?= min($fornecedoresPage * $fornecedoresPerPage - $fornecedoresPerPage + 1, $fornecedoresTotal) ?>
                            até <?= min($fornecedoresPage * $fornecedoresPerPage, $fornecedoresTotal) ?>
                            de <?= $fornecedoresTotal ?> fornecedores
                        </small>
                    </div>
                </nav>
                <?php elseif (isset($fornecedoresTotal) && $fornecedoresTotal > 0): ?>
                <!-- Informação de paginação quando há apenas uma página -->
                <div class="text-center mt-3">
                    <small class="text-muted">
                        Mostrando todos os <?= $fornecedoresTotal ?> fornecedor(es)
                    </small>
                </div>
                <?php endif; ?>
            </div>

            <!-- Aba Transportadoras -->
            <div class="tab-pane fade" id="transportadoras" role="tabpanel" aria-labelledby="transportadoras-tab">
                <!-- Filtros para Transportadoras -->
                <div class="row mb-3">
                    <div class="col-md-8">
                        <input type="text" class="form-control" id="search-transportadoras"
                            placeholder="Buscar transportadoras por nome, CNPJ, email..."
                            onkeyup="filterTable('transportadoras-table', this.value)">
                    </div>
                    <div class="col-md-4">
                        <select class="form-select" id="filter-transportadoras"
                            onchange="filterTableByStatus('transportadoras-table', this.value)">
                            <option value="">Todos os Status</option>
                            <option value="1" selected>Ativos</option>
                            <option value="0">Inativos</option>
                        </select>
                    </div>
                </div>

                <!-- Tabela de Transportadoras -->
                <div class="table-responsive">
                    <table class="table table-hover" id="transportadoras-table" style="table-layout: fixed; width: 100%;">
                        <thead>
                            <tr>
                                <th style="width: 60px;">ID</th>
                                <th>Nome</th>
                                <th style="width: 150px; min-width: 150px;">CNPJ</th>
                                <th>Email</th>
                                <th style="width: 130px; min-width: 130px;">Telefone</th>
                                <th style="width: 60px; text-align: center;">WhatsApp</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($transportadoras)): ?>
                            <?php foreach ($transportadoras as $transportadora): ?>
                            <tr style="cursor: pointer;"
                                data-status="<?= (isset($transportadora['is_active']) && $transportadora['is_active']) ? '1' : '0' ?>"
                                onclick="abrirOpcoesPessoa(<?= $transportadora['id'] ?>, '<?= addslashes(htmlspecialchars($transportadora['name'])) ?>', '<?= addslashes(formatDocument($transportadora['document'] ?? '')) ?>', 'transportadora')">
                                <td><?= $transportadora['id'] ?></td>
                                <td>
                                    <div class="d-flex align-items-start">
                                        <div class="avatar-sm bg-success rounded-circle d-flex align-items-center justify-content-center me-2 flex-shrink-0">
                                            <i class="bi bi-truck text-white"></i>
                                        </div>
                                        <div>
                                            <?php if (!empty($transportadora['trade_name'])): ?>
                                                <div class="fw-bold text-success"><?= htmlspecialchars($transportadora['trade_name']) ?></div>
                                            <?php endif; ?>
                                            <div class="text-muted small"><?= htmlspecialchars($transportadora['name']) ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-nowrap" style="font-size: 0.9rem;"><?= formatDocument($transportadora['document'] ?? '') ?></td>
                                <td><?= htmlspecialchars($transportadora['email'] ?? '') ?></td>
                                <td class="text-nowrap"><?= htmlspecialchars($transportadora['mobile'] ?? $transportadora['phone'] ?? '') ?></td>
                                <td class="text-center" onclick="event.stopPropagation();">
                                    <?php
                                    $whatsapp = $transportadora['whatsapp'] ?? $transportadora['mobile'] ?? $transportadora['phone'] ?? '';
                                    if (!empty($whatsapp)):
                                        $whatsappNumero = preg_replace('/\D/', '', $whatsapp);
                                    ?>
                                        <a href="https://wa.me/55<?= $whatsappNumero ?>" target="_blank"
                                           class="btn btn-sm btn-success"
                                           title="Abrir WhatsApp">
                                            <i class="bi bi-whatsapp"></i>
                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted" title="WhatsApp não informado">
                                            <i class="bi bi-whatsapp"></i>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center py-4">
                                    <i class="bi bi-truck" style="font-size: 3rem; opacity: 0.3;"></i>
                                    <p class="text-muted mt-2">Nenhuma transportadora encontrada</p>
                                    <?php if (isset($canCreate) && $canCreate): ?>
                                    <a href="<?= url('/pessoas/criar') ?>" class="btn btn-success btn-sm mt-2">
                                        <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeira Transportadora
                                    </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Paginação Transportadoras -->
                <?php
                $transportadorasTotal = $transportadorasTotal ?? 0;
                $transportadorasPerPage = $transportadorasPerPage ?? 40;
                $transportadorasTotalPages = $transportadorasTotalPages ?? 1;
                $transportadorasPage = $transportadorasPage ?? 1;
                ?>
                <?php if ($transportadorasTotalPages > 1 || $transportadorasTotal > $transportadorasPerPage): ?>
                <nav aria-label="Paginação de Transportadoras" class="mt-3">
                    <ul class="pagination justify-content-center mb-0">
                        <li class="page-item <?= $transportadorasPage <= 1 ? 'disabled' : '' ?>">
                            <a class="page-link" href="?page_transportadoras=<?= max(1, $transportadorasPage - 1) ?>&tab=transportadoras" onclick="event.preventDefault(); navegarPagina('transportadoras', <?= max(1, $transportadorasPage - 1) ?>);">
                                <i class="bi bi-chevron-left"></i>
                            </a>
                        </li>
                        <?php for ($i = max(1, $transportadorasPage - 2); $i <= min($transportadorasTotalPages, $transportadorasPage + 2); $i++): ?>
                        <li class="page-item <?= $transportadorasPage == $i ? 'active' : '' ?>">
                            <a class="page-link" href="?page_transportadoras=<?= $i ?>&tab=transportadoras" onclick="event.preventDefault(); navegarPagina('transportadoras', <?= $i ?>);"><?= $i ?></a>
                        </li>
                        <?php endfor; ?>
                        <li class="page-item <?= $transportadorasPage >= $transportadorasTotalPages ? 'disabled' : '' ?>">
                            <a class="page-link" href="?page_transportadoras=<?= min($transportadorasTotalPages, $transportadorasPage + 1) ?>&tab=transportadoras" onclick="event.preventDefault(); navegarPagina('transportadoras', <?= min($transportadorasTotalPages, $transportadorasPage + 1) ?>);">
                                <i class="bi bi-chevron-right"></i>
                            </a>
                        </li>
                    </ul>
                    <div class="text-center mt-2">
                        <small class="text-muted">
                            Mostrando <?= min($transportadorasPage * $transportadorasPerPage - $transportadorasPerPage + 1, $transportadorasTotal) ?>
                            até <?= min($transportadorasPage * $transportadorasPerPage, $transportadorasTotal) ?>
                            de <?= $transportadorasTotal ?> transportadoras
                        </small>
                    </div>
                </nav>
                <?php elseif (isset($transportadorasTotal) && $transportadorasTotal > 0): ?>
                <!-- Informação de paginação quando há apenas uma página -->
                <div class="text-center mt-3">
                    <small class="text-muted">
                        Mostrando todas as <?= $transportadorasTotal ?> transportadora(s)
                    </small>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<style>
/* Estilos para evitar quebra de layout nas colunas CPF/CNPJ e Telefone */
#clientes-table th:nth-child(3),
#clientes-table td:nth-child(3),
#fornecedores-table th:nth-child(3),
#fornecedores-table td:nth-child(3),
#transportadoras-table th:nth-child(3),
#transportadoras-table td:nth-child(3) {
    white-space: nowrap;
    overflow: hidden;
    max-width: 150px;
}

#clientes-table th:nth-child(4),
#clientes-table td:nth-child(4),
#fornecedores-table th:nth-child(5),
#fornecedores-table td:nth-child(5),
#transportadoras-table th:nth-child(5),
#transportadoras-table td:nth-child(5) {
    white-space: nowrap;
    overflow: hidden;
    max-width: 130px;
}

.avatar-sm {
    width: 32px;
    height: 32px;
    font-size: 14px;
}

.nav-tabs .nav-link {
    border: none;
    border-bottom: 3px solid transparent;
    color: #6c757d;
    font-weight: 500;
}

.nav-tabs .nav-link.active {
    border-bottom-color: #0d6efd;
    color: #0d6efd;
    background: transparent;
}

.nav-tabs .nav-link:hover {
    border-bottom-color: #0d6efd;
    color: #0d6efd;
}

.opcoes-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
    padding: 0 1rem;
}

.opcao-card {
    aspect-ratio: 1;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: 1rem;
    border: 2px solid #e0e0e0;
    border-radius: 12px;
    background: white;
    cursor: pointer;
    transition: all 0.3s;
    padding: 1.5rem;
}

.opcao-card i {
    font-size: 3rem;
}

.opcao-card span {
    font-size: 0.95rem;
    font-weight: 600;
    text-align: center;
}

.opcao-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
}

.opcao-card-primary {
    border-color: #0d6efd;
    color: #0d6efd;
}

.opcao-card-primary:hover {
    background: #0d6efd;
    color: white;
}

.opcao-card-warning {
    border-color: #ffc107;
    color: #ffc107;
}

.opcao-card-warning:hover {
    background: #ffc107;
    color: white;
}

.opcao-card-success {
    border-color: #198754;
    color: #198754;
}

.opcao-card-success:hover {
    background: #198754;
    color: white;
}

.opcao-card-info {
    border-color: #0dcaf0;
    color: #0dcaf0;
}

.opcao-card-info:hover {
    background: #0dcaf0;
    color: white;
}

.table tbody tr:hover {
    background-color: rgba(13, 110, 253, 0.05);
}

.table tbody tr td:nth-child(2)>div strong {
    transition: all 0.2s;
}

.avatar-lg {
    width: 60px;
    height: 60px;
    font-size: 24px;
}

/* Estilos para o modal de opções */
.opcoes-grid-compact {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 10px;
    padding: 0;
}

.opcao-btn {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 16px 12px;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    transition: all 0.2s ease;
    gap: 6px;
    min-height: 80px;
    font-family: inherit;
}

.opcao-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.opcao-btn i {
    font-size: 1.4rem;
}

.opcao-btn span {
    font-size: 0.85rem;
    font-weight: 500;
}

.opcao-btn-primary {
    background: linear-gradient(135deg, #3b82f6, #1d4ed8);
    color: white;
}

.opcao-btn-info {
    background: linear-gradient(135deg, #06b6d4, #0891b2);
    color: white;
}

.opcao-btn-secondary {
    background: linear-gradient(135deg, #6b7280, #4b5563);
    color: white;
}

.opcao-btn-danger {
    background: linear-gradient(135deg, #ef4444, #dc2626);
    color: white;
}

.opcao-btn-success {
    background: linear-gradient(135deg, #25d366, #128c7e);
    color: white;
}

/* Estilos para o Tutorial */
.tutorial-container {
    max-height: 90vh !important;
}

.tutorial-popup {
    max-width: 90vw !important;
    max-height: 90vh !important;
    width: 90% !important;
}

.tutorial-popup .swal2-html-container {
    padding: 0;
    max-height: calc(90vh - 150px);
    overflow-y: auto;
}

.tutorial-popup .accordion-button {
    font-size: 0.95rem;
    font-weight: 600;
    padding: 0.75rem 1rem;
    background-color: #f8f9fa;
    border: 1px solid #dee2e6;
}

.tutorial-popup .accordion-button:not(.collapsed) {
    background-color: #e7f3ff;
    color: #0d6efd;
    border-color: #0d6efd;
}

.tutorial-popup .accordion-button:focus {
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.tutorial-popup .accordion-body {
    padding: 1.25rem;
    background-color: #ffffff;
    border-left: 3px solid #0d6efd;
}

.tutorial-popup .accordion-item {
    border: 1px solid #dee2e6;
    border-radius: 8px;
    overflow: hidden;
    margin-bottom: 0.5rem;
}

.tutorial-popup .list-unstyled li {
    padding: 0.25rem 0;
    line-height: 1.6;
}

.tutorial-popup .alert {
    margin-top: 1rem;
    border-left: 4px solid;
}

.tutorial-popup .text-muted {
    font-size: 0.875rem;
}

.tutorial-popup .text-info {
    color: #0dcaf0 !important;
}

.tutorial-popup .text-success {
    color: #198754 !important;
}

.tutorial-popup .text-warning {
    color: #ffc107 !important;
}

.tutorial-popup .text-primary {
    color: #0d6efd !important;
}
</style>

<script>
// Permissões do usuário logado
const canEdit = <?= (isset($canEdit) && $canEdit) ? 'true' : 'false' ?>;
const canDelete = <?= (isset($canDelete) && $canDelete) ? 'true' : 'false' ?>;

// Função para filtrar tabela por texto
function filterTable(tableId, searchText) {
    const table = document.getElementById(tableId);
    const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

    for (let i = 0; i < rows.length; i++) {
        const row = rows[i];
        const text = row.textContent.toLowerCase();

        if (text.includes(searchText.toLowerCase())) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    }
}

// Função para filtrar por status
function filterTableByStatus(tableId, status) {
    const table = document.getElementById(tableId);
    if (!table) return;

    const tbody = table.getElementsByTagName('tbody')[0];
    if (!tbody) return;

    const rows = tbody.getElementsByTagName('tr');

    for (let i = 0; i < rows.length; i++) {
        const row = rows[i];
        const rowStatus = row.getAttribute('data-status');

        // Se não há filtro selecionado, mostra todas as linhas
        if (!status || status === '') {
            row.style.display = '';
        } else {
            // Compara o status da linha com o filtro selecionado
            if (rowStatus === status) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        }
    }
}

// Função para navegar entre páginas
function navegarPagina(tipo, pagina) {
    const url = new URL(window.location.href);
    // Remover parâmetros de página antigos
    url.searchParams.delete('page');
    url.searchParams.delete('page_clientes');
    url.searchParams.delete('page_fornecedores');
    url.searchParams.delete('page_transportadoras');

    // Adicionar página específica do tipo
    url.searchParams.set(`page_${tipo}`, pagina);
    url.searchParams.set('tab', tipo);

    window.location.href = url.toString();
}

// Aplicar filtro de "Ativos" ao carregar a página
document.addEventListener('DOMContentLoaded', function() {
    // Verificar se há parâmetro de aba na URL
    const urlParams = new URLSearchParams(window.location.search);
    const tabParam = urlParams.get('tab');

    if (tabParam) {
        // Ativar a aba especificada
        const tabButton = document.querySelector(`[data-bs-target="#${tabParam}"]`);
        if (tabButton) {
            const tab = new bootstrap.Tab(tabButton);
            tab.show();
        }
    }

    // Aplicar filtro na aba ativa
    setTimeout(() => {
        const activeTab = document.querySelector('.nav-link.active');
        if (activeTab) {
            const tabId = activeTab.getAttribute('data-bs-target');
            if (tabId === '#clientes') {
                filterTableByStatus('clientes-table', '1');
            } else if (tabId === '#fornecedores') {
                filterTableByStatus('fornecedores-table', '1');
            } else if (tabId === '#transportadoras') {
                filterTableByStatus('transportadoras-table', '1');
            }
        }
    }, 100);

    // Aplicar filtro quando mudar de aba
    const tabButtons = document.querySelectorAll('[data-bs-toggle="tab"]');
    tabButtons.forEach(button => {
        button.addEventListener('shown.bs.tab', function(e) {
            const targetId = e.target.getAttribute('data-bs-target');
            if (targetId === '#clientes') {
                filterTableByStatus('clientes-table', '1');
            } else if (targetId === '#fornecedores') {
                filterTableByStatus('fornecedores-table', '1');
            } else if (targetId === '#transportadoras') {
                filterTableByStatus('transportadoras-table', '1');
            }
        });
    });
});

// Função unificada para abrir opções de pessoa (cliente/fornecedor/transportadora)
function abrirOpcoesPessoa(id, nome, documento, tipo) {
    const tipoConfig = {
        cliente: { icon: 'bi-person-heart', color: '#0d6efd', colorDark: '#0b5ed7', label: 'Cliente' },
        fornecedor: { icon: 'bi-building', color: '#fd7e14', colorDark: '#e06c0b', label: 'Fornecedor' },
        transportadora: { icon: 'bi-truck', color: '#198754', colorDark: '#157347', label: 'Transportadora' }
    };

    const config = tipoConfig[tipo] || tipoConfig.cliente;
    const codigo = String(id).padStart(4, '0');

    const headerHtml = `
        <div style="background: linear-gradient(135deg, ${config.color} 0%, ${config.colorDark} 100%);
                    margin: -20px -20px 20px -20px;
                    padding: 28px 24px;
                    border-radius: 12px 12px 0 0;
                    color: white;
                    text-align: center;">
            <div style="display: inline-flex; align-items: center; justify-content: center; width: 70px; height: 70px; background: rgba(255,255,255,0.2); border-radius: 50%; margin-bottom: 12px;">
                <i class="bi ${config.icon}" style="font-size: 2rem;"></i>
            </div>
            <div style="background: rgba(255,255,255,0.15); border-radius: 8px; padding: 12px; margin-top: 8px;">
                <div style="font-size: 0.75rem; opacity: 0.9; margin-bottom: 4px;">Código: <strong>${codigo}</strong></div>
                <div style="font-size: 1.1rem; font-weight: 600; margin-bottom: 4px;">${nome}</div>
                ${documento ? `<div style="font-size: 0.85rem; opacity: 0.95;"><i class="bi bi-card-text me-1"></i>${documento}</div>` : ''}
            </div>
            <div style="margin-top: 10px;">
                <span style="background: rgba(255,255,255,0.25); padding: 4px 12px; border-radius: 20px; font-size: 0.75rem; font-weight: 500;">${config.label}</span>
            </div>
        </div>
    `;

    // Buscar dados da pessoa para obter WhatsApp
    $.ajax({
        url: appUrl('/pessoas/dados-rapidos'),
        type: 'GET',
        data: { id: id },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                const pessoa = response.data;
                const whatsapp = pessoa.whatsapp || pessoa.mobile || pessoa.phone || '';
                const whatsappNumero = whatsapp.replace(/\D/g, ''); // Remove caracteres não numéricos

                let whatsappButton = '';
                if (whatsappNumero) {
                    whatsappButton = `
                        <button type="button" class="opcao-btn opcao-btn-success" onclick="abrirWhatsApp('${whatsappNumero}')">
                            <i class="bi bi-whatsapp"></i>
                            <span>WhatsApp</span>
                        </button>
                    `;
                }

                const editarButton = canEdit ? `
                        <button type="button" class="opcao-btn opcao-btn-primary" onclick="window.location.href=appUrl('/pessoas/editar?id=${id}')">
                            <i class="bi bi-pencil"></i>
                            <span>Editar</span>
                        </button>
                ` : '';

                const excluirButton = canDelete ? `
                        <button type="button" class="opcao-btn opcao-btn-danger" onclick="Swal.close(); deletarPessoa(${id})">
                            <i class="bi bi-trash"></i>
                            <span>Excluir</span>
                        </button>
                ` : '';

                const buttonsHtml = `
                    <div class="opcoes-grid-compact">
                        <button type="button" class="opcao-btn opcao-btn-info" onclick="window.location.href=appUrl('/pessoas/ficha?id=${id}')">
                            <i class="bi bi-person-vcard"></i>
                            <span>Ficha</span>
                        </button>
                        <button type="button" class="opcao-btn opcao-btn-secondary" onclick="window.location.href=appUrl('/pessoas/extrato?id=${id}')">
                            <i class="bi bi-file-text"></i>
                            <span>Extrato</span>
                        </button>
                        ${whatsappButton}
                        ${editarButton}
                        ${excluirButton}
                    </div>
                `;

                Swal.fire({
                    html: headerHtml + buttonsHtml,
                    showConfirmButton: false,
                    showCloseButton: true,
                    width: 420,
                    padding: '20px',
                    customClass: {
                        popup: 'swal-opcoes-pessoa'
                    }
                });
            } else {
                // Se não conseguir buscar dados, mostra modal sem WhatsApp
                mostrarModalSemWhatsApp(id, headerHtml);
            }
        },
        error: function() {
            // Se erro, mostra modal sem WhatsApp
            mostrarModalSemWhatsApp(id, headerHtml);
        }
    });
}

// Função auxiliar para mostrar modal sem botão WhatsApp
function mostrarModalSemWhatsApp(id, headerHtml) {
    const editarButton = canEdit ? `
            <button type="button" class="opcao-btn opcao-btn-primary" onclick="window.location.href=appUrl('/pessoas/editar?id=${id}')">
                <i class="bi bi-pencil"></i>
                <span>Editar</span>
            </button>
    ` : '';

    const excluirButton = canDelete ? `
            <button type="button" class="opcao-btn opcao-btn-danger" onclick="Swal.close(); deletarPessoa(${id})">
                <i class="bi bi-trash"></i>
                <span>Excluir</span>
            </button>
    ` : '';

    const buttonsHtml = `
        <div class="opcoes-grid-compact">
            <button type="button" class="opcao-btn opcao-btn-info" onclick="window.location.href=appUrl('/pessoas/ficha?id=${id}')">
                <i class="bi bi-person-vcard"></i>
                <span>Ficha</span>
            </button>
            <button type="button" class="opcao-btn opcao-btn-secondary" onclick="window.location.href=appUrl('/pessoas/extrato?id=${id}')">
                <i class="bi bi-file-text"></i>
                <span>Extrato</span>
            </button>
            ${editarButton}
            ${excluirButton}
        </div>
    `;

    Swal.fire({
        html: headerHtml + buttonsHtml,
        showConfirmButton: false,
        showCloseButton: true,
        width: 420,
        padding: '20px',
        customClass: {
            popup: 'swal-opcoes-pessoa'
        }
    });
}

// Função para abrir WhatsApp
function abrirWhatsApp(numero) {
    const numeroLimpo = numero.replace(/\D/g, '');
    if (numeroLimpo) {
        const url = `https://wa.me/55${numeroLimpo}`;
        window.open(url, '_blank');
    }
}

// Função para deletar pessoa (cliente/fornecedor/funcionário)
async function deletarPessoa(id) {
    const confirmed = await confirmDelete('Tem certeza que deseja excluir esta pessoa?');
    if (confirmed) {
        $.ajax({
            url: appUrl('/pessoas/deletar'),
            type: 'POST',
            data: {
                id: id
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Toast.success(response.message);
                    setTimeout(() => location.reload(), 1500);
                } else {
                    Toast.error(response.message || 'Erro ao excluir pessoa');
                }
            },
            error: function(xhr, status, error) {
                console.error('Erro ao deletar pessoa:', xhr, status, error);
                let errorMessage = 'Erro ao excluir pessoa';

                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                } else if (xhr.responseText) {
                    try {
                        const response = JSON.parse(xhr.responseText);
                        errorMessage = response.message || errorMessage;
                    } catch (e) {
                        errorMessage = xhr.responseText || errorMessage;
                    }
                }

                Toast.error(errorMessage);
            }
        });
    }
}

// Função para abrir tutorial do módulo de Pessoas
function abrirTutorialPessoas() {
    Swal.fire({
        title: '<i class="bi bi-people text-primary"></i> Tutorial Completo: Módulo de Pessoas',
        html: `
            <div class="text-start" style="max-height: 70vh; overflow-y: auto;">
                <div class="mb-4">
                    <h5 class="text-primary mb-3"><i class="bi bi-info-circle me-2"></i>Visão Geral</h5>
                    <p class="text-muted">O módulo de Pessoas permite cadastrar e gerenciar Clientes, Fornecedores e Transportadoras em um único local. Cada pessoa pode ter múltiplos tipos associados.</p>
                </div>

                <div class="accordion" id="tutorialAccordion">
                    <!-- ABA: DADOS PRINCIPAIS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#dadosPrincipais">
                                <i class="bi bi-person me-2"></i> <strong>1. Aba: Dados Principais</strong>
                            </button>
                        </h2>
                        <div id="dadosPrincipais" class="accordion-collapse collapse show" data-bs-parent="#tutorialAccordion">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-toggle-on me-2"></i>Tipos de Pessoa</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Cliente:</strong> Marque esta opção se a pessoa pode realizar compras/vendas com sua empresa</li>
                                    <li><i class="bi bi-check-circle text-warning me-2"></i><strong>Fornecedor:</strong> Marque se a pessoa fornece produtos/serviços para sua empresa</li>
                                    <li><i class="bi bi-check-circle text-info me-2"></i><strong>Transportadora:</strong> Marque se a pessoa realiza entregas/envios</li>
                                    <li class="text-muted mt-2"><small><i class="bi bi-info-circle me-1"></i>Uma pessoa pode ter múltiplos tipos (ex: Cliente e Fornecedor)</small></li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-card-text me-2"></i>Tipo de Documento</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Pessoa Física (CPF):</strong> Para pessoas físicas</li>
                                    <li><strong>Pessoa Jurídica (CNPJ):</strong> Para empresas e organizações</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-person-badge me-2"></i>Campos - Pessoa Física</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Nome Completo *:</strong> Nome completo da pessoa (obrigatório)</li>
                                    <li><strong>CPF *:</strong> Cadastro de Pessoa Física, formato: 000.000.000-00 (obrigatório)</li>
                                    <li><strong>RG:</strong> Registro Geral, formato: 00.000.000-0 (opcional)</li>
                                    <li><strong>CNH:</strong> Carteira Nacional de Habilitação, apenas números (opcional)</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-building me-2"></i>Campos - Pessoa Jurídica</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>CNPJ *:</strong> Cadastro Nacional de Pessoa Jurídica, formato: 00.000.000/0000-00 (obrigatório)
                                        <br><small class="text-info"><i class="bi bi-magic me-1"></i>Busca automática de dados da Receita Federal ao sair do campo</small>
                                    </li>
                                    <li><strong>Razão Social *:</strong> Nome oficial da empresa conforme a Receita Federal (obrigatório)</li>
                                    <li><strong>Nome Fantasia:</strong> Nome comercial da empresa (opcional)</li>
                                    <li><strong>Inscrição Estadual:</strong> IE da empresa no estado, formato: 000.000.000.000 (opcional)</li>
                                    <li><strong>Inscrição Municipal:</strong> Inscrição no município, formato: 000.000.000 (opcional)</li>
                                    <li><strong>Inscrição SUFRAMA:</strong> Inscrição na Superintendência da Zona Franca de Manaus (opcional)</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-sticky me-2"></i>Observações</h6>
                                <p class="ms-3 text-muted">Campo de texto livre para anotações, observações ou informações adicionais sobre a pessoa.</p>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: ENDEREÇO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#endereco">
                                <i class="bi bi-geo-alt me-2"></i> <strong>2. Aba: Endereço</strong>
                            </button>
                        </h2>
                        <div id="endereco" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordion">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-search me-2"></i>CEP (Busca Automática)</h6>
                                <p class="ms-3 mb-3">Digite o CEP no formato 00000-000. Ao sair do campo, o sistema busca automaticamente e preenche:
                                    <br><small class="text-success"><i class="bi bi-check-circle me-1"></i>Endereço, Bairro, Cidade e Estado</small>
                                </p>

                                <h6 class="text-primary mb-3"><i class="bi bi-map me-2"></i>Campos de Endereço</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>CEP:</strong> Código Postal, formato: 00000-000</li>
                                    <li><strong>Endereço:</strong> Nome da rua, avenida, estrada, etc.</li>
                                    <li><strong>Número:</strong> Número do endereço (ex: 123, 456-A)</li>
                                    <li><strong>Complemento:</strong> Informações adicionais (ex: Sala 101, Andar 2, Bloco A)</li>
                                    <li><strong>Bairro:</strong> Bairro ou distrito</li>
                                    <li><strong>UF:</strong> Unidade Federativa (Estado), selecione na lista</li>
                                    <li><strong>Cidade:</strong> Nome da cidade</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: CONTATO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#contato">
                                <i class="bi bi-telephone me-2"></i> <strong>3. Aba: Contato</strong>
                            </button>
                        </h2>
                        <div id="contato" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordion">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-envelope me-2"></i>Informações de Contato</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Email:</strong> Endereço de e-mail para comunicação, formato: exemplo@email.com</li>
                                    <li><strong>Telefone:</strong> Telefone fixo, formato: (11) 3333-4444</li>
                                    <li><strong>Celular:</strong> Telefone celular, formato: (11) 99999-9999</li>
                                    <li><strong>Website:</strong> Site da empresa/pessoa, formato: https://www.exemplo.com.br</li>
                                    <li><strong>WhatsApp:</strong> Número do WhatsApp para comunicação (opcional)</li>
                                </ul>
                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small>Preencha pelo menos um meio de contato para facilitar a comunicação.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: VEÍCULOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#veiculos">
                                <i class="bi bi-truck-front me-2"></i> <strong>4. Aba: Veículos</strong>
                            </button>
                        </h2>
                        <div id="veiculos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordion">
                            <div class="accordion-body">
                                <p class="mb-3">Esta aba é especialmente útil para <strong>Transportadoras</strong>. Permite cadastrar múltiplos veículos e associar motoristas a cada um.</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-plus-circle me-2"></i>Adicionar Veículo</h6>
                                <p class="ms-3 mb-3">Clique em "Adicionar Veículo" para cadastrar um novo veículo. Para cada veículo, você pode informar:</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Placa:</strong> Placa do veículo (ex: ABC-1234)</li>
                                    <li><strong>Modelo:</strong> Modelo do veículo (ex: Mercedes-Benz Actros)</li>
                                    <li><strong>Cor:</strong> Cor do veículo</li>
                                    <li><strong>Ano:</strong> Ano de fabricação</li>
                                    <li><strong>Renavam:</strong> Número do Renavam</li>
                                    <li><strong>Motoristas:</strong> Adicione múltiplos motoristas associados ao veículo</li>
                                </ul>

                                <div class="alert alert-warning mt-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small>Esta funcionalidade é opcional e geralmente usada apenas para transportadoras.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: CONFIGURAÇÕES -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#configuracoes">
                                <i class="bi bi-gear me-2"></i> <strong>5. Aba: Configurações</strong>
                            </button>
                        </h2>
                        <div id="configuracoes" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordion">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-toggle-on me-2"></i>Status e Permissões</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Pessoa Ativa:</strong> Marque para manter a pessoa ativa no sistema. Desmarque para desativar (não aparecerá em listas)</li>
                                    <li><strong>Enviar Emails:</strong> Permite que o sistema envie emails automáticos para esta pessoa</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-currency-dollar me-2"></i>Configurações Financeiras</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Limite de Crédito (R$):</strong> Valor máximo de crédito permitido para esta pessoa (geralmente usado para clientes)
                                        <br><small class="text-muted">Exemplo: 10.000,00</small>
                                    </li>
                                    <li><strong>Prazo de Pagamento (dias):</strong> Prazo padrão em dias para pagamento (ex: 30, 60, 90 dias)
                                        <br><small class="text-muted">Usado como padrão em vendas/compras</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-folder me-2"></i>Organização</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Grupo:</strong> Selecione um grupo para categorizar a pessoa (ex: "Clientes VIP", "Fornecedores Nacionais")
                                        <br><small class="text-info"><i class="bi bi-info-circle me-1"></i>Lista apenas grupos do tipo "pessoas"</small>
                                    </li>
                                    <li><strong>Subgrupo:</strong> Selecione um subgrupo dentro do grupo escolhido
                                        <br><small class="text-info"><i class="bi bi-info-circle me-1"></i>Lista apenas subgrupos do grupo selecionado</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- DICAS E BOAS PRÁTICAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#dicas">
                                <i class="bi bi-lightbulb me-2"></i> <strong>Dicas e Boas Práticas</strong>
                            </button>
                        </h2>
                        <div id="dicas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordion">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-check-circle me-2"></i>Preenchimento Eficiente</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Use a busca automática de CEP para preencher endereço rapidamente</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Para CNPJ, a busca automática preenche Razão Social e outros dados</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Preencha pelo menos um tipo (Cliente, Fornecedor ou Transportadora)</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Campos marcados com * são obrigatórios</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-exclamation-triangle me-2"></i>Importante</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>CPF/CNPJ devem ser únicos no sistema</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Desative pessoas que não devem mais aparecer em listas (em vez de excluir)</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Configure limite de crédito apenas para clientes que compram a prazo</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Use grupos e subgrupos para organizar e filtrar pessoas</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-info-circle me-2"></i>Funcionalidades Especiais</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Uma pessoa pode ser Cliente, Fornecedor e Transportadora ao mesmo tempo</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Veículos são opcionais e geralmente usados apenas para transportadoras</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>O histórico de compras/vendas pode ser visualizado na página de detalhes</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="alert alert-success mt-4">
                    <i class="bi bi-check-circle me-2"></i>
                    <strong>Pronto para começar!</strong> Agora você conhece todos os campos e funcionalidades do módulo de Pessoas.
                </div>
            </div>
        `,
        width: '90%',
        heightAuto: false,
        confirmButtonText: 'Entendi, obrigado!',
        confirmButtonColor: '#0d6efd',
        icon: null,
        customClass: {
            popup: 'tutorial-popup',
            container: 'tutorial-container'
        }
    });
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'pessoas';
include ROOT_PATH . '/views/layouts/app.php';
?>