<?php
ob_start();
$isEdit = isset($pessoa);
$titulo = $isEdit ? 'Editar Pessoa' : 'Nova Pessoa';
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/pessoas') ?>">Pessoas</a></li>
                <li class="breadcrumb-item active"><?= $titulo ?></li>
            </ol>
        </nav>
        <h2><i class="bi bi-person me-2"></i> <?= $titulo ?></h2>
    </div>
</div>

<form id="formPessoa" novalidate>
    <input type="hidden" name="id" value="<?= $pessoa['id'] ?? '' ?>">
    <input type="hidden" id="veiculos_data" name="veiculos_data"
        value='<?= htmlspecialchars(json_encode($pessoaVeiculos ?? []), ENT_QUOTES, "UTF-8") ?>'>
    <input type="hidden" id="contatos-inicial-data"
        value='<?= htmlspecialchars(json_encode($pessoaContatos ?? []), ENT_QUOTES, "UTF-8") ?>'>

    <!-- Navegação por Abas -->
    <div class="row mb-4">
        <div class="col-12">
            <ul class="nav nav-tabs" id="pessoaTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados"
                        type="button" role="tab">
                        <i class="bi bi-person me-2"></i> Dados Principais
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="endereco-tab" data-bs-toggle="tab" data-bs-target="#endereco"
                        type="button" role="tab">
                        <i class="bi bi-geo-alt me-2"></i> Endereço
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="contato-tab" data-bs-toggle="tab" data-bs-target="#contato"
                        type="button" role="tab">
                        <i class="bi bi-telephone me-2"></i> Contato
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="veiculos-tab" data-bs-toggle="tab" data-bs-target="#veiculos"
                        type="button" role="tab">
                        <i class="bi bi-truck-front me-2"></i> Veículos
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="configuracoes-tab" data-bs-toggle="tab" data-bs-target="#configuracoes"
                        type="button" role="tab">
                        <i class="bi bi-gear me-2"></i> Configurações
                    </button>
                </li>
            </ul>
        </div>
    </div>

    <!-- Conteúdo das Abas -->
    <div class="tab-content" id="pessoaTabsContent">
        <!-- Aba: Dados Principais -->
        <div class="tab-pane fade show active" id="dados" role="tabpanel">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <i class="bi bi-info-circle me-2"></i> Informações Básicas
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="row align-items-start">
                                        <div class="col-md-9">
                                            <label class="form-label">Tipo *</label>
                                            <div class="d-flex gap-2 flex-wrap">
                                                <div class="modern-switch-wrapper">
                                                    <input type="checkbox" class="modern-switch-input"
                                                        name="tipo_cliente" id="tipo_cliente" value="1"
                                                        <?= isset($pessoa['tipo_cliente']) && $pessoa['tipo_cliente'] ? 'checked' : '' ?>>
                                                    <label class="modern-switch-label" for="tipo_cliente">
                                                        <span class="modern-switch-slider"></span>
                                                        <span class="modern-switch-text">
                                                            <i class="bi bi-person-heart me-1"></i>Cliente
                                                        </span>
                                                    </label>
                                                </div>
                                                <div class="modern-switch-wrapper">
                                                    <input type="checkbox" class="modern-switch-input"
                                                        name="tipo_fornecedor" id="tipo_fornecedor" value="1"
                                                        <?= isset($pessoa['tipo_fornecedor']) && $pessoa['tipo_fornecedor'] ? 'checked' : '' ?>>
                                                    <label class="modern-switch-label" for="tipo_fornecedor">
                                                        <span class="modern-switch-slider"></span>
                                                        <span class="modern-switch-text">
                                                            <i class="bi bi-building me-1"></i>Fornecedor
                                                        </span>
                                                    </label>
                                                </div>
                                                <div class="modern-switch-wrapper">
                                                    <input type="checkbox" class="modern-switch-input"
                                                        name="tipo_transportadora" id="tipo_transportadora" value="1"
                                                        <?= isset($pessoa['tipo_transportadora']) && $pessoa['tipo_transportadora'] ? 'checked' : '' ?>>
                                                    <label class="modern-switch-label" for="tipo_transportadora">
                                                        <span class="modern-switch-slider"></span>
                                                        <span class="modern-switch-text">
                                                            <i class="bi bi-truck me-1"></i>Transportadora
                                                        </span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <label for="person_type" class="form-label">Pessoa *</label>
                                            <select class="form-select" id="person_type" name="person_type" required
                                                onchange="togglePersonType()">
                                                <option value="">Selecione...</option>
                                                <option value="fisica"
                                                    <?= ($pessoa['person_type'] ?? '') === 'fisica' ? 'selected' : '' ?>>
                                                    Física (CPF)</option>
                                                <option value="juridica"
                                                    <?= ($pessoa['person_type'] ?? '') === 'juridica' ? 'selected' : '' ?>>
                                                    Jurídica (CNPJ)</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <!-- Campos Pessoa Física -->
                                <div id="campos_pf" style="display: none;" class="col-12">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="name_pf" class="form-label">Nome Completo *</label>
                                            <input type="text" class="form-control" id="name_pf" name="name_pf"
                                                value="<?= htmlspecialchars($pessoa['name'] ?? '') ?>">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="document_pf" class="form-label">CPF *</label>
                                            <input type="text" class="form-control" id="document_pf" name="document_pf"
                                                placeholder="000.000.000-00"
                                                value="<?= htmlspecialchars($pessoa['document'] ?? '') ?>">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="rg_ie" class="form-label">RG</label>
                                            <input type="text" class="form-control" id="rg_ie" name="rg_ie"
                                                placeholder="00.000.000-0"
                                                value="<?= htmlspecialchars($pessoa['rg_ie'] ?? '') ?>">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="cnh" class="form-label">CNH</label>
                                            <input type="text" class="form-control" id="cnh" name="cnh"
                                                placeholder="00000000000"
                                                value="<?= htmlspecialchars($pessoa['cnh'] ?? '') ?>">
                                        </div>
                                    </div>
                                </div>

                                <!-- Campos Pessoa Jurídica -->
                                <div id="campos_pj" style="display: none;" class="col-12">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="document_pj" class="form-label">CNPJ *</label>
                                            <input type="text" class="form-control" id="document_pj" name="document_pj"
                                                placeholder="00.000.000/0000-00"
                                                value="<?= htmlspecialchars($pessoa['document'] ?? '') ?>"
                                                onblur="buscarCNPJAgora(this.value)">
                                            <small class="text-muted">Busca automática ao sair do campo</small>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="name_pj" class="form-label">Razão Social *</label>
                                            <input type="text" class="form-control" id="name_pj" name="name_pj"
                                                value="<?= htmlspecialchars($pessoa['name'] ?? '') ?>">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="trade_name" class="form-label">Nome Fantasia</label>
                                            <input type="text" class="form-control" id="trade_name" name="trade_name"
                                                value="<?= htmlspecialchars($pessoa['trade_name'] ?? '') ?>">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="rg_ie" class="form-label">Inscrição Estadual</label>
                                            <input type="text" class="form-control" id="ie" name="rg_ie"
                                                placeholder="000.000.000.000"
                                                value="<?= htmlspecialchars($pessoa['rg_ie'] ?? '') ?>">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="inscricao_municipal" class="form-label">Inscrição
                                                Municipal</label>
                                            <input type="text" class="form-control" id="inscricao_municipal"
                                                name="inscricao_municipal" placeholder="000.000.000"
                                                value="<?= htmlspecialchars($pessoa['inscricao_municipal'] ?? '') ?>">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="inscricao_suframa" class="form-label">Inscrição SUFRAMA</label>
                                            <input type="text" class="form-control" id="inscricao_suframa"
                                                name="inscricao_suframa" placeholder="000000000"
                                                value="<?= htmlspecialchars($pessoa['inscricao_suframa'] ?? '') ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label for="notes" class="form-label">Observações</label>
                                    <textarea class="form-control" id="notes" name="notes" rows="3"
                                        placeholder="Observações sobre esta pessoa..."><?= htmlspecialchars($pessoa['notes'] ?? '') ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- Aba: Endereço -->
        <div class="tab-pane fade" id="endereco" role="tabpanel">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <i class="bi bi-geo-alt me-2"></i> Endereço Completo
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <label for="zip_code" class="form-label">
                                        CEP
                                        <i class="bi bi-search text-primary" style="cursor: pointer;"
                                            title="Busca automática ao digitar"></i>
                                    </label>
                                    <input type="text" class="form-control" id="zip_code" name="zip_code"
                                        placeholder="00000-000"
                                        value="<?= htmlspecialchars($pessoa['zip_code'] ?? '') ?>"
                                        onblur="buscarCEPAgora(this.value)">
                                    <small class="text-muted">Preenche automaticamente</small>
                                </div>

                                <div class="col-md-7 mb-3">
                                    <label for="address" class="form-label">Endereço</label>
                                    <input type="text" class="form-control" id="address" name="address"
                                        placeholder="Rua, Avenida..."
                                        value="<?= htmlspecialchars($pessoa['address'] ?? '') ?>">
                                </div>

                                <div class="col-md-2 mb-3">
                                    <label for="numero" class="form-label">Número</label>
                                    <input type="text" class="form-control" id="numero" name="numero" placeholder="123"
                                        value="<?= htmlspecialchars($pessoa['numero'] ?? '') ?>">
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="complemento" class="form-label">Complemento</label>
                                    <input type="text" class="form-control" id="complemento" name="complemento"
                                        placeholder="Sala, Andar..."
                                        value="<?= htmlspecialchars($pessoa['complemento'] ?? '') ?>">
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="bairro" class="form-label">Bairro</label>
                                    <input type="text" class="form-control" id="bairro" name="bairro"
                                        placeholder="Centro" value="<?= htmlspecialchars($pessoa['bairro'] ?? '') ?>">
                                </div>

                                <div class="col-md-2 mb-3">
                                    <label for="state" class="form-label">UF</label>
                                    <select class="form-select" id="state" name="state">
                                        <option value="">UF</option>
                                        <?php
                                        $estados = ['AC','AL','AP','AM','BA','CE','DF','ES','GO','MA','MT','MS','MG','PA','PB','PR','PE','PI','RJ','RN','RS','RO','RR','SC','SP','SE','TO'];
                                        foreach ($estados as $uf):
                                        ?>
                                        <option value="<?= $uf ?>"
                                            <?= ($pessoa['state'] ?? '') === $uf ? 'selected' : '' ?>>
                                            <?= $uf ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="city" class="form-label">Cidade</label>
                                    <input type="text" class="form-control" id="city" name="city"
                                        placeholder="São Paulo" value="<?= htmlspecialchars($pessoa['city'] ?? '') ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aba: Contato -->
        <div class="tab-pane fade" id="contato" role="tabpanel">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <i class="bi bi-telephone me-2"></i> Informações de Contato
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="email" class="form-control" id="email" name="email"
                                        placeholder="exemplo@email.com"
                                        value="<?= htmlspecialchars($pessoa['email'] ?? '') ?>">
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="phone" class="form-label">Telefone</label>
                                    <input type="text" class="form-control" id="phone" name="phone"
                                        placeholder="(11) 3333-4444"
                                        value="<?= htmlspecialchars($pessoa['phone'] ?? '') ?>">
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="mobile" class="form-label">Celular</label>
                                    <input type="text" class="form-control" id="mobile" name="mobile"
                                        placeholder="(11) 99999-9999"
                                        value="<?= htmlspecialchars($pessoa['mobile'] ?? '') ?>">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="website" class="form-label">Website</label>
                                    <input type="url" class="form-control" id="website" name="website"
                                        placeholder="https://www.exemplo.com.br"
                                        value="<?= htmlspecialchars($pessoa['website'] ?? '') ?>">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="whatsapp" class="form-label">
                                        <i class="bi bi-whatsapp me-1 text-success"></i> WhatsApp
                                    </label>
                                    <input type="text" class="form-control" id="whatsapp" name="whatsapp"
                                        placeholder="(00) 00000-0000"
                                        value="<?= htmlspecialchars($pessoa['whatsapp'] ?? '') ?>">
                                    <small class="form-text text-muted">
                                        Digite o número com DDD (ex: 11987654321)
                                    </small>
                                </div>
                            </div>

                            <!-- Seção de Contatos Adicionais -->
                            <hr class="my-4">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <div>
                                    <h6 class="mb-0">
                                        <i class="bi bi-people me-2"></i> Contatos Adicionais
                                    </h6>
                                    <small class="text-muted">Cadastre múltiplos contatos para esta pessoa (Nome, Telefone e Cargo)</small>
                                </div>
                                <button type="button" class="btn btn-primary btn-sm" onclick="adicionarContato()">
                                    <i class="bi bi-plus-circle me-1"></i> Adicionar Contato
                                </button>
                            </div>
                            <div id="contatos-list" class="contatos-list"></div>
                            <input type="hidden" id="contatos_data" name="contatos_data" value="">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aba: Veículos -->
        <div class="tab-pane fade" id="veiculos" role="tabpanel">
            <div class="row">
                <div class="col-12">
                    <div class="card shadow-sm">
                        <div class="card-header d-flex justify-content-between align-items-center flex-wrap gap-2">
                            <div>
                                <h5 class="mb-0"><i class="bi bi-truck-front me-2"></i> Veículos e Motoristas</h5>
                                <small class="text-muted">Cadastre múltiplos veículos e associe os motoristas de cada
                                    um.</small>
                            </div>
                            <button type="button" class="btn btn-primary" onclick="adicionarVeiculo()">
                                <i class="bi bi-plus-circle me-1"></i> Adicionar Veículo
                            </button>
                        </div>
                        <div class="card-body">
                            <div id="veiculos-list" class="veiculos-list"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aba: Configurações -->
        <div class="tab-pane fade" id="configuracoes" role="tabpanel">
            <div class="card">
                <div class="card-header">
                    <i class="bi bi-gear me-2"></i> Configurações da Pessoa
                </div>
                <div class="card-body">
                    <!-- Primeira linha: Toggles -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <label class="form-label">Pessoa Ativa</label>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" role="switch" id="is_active" name="is_active"
                                    <?= (!isset($pessoa['is_active']) || $pessoa['is_active']) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="is_active">
                                    Ativar/Desativar pessoa no sistema
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Enviar Emails</label>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" role="switch" id="send_email" name="send_email"
                                    <?= (!isset($pessoa['send_email']) || $pessoa['send_email']) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="send_email">
                                    <i class="bi bi-envelope me-1"></i> Permitir envio de emails
                                </label>
                            </div>
                        </div>
                    </div>

                    <!-- Segunda linha: Campos financeiros e grupos -->
                    <div class="row mb-3">
                        <div class="col-md-4 mb-4">
                            <label for="credit_limit" class="form-label">Limite de Crédito (R$)</label>
                            <input type="text" class="form-control" id="credit_limit" name="credit_limit"
                                placeholder="0,00"
                                value="<?= isset($pessoa['credit_limit']) ? number_format((float)$pessoa['credit_limit'], 2, ',', '.') : '0,00' ?>">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="grupo_id" class="form-label">
                                <i class="bi bi-folder me-1"></i> Grupo
                            </label>
                            <select class="form-select" id="grupo_id" name="grupo_id">
                                <option value="">Selecione um grupo</option>
                                <?php if (!empty($grupos)): ?>
                                    <?php foreach ($grupos as $grupo): ?>
                                        <option value="<?= $grupo['id'] ?>"
                                            <?= (isset($pessoa['grupo_id']) && $pessoa['grupo_id'] == $grupo['id']) ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($grupo['nome'] ?? '') ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="subgrupo_id" class="form-label">
                                <i class="bi bi-tag me-1"></i> Subgrupo
                            </label>
                            <select class="form-select" id="subgrupo_id" name="subgrupo_id">
                                <option value="">Selecione um subgrupo</option>
                                <?php if (!empty($subgrupos)): ?>
                                    <?php foreach ($subgrupos as $subgrupo): ?>
                                        <option value="<?= $subgrupo['id'] ?>"
                                            data-grupo="<?= $subgrupo['grupo_id'] ?>"
                                            <?= (isset($pessoa['subgrupo_id']) && $pessoa['subgrupo_id'] == $subgrupo['id']) ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($subgrupo['nome'] ?? '') ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Terceira linha: Vendedores e Área Comercial -->
                    <div class="row mb-3">
                        <div class="col-md-4 mb-3">
                            <label for="vendedor_id" class="form-label">
                                <i class="bi bi-person-badge me-1"></i> Vendedor
                            </label>
                            <select class="form-select" id="vendedor_id" name="vendedor_id">
                                <option value="">Selecione um vendedor</option>
                                <?php if (!empty($vendedores)): ?>
                                    <?php foreach ($vendedores as $vendedor): ?>
                                        <option value="<?= $vendedor['id'] ?>"
                                            <?= (isset($pessoa['vendedor_id']) && $pessoa['vendedor_id'] == $vendedor['id']) ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($vendedor['name'] ?? '') ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="vendedor_auxiliar_id" class="form-label">
                                <i class="bi bi-person-badge me-1"></i> Vendedor Auxiliar
                            </label>
                            <select class="form-select" id="vendedor_auxiliar_id" name="vendedor_auxiliar_id">
                                <option value="">Selecione um vendedor auxiliar</option>
                                <?php if (!empty($vendedores)): ?>
                                    <?php foreach ($vendedores as $vendedor): ?>
                                        <option value="<?= $vendedor['id'] ?>"
                                            <?= (isset($pessoa['vendedor_auxiliar_id']) && $pessoa['vendedor_auxiliar_id'] == $vendedor['id']) ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($vendedor['name'] ?? '') ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="area_comercial_id" class="form-label">
                                <i class="bi bi-building me-1"></i> Área Comercial
                            </label>
                            <select class="form-select" id="area_comercial_id" name="area_comercial_id">
                                <option value="">Selecione uma área comercial</option>
                                <?php if (!empty($areas)): ?>
                                    <?php foreach ($areas as $area): ?>
                                        <option value="<?= $area['id'] ?>"
                                            <?= (isset($pessoa['area_comercial_id']) && $pessoa['area_comercial_id'] == $area['id']) ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($area['name'] ?? '') ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Divisor -->
                    <hr class="my-4">

                    <!-- Seção de Licenças e Registros -->
                    <div class="mb-4">
                        <label class="form-label mb-3">
                            <i class="bi bi-file-check me-1"></i> Licenças e Registros
                        </label>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="data_anvisa" class="form-label">Anvisa</label>
                                <div class="input-group">
                                    <input type="date" class="form-control" id="data_anvisa" name="data_anvisa"
                                           value="<?= !empty($pessoa['data_anvisa']) ? date('Y-m-d', strtotime($pessoa['data_anvisa'])) : '' ?>"
                                           placeholder="DD/MM/AAAA">
                                    <span class="input-group-text">
                                        <i class="bi bi-calendar"></i>
                                    </span>
                                </div>
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="data_conselho_farmacia" class="form-label">Conselho de Farmácia</label>
                                <div class="input-group">
                                    <input type="date" class="form-control" id="data_conselho_farmacia" name="data_conselho_farmacia"
                                           value="<?= !empty($pessoa['data_conselho_farmacia']) ? date('Y-m-d', strtotime($pessoa['data_conselho_farmacia'])) : '' ?>"
                                           placeholder="DD/MM/AAAA">
                                    <span class="input-group-text">
                                        <i class="bi bi-calendar"></i>
                                    </span>
                                </div>
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="data_vigilancia_sanitaria" class="form-label">Vigilância Sanitária</label>
                                <div class="input-group">
                                    <input type="date" class="form-control" id="data_vigilancia_sanitaria" name="data_vigilancia_sanitaria"
                                           value="<?= !empty($pessoa['data_vigilancia_sanitaria']) ? date('Y-m-d', strtotime($pessoa['data_vigilancia_sanitaria'])) : '' ?>"
                                           placeholder="DD/MM/AAAA">
                                    <span class="input-group-text">
                                        <i class="bi bi-calendar"></i>
                                    </span>
                                </div>
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="data_alvara_localizacao" class="form-label">Alvará de Localização</label>
                                <div class="input-group">
                                    <input type="date" class="form-control" id="data_alvara_localizacao" name="data_alvara_localizacao"
                                           value="<?= !empty($pessoa['data_alvara_localizacao']) ? date('Y-m-d', strtotime($pessoa['data_alvara_localizacao'])) : '' ?>"
                                           placeholder="DD/MM/AAAA">
                                    <span class="input-group-text">
                                        <i class="bi bi-calendar"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Divisor -->
                    <hr class="my-4">

                    <!-- Seção de Empresas Vinculadas -->
                    <div class="mb-3">
                        <label class="form-label mb-3">
                            <i class="bi bi-building me-1"></i> Empresas Vinculadas
                        </label>
                        <div class="card border">
                            <div class="card-body p-3" style="max-height: 350px; overflow-y: auto;">
                                <div class="mb-3 pb-3 border-bottom bg-light rounded p-2 sticky-top">
                                    <div class="modern-switch-wrapper">
                                        <input type="checkbox" class="modern-switch-input" id="marcar_todas_empresas">
                                        <label class="modern-switch-label" for="marcar_todas_empresas">
                                            <span class="modern-switch-slider"></span>
                                            <span class="modern-switch-text fw-bold">
                                                <i class="bi bi-check-all me-1"></i> Marcar todas
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div id="empresas_list">
                                    <?php if (!empty($todasEmpresas)): ?>
                                        <?php
                                        $empresasVinculadasIds = array_map('intval', $empresasVinculadas ?? []);
                                        foreach ($todasEmpresas as $empresa):
                                            $isChecked = in_array((int)$empresa['id'], $empresasVinculadasIds);
                                        ?>
                                            <div class="modern-switch-wrapper empresa-item-wrapper mb-2" style="padding: 10px 12px;">
                                                <input type="checkbox"
                                                       class="modern-switch-input empresa-checkbox"
                                                       value="<?= $empresa['id'] ?>"
                                                       id="empresa_<?= $empresa['id'] ?>"
                                                       <?= $isChecked ? 'checked' : '' ?>>
                                                <label class="modern-switch-label" for="empresa_<?= $empresa['id'] ?>">
                                                    <span class="modern-switch-slider"></span>
                                                    <span class="modern-switch-text">
                                                        <div class="fw-medium">
                                                            <?= htmlspecialchars($empresa['razao_social']) ?>
                                                        </div>
                                                        <?php if (!empty($empresa['cnpj'])): ?>
                                                            <small class="text-muted d-block mt-1">
                                                                <i class="bi bi-file-earmark-text me-1"></i>
                                                                <?= htmlspecialchars($empresa['cnpj']) ?>
                                                            </small>
                                                        <?php endif; ?>
                                                    </span>
                                                </label>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <div class="text-center text-muted py-4">
                                            <i class="bi bi-building" style="font-size: 2rem; opacity: 0.3;"></i>
                                            <p class="mb-0 mt-2">Nenhuma empresa cadastrada.</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Campo oculto para enviar os IDs das empresas vinculadas -->
                    <input type="hidden" name="empresas_vinculadas" id="empresas_vinculadas_input"
                        value="<?= htmlspecialchars(json_encode($empresasVinculadas ?? []), ENT_QUOTES, 'UTF-8') ?>">
                </div>
            </div>
        </div>
    </div>

    <!-- Botões -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle me-2"></i> Salvar
                </button>
                <a href="<?= url('/pessoas') ?>" class="btn btn-secondary">
                    <i class="bi bi-x-circle me-2"></i> Cancelar
                </a>
            </div>
        </div>
    </div>
</form>

<style>
/* Modern Switch Styles - Compacto */
.modern-switch-wrapper {
    position: relative;
    display: flex;
    align-items: center;
    padding: 8px 12px;
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.modern-switch-wrapper:hover {
    border-color: #0066CC;
    background: #e7f3ff;
    transform: translateX(2px);
}

.modern-switch-input {
    position: absolute;
    opacity: 0;
    cursor: pointer;
    height: 0;
    width: 0;
}

.modern-switch-label {
    display: flex;
    align-items: center;
    cursor: pointer;
    user-select: none;
    width: 100%;
    margin: 0;
    font-weight: 500;
}

.modern-switch-slider {
    position: relative;
    width: 40px;
    height: 20px;
    background-color: #cbd5e0;
    border-radius: 20px;
    transition: all 0.2s ease;
    margin-right: 10px;
    box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.1);
}

.modern-switch-slider:before {
    content: "";
    position: absolute;
    height: 16px;
    width: 16px;
    left: 2px;
    bottom: 2px;
    background-color: white;
    border-radius: 50%;
    transition: all 0.2s ease;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
}

.modern-switch-input:checked+.modern-switch-label .modern-switch-slider {
    background: linear-gradient(135deg, #0066CC 0%, #0052a3 100%);
}

.modern-switch-input:checked+.modern-switch-label .modern-switch-slider:before {
    transform: translateX(20px);
}

.modern-switch-wrapper:has(.modern-switch-input:checked) {
    border-color: #0066CC;
    background: #e7f3ff;
}

.modern-switch-text {
    flex: 1;
    font-size: 0.9rem;
    color: #2c3e50;
}

.modern-switch-input:checked+.modern-switch-label .modern-switch-text {
    color: #0066CC;
    font-weight: 600;
}

.modern-switch-wrapper:active {
    transform: scale(0.98);
}

.veiculos-list .veiculo-card {
    border: 1px solid #e5e7eb;
    border-radius: 12px;
    padding: 1.25rem;
    margin-bottom: 1.25rem;
    box-shadow: 0 5px 15px rgba(15, 23, 42, 0.05);
}

.veiculo-card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
}

.motoristas-wrapper {
    background: #f8f9fb;
    border-radius: 10px;
    padding: 1rem;
    margin-top: 1rem;
}

.motorista-card {
    border: 1px dashed #cbd5f5;
    border-radius: 8px;
    padding: 0.75rem;
    margin-bottom: 0.75rem;
    background: #fff;
}

.motorista-card:last-child {
    margin-bottom: 0;
}

.btn-remove {
    color: #dc3545;
}

.veiculos-list-empty {
    border: 1px dashed #cbd5f5;
    border-radius: 10px;
    padding: 1.5rem;
    text-align: center;
    color: #64748b;
    background: #f8fafc;
}
/* Estilo moderno para empresas vinculadas com toggle switches */
.empresa-item-wrapper {
    border: 1px solid #e9ecef;
}

.empresa-item-wrapper:hover {
    border-color: #0066CC;
    box-shadow: 0 2px 4px rgba(0, 102, 204, 0.1);
}

.empresa-item-wrapper:has(.modern-switch-input:checked) {
    background-color: #e7f3ff;
    border-color: #0066CC;
}

.empresa-item-wrapper .modern-switch-text .fw-medium {
    color: #2c3e50;
}

.empresa-item-wrapper:has(.modern-switch-input:checked) .modern-switch-text .fw-medium {
    color: #0066CC;
}
</style>

<script>
// ALTERNAR ENTRE PESSOA FÍSICA E JURÍDICA
function togglePersonType() {
    var personType = document.getElementById('person_type').value;
    var camposPF = document.getElementById('campos_pf');
    var camposPJ = document.getElementById('campos_pj');

    if (personType === 'fisica') {
        camposPF.style.display = 'block';
        camposPJ.style.display = 'none';

        // Habilita campos PF
        var namePF = document.getElementById('name_pf');
        var documentPF = document.getElementById('document_pf');
        if (namePF) namePF.required = true;
        if (documentPF) documentPF.required = true;

        // Desabilita campos PJ
        var namePJ = document.getElementById('name_pj');
        var documentPJ = document.getElementById('document_pj');
        if (namePJ) namePJ.required = false;
        if (documentPJ) documentPJ.required = false;
    } else if (personType === 'juridica') {
        camposPF.style.display = 'none';
        camposPJ.style.display = 'block';

        // Desabilita campos PF
        var namePF = document.getElementById('name_pf');
        var documentPF = document.getElementById('document_pf');
        if (namePF) namePF.required = false;
        if (documentPF) documentPF.required = false;

        // Habilita campos PJ
        var namePJ = document.getElementById('name_pj');
        var documentPJ = document.getElementById('document_pj');
        if (namePJ) namePJ.required = true;
        if (documentPJ) documentPJ.required = true;
    } else {
        // Nenhum selecionado
        camposPF.style.display = 'none';
        camposPJ.style.display = 'none';
    }
}

// BUSCA CEP - FUNÇÃO DIRETA NO ONBLUR
function buscarCEPAgora(cep) {
    cep = cep.replace(/\D/g, '');

    if (cep.length !== 8) return;

    document.getElementById('address').value = 'Buscando...';
    document.getElementById('address').disabled = true;

    fetch('https://viacep.com.br/ws/' + cep + '/json/')
        .then(response => response.json())
        .then(data => {
            if (!data.erro) {
                document.getElementById('address').value = data.logradouro || '';
                document.getElementById('bairro').value = data.bairro || '';
                document.getElementById('city').value = data.localidade || '';
                document.getElementById('state').value = data.uf || '';
                document.getElementById('complemento').value = data.complemento || '';
                document.getElementById('numero').focus();

                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'success',
                        title: 'CEP encontrado!',
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 2000
                    });
                }
            } else {
                document.getElementById('address').value = '';
                alert('CEP não encontrado!');
            }
        })
        .catch(error => {
            document.getElementById('address').value = '';
            alert('Erro ao buscar CEP!');
        })
        .finally(() => {
            document.getElementById('address').disabled = false;
        });
}

// BUSCA CNPJ - FUNÇÃO DIRETA NO ONBLUR
function buscarCNPJAgora(doc) {
    doc = doc.replace(/\D/g, '');

    if (doc.length !== 14) return;

    // Mostra loading no campo nome
    var nameField = document.getElementById('name_pj');
    if (!nameField) return;

    var originalValue = nameField.value;
    nameField.value = 'Buscando dados do CNPJ...';
    nameField.disabled = true;

    fetch('https://brasilapi.com.br/api/cnpj/v1/' + doc)
        .then(response => {
            if (!response.ok) {
                return response.json().then(err => Promise.reject(err));
            }
            return response.json();
        })
        .then(data => {
            // Verifica se retornou erro da API
            if (data.type === 'bad_request' || data.name === 'BadRequestError') {
                throw data;
            }

            // Preenche automaticamente SEM perguntar
            var nameField = document.getElementById('name_pj');
            if (nameField) {
                nameField.value = data.razao_social || data.nome_fantasia || '';
            }

            if (document.getElementById('trade_name')) {
                document.getElementById('trade_name').value = data.nome_fantasia || data.razao_social || '';
            }
            if (document.getElementById('email')) {
                document.getElementById('email').value = data.email || '';
            }
            if (document.getElementById('phone')) {
                document.getElementById('phone').value = data.ddd_telefone_1 || '';
            }
            if (document.getElementById('zip_code')) {
                document.getElementById('zip_code').value = data.cep || '';
            }
            if (document.getElementById('address')) {
                document.getElementById('address').value = data.logradouro || '';
            }
            if (document.getElementById('numero')) {
                document.getElementById('numero').value = data.numero || '';
            }
            if (document.getElementById('complemento')) {
                document.getElementById('complemento').value = data.complemento || '';
            }
            if (document.getElementById('bairro')) {
                document.getElementById('bairro').value = data.bairro || '';
            }
            if (document.getElementById('city')) {
                document.getElementById('city').value = data.municipio || '';
            }
            if (document.getElementById('state')) {
                document.getElementById('state').value = data.uf || '';
            }

            nameField.disabled = false;

            // Toast de sucesso
            if (typeof Swal !== 'undefined') {
                Swal.fire({
                    icon: 'success',
                    title: 'CNPJ encontrado!',
                    text: 'Dados preenchidos automaticamente',
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 2000
                });
            }
        })
        .catch(error => {
            nameField.value = originalValue;
            nameField.disabled = false;

            // Verifica se é erro de CNPJ inválido
            if (error && (error.type === 'bad_request' || error.name === 'BadRequestError')) {
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'error',
                        title: 'CNPJ Inválido!',
                        text: error.message || 'O CNPJ informado é inválido.',
                        confirmButtonColor: '#dc3545'
                    });
                } else {
                    alert('CNPJ Inválido! ' + (error.message || ''));
                }
            } else {
                // Erro genérico (falha de rede, etc)
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'warning',
                        title: 'CNPJ não encontrado',
                        text: 'Não foi possível consultar este CNPJ. Preencha os dados manualmente.',
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 3000
                    });
                }
            }
        });
}

// ============================================
// ABA DE VEÍCULOS E MOTORISTAS
// ============================================
const veiculosHiddenInput = document.getElementById('veiculos_data');
let veiculosData = [];

function novoVeiculoTemplate() {
    return {
        apelido: '',
        placa: '',
        tipo: '',
        marca: '',
        modelo: '',
        ano: '',
        cor: '',
        renavam: '',
        chassi: '',
        capacidade: '',
        observacoes: '',
        motoristas: []
    };
}

function novoMotoristaTemplate() {
    return {
        nome: '',
        documento: '',
        cnh: '',
        categoria_cnh: '',
        validade_cnh: '',
        telefone: '',
        email: '',
        observacoes: ''
    };
}

function normalizarMotoristas(data) {
    if (!Array.isArray(data)) {
        return [];
    }
    return data.map((motorista) => {
        const base = novoMotoristaTemplate();
        Object.keys(base).forEach((campo) => {
            if (campo === 'validade_cnh') {
                base[campo] = motorista[campo] ? String(motorista[campo]).substring(0, 10) : '';
            } else {
                const valor = motorista[campo];
                base[campo] = valor !== null && valor !== undefined ? String(valor) : '';
            }
        });
        return base;
    });
}

function normalizarVeiculosData(raw) {
    if (!Array.isArray(raw)) {
        return [];
    }

    return raw.map((veiculo) => {
        const base = novoVeiculoTemplate();
        Object.keys(base).forEach((campo) => {
            if (campo === 'motoristas') {
                base[campo] = normalizarMotoristas(veiculo[campo] ?? []);
            } else {
                const valor = veiculo[campo];
                base[campo] = valor !== null && valor !== undefined ? String(valor) : '';
            }
        });
        return base;
    });
}

function escapeHtmlVeiculos(text) {
    const map = {
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;',
        '"': '&quot;',
        "'": '&#039;'
    };
    return String(text ?? '').replace(/[&<>"']/g, (m) => map[m]);
}

function obterVeiculosIniciais() {
    if (!veiculosHiddenInput || !veiculosHiddenInput.value) {
        return [];
    }
    try {
        return JSON.parse(veiculosHiddenInput.value);
    } catch (error) {
        console.warn('Não foi possível interpretar os veículos iniciais:', error);
        return [];
    }
}

function sincronizarVeiculosHidden() {
    if (veiculosHiddenInput) {
        veiculosHiddenInput.value = JSON.stringify(veiculosData ?? []);
    }
}

function gerarMotoristasHtml(motoristas, veiculoIndex) {
    if (!Array.isArray(motoristas) || motoristas.length === 0) {
        return `
            <div class="veiculos-list-empty py-3 mb-0">
                <i class="bi bi-person-lock me-2"></i>
                Nenhum motorista cadastrado para este veículo.
            </div>
        `;
    }

    return motoristas.map((motorista, motoristaIndex) => `
        <div class="motorista-card" data-motorista-index="${motoristaIndex}">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <strong><i class="bi bi-person me-1"></i> Motorista ${motoristaIndex + 1}</strong>
                <button type="button" class="btn btn-link btn-sm text-danger"
                    onclick="removerMotorista(${veiculoIndex}, ${motoristaIndex})">
                    <i class="bi bi-x-circle me-1"></i> Remover
                </button>
            </div>
            <div class="row g-2">
                <div class="col-md-4">
                    <label class="form-label small mb-1">Nome</label>
                    <input type="text" class="form-control form-control-sm"
                        value="${escapeHtmlVeiculos(motorista.nome)}"
                        oninput="atualizarMotoristaCampo(${veiculoIndex}, ${motoristaIndex}, 'nome', this.value)">
                </div>
                <div class="col-md-4">
                    <label class="form-label small mb-1">Documento</label>
                    <input type="text" class="form-control form-control-sm"
                        value="${escapeHtmlVeiculos(motorista.documento)}"
                        oninput="atualizarMotoristaCampo(${veiculoIndex}, ${motoristaIndex}, 'documento', this.value)">
                </div>
                <div class="col-md-4">
                    <label class="form-label small mb-1">Telefone</label>
                    <input type="text" class="form-control form-control-sm"
                        value="${escapeHtmlVeiculos(motorista.telefone)}"
                        oninput="atualizarMotoristaCampo(${veiculoIndex}, ${motoristaIndex}, 'telefone', this.value)">
                </div>
                <div class="col-md-4">
                    <label class="form-label small mb-1">CNH</label>
                    <input type="text" class="form-control form-control-sm"
                        value="${escapeHtmlVeiculos(motorista.cnh)}"
                        oninput="atualizarMotoristaCampo(${veiculoIndex}, ${motoristaIndex}, 'cnh', this.value)">
                </div>
                <div class="col-md-2">
                    <label class="form-label small mb-1">Categoria</label>
                    <input type="text" class="form-control form-control-sm"
                        value="${escapeHtmlVeiculos(motorista.categoria_cnh)}"
                        oninput="atualizarMotoristaCampo(${veiculoIndex}, ${motoristaIndex}, 'categoria_cnh', this.value)">
                </div>
                <div class="col-md-3">
                    <label class="form-label small mb-1">Validade CNH</label>
                    <input type="date" class="form-control form-control-sm"
                        value="${escapeHtmlVeiculos(motorista.validade_cnh)}"
                        oninput="atualizarMotoristaCampo(${veiculoIndex}, ${motoristaIndex}, 'validade_cnh', this.value)">
                </div>
                <div class="col-md-3">
                    <label class="form-label small mb-1">Email</label>
                    <input type="email" class="form-control form-control-sm"
                        value="${escapeHtmlVeiculos(motorista.email)}"
                        oninput="atualizarMotoristaCampo(${veiculoIndex}, ${motoristaIndex}, 'email', this.value)">
                </div>
                <div class="col-12">
                    <label class="form-label small mb-1">Observações</label>
                    <textarea class="form-control form-control-sm" rows="2"
                        oninput="atualizarMotoristaCampo(${veiculoIndex}, ${motoristaIndex}, 'observacoes', this.value)">${escapeHtmlVeiculos(motorista.observacoes)}</textarea>
                </div>
            </div>
        </div>
    `).join('');
}

function renderVeiculos() {
    const container = document.getElementById('veiculos-list');
    if (!container) {
        return;
    }

    if (!veiculosData.length) {
        container.innerHTML = `
            <div class="veiculos-list-empty">
                <i class="bi bi-truck-front me-2"></i>
                Nenhum veículo cadastrado ainda. Clique em "Adicionar Veículo" para começar.
            </div>
        `;
        sincronizarVeiculosHidden();
        return;
    }

    const cards = veiculosData.map((veiculo, index) => `
        <div class="veiculo-card" data-index="${index}">
            <div class="veiculo-card-header">
                <div>
                    <strong>${escapeHtmlVeiculos(veiculo.apelido || veiculo.modelo || ('Veículo ' + (index + 1)))}</strong>
                    <div class="text-muted small">
                        Placa: ${escapeHtmlVeiculos(veiculo.placa || 'Não informado')}
                    </div>
                </div>
                <button type="button" class="btn btn-link btn-sm text-danger" onclick="removerVeiculo(${index})">
                    <i class="bi bi-trash me-1"></i> Remover
                </button>
            </div>
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Identificação / Apelido</label>
                    <input type="text" class="form-control"
                        value="${escapeHtmlVeiculos(veiculo.apelido)}"
                        oninput="atualizarVeiculoCampo(${index}, 'apelido', this.value)">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Placa</label>
                    <input type="text" class="form-control text-uppercase"
                        value="${escapeHtmlVeiculos(veiculo.placa)}"
                        oninput="atualizarVeiculoCampo(${index}, 'placa', this.value.toUpperCase())">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Tipo</label>
                    <input type="text" class="form-control"
                        value="${escapeHtmlVeiculos(veiculo.tipo)}"
                        oninput="atualizarVeiculoCampo(${index}, 'tipo', this.value)">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Marca</label>
                    <input type="text" class="form-control"
                        value="${escapeHtmlVeiculos(veiculo.marca)}"
                        oninput="atualizarVeiculoCampo(${index}, 'marca', this.value)">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Modelo</label>
                    <input type="text" class="form-control"
                        value="${escapeHtmlVeiculos(veiculo.modelo)}"
                        oninput="atualizarVeiculoCampo(${index}, 'modelo', this.value)">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Ano</label>
                    <input type="text" class="form-control"
                        value="${escapeHtmlVeiculos(veiculo.ano)}"
                        oninput="atualizarVeiculoCampo(${index}, 'ano', this.value)">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Cor</label>
                    <input type="text" class="form-control"
                        value="${escapeHtmlVeiculos(veiculo.cor)}"
                        oninput="atualizarVeiculoCampo(${index}, 'cor', this.value)">
                </div>
                <div class="col-md-3">
                    <label class="form-label">RENAVAM</label>
                    <input type="text" class="form-control"
                        value="${escapeHtmlVeiculos(veiculo.renavam)}"
                        oninput="atualizarVeiculoCampo(${index}, 'renavam', this.value)">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Chassi</label>
                    <input type="text" class="form-control text-uppercase"
                        value="${escapeHtmlVeiculos(veiculo.chassi)}"
                        oninput="atualizarVeiculoCampo(${index}, 'chassi', this.value.toUpperCase())">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Capacidade</label>
                    <input type="text" class="form-control"
                        value="${escapeHtmlVeiculos(veiculo.capacidade)}"
                        oninput="atualizarVeiculoCampo(${index}, 'capacidade', this.value)">
                </div>
                <div class="col-12">
                    <label class="form-label">Observações</label>
                    <textarea class="form-control" rows="2"
                        oninput="atualizarVeiculoCampo(${index}, 'observacoes', this.value)">${escapeHtmlVeiculos(veiculo.observacoes)}</textarea>
                </div>
            </div>
            <div class="motoristas-wrapper">
                <div class="d-flex justify-content-between align-items-center mb-2 flex-wrap gap-2">
                    <h6 class="mb-0 text-primary">
                        <i class="bi bi-people me-1"></i> Motoristas vinculados
                    </h6>
                    <button type="button" class="btn btn-sm btn-outline-primary"
                        onclick="adicionarMotorista(${index})">
                        <i class="bi bi-plus-circle me-1"></i> Adicionar Motorista
                    </button>
                </div>
                ${gerarMotoristasHtml(veiculo.motoristas, index)}
            </div>
        </div>
    `).join('');

    container.innerHTML = cards;
    sincronizarVeiculosHidden();
}

function adicionarVeiculo() {
    veiculosData.push(novoVeiculoTemplate());
    renderVeiculos();
}

function removerVeiculo(index) {
    veiculosData.splice(index, 1);
    renderVeiculos();
}

function atualizarVeiculoCampo(index, campo, valor) {
    if (!veiculosData[index]) {
        return;
    }
    veiculosData[index][campo] = valor;
    sincronizarVeiculosHidden();
}

function adicionarMotorista(veiculoIndex) {
    if (!veiculosData[veiculoIndex]) {
        return;
    }
    if (!Array.isArray(veiculosData[veiculoIndex].motoristas)) {
        veiculosData[veiculoIndex].motoristas = [];
    }
    veiculosData[veiculoIndex].motoristas.push(novoMotoristaTemplate());
    renderVeiculos();
}

function removerMotorista(veiculoIndex, motoristaIndex) {
    if (!veiculosData[veiculoIndex] || !Array.isArray(veiculosData[veiculoIndex].motoristas)) {
        return;
    }
    veiculosData[veiculoIndex].motoristas.splice(motoristaIndex, 1);
    renderVeiculos();
}

function atualizarMotoristaCampo(veiculoIndex, motoristaIndex, campo, valor) {
    if (!veiculosData[veiculoIndex] || !veiculosData[veiculoIndex].motoristas[motoristaIndex]) {
        return;
    }
    veiculosData[veiculoIndex].motoristas[motoristaIndex][campo] = valor;
    sincronizarVeiculosHidden();
}

veiculosData = normalizarVeiculosData(obterVeiculosIniciais());
sincronizarVeiculosHidden();

// ============================================
// ABA DE CONTATOS
// ============================================
let contatosHiddenInput;
let contatosData = [];

function novoContatoTemplate() {
    return {
        nome: '',
        telefone: '',
        cargo: ''
    };
}

function normalizarContatosData(raw) {
    if (!Array.isArray(raw)) {
        return [];
    }
    return raw.map((contato) => {
        const base = novoContatoTemplate();
        Object.keys(base).forEach((campo) => {
            const valor = contato[campo];
            base[campo] = valor !== null && valor !== undefined ? String(valor) : '';
        });
        return base;
    });
}

function obterContatosIniciais() {
    const input = document.getElementById('contatos-inicial-data');
    if (!input || !input.value) {
        return [];
    }
    try {
        return JSON.parse(input.value);
    } catch (e) {
        console.error('Erro ao parsear contatos iniciais:', e);
        return [];
    }
}

function sincronizarContatosHidden() {
    if (contatosHiddenInput) {
        contatosHiddenInput.value = JSON.stringify(contatosData);
    }
}

function escapeHtmlContatos(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

function formatarTelefoneContato(telefone) {
    if (!telefone) return '';
    const cleanValue = String(telefone).replace(/\D/g, '');
    if (!cleanValue) return '';
    return maskPhone(cleanValue);
}

function renderContatos() {
    const container = document.getElementById('contatos-list');
    if (!container) {
        return;
    }

    if (contatosData.length === 0) {
        container.innerHTML = `
            <div class="alert alert-info mb-0">
                <i class="bi bi-info-circle me-2"></i>
                Nenhum contato cadastrado ainda. Clique em "Adicionar Contato" para começar.
            </div>
        `;
        sincronizarContatosHidden();
        return;
    }

    const cards = contatosData.map((contato, index) => `
        <div class="card mb-3 contato-card" data-index="${index}">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start mb-3">
                    <h6 class="mb-0">
                        <i class="bi bi-person me-2 text-primary"></i>
                        ${escapeHtmlContatos(contato.nome || 'Contato ' + (index + 1))}
                    </h6>
                    <button type="button" class="btn btn-link btn-sm text-danger p-0" onclick="removerContato(${index})">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Nome <span class="text-danger">*</span></label>
                        <input type="text" class="form-control"
                            value="${escapeHtmlContatos(contato.nome)}"
                            oninput="atualizarContatoCampo(${index}, 'nome', this.value)"
                            required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Telefone</label>
                        <input type="text" class="form-control contato-telefone"
                            value="${escapeHtmlContatos(formatarTelefoneContato(contato.telefone))}"
                            oninput="this.value = maskPhone(this.value); atualizarContatoCampo(${index}, 'telefone', this.value)"
                            data-index="${index}">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Cargo</label>
                        <input type="text" class="form-control"
                            value="${escapeHtmlContatos(contato.cargo)}"
                            oninput="atualizarContatoCampo(${index}, 'cargo', this.value)"
                            placeholder="Ex: Gerente, Diretor, etc">
                    </div>
                </div>
            </div>
        </div>
    `).join('');

    container.innerHTML = cards;
    sincronizarContatosHidden();

    // Aplicar máscara de telefone nos campos recém-renderizados
    setTimeout(() => {
        container.querySelectorAll('.contato-telefone').forEach(input => {
            if (input.value) {
                const cleanValue = input.value.replace(/\D/g, '');
                if (cleanValue) {
                    input.value = maskPhone(cleanValue);
                }
            }
        });
    }, 0);
}

function adicionarContato() {
    contatosData.push(novoContatoTemplate());
    renderContatos();
}

function removerContato(index) {
    if (confirm('Tem certeza que deseja remover este contato?')) {
        contatosData.splice(index, 1);
        renderContatos();
    }
}

function atualizarContatoCampo(index, campo, valor) {
    if (!contatosData[index]) {
        return;
    }
    contatosData[index][campo] = valor;
    sincronizarContatosHidden();
}

// Inicializar contatos (será executado quando o DOM estiver pronto)

// Funções de máscara
function maskZipCode(value) {
    value = value.replace(/\D/g, '');
    value = value.replace(/^(\d{5})(\d)/, '$1-$2');
    return value.substring(0, 9);
}

// MÁSCARA DE CNPJ - FORMATO: 00.000.000/0000-00
function mascaraCNPJ(valor) {
    valor = valor.replace(/\D/g, ''); // Remove tudo que não é dígito

    if (valor.length <= 2) {
        return valor;
    } else if (valor.length <= 5) {
        return valor.replace(/(\d{2})(\d{0,3})/, '$1.$2');
    } else if (valor.length <= 8) {
        return valor.replace(/(\d{2})(\d{3})(\d{0,3})/, '$1.$2.$3');
    } else if (valor.length <= 12) {
        return valor.replace(/(\d{2})(\d{3})(\d{3})(\d{0,4})/, '$1.$2.$3/$4');
    } else {
        return valor.replace(/(\d{2})(\d{3})(\d{3})(\d{4})(\d{0,2})/, '$1.$2.$3/$4-$5');
    }
}

// MÁSCARA DE CPF - FORMATO: 000.000.000-00
function mascaraCPF(valor) {
    valor = valor.replace(/\D/g, ''); // Remove tudo que não é dígito

    if (valor.length <= 3) {
        return valor;
    } else if (valor.length <= 6) {
        return valor.replace(/(\d{3})(\d{0,3})/, '$1.$2');
    } else if (valor.length <= 9) {
        return valor.replace(/(\d{3})(\d{3})(\d{0,3})/, '$1.$2.$3');
    } else {
        return valor.replace(/(\d{3})(\d{3})(\d{3})(\d{0,2})/, '$1.$2.$3-$4');
    }
}

function maskPhone(value) {
    value = value.replace(/\D/g, '');

    if (value.length <= 10) {
        // Telefone fixo: (00) 0000-0000
        value = value.replace(/^(\d{2})(\d)/, '($1) $2');
        value = value.replace(/(\d{4})(\d)/, '$1-$2');
    } else {
        // Celular: (00) 00000-0000
        value = value.replace(/^(\d{2})(\d)/, '($1) $2');
        value = value.replace(/(\d{5})(\d)/, '$1-$2');
    }

    return value.substring(0, 15);
}

// Função para buscar CNPJ
function buscarCnpj(cnpj, callback) {
    cnpj = cnpj.replace(/\D/g, '');

    if (cnpj.length !== 14) return;

    Swal.fire({
        title: 'Buscando CNPJ...',
        text: 'Aguarde enquanto consultamos a Receita Federal',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    $.ajax({
        url: `https://brasilapi.com.br/api/cnpj/v1/${cnpj}`,
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            Swal.close();

            const dadosFormatados = {
                razao_social: data.razao_social || data.nome_fantasia,
                nome_fantasia: data.nome_fantasia || data.razao_social,
                email: data.email || '',
                telefone: data.ddd_telefone_1 || '',
                cep: data.cep || '',
                logradouro: data.logradouro || '',
                numero: data.numero || '',
                complemento: data.complemento || '',
                bairro: data.bairro || '',
                municipio: data.municipio || '',
                uf: data.uf || ''
            };

            callback(dadosFormatados);
        },
        error: function() {
            Swal.fire({
                icon: 'warning',
                title: 'CNPJ não encontrado',
                text: 'Não foi possível consultar este CNPJ. Preencha os dados manualmente.',
                confirmButtonColor: '#0066CC'
            });
        }
    });
}

// Espera o jQuery carregar
(function aguardarJQuery() {
    if (typeof jQuery === 'undefined') {
        setTimeout(aguardarJQuery, 50);
        return;
    }

    jQuery(document).ready(function($) {
        // Inicializar referências de contatos
        contatosHiddenInput = document.getElementById('contatos_data');

        // Inicializa os campos de acordo com o tipo selecionado
        setTimeout(function() {
            togglePersonType();
        }, 100);

        // Inicializar contatos
        contatosData = normalizarContatosData(obterContatosIniciais());
        sincronizarContatosHidden();
        renderContatos();

        renderVeiculos();

        $('#formPessoa').on('submit', function(e) {
            e.preventDefault();

            // Validação: pelo menos um tipo deve estar marcado
            var tipoCliente = $('#tipo_cliente').is(':checked');
            var tipoFornecedor = $('#tipo_fornecedor').is(':checked');
            var tipoTransportadora = $('#tipo_transportadora').is(':checked');

            if (!tipoCliente && !tipoFornecedor && !tipoTransportadora) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção!',
                    text: 'Selecione pelo menos um tipo (Cliente, Fornecedor ou Transportadora)',
                    confirmButtonColor: '#ffc107'
                });
                return false;
            }

            // Validar que vendedor principal e auxiliar não sejam o mesmo
            const vendedorId = $('#vendedor_id').val();
            const vendedorAuxiliarId = $('#vendedor_auxiliar_id').val();
            if (vendedorId && vendedorAuxiliarId && vendedorId === vendedorAuxiliarId) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção!',
                    text: 'O vendedor principal e o vendedor auxiliar não podem ser a mesma pessoa',
                    confirmButtonColor: '#ffc107'
                });
                return false;
            }

            // Consolidar dados dos campos PF/PJ
            var personType = $('#person_type').val();
            var name = '';
            var document = '';

            if (!personType) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção!',
                    text: 'Selecione se a pessoa é Física ou Jurídica.',
                    confirmButtonColor: '#ffc107'
                }).then(() => {
                    $('#person_type').focus();
                });
                return false;
            }

            if (personType === 'fisica') {
                name = $('#name_pf').val();
                document = $('#document_pf').val();
            } else if (personType === 'juridica') {
                name = $('#name_pj').val();
                document = $('#document_pj').val();
            }

            sincronizarVeiculosHidden();

            // Converter limite de crédito de formato brasileiro (vírgula) para decimal (ponto)
            const creditLimitInput = $('#credit_limit').val();
            let creditLimit = 0.00;
            if (creditLimitInput) {
                // Remove tudo exceto números, vírgula e ponto
                let cleanValue = creditLimitInput.replace(/[^\d.,]/g, '');
                // Remove pontos (separadores de milhar) e substitui vírgula por ponto (separador decimal)
                cleanValue = cleanValue.replace(/\./g, '').replace(',', '.');
                creditLimit = parseFloat(cleanValue) || 0.00;
            }

            const formData = new FormData(this);

            // Adicionar campos consolidados
            formData.set('name', name);
            formData.set('document', document);
            formData.set('credit_limit', creditLimit.toFixed(2));
            const url = appUrl('<?= $isEdit ? '/pessoas/editar' : '/pessoas/criar' ?>');

            Swal.fire({
                title: 'Salvando...',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: url,
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'json',
                beforeSend: function() {
                    return true;
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        }).then(() => {
                            window.location.href = appUrl('/pessoas');
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: response.message
                        });
                    }
                },
                error: function(xhr) {
                    const response = xhr.responseJSON;
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro ao salvar',
                        text: response?.message || 'Ocorreu um erro'
                    });
                }
            });
        });

        // Máscara CPF - Aplica em tempo real
        $(document).on('input', '#document_pf', function() {
            var valor = this.value;
            this.value = mascaraCPF(valor);

            // Quando completar 11 dígitos (14 com máscara), faz blur automático
            var somenteNumeros = valor.replace(/\D/g, '');
            if (somenteNumeros.length === 11) {
                $(this).blur();
            }
        });

        // Máscara CNPJ - Aplica em tempo real
        $(document).on('input', '#document_pj', function() {
            var valor = this.value;
            this.value = mascaraCNPJ(valor);

            // Quando completar 14 dígitos (18 com máscara), faz blur automático
            var somenteNumeros = valor.replace(/\D/g, '');
            if (somenteNumeros.length === 14) {
                $(this).blur();
            }
        });

        // Máscara CEP
        $('#zip_code').on('input', function() {
            this.value = maskZipCode(this.value);

            // Quando completar 8 dígitos (9 com máscara), faz blur automático
            var somenteNumeros = this.value.replace(/\D/g, '');
            if (somenteNumeros.length === 8) {
                $(this).blur();
            }
        });

        // Busca CEP automaticamente
        $('#zip_code').on('blur', function() {
            const cep = this.value.replace(/\D/g, '');

            if (cep.length === 8) {

                // Mostra loading
                $('#address, #bairro, #city, #state').prop('disabled', true);
                $('#address').val('Buscando...');

                // Busca via ViaCEP
                $.ajax({
                    url: `https://viacep.com.br/ws/${cep}/json/`,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        if (!data.erro) {
                            $('#address').val(data.logradouro || '');
                            $('#bairro').val(data.bairro || '');
                            $('#city').val(data.localidade || '');
                            $('#state').val(data.uf || '');
                            $('#complemento').val(data.complemento || '');

                            // Foca no número
                            $('#numero').focus();

                            // Toast de sucesso
                            if (typeof Swal !== 'undefined') {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'CEP encontrado!',
                                    text: 'Endereço preenchido automaticamente',
                                    toast: true,
                                    position: 'top-end',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            } else {
                                alert('CEP encontrado! Endereço preenchido.');
                            }
                        } else {
                            $('#address').val('');
                            if (typeof Swal !== 'undefined') {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'CEP não encontrado',
                                    text: 'Por favor, preencha o endereço manualmente',
                                    toast: true,
                                    position: 'top-end',
                                    showConfirmButton: false,
                                    timer: 3000
                                });
                            } else {
                                alert('CEP não encontrado!');
                            }
                        }
                    },
                    error: function(xhr, status, error) {
                        $('#address').val('');
                        if (typeof Swal !== 'undefined') {
                            Swal.fire({
                                icon: 'warning',
                                title: 'Erro na busca',
                                text: 'Não foi possível buscar o CEP. Preencha manualmente.',
                                toast: true,
                                position: 'top-end',
                                showConfirmButton: false,
                                timer: 3000
                            });
                        } else {
                            alert('Erro ao buscar CEP!');
                        }
                    },
                    complete: function() {
                        $('#address, #bairro, #city, #state').prop('disabled', false);
                    }
                });
            }
        });

        // Máscara Telefone
        $('#phone, #mobile, #whatsapp').on('input', function() {
            this.value = maskPhone(this.value);
        });

        // Máscaras para campos que EXISTEM
        $(document).on('input', '#cnh', function() {
            this.value = this.value.replace(/\D/g, '').substring(0, 11);
        });

        $(document).on('input', '#inscricao_municipal', function() {
            this.value = this.value.replace(/\D/g, '');
        });

        $(document).on('input', '#inscricao_suframa', function() {
            this.value = this.value.replace(/\D/g, '').substring(0, 9);
        });

        // Máscara de moeda para limite de crédito
        $(document).on('input', '#credit_limit', function() {
            let value = this.value.replace(/\D/g, ''); // Remove tudo que não é dígito

            if (value === '') {
                this.value = '';
                return;
            }

            // Converte para número e formata como moeda brasileira
            const numValue = parseFloat(value) / 100;
            this.value = numValue.toLocaleString('pt-BR', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });
        });

        // Filtrar subgrupos por grupo selecionado
        $('#grupo_id').on('change', function() {
            const grupoId = $(this).val();
            const $subgrupoSelect = $('#subgrupo_id');
            const $options = $subgrupoSelect.find('option');

            if (!grupoId) {
                // Se nenhum grupo selecionado, mostra todos
                $options.show();
                $subgrupoSelect.val('');
                return;
            }

            // Oculta todos exceto o primeiro (opção vazia)
            $options.each(function() {
                const $option = $(this);
                if ($option.val() === '') {
                    $option.show();
                } else if ($option.data('grupo') == grupoId) {
                    $option.show();
                } else {
                    $option.hide();
                }
            });

            // Limpa seleção se o subgrupo atual não pertence ao grupo
            const selectedSubgrupo = $subgrupoSelect.val();
            if (selectedSubgrupo) {
                const selectedOption = $subgrupoSelect.find('option:selected');
                if (selectedOption.data('grupo') != grupoId) {
                    $subgrupoSelect.val('');
                }
            }
        });

        // Trigger no carregamento se já houver grupo selecionado
        if ($('#grupo_id').val()) {
            $('#grupo_id').trigger('change');
        }

        // Gerenciar empresas vinculadas
        const empresasVinculadasInput = $('#empresas_vinculadas_input');

        // Função para atualizar o campo hidden com os IDs das empresas selecionadas
        function atualizarEmpresasVinculadas() {
            const empresasSelecionadas = [];
            $('.empresa-checkbox:checked').each(function() {
                empresasSelecionadas.push(parseInt($(this).val()));
            });
            empresasVinculadasInput.val(JSON.stringify(empresasSelecionadas));
        }

        // Checkbox "Marcar todas"
        $('#marcar_todas_empresas').on('change', function() {
            const isChecked = $(this).is(':checked');
            $('.empresa-checkbox').prop('checked', isChecked);
            atualizarEmpresasVinculadas();
        });

        // Checkboxes individuais de empresas
        $(document).on('change', '.empresa-checkbox', function() {
            atualizarEmpresasVinculadas();

            // Se algum checkbox for desmarcado, desmarcar "Marcar todas"
            const totalCheckboxes = $('.empresa-checkbox').length;
            const checkedCheckboxes = $('.empresa-checkbox:checked').length;

            if (checkedCheckboxes === totalCheckboxes) {
                $('#marcar_todas_empresas').prop('checked', true);
            } else {
                $('#marcar_todas_empresas').prop('checked', false);
            }
        });

        // Inicializar estado do checkbox "Marcar todas"
        const totalCheckboxes = $('.empresa-checkbox').length;
        const checkedCheckboxes = $('.empresa-checkbox:checked').length;
        if (totalCheckboxes > 0 && checkedCheckboxes === totalCheckboxes) {
            $('#marcar_todas_empresas').prop('checked', true);
        }
    });
})();
</script>

<?php
// Layout será incluído pelo arquivo que chama este form
?>