<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item active">Perfis de Acesso</li>
            </ol>
        </nav>
        <h2><i class="bi bi-shield-check me-2"></i> Perfis de Acesso</h2>
        <p class="text-muted">Gerencie os perfis de acesso dos usuários</p>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="bi bi-list-ul me-2"></i> Lista de Perfis de Acesso</h5>
                <div class="d-flex gap-2">
                    <a href="<?= url('/perfis-acesso/criar') ?>" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-2"></i> Novo Perfil
                    </a>
                </div>
            </div>
            <div class="card-body">
                <?php if (isset($tabela_nao_existe) && $tabela_nao_existe): ?>
                    <div class="alert alert-warning">
                        <h5><i class="bi bi-exclamation-triangle me-2"></i> Tabela não encontrada</h5>
                        <p>A tabela <code>perfis_acesso</code> ainda não foi criada no banco de dados.</p>
                        <p>Para criar a tabela, execute o seguinte comando:</p>
                        <pre class="bg-light p-3 rounded"><code>php database/criar_tabela_perfis_acesso.php</code></pre>
                        <p class="mb-0">Ou execute o SQL manualmente usando o arquivo <code>database/create_perfis_acesso_table.sql</code></p>
                    </div>
                <?php elseif (isset($erro) && $erro): ?>
                    <div class="alert alert-danger">
                        <h5><i class="bi bi-exclamation-triangle me-2"></i> Erro ao carregar perfis</h5>
                        <p><?= htmlspecialchars($erro) ?></p>
                        <p class="mb-0">Verifique os logs do servidor para mais detalhes.</p>
                    </div>
                <?php else: ?>
                <!-- Tabela -->
                <div class="table-responsive">
                    <table class="table table-hover" id="tabelaPerfis">
                        <thead class="table-light">
                            <tr>
                                <th>Nome</th>
                                <th>Descrição</th>
                                <th>Usuários</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($perfis)): ?>
                                <?php foreach ($perfis as $perfil): ?>
                                    <tr style="cursor: pointer;"
                                        data-perfil-id="<?= $perfil['id'] ?>"
                                        data-perfil-nome="<?= htmlspecialchars($perfil['nome'], ENT_QUOTES) ?>">
                                        <td>
                                            <strong><?= htmlspecialchars($perfil['nome']) ?></strong>
                                        </td>
                                        <td>
                                            <small class="text-muted">
                                                <?= htmlspecialchars($perfil['descricao'] ?? '-') ?>
                                            </small>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">
                                                <?= $perfil['total_usuarios'] ?? 0 ?> usuário(s)
                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?= $perfil['ativo'] ? 'success' : 'danger' ?>">
                                                <?= $perfil['ativo'] ? 'Ativo' : 'Inativo' ?>
                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="4" class="text-center text-muted py-4">
                                        <i class="bi bi-shield-check display-6 d-block mb-2"></i>
                                        Nenhum perfil de acesso encontrado
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php if (!empty($perfis) && isset($totalPages) && $totalPages > 1): ?>
                    <div class="d-flex justify-content-between align-items-center p-3 border-top">
                        <div class="text-muted">
                            Mostrando <?= (($page ?? 1) - 1) * ($perPage ?? 50) + 1 ?> a <?= min(($page ?? 1) * ($perPage ?? 50), $total ?? 0) ?> de <?= $total ?? 0 ?> perfis
                        </div>
                        <nav>
                            <ul class="pagination pagination-sm mb-0">
                                <li class="page-item <?= ($page ?? 1) <= 1 ? 'disabled' : '' ?>">
                                    <a class="page-link" href="?page=<?= max(1, ($page ?? 1) - 1) ?>" aria-label="Anterior">
                                        <span aria-hidden="true">&laquo;</span>
                                    </a>
                                </li>
                                <?php for ($i = max(1, ($page ?? 1) - 2); $i <= min($totalPages, ($page ?? 1) + 2); $i++): ?>
                                    <li class="page-item <?= ($i === ($page ?? 1)) ? 'active' : '' ?>">
                                        <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                                    </li>
                                <?php endfor; ?>
                                <li class="page-item <?= ($page ?? 1) >= $totalPages ? 'disabled' : '' ?>">
                                    <a class="page-link" href="?page=<?= min($totalPages, ($page ?? 1) + 1) ?>" aria-label="Próximo">
                                        <span aria-hidden="true">&raquo;</span>
                                    </a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                <?php elseif (!empty($perfis) && isset($total) && $total > 0): ?>
                    <div class="text-center p-3 border-top">
                        <small class="text-muted">Mostrando todos os <?= $total ?> perfil(is)</small>
                    </div>
                <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Ações -->
<div class="modal fade" id="modalAcoes" tabindex="-1" aria-labelledby="modalAcoesLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalAcoesLabel">
                    <i class="bi bi-shield-check me-2"></i>Ações do Perfil
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
            </div>
            <div class="modal-body">
                <p class="mb-3">
                    <strong>Perfil:</strong> <span id="modalPerfilNome"></span>
                </p>
                <div class="d-grid gap-2">
                    <a href="#" id="btnEditarPerfil" class="btn btn-primary">
                        <i class="bi bi-pencil me-2"></i>Editar Perfil
                    </a>
                    <button type="button" id="btnExcluirPerfil" class="btn btn-danger">
                        <i class="bi bi-trash me-2"></i>Excluir Perfil
                    </button>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<style>
    #tabelaPerfis tbody tr:hover {
        background-color: #f8f9fa;
    }
</style>

<script>
let perfilIdAtual = null;
let perfilNomeAtual = null;

// Usar event delegation para cliques nas linhas da tabela
document.addEventListener('DOMContentLoaded', function() {
    const tabela = document.getElementById('tabelaPerfis');
    if (tabela) {
        tabela.addEventListener('click', function(e) {
            const tr = e.target.closest('tr[data-perfil-id]');
            if (tr && !e.target.closest('a') && !e.target.closest('button')) {
                const id = tr.getAttribute('data-perfil-id');
                const nome = tr.getAttribute('data-perfil-nome');
                if (id && nome) {
                    abrirModalAcoes(parseInt(id), nome);
                }
            }
        });
    }

    // Evento de clique no botão excluir do modal
    const btnExcluir = document.getElementById('btnExcluirPerfil');
    if (btnExcluir) {
        btnExcluir.addEventListener('click', function() {
            if (perfilIdAtual && perfilNomeAtual) {
                deletarPerfil(perfilIdAtual, perfilNomeAtual);
            }
        });
    }
});

function abrirModalAcoes(id, nome) {
    perfilIdAtual = id;
    perfilNomeAtual = nome;

    // Atualizar o nome no modal
    document.getElementById('modalPerfilNome').textContent = nome;

    // Atualizar o link de editar
    document.getElementById('btnEditarPerfil').href = appUrl('/perfis-acesso/editar?id=' + id);

    // Mostrar o modal
    const modal = new bootstrap.Modal(document.getElementById('modalAcoes'));
    modal.show();
}

function deletarPerfil(id, nome) {
    // Fechar o modal de ações primeiro
    const modal = bootstrap.Modal.getInstance(document.getElementById('modalAcoes'));
    if (modal) {
        modal.hide();
    }

    Swal.fire({
        title: 'Confirmar Exclusão',
        html: `Deseja realmente excluir o perfil <strong>${nome}</strong>?<br><small class="text-danger">Esta ação não pode ser desfeita!</small>`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sim, excluir!',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: appUrl('/perfis-acesso/deletar'),
                type: 'POST',
                data: { id: id },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Excluído!',
                            text: response.message,
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: response.message
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'Erro ao excluir perfil de acesso'
                    });
                }
            });
        }
    });
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'perfis-acesso';
include ROOT_PATH . '/views/layouts/app.php';
?>

