<?php
ob_start();

// Dados do perfil
$perfilId = $perfil['id'] ?? 0;
$permissoesExistentes = $permissoes ?? [];
$modulosDisponiveis = $modulos ?? [];
?>
<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/perfis-acesso') ?>">Perfis de Acesso</a></li>
                <li class="breadcrumb-item active">Editar Perfil</li>
            </ol>
        </nav>
        <h2><i class="bi bi-shield-check me-2"></i> Editar Perfil de Acesso</h2>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <!-- Tabs -->
        <ul class="nav nav-tabs mb-3" id="perfilTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados" type="button" role="tab" aria-controls="dados" aria-selected="true">
                    <i class="bi bi-pencil me-2"></i> Dados do Perfil
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="permissoes-tab" data-bs-toggle="tab" data-bs-target="#permissoes" type="button" role="tab" aria-controls="permissoes" aria-selected="false">
                    <i class="bi bi-shield-lock me-2"></i> Permissões
                </button>
            </li>
        </ul>

        <!-- Tab Content -->
        <div class="tab-content" id="perfilTabsContent">
            <!-- Tab Dados -->
            <div class="tab-pane fade show active" id="dados" role="tabpanel" aria-labelledby="dados-tab">
                <div class="card">
                    <div class="card-body">
                        <form id="formPerfil" method="POST" action="<?= url('/perfis-acesso/editar') ?>">
                            <input type="hidden" name="id" value="<?= $perfil['id'] ?>">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label for="nome" class="form-label">Nome do Perfil *</label>
                                    <input type="text" class="form-control" id="nome" name="nome" required
                                           value="<?= htmlspecialchars($perfil['nome']) ?>"
                                           placeholder="Ex: Vendedor, Gerente, Operador">
                                    <small class="text-muted">Nome que identifica o perfil de acesso</small>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label for="descricao" class="form-label">Descrição</label>
                                    <textarea class="form-control" id="descricao" name="descricao" rows="3"
                                              placeholder="Descreva o propósito deste perfil de acesso"><?= htmlspecialchars($perfil['descricao'] ?? '') ?></textarea>
                                    <small class="text-muted">Opcional: Descrição sobre o perfil</small>
                                </div>
                        <div class="col-md-12 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" role="switch" id="ativo" name="ativo" value="1"
                                       <?= $perfil['ativo'] ? 'checked' : '' ?>>
                                <label class="form-check-label" for="ativo">
                                    Perfil Ativo
                                </label>
                                <small class="text-muted d-block">Perfis inativos não aparecem em seleções</small>
                            </div>
                        </div>
                            </div>
                            <div class="d-flex justify-content-end gap-2">
                                <a href="<?= url('/perfis-acesso') ?>" class="btn btn-secondary">
                                    <i class="bi bi-x-circle me-2"></i> Cancelar
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-check-circle me-2"></i> Atualizar Perfil
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Tab Permissões -->
            <div class="tab-pane fade" id="permissoes" role="tabpanel" aria-labelledby="permissoes-tab">
                <div class="card">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="bi bi-shield-lock me-2"></i> Gerenciar Permissões de Acesso</h5>
                    </div>
                    <div class="card-body">
                        <form id="formPermissoes" method="POST" action="<?= url('/perfis-acesso/salvar-permissoes') ?>">
                            <input type="hidden" name="perfil_id" value="<?= $perfilId ?>">

                            <div class="alert alert-info">
                                <i class="bi bi-info-circle me-2"></i>
                                <strong>Como funciona:</strong> Marque as ações permitidas para cada módulo. Usuários com este perfil terão apenas as permissões marcadas.
                            </div>

                            <div class="table-responsive">
                                <table class="table table-bordered table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th style="width: 30%;">Módulo</th>
                                            <th class="text-center" style="width: 17.5%;">
                                                <div class="d-flex flex-column align-items-center">
                                                    <div>
                                                        <i class="bi bi-eye me-1"></i> Visualizar
                                                    </div>
                                                    <button type="button" class="btn btn-link btn-sm p-0 text-decoration-none" onclick="selecionarTodasPorTipo('can_view')" title="Selecionar todas">
                                                        <small>Selecionar Todas</small>
                                                    </button>
                                                </div>
                                            </th>
                                            <th class="text-center" style="width: 17.5%;">
                                                <div class="d-flex flex-column align-items-center">
                                                    <div>
                                                        <i class="bi bi-plus-circle me-1"></i> Criar
                                                    </div>
                                                    <button type="button" class="btn btn-link btn-sm p-0 text-decoration-none" onclick="selecionarTodasPorTipo('can_create')" title="Selecionar todas">
                                                        <small>Selecionar Todas</small>
                                                    </button>
                                                </div>
                                            </th>
                                            <th class="text-center" style="width: 17.5%;">
                                                <div class="d-flex flex-column align-items-center">
                                                    <div>
                                                        <i class="bi bi-pencil me-1"></i> Editar
                                                    </div>
                                                    <button type="button" class="btn btn-link btn-sm p-0 text-decoration-none" onclick="selecionarTodasPorTipo('can_edit')" title="Selecionar todas">
                                                        <small>Selecionar Todas</small>
                                                    </button>
                                                </div>
                                            </th>
                                            <th class="text-center" style="width: 17.5%;">
                                                <div class="d-flex flex-column align-items-center">
                                                    <div>
                                                        <i class="bi bi-trash me-1"></i> Excluir
                                                    </div>
                                                    <button type="button" class="btn btn-link btn-sm p-0 text-decoration-none" onclick="selecionarTodasPorTipo('can_delete')" title="Selecionar todas">
                                                        <small>Selecionar Todas</small>
                                                    </button>
                                                </div>
                                            </th>
                                            <th class="text-center" style="width: 10%;">
                                                <i class="bi bi-gear me-1"></i> Ações
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($modulosDisponiveis as $moduloKey => $moduloNome): ?>
                                            <?php
                                            $perm = $permissoesExistentes[$moduloKey] ?? [
                                                'id' => null,
                                                'can_view' => false,
                                                'can_create' => false,
                                                'can_edit' => false,
                                                'can_delete' => false
                                            ];
                                            $permissaoId = $perm['id'] ?? null;
                                            ?>
                                            <tr>
                                                <td>
                                                    <strong><?= htmlspecialchars($moduloNome) ?></strong>
                                                    <br>
                                                    <small class="text-muted"><?= htmlspecialchars($moduloKey) ?></small>
                                                </td>
                                                <td class="text-center">
                                                    <div class="form-check form-switch d-flex justify-content-center">
                                                        <input class="form-check-input" type="checkbox" role="switch"
                                                               name="permissoes[<?= htmlspecialchars($moduloKey) ?>][can_view]"
                                                               value="1"
                                                               id="view_<?= htmlspecialchars($moduloKey) ?>"
                                                               <?= $perm['can_view'] ? 'checked' : '' ?>>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <div class="form-check form-switch d-flex justify-content-center">
                                                        <input class="form-check-input" type="checkbox" role="switch"
                                                               name="permissoes[<?= htmlspecialchars($moduloKey) ?>][can_create]"
                                                               value="1"
                                                               id="create_<?= htmlspecialchars($moduloKey) ?>"
                                                               <?= $perm['can_create'] ? 'checked' : '' ?>>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <div class="form-check form-switch d-flex justify-content-center">
                                                        <input class="form-check-input" type="checkbox" role="switch"
                                                               name="permissoes[<?= htmlspecialchars($moduloKey) ?>][can_edit]"
                                                               value="1"
                                                               id="edit_<?= htmlspecialchars($moduloKey) ?>"
                                                               <?= $perm['can_edit'] ? 'checked' : '' ?>>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <div class="form-check form-switch d-flex justify-content-center">
                                                        <input class="form-check-input" type="checkbox" role="switch"
                                                               name="permissoes[<?= htmlspecialchars($moduloKey) ?>][can_delete]"
                                                               value="1"
                                                               id="delete_<?= htmlspecialchars($moduloKey) ?>"
                                                               <?= $perm['can_delete'] ? 'checked' : '' ?>>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <?php if ($permissaoId): ?>
                                                        <button type="button" class="btn btn-sm btn-outline-primary"
                                                                onclick="abrirModalMovimentos(<?= $permissaoId ?>, '<?= htmlspecialchars($moduloKey) ?>', '<?= htmlspecialchars($moduloNome) ?>')"
                                                                title="Configurar permissões de movimento">
                                                            <i class="bi bi-gear"></i>
                                                        </button>
                                                    <?php else: ?>
                                                        <span class="text-muted" title="Salve as permissões básicas primeiro">
                                                            <i class="bi bi-gear text-muted"></i>
                                                        </span>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex justify-content-between align-items-center mt-3">
                                <div>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="selecionarTodasPermissoes()">
                                        <i class="bi bi-check-all me-1"></i> Selecionar Todas
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="limparTodasPermissoes()">
                                        <i class="bi bi-x-circle me-1"></i> Limpar Todas
                                    </button>
                                </div>
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-save me-2"></i> Salvar Permissões
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Formulário de dados do perfil
    $('#formPerfil').on('submit', function(e) {
        e.preventDefault();

        const $form = $(this);
        const $btn = $form.find('button[type="submit"]');
        const btnText = $btn.html();

        $btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>Atualizando...');

        $.ajax({
            url: $form.attr('action'),
            type: 'POST',
            data: $form.serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message,
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        if (response.data && response.data.redirect) {
                            window.location.href = appUrl(response.data.redirect);
                        } else {
                            // Recarregar a página para manter na mesma aba
                            window.location.reload();
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: response.message
                    });
                    $btn.prop('disabled', false).html(btnText);
                }
            },
            error: function(xhr) {
                let message = 'Erro ao atualizar perfil de acesso';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: message
                });
                $btn.prop('disabled', false).html(btnText);
            }
        });
    });

    // Formulário de permissões
    $('#formPermissoes').on('submit', function(e) {
        e.preventDefault();

        const $form = $(this);
        const $btn = $form.find('button[type="submit"]');
        const btnText = $btn.html();

        $btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>Salvando...');

        $.ajax({
            url: $form.attr('action'),
            type: 'POST',
            data: $form.serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message,
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        if (response.data && response.data.redirect) {
                            window.location.href = appUrl(response.data.redirect);
                        } else {
                            window.location.href = appUrl('/perfis-acesso');
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: response.message
                    });
                }
                $btn.prop('disabled', false).html(btnText);
            },
            error: function(xhr) {
                let message = 'Erro ao salvar permissões';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: message
                });
                $btn.prop('disabled', false).html(btnText);
            }
        });
    });
});

// Funções auxiliares
function selecionarTodasPermissoes() {
    $('#formPermissoes input[type="checkbox"]').prop('checked', true);
}

function limparTodasPermissoes() {
    $('#formPermissoes input[type="checkbox"]').prop('checked', false);
}

function selecionarTodasPorTipo(tipo) {
    // tipo pode ser: can_view, can_create, can_edit, can_delete
    // Seleciona todos os checkboxes que contenham [tipo] no nome
    $(`#formPermissoes input[name*="[${tipo}]"]`).prop('checked', true);
}

// Modal de Movimentos
let modalMovimentos = null;

function abrirModalMovimentos(permissaoId, modulo, moduloNome) {
    // Criar modal dinamicamente se não existir
    if (!$('#modalMovimentos').length) {
        $('body').append(`
            <div class="modal fade" id="modalMovimentos" tabindex="-1" aria-labelledby="modalMovimentosLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalMovimentosLabel">
                                <i class="bi bi-gear me-2"></i> Permissões de Movimento
                            </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" id="modal_permissao_id">
                            <input type="hidden" id="modal_modulo">
                            <div class="mb-3">
                                <strong>Módulo:</strong> <span id="modal_modulo_nome"></span>
                            </div>
                            <div id="movimentosContainer">
                                <!-- Movimentos serão carregados aqui -->
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                <i class="bi bi-x-circle me-2"></i> Fechar
                            </button>
                            <button type="button" class="btn btn-primary" onclick="salvarMovimentos()">
                                <i class="bi bi-save me-2"></i> Salvar Movimentos
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        `);
    }

    // Configurar modal
    $('#modal_permissao_id').val(permissaoId);
    $('#modal_modulo').val(modulo);
    $('#modal_modulo_nome').text(moduloNome);

    // Carregar movimentos
    carregarMovimentos(permissaoId);

    // Mostrar modal
    modalMovimentos = new bootstrap.Modal(document.getElementById('modalMovimentos'));
    modalMovimentos.show();
}

function carregarMovimentos(permissaoId) {
    $.ajax({
        url: appUrl('/perfis-acesso/buscar-movimentos'),
        type: 'POST',
        data: { permissao_id: permissaoId },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                const movimentos = response.data.movimentos || [];
                const movimentosDisponiveis = response.data.movimentos_disponiveis || {};
                const modulo = response.data.modulo || '';

                // Normalizar nome do módulo
                let moduloNormalizado = modulo;
                if (modulo && modulo.indexOf('modulo_') === 0) {
                    moduloNormalizado = modulo.replace('modulo_', '');
                }

                // Debug (remover em produção)
                console.log('Módulo:', modulo);
                console.log('Módulo normalizado:', moduloNormalizado);
                console.log('Movimentos disponíveis:', movimentosDisponiveis);

                let html = '';

                // Processar estrutura hierárquica
                if (moduloNormalizado === 'pessoas' && movimentosDisponiveis && Object.keys(movimentosDisponiveis).length > 0) {
                    html = '<div class="accordion" id="accordionMovimentos">';

                    // Clientes
                    if (movimentosDisponiveis.clientes) {
                        html += `
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingClientes">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseClientes" aria-expanded="true" aria-controls="collapseClientes">
                                        <i class="bi bi-people me-2"></i> Clientes
                                    </button>
                                </h2>
                                <div id="collapseClientes" class="accordion-collapse collapse show" aria-labelledby="headingClientes" data-bs-parent="#accordionMovimentos">
                                    <div class="accordion-body">
                        `;

                        Object.keys(movimentosDisponiveis.clientes).forEach(function(key) {
                            const nome = movimentosDisponiveis.clientes[key];
                            const movimentoKey = `clientes.${key}`;
                            const isChecked = movimentos.some(m => m.movimento === movimentoKey && m.permitido);

                            html += `
                                <div class="form-check form-switch mb-3">
                                    <input class="form-check-input" type="checkbox" role="switch"
                                           id="mov_${movimentoKey.replace(/\./g, '_')}"
                                           value="${movimentoKey}"
                                           ${isChecked ? 'checked' : ''}>
                                    <label class="form-check-label" for="mov_${movimentoKey.replace(/\./g, '_')}">
                                        ${nome}
                                    </label>
                                </div>
                            `;
                        });

                        html += `
                                    </div>
                                </div>
                            </div>
                        `;
                    }

                    // Fornecedor
                    if (movimentosDisponiveis.fornecedor !== undefined) {
                        const movimentoKey = 'fornecedor';
                        const isChecked = movimentos.some(m => m.movimento === movimentoKey && m.permitido);

                        html += `
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingFornecedor">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFornecedor" aria-expanded="false" aria-controls="collapseFornecedor">
                                        <i class="bi bi-truck me-2"></i> Fornecedor
                                    </button>
                                </h2>
                                <div id="collapseFornecedor" class="accordion-collapse collapse" aria-labelledby="headingFornecedor" data-bs-parent="#accordionMovimentos">
                                    <div class="accordion-body">
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" role="switch"
                                                   id="mov_${movimentoKey}"
                                                   value="${movimentoKey}"
                                                   ${isChecked ? 'checked' : ''}>
                                            <label class="form-check-label" for="mov_${movimentoKey}">
                                                Habilitado
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        `;
                    }

                    // Transportadora
                    if (movimentosDisponiveis.transportadora !== undefined) {
                        const movimentoKey = 'transportadora';
                        const isChecked = movimentos.some(m => m.movimento === movimentoKey && m.permitido);

                        html += `
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingTransportadora">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTransportadora" aria-expanded="false" aria-controls="collapseTransportadora">
                                        <i class="bi bi-truck-flatbed me-2"></i> Transportadora
                                    </button>
                                </h2>
                                <div id="collapseTransportadora" class="accordion-collapse collapse" aria-labelledby="headingTransportadora" data-bs-parent="#accordionMovimentos">
                                    <div class="accordion-body">
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" role="switch"
                                                   id="mov_${movimentoKey}"
                                                   value="${movimentoKey}"
                                                   ${isChecked ? 'checked' : ''}>
                                            <label class="form-check-label" for="mov_${movimentoKey}">
                                                Habilitado
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        `;
                    }

                    html += '</div>';
                } else {
                    html = '<div class="alert alert-info">Nenhuma configuração disponível para este módulo.</div>';
                }

                $('#movimentosContainer').html(html);
            } else {
                $('#movimentosContainer').html('<div class="alert alert-warning">' + (response.message || 'Erro ao carregar movimentos') + '</div>');
            }
        },
        error: function() {
            $('#movimentosContainer').html('<div class="alert alert-danger">Erro ao carregar movimentos</div>');
        }
    });
}

function salvarMovimentos() {
    const permissaoId = $('#modal_permissao_id').val();
    const modulo = $('#modal_modulo').val();
    const movimentos = [];

    $('#movimentosContainer input[type="checkbox"]').each(function() {
        if ($(this).is(':checked')) {
            movimentos.push($(this).val());
        }
    });

    $.ajax({
        url: appUrl('/perfis-acesso/salvar-movimentos'),
        type: 'POST',
        data: {
            permissao_id: permissaoId,
            modulo: modulo,
            movimentos: movimentos
        },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Sucesso!',
                    text: response.message,
                    timer: 1500,
                    showConfirmButton: false
                });
                if (modalMovimentos) {
                    modalMovimentos.hide();
                }
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: response.message
                });
            }
        },
        error: function(xhr) {
            let message = 'Erro ao salvar movimentos';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                message = xhr.responseJSON.message;
            }
            Swal.fire({
                icon: 'error',
                title: 'Erro!',
                text: message
            });
        }
    });
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'perfis-acesso';
include ROOT_PATH . '/views/layouts/app.php';
?>
