<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/perfis-acesso') ?>">Perfis de Acesso</a></li>
                <li class="breadcrumb-item active">Novo Perfil</li>
            </ol>
        </nav>
        <h2><i class="bi bi-shield-check me-2"></i> Novo Perfil de Acesso</h2>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-plus-circle me-2"></i> Dados do Perfil</h5>
            </div>
            <div class="card-body">
                <form id="formPerfil" method="POST" action="<?= url('/perfis-acesso/criar') ?>">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="nome" class="form-label">Nome do Perfil *</label>
                            <input type="text" class="form-control" id="nome" name="nome" required
                                   placeholder="Ex: Vendedor, Gerente, Operador">
                            <small class="text-muted">Nome que identifica o perfil de acesso</small>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="descricao" class="form-label">Descrição</label>
                            <textarea class="form-control" id="descricao" name="descricao" rows="3"
                                      placeholder="Descreva o propósito deste perfil de acesso"></textarea>
                            <small class="text-muted">Opcional: Descrição sobre o perfil</small>
                        </div>
                        <div class="col-md-12 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" role="switch" id="ativo" name="ativo" value="1" checked>
                                <label class="form-check-label" for="ativo">
                                    Perfil Ativo
                                </label>
                                <small class="text-muted d-block">Perfis inativos não aparecem em seleções</small>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-end gap-2">
                        <a href="<?= url('/perfis-acesso') ?>" class="btn btn-secondary">
                            <i class="bi bi-x-circle me-2"></i> Cancelar
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-circle me-2"></i> Salvar Perfil
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#formPerfil').on('submit', function(e) {
        e.preventDefault();

        const $form = $(this);
        const $btn = $form.find('button[type="submit"]');
        const btnText = $btn.html();

        $btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>Salvando...');

        $.ajax({
            url: $form.attr('action'),
            type: 'POST',
            data: $form.serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message,
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        if (response.data && response.data.redirect) {
                            window.location.href = appUrl(response.data.redirect);
                        } else {
                            window.location.href = appUrl('/perfis-acesso');
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: response.message
                    });
                    $btn.prop('disabled', false).html(btnText);
                }
            },
            error: function(xhr) {
                let message = 'Erro ao salvar perfil de acesso';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: message
                });
                $btn.prop('disabled', false).html(btnText);
            }
        });
    });
});
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'perfis-acesso';
include ROOT_PATH . '/views/layouts/app.php';
?>

