<?php
ob_start();
$isEdit = isset($pedido);
$pageTitle = $pageTitle ?? ($isEdit ? 'Editar Pedido' : 'Novo Pedido');
$activeMenu = $activeMenu ?? 'pedidos';
$pedidoId = $pedido['id'] ?? null;
$numeroPedido = $isEdit ? ($pedido['sale_number'] ?? $proximoNumero ?? '') : ($proximoNumero ?? '');
$dataPedido = $isEdit ? ($pedido['sale_date'] ?? date('Y-m-d')) : date('Y-m-d');
$dataPedido = substr($dataPedido, 0, 10);
$linhaTemporal = $isEdit ? ($pedido['linha_temporal'] ?? '') : 'entrada';
$isTriagemLinhaTemporal = $linhaTemporal === 'triagem';
$botaoAcaoLabel = $isEdit
    ? ($isTriagemLinhaTemporal ? 'Gerar Pedido' : 'Atualizar Pedido')
    : 'Ir para Triagem';
$quantidadeInformadaBase = $isEdit ? ($pedido['quantidade_informada'] ?? '') : '';
$quantidadeInformadaFieldValue = $isTriagemLinhaTemporal ? '' : $quantidadeInformadaBase;
$quantidadeContada = $isEdit ? ($pedido['quantidade_contada'] ?? '') : '';
$aptoEnvaze = $isEdit ? ($pedido['apto_envaze'] ?? '') : '';
$quebra = $isEdit ? ($pedido['quebra'] ?? '') : '';
$diferencaAtual = $isEdit ? ($pedido['diferenca'] ?? '') : '';
$triagemProdutos = $triagemProdutos ?? [
    'garrafao' => null,
    'itensAutomaticos' => [
        'envaze' => 1,
        'garrafao' => 2,
        'lacre' => 3,
        'selo' => 4,
        'tampa' => 5
    ]
];
$notesIniciais = $isEdit ? ($pedido['notes_limpos'] ?? '') : '';
$clienteSelecionado = $isEdit ? [
    'id' => $pedido['customer_id'] ?? null,
    'name' => $pedido['customer_name'] ?? '',
    'trade_name' => $pedido['customer_name'] ?? '',
    'document' => $pedido['customer_document'] ?? '',
    'email' => $pedido['cliente_email'] ?? '',
    'phone' => $pedido['cliente_phone'] ?? '',
    'mobile' => $pedido['cliente_mobile'] ?? ''
] : null;
$formAction = $isEdit ? url('/pedidos/editar') : url('/pedidos/criar');
?>

<div class="row mb-3">
    <div class="col-12">
        <nav aria-label="breadcrumb" class="mb-3">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/pedidos') ?>">Pedidos</a></li>
                <li class="breadcrumb-item active">
                    <?= $isEdit ? 'Editar Pedido' : 'Novo Pedido - Entrada' ?>
                </li>
            </ol>
        </nav>
        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
            <div>
                <h2>
                    <i class="bi bi-clipboard-plus me-2"></i>
                    <?= $isEdit ? 'Editar Pedido' : 'Novo Pedido - Entrada' ?>
                </h2>
                <p class="text-muted mb-0">
                    <?= $isEdit ? 'Atualize as informações do pedido selecionado' : 'Preencha os dados básicos do pedido' ?>
                </p>
            </div>
            <a href="<?= url('/pedidos') ?>" class="btn btn-secondary">
                <i class="bi bi-arrow-left me-2"></i> Voltar
            </a>
        </div>
    </div>
</div>

<!-- Formulário de Pedido -->
<div class="card shadow-sm">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0"><i class="bi bi-inbox me-2"></i> Dados do Pedido</h5>
    </div>
    <div class="card-body">
        <form id="formPedido" method="POST" action="<?= $formAction ?>" novalidate>
            <input type="hidden" name="sale_number" value="<?= htmlspecialchars($numeroPedido) ?>">
            <?php if ($isEdit && $pedidoId): ?>
            <input type="hidden" name="pedido_id" value="<?= htmlspecialchars($pedidoId) ?>">
            <?php endif; ?>
            <?php if ($isTriagemLinhaTemporal): ?>
            <input type="hidden" name="triagem_workflow" id="triagem_workflow" value="">
            <?php endif; ?>

            <!-- Número do Pedido -->
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label">Número do Pedido</label>
                    <input type="text" class="form-control" value="<?= htmlspecialchars($numeroPedido) ?>" readonly>
                    <small class="text-muted">
                        <?= $isEdit ? 'Número original do pedido' : 'Gerado automaticamente' ?>
                    </small>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Data</label>
                    <input type="date" class="form-control" value="<?= htmlspecialchars($dataPedido) ?>" readonly>
                </div>
            </div>

            <!-- Cliente (Autocomplete) -->
            <div class="row mb-3">
                <div class="col-12">
                    <label for="customer_search" class="form-label <?= !$isEdit ? 'required' : '' ?>">
                        Cliente
                        <?php if (!$isEdit): ?>
                        <small class="text-muted d-block">Digite para buscar por nome, fantasia ou documento</small>
                        <?php else: ?>
                        <small class="text-muted d-block">Cliente não pode ser alterado após a criação do pedido</small>
                        <?php endif; ?>
                    </label>
                    <div class="position-relative">
                        <input type="text" class="form-control" id="customer_search"
                            placeholder="Digite para buscar o cliente..." autocomplete="off"
                            value="<?= $isEdit ? htmlspecialchars($clienteSelecionado['name'] ?? '') : '' ?>"
                            <?= $isEdit ? 'readonly style="background-color: #e9ecef; cursor: not-allowed;"' : '' ?>>
                        <div id="customer_dropdown" class="autocomplete-dropdown" style="display: none;"></div>
                    </div>
                    <input type="hidden" id="customer_id" name="customer_id"
                        value="<?= htmlspecialchars($clienteSelecionado['id'] ?? '') ?>">
                    <input type="hidden" id="customer_type" name="customer_type" value="pessoa">
                    <input type="hidden" id="customer_name" name="customer_name"
                        value="<?= htmlspecialchars($clienteSelecionado['name'] ?? '') ?>">
                    <input type="hidden" id="customer_document" name="customer_document"
                        value="<?= htmlspecialchars($clienteSelecionado['document'] ?? '') ?>">
                    <input type="hidden" id="motorista" name="motorista" value="">
                    <input type="hidden" id="veiculo" name="veiculo" value="">
                </div>
            </div>

            <!-- Informações do Cliente -->
            <div id="customer_info" class="row mb-3" style="<?= $isEdit ? '' : 'display: none;' ?>">
                <div class="col-12">
                    <div class="alert alert-info mb-0 d-flex justify-content-between align-items-start">
                        <div id="customer_info_content"></div>
                        <?php if (!$isEdit): ?>
                        <button type="button" class="btn btn-sm btn-outline-danger ms-3" onclick="limparCliente()">
                            <i class="bi bi-x"></i>
                        </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Quantidade / Observações -->
            <?php if ($isTriagemLinhaTemporal): ?>
            <div class="row mb-3 g-3">
                <div class="col-md-3">
                    <label for="quantity" class="form-label">Quantidade Informada</label>
                    <input type="number" class="form-control" id="quantity" name="quantity" step="0.01" min="0.01"
                        placeholder="Ex: 100.00" readonly value=""
                        data-quantidade-real="<?= htmlspecialchars($quantidadeInformadaFieldValue) ?>">
                    <small class="text-muted">Quantidade registrada na entrada</small>
                    <div class="invalid-feedback">Informe a quantidade</div>
                </div>
                <div class="col-md-3">
                    <label for="quantidade_contada" class="form-label required">Quantidade Contada</label>
                    <input type="number" class="form-control" id="quantidade_contada" name="quantidade_contada"
                        step="0.01" min="0.01" placeholder="Ex: 100.00" required
                        value="<?= htmlspecialchars($quantidadeContada) ?>">
                    <small class="text-muted">Informe a quantidade conferida</small>
                    <div class="invalid-feedback">Informe a quantidade contada</div>
                </div>
                <div class="col-md-3">
                    <label for="diferenca" class="form-label">Diferença</label>
                    <input type="text" class="form-control" id="diferenca" name="diferenca" readonly
                        value="<?= htmlspecialchars($diferencaAtual) ?>">
                    <small class="text-muted">Qtd. contada - Qtd. informada</small>
                </div>
                <div class="col-md-3">
                    <label for="apto_envaze" class="form-label">Apto para Envaze</label>
                    <input type="number" class="form-control" id="apto_envaze" name="apto_envaze" step="0.01" min="0"
                        placeholder="Ex: 95.00" value="<?= htmlspecialchars($aptoEnvaze) ?>">
                    <small class="text-muted">Qtd apta para o envaze</small>
                </div>
                <div class="col-md-3">
                    <label for="quebra" class="form-label">Inapto para Envaze</label>
                    <input type="number" class="form-control" id="quebra" name="quebra" step="0.01" min="0"
                        placeholder="Ex: 1.50" value="<?= htmlspecialchars($quebra) ?>" readonly>
                    <small class="text-muted">Qtd inapta / quebrada durante a triagem</small>
                </div>
            </div>
            <div class="row mb-3 g-3 align-items-start">

                <!-- <div class="col <?= $diferencaAtual !== '' ? 'col-md-9' : 'col-12' ?>">
                        <label for="notes" class="form-label">Observações</label>
                        <textarea class="form-control"
                                  id="notes"
                                  name="notes"
                                  rows="3"
                                  placeholder="Observações adicionais sobre o pedido..."><?= htmlspecialchars($notesIniciais) ?></textarea>
                    </div> -->
            </div>
            <?php else: ?>
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="quantity" class="form-label required">Quantidade Informada</label>
                    <input type="number" class="form-control" id="quantity" name="quantity" step="0.01" min="0.01"
                        placeholder="Ex: 100.00" required
                        value="<?= htmlspecialchars($quantidadeInformadaFieldValue) ?>">
                    <small class="text-muted">Informe a quantidade desejada</small>
                    <div class="invalid-feedback">Informe a quantidade</div>
                </div>
                <div class="col-md-6">
                    <label for="notes" class="form-label">Observações</label>
                    <textarea class="form-control" id="notes" name="notes" rows="3"
                        placeholder="Observações adicionais sobre o pedido..."><?= htmlspecialchars($notesIniciais) ?></textarea>
                </div>
            </div>
            <?php endif; ?>

            <!-- Botões de Ação -->
            <div class="row mt-4">
                <div class="col-12 d-flex justify-content-between gap-2">
                    <a href="<?= url('/pedidos') ?>" class="btn btn-secondary">
                        <i class="bi bi-x-circle me-2"></i> Cancelar
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i> <?= htmlspecialchars($botaoAcaoLabel) ?>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
.required::after {
    content: " *";
    color: #dc3545;
}

.form-label {
    font-weight: 600;
    margin-bottom: 0.5rem;
}

.form-control:focus,
.form-select:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.alert {
    border-left: 4px solid #0dcaf0;
}

.autocomplete-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: #fff;
    border: 1px solid #dee2e6;
    border-top: none;
    border-radius: 0 0 0.375rem 0.375rem;
    max-height: 280px;
    overflow-y: auto;
    z-index: 1050;
    box-shadow: 0 .5rem 1rem rgba(0, 0, 0, 0.1);
}

.autocomplete-item {
    padding: 0.75rem 1rem;
    cursor: pointer;
    border-bottom: 1px solid #f1f1f1;
    transition: all 0.15s ease-in-out;
}

.autocomplete-item:hover,
.autocomplete-item.active {
    background-color: #0d6efd;
    color: #fff;
}

.autocomplete-item:hover .text-muted {
    color: rgba(255, 255, 255, 0.8) !important;
}

.autocomplete-no-results {
    padding: 0.75rem;
    text-align: center;
    color: #6c757d;
    font-style: italic;
}

/* Responsividade Mobile */
@media (max-width: 575.98px) {
    .card-body {
        padding: 1rem;
    }

    .row.mb-3 {
        margin-bottom: 1rem !important;
    }

    .btn {
        width: 100%;
        margin-bottom: 0.5rem;
    }

    .d-flex.justify-content-between {
        flex-direction: column;
    }
}

/* Responsividade Tablet */
@media (min-width: 576px) and (max-width: 991.98px) {
    .card-body {
        padding: 1.25rem;
    }
}

/* Estilos para SweetAlert responsivo */
.swal2-popup-responsive {
    max-width: 90% !important;
    font-size: 0.9rem !important;
}

.swal2-html-container-responsive {
    max-height: 60vh;
    overflow-y: auto;
    padding: 0.5rem;
}

@media (max-width: 576px) {
    .swal2-popup-responsive {
        width: 95% !important;
        padding: 1rem !important;
    }

    .swal2-html-container-responsive {
        font-size: 0.85rem !important;
        padding: 0.5rem !important;
    }

    .swal2-title {
        font-size: 1.1rem !important;
    }

    .swal2-confirm {
        width: 100% !important;
        margin-top: 0.5rem !important;
    }
}
</style>

<script>
const clientesData = <?= json_encode(array_values($clientes ?? [])) ?>;
const isEditPedido = <?= $isEdit ? 'true' : 'false' ?>;
const linhaTemporalPedido = <?= json_encode($isEdit ? ($linhaTemporal ?? 'entrada') : 'entrada') ?>;
const isTriagemLinhaTemporal = linhaTemporalPedido === 'triagem';
const quantidadeInformadaOriginal =
    <?= $quantidadeInformadaBase !== '' ? json_encode((float)$quantidadeInformadaBase) : 'null' ?>;
const diferencaInicial = <?= $diferencaAtual !== '' ? json_encode((float)$diferencaAtual) : 'null' ?>;
const triagemConfig = <?= json_encode($triagemProdutos, JSON_UNESCAPED_UNICODE) ?>;
const garrafaoProdutoTriagem = triagemConfig?.garrafao || null;
let triagemWorkflowInput = null;
const pedidoSelecionado = <?= $isEdit ? json_encode([
    'id' => $clienteSelecionado['id'] ?? null,
    'name' => $clienteSelecionado['name'] ?? '',
    'trade_name' => $clienteSelecionado['trade_name'] ?? '',
    'document' => $clienteSelecionado['document'] ?? '',
    'email' => $clienteSelecionado['email'] ?? '',
    'phone' => $clienteSelecionado['phone'] ?? '',
    'mobile' => $clienteSelecionado['mobile'] ?? '',
    'quantidade' => $quantidadeInformadaFieldValue,
    'quantidade_contada' => $quantidadeContada,
    'apto_envaze' => $aptoEnvaze,
    'quebra' => $quebra,
    'notes' => $notesIniciais,
    'linha_temporal' => $linhaTemporal
], JSON_UNESCAPED_UNICODE) : 'null' ?>;
let autocompleteTimeout = null;
let selectedCustomer = null;

$(document).ready(function() {
    triagemWorkflowInput = $('#triagem_workflow');
    inicializarAutocompleteCliente();
    inicializarTriagemQuantidade();
    aplicarMascaraInteiros(['#quantity', '#quantidade_contada', '#apto_envaze']);

    $('#formPedido').on('submit', async function(e) {
        e.preventDefault();

        let isValid = true;

        if (!$('#customer_id').val()) {
            $('#customer_search').addClass('is-invalid');
            $('#customer-error').show();
            isValid = false;
        } else {
            $('#customer_search').removeClass('is-invalid');
            $('#customer-error').hide();
        }

        if (!isTriagemLinhaTemporal) {
            const quantity = parseFloat($('#quantity').val());
            if (!quantity || quantity <= 0) {
                $('#quantity').addClass('is-invalid');
                isValid = false;
            } else {
                $('#quantity').removeClass('is-invalid');
            }
        } else {
            const quantidadeContada = parseFloat($('#quantidade_contada').val());
            if (!quantidadeContada || quantidadeContada <= 0) {
                $('#quantidade_contada').addClass('is-invalid');
                isValid = false;
            } else {
                $('#quantidade_contada').removeClass('is-invalid');
            }
        }

        if (!isValid) {
            Swal.fire({
                icon: 'warning',
                title: 'Atenção!',
                text: 'Preencha todos os campos obrigatórios corretamente.'
            });
            return;
        }

        if (isTriagemLinhaTemporal) {
            const fluxoAprovado = await executarFluxoTriagem();
            if (!fluxoAprovado) {
                return;
            }
        }

        const mensagemProcessamento = isEditPedido ? 'Atualizando pedido...' : 'Criando pedido...';
        Swal.fire({
            title: mensagemProcessamento,
            html: isEditPedido ? 'Aguarde enquanto o pedido é atualizado.' :
                'Aguarde enquanto o pedido é criado.',
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => Swal.showLoading()
        });

        const formData = $(this).serialize();

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message || (isEditPedido ?
                            'Pedido atualizado com sucesso!' :
                            'Pedido criado com sucesso!'),
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        if (response.data && response.data.redirect) {
                            window.location.href = response.data.redirect;
                        } else {
                            window.location.href = appUrl('/pedidos');
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: response.message || 'Erro ao criar pedido'
                    });
                }
            },
            error: function(xhr) {
                let errorMessage = 'Erro ao processar requisição';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: errorMessage
                });
            }
        });
    });

    $('#customer_search').on('input change', function() {
        $(this).removeClass('is-invalid');
        $('#customer-error').hide();
    });

    $('#quantity').on('input change', function() {
        $(this).removeClass('is-invalid');
    });

    $('#quantidade_contada').on('input change', function() {
        $(this).removeClass('is-invalid');
    });

    if (isEditPedido) {
        if (pedidoSelecionado && pedidoSelecionado.id) {
            const clienteExistente = clientesData.find(c => String(c.id) === String(pedidoSelecionado.id));
            if (clienteExistente) {
                selecionarCliente(clienteExistente, true);
            } else {
                selecionarCliente(pedidoSelecionado, true);
            }
            if (pedidoSelecionado.quantidade && !isTriagemLinhaTemporal) {
                $('#quantity').val(pedidoSelecionado.quantidade);
            }
            if (pedidoSelecionado.quantidade_contada && isTriagemLinhaTemporal) {
                $('#quantidade_contada').val(pedidoSelecionado.quantidade_contada);
            }
            if (pedidoSelecionado.apto_envaze && isTriagemLinhaTemporal) {
                $('#apto_envaze').val(pedidoSelecionado.apto_envaze);
            }
            if (pedidoSelecionado.quebra && isTriagemLinhaTemporal) {
                $('#quebra').val(pedidoSelecionado.quebra);
            }
            if (pedidoSelecionado.notes) {
                $('#notes').val(pedidoSelecionado.notes);
            }
        }
    } else {
        $('#customer_search').focus();
    }
});

function inicializarAutocompleteCliente() {
    const $search = $('#customer_search');
    const $dropdown = $('#customer_dropdown');

    // Se estiver em modo de edição, desabilitar autocomplete
    if (isEditPedido && $search.prop('readonly')) {
        return;
    }

    $search.on('input', function() {
        const query = $(this).val().trim();
        clearTimeout(autocompleteTimeout);

        if (query.length < 2) {
            $dropdown.hide();
            return;
        }

        autocompleteTimeout = setTimeout(() => {
            buscarClientes(query.toLowerCase());
        }, 250);
    });

    $search.on('focus', function() {
        if ($(this).val().length >= 2) {
            buscarClientes($(this).val().trim().toLowerCase());
        }
    });

    $search.on('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
        }
    });

    $(document).on('click', function(e) {
        if (!$(e.target).closest('#customer_search, #customer_dropdown').length) {
            $dropdown.hide();
        }
    });
}

function parseIntegerValue(value) {
    if (value === null || value === undefined) {
        return null;
    }

    const normalized = String(value)
        .replace(/[^\d.,-]/g, '')
        .replace(',', '.')
        .trim();

    if (normalized === '') {
        return null;
    }

    const numeric = Number(normalized);
    if (!Number.isFinite(numeric)) {
        return null;
    }

    const integer = Math.trunc(numeric);
    return integer >= 0 ? integer : 0;
}

function formatIntegerValue(value) {
    if (value === null || value === undefined || value === '' || Number.isNaN(value)) {
        return '';
    }

    const numeric = Number(value);
    if (!Number.isFinite(numeric)) {
        return '';
    }

    return String(Math.max(0, Math.trunc(numeric)));
}

function formatSignedIntegerValue(value) {
    if (value === null || value === undefined || value === '' || Number.isNaN(value)) {
        return '';
    }

    const numeric = Number(value);
    if (!Number.isFinite(numeric)) {
        return '';
    }

    return String(Math.trunc(numeric));
}

function aplicarMascaraInteiros(selectors) {
    selectors.forEach(selector => {
        const $field = $(selector);
        if (!$field.length) {
            return;
        }

        const inicial = parseIntegerValue($field.val());
        $field.val(inicial !== null ? formatIntegerValue(inicial) : '');

        $field.on('input.integer-mask', function() {
            const valorAtual = $(this).val();
            if (valorAtual === '') {
                return;
            }
            const sanitizado = valorAtual.replace(/[^\d]/g, '');
            if (valorAtual !== sanitizado) {
                $(this).val(sanitizado);
            }
        });

        $field.on('blur.integer-mask', function() {
            const parsed = parseIntegerValue($(this).val());
            $(this).val(parsed !== null ? formatIntegerValue(parsed) : '');
        });
    });
}

function inicializarTriagemQuantidade() {
    if (!isTriagemLinhaTemporal) {
        return;
    }

    const $quantidadeField = $('#quantity');
    const $quantidadeContadaField = $('#quantidade_contada');
    const $diferencaField = $('#diferenca');
    const $aptoEnvazeField = $('#apto_envaze');
    const $inaptoField = $('#quebra');

    if (!$quantidadeContadaField.length) {
        return;
    }

    $quantidadeContadaField.prop('readonly', false);

    if ($inaptoField.length) {
        $inaptoField.prop('readonly', true);
    }

    // Armazenar valor real da quantidade informada e inicialmente deixar campo vazio
    const quantidadeReal = $quantidadeField.data('quantidade-real') || '';
    if (quantidadeReal) {
        $quantidadeField.val(''); // Inicialmente vazio
    }

    function obterQuantidadeInformadaValor() {
        // Se o campo estiver vazio, usar o valor real armazenado
        let quantidadeInformadaValor = parseIntegerValue($quantidadeField.val());
        if (quantidadeInformadaValor === null) {
            const quantidadeRealValue = $quantidadeField.data('quantidade-real');
            if (quantidadeRealValue) {
                quantidadeInformadaValor = parseIntegerValue(quantidadeRealValue);
            } else if (quantidadeInformadaOriginal !== null) {
                quantidadeInformadaValor = parseIntegerValue(quantidadeInformadaOriginal);
            }
        }
        return quantidadeInformadaValor;
    }

    // Função para exibir quantidade informada após blur da quantidade contada
    function exibirQuantidadeInformada() {
        const quantidadeContadaValor = parseFloat($quantidadeContadaField.val() || 0);
        if (quantidadeContadaValor > 0) {
            const quantidadeRealValue = $quantidadeField.data('quantidade-real') || '';
            if (quantidadeRealValue) {
                $quantidadeField.val(quantidadeRealValue);
            } else if (quantidadeInformadaOriginal !== null) {
                $quantidadeField.val(formatIntegerValue(quantidadeInformadaOriginal));
            }
        } else {
            $quantidadeField.val('');
        }
    }

    function atualizarDiferenca() {
        if (!$diferencaField.length) {
            return;
        }

        const quantidadeContadaValor = parseIntegerValue($quantidadeContadaField.val());
        const quantidadeInformadaValor = obterQuantidadeInformadaValor();

        if (quantidadeContadaValor === null || quantidadeInformadaValor === null) {
            $diferencaField.val('');
            return;
        }

        const diferencaCalculada = quantidadeInformadaValor - quantidadeContadaValor;
        $diferencaField.val(formatSignedIntegerValue(diferencaCalculada));
    }

    function atualizarInaptoPorApto() {
        if (!$inaptoField.length || !$aptoEnvazeField.length) {
            return;
        }

        const quantidadeContadaValor = parseIntegerValue($quantidadeContadaField.val());
        const aptoValor = parseIntegerValue($aptoEnvazeField.val());

        if (quantidadeContadaValor === null || quantidadeContadaValor <= 0 || aptoValor === null || aptoValor < 0) {
            return;
        }

        let inapto = quantidadeContadaValor - aptoValor;
        if (!Number.isFinite(inapto) || inapto < 0) {
            inapto = 0;
        }

        $inaptoField.val(formatIntegerValue(inapto)).prop('readonly', true);
    }

    function aplicarEstadoTriagem(valorContado) {
        if (!valorContado || Number.isNaN(valorContado) || valorContado <= 0) {
            return;
        }

        const valorFormatado = formatIntegerValue(valorContado);
        $quantidadeContadaField
            .val(valorFormatado)
            .prop('readonly', true);

        $quantidadeField.prop('readonly', true);
        obterQuantidadeInformadaValor();
        atualizarInaptoPorApto();
        atualizarDiferenca();
    }

    $quantidadeContadaField.on('blur.triagem', function() {
        const valor = parseIntegerValue($(this).val());
        if (!valor || valor <= 0) {
            // Se quantidade contada for 0 ou vazia, ocultar quantidade informada
            $quantidadeField.val('');
            return;
        }
        // Exibir quantidade informada após blur se quantidade contada > 0
        exibirQuantidadeInformada();
        aplicarEstadoTriagem(valor);
        atualizarDiferenca();
    });

    if ($quantidadeField.length) {
        $quantidadeField.on('blur.triagem change', function() {
            const parsed = parseIntegerValue($(this).val());
            if (parsed !== null) {
                $(this).val(formatIntegerValue(parsed));
            } else if (quantidadeInformadaOriginal !== null) {
                $(this).val(formatIntegerValue(quantidadeInformadaOriginal));
            } else {
                $(this).val('');
            }
            atualizarDiferenca();
        });
    }

    if ($aptoEnvazeField.length) {
        $aptoEnvazeField.on('blur.triagem change', function() {
            const parsed = parseIntegerValue($(this).val());
            $(this).val(parsed !== null ? formatIntegerValue(parsed) : '');
            atualizarInaptoPorApto();
            atualizarDiferenca();
        });
    }

    const valorInicial = parseIntegerValue($quantidadeContadaField.val());
    if (valorInicial && valorInicial > 0) {
        // Se já tiver quantidade contada inicial, exibir quantidade informada
        exibirQuantidadeInformada();
        aplicarEstadoTriagem(valorInicial);
    } else if (diferencaInicial !== null && quantidadeInformadaOriginal !== null) {
        const valorCalculado = quantidadeInformadaOriginal + diferencaInicial;
        if (valorCalculado && valorCalculado > 0) {
            $quantidadeContadaField.val(formatIntegerValue(valorCalculado));
            exibirQuantidadeInformada();
            aplicarEstadoTriagem(valorCalculado);
        }
    } else {
        // Se não tiver quantidade contada, manter quantidade informada vazia
        $quantidadeField.val('');
        atualizarInaptoPorApto();
        atualizarDiferenca();
    }
}

function coletarValoresTriagem() {
    const informada = parseIntegerValue($('#quantity').val());
    const contada = parseIntegerValue($('#quantidade_contada').val());
    const apto = parseIntegerValue($('#apto_envaze').val());
    const inapto = parseIntegerValue($('#quebra').val());

    if (informada === null || contada === null || apto === null || inapto === null) {
        return null;
    }

    const diferenca = informada - contada;
    const fatorCashback = garrafaoProdutoTriagem && garrafaoProdutoTriagem.fator_cashback ?
        Number(garrafaoProdutoTriagem.fator_cashback) || 0 :
        0;
    const precoGarrafao = garrafaoProdutoTriagem && garrafaoProdutoTriagem.price ?
        Number(garrafaoProdutoTriagem.price) || 0 :
        0;
    const cashbackTotal = fatorCashback > 0 ? Math.floor(inapto / fatorCashback) : 0;
    const cashbackSobra = fatorCashback > 0 ? inapto % fatorCashback : 0;
    const descontoCalculado = (precoGarrafao > 0 && fatorCashback > 0) ?
        (precoGarrafao / fatorCashback) * cashbackSobra :
        0;

    return {
        informada,
        contada,
        diferenca,
        apto,
        inapto,
        fatorCashback,
        precoGarrafao,
        cashbackTotal,
        cashbackSobra,
        descontoCalculado
    };
}

function formatNumberPt(value) {
    if (value === null || value === undefined || Number.isNaN(value)) {
        return '-';
    }
    return new Intl.NumberFormat('pt-BR').format(Number(value));
}

function formatCurrencyBRL(value) {
    if (value === null || value === undefined || Number.isNaN(value)) {
        return '-';
    }
    return new Intl.NumberFormat('pt-BR', {
        style: 'currency',
        currency: 'BRL'
    }).format(Number(value));
}

function gerarResumoTriagemHtml(valores) {
    const linhas = [
        ['Qtd Informada', formatNumberPt(valores.informada)],
        ['Qtd Contada', formatNumberPt(valores.contada)],
        ['Diferença', formatNumberPt(valores.diferenca)],
        ['Apto para Envaze', formatNumberPt(valores.apto)],
        ['Inapto para Envaze', formatNumberPt(valores.inapto)],
    ];

    if (valores.fatorCashback > 0) {
        linhas.push(['Cashback', `${formatNumberPt(valores.cashbackTotal)} garrafão(ões)`]);
        linhas.push(['Sobra do Cashback', formatNumberPt(valores.cashbackSobra)]);
        linhas.push(['Desconto (potencial)', formatCurrencyBRL(valores.descontoCalculado)]);
    }

    const linhasHtml = linhas.map(([label, valor]) => `
        <div class="d-flex justify-content-between py-1 border-bottom">
            <span class="fw-semibold">${label}</span>
            <span>${valor}</span>
        </div>
    `).join('');

    return `<div class="text-start">${linhasHtml}</div>`;
}

async function executarFluxoTriagem() {
    const valores = coletarValoresTriagem();
    if (!valores) {
        await Swal.fire({
            icon: 'warning',
            title: 'Dados incompletos',
            text: 'Informe todas as quantidades antes de gerar o pedido.'
        });
        return false;
    }

    const resumoHtml = gerarResumoTriagemHtml(valores);
    const resumoResult = await Swal.fire({
        icon: 'info',
        title: 'Resumo da Conferência',
        html: resumoHtml,
        showCancelButton: true,
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar'
    });

    if (!resumoResult.isConfirmed) {
        return false;
    }

    const completarResult = await Swal.fire({
        icon: 'question',
        title: 'Completar quantidade?',
        text: 'Deseja completar a quantidade contada para suprir a quantidade informada na portaria?',
        showCancelButton: true,
        confirmButtonText: 'Sim',
        cancelButtonText: 'Não'
    });

    if (completarResult.dismiss && completarResult.dismiss !== Swal.DismissReason.cancel) {
        return false;
    }
    const completarQuantidade = completarResult.isConfirmed;

    const converterResult = await Swal.fire({
        icon: 'question',
        title: 'Converter cashback?',
        text: 'Deseja converter o cashback em novos garrafões?',
        showCancelButton: true,
        confirmButtonText: 'Sim',
        cancelButtonText: 'Não'
    });

    if (converterResult.dismiss && converterResult.dismiss !== Swal.DismissReason.cancel) {
        return false;
    }
    const converterCashback = converterResult.isConfirmed;

    let completarSobra = false;
    if (converterCashback && valores.cashbackSobra > 0) {
        const completarSobraResult = await Swal.fire({
            icon: 'question',
            title: 'Completar sobra?',
            text: 'Deseja completar o valor para garrafão(ões) novo(s) com a sobra do cashback?',
            showCancelButton: true,
            confirmButtonText: 'Sim',
            cancelButtonText: 'Não'
        });

        if (completarSobraResult.dismiss && completarSobraResult.dismiss !== Swal.DismissReason.cancel) {
            return false;
        }
        completarSobra = completarSobraResult.isConfirmed;
    }

    const workflowPayload = {
        resumo: valores,
        acoes: {
            completarQuantidade,
            converterCashback,
            completarSobra
        }
    };

    if (triagemWorkflowInput && triagemWorkflowInput.length) {
        triagemWorkflowInput.val(JSON.stringify(workflowPayload));
    }

    return true;
}

function buscarClientes(query) {
    const $dropdown = $('#customer_dropdown');

    if (!Array.isArray(clientesData) || clientesData.length === 0) {
        $dropdown.html('<div class="autocomplete-no-results">Nenhum cliente cadastrado</div>').show();
        return;
    }

    const normalizedQuery = query.replace(/[^\d\w]/g, '');

    const results = clientesData.filter(cliente => {
        const name = (cliente.name || '').toLowerCase();
        const tradeName = (cliente.trade_name || '').toLowerCase();
        const document = (cliente.document || '').toLowerCase();
        const email = (cliente.email || '').toLowerCase();
        const phone = (cliente.phone || '').toLowerCase();
        const mobile = (cliente.mobile || '').toLowerCase();

        const normalizedDocument = document.replace(/[^\d\w]/g, '');

        return name.includes(query) ||
            tradeName.includes(query) ||
            document.includes(query) ||
            normalizedDocument.includes(normalizedQuery) ||
            email.includes(query) ||
            phone.includes(query) ||
            mobile.includes(query);
    }).slice(0, 15);

    let html = '';

    if (results.length > 0) {
        results.forEach(cliente => {
            const codigo = cliente.id ? String(cliente.id).padStart(4, '0') : '-';
            const nome = escapeHtml(cliente.name || 'Sem nome');
            const fantasia = escapeHtml(cliente.trade_name || '');
            const documento = escapeHtml(cliente.document || 'Sem documento');
            const contato = escapeHtml(cliente.phone || cliente.mobile || cliente.email || '');

            html += `
                <div class="autocomplete-item" data-id="${cliente.id}">
                    <div class="fw-bold">${nome}</div>
                    <div class="small text-muted">
                        Código: ${codigo} • Documento: ${documento}${fantasia ? ' • Fantasia: ' + fantasia : ''}
                    </div>
                    ${contato ? `<div class="small text-muted">Contato: ${contato}</div>` : ''}
                </div>
            `;
        });
    } else {
        html = '<div class="autocomplete-no-results">Nenhum cliente encontrado</div>';
    }

    $dropdown.html(html).show();

    $dropdown.find('.autocomplete-item').on('click', function() {
        const clienteId = $(this).data('id');
        const cliente = clientesData.find(c => c.id == clienteId);
        if (cliente) {
            selecionarCliente(cliente);
        }
    });
}

function selecionarCliente(cliente, isPrefill = false) {
    selectedCustomer = cliente;

    $('#customer_id').val(cliente.id);
    $('#customer_type').val('pessoa');
    $('#customer_name').val(cliente.name || '');
    $('#customer_document').val(cliente.document || '');

    const nomeExibir = cliente.trade_name || cliente.name || '';
    $('#customer_search').val(nomeExibir);

    const documento = escapeHtml(cliente.document || 'Não informado');
    const telefone = escapeHtml(cliente.phone || cliente.mobile || '-');
    const email = escapeHtml(cliente.email || '-');
    const codigo = cliente.id ? String(cliente.id).padStart(4, '0') : '-';

    const infoHtml = `
        <div>
            <div class="fw-bold mb-1">${escapeHtml(nomeExibir)}</div>
            <div class="small">
                <strong>Código:</strong> ${codigo} • <strong>Documento:</strong> ${documento}
            </div>
            <div class="small text-muted">
                <strong>Telefone:</strong> ${telefone} • <strong>Email:</strong> ${email}
            </div>
        </div>
    `;

    $('#customer_info_content').html(infoHtml);
    $('#customer_info').slideDown();

    $('#customer_search').removeClass('is-invalid');
    $('#customer-error').hide();
    $('#customer_dropdown').hide();

    // Buscar veículos e motoristas do cliente
    if (cliente.id && !isPrefill) {
        buscarVeiculosMotoristas(cliente.id);
    }
}

function buscarVeiculosMotoristas(clienteId) {
    $.ajax({
        url: appUrl('/pedidos/buscar-veiculos-motoristas'),
        type: 'GET',
        data: {
            cliente_id: clienteId
        },
        dataType: 'json',
        success: function(response) {
            if (response.success && response.data) {
                const veiculos = response.data.veiculos || [];
                const motoristas = response.data.motoristas || [];

                if (veiculos.length > 0 || motoristas.length > 0) {
                    exibirVeiculosMotoristas(veiculos, motoristas);
                }
            }
        },
        error: function(xhr) {
            // Silenciar erro, não é crítico
            console.log('Erro ao buscar veículos e motoristas:', xhr);
        }
    });
}

function exibirVeiculosMotoristas(veiculos, motoristas) {
    let html = '<div style="text-align: left; max-width: 100%;">';

    // Agrupar motoristas por veículo
    const motoristasPorVeiculo = {};
    veiculos.forEach(veiculo => {
        motoristasPorVeiculo[veiculo.id] = veiculo.motoristas || [];
    });

    // Exibir veículos e seus motoristas
    veiculos.forEach((veiculo, index) => {
        const motoristasVeiculo = motoristasPorVeiculo[veiculo.id] || [];

        html +=
            `<div style="margin-bottom: ${index < veiculos.length - 1 ? '20px' : '0'}; padding-bottom: ${index < veiculos.length - 1 ? '15px' : '0'}; border-bottom: ${index < veiculos.length - 1 ? '1px solid #e0e0e0' : 'none'};">`;

        // Dados do veículo
        html +=
            `<div style="margin-bottom: 10px;"><strong style="color: #0066CC;">🚛 Veículo ${index + 1}</strong></div>`;
        html += `<div style="font-size: 0.9em; line-height: 1.6; margin-left: 10px;">`;

        if (veiculo.apelido) html += `<div><strong>Apelido:</strong> ${escapeHtml(veiculo.apelido)}</div>`;
        if (veiculo.placa) html += `<div><strong>Placa:</strong> ${escapeHtml(veiculo.placa)}</div>`;
        if (veiculo.modelo) html += `<div><strong>Modelo:</strong> ${escapeHtml(veiculo.modelo)}</div>`;
        if (veiculo.marca) html += `<div><strong>Marca:</strong> ${escapeHtml(veiculo.marca)}</div>`;
        if (veiculo.ano) html += `<div><strong>Ano:</strong> ${escapeHtml(veiculo.ano)}</div>`;
        if (veiculo.cor) html += `<div><strong>Cor:</strong> ${escapeHtml(veiculo.cor)}</div>`;

        html += `</div>`;

        // Motoristas do veículo
        if (motoristasVeiculo.length > 0) {
            html +=
                `<div style="margin-top: 10px; margin-left: 10px;"><strong style="color: #28a745;">👤 Motorista(s)</strong></div>`;
            html += `<div style="font-size: 0.9em; line-height: 1.6; margin-left: 20px;">`;

            motoristasVeiculo.forEach((motorista, mIndex) => {
                if (mIndex > 0) html +=
                    `<div style="margin-top: 8px; padding-top: 8px; border-top: 1px solid #f0f0f0;"></div>`;

                if (motorista.nome) html +=
                    `<div><strong>Nome:</strong> ${escapeHtml(motorista.nome)}</div>`;
                if (motorista.documento) html +=
                    `<div><strong>Documento:</strong> ${escapeHtml(motorista.documento)}</div>`;
                if (motorista.cnh) html +=
                    `<div><strong>CNH:</strong> ${escapeHtml(motorista.cnh)}</div>`;
                if (motorista.categoria_cnh) html +=
                    `<div><strong>Categoria CNH:</strong> ${escapeHtml(motorista.categoria_cnh)}</div>`;
                if (motorista.telefone) html +=
                    `<div><strong>Telefone:</strong> ${escapeHtml(motorista.telefone)}</div>`;
            });

            html += `</div>`;
        }

        html += `</div>`;
    });

    html += '</div>';

    // Selecionar primeiro veículo e primeiro motorista (se existir)
    let veiculoSelecionado = '';
    let motoristaSelecionado = '';

    if (veiculos.length > 0) {
        const primeiroVeiculo = veiculos[0];
        veiculoSelecionado = primeiroVeiculo.apelido || primeiroVeiculo.placa || primeiroVeiculo.modelo || '';

        const motoristasPrimeiroVeiculo = motoristasPorVeiculo[primeiroVeiculo.id] || [];
        if (motoristasPrimeiroVeiculo.length > 0) {
            motoristaSelecionado = motoristasPrimeiroVeiculo[0].nome || '';
        }
    }

    $('#motorista').val(motoristaSelecionado);
    $('#veiculo').val(veiculoSelecionado);

    Swal.fire({
        title: 'Veículos e Motoristas Encontrados',
        html: html,
        icon: 'info',
        width: window.innerWidth <= 576 ? '90%' : '600px',
        customClass: {
            popup: 'swal2-popup-responsive',
            htmlContainer: 'swal2-html-container-responsive'
        },
        confirmButtonText: 'OK',
        confirmButtonColor: '#0066CC'
    });
}

function limparCliente() {
    // Não permitir limpar cliente em modo de edição
    if (isEditPedido) {
        return;
    }

    selectedCustomer = null;
    $('#customer_id').val('');
    $('#customer_type').val('pessoa');
    $('#customer_name').val('');
    $('#customer_document').val('');
    $('#customer_search').val('').focus();
    $('#customer_info').slideUp();
}

function escapeHtml(text) {
    const map = {
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;',
        '"': '&quot;',
        "'": '&#039;'
    };
    return String(text ?? '').replace(/[&<>"']/g, m => map[m]);
}
</script>

<?php
$content = ob_get_clean();
require __DIR__ . '/../layouts/app.php';
?>