<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PDV | Aurion</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'IBM Plex Sans', sans-serif;
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 25%, #f093fb 50%, #4facfe 75%, #00f2fe 100%);
            background-size: 400% 400%;
            animation: gradientShift 15s ease infinite;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
            overflow: hidden;
        }

        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(0, 17, 34, 0.8) 0%, rgba(0, 51, 102, 0.9) 100%);
            z-index: 0;
        }

        @keyframes gradientShift {
            0% {
                background-position: 0% 50%;
            }

            50% {
                background-position: 100% 50%;
            }

            100% {
                background-position: 0% 50%;
            }
        }

        .login-card {
            width: 100%;
            max-width: 440px;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 24px;
            box-shadow: 0 20px 60px rgba(0, 17, 34, 0.3), 0 0 0 1px rgba(255, 255, 255, 0.1);
            overflow: hidden;
            position: relative;
            z-index: 1;
            animation: cardFadeIn 0.6s ease-out;
        }

        @keyframes cardFadeIn {
            from {
                opacity: 0;
                transform: translateY(30px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .login-header {
            background: linear-gradient(135deg, #001122 0%, #003366 100%);
            padding: 48px 32px 36px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .login-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -20%;
            width: 300px;
            height: 300px;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
            border-radius: 50%;
            animation: float 6s ease-in-out infinite;
        }

        .login-header::after {
            content: '';
            position: absolute;
            bottom: -30%;
            left: -10%;
            width: 200px;
            height: 200px;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.08) 0%, transparent 70%);
            border-radius: 50%;
            animation: float 8s ease-in-out infinite reverse;
        }

        @keyframes float {

            0%,
            100% {
                transform: translateY(0) translateX(0);
            }

            50% {
                transform: translateY(-20px) translateX(20px);
            }
        }

        .login-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.2) 0%, rgba(255, 255, 255, 0.1) 100%);
            border-radius: 20px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 24px;
            position: relative;
            z-index: 1;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.2), inset 0 1px 0 rgba(255, 255, 255, 0.2);
            transition: transform 0.3s ease;
        }

        .login-icon:hover {
            transform: scale(1.05) rotate(5deg);
        }

        .login-icon i {
            font-size: 36px;
            color: white;
            filter: drop-shadow(0 2px 4px rgba(0, 0, 0, 0.2));
        }

        .login-header h1 {
            font-size: 28px;
            font-weight: 700;
            color: white;
            margin-bottom: 8px;
            position: relative;
            z-index: 1;
            text-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
            letter-spacing: -0.5px;
        }

        .login-header p {
            font-size: 15px;
            color: rgba(255, 255, 255, 0.85);
            position: relative;
            z-index: 1;
            font-weight: 400;
        }

        .login-body {
            padding: 40px 36px;
            background: white;
        }

        .form-group {
            margin-bottom: 24px;
            position: relative;
        }

        .form-label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .form-label::before {
            content: '';
            width: 4px;
            height: 16px;
            background: linear-gradient(135deg, #001122 0%, #003366 100%);
            border-radius: 2px;
        }

        .form-control {
            width: 100%;
            height: 52px;
            padding: 0 16px 0 48px;
            font-size: 15px;
            font-family: inherit;
            color: #1e293b;
            background: #f8fafc;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
        }

        .form-control:hover {
            border-color: #cbd5e1;
            background: white;
        }

        .form-control:focus {
            outline: none;
            background: white;
            border-color: #001122;
            box-shadow: 0 0 0 4px rgba(0, 17, 34, 0.1), 0 4px 12px rgba(0, 17, 34, 0.1);
            transform: translateY(-1px);
        }

        .form-group .input-icon {
            position: absolute;
            left: 16px;
            top: calc(50% + 12px);
            transform: translateY(-50%);
            color: #64748b;
            font-size: 18px;
            pointer-events: none;
            transition: color 0.3s;
            z-index: 2;
        }

        .form-control:focus~.input-icon {
            color: #001122;
        }

        .btn-login {
            width: 100%;
            height: 56px;
            font-size: 16px;
            font-weight: 600;
            font-family: inherit;
            color: white;
            background: linear-gradient(135deg, #001122 0%, #003366 100%);
            border: none;
            border-radius: 12px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 4px 16px rgba(0, 17, 34, 0.3), 0 0 0 0 rgba(0, 17, 34, 0.5);
            position: relative;
            overflow: hidden;
            margin-top: 8px;
        }

        .btn-login::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }

        .btn-login:hover::before {
            width: 300px;
            height: 300px;
        }

        .btn-login:hover {
            background: linear-gradient(135deg, #003366 0%, #004488 100%);
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(0, 17, 34, 0.4), 0 0 0 4px rgba(0, 17, 34, 0.1);
        }

        .btn-login:active {
            transform: translateY(0);
            box-shadow: 0 4px 12px rgba(0, 17, 34, 0.3);
        }

        .btn-login i {
            position: relative;
            z-index: 1;
        }

        .btn-login span {
            position: relative;
            z-index: 1;
        }

        .btn-login:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }

        .login-footer {
            padding: 20px 36px;
            background: linear-gradient(to top, #f8fafc 0%, #ffffff 100%);
            border-top: 1px solid #e2e8f0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 13px;
            color: #64748b;
        }

        .login-footer #clock {
            font-weight: 600;
            color: #001122;
            font-variant-numeric: tabular-nums;
            letter-spacing: 1px;
        }

        .spinner {
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-top-color: white;
            border-radius: 50%;
            animation: spin 0.6s linear infinite;
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }

        @media (max-width: 440px) {

            .login-header,
            .login-body {
                padding: 24px;
            }

            .login-footer {
                padding: 12px 24px;
            }
        }
    </style>
</head>

<body>
    <div class="login-card">
        <div class="login-header">
            <div class="login-icon">
                <i class="bi bi-cart3"></i>
            </div>
            <h1>Ponto de Venda</h1>
            <p>Acesse o caixa</p>
        </div>

        <div class="login-body">
            <form id="formLogin">
                <div class="form-group">
                    <label class="form-label">Email</label>
                    <input type="email" class="form-control" name="email" placeholder="seu@email.com" required
                        autofocus>
                    <i class="bi bi-envelope input-icon"></i>
                </div>

                <div class="form-group">
                    <label class="form-label">Senha</label>
                    <input type="password" class="form-control" name="password" placeholder="••••••••" required>
                    <i class="bi bi-lock input-icon"></i>
                </div>

                <button type="submit" class="btn-login" id="btnLogin">
                    <i class="bi bi-box-arrow-in-right"></i>
                    <span>Entrar</span>
                </button>
            </form>
        </div>

        <div class="login-footer">
            <span>Systhema © <?= date('Y') ?></span>
            <span id="clock">--:--</span>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        // Clock
        setInterval(() => {
            document.getElementById('clock').textContent = new Date().toLocaleTimeString('pt-BR', {
                hour: '2-digit',
                minute: '2-digit'
            });
        }, 1000);

        // URL helper
        const buildUrl = path => {
            const seg = location.pathname.split('/').filter(s => s);
            return (seg.length ? '/' + seg[0] : '') + '/' + path.replace(/^\/+/, '');
        };

        // Login
        $('#formLogin').on('submit', function (e) {
            e.preventDefault();
            const $btn = $('#btnLogin'),
                orig = $btn.html();
            $btn.prop('disabled', true).html('<div class="spinner"></div>');

            $.post(buildUrl('/pdv/autenticar'), $(this).serialize(), null, 'json')
                .done(res => {
                    if (res.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'OK',
                            timer: 1000,
                            showConfirmButton: false
                        })
                            .then(() => location.href = buildUrl(res.data?.redirect || '/pdv/caixa'));
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: res.message
                        });
                        $btn.prop('disabled', false).html(orig);
                    }
                })
                .fail(() => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Falha na conexão'
                    });
                    $btn.prop('disabled', false).html(orig);
                });
        });
    </script>
</body>

</html>