<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <title>Comprovante de Fechamento de Caixa</title>
    <style>
        @page {
            size: 80mm auto;
            margin: 0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', 'Arial', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            width: 80mm;
            background: white;
            color: #1a1a1a;
        }

        .cupom {
            width: 100%;
            padding: 4mm;
        }

        /* Header com Logo */
        .header {
            text-align: center;
            padding-bottom: 10px;
            margin-bottom: 0;
        }

        .logo {
            max-width: 50mm;
            max-height: 18mm;
            margin-bottom: 6px;
        }

        .empresa-nome {
            font-size: 14px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: #000;
        }

        .empresa-info {
            font-size: 9px;
            margin-top: 5px;
            line-height: 1.5;
            color: #333;
        }

        .empresa-info span {
            display: block;
        }

        /* Tarja/Banner - Estilo moderno */
        .tarja {
            background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
            color: #fff;
            text-align: center;
            font-weight: 700;
            font-size: 12px;
            padding: 8px 8px;
            margin: 8px -4mm;
            letter-spacing: 1.5px;
            text-transform: uppercase;
        }

        .tarja-secundaria {
            background: linear-gradient(135deg, #c82333 0%, #bd2130 100%);
            color: #fff;
            text-align: center;
            font-weight: 600;
            font-size: 10px;
            padding: 5px 8px;
            margin: 6px -4mm;
            letter-spacing: 1px;
        }

        /* Info Sessão */
        .info-sessao {
            padding: 10px 0;
        }

        .info-linha {
            display: flex;
            justify-content: space-between;
            margin-bottom: 6px;
            font-size: 10px;
            padding: 4px 0;
        }

        .info-linha:last-child {
            margin-bottom: 0;
        }

        .info-linha strong {
            color: #000;
            font-size: 11px;
        }

        .info-label {
            color: #555;
        }

        /* Seção de Valores */
        .secao-valores {
            margin: 10px 0;
        }

        .secao-titulo {
            font-size: 10px;
            font-weight: 700;
            text-transform: uppercase;
            color: #333;
            padding: 6px 0;
            border-bottom: 2px solid #ddd;
            margin-bottom: 8px;
        }

        .valor-linha {
            display: flex;
            justify-content: space-between;
            padding: 5px 0;
            font-size: 10px;
            border-bottom: 1px dotted #ddd;
        }

        .valor-linha:last-child {
            border-bottom: none;
        }

        .valor-linha-label {
            color: #555;
        }

        .valor-linha-valor {
            font-weight: 600;
            color: #000;
        }

        .valor-linha-total {
            font-weight: 700;
            font-size: 11px;
            padding-top: 5px;
            margin-top: 5px;
            border-top: 2px solid #333;
        }

        /* Destaque para valores importantes */
        .destaque-valor {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: #fff;
            text-align: center;
            padding: 12px 10px;
            margin: 10px -4mm;
            border-radius: 8px;
        }

        .destaque-valor-label {
            font-size: 9px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 6px;
            opacity: 0.9;
        }

        .destaque-valor-valor {
            font-size: 20px;
            font-weight: 700;
            letter-spacing: 1px;
        }

        .destaque-valor-negativo {
            background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        }

        /* Métodos de Pagamento */
        .metodos-pagamento {
            margin: 10px 0;
        }

        .metodo-item {
            display: flex;
            justify-content: space-between;
            padding: 5px 0;
            font-size: 10px;
            border-bottom: 1px dotted #ddd;
        }

        .metodo-item:last-child {
            border-bottom: none;
        }

        .metodo-nome {
            color: #555;
        }

        .metodo-valor {
            font-weight: 600;
            color: #000;
        }

        /* Observações */
        .observacoes {
            padding: 10px 0;
            margin-top: 10px;
        }

        .observacoes-label {
            font-size: 9px;
            font-weight: 600;
            text-transform: uppercase;
            color: #666;
            margin-bottom: 5px;
        }

        .observacoes-texto {
            font-size: 10px;
            color: #333;
            padding: 8px;
            background: #f8f9fa;
            border-left: 3px solid #dc3545;
            border-radius: 4px;
        }

        /* Footer */
        .footer {
            text-align: center;
            padding: 12px 0 8px;
        }

        .footer-msg {
            font-weight: 700;
            font-size: 12px;
            margin-bottom: 4px;
            color: #000;
        }

        .footer-info {
            font-size: 9px;
            color: #666;
            padding-top: 8px;
            border-top: 1px solid #ddd;
        }

        .footer-info .datetime {
            font-weight: 600;
            color: #333;
        }

        .footer-info .brand {
            margin-top: 4px;
            font-style: italic;
        }

        /* Decorativo */
        .divisor {
            height: 1px;
            background: linear-gradient(to right, transparent, #ccc, transparent);
            margin: 8px 0;
        }

        .divisor-forte {
            height: 2px;
            background: linear-gradient(to right, transparent, #333, transparent);
            margin: 10px 0;
        }

        @media print {
            body {
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }

            .tarja,
            .tarja-secundaria,
            .destaque-valor {
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }
        }
    </style>
</head>

<body>
    <div class="cupom">
        <!-- Header com Logo -->
        <div class="header">
            <?php
            // Buscar logo da empresa pelo CNPJ
            $cnpjLimpo = preg_replace('/\D/', '', $empresa['cnpj'] ?? '');
            $logoPath = '';

            // 1. Tentar campo logo direto
            if (!empty($empresa['logo'])) {
                $logoPath = $empresa['logo'];
            }

            // 2. Fallback: logo por CNPJ no storage
            if (empty($logoPath) && !empty($cnpjLimpo)) {
                $rootPath = defined('ROOT_PATH') ? ROOT_PATH : dirname(__DIR__, 2);
                $extensoes = ['jpg', 'jpeg', 'png', 'gif'];
                foreach ($extensoes as $ext) {
                    $arquivo = "storage/uploads/logos/{$cnpjLimpo}.{$ext}";
                    if (file_exists($rootPath . '/' . $arquivo)) {
                        $logoPath = $arquivo;
                        break;
                    }
                }
            }

            // 3. Montar URL completa
            if (!empty($logoPath)) {
                if (strpos($logoPath, 'http') === 0) {
                    $logoUrl = $logoPath;
                } else {
                    $scriptDir = dirname($_SERVER['SCRIPT_NAME']);
                    $baseUrl = rtrim($scriptDir, '/');
                    $logoUrl = $baseUrl . '/' . ltrim($logoPath, '/');
                }
            } else {
                $logoUrl = '';
            }
            ?>
            <?php if (!empty($logoUrl)): ?>
                <img src="<?= htmlspecialchars($logoUrl) ?>" alt="Logo" class="logo">
            <?php endif; ?>

            <div class="empresa-nome">
                <?= htmlspecialchars($empresa['nome_fantasia'] ?? $empresa['razao_social'] ?? 'EMPRESA') ?>
            </div>

            <div class="empresa-info">
                <?php if (!empty($empresa['cnpj'])): ?>
                    <span>CNPJ: <?= htmlspecialchars($empresa['cnpj']) ?></span>
                <?php endif; ?>
                <?php if (!empty($empresa['endereco'])): ?>
                    <span><?= htmlspecialchars($empresa['endereco']) ?><?= !empty($empresa['numero']) ? ', ' . $empresa['numero'] : '' ?></span>
                <?php endif; ?>
                <?php if (!empty($empresa['bairro']) || !empty($empresa['cidade'])): ?>
                    <span>
                        <?= htmlspecialchars($empresa['bairro'] ?? '') ?>
                        <?= (!empty($empresa['bairro']) && !empty($empresa['cidade'])) ? ' - ' : '' ?>
                        <?= htmlspecialchars($empresa['cidade'] ?? '') ?>/<?= htmlspecialchars($empresa['uf'] ?? '') ?>
                    </span>
                <?php endif; ?>
                <?php if (!empty($empresa['telefone'])): ?>
                    <span>Tel: <?= htmlspecialchars($empresa['telefone']) ?></span>
                <?php endif; ?>
            </div>
        </div>

        <!-- Tarja Principal -->
        <div class="tarja">🔒 Fechamento de Caixa</div>

        <!-- Info Sessão -->
        <div class="info-sessao">
            <div class="info-linha">
                <span class="info-label">Operador:</span>
                <strong><?= htmlspecialchars($sessao['operador_nome'] ?? 'N/A') ?></strong>
            </div>
            <div class="info-linha">
                <span class="info-label">Sessão:</span>
                <strong>#<?= htmlspecialchars($sessao['id'] ?? '-') ?></strong>
            </div>
            <div class="info-linha">
                <span class="info-label">Abertura:</span>
                <strong><?= date('d/m/Y H:i', strtotime($sessao['created_at'] ?? 'now')) ?></strong>
            </div>
            <div class="info-linha">
                <span class="info-label">Fechamento:</span>
                <strong><?= date('d/m/Y H:i', strtotime($sessao['closed_at'] ?? $sessao['updated_at'] ?? 'now')) ?></strong>
            </div>
        </div>

        <div class="divisor"></div>

        <!-- Resumo de Movimentações -->
        <div class="secao-valores">
            <div class="secao-titulo">Resumo de Movimentações</div>

            <div class="valor-linha">
                <span class="valor-linha-label">Valor de Abertura:</span>
                <span class="valor-linha-valor">R$ <?= number_format($valor_abertura ?? 0, 2, ',', '.') ?></span>
            </div>

            <div class="valor-linha">
                <span class="valor-linha-label">Qtd. de Vendas:</span>
                <span class="valor-linha-valor"><?= $qtd_vendas ?? 0 ?></span>
            </div>

            <div class="valor-linha">
                <span class="valor-linha-label">Total de Vendas:</span>
                <span class="valor-linha-valor">R$ <?= number_format($total_vendas ?? 0, 2, ',', '.') ?></span>
            </div>

            <div class="valor-linha">
                <span class="valor-linha-label">Suprimentos:</span>
                <span class="valor-linha-valor">R$ <?= number_format($total_suprimentos ?? 0, 2, ',', '.') ?></span>
            </div>

            <div class="valor-linha">
                <span class="valor-linha-label">Sangrias:</span>
                <span class="valor-linha-valor">R$ <?= number_format($total_sangrias ?? 0, 2, ',', '.') ?></span>
            </div>

            <div class="valor-linha valor-linha-total">
                <span>Saldo Esperado:</span>
                <span>R$ <?= number_format($saldo_esperado ?? 0, 2, ',', '.') ?></span>
            </div>
        </div>

        <div class="divisor-forte"></div>

        <!-- Valores Informados por Método de Pagamento -->
        <?php if (!empty($valores_metodos)): ?>
        <div class="metodos-pagamento">
            <div class="secao-titulo">Valores Informados</div>
            <?php foreach ($valores_metodos as $metodo): ?>
                <div class="metodo-item">
                    <span class="metodo-nome"><?= htmlspecialchars($metodo['metodo_nome'] ?? 'Método ' . ($metodo['metodo_pagamento_id'] ?? '')) ?>:</span>
                    <span class="metodo-valor">R$ <?= number_format($metodo['valor'] ?? 0, 2, ',', '.') ?></span>
                </div>
            <?php endforeach; ?>

            <div class="metodo-item valor-linha-total">
                <span>Total Informado:</span>
                <span>R$ <?= number_format($valor_fechamento ?? 0, 2, ',', '.') ?></span>
            </div>
        </div>
        <?php endif; ?>

        <div class="divisor-forte"></div>

        <!-- Diferença - Destaque -->
        <div class="destaque-valor <?= ($diferenca ?? 0) < 0 ? 'destaque-valor-negativo' : '' ?>">
            <div class="destaque-valor-label">Diferença</div>
            <div class="destaque-valor-valor">
                <?= ($diferenca ?? 0) >= 0 ? '+' : '' ?>R$ <?= number_format($diferenca ?? 0, 2, ',', '.') ?>
            </div>
        </div>

        <!-- Observações (se houver) -->
        <?php if (!empty($sessao['observacoes_fechamento'])): ?>
            <div class="observacoes">
                <div class="observacoes-label">Observações:</div>
                <div class="observacoes-texto">
                    <?= htmlspecialchars($sessao['observacoes_fechamento']) ?>
                </div>
            </div>
        <?php endif; ?>

        <div class="divisor"></div>

        <!-- Footer -->
        <div class="footer">
            <div class="footer-msg">✅ Caixa Fechado com Sucesso</div>
            <div class="footer-info">
                <div class="datetime"><?= date('d/m/Y H:i:s') ?></div>
                <div class="brand">Systhema ERP</div>
            </div>
        </div>
    </div>

    <script>
        // Impressão automática
        window.onload = function () {
            setTimeout(function() {
                window.print();
            }, 300);
        };

        // Detectar quando a impressão é concluída ou cancelada
        window.addEventListener('afterprint', function() {
            if (window.parent && window.parent !== window) {
                window.parent.postMessage('print-complete', '*');
            }
        });

        // Fallback: usar matchMedia para detectar quando sai do modo de impressão
        if (window.matchMedia) {
            let mediaQueryList = window.matchMedia('print');
            let wasPrinting = false;

            function checkPrintStatus(mql) {
                if (mql.matches) {
                    wasPrinting = true;
                } else if (wasPrinting) {
                    wasPrinting = false;
                    if (window.parent && window.parent !== window) {
                        window.parent.postMessage('print-complete', '*');
                    }
                }
            }

            if (mediaQueryList.addEventListener) {
                mediaQueryList.addEventListener('change', checkPrintStatus);
            } else if (mediaQueryList.addListener) {
                mediaQueryList.addListener(checkPrintStatus);
            }
        }
    </script>
</body>

</html>

