<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <title>Comprovante de Abertura de Caixa</title>
    <style>
        @page {
            size: 80mm auto;
            margin: 0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', 'Arial', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            width: 80mm;
            background: white;
            color: #1a1a1a;
        }

        .cupom {
            width: 100%;
            padding: 4mm;
        }

        /* Header com Logo */
        .header {
            text-align: center;
            padding-bottom: 10px;
            margin-bottom: 0;
        }

        .logo {
            max-width: 50mm;
            max-height: 18mm;
            margin-bottom: 6px;
        }

        .empresa-nome {
            font-size: 14px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: #000;
        }

        .empresa-info {
            font-size: 9px;
            margin-top: 5px;
            line-height: 1.5;
            color: #333;
        }

        .empresa-info span {
            display: block;
        }

        /* Tarja/Banner - Estilo moderno */
        .tarja {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: #fff;
            text-align: center;
            font-weight: 700;
            font-size: 12px;
            padding: 8px 8px;
            margin: 8px -4mm;
            letter-spacing: 1.5px;
            text-transform: uppercase;
        }

        .tarja-secundaria {
            background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%);
            color: #fff;
            text-align: center;
            font-weight: 600;
            font-size: 10px;
            padding: 5px 8px;
            margin: 6px -4mm;
            letter-spacing: 1px;
        }

        /* Info Abertura */
        .info-abertura {
            padding: 10px 0;
        }

        .info-linha {
            display: flex;
            justify-content: space-between;
            margin-bottom: 6px;
            font-size: 10px;
            padding: 4px 0;
        }

        .info-linha:last-child {
            margin-bottom: 0;
        }

        .info-linha strong {
            color: #000;
            font-size: 11px;
        }

        .info-label {
            color: #555;
        }

        /* Valor de Abertura - Destaque */
        .valor-abertura {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: #fff;
            text-align: center;
            padding: 15px 10px;
            margin: 10px -4mm;
            border-radius: 8px;
        }

        .valor-abertura-label {
            font-size: 10px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 8px;
            opacity: 0.9;
        }

        .valor-abertura-valor {
            font-size: 24px;
            font-weight: 700;
            letter-spacing: 1px;
        }

        /* Observações */
        .observacoes {
            padding: 10px 0;
            margin-top: 10px;
        }

        .observacoes-label {
            font-size: 9px;
            font-weight: 600;
            text-transform: uppercase;
            color: #666;
            margin-bottom: 5px;
        }

        .observacoes-texto {
            font-size: 10px;
            color: #333;
            padding: 8px;
            background: #f8f9fa;
            border-left: 3px solid #28a745;
            border-radius: 4px;
        }

        /* Footer */
        .footer {
            text-align: center;
            padding: 12px 0 8px;
        }

        .footer-msg {
            font-weight: 700;
            font-size: 12px;
            margin-bottom: 4px;
            color: #000;
        }

        .footer-info {
            font-size: 9px;
            color: #666;
            padding-top: 8px;
            border-top: 1px solid #ddd;
        }

        .footer-info .datetime {
            font-weight: 600;
            color: #333;
        }

        .footer-info .brand {
            margin-top: 4px;
            font-style: italic;
        }

        /* Decorativo */
        .divisor {
            height: 1px;
            background: linear-gradient(to right, transparent, #ccc, transparent);
            margin: 8px 0;
        }

        @media print {
            body {
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }

            .tarja,
            .tarja-secundaria,
            .valor-abertura {
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }
        }
    </style>
</head>

<body>
    <div class="cupom">
        <!-- Header com Logo -->
        <div class="header">
            <?php
            // Buscar logo da empresa pelo CNPJ
            $cnpjLimpo = preg_replace('/\D/', '', $empresa['cnpj'] ?? '');
            $logoPath = '';

            // 1. Tentar campo logo direto
            if (!empty($empresa['logo'])) {
                $logoPath = $empresa['logo'];
            }

            // 2. Fallback: logo por CNPJ no storage
            if (empty($logoPath) && !empty($cnpjLimpo)) {
                $rootPath = defined('ROOT_PATH') ? ROOT_PATH : dirname(__DIR__, 2);
                $extensoes = ['jpg', 'jpeg', 'png', 'gif'];
                foreach ($extensoes as $ext) {
                    $arquivo = "storage/uploads/logos/{$cnpjLimpo}.{$ext}";
                    if (file_exists($rootPath . '/' . $arquivo)) {
                        $logoPath = $arquivo;
                        break;
                    }
                }
            }

            // 3. Montar URL completa
            if (!empty($logoPath)) {
                // Se já tem http, usar direto
                if (strpos($logoPath, 'http') === 0) {
                    $logoUrl = $logoPath;
                } else {
                    // Montar URL relativa à raiz do projeto
                    $scriptDir = dirname($_SERVER['SCRIPT_NAME']);
                    $baseUrl = rtrim($scriptDir, '/');
                    $logoUrl = $baseUrl . '/' . ltrim($logoPath, '/');
                }
            } else {
                $logoUrl = '';
            }
            ?>
            <?php if (!empty($logoUrl)): ?>
                <img src="<?= htmlspecialchars($logoUrl) ?>" alt="Logo" class="logo">
            <?php endif; ?>

            <div class="empresa-nome">
                <?= htmlspecialchars($empresa['nome_fantasia'] ?? $empresa['razao_social'] ?? 'EMPRESA') ?>
            </div>

            <div class="empresa-info">
                <?php if (!empty($empresa['cnpj'])): ?>
                    <span>CNPJ: <?= htmlspecialchars($empresa['cnpj']) ?></span>
                <?php endif; ?>
                <?php if (!empty($empresa['endereco'])): ?>
                    <span><?= htmlspecialchars($empresa['endereco']) ?><?= !empty($empresa['numero']) ? ', ' . $empresa['numero'] : '' ?></span>
                <?php endif; ?>
                <?php if (!empty($empresa['bairro']) || !empty($empresa['cidade'])): ?>
                    <span>
                        <?= htmlspecialchars($empresa['bairro'] ?? '') ?>
                        <?= (!empty($empresa['bairro']) && !empty($empresa['cidade'])) ? ' - ' : '' ?>
                        <?= htmlspecialchars($empresa['cidade'] ?? '') ?>/<?= htmlspecialchars($empresa['uf'] ?? '') ?>
                    </span>
                <?php endif; ?>
                <?php if (!empty($empresa['telefone'])): ?>
                    <span>Tel: <?= htmlspecialchars($empresa['telefone']) ?></span>
                <?php endif; ?>
            </div>
        </div>

        <!-- Tarja Principal -->
        <div class="tarja">💰 Abertura de Caixa</div>

        <!-- Info Abertura -->
        <div class="info-abertura">
            <div class="info-linha">
                <span class="info-label">Operador:</span>
                <strong><?= htmlspecialchars($sessao['operador_nome'] ?? 'N/A') ?></strong>
            </div>
            <div class="info-linha">
                <span class="info-label">Data/Hora:</span>
                <strong><?= date('d/m/Y H:i', strtotime($sessao['created_at'] ?? 'now')) ?></strong>
            </div>
            <div class="info-linha">
                <span class="info-label">Sessão:</span>
                <strong>#<?= htmlspecialchars($sessao['id'] ?? '-') ?></strong>
            </div>
        </div>

        <!-- Valor de Abertura - Destaque -->
        <div class="valor-abertura">
            <div class="valor-abertura-label">Valor de Abertura</div>
            <div class="valor-abertura-valor">R$ <?= number_format($sessao['valor_abertura'] ?? 0, 2, ',', '.') ?></div>
        </div>

        <!-- Observações (se houver) -->
        <?php if (!empty($sessao['observacoes_abertura'])): ?>
            <div class="observacoes">
                <div class="observacoes-label">Observações:</div>
                <div class="observacoes-texto">
                    <?= htmlspecialchars($sessao['observacoes_abertura']) ?>
                </div>
            </div>
        <?php endif; ?>

        <div class="divisor"></div>

        <!-- Footer -->
        <div class="footer">
            <div class="footer-msg">✅ Caixa Aberto com Sucesso</div>
            <div class="footer-info">
                <div class="datetime"><?= date('d/m/Y H:i:s') ?></div>
                <div class="brand">Systhema ERP</div>
            </div>
        </div>
    </div>

    <script>
        // Impressão automática
        window.onload = function () {
            // Aguardar um pouco antes de imprimir para garantir que tudo carregou
            setTimeout(function() {
                window.print();
            }, 300);
        };

        // Detectar quando a impressão é concluída ou cancelada
        window.addEventListener('afterprint', function() {
            // Notificar a janela pai que a impressão foi concluída
            if (window.parent && window.parent !== window) {
                window.parent.postMessage('print-complete', '*');
            }
        });

        // Fallback: usar matchMedia para detectar quando sai do modo de impressão
        if (window.matchMedia) {
            let mediaQueryList = window.matchMedia('print');
            let wasPrinting = false;

            function checkPrintStatus(mql) {
                if (mql.matches) {
                    wasPrinting = true;
                } else if (wasPrinting) {
                    // Estava imprimindo e agora não está mais
                    wasPrinting = false;
                    if (window.parent && window.parent !== window) {
                        window.parent.postMessage('print-complete', '*');
                    }
                }
            }

            // Adicionar listener (addListener para compatibilidade antiga, addEventListener para nova)
            if (mediaQueryList.addEventListener) {
                mediaQueryList.addEventListener('change', checkPrintStatus);
            } else if (mediaQueryList.addListener) {
                mediaQueryList.addListener(checkPrintStatus);
            }
        }
    </script>
</body>

</html>

