<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item active">Parâmetros</li>
            </ol>
        </nav>
        <h2><i class="bi bi-gear me-2"></i> Parâmetros do Sistema</h2>
        <p class="text-muted">Selecione uma empresa para configurar seus parâmetros</p>
    </div>
</div>

<div class="row">
    <?php if (empty($empresas)): ?>
        <div class="col-12">
            <div class="alert alert-info">
                <i class="bi bi-info-circle me-2"></i>
                Nenhuma empresa cadastrada. <a href="<?= url('/empresas') ?>">Cadastre uma empresa</a> para começar.
            </div>
        </div>
    <?php else: ?>
        <?php foreach ($empresas as $empresa): ?>
            <div class="col-md-6 col-lg-4 mb-4">
                <div class="card h-100 hover-shadow">
                    <div class="card-body">
                        <h5 class="card-title">
                            <i class="bi bi-building me-2"></i>
                            <?= htmlspecialchars($empresa['razao_social']) ?>
                        </h5>

                        <?php if (!empty($empresa['nome_fantasia'])): ?>
                            <p class="text-muted mb-2">
                                <small><?= htmlspecialchars($empresa['nome_fantasia']) ?></small>
                            </p>
                        <?php endif; ?>

                        <?php if (!empty($empresa['cnpj'])): ?>
                            <p class="text-muted mb-2">
                                <small><strong>CNPJ:</strong> <?= htmlspecialchars($empresa['cnpj']) ?></small>
                            </p>
                        <?php endif; ?>

                        <div class="mb-3">
                            <?php $ativo = strtoupper((string) ($empresa['ativo'] ?? 'Sim')) === 'SIM'; ?>
                            <span class="badge bg-<?= $ativo ? 'success' : 'secondary' ?>">
                                <?= $ativo ? 'Ativa' : 'Inativa' ?>
                            </span>
                        </div>

                        <a href="<?= url('/parametros-edit?id=' . $empresa['id']) ?>" class="btn btn-primary w-100">
                            <i class="bi bi-gear-fill me-2"></i> Configurar Parâmetros
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<style>
.hover-shadow {
    transition: all 0.3s ease;
}

.hover-shadow:hover {
    transform: translateY(-5px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1) !important;
}
</style>

<?php
$content = ob_get_clean();
require __DIR__ . '/../layouts/app.php';
?>
