<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/parametros') ?>">Parâmetros</a></li>
                <li class="breadcrumb-item active"><?= htmlspecialchars($empresa['razao_social']) ?></li>
            </ol>
        </nav>
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="bi bi-gear me-2"></i> Parâmetros - <?= htmlspecialchars($empresa['razao_social']) ?></h2>
                <?php if (!empty($empresa['nome_fantasia'])): ?>
                <p class="text-muted"><?= htmlspecialchars($empresa['nome_fantasia']) ?></p>
                <?php endif; ?>
            </div>
            <a href="<?= url('/parametros') ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i> Voltar
            </a>
        </div>
    </div>
</div>

<!-- Tabs -->
<ul class="nav nav-tabs mb-4" id="parametrosTabs" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="regras-tab" data-bs-toggle="tab" data-bs-target="#regras" type="button">
            <i class="bi bi-sliders"></i> Regras de Operação
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="geral-tab" data-bs-toggle="tab" data-bs-target="#geral" type="button">
            <i class="bi bi-gear"></i> Geral
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="financeiro-tab" data-bs-toggle="tab" data-bs-target="#financeiro" type="button">
            <i class="bi bi-cash-coin"></i> Financeiro
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="seguranca-tab" data-bs-toggle="tab" data-bs-target="#seguranca" type="button">
            <i class="bi bi-shield-lock"></i> Segurança
        </button>
    </li>
</ul>

<!-- Tab Content -->
<div class="tab-content" id="parametrosTabContent">

    <!-- REGRAS OPERACIONAIS -->
    <div class="tab-pane fade show active" id="regras" role="tabpanel">
        <div class="row g-3">
            <?php foreach ($definicoesBooleanas as $modulo => $config): ?>
            <?php if ($modulo === 'modulos') {
                    continue;
                } ?>
            <div class="col-12">
                <div class="card shadow-sm h-100">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-1">
                                <i class="bi <?= $config['icone'] ?? 'bi-gear' ?> me-2"></i>
                                <?= htmlspecialchars($config['titulo']) ?>
                            </h5>
                            <p class="text-muted small mb-0">Parâmetros críticos que impactam o funcionamento deste
                                módulo.</p>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row g-4">
                            <?php foreach ($config['itens'] as $chave => $item):
                                    $valorAtivo = (int) ($parametrosBooleanos[$modulo][$chave] ?? 0);
                                ?>
                            <div class="col-lg-6">
                                <div class="p-3 border rounded-3 h-100 position-relative bg-dark bg-opacity-10">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="pe-3">
                                            <h6 class="mb-1"><?= htmlspecialchars($item['label']) ?></h6>
                                            <p class="text-muted small mb-0">
                                                <?= htmlspecialchars($item['descricao']) ?>
                                            </p>
                                        </div>
                                        <div class="form-check form-switch">
                                            <input class="form-check-input toggle-parametro" type="checkbox"
                                                role="switch" data-modulo="<?= $modulo ?>" data-chave="<?= $chave ?>"
                                                data-empresa="<?= $empresa['id'] ?>"
                                                data-label="<?= htmlspecialchars($item['label']) ?>"
                                                <?= $valorAtivo ? 'checked' : '' ?>>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>

                        <?php if (!empty($config['permissoes'])): ?>
                        <div class="alert alert-dark mt-4 mb-0" role="alert">
                            <div class="d-flex">
                                <i class="bi bi-shield-lock me-3 fs-4"></i>
                                <div>
                                    <h6 class="mb-2">Permissões sugeridas para este módulo</h6>
                                    <ul class="mb-0 ps-3">
                                        <?php foreach ($config['permissoes'] as $permissao): ?>
                                        <li class="small"><?= htmlspecialchars($permissao) ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- GERAL -->
    <div class="tab-pane fade" id="geral" role="tabpanel">
        <form id="formGeral" class="parametros-form" data-categoria="general">
            <input type="hidden" name="company_id" value="<?= $empresa['id'] ?>">

            <div class="card">
                <div class="card-header">
                    <i class="bi bi-building me-2"></i> Dados da Empresa
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label class="form-label">Nota de Rodapé (usado nos comprovantes de impressora
                                térmica)</label>
                            <textarea class="form-control" name="parametros[nota_rodape]"
                                rows="2"><?= htmlspecialchars($parametros['geral']['nota_rodape'] ?? '') ?></textarea>
                            <small class="text-muted">Texto que aparece no rodapé dos comprovantes térmicos</small>
                        </div>

                        <div class="col-md-12 mb-3">
                            <label class="form-label">Mensagem no Boleto Bancário</label>
                            <textarea class="form-control" name="parametros[mensagem_boleto]"
                                rows="3"><?= htmlspecialchars($parametros['geral']['mensagem_boleto'] ?? '') ?></textarea>
                            <small class="text-muted">Instruções e mensagens que aparecerão no boleto</small>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">Tipo de Impressão A4</label>
                            <select class="form-select" name="parametros[tipo_impressao_a4]">
                                <option value="1"
                                    <?= ($parametros['geral']['tipo_impressao_a4'] ?? '1') == '1' ? 'selected' : '' ?>>1
                                    - Meia Folha</option>
                                <option value="2"
                                    <?= ($parametros['geral']['tipo_impressao_a4'] ?? '') == '2' ? 'selected' : '' ?>>2
                                    - Folha Inteira</option>
                            </select>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">Orientação do Papel</label>
                            <select class="form-select" name="parametros[orientacao_papel]">
                                <option value="1"
                                    <?= ($parametros['geral']['orientacao_papel'] ?? '1') == '1' ? 'selected' : '' ?>>1
                                    - Retrato</option>
                                <option value="2"
                                    <?= ($parametros['geral']['orientacao_papel'] ?? '') == '2' ? 'selected' : '' ?>>2 -
                                    Paisagem</option>
                            </select>
                        </div>

                    </div>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <i class="bi bi-palette me-2"></i> Personalização
                </div>
                <div class="card-body">
                    <div class="row">
                    </div>
                </div>
            </div>

            <div class="mt-3">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle me-2"></i> Salvar Configurações Gerais
                </button>
            </div>
        </form>
    </div>

    <!-- FINANCEIRO -->
    <div class="tab-pane fade" id="financeiro" role="tabpanel">
        <form id="formFinanceiro" class="parametros-form" data-categoria="financeiro">
            <input type="hidden" name="company_id" value="<?= $empresa['id'] ?>">

            <!-- Boletos e Documentos -->
            <div class="card mb-3">
                <div class="card-header">
                    <i class="bi bi-file-earmark-pdf me-2"></i> Boletos e Documentos
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="enviar_boleto_nfe"
                                    name="parametros[enviar_boleto_nfe]" value="1"
                                    <?= ($parametros['financeiro']['enviar_boleto_nfe'] ?? '0') == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="enviar_boleto_nfe">
                                    <strong>Enviar Boleto + NFe juntos</strong>
                                </label>
                                <small class="d-block text-muted">Quando habilitado, envia o boleto e a NFe no mesmo
                                    email</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Lembretes de Vencimento -->
            <div class="card mb-3">
                <div class="card-header">
                    <i class="bi bi-bell me-2"></i> Lembretes de Vencimento
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="enviar_lembrete_vencimento"
                                    name="parametros[enviar_lembrete_vencimento]" value="1"
                                    <?= ($parametros['financeiro']['enviar_lembrete_vencimento'] ?? '0') == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="enviar_lembrete_vencimento">
                                    <strong>Enviar Lembrete de Vencimento</strong>
                                </label>
                                <small class="d-block text-muted">Envia email automático para clientes sobre títulos
                                    próximos ao vencimento</small>
                            </div>
                        </div>

                        <div class="col-md-6 mb-3" id="dias_antes_vencimento_container">
                            <label class="form-label">Enviar com quantos dias de antecedência?</label>
                            <input type="number" class="form-control" name="parametros[dias_antes_vencimento]"
                                value="<?= htmlspecialchars($parametros['financeiro']['dias_antes_vencimento'] ?? '3') ?>"
                                min="1" max="30">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Alertas no Login -->
            <div class="card mb-3">
                <div class="card-header">
                    <i class="bi bi-exclamation-triangle me-2"></i> Alertas no Login
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="alerta_contas_pagar"
                                    name="parametros[alerta_contas_pagar]" value="1"
                                    <?= ($parametros['financeiro']['alerta_contas_pagar'] ?? '1') == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="alerta_contas_pagar">
                                    <strong>Alerta de Contas a Pagar</strong>
                                </label>
                                <small class="d-block text-muted">Mostra notificação ao fazer login sobre contas a pagar
                                    vencidas ou próximas do vencimento</small>
                            </div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="alerta_contas_receber"
                                    name="parametros[alerta_contas_receber]" value="1"
                                    <?= ($parametros['financeiro']['alerta_contas_receber'] ?? '1') == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="alerta_contas_receber">
                                    <strong>Alerta de Contas a Receber</strong>
                                </label>
                                <small class="d-block text-muted">Mostra notificação ao fazer login sobre contas a
                                    receber vencidas ou próximas do vencimento</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Controle de Inadimplência -->
            <div class="card">
                <div class="card-header">
                    <i class="bi bi-person-x me-2"></i> Controle de Inadimplência
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="bloquear_cliente_inadimplente"
                                    name="parametros[bloquear_cliente_inadimplente]" value="1"
                                    <?= ($parametros['financeiro']['bloquear_cliente_inadimplente'] ?? '0') == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="bloquear_cliente_inadimplente">
                                    <strong>Bloquear Cliente Inadimplente</strong>
                                </label>
                                <small class="d-block text-muted">Impede que clientes com títulos vencidos façam novas
                                    compras</small>
                            </div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="vender_cliente_inadimplente"
                                    name="parametros[vender_cliente_inadimplente]" value="1"
                                    <?= ($parametros['financeiro']['vender_cliente_inadimplente'] ?? '0') == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="vender_cliente_inadimplente">
                                    <strong>Permitir Venda para Cliente Inadimplente</strong>
                                </label>
                                <small class="d-block text-muted">Permite vender para cliente inadimplente, mas exibe
                                    aviso</small>
                            </div>
                        </div>

                        <div class="col-md-6 mb-3" id="dias_bloqueio_container">
                            <label class="form-label">Bloquear após quantos dias de inadimplência?</label>
                            <input type="number" class="form-control" name="parametros[dias_bloqueio_inadimplente]"
                                value="<?= htmlspecialchars($parametros['financeiro']['dias_bloqueio_inadimplente'] ?? '0') ?>"
                                min="0" max="365">
                            <small class="text-muted">0 = bloqueia imediatamente após o vencimento</small>
                        </div>

                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="bloqueio_universal_inadimplente"
                                    name="parametros[bloqueio_universal_inadimplente]" value="1"
                                    <?= ($parametros['financeiro']['bloqueio_universal_inadimplente'] ?? '0') == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="bloqueio_universal_inadimplente">
                                    <strong>Bloqueio Universal por Inadimplência</strong>
                                </label>
                                <small class="d-block text-muted">Bloqueia cliente em TODAS as empresas quando
                                    inadimplente em qualquer uma</small>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="alert alert-info mb-0">
                                <i class="bi bi-info-circle me-2"></i>
                                <strong>Atenção:</strong> Se ambas as opções estiverem desabilitadas, o sistema não fará
                                nenhum controle de inadimplência. Se "Bloquear" estiver habilitado, o cliente não poderá
                                comprar. Se "Permitir Venda" estiver habilitado, poderá comprar mas receberá um aviso.
                                <br><br>
                                <strong>Bloqueio Universal:</strong> Quando ativado, bloqueia o cliente em TODAS as
                                empresas
                                do sistema quando ele estiver inadimplente em qualquer uma delas.
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-3">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle me-2"></i> Salvar Configurações Financeiras
                </button>
            </div>
        </form>
    </div>

    <!-- SEGURANÇA -->
    <div class="tab-pane fade" id="seguranca" role="tabpanel">
        <form id="formSeguranca" class="parametros-form" data-categoria="security">
            <input type="hidden" name="company_id" value="<?= $empresa['id'] ?>">

            <div class="card">
                <div class="card-header">
                    <i class="bi bi-shield-lock me-2"></i> Configurações de Segurança
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="enable_2fa"
                                    name="parametros[enable_2fa]" value="1"
                                    <?= ($parametros['seguranca']['enable_2fa'] ?? '0') == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="enable_2fa">
                                    Habilitar Autenticação de Dois Fatores (2FA)
                                </label>
                            </div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">Timeout de Sessão (minutos)</label>
                            <input type="number" class="form-control" name="parametros[session_timeout]"
                                value="<?= htmlspecialchars($parametros['seguranca']['session_timeout'] ?? '60') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">Máximo de Tentativas de Login</label>
                            <input type="number" class="form-control" name="parametros[max_login_attempts]"
                                value="<?= htmlspecialchars($parametros['seguranca']['max_login_attempts'] ?? '5') ?>">
                        </div>

                        <div class="col-md-12 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="force_password_change"
                                    name="parametros[force_password_change]" value="1"
                                    <?= ($parametros['seguranca']['force_password_change'] ?? '0') == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="force_password_change">
                                    Forçar Mudança de Senha a cada 90 dias
                                </label>
                            </div>
                        </div>

                        <div class="col-md-12 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="enable_audit_log"
                                    name="parametros[enable_audit_log]" value="1"
                                    <?= ($parametros['seguranca']['enable_audit_log'] ?? '1') == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="enable_audit_log">
                                    Habilitar Log de Auditoria
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- IPs Válidos -->
            <div class="card mb-4">
                <div class="card-header">
                    <i class="bi bi-shield-check me-2"></i> IPs Válidos
                </div>
                <div class="card-body">
                    <!-- Formulário para adicionar IP -->
                    <form id="formAdicionarIp" class="mb-4">
                        <input type="hidden" name="company_id" value="<?= $empresa['id'] ?>">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Endereço IP</label>
                                <input type="text" class="form-control" name="ip_address"
                                    placeholder="Ex: 192.168.1.100 ou 192.168.1.0/24" required>
                                <small class="text-muted">IPv4, IPv6 ou CIDR</small>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Descrição</label>
                                <input type="text" class="form-control" name="description"
                                    placeholder="Ex: Escritório principal" required>
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">&nbsp;</label>
                                <button type="submit" class="btn btn-primary d-block w-100">
                                    <i class="bi bi-plus-circle me-1"></i>
                                </button>
                            </div>
                        </div>
                    </form>

                    <!-- Lista de IPs -->
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>IP</th>
                                    <th>Descrição</th>
                                    <th>Status</th>
                                    <th>Data</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody id="listaIps">
                                <?php if (!empty($ipsValidos)): ?>
                                <?php foreach ($ipsValidos as $ip): ?>
                                <tr data-ip-id="<?= $ip['id'] ?>">
                                    <td>
                                        <code><?= htmlspecialchars($ip['ip_address']) ?></code>
                                    </td>
                                    <td><?= htmlspecialchars($ip['description']) ?></td>
                                    <td>
                                        <span class="badge bg-<?= $ip['is_active'] ? 'success' : 'secondary' ?>">
                                            <?= $ip['is_active'] ? 'Ativo' : 'Inativo' ?>
                                        </span>
                                    </td>
                                    <td><?= date('d/m/Y H:i', strtotime($ip['created_at'])) ?></td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button type="button"
                                                class="btn btn-outline-<?= $ip['is_active'] ? 'warning' : 'success' ?> toggle-ip"
                                                data-ip-id="<?= $ip['id'] ?>" data-is-active="<?= $ip['is_active'] ?>"
                                                title="<?= $ip['is_active'] ? 'Desativar' : 'Ativar' ?>">
                                                <i class="bi bi-<?= $ip['is_active'] ? 'pause' : 'play' ?>"></i>
                                            </button>
                                            <button type="button" class="btn btn-outline-danger remover-ip"
                                                data-ip-id="<?= $ip['id'] ?>" title="Remover">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                                <?php else: ?>
                                <tr>
                                    <td colspan="5" class="text-center text-muted">
                                        <i class="bi bi-info-circle me-2"></i>
                                        Nenhum IP cadastrado
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="alert alert-info mb-0">
                        <i class="bi bi-info-circle me-2"></i>
                        <strong>Formato de IPs aceitos:</strong><br>
                        • <strong>IPv4:</strong> 192.168.1.100<br>
                        • <strong>IPv6:</strong> 2001:db8::1<br>
                        • <strong>CIDR IPv4:</strong> 192.168.1.0/24<br>
                        • <strong>CIDR IPv6:</strong> 2001:db8::/32
                    </div>
                </div>
            </div>


            <div class="mt-3">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle me-2"></i> Salvar Configurações de Segurança
                </button>
            </div>
        </form>
    </div>


</div>

<script>
// Aguardar jQuery e DOM estarem prontos
document.addEventListener('DOMContentLoaded', function() {
    // Verificar se jQuery está carregado
    if (typeof jQuery === 'undefined') {
        console.error('jQuery não carregado! Aguardando...');
        setTimeout(initParametrosPage, 500);
        return;
    }
    initParametrosPage();
});

function initParametrosPage() {
    const toggleEndpoint = appUrl('/parametros/boolean');

    $(document).off('change.toggleParametro').on('change.toggleParametro', '.toggle-parametro', function() {
        const $input = $(this);
        const payload = {
            empresa_id: $input.data('empresa'),
            modulo: $input.data('modulo'),
            chave: $input.data('chave'),
            valor: $input.is(':checked') ? 1 : 0
        };

        const rotulo = $input.data('label') || 'Parâmetro';
        $input.prop('disabled', true);

        $.ajax({
            url: toggleEndpoint,
            type: 'POST',
            data: payload,
            dataType: 'json',
            success: function(response) {
                if (response && response.success) {
                    Toast.success(response.message || `${rotulo} atualizado.`);
                } else {
                    $input.prop('checked', !payload.valor);
                    const mensagem = response && response.message ? response.message :
                        'Não foi possível salvar parametro.';
                    Toast.error(mensagem);
                }
            },
            error: function(xhr) {
                $input.prop('checked', !payload.valor);
                let mensagem = 'Erro ao salvar parâmetro.';
                try {
                    const erro = JSON.parse(xhr.responseText);
                    mensagem = erro.message || mensagem;
                } catch (e) {}
                Toast.error(mensagem);
            },
            complete: function() {
                $input.prop('disabled', false);
            }
        });
    });


    // Controlar exibição do campo "dias antes vencimento"
    function toggleDiasVencimento() {
        if ($('#enviar_lembrete_vencimento').is(':checked')) {
            $('#dias_antes_vencimento_container').fadeIn();
        } else {
            $('#dias_antes_vencimento_container').fadeOut();
        }
    }

    // Executar ao carregar a página
    toggleDiasVencimento();

    // Executar quando mudar o checkbox
    $('#enviar_lembrete_vencimento').on('change', toggleDiasVencimento);

    // Controlar exibição do campo "dias bloqueio inadimplente"
    function toggleDiasBloqueio() {
        if ($('#bloquear_cliente_inadimplente').is(':checked')) {
            $('#dias_bloqueio_container').fadeIn();
        } else {
            $('#dias_bloqueio_container').fadeOut();
        }
    }

    // Executar ao carregar a página
    toggleDiasBloqueio();

    // Executar quando mudar o checkbox
    $('#bloquear_cliente_inadimplente').on('change', toggleDiasBloqueio);

    // Adicionar IP - SIMPLES E DIRETO
    $('#formAdicionarIp').on('submit', function(e) {
        e.preventDefault();

        const ipAddress = $('input[name="ip_address"]').val().trim();
        const description = $('input[name="description"]').val().trim();
        const companyId = $('input[name="company_id"]').val();

        if (!ipAddress || !description) {
            Swal.fire('Erro!', 'Preencha todos os campos', 'error');
            return;
        }

        $.ajax({
            url: appUrl('/parametros-adicionar-ip'),
            method: 'POST',
            data: {
                company_id: companyId,
                ip_address: ipAddress,
                description: description
            },
            success: function(response) {
                if (response.success) {
                    Swal.fire('Sucesso!', response.message, 'success').then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire('Erro!', response.message, 'error');
                }
            },
            error: function() {
                Swal.fire('Erro!', 'Erro ao adicionar IP', 'error');
            }
        });
    });

    // Remover IP - SIMPLES
    $(document).on('click', '.remover-ip', function() {
        const ipId = $(this).data('ip-id');
        const companyId = $('input[name="company_id"]').val();

        Swal.fire({
            title: 'Remover IP?',
            text: 'Esta ação não pode ser desfeita',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sim, remover',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.post(appUrl('/parametros-remover-ip'), {
                    ip_id: ipId,
                    company_id: companyId
                }, function(response) {
                    if (response.success) {
                        Swal.fire('Removido!', response.message, 'success').then(() => location
                            .reload());
                    } else {
                        Swal.fire('Erro!', response.message, 'error');
                    }
                });
            }
        });
    });

    // Toggle status do IP - SIMPLES
    $(document).on('click', '.toggle-ip', function() {
        const ipId = $(this).data('ip-id');
        const isActive = $(this).data('is-active');
        const companyId = $('input[name="company_id"]').val();

        $.post(appUrl('/parametros-toggle-ip'), {
            ip_id: ipId,
            company_id: companyId,
            is_active: isActive ? 0 : 1
        }, function(response) {
            if (response.success) {
                Swal.fire('Sucesso!', response.message, 'success').then(() => location.reload());
            } else {
                Swal.fire('Erro!', response.message, 'error');
            }
        });
    });

    // Salvar parâmetros via AJAX
    $('.parametros-form').on('submit', function(e) {
        e.preventDefault();

        const form = $(this);
        const categoria = form.data('categoria');
        const formData = form.serialize() + '&categoria=' + categoria;

        Swal.fire({
            title: 'Salvando...',
            text: 'Aguarde enquanto salvamos as configurações',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            url: appUrl('/parametros-salvar'),
            method: 'POST',
            data: formData,
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Sucesso!',
                    text: response.message || 'Parâmetros salvos com sucesso',
                    timer: 2000,
                    showConfirmButton: false
                });
            },
            error: function(xhr) {
                const response = xhr.responseJSON || {};
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: response.message || 'Erro ao salvar parâmetros',
                });
            }
        });
    });

}
</script>

<?php
$content = ob_get_clean();
require __DIR__ . '/../layouts/app.php';
?>