<?php
ob_start();
?>

<style>
.badge.bg-purple {
    background-color: #6f42c1 !important;
}

.badge.bg-cyan {
    background-color: #0dcaf0 !important;
    color: #000 !important;
}

/* Switches modernos para modal NFe */
.swal2-container .form-switch .form-check-input {
    width: 2.5em;
    height: 1.25em;
    cursor: pointer;
    background-color: #e9ecef;
    border: none;
}

.swal2-container .form-switch .form-check-input:checked {
    background-color: #198754;
}

.swal2-container .form-switch .form-check-input:focus {
    box-shadow: 0 0 0 0.25rem rgba(25, 135, 84, 0.25);
}

.swal2-container .form-check-label {
    font-size: 0.9rem;
    color: #495057;
    cursor: pointer;
}

/* Cards de opções (padrão semelhante ao módulo Pessoas) */
.opcoes-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
    padding: 0 0.5rem;
}

.opcao-card {
    aspect-ratio: 1;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: 0.75rem;
    border: 2px solid #e0e0e0;
    border-radius: 12px;
    background: white;
    cursor: pointer;
    transition: all 0.2s ease-in-out;
    padding: 1rem;
}

.opcao-card i {
    font-size: 2rem;
}

.opcao-card span {
    font-size: 0.9rem;
    font-weight: 600;
    text-align: center;
}

.opcao-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 18px rgba(0, 0, 0, 0.12);
}

.opcao-card-primary {
    border-color: #0d6efd;
    color: #0d6efd;
}

.opcao-card-primary:hover {
    background: #0d6efd;
    color: #fff;
}

.opcao-card-success {
    border-color: #198754;
    color: #198754;
}

.opcao-card-success:hover {
    background: #198754;
    color: #fff;
}

.opcao-card-warning {
    border-color: #ffc107;
    color: #ffc107;
}

.opcao-card-warning:hover {
    background: #ffc107;
    color: #fff;
}

.opcao-card-danger {
    border-color: #dc3545;
    color: #dc3545;
}

.opcao-card-danger:hover {
    background: #dc3545;
    color: #fff;
}

.opcao-card-secondary {
    border-color: #6c757d;
    color: #6c757d;
}

.opcao-card-secondary:hover {
    background: #6c757d;
    color: #fff;
}

.opcao-card-info {
    border-color: #0dcaf0;
    color: #0dcaf0;
}

.opcao-card-info:hover {
    background: #0dcaf0;
    color: #fff;
}

.opcao-card-disabled {
    border-color: #adb5bd;
    color: #adb5bd;
    background: #f8f9fa;
    cursor: default;
    pointer-events: none;
}

.opcao-card-disabled:hover {
    background: #f8f9fa;
    color: #adb5bd;
    transform: none;
    box-shadow: none;
}
</style>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-cart-check me-2"></i> Ordens de Servico</h2>
        <p class="text-muted">Gerencie suas ordens de servico e pedidos</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/ordem-servico/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Nova Ordem de Servico
        </a>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-6">
                <input type="text" class="form-control" name="search" placeholder="Buscar por número, cliente..."
                    value="<?= htmlspecialchars($search ?? '') ?>">
            </div>
            <div class="col-md-3">
                <select class="form-select" name="status">
                    <option value="">Todos os Status</option>
                    <?php
                    $statusOrdens_servico = $statusOrdens_servico ?? [];
                    if (empty($statusOrdens_servico)) {
                        // Fallback: se não houver status cadastrados
                        $statusOrdens_servico = [
                            ['codigo' => 'orcamento', 'nome' => 'Orçamento'],
                            ['codigo' => 'pendente', 'nome' => 'Pendente'],
                            ['codigo' => 'realizado', 'nome' => 'Realizado'],
                            ['codigo' => 'faturamento', 'nome' => 'Faturamento'],
                            ['codigo' => 'expedicao', 'nome' => 'Expedição'],
                            ['codigo' => 'em_entrega', 'nome' => 'Em Entrega'],
                            ['codigo' => 'finalizado', 'nome' => 'Finalizado'],
                        ];
                    }
                    foreach ($statusOrdens_servico as $s) {
                        $selected = (!empty($status) && $status === $s['codigo']) ? 'selected' : '';
                        echo "<option value=\"{$s['codigo']}\" {$selected}>{$s['nome']}</option>\n";
                    }
                    ?>
                </select>
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-secondary w-100">
                    <i class="bi bi-search"></i> Buscar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Lista de Ordens_servico</span>
        <span class="badge bg-primary"><?= count($ordens ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($ordens)): ?>
        <div class="table-responsive">
            <table class="table table-hover mb-0" id="ordens_servico-table">
                <thead>
                    <tr>
                        <th width="60">ID</th>
                        <th>Número</th>
                        <th>Cliente</th>
                        <th>Data</th>
                        <th>Total</th>
                        <th>Status</th>
                        <th>Pagamento</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($ordens as $ordem): ?>
                    <tr style="cursor: pointer;" data-ordem_servico-id="<?= $ordem['id'] ?>"
                        data-ordem_servico-numero="<?= htmlspecialchars($ordem['service_number'], ENT_QUOTES) ?>"
                        data-ordem_servico-cliente="<?= htmlspecialchars($ordem['customer_name'] ?? '', ENT_QUOTES) ?>"
                        data-ordem_servico-documento="<?= htmlspecialchars($ordem['customer_document'] ?? '', ENT_QUOTES) ?>"
                        data-ordem_servico-vendedor="<?= htmlspecialchars($ordem['vendor_name'] ?? '', ENT_QUOTES) ?>"
                        data-ordem_servico-total="<?= formatCurrency($ordem['total'] ?? 0) ?>"
                        data-nfe-emitida="<?= (!empty($ordem['chave_nfe']) && !empty($ordem['protocolo_nfe']) && !empty($ordem['numero_nfe'])) ? 'true' : 'false' ?>"
                        data-nfe-cancelada="<?= (!empty($ordem['protocolo_cancelamento']) && !empty($ordem['data_cancelamento'])) ? 'true' : 'false' ?>"
                        data-pode-emitir-nfe="<?= !empty($podeEmitirNfePorVenda[$ordem['id']]) ? 'true' : 'false' ?>"
                        onclick="abrirOpcoesOrdem_servico(event)">
                        <td><?= $ordem['id'] ?></td>
                        <td><strong><?= htmlspecialchars($ordem['service_number']) ?></strong></td>
                        <td><?= htmlspecialchars($ordem['customer_name'] ?? '-') ?></td>
                        <td><?= date('d/m/Y', strtotime($ordem['service_date'])) ?></td>
                        <td><?= formatCurrency($ordem['total'] ?? 0) ?></td>
                        <td>
                            <?php
                                    $statusBadges = [
                                        'orcamento' => '<span class="badge bg-secondary"><i class="bi bi-file-earmark me-1"></i>Orçamento</span>',
                                        'pendente' => '<span class="badge bg-warning text-dark"><i class="bi bi-clock me-1"></i>Pendente</span>',
                                        'realizado' => '<span class="badge bg-info"><i class="bi bi-check me-1"></i>Realizado</span>',
                                        'faturamento' => '<span class="badge bg-primary"><i class="bi bi-receipt me-1"></i>Faturamento</span>',
                                        'expedicao' => '<span class="badge bg-purple"><i class="bi bi-box-seam me-1"></i>Expedição</span>',
                                        'em_entrega' => '<span class="badge bg-cyan"><i class="bi bi-truck me-1"></i>Em Entrega</span>',
                                        'finalizado' => '<span class="badge bg-success"><i class="bi bi-check-circle me-1"></i>Finalizado</span>'
                                    ];
                                    echo $statusBadges[$ordem['status']] ?? '-';
                                    ?>
                        </td>
                        <td><?= htmlspecialchars($ordem['payment_method_name'] ?? '-') ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="text-center py-5">
            <i class="bi bi-cart-check" style="font-size: 4rem; color: var(--text-secondary);"></i>
            <p class="text-muted mt-3">Nenhuma ordem_servico encontrada</p>
            <a href="<?= url('/ordem-servico/criar') ?>" class="btn btn-primary mt-2">
                <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeira Ordem_servico
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>

<script>
function abrirOpcoesOrdem_servico(event) {
    // Buscar dados da linha da tabela
    const row = event.target.closest('tr');
    if (!row) return;

    const id = row.dataset.ordem_servicoId;
    const numero = row.dataset.ordem_servicoNumero;
    const cliente = row.dataset.ordem_servicoCliente;
    const cnpj = row.dataset.ordem_servicoDocumento;
    const vendedor = row.dataset.ordem_servicoVendedor;
    const total = row.dataset.ordem_servicoTotal;
    const nfeEmitida = row.dataset.nfeEmitida === 'true';
    const nfeCancelada = row.dataset.nfeCancelada === 'true';
    const podeEmitirNfe = row.dataset.podeEmitirNfe === 'true';

    const headerHtml = `
        <div style="background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);
                    padding: 1.5rem;
                    margin: 0 0 1rem 0;
                    border-radius: 12px 12px 0 0;
                    color: white;
                    text-align: left;">
            <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 0.75rem;">
                <div style="background: rgba(255,255,255,0.2);
                            padding: 0.75rem;
                            border-radius: 10px;
                            display: flex;
                            align-items: center;
                            justify-content: center;">
                    <i class="bi bi-cart-check" style="font-size: 1.5rem;"></i>
                </div>
                <div style="flex: 1; padding-right: 3rem;">
                    <div style="font-size: 0.85rem; opacity: 0.9; margin-bottom: 0.25rem;">Pedido</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">${numero}</div>
                </div>
                <div style="text-align: right; min-width: 140px; padding-right: 2.5rem;">
                    <div style="font-size: 0.85rem; opacity: 0.9; margin-bottom: 0.25rem;">Valor Total</div>
                    <div style="font-size: 1.15rem; font-weight: 600;">${total}</div>
                </div>
            </div>
            <div style="background: rgba(255,255,255,0.15);
                        padding: 0.75rem 1rem;
                        border-radius: 8px;
                        display: flex;
                        align-items: center;
                        gap: 0.75rem;">
                <i class="bi bi-person-circle" style="font-size: 1.1rem; opacity: 0.9;"></i>
                <div style="flex: 1;">
                    <strong style="font-size: 0.95rem;">${cliente || 'Cliente não informado'}</strong>
                    ${cnpj ? `
                        <div style="opacity: 0.9; font-size: 0.85rem; margin-top: 0.25rem;">
                            <i class="bi bi-card-text" style="font-size: 0.85rem; margin-right: 0.25rem;"></i>
                            ${cnpj}
                        </div>
                    ` : ''}
                </div>
                ${vendedor ? `
                    <div style="text-align: right; border-left: 1px solid rgba(255,255,255,0.2); padding-left: 0.75rem;">
                        <div style="opacity: 0.8; font-size: 0.75rem; margin-bottom: 0.25rem;">Vendedor</div>
                        <div style="font-size: 0.9rem; font-weight: 600;">
                            <i class="bi bi-person-badge" style="font-size: 0.85rem; margin-right: 0.25rem;"></i>
                            ${vendedor}
                        </div>
                    </div>
                ` : ''}
            </div>
        </div>
    `;

    const gridInicio = '<div class="opcoes-grid">';
    const gridFim = '</div>';

    // Opções sempre disponíveis
    let html = headerHtml + gridInicio + `
        <button type="button" class="opcao-card opcao-card-secondary" onclick="window.location.href=appUrl('/ordem-servico/visualizar?id=${id}')">
            <i class="bi bi-eye"></i>
            <span>Visualizar</span>
        </button>
        <button type="button" class="opcao-card opcao-card-secondary" onclick="window.open(appUrl('/ordem-servico/imprimir?id=${id}'), '_blank')">
            <i class="bi bi-printer-fill"></i>
            <span>Imprimir OS</span>
        </button>
        <button type="button" class="opcao-card opcao-card-primary" onclick="window.open(appUrl('/ordem-servico/imprimir-producao?id=${id}'), '_blank')">
            <i class="bi bi-gear-fill"></i>
            <span>Imprimir Produção</span>
        </button>
        <button type="button" class="opcao-card opcao-card-info" onclick="enviarPorEmail(${id}, '${numero.replace(/'/g, "&#39;")}', '${(cliente||'').replace(/'/g, "&#39;")}')">
            <i class="bi bi-envelope"></i>
            <span>Enviar por Email</span>
        </button>
    `;

    if (nfeEmitida) {
        // NF-e já emitida
        html += `
            <button type="button" class="opcao-card opcao-card-success" onclick="reimprimirNFe(${id})">
                <i class="bi bi-receipt"></i>
                <span>Reimprimir NF-e</span>
            </button>
        `;

        if (nfeCancelada) {
            html += `
                <button type="button" class="opcao-card opcao-card-disabled">
                    <i class="bi bi-slash-circle"></i>
                    <span>NF-e Cancelada</span>
                </button>
            `;
        } else {
            html += `
                <button type="button" class="opcao-card opcao-card-warning" onclick="cartaCorrecaoNFe(${id})">
                    <i class="bi bi-pencil-square"></i>
                    <span>Carta de Correção</span>
                </button>
                <button type="button" class="opcao-card opcao-card-danger" onclick="cancelarNFe(${id})">
                    <i class="bi bi-x-circle"></i>
                    <span>Cancelar NF-e</span>
                </button>
            `;
        }
    } else {
        // NF-e não emitida
        const total = (function() {
            try {
                return parseFloat(document.querySelector(`#ordens_servico-table tbody tr td:nth-child(5)`)
                    ?.innerText?.replace(/[^0-9,.-]/g, '').replace('.', '').replace(',', '.') || '0');
            } catch (e) {
                return 0;
            }
        })();
        html += `
            ${podeEmitirNfe ? `
                <button type="button" class="opcao-card opcao-card-success" onclick="emitirNFe(${id}, '${numero.replace(/'/g, "&#39;")}', '${(cliente||'').replace(/'/g, "&#39;")}', ${isNaN(total)?0:total})">
                    <i class="bi bi-file-earmark-text"></i>
                    <span>Emitir NF-e</span>
                </button>
            ` : `
                <button type="button" class="opcao-card opcao-card-disabled">
                    <i class="bi bi-file-earmark-x"></i>
                    <span>Emitir NF-e</span>
                </button>
            `}
            <button type="button" class="opcao-card opcao-card-primary" onclick="window.location.href=appUrl('/ordem-servico/editar?id=${id}')">
                <i class="bi bi-pencil"></i>
                <span>Editar</span>
            </button>
            <button type="button" class="opcao-card opcao-card-danger" onclick="deletarOrdem_servico(${id})">
                <i class="bi bi-trash"></i>
                <span>Excluir</span>
            </button>
        `;
    }

    html += gridFim;

    Swal.fire({
        html: html,
        showConfirmButton: false,
        showCloseButton: true,
        width: '700px',
        padding: '0',
        customClass: {
            popup: 'swal-ordem_servico-opcoes',
            htmlContainer: 'swal-ordem_servico-container'
        }
    });
}

// Adicionar estilo customizado para o modal
const style = document.createElement('style');
style.textContent = `
    .swal-ordem_servico-opcoes {
        border-radius: 16px;
        overflow: visible !important;
    }
    .swal-ordem_servico-container {
        margin: 0 !important;
        padding: 0 !important;
        overflow: visible !important;
    }
    .swal-ordem_servico-opcoes .swal2-html-container {
        overflow: visible !important;
    }
    .swal-ordem_servico-opcoes .swal2-close {
        color: white !important;
        background: rgba(255,255,255,0.25) !important;
        border-radius: 8px !important;
        width: 36px !important;
        height: 36px !important;
        font-size: 1.5rem !important;
        transition: all 0.2s !important;
        top: 1rem !important;
        right: 1rem !important;
        box-shadow: 0 2px 8px rgba(0,0,0,0.2) !important;
        z-index: 9999 !important;
    }
    .swal-ordem_servico-opcoes .swal2-close:hover {
        background: rgba(255,255,255,0.4) !important;
        transform: scale(1.1) !important;
    }
    .swal-ordem_servico-opcoes .swal2-close:focus {
        box-shadow: 0 0 0 3px rgba(255,255,255,0.3) !important;
    }
    .opcoes-grid {
        padding: 1rem !important;
    }
`;
if (!document.getElementById('swal-ordem_servico-custom-style')) {
    style.id = 'swal-ordem_servico-custom-style';
    document.head.appendChild(style);
}

async function enviarPorEmail(ordem_servicoId, numeroOrdem_servico, clienteNome) {
    // Fechar modal anterior
    Swal.close();

    const {
        value: formValues
    } = await Swal.fire({
        title: '<i class="bi bi-envelope text-info"></i> Enviar Pedido por Email',
        html: `
            <div class="text-start">
                <div class="alert alert-info mb-3">
                    <h6 class="mb-2"><strong>Pedido: ${numeroOrdem_servico}</strong></h6>
                    <p class="mb-0 small">Cliente: ${clienteNome || 'Não informado'}</p>
                </div>

                <div class="mb-3">
                    <label class="form-label">Email do Destinatário *</label>
                    <input type="email" class="form-control" id="email_destinatario"
                           placeholder="exemplo@email.com" required>
                    <small class="text-muted">Insira o email que receberá o pedido</small>
                </div>

                <div class="mb-3">
                    <label class="form-label">Assunto</label>
                    <input type="text" class="form-control" id="assunto_email"
                           value="Pedido ${numeroOrdem_servico} - ${clienteNome || ''}">
                </div>

                <div class="mb-3">
                    <label class="form-label">Mensagem (Opcional)</label>
                    <textarea class="form-control" id="mensagem_email" rows="4"
                              placeholder="Digite uma mensagem personalizada..."></textarea>
                </div>

                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="anexar_pdf" checked>
                    <label class="form-check-label" for="anexar_pdf">
                        Anexar PDF do pedido
                    </label>
                </div>
            </div>
        `,
        width: '600px',
        showCancelButton: true,
        confirmButtonText: '<i class="bi bi-send me-2"></i>Enviar Email',
        cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Cancelar',
        confirmButtonColor: '#0dcaf0',
        cancelButtonColor: '#6c757d',
        preConfirm: () => {
            const email = document.getElementById('email_destinatario').value.trim();
            const assunto = document.getElementById('assunto_email').value.trim();
            const mensagem = document.getElementById('mensagem_email').value.trim();
            const anexarPdf = document.getElementById('anexar_pdf').checked;

            if (!email) {
                Swal.showValidationMessage('O email do destinatário é obrigatório');
                return false;
            }

            // Validação básica de email
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test(email)) {
                Swal.showValidationMessage('Digite um email válido');
                return false;
            }

            return {
                email: email,
                assunto: assunto || `Pedido ${numeroOrdem_servico}`,
                mensagem: mensagem,
                anexar_pdf: anexarPdf
            };
        }
    });

    if (formValues) {
        // Mostrar loading
        Swal.fire({
            title: 'Enviando Email...',
            html: 'Aguarde enquanto enviamos o pedido por email.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // Enviar para o backend
        $.ajax({
            url: appUrl('/ordem-servico/enviar-email'),
            type: 'POST',
            data: {
                ordem_servico_id: ordem_servicoId,
                email: formValues.email,
                assunto: formValues.assunto,
                mensagem: formValues.mensagem,
                anexar_pdf: formValues.anexar_pdf ? 1 : 0
            },
            dataType: 'json',
            success: function(response) {
                Swal.close();
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Email Enviado!',
                        text: response.message || 'Email enviado com sucesso',
                        confirmButtonText: 'OK'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro ao Enviar',
                        text: response.message || 'Não foi possível enviar o email',
                        confirmButtonText: 'OK'
                    });
                }
            },
            error: function(xhr) {
                Swal.close();
                const response = xhr.responseJSON;
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: response?.message || 'Erro ao enviar email. Tente novamente.',
                    confirmButtonText: 'OK'
                });
            }
        });
    }
}

async function deletarOrdem_servico(id) {
    const confirmed = await confirmDelete('Tem certeza que deseja excluir esta ordem_servico?');
    if (confirmed) {
        $.ajax({
            url: appUrl('/ordem-servico/deletar'),
            type: 'POST',
            data: {
                id: id
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Toast.success(response.message);
                    setTimeout(() => location.reload(), 1500);
                } else {
                    Toast.error(response.message);
                }
            }
        });
    }
}

async function previsualizarNFe(ordem_servicoId, numeroOrdem_servico, cliente, total, configs) {
    // Buscar dados completos da ordem_servico
    Swal.fire({
        title: 'Gerando pré-visualização...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    try {
        const response = await $.ajax({
            url: appUrl(`/ordem-servico/buscar-itens?id=${ordem_servicoId}`),
            type: 'GET',
            dataType: 'json'
        });

        let itensDetalhados = '';
        let totalIcms = 0,
            totalPis = 0,
            totalCofins = 0,
            totalIpi = 0;

        if (response.success && response.data && response.data.itens) {
            itensDetalhados = response.data.itens.map((item, idx) => {
                totalIcms += parseFloat(item.valor_icms || 0);
                totalPis += parseFloat(item.valor_pis || 0);
                totalCofins += parseFloat(item.valor_cofins || 0);
                totalIpi += parseFloat(item.valor_ipi || 0);

                return `
                    <tr>
                        <td>${idx + 1}</td>
                        <td>${item.product_name}</td>
                        <td class="text-center">${item.quantity}</td>
                        <td class="text-end">R$ ${parseFloat(item.unit_price).toFixed(2).replace('.', ',')}</td>
                        <td class="text-end">R$ ${parseFloat(item.total_price).toFixed(2).replace('.', ',')}</td>
                    </tr>
                `;
            }).join('');
        }

        const presencaTexto = {
            '0': 'Não se aplica',
            '1': 'Operação presencial',
            '2': 'Internet',
            '3': 'Teleatendimento',
            '4': 'Entrega a domicílio',
            '5': 'Fora do estabelecimento',
            '9': 'Outros'
        };

        Swal.fire({
            title: '<i class="bi bi-eye text-primary"></i> Pré-visualização da NF-e',
            html: `
                <div class="text-start">
                    <!-- Dados da Operação -->
                    <div class="card mb-3">
                        <div class="card-header bg-primary text-white py-2">
                            <strong>Dados da Operação</strong>
                        </div>
                        <div class="card-body p-2">
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <td width="40%"><strong>Número da Ordem_servico:</strong></td>
                                    <td>${numeroOrdem_servico}</td>
                                </tr>
                                <tr>
                                    <td><strong>Cliente:</strong></td>
                                    <td>${cliente}</td>
                                </tr>
                                <tr>
                                    <td><strong>Presença do Comprador:</strong></td>
                                    <td>${presencaTexto[configs.presenca_comprador] || configs.presenca_comprador}</td>
                                </tr>
                                <tr>
                                    <td><strong>Intermediador:</strong></td>
                                    <td>${configs.intermediador === '0' ? 'Não' : 'Sim'}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- Itens -->
                    <div class="card mb-3">
                        <div class="card-header bg-info text-white py-2">
                            <strong>Itens da NF-e</strong>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive" style="max-height: 250px; overflow-y: auto;">
                                <table class="table table-sm table-bordered mb-0">
                                    <thead class="table-light sticky-top">
                                        <tr>
                                            <th width="30">#</th>
                                            <th>Descrição</th>
                                            <th class="text-center" width="60">Qtd</th>
                                            <th class="text-end" width="100">Vlr. Unit.</th>
                                            <th class="text-end" width="100">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        ${itensDetalhados || '<tr><td colspan="5" class="text-center text-muted">Nenhum item</td></tr>'}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Totais -->
                    <div class="card mb-3">
                        <div class="card-header bg-success text-white py-2">
                            <strong>Valores e Impostos</strong>
                        </div>
                        <div class="card-body p-2">
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <td width="60%"><strong>Valor Total dos Produtos:</strong></td>
                                    <td class="text-end"><strong>R$ ${parseFloat(total).toFixed(2).replace('.', ',')}</strong></td>
                                </tr>
                                ${configs.exibir_pis_cofins_danfe ? `
                                <tr class="text-success">
                                    <td>ICMS Total:</td>
                                    <td class="text-end">R$ ${totalIcms.toFixed(2).replace('.', ',')}</td>
                                </tr>
                                <tr class="text-success">
                                    <td>PIS Total:</td>
                                    <td class="text-end">R$ ${totalPis.toFixed(2).replace('.', ',')}</td>
                                </tr>
                                <tr class="text-success">
                                    <td>COFINS Total:</td>
                                    <td class="text-end">R$ ${totalCofins.toFixed(2).replace('.', ',')}</td>
                                </tr>
                                ` : ''}
                                <tr>
                                    <td>IPI Total:</td>
                                    <td class="text-end">R$ ${totalIpi.toFixed(2).replace('.', ',')}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- Opções Configuradas -->
                    <div class="card">
                        <div class="card-header bg-secondary text-white py-2">
                            <strong>Opções Configuradas</strong>
                        </div>
                        <div class="card-body p-2">
                            <div class="row">
                                <div class="col-6">
                                    ${configs.base_pis_cofins_icms ? '✓' : '✗'} Base PIS/COFINS c/ ICMS
                                </div>
                                <div class="col-6">
                                    ${configs.exibir_pis_cofins_danfe ? '✓' : '✗'} Exibir PIS/COFINS DANFE
                                </div>
                                <div class="col-6">
                                    ${configs.subtrair_icms_desonerado ? '✓' : '✗'} Subtrair ICMS Desonerado
                                </div>
                                <div class="col-6">
                                    ${configs.exibir_financeiro ? '✓' : '✗'} Exibir Financeiro
                                </div>
                                <div class="col-12 mt-2">
                                    ${configs.enviar_por_email ? '<span class="text-success"><i class="bi bi-envelope me-1"></i>Enviar por E-mail</span>' : '<span class="text-muted">Não enviar por e-mail</span>'}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `,
            width: '800px',
            showConfirmButton: true,
            showCancelButton: true,
            confirmButtonText: '<i class="bi bi-arrow-left me-2"></i>Voltar',
            cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Fechar',
            confirmButtonColor: '#6c757d',
            cancelButtonColor: '#dc3545'
        }).then((result) => {
            if (result.isConfirmed) {
                // Voltar para o modal de configuração
                emitirNFe(ordem_servicoId, numeroOrdem_servico, cliente, total);
            }
        });

    } catch (error) {
        Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: 'Não foi possível carregar a pré-visualização.',
            confirmButtonText: 'OK'
        });
    }
}

async function emitirNFe(ordem_servicoId, numeroOrdem_servico, cliente, total) {
    // Buscar itens da ordem_servico primeiro
    Swal.fire({
        title: 'Carregando...',
        text: 'Buscando dados da ordem_servico',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    let itensHtml = '<p class="text-muted">Nenhum item encontrado</p>';

    try {
        console.log('Buscando itens da ordem_servico #' + ordem_servicoId);

        const response = await $.ajax({
            url: appUrl(`/ordem-servico/buscar-itens?id=${ordem_servicoId}`),
            type: 'GET',
            dataType: 'json'
        });

        console.log('Resposta completa:', response);
        console.log('response.success:', response.success);
        console.log('response.data:', response.data);
        console.log('response.data.itens:', response.data?.itens);

        if (response.success && response.data && response.data.itens && response.data.itens.length > 0) {
            console.log('✓ Itens encontrados! Total:', response.data.itens.length);
            itensHtml = `
                <div class="table-responsive" style="max-height: 200px; overflow-y: auto;">
                    <table class="table table-sm table-bordered mb-0">
                        <thead class="table-light sticky-top">
                            <tr>
                                <th>Produto</th>
                                <th class="text-center">Qtd</th>
                                <th class="text-end">Valor Unit.</th>
                                <th class="text-end">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${response.data.itens.map(item => `
                                <tr>
                                    <td>${item.product_name}</td>
                                    <td class="text-center">${item.quantity}</td>
                                    <td class="text-end">R$ ${parseFloat(item.unit_price).toFixed(2).replace('.', ',')}</td>
                                    <td class="text-end">R$ ${parseFloat(item.total_price).toFixed(2).replace('.', ',')}</td>
                                </tr>
                            `).join('')}
                        </tbody>
                    </table>
                </div>
            `;
        } else {
            console.log('✗ Nenhum item encontrado ou resposta inválida');
        }
    } catch (error) {
        console.error('❌ ERRO ao buscar itens:', error);
        console.error('Status:', error.status);
        console.error('ResponseText:', error.responseText);
        itensHtml = '<p class="text-danger">Erro ao carregar itens da ordem_servico</p>';
    }

    Swal.close();

    const {
        value: formValues
    } = await Swal.fire({
        title: '<i class="bi bi-file-earmark-text text-success"></i> Emitir NF-e',
        html: `
            <div class="text-start">
                <!-- Resumo da Ordem_servico -->
                <div class="alert alert-info mb-3">
                    <h6 class="mb-2"><strong>Resumo da Ordem_servico</strong></h6>
                    <div class="row">
                        <div class="col-6"><strong>Número:</strong> ${numeroOrdem_servico}</div>
                        <div class="col-6"><strong>Cliente:</strong> ${cliente}</div>
                        <div class="col-12 mt-2"><strong>Total:</strong> R$ ${parseFloat(total).toFixed(2).replace('.', ',')}</div>
                    </div>
                </div>

                <!-- Itens da Ordem_servico -->
                <div class="mb-3">
                    <h6 class="mb-2"><i class="bi bi-box-seam me-2"></i><strong>Itens da Ordem_servico</strong></h6>
                    ${itensHtml}
                </div>

                <!-- Configurações da NF-e -->
                <h6 class="mb-3 text-primary"><i class="bi bi-gear me-2"></i>Configurações da NF-e</h6>

                <div class="row">
                    <!-- Coluna Esquerda -->
                    <div class="col-md-6">
                        <!-- Presença do Comprador -->
                        <div class="mb-3">
                            <label class="form-label small text-muted mb-1">Presença do Comprador</label>
                            <select class="form-select form-select-sm" id="presenca_comprador">
                                <option value="0">0 - Não se aplica</option>
                                <option value="1" selected>1 - Operação presencial</option>
                                <option value="2">2 - Internet</option>
                                <option value="3">3 - Teleatendimento</option>
                                <option value="4">4 - Entrega a domicílio</option>
                                <option value="5">5 - Fora do estabelecimento</option>
                                <option value="9">9 - Outros</option>
                            </select>
                        </div>

                        <!-- Intermediador -->
                        <div class="mb-3">
                            <label class="form-label small text-muted mb-1">Intermediador</label>
                            <select class="form-select form-select-sm" id="intermediador">
                                <option value="0" selected>0 - Sem intermediador</option>
                                <option value="1">1 - Com intermediador</option>
                            </select>
                        </div>
                    </div>

                    <!-- Coluna Direita - Checkboxes Modernos -->
                    <div class="col-md-6">
                        <label class="form-label small text-muted mb-2">Opções da NF-e</label>

                        <!-- Switch Base PIS/COFINS -->
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" role="switch" id="base_pis_cofins_icms" checked>
                            <label class="form-check-label" for="base_pis_cofins_icms">
                                Base PIS/COFINS c/ ICMS
                            </label>
                        </div>

                        <!-- Switch Exibir PIS/COFINS -->
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" role="switch" id="exibir_pis_cofins_danfe" checked>
                            <label class="form-check-label" for="exibir_pis_cofins_danfe">
                                Exibir PIS/COFINS DANFE
                            </label>
                        </div>

                        <!-- Switch Subtrair ICMS -->
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" role="switch" id="subtrair_icms_desonerado">
                            <label class="form-check-label" for="subtrair_icms_desonerado">
                                Subtrair ICMS Desonerado
                            </label>
                        </div>

                        <!-- Switch Exibir Financeiro -->
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" role="switch" id="exibir_financeiro" checked>
                            <label class="form-check-label" for="exibir_financeiro">
                                Exibir Financeiro DANFE
                            </label>
                        </div>

                        <!-- Switch Enviar por Email - NOVO -->
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input" type="checkbox" role="switch" id="enviar_por_email" checked>
                            <label class="form-check-label" for="enviar_por_email">
                                <i class="bi bi-envelope me-1"></i>Enviar por E-mail
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        `,
        width: '700px',
        showCancelButton: true,
        showDenyButton: true,
        confirmButtonText: '<i class="bi bi-check-circle me-2"></i>Emitir NF-e',
        denyButtonText: '<i class="bi bi-eye me-2"></i>Pré-visualizar',
        cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Cancelar',
        confirmButtonColor: '#198754',
        denyButtonColor: '#0d6efd',
        cancelButtonColor: '#6c757d',
        preConfirm: () => {
            // Validação antes de emitir
            const presencaComprador = document.getElementById('presenca_comprador').value;
            const intermediador = document.getElementById('intermediador').value;

            if (!presencaComprador) {
                Swal.showValidationMessage('Selecione a presença do comprador');
                return false;
            }

            return {
                presenca_comprador: presencaComprador,
                intermediador: intermediador,
                base_pis_cofins_icms: document.getElementById('base_pis_cofins_icms').checked,
                exibir_pis_cofins_danfe: document.getElementById('exibir_pis_cofins_danfe').checked,
                subtrair_icms_desonerado: document.getElementById('subtrair_icms_desonerado').checked,
                exibir_financeiro: document.getElementById('exibir_financeiro').checked,
                enviar_por_email: document.getElementById('enviar_por_email').checked
            }
        },
        preDeny: () => {
            // Capturar dados para pré-visualização
            const configs = {
                presenca_comprador: document.getElementById('presenca_comprador').value,
                intermediador: document.getElementById('intermediador').value,
                base_pis_cofins_icms: document.getElementById('base_pis_cofins_icms').checked,
                exibir_pis_cofins_danfe: document.getElementById('exibir_pis_cofins_danfe').checked,
                subtrair_icms_desonerado: document.getElementById('subtrair_icms_desonerado')
                    .checked,
                exibir_financeiro: document.getElementById('exibir_financeiro').checked,
                enviar_por_email: document.getElementById('enviar_por_email').checked
            };

            // Chamar pré-visualização e prevenir o fechamento do modal
            previsualizarNFe(ordem_servicoId, numeroOrdem_servico, cliente, total, configs);
            return false; // Previne fechamento do modal
        }
    });

    if (formValues) {
        // Mostra loading
        Swal.fire({
            title: 'Emitindo NF-e...',
            html: 'Aguarde enquanto geramos a nota fiscal eletrônica.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // Envia para o backend
        $.ajax({
            url: appUrl('/ordem-servico/emitir-nfe'),
            type: 'POST',
            data: {
                ordem_servico_id: ordem_servicoId,
                ...formValues
            },
            dataType: 'json',
            success: function(response) {
                Swal.close();
                if (response.success) {
                    const data = response.data || {};
                    const numeroNfe = data.numero_nfe || response.numero_nfe || 'N/A';
                    const chaveNfe = data.chave_nfe || response.chave_nfe || 'N/A';
                    const protocolo = data.protocolo || data.protocolo_nfe || response.protocolo ||
                        'N/A';
                    const pdfPath = data.pdf_path || '';

                    let htmlContent = `
                        <div class="text-start">
                            <p><strong>Número:</strong> ${numeroNfe}</p>
                            <p><strong>Chave de Acesso:</strong> <small>${chaveNfe}</small></p>
                            <p><strong>Protocolo:</strong> ${protocolo}</p>
                    `;

                    htmlContent += `</div>`;

                    Swal.fire({
                        icon: 'success',
                        title: '✅ NF-e Emitida com Sucesso!',
                        html: htmlContent,
                        confirmButtonText: 'OK',
                        width: '600px'
                    }).then(() => {
                        // CORREÇÃO: Abrir PDF automaticamente ao invés de apenas mostrar botão
                        if (pdfPath) {
                            window.open(pdfPath, '_blank');
                        }
                        location.reload();
                    });

                    // CORREÇÃO: Abrir PDF imediatamente após exibir SweetAlert
                    // Não aguardar confirmação do usuário
                    if (pdfPath) {
                        setTimeout(() => {
                            window.open(pdfPath, '_blank');
                        }, 500);
                    }
                } else {
                    // Extrair detalhes do erro
                    const errorMessage = response.message || 'Erro desconhecido';
                    const cStat = response.data?.cStat || '';

                    // Montar HTML com detalhes
                    let errorHtml = `
                        <div class="text-start">
                            <p><strong>Erro:</strong> ${errorMessage}</p>
                    `;

                    if (cStat) {
                        errorHtml +=
                            `<p class="text-danger"><strong>Código SEFAZ:</strong> ${cStat}</p>`;
                    }

                    // Verificar se tem detalhes específicos
                    if (response.data && response.data.motivo) {
                        errorHtml +=
                            `<p class="text-danger mt-2"><strong>Motivo da Rejeição:</strong><br>${response.data.motivo}</p>`;
                    }

                    errorHtml += `</div>`;

                    Swal.fire({
                        icon: 'error',
                        title: '❌ Erro ao Emitir NF-e',
                        html: errorHtml,
                        confirmButtonText: 'Entendi',
                        width: '600px'
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close();

                let errorMessage = 'Não foi possível conectar ao servidor.';
                let errorDetails = '';

                // Tentar extrair mensagem do erro
                if (xhr.responseJSON) {
                    const json = xhr.responseJSON;
                    errorMessage = json.message || errorMessage;
                    errorDetails = json.errors ? JSON.stringify(json.errors) : '';
                }

                Swal.fire({
                    icon: 'error',
                    title: '❌ Erro de Conexão',
                    html: `
                        <div class="text-start">
                            <p><strong>${errorMessage}</strong></p>
                            ${errorDetails ? `<p class="text-muted small mt-2"><code>${errorDetails}</code></p>` : ''}
                        </div>
                    `,
                    confirmButtonText: 'OK',
                    width: '600px'
                });
            }
        });
    }
}

// Função para pré-visualizar DANFE
async function previsualizarNFe(ordem_servicoId, numeroOrdem_servico, cliente, total, configs) {
    try {
        // Mostrar loading
        Swal.fire({
            title: 'Gerando Preview...',
            html: 'Aguarde enquanto geramos o preview do DANFE.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // Fazer requisição para preview
        const params = new URLSearchParams({
            id: String(ordem_servicoId),
            presenca_comprador: String(configs?.presenca_comprador ?? ''),
            intermediador: String(configs?.intermediador ?? ''),
            base_pis_cofins_icms: (configs?.base_pis_cofins_icms ? '1' : '0'),
            exibir_pis_cofins_danfe: (configs?.exibir_pis_cofins_danfe ? '1' : '0'),
            subtrair_icms_desonerado: (configs?.subtrair_icms_desonerado ? '1' : '0'),
            exibir_financeiro: (configs?.exibir_financeiro ? '1' : '0'),
            enviar_por_email: (configs?.enviar_por_email ? '1' : '0')
        });
        const response = await fetch(appUrl(`/ordem-servico/preview-danfe?${params.toString()}`), {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            }
        });

        const raw = await response.text();
        let data;
        try {
            data = JSON.parse(raw);
        } catch (e) {
            throw new Error(raw.substring(0, 500));
        }

        if (data.success) {
            // Fechar loading e abrir PDF imediatamente
            Swal.close();
            if (data.pdf_url) {
                window.open(data.pdf_url, '_blank');
            }
            return;
        } else {
            // Mostrar erro
            Swal.fire({
                icon: 'error',
                title: 'Erro ao Gerar Preview',
                text: data.error || 'Erro desconhecido ao gerar preview do DANFE.',
                confirmButtonText: 'OK'
            });
        }

    } catch (error) {
        console.error('Erro ao gerar preview:', error);
        Swal.fire({
            icon: 'error',
            title: 'Erro de Conexão',
            text: 'Erro ao conectar com o servidor. Tente novamente.',
            confirmButtonText: 'OK'
        });
    }
}

// Função para reimprimir NF-e
async function reimprimirNFe(ordem_servicoId) {
    Swal.fire({
        title: 'Buscando DANFE...',
        text: 'Aguarde enquanto carregamos o PDF',
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
    });

    $.ajax({
        url: appUrl('/ordem-servico/reimprimir-nfe?id=' + ordem_servicoId),
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            Swal.close();

            // Verificar se a resposta foi bem-sucedida
            if (response.success && response.data) {
                // Tentar usar pdf_path primeiro, depois pdf_path_alternativo
                let pdfUrl = response.data.pdf_path || response.data.pdf_path_alternativo;

                if (pdfUrl) {
                    // Garantir que a URL seja absoluta se necessário
                    if (pdfUrl.startsWith('/')) {
                        pdfUrl = window.location.origin + pdfUrl;
                    }

                    console.log('Abrindo DANFE:', pdfUrl);

                    // Método mais confiável: criar link temporário e clicar nele
                    // Isso evita bloqueio de popup
                    const link = document.createElement('a');
                    link.href = pdfUrl;
                    link.target = '_blank';
                    link.rel = 'noopener noreferrer';
                    document.body.appendChild(link);
                    link.click();
                    document.body.removeChild(link);

                    // Mostrar mensagem de sucesso
                    Swal.fire({
                        icon: 'success',
                        title: 'DANFE Aberto',
                        text: 'O DANFE foi aberto em uma nova aba.',
                        timer: 2000,
                        showConfirmButton: false
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Caminho do PDF não encontrado na resposta'
                    });
                }
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: response.message || 'PDF não encontrado'
                });
            }
        },
        error: function(xhr) {
            Swal.close();
            const response = xhr.responseJSON;
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: response?.message || 'Erro ao buscar PDF'
            });
        }
    });
}

// Função para Carta de Correção
async function cartaCorrecaoNFe(ordem_servicoId) {
    Swal.fire({
        title: 'Carta de Correção Eletrônica',
        html: `
            <div class="text-start">
                <div class="mb-3">
                    <label class="form-label">Campo a Corrigir</label>
                    <select class="form-select" id="campo_correcao">
                        <option value="00">Descrição do produto/serviço</option>
                        <option value="01">Quantidade do produto/serviço</option>
                        <option value="02">Valor unitário do produto/serviço</option>
                        <option value="03">Valor total do produto/serviço</option>
                        <option value="04">Código da NCM</option>
                        <option value="05">Código CFOP</option>
                        <option value="06">Código CEST</option>
                        <option value="07">Dados do cliente</option>
                        <option value="08">Outros</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Correção *</label>
                    <textarea class="form-control" id="correcao" rows="4" placeholder="Descreva a correção necessária..." required></textarea>
                    <small class="text-muted">Máximo 1000 caracteres</small>
                </div>
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Enviar Carta de Correção',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#ffc107',
        preConfirm: () => {
            const campo = document.getElementById('campo_correcao').value;
            const correcao = document.getElementById('correcao').value.trim();

            if (!correcao) {
                Swal.showValidationMessage('A correção é obrigatória');
                return false;
            }

            if (correcao.length > 1000) {
                Swal.showValidationMessage('A correção deve ter no máximo 1000 caracteres');
                return false;
            }

            return {
                campo,
                correcao
            };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const {
                campo,
                correcao
            } = result.value;

            Swal.fire({
                title: 'Enviando Carta de Correção...',
                allowOutsideClick: false,
                didOpen: () => Swal.showLoading()
            });

            $.ajax({
                url: appUrl('/ordem-servico/carta-correcao-nfe'),
                type: 'POST',
                data: {
                    ordem_servico_id: ordem_servicoId,
                    campo_correcao: campo,
                    correcao: correcao
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Carta de Correção Enviada!',
                            text: response.message ||
                                'Carta de correção enviada com sucesso',
                            confirmButtonText: 'OK'
                        }).then(() => location.reload());
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: response.message || 'Erro ao enviar carta de correção'
                        });
                    }
                },
                error: function(xhr) {
                    const response = xhr.responseJSON;
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response?.message || 'Erro ao enviar carta de correção'
                    });
                }
            });
        }
    });
}

// Função para Cancelar NF-e
async function cancelarNFe(ordem_servicoId) {
    Swal.fire({
        title: 'Cancelar NF-e',
        html: `
            <div class="text-start">
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <strong>Atenção!</strong> O cancelamento de NF-e é irreversível e deve ser feito em até 30 dias após a autorização.
                </div>
                <div class="mb-3">
                    <label class="form-label">Justificativa do Cancelamento *</label>
                    <textarea class="form-control" id="justificativa" rows="4" placeholder="Descreva o motivo do cancelamento..." required></textarea>
                    <small class="text-muted">Mínimo 15 caracteres</small>
                </div>
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Confirmar Cancelamento',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#dc3545',
        preConfirm: () => {
            const justificativa = document.getElementById('justificativa').value.trim();

            if (!justificativa) {
                Swal.showValidationMessage('A justificativa é obrigatória');
                return false;
            }

            if (justificativa.length < 15) {
                Swal.showValidationMessage('A justificativa deve ter no mínimo 15 caracteres');
                return false;
            }

            return {
                justificativa
            };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const {
                justificativa
            } = result.value;

            // Segunda confirmação
            Swal.fire({
                title: 'Confirmar Cancelamento?',
                text: 'Esta ação não pode ser desfeita!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Sim, Cancelar NF-e',
                cancelButtonText: 'Não, Manter',
                confirmButtonColor: '#dc3545'
            }).then((confirmResult) => {
                if (confirmResult.isConfirmed) {
                    Swal.fire({
                        title: 'Cancelando NF-e...',
                        allowOutsideClick: false,
                        didOpen: () => Swal.showLoading()
                    });

                    $.ajax({
                        url: appUrl('/ordem-servico/cancelar-nfe'),
                        type: 'POST',
                        data: {
                            ordem_servico_id: ordem_servicoId,
                            justificativa: justificativa
                        },
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'NF-e Cancelada!',
                                    text: response.message ||
                                        'NF-e cancelada com sucesso',
                                    confirmButtonText: 'OK'
                                }).then(() => location.reload());
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Erro ao Cancelar',
                                    html: `
                                        <div class="text-start">
                                            <p>${response.message || 'Erro desconhecido'}</p>
                                            ${response.data?.cStat ? `<p class="text-danger"><strong>Código SEFAZ:</strong> ${response.data.cStat}</p>` : ''}
                                        </div>
                                    `,
                                    confirmButtonText: 'OK',
                                    width: '600px'
                                });
                            }
                        },
                        error: function(xhr) {
                            const response = xhr.responseJSON;
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: response?.message ||
                                    'Erro ao cancelar NF-e'
                            });
                        }
                    });
                }
            });
        }
    });
}

// Função para visualizar PDF de cancelamento
function visualizarPdfCancelamento(chaveNfe) {
    if (!chaveNfe) {
        Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: 'Chave de acesso não encontrada'
        });
        return;
    }

    const url = appUrl(`/ordem-servico/visualizar-pdf-cancelamento?chave=${encodeURIComponent(chaveNfe)}`);
    window.open(url, '_blank');
}

// Função para visualizar XML de cancelamento
function visualizarXmlCancelamento(xmlPath) {
    if (!xmlPath) {
        Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: 'XML de cancelamento não encontrado'
        });
        return;
    }

    // Converter caminho relativo para absoluto se necessário
    let url = xmlPath;
    if (xmlPath.startsWith('/pontti_nfe/')) {
        url = xmlPath.replace('/pontti_nfe/', '/src/Integrations/NFe/');
    }

    // Abrir XML em nova aba
    window.open(url, '_blank');
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'ordens_servico';
include ROOT_PATH . '/views/layouts/app.php';
?>