<?php
$isEdit = isset($ordem['id']);
?>

<!-- Abas -->
<ul class="nav nav-tabs mb-4" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados" type="button"
            role="tab">
            <i class="bi bi-file-earmark-text me-2"></i> Dados da Ordem Servico
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="itens-tab" data-bs-toggle="tab" data-bs-target="#itens" type="button" role="tab">
            <i class="bi bi-cart-plus me-2"></i> Itens
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="despesas-tab" data-bs-toggle="tab" data-bs-target="#despesas" type="button"
            role="tab">
            <i class="bi bi-receipt me-2"></i> Despesas
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="entrega-tab" data-bs-toggle="tab" data-bs-target="#entrega" type="button"
            role="tab">
            <i class="bi bi-truck me-2"></i> Entrega
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pagamento-tab" data-bs-toggle="tab" data-bs-target="#pagamento" type="button"
            role="tab">
            <i class="bi bi-credit-card me-2"></i> Pagamento e Valores
        </button>
    </li>
</ul>

<!-- Conteúdo das Abas -->
<div class="tab-content">
    <!-- Aba: Dados da Ordem de Serviço -->
    <div class="tab-pane fade show active" id="dados" role="tabpanel">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-file-earmark-text me-2"></i> Informações Principais
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="service_number" class="form-label">Número da Ordem de Serviço *</label>
                                <input type="text" readonly class="form-control bg-light" id="service_number"
                                    name="service_number"
                                    value="<?= htmlspecialchars($ordem['service_number'] ?? $proximoNumero ?? 'OS-000001') ?>"
                                    title="Gerado automaticamente" required>
                                <small class="text-muted">Gerado automaticamente</small>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="service_date" class="form-label">Data da Ordem de Serviço *</label>
                                <input type="date" class="form-control" id="service_date" name="service_date"
                                    value="<?= $ordem['service_date'] ?? date('Y-m-d') ?>" required>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="status" class="form-label">Status *</label>
                                <select class="form-select" id="status" name="status" required>
                                    <?php
                                    $statusOrdens_servico = $statusOrdens_servico ?? [];
                                    $statusAtual = $ordem['status'] ?? ($statusPadrao ?? 'orcamento');

                                    if (empty($statusOrdens_servico)) {
                                        // Fallback: se não houver status cadastrados, usar os padrões
                                        $statusOrdens_servico = [
                                            ['codigo' => 'orcamento', 'nome' => 'Orçamento'],
                                            ['codigo' => 'pendente', 'nome' => 'Pendente'],
                                            ['codigo' => 'realizado', 'nome' => 'Realizado'],
                                            ['codigo' => 'faturamento', 'nome' => 'Faturamento'],
                                            ['codigo' => 'expedicao', 'nome' => 'Expedição'],
                                            ['codigo' => 'em_entrega', 'nome' => 'Em Entrega'],
                                            ['codigo' => 'finalizado', 'nome' => 'Finalizado'],
                                        ];
                                    }

                                    foreach ($statusOrdens_servico as $status) {
                                        $codigo = $status['codigo'];
                                        $nome = $status['nome'];
                                        $selected = ($statusAtual === $codigo) ? 'selected' : '';
                                        echo "<option value=\"{$codigo}\" {$selected}>{$nome}</option>\n";
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Cliente com Autocomplete -->
                        <h6 class="text-primary mb-3">
                            <i class="bi bi-person me-2"></i> Cliente
                        </h6>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="customer_search" class="form-label">
                                    Cliente
                                    <small class="text-muted">(Digite para buscar ou deixe vazio para Consumidor
                                        Final)</small>
                                </label>
                                <div class="position-relative">
                                    <input type="text" class="form-control" id="customer_search"
                                        placeholder="Digite nome, razão social ou CNPJ/CPF do cliente..."
                                        autocomplete="off"
                                        value="<?= htmlspecialchars($ordem['customer_name'] ?? '') ?>">
                                    <div id="customer_dropdown" class="autocomplete-dropdown" style="display: none;">
                                    </div>
                                </div>
                                <input type="hidden" id="customer_id" name="customer_id"
                                    value="<?= $ordem['customer_id'] ?? '' ?>">
                                <input type="hidden" id="customer_type" name="customer_type"
                                    value="<?= $ordem['customer_type'] ?? 'pessoa' ?>">
                                <input type="hidden" id="customer_name" name="customer_name"
                                    value="<?= htmlspecialchars($ordem['customer_name'] ?? '') ?>">
                                <input type="hidden" id="customer_document" name="customer_document"
                                    value="<?= htmlspecialchars($ordem['customer_document'] ?? '') ?>">
                            </div>
                            <div class="col-md-12" id="customer_info" style="display: none;">
                                <div class="alert alert-info mb-3">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="flex-grow-1">
                                            <div id="customer_info_name"></div>
                                        </div>
                                        <button type="button" class="btn btn-sm btn-outline-danger ms-2"
                                            onclick="limparCliente()">
                                            <i class="bi bi-x"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Vendedores -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="vendor_id" class="form-label">
                                    <i class="bi bi-person-badge me-1"></i> Vendedor Principal
                                </label>
                                <select class="form-select" id="vendor_id" name="vendor_id">
                                    <option value="">Nenhum</option>
                                    <?php if (!empty($vendedores)): ?>
                                    <?php foreach ($vendedores as $vendedor): ?>
                                    <option value="<?= $vendedor['id'] ?>"
                                        <?= ($ordem['vendor_id'] ?? '') == $vendedor['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($vendedor['name']) ?>
                                    </option>
                                    <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="auxiliary_vendor_id" class="form-label">
                                    <i class="bi bi-person-plus me-1"></i> Vendedor Auxiliar
                                </label>
                                <select class="form-select" id="auxiliary_vendor_id" name="auxiliary_vendor_id">
                                    <option value="">Nenhum</option>
                                    <?php if (!empty($vendedores)): ?>
                                    <?php foreach ($vendedores as $vendedor): ?>
                                    <option value="<?= $vendedor['id'] ?>"
                                        <?= ($ordem['auxiliary_vendor_id'] ?? '') == $vendedor['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($vendedor['name']) ?>
                                    </option>
                                    <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="notes" class="form-label">Observações</label>
                                <textarea class="form-control" id="notes" name="notes" rows="3"
                                    placeholder="Observações sobre esta Ordem de Serviço..."><?= htmlspecialchars($ordem['notes'] ?? '') ?></textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="observacoes_nfe" class="form-label">
                                    <i class="bi bi-file-earmark-text me-1"></i>
                                    Observações NF-e
                                </label>
                                <textarea class="form-control" id="observacoes_nfe" name="observacoes_nfe" rows="3"
                                    placeholder="Observações específicas que aparecerão na NF-e (ex: informações fiscais, complementares, etc.)..."><?= htmlspecialchars($ordem['observacoes_nfe'] ?? '') ?></textarea>
                                <small class="text-muted">
                                    <i class="bi bi-info-circle me-1"></i>
                                    Estas observações aparecerão na NF-e emitida
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Itens da Ordem de Serviço -->
    <div class="tab-pane fade" id="itens" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-cart-plus me-2"></i> Produtos/Serviços
            </div>
            <div class="card-body">
                <!-- Bloco fixo para adicionar item -->
                <div class="card bg-light mb-4" id="bloco-adicionar-item">
                    <div class="card-body">
                        <h6 class="mb-3"><i class="bi bi-plus-circle me-2"></i> Adicionar Item</h6>
                        <div class="row">
                            <div class="col-md-10 mb-3">
                                <label class="form-label">Item</label>
                                <div class="position-relative">
                                    <input type="text" class="form-control item-search" id="item_search_principal"
                                        placeholder="Digite para buscar produto/serviço..." autocomplete="off">
                                    <div id="item_dropdown_principal" class="autocomplete-dropdown"
                                        style="display: none;"></div>
                                </div>
                                <input type="hidden" id="produto_id_principal" value="">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">Imagem</label>
                                <input type="file" class="form-control form-control-sm" id="imagem_principal"
                                    accept="image/*" onchange="processarImagemItem(this)">
                                <input type="hidden" id="imagem_base64_principal">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-1 mb-2">
                                <label class="form-label small">Altura (m)</label>
                                <input type="number" class="form-control form-control-sm text-center"
                                    id="altura_principal" name="altura_principal" min="0" step="0.01" value=""
                                    placeholder="Opcional" onchange="calcularM2Principal()">
                            </div>
                            <div class="col-md-1 mb-2">
                                <label class="form-label small">Largura (m)</label>
                                <input type="number" class="form-control form-control-sm text-center"
                                    id="largura_principal" name="largura_principal" min="0" step="0.01" value=""
                                    placeholder="Opcional" onchange="calcularM2Principal()">
                            </div>
                            <div class="col-md-1 mb-2">
                                <label class="form-label small">M²</label>
                                <input type="number"
                                    class="form-control form-control-sm text-center bg-light"
                                    id="m2_principal" min="0" step="0.001" value="0" readonly
                                    title="Calculado: Altura × Largura">
                            </div>
                            <div class="col-md-1 mb-2">
                                <label class="form-label small">Qtd</label>
                                <input type="number" class="form-control form-control-sm text-center"
                                    id="quantidade_principal" min="1" step="1" value="1"
                                    title="Quantidade de itens">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Preço Unit. (R$)</label>
                                <input type="number" class="form-control form-control-sm preco-unitario"
                                    id="preco_principal" step="0.01" min="0" value="0">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Total (R$)</label>
                                <input type="number" class="form-control form-control-sm total-item fw-bold"
                                    id="total_principal" step="0.01" readonly value="0">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Obs.</label>
                                <input type="text" class="form-control form-control-sm" id="obs_principal"
                                    placeholder="Obs">
                            </div>
                            <div class="col-md-1 mb-2">
                                <label class="form-label small">&nbsp;</label>
                                <button type="button" class="btn btn-sm btn-success w-100"
                                    onclick="adicionarItemNaTabela()">
                                    <i class="bi bi-plus-circle me-1"></i> Add
                                </button>
                            </div>
                        </div>
                        <div class="row" id="preview_imagem_principal" style="display: none;">
                            <div class="col-12">
                                <div class="alert alert-info p-2 d-flex align-items-center justify-content-between">
                                    <div class="d-flex align-items-center">
                                        <img id="img_preview_principal" src=""
                                            style="max-height: 50px; max-width: 100px;" class="me-2 rounded">
                                        <small id="img_info_principal"></small>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-danger"
                                        onclick="removerImagemPrincipal()">
                                        <i class="bi bi-x"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tabela de itens adicionados -->
                <div id="tabela-itens">
                    <table class="table table-hover table-sm">
                        <thead class="table-light">
                            <tr>
                                <th width="23%">Item</th>
                                <th width="5%" class="text-center">Img</th>
                                <th width="5%" class="text-center">Altura</th>
                                <th width="5%" class="text-center">Largura</th>
                                <th width="5%" class="text-center">M²</th>
                                <th width="5%" class="text-center">Qtd</th>
                                <th width="8%" class="text-end">Unit.</th>
                                <th width="9%" class="text-end">Total</th>
                                <th width="17%">Obs.</th>
                                <th width="10%"></th>
                            </tr>
                        </thead>
                        <tbody id="tbody-itens">
                            <!-- Itens serão adicionados aqui -->
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="7" class="text-end"><strong>Total:</strong></td>
                                <td class="text-end"><strong id="total-geral">R$ 0,00</strong></td>
                                <td colspan="2"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="alert alert-info" id="alert-sem-itens">
                    <i class="bi bi-info-circle me-2"></i>
                    Nenhum item adicionado. Use o formulário acima para adicionar itens.
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Despesas -->
    <div class="tab-pane fade" id="despesas" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-receipt me-2"></i> Despesas Adicionais
            </div>
            <div class="card-body">
                <!-- Bloco para adicionar despesa -->
                <div class="card bg-light mb-4">
                    <div class="card-body">
                        <h6 class="mb-3"><i class="bi bi-plus-circle me-2"></i> Adicionar Despesa</h6>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="despesa_tipo" class="form-label">Tipo de Despesa</label>
                                <select class="form-select" id="despesa_tipo">
                                    <option value="">Selecione...</option>
                                    <option value="comissao">Comissão</option>
                                    <option value="frete">Frete</option>
                                    <option value="taxa_administrativa">Taxa Administrativa</option>
                                    <option value="embalagem">Embalagem</option>
                                    <option value="seguro">Seguro</option>
                                    <option value="outro">Outro</option>
                                </select>
                            </div>
                            <div class="col-md-5 mb-3">
                                <label for="despesa_descricao" class="form-label">Descrição</label>
                                <input type="text" class="form-control" id="despesa_descricao"
                                    placeholder="Descrição da despesa">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label for="despesa_valor" class="form-label">Valor (R$)</label>
                                <input type="number" class="form-control" id="despesa_valor" step="0.01" min="0"
                                    placeholder="0,00">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">&nbsp;</label>
                                <button type="button" class="btn btn-success w-100" onclick="adicionarDespesa()">
                                    <i class="bi bi-plus-circle me-1"></i> Adicionar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tabela de despesas -->
                <div id="tabela-despesas" style="display: none;">
                    <table class="table table-hover table-sm">
                        <thead class="table-light">
                            <tr>
                                <th width="20%">Tipo</th>
                                <th width="50%">Descrição</th>
                                <th width="20%" class="text-end">Valor</th>
                                <th width="10%"></th>
                            </tr>
                        </thead>
                        <tbody id="tbody-despesas">
                            <!-- Despesas serão adicionadas aqui -->
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="2" class="text-end"><strong>Total Despesas:</strong></td>
                                <td class="text-end"><strong id="total-despesas">R$ 0,00</strong></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="alert alert-info" id="alert-sem-despesas">
                    <i class="bi bi-info-circle me-2"></i>
                    Nenhuma despesa adicionada. Use o formulário acima para adicionar despesas.
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Entrega -->
    <div class="tab-pane fade" id="entrega" role="tabpanel">
        <div class="row">
            <!-- Endereço de Entrega -->
            <div class="col-lg-6">
                <div class="card h-100">
                    <div class="card-header">
                        <i class="bi bi-geo-alt me-2"></i> Endereço de Entrega
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8 mb-3">
                                <label for="delivery_street" class="form-label">Rua/Logradouro</label>
                                <input type="text" class="form-control" id="delivery_street" name="delivery_street"
                                    value="<?= htmlspecialchars($ordem['delivery_street'] ?? '') ?>"
                                    placeholder="Nome da rua ou avenida">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="delivery_number" class="form-label">Número</label>
                                <input type="text" class="form-control" id="delivery_number" name="delivery_number"
                                    value="<?= htmlspecialchars($ordem['delivery_number'] ?? '') ?>" placeholder="123">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="delivery_complement" class="form-label">Complemento</label>
                                <input type="text" class="form-control" id="delivery_complement"
                                    name="delivery_complement"
                                    value="<?= htmlspecialchars($ordem['delivery_complement'] ?? '') ?>"
                                    placeholder="Apartamento, bloco, sala...">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-5 mb-3">
                                <label for="delivery_city" class="form-label">Cidade</label>
                                <input type="text" class="form-control" id="delivery_city" name="delivery_city"
                                    value="<?= htmlspecialchars($ordem['delivery_city'] ?? '') ?>" placeholder="Cidade">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label for="delivery_state" class="form-label">UF</label>
                                <input type="text" class="form-control text-uppercase" id="delivery_state"
                                    name="delivery_state"
                                    value="<?= htmlspecialchars($ordem['delivery_state'] ?? '') ?>" placeholder="UF"
                                    maxlength="2">
                            </div>
                            <div class="col-md-5 mb-3">
                                <label for="delivery_zip" class="form-label">CEP</label>
                                <input type="text" class="form-control" id="delivery_zip" name="delivery_zip"
                                    value="<?= htmlspecialchars($ordem['delivery_zip'] ?? '') ?>"
                                    placeholder="00000-000">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="delivery_date" class="form-label">Data de Entrega Prevista</label>
                                <input type="date" class="form-control" id="delivery_date" name="delivery_date"
                                    value="<?= $ordem['delivery_date'] ?? '' ?>">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="delivery_notes" class="form-label">Observações da Entrega</label>
                                <textarea class="form-control" id="delivery_notes" name="delivery_notes" rows="3"
                                    placeholder="Instruções especiais para entrega..."><?= htmlspecialchars($ordem['delivery_notes'] ?? '') ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Transportadora e Veículo -->
            <div class="col-lg-6">
                <div class="card h-100">
                    <div class="card-header">
                        <i class="bi bi-truck-front-fill me-2"></i> Transportadora e Veículo
                    </div>
                    <div class="card-body">
                        <h6 class="text-primary mb-3"><i class="bi bi-building me-2"></i> Transportadora</h6>

                        <div class="mb-3">
                            <label for="carrier_name" class="form-label">Nome da Transportadora</label>
                            <input type="text" class="form-control" id="carrier_name" name="carrier_name"
                                value="<?= htmlspecialchars($ordem['carrier_name'] ?? '') ?>"
                                placeholder="Nome da transportadora">
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="carrier_cnpj" class="form-label">CNPJ</label>
                                <input type="text" class="form-control" id="carrier_cnpj" name="carrier_cnpj"
                                    value="<?= htmlspecialchars($ordem['carrier_cnpj'] ?? '') ?>"
                                    placeholder="00.000.000/0000-00">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="carrier_ie" class="form-label">Inscrição Estadual</label>
                                <input type="text" class="form-control" id="carrier_ie" name="carrier_ie"
                                    value="<?= htmlspecialchars($ordem['carrier_ie'] ?? '') ?>" placeholder="IE">
                            </div>
                        </div>

                        <hr class="my-3">

                        <h6 class="text-primary mb-3"><i class="bi bi-truck me-2"></i> Dados do Veículo</h6>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="vehicle_plate" class="form-label">Placa do Veículo</label>
                                <input type="text" class="form-control text-uppercase" id="vehicle_plate"
                                    name="vehicle_plate" value="<?= htmlspecialchars($ordem['vehicle_plate'] ?? '') ?>"
                                    placeholder="ABC-1234" maxlength="8">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="vehicle_state" class="form-label">UF Veículo</label>
                                <input type="text" class="form-control text-uppercase" id="vehicle_state"
                                    name="vehicle_state" value="<?= htmlspecialchars($ordem['vehicle_state'] ?? '') ?>"
                                    placeholder="UF" maxlength="2">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="driver_name" class="form-label">Nome do Motorista</label>
                                <input type="text" class="form-control" id="driver_name" name="driver_name"
                                    value="<?= htmlspecialchars($ordem['driver_name'] ?? '') ?>"
                                    placeholder="Nome completo do motorista">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="tracking_code" class="form-label">Código de Rastreamento</label>
                                <input type="text" class="form-control" id="tracking_code" name="tracking_code"
                                    value="<?= htmlspecialchars($ordem['tracking_code'] ?? '') ?>"
                                    placeholder="Código de rastreio da entrega">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Frete e Volumes -->
        <div class="row mt-3">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-box-seam me-2"></i> Frete e Volumes
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="freight_type" class="form-label">Tipo de Frete</label>
                                <select class="form-select" id="freight_type" name="freight_type">
                                    <option value="">Selecione...</option>
                                    <option value="cif"
                                        <?= ($ordem['freight_type'] ?? '') === 'cif' ? 'selected' : '' ?>>CIF (Por conta
                                        do remetente)</option>
                                    <option value="fob"
                                        <?= ($ordem['freight_type'] ?? '') === 'fob' ? 'selected' : '' ?>>FOB (Por conta
                                        do destinatário)</option>
                                    <option value="terceiros"
                                        <?= ($ordem['freight_type'] ?? '') === 'terceiros' ? 'selected' : '' ?>>
                                        Terceiros</option>
                                    <option value="proprio"
                                        <?= ($ordem['freight_type'] ?? '') === 'proprio' ? 'selected' : '' ?>>Próprio
                                        (por conta do remetente)</option>
                                    <option value="proprio_destinatario"
                                        <?= ($ordem['freight_type'] ?? '') === 'proprio_destinatario' ? 'selected' : '' ?>>
                                        Próprio (por conta do destinatário)</option>
                                </select>
                            </div>

                            <div class="col-md-2 mb-3">
                                <label for="freight_value" class="form-label">Valor Frete (R$)</label>
                                <input type="number" class="form-control" id="freight_value" name="freight_value"
                                    step="0.01" min="0" value="<?= $ordem['freight_value'] ?? '0.00' ?>"
                                    placeholder="0,00">
                            </div>

                            <div class="col-md-2 mb-3">
                                <label for="volume_quantity" class="form-label">Quantidade Volume</label>
                                <input type="number" class="form-control" id="volume_quantity" name="volume_quantity"
                                    min="0" value="<?= $ordem['volume_quantity'] ?? '' ?>" placeholder="0">
                            </div>

                            <div class="col-md-2 mb-3">
                                <label for="volume_species" class="form-label">Espécie Volume</label>
                                <input type="text" class="form-control" id="volume_species" name="volume_species"
                                    value="<?= htmlspecialchars($ordem['volume_species'] ?? '') ?>"
                                    placeholder="Caixa, Pacote...">
                            </div>

                            <div class="col-md-2 mb-3">
                                <label for="volume_brand" class="form-label">Marca Volume</label>
                                <input type="text" class="form-control" id="volume_brand" name="volume_brand"
                                    value="<?= htmlspecialchars($ordem['volume_brand'] ?? '') ?>" placeholder="Marca">
                            </div>

                            <div class="col-md-1 mb-3">
                                <label for="volume_numbering" class="form-label">Numeração</label>
                                <input type="text" class="form-control" id="volume_numbering" name="volume_numbering"
                                    value="<?= htmlspecialchars($ordem['volume_numbering'] ?? '') ?>" placeholder="1/5">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Pagamento e Valores -->
    <div class="tab-pane fade" id="pagamento" role="tabpanel">
        <!-- Card Único com 2 Colunas -->
        <div class="card">
            <div class="card-header">
                <i class="bi bi-credit-card me-2"></i> Pagamento e Valores
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Coluna Esquerda: Valores e Cálculos -->
                    <div class="col-lg-6">
                        <h6 class="text-primary mb-3"><i class="bi bi-currency-dollar me-2"></i> Valores</h6>

                        <div class="mb-3">
                            <label class="form-label"><strong>Subtotal</strong></label>
                            <div class="input-group">
                                <span class="input-group-text">R$</span>
                                <input type="text" class="form-control text-end" id="subtotal_display" readonly
                                    value="0,00">
                            </div>
                            <input type="hidden" id="subtotal" name="subtotal" value="0.00">
                            <small class="text-muted">Itens + Despesas + Frete</small>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="discount_type" class="form-label">Tipo de Desconto</label>
                                <select class="form-select" id="discount_type" name="discount_type">
                                    <option value="fixed"
                                        <?= ($ordem['discount_type'] ?? 'fixed') === 'fixed' ? 'selected' : '' ?>>Valor
                                        Fixo (R$)</option>
                                    <option value="percent"
                                        <?= ($ordem['discount_type'] ?? '') === 'percent' ? 'selected' : '' ?>>
                                        Percentual (%)</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="discount" class="form-label">Desconto</label>
                                <input type="number" class="form-control" id="discount" name="discount" step="0.01"
                                    min="0" value="<?= $ordem['discount'] ?? '0.00' ?>" placeholder="0,00">
                            </div>
                        </div>

                        <hr class="my-3">

                        <div class="mb-3">
                            <label class="form-label"><strong class="text-success fs-5">TOTAL FINAL</strong></label>
                            <div class="input-group input-group-lg">
                                <span class="input-group-text bg-success text-white fw-bold">R$</span>
                                <input type="text" class="form-control text-end fw-bold" id="total_display" readonly
                                    value="0,00">
                            </div>
                            <input type="hidden" id="total" name="total" value="0.00">
                        </div>
                    </div>

                    <!-- Coluna Direita: Forma de Pagamento e Opções -->
                    <div class="col-lg-6">
                        <h6 class="text-primary mb-3"><i class="bi bi-credit-card me-2"></i> Forma de Pagamento</h6>

                        <div class="mb-3">
                            <label for="payment_method_id" class="form-label">Método de Pagamento</label>
                            <select class="form-select" id="payment_method_id" name="payment_method_id">
                                <option value="">Selecione...</option>
                                <?php if (!empty($metodosPagamento)): ?>
                                <?php foreach ($metodosPagamento as $metodo): ?>
                                <option value="<?= $metodo['id'] ?>"
                                    <?= ($ordem['payment_method_id'] ?? '') == $metodo['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($metodo['name']) ?>
                                </option>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>

                        <!-- Campos hidden para manter compatibilidade com backend -->
                        <input type="hidden" id="additions" name="additions" value="0.00">
                        <input type="hidden" id="shipping" name="shipping" value="0.00">
                        <input type="hidden" id="installments" name="installments"
                            value="<?= $ordem['installments'] ?? 1 ?>">

                        <!-- Exibição do Parcelamento Selecionado -->
                        <div id="parcelamento-info" class="alert alert-info mb-3 d-none"
                            style="border-left: 4px solid #0dcaf0; background-color: #e7f3ff;">
                            <div class="d-flex align-items-start">
                                <i class="bi bi-calendar-check me-2 mt-1" style="font-size: 1.25rem;"></i>
                                <div class="flex-grow-1">
                                    <strong class="d-block mb-2" style="color: #0d6efd;">
                                        <i class="bi bi-receipt-cutoff me-1"></i> Parcelamento Selecionado
                                    </strong>
                                    <div id="parcelamento-detalhes" style="font-size: 0.95rem; line-height: 1.5;"></div>
                                </div>
                                <button type="button" class="btn btn-sm btn-link text-primary p-0 ms-2"
                                    onclick="$('#payment_method_id').trigger('change')" title="Alterar parcelamento">
                                    <i class="bi bi-pencil-fill"></i>
                                </button>
                            </div>
                        </div>

                        <hr class="my-3">

                        <h6 class="text-primary mb-3"><i class="bi bi-gear me-2"></i> Opções</h6>

                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="generate_receivables"
                                    name="generate_receivables" value="1"
                                    <?= ($ordem['generate_receivables'] ?? 1) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="generate_receivables">
                                    <strong><i class="bi bi-receipt me-1"></i> Gerar Contas a Receber</strong>
                                </label>
                            </div>
                            <small class="text-muted">Se ativado, serão criadas parcelas no módulo de Contas a
                                Receber</small>
                        </div>

                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="update_stock" name="update_stock"
                                    value="1" <?= ($ordem['update_stock'] ?? 1) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="update_stock">
                                    <strong><i class="bi bi-box-seam me-1"></i> Atualizar Estoque</strong>
                                </label>
                            </div>
                            <small class="text-muted">Se ativado, o estoque dos produtos será baixado
                                automaticamente</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($isEdit): ?>
<input type="hidden" name="id" value="<?= $ordem['id'] ?>">
<?php endif; ?>

<style>
.autocomplete-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: var(--bs-body-bg, #fff);
    border: 1px solid var(--bs-border-color, #dee2e6);
    border-top: none;
    border-radius: 0 0 0.375rem 0.375rem;
    max-height: 300px;
    overflow-y: auto;
    z-index: 1000;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

.autocomplete-item {
    padding: 0.875rem 1rem;
    cursor: pointer;
    border-bottom: 1px solid var(--bs-border-color, #f0f0f0);
    transition: all 0.15s ease-in-out;
    line-height: 1.5;
}

.autocomplete-item:hover,
.autocomplete-item.active {
    background-color: var(--bs-primary, #0d6efd);
    color: white;
    transform: translateX(3px);
}

.autocomplete-item:hover .text-muted {
    color: rgba(255, 255, 255, 0.8) !important;
}

.autocomplete-item:last-child {
    border-bottom: none;
}

.autocomplete-item .mb-1 {
    margin-bottom: 0.375rem;
}

.autocomplete-item strong {
    font-weight: 600;
}

.autocomplete-no-results {
    padding: 1rem;
    text-align: center;
    color: var(--bs-secondary, #6c757d);
    font-style: italic;
}

/* Modal de Prazos */
.swal-wide .list-group-item {
    cursor: pointer;
    transition: all 0.2s;
    padding: 1rem;
}

.swal-wide .list-group-item:hover {
    background-color: #f0f8ff;
    transform: translateX(3px);
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.swal-wide .list-group-item h6 {
    color: #2c3e50;
    font-weight: 600;
    font-size: 1rem;
    margin: 0;
}

.swal-wide .list-group-item p {
    color: #6c757d;
    font-size: 0.875rem;
    margin: 0;
    line-height: 1.4;
}

.swal-wide .prazo-item .d-flex>div:first-child {
    flex: 1;
}

/* Info de Parcelamento */
#parcelamento-info {
    background-color: #e7f3ff;
    border-color: #0dcaf0;
    animation: fadeInDown 0.3s;
}

#parcelamento-info strong {
    color: #0d6efd;
}

#parcelamento-info .btn-link {
    text-decoration: none;
    font-size: 1rem;
}

#parcelamento-info .btn-link:hover {
    opacity: 0.7;
}

@keyframes fadeInDown {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }

    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>

<script>
// Declarar variáveis PRIMEIRO (antes de usar)
let itensTabela = [];
let itemIndex = 0;
let itemTimeoutPrincipal = null;
let despesasTabela = [];
let despesaIndex = 0;

// Lista de clientes e produtos do PHP
const clientesData = <?= json_encode($clientes ?? []) ?>;
const produtosData = <?= json_encode($produtos ?? []) ?>;
let selectedCustomer = null;
let autocompleteTimeout = null;
let selectedProduto = null;

// Aguardar jQuery e inicializar
(function aguardarJQuery() {
    if (typeof jQuery === 'undefined') {
        setTimeout(aguardarJQuery, 100);
        return;
    }
    inicializarFormularioOrdemServico();
})();

// ============================================
// AUTOCOMPLETE DE CLIENTE
// ============================================
function inicializarAutocompleteCliente() {
    const $search = $('#customer_search');
    const $dropdown = $('#customer_dropdown');

    // Ao digitar
    $search.on('input', function() {
        const query = $(this).val().trim().toLowerCase();

        clearTimeout(autocompleteTimeout);

        if (query.length < 2) {
            $dropdown.hide();
            return;
        }

        autocompleteTimeout = setTimeout(() => {
            buscarClientes(query);
        }, 300);
    });

    // Ao clicar fora, fechar dropdown
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#customer_search, #customer_dropdown').length) {
            $dropdown.hide();
        }
    });

    // Ao focar no campo
    $search.on('focus', function() {
        if ($(this).val().length >= 2) {
            buscarClientes($(this).val().trim().toLowerCase());
        }
    });

    // Ao pressionar Enter, apenas prevenir submit
    $search.on('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
        }
    });

    // Carregar cliente existente se estiver editando
    <?php if ($isEdit && !empty($ordem['customer_id'])): ?>
    const clienteInicial = clientesData.find(c => c.id == <?= $ordem['customer_id'] ?>);
    if (clienteInicial) {
        selecionarCliente(clienteInicial);
    }
    <?php endif; ?>
}

function buscarClientes(query) {
    const $dropdown = $('#customer_dropdown');

    // Filtrar clientes
    const results = clientesData.filter(cliente => {
        const name = (cliente.name || '').toLowerCase();
        const tradeName = (cliente.trade_name || '').toLowerCase();
        const document = (cliente.document || '').toLowerCase();
        const email = (cliente.email || '').toLowerCase();
        const phone = (cliente.phone || '').toLowerCase();
        const mobile = (cliente.mobile || '').toLowerCase();

        // Normalizar query e documento para busca mais flexível
        const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
        const normalizedDocument = document.replace(/[^\d\w]/g, '').toLowerCase();

        return name.includes(query) || tradeName.includes(query) ||
            document.includes(query) || normalizedDocument.includes(normalizedQuery) ||
            email.includes(query) || phone.includes(query) || mobile.includes(query);
    });

    // Montar HTML
    let html = '';

    if (results.length > 0) {
        results.forEach(cliente => {
            const nomeFantasia = cliente.trade_name || '-';
            const razaoSocial = cliente.name || '-';
            const documento = cliente.document || 'Não informado';
            const codigo = String(cliente.id).padStart(4, '0');
            const telefone = cliente.phone || cliente.mobile || '-';
            const email = cliente.email || '-';

            html += `
                <div class="autocomplete-item" data-id="${cliente.id}">
                    <div class="mb-1">
                        <strong>Código: ${codigo}</strong>  |  <strong>CNPJ/CPF:</strong> ${documento}
                    </div>
                    <div class="mb-1">
                        <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                    </div>
                    <div class="text-muted small">
                        <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                    </div>
                </div>
            `;
        });
    } else {
        html = '<div class="autocomplete-no-results">Nenhum cliente encontrado</div>';
    }

    $dropdown.html(html).show();

    // Event listeners
    $dropdown.find('.autocomplete-item').on('click', function() {
        const clienteId = $(this).data('id');
        const cliente = clientesData.find(c => c.id == clienteId);
        if (cliente) {
            selecionarCliente(cliente);
        }
    });
}

function selecionarCliente(cliente) {
    selectedCustomer = cliente;

    const nomeFantasia = cliente.trade_name || '-';
    const razaoSocial = cliente.name || '-';
    const nomeExibir = nomeFantasia !== '-' ? nomeFantasia : razaoSocial;
    const codigo = String(cliente.id).padStart(4, '0');
    const documento = cliente.document || 'Não informado';
    const telefone = cliente.phone || cliente.mobile || '-';
    const email = cliente.email || '-';

    // Preencher campos hidden
    $('#customer_id').val(cliente.id);
    $('#customer_type').val('pessoa');
    $('#customer_name').val(razaoSocial);
    $('#customer_document').val(cliente.document || '');

    // Atualizar campo de busca
    $('#customer_search').val(nomeExibir);

    // Mostrar info do cliente no formato estruturado
    let infoHtml = `
        <div style="line-height: 1.6;">
            <div class="mb-1">
                <strong>Código: ${codigo}</strong>  |  ${documento}
            </div>
            <div class="mb-1">
                <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
            </div>
            <div class="text-muted small">
                <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
            </div>
        </div>
    `;

    $('#customer_info_name').html(infoHtml);
    $('#customer_info_document').text('');
    $('#customer_info_email').text('');

    $('#customer_info').slideDown();

    // Fechar dropdown
    $('#customer_dropdown').hide();
}

function limparCliente() {
    selectedCustomer = null;

    $('#customer_id').val('');
    $('#customer_type').val('pessoa');
    $('#customer_name').val('');
    $('#customer_document').val('');
    $('#customer_search').val('');

    $('#customer_info').slideUp();
}

function inicializarFormularioOrdemServico() {
    // Inicializar autocomplete de clientes
    inicializarAutocompleteCliente();

    // Calcular valores quando houver mudança
    $('#discount, #discount_type, #freight_value').on('input change', function() {
        calcularTotalGeral();
    });

    // Evento ao selecionar método de pagamento
    $('#payment_method_id').on('change', function() {
        const metodoId = $(this).val();

        // Limpar informação de parcelamento anterior
        $('#parcelamento-info').addClass('d-none');
        $('#installments').val(1);

        if (metodoId) {
            mostrarPrazosMetodoPagamento(metodoId);
        } else {
            // Se não houver método selecionado, ocultar parcelamento
            $('#parcelamento-info').addClass('d-none');
        }
    });

    // Carregar parcelamento existente se estiver editando
    <?php if ($isEdit && !empty($ordem['payment_method_id']) && !empty($ordem['installments']) && $ordem['installments'] > 1): ?>
    $(document).ready(function() {
        const metodoId = <?= $ordem['payment_method_id'] ?>;
        const parcelas = <?= $ordem['installments'] ?? 1 ?>;
        const totalFinal = parseFloat($('#total').val()) || parseFloat('<?= $ordem['total'] ?? 0 ?>');

        if (parcelas > 1 && totalFinal > 0) {
            // Buscar dias do prazo se houver payment_term_id
            <?php if (!empty($ordem['payment_term_id'])): ?>
            $.ajax({
                url: appUrl('/metodos-pagamento/buscar-prazos'),
                method: 'GET',
                data: {
                    metodo_id: metodoId
                },
                success: function(response) {
                    if (response.success && response.data.prazos && response.data.prazos
                        .length >
                        0) {
                        const prazoEncontrado = response.data.prazos.find(p => Math.ceil(p
                            .dias /
                            30) === parcelas);
                        const dias = prazoEncontrado ? prazoEncontrado.dias : (parcelas * 30);

                        // Calcular valores das parcelas
                        const valorParcela = totalFinal / parcelas;
                        const valorParcelaInteiro = Math.floor(valorParcela * 100) / 100;
                        const valorUltimaParcela = totalFinal - (valorParcelaInteiro * (
                            parcelas -
                            1));

                        // Montar descrição
                        let descricaoDetalhada = '';
                        if (parcelas === 1) {
                            descricaoDetalhada =
                                `<strong>${parcelas}x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
                        } else {
                            if (Math.abs(valorUltimaParcela - valorParcelaInteiro) < 0.01) {
                                descricaoDetalhada =
                                    `<strong>${parcelas}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
                            } else {
                                descricaoDetalhada =
                                    `<strong>${parcelas - 1}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> + <strong>1x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
                            }
                        }

                        $('#parcelamento-detalhes').html(descricaoDetalhada);
                        $('#parcelamento-info').removeClass('d-none');
                    }
                }
            });
            <?php else: ?>
            // Se não houver payment_term_id, usar cálculo padrão
            const dias = parcelas * 30;
            const valorParcela = totalFinal / parcelas;
            const valorParcelaInteiro = Math.floor(valorParcela * 100) / 100;
            const valorUltimaParcela = totalFinal - (valorParcelaInteiro * (parcelas - 1));

            let descricaoDetalhada = '';
            if (parcelas === 1) {
                descricaoDetalhada =
                    `<strong>${parcelas}x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong>`;
            } else {
                if (Math.abs(valorUltimaParcela - valorParcelaInteiro) < 0.01) {
                    descricaoDetalhada =
                        `<strong>${parcelas}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong>`;
                } else {
                    descricaoDetalhada =
                        `<strong>${parcelas - 1}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> + <strong>1x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong>`;
                }
            }

            $('#parcelamento-detalhes').html(descricaoDetalhada);
            $('#parcelamento-info').removeClass('d-none');
            <?php endif; ?>
        }
    });
    <?php endif; ?>

    // Validação de vendedores - não permitir mesmo vendedor em ambos campos
    function atualizarSelectsVendedores() {
        const vendorPrincipal = $('#vendor_id').val();
        const vendorAuxiliar = $('#auxiliary_vendor_id').val();

        // Atualizar select do vendedor auxiliar
        $('#auxiliary_vendor_id option').each(function() {
            const optionValue = $(this).val();
            if (optionValue && optionValue === vendorPrincipal) {
                $(this).prop('disabled', true);
            } else {
                $(this).prop('disabled', false);
            }
        });

        // Atualizar select do vendedor principal
        $('#vendor_id option').each(function() {
            const optionValue = $(this).val();
            if (optionValue && optionValue === vendorAuxiliar) {
                $(this).prop('disabled', true);
            } else {
                $(this).prop('disabled', false);
            }
        });

        // Se ambos forem iguais, limpar o auxiliar e mostrar aviso
        if (vendorPrincipal && vendorAuxiliar && vendorPrincipal === vendorAuxiliar) {
            $('#auxiliary_vendor_id').val('');
            Swal.fire({
                icon: 'warning',
                title: 'Atenção',
                text: 'O vendedor principal e o vendedor auxiliar não podem ser a mesma pessoa!',
                toast: true,
                position: 'top-end',
                timer: 3000,
                showConfirmButton: false
            });
        }
    }

    $('#vendor_id, #auxiliary_vendor_id').on('change', atualizarSelectsVendedores);

    // Executar na inicialização para garantir estado correto
    atualizarSelectsVendedores();

    // Ocultar tabela inicialmente apenas se não for edição
    <?php if (!$isEdit || empty($itens)): ?>
    $('#tabela-itens').hide();
    $('#alert-sem-itens').show();
    <?php else: ?>
    $('#tabela-itens').show();
    $('#alert-sem-itens').hide();
    console.log('Tabela deve estar visível (modo edição com itens)');
    <?php endif; ?>

    // Inicializar autocomplete de item principal
    inicializarAutocompleteItemPrincipal();

    // Calcular total ao mudar campos do item principal
    $('#altura_principal, #largura_principal').on('input', function() {
        calcularM2Principal();
    });

    $('#m2_principal, #quantidade_principal, #preco_principal').on('input', function() {
        calcularTotalPrincipal();
    });

    // Carregar itens existentes se estiver editando
    <?php if ($isEdit && !empty($itens)): ?>
    console.log('=== INICIANDO CARGA DE ITENS ===');
    console.log('Modo de edição: SIM');
    console.log('Total de itens a carregar: <?= count($itens) ?>');
    console.log('Itens do PHP:', <?= json_encode($itens) ?>);

    <?php foreach ($itens as $index => $item): ?>
    console.log('--- Processando item <?= $index + 1 ?> ---');
    const itemCarregado_<?= $index ?> = <?= json_encode($item) ?>;
    console.log('Dados do item:', itemCarregado_<?= $index ?>);
    // Não adicionar aqui - a função adicionarItemNaTabela já faz isso
    adicionarItemNaTabela(itemCarregado_<?= $index ?>, true);
    console.log('Item processado. Total no array:', itensTabela.length);
    <?php endforeach; ?>

    console.log('=== FINALIZANDO CARGA DE ITENS ===');
    console.log('Total de itens no array:', itensTabela.length);
    atualizarTotalGeral();
    <?php else: ?>
    console.log('=== MODO CRIAR NOVA ORDEM DE SERVIÇO ===');
    console.log('Modo de edição:', <?= $isEdit ? 'true' : 'false' ?>);
    console.log('Itens disponíveis:', <?= json_encode($itens ?? []) ?>);
    <?php endif; ?>

    // Calcular totais ao inicializar (para preencher os campos mesmo sem itens)
    calcularTotalGeral();
}

// ============================================
// AUTOCOMPLETE E GERENCIAMENTO DE ITENS
// ============================================
function inicializarAutocompleteItemPrincipal() {
    const $search = $('#item_search_principal');
    const $dropdown = $('#item_dropdown_principal');

    $search.on('input', function() {
        const query = $(this).val().trim().toLowerCase();
        clearTimeout(itemTimeoutPrincipal);

        if (query.length < 2) {
            $dropdown.hide();
            return;
        }

        itemTimeoutPrincipal = setTimeout(() => {
            buscarProdutosPrincipal(query);
        }, 300);
    });

    $search.on('focus', function() {
        if ($(this).val().length >= 2) {
            buscarProdutosPrincipal($(this).val().trim().toLowerCase());
        }
    });

    $search.on('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
        }
    });

    $(document).on('click', function(e) {
        if (!$(e.target).closest('#item_search_principal, #item_dropdown_principal').length) {
            $dropdown.hide();
        }
    });
}

function buscarProdutosPrincipal(query) {
    const $dropdown = $('#item_dropdown_principal');
    const results = produtosData.filter(produto => {
        const name = (produto.name || '').toLowerCase();
        const sku = (produto.sku || '').toLowerCase();
        return name.includes(query) || sku.includes(query);
    });

    let html = '';
    if (results.length > 0) {
        results.forEach(produto => {
            const estoque = produto.stock_quantity || 0;
            const preco = parseFloat(produto.price || 0);
            html += `
                <div class="autocomplete-item" data-id="${produto.id}">
                    <div class="mb-1"><strong>${produto.name}</strong>${produto.sku ? ' <span class="text-muted">(' + produto.sku + ')</span>' : ''}</div>
                    <div class="text-muted small"><strong>Preço:</strong> R$ ${preco.toFixed(2).replace('.', ',')}  |  <strong>Estoque:</strong> ${estoque} ${produto.unit || 'un'}</div>
                </div>
            `;
        });
    } else {
        html = '<div class="autocomplete-no-results">Nenhum produto encontrado</div>';
    }

    $dropdown.html(html).show();

    $dropdown.find('.autocomplete-item').on('click', function() {
        const produtoId = $(this).data('id');
        const produto = produtosData.find(p => p.id == produtoId);
        if (produto) {
            selecionarProdutoPrincipal(produto);
        }
    });
}

function selecionarProdutoPrincipal(produto) {
    selectedProduto = produto;
    $('#produto_id_principal').val(produto.id);
    $('#item_search_principal').val(produto.name);
    $('#preco_principal').val(parseFloat(produto.price || 0).toFixed(2));
    $('#item_dropdown_principal').hide();
    $('#quantidade_principal').focus().select();
    calcularTotalPrincipal();

    // Armazenar dados fiscais do produto
    selectedProduto.fiscal = {
        ncm: produto.ncm || '',
        cest: produto.cest || '',
        cfop: produto.cfop || '',
        origem: produto.origem || '',
        origem_st: produto.origem_st || '0',
        cst_icms: produto.cst_icms || '',
        aliquota_icms: produto.aliquota_icms || 0,
        cst_pis: produto.cst_pis || '',
        aliquota_pis: produto.aliquota_pis || 0,
        cst_cofins: produto.cst_cofins || '',
        aliquota_cofins: produto.aliquota_cofins || 0,
        cst_ipi: produto.cst_ipi || '',
        aliquota_ipi: produto.aliquota_ipi || 0
    };
}

function calcularM2Principal() {
    const altura = parseFloat($('#altura_principal').val()) || 0;
    const largura = parseFloat($('#largura_principal').val()) || 0;
    const m2 = altura * largura;
    $('#m2_principal').val(m2.toFixed(3));
    calcularTotalPrincipal();
}

// ============================================
// PROCESSAMENTO DE IMAGEM
// ============================================
const IMAGE_MAX_MB = 5;
const IMAGE_MAX_BYTES = IMAGE_MAX_MB * 1024 * 1024;
const IMAGE_MAX_WIDTH = 1920;
const IMAGE_MAX_HEIGHT = 1080;
let imagemModalAtual = '';

function calcularTamanhoBase64(base64String) {
    if (!base64String) {
        return 0;
    }

    const padding = base64String.endsWith('==') ? 2 : (base64String.endsWith('=') ? 1 : 0);
    return Math.ceil((base64String.length * 3) / 4) - padding;
}

function tratarImagemArquivo(file, onSuccess) {
    if (!file) {
        return;
    }

    if (!file.type || !file.type.match(/^image\//)) {
        Swal.fire({
            icon: 'error',
            title: 'Arquivo inválido',
            text: 'Por favor, selecione um arquivo de imagem (JPG, PNG, etc).'
        });
        return;
    }

    const reader = new FileReader();

    reader.onload = (event) => {
        const img = new Image();

        img.onload = () => {
            if (file.size <= IMAGE_MAX_BYTES) {
                onSuccess({
                    base64: event.target.result,
                    sizeBytes: file.size,
                    width: img.width,
                    height: img.height
                });
                return;
            }

            const canvas = document.createElement('canvas');
            const ctx = canvas.getContext('2d');

            let width = img.width;
            let height = img.height;

            const ratio = Math.min(IMAGE_MAX_WIDTH / width, IMAGE_MAX_HEIGHT / height, 1);
            width = Math.floor(width * ratio);
            height = Math.floor(height * ratio);

            canvas.width = width;
            canvas.height = height;
            ctx.clearRect(0, 0, width, height);
            ctx.drawImage(img, 0, 0, width, height);

            let quality = 0.9;
            let base64 = canvas.toDataURL('image/jpeg', quality);
            let sizeBytes = calcularTamanhoBase64(base64.split(',')[1] || '');

            while (sizeBytes > IMAGE_MAX_BYTES && quality > 0.2) {
                quality -= 0.1;
                base64 = canvas.toDataURL('image/jpeg', quality);
                sizeBytes = calcularTamanhoBase64(base64.split(',')[1] || '');
            }

            onSuccess({
                base64,
                sizeBytes,
                width,
                height
            });
        };

        img.onerror = () => {
            Swal.fire({
                icon: 'error',
                title: 'Erro ao processar imagem',
                text: 'Não foi possível carregar a imagem selecionada.'
            });
        };

        img.src = event.target.result;
    };

    reader.onerror = () => {
        Swal.fire({
            icon: 'error',
            title: 'Erro ao ler arquivo',
            text: 'Tente selecionar a imagem novamente.'
        });
    };

    reader.readAsDataURL(file);
}

function processarImagemItem(input) {
    const file = input.files[0];
    if (!file) {
        return;
    }

    tratarImagemArquivo(file, (dadosImagem) => {
        aplicarImagemPrincipal(dadosImagem);
    });
}

function aplicarImagemPrincipal({
    base64,
    sizeBytes,
    width,
    height
}) {
    $('#imagem_base64_principal').val(base64);
    $('#img_preview_principal').attr('src', base64);

    const tamanhoMB = (sizeBytes / (1024 * 1024)).toFixed(2);
    $('#img_info_principal').html(`
        <i class="bi bi-check-circle text-success me-1"></i>
        Imagem: ${width}x${height}px (${tamanhoMB} MB)
    `);

    $('#preview_imagem_principal').slideDown();
}

function removerImagemPrincipal() {
    $('#imagem_principal').val('');
    $('#imagem_base64_principal').val('');
    $('#img_preview_principal').attr('src', '');
    $('#img_info_principal').text('');
    $('#preview_imagem_principal').slideUp();
}

function processarImagemModal(input) {
    const file = input.files[0];
    if (!file) {
        return;
    }

    tratarImagemArquivo(file, (dadosImagem) => {
        aplicarImagemModal(dadosImagem);
    });
}

function aplicarImagemModal({
    base64,
    sizeBytes,
    width,
    height
}) {
    imagemModalAtual = base64;

    const $preview = $('#swal-image-preview');
    if (!$preview.length) {
        return;
    }

    const tamanhoMB = (sizeBytes / (1024 * 1024)).toFixed(2);

    $('#swal-img-preview').attr('src', base64);
    $('#swal-img-info').html(`
        <i class="bi bi-check-circle text-success me-1"></i>
        Imagem: ${width}x${height}px (${tamanhoMB} MB)
    `);

    $preview.slideDown();
}

function removerImagemModal() {
    imagemModalAtual = '';

    const $fileInput = $('#swal-image');
    if ($fileInput.length) {
        $fileInput.val('');
    }

    $('#swal-img-preview').attr('src', '');
    $('#swal-img-info').text('');
    $('#swal-image-preview').slideUp();
}

function calcularTotalPrincipal() {
    const m2 = parseFloat($('#m2_principal').val()) || 0;
    const quantidade = parseFloat($('#quantidade_principal').val()) || 1;
    const preco = parseFloat($('#preco_principal').val()) || 0;
    // Cálculo: m² × preço × quantidade
    const total = m2 * preco * quantidade;
    $('#total_principal').val(total.toFixed(2));
}

function adicionarItemNaTabela(itemData = null, isLoad = false) {
    let item;

    if (itemData) {
        // Se for carga de dados existentes (edição), garantir compatibilidade
        // Calcular M² se não existir
        const m2Item = itemData.m2 || (parseFloat(itemData.altura || 0) * parseFloat(itemData.largura || 0));

        item = {
            product_id: itemData.product_id || '',
            product_name: itemData.product_name || '',
            product_sku: itemData.product_sku || '',
            altura: itemData.altura || 0,
            largura: itemData.largura || 0,
            m2: m2Item,
            quantity: itemData.quantity || m2Item, // M² (para compatibilidade)
            quantity2: itemData.quantity2 || itemData.quantity || 1, // Quantidade de itens
            unit_price: itemData.unit_price || 0,
            discount: 0,
            discount_type: 'fixed',
            total_price: itemData.total_price || 0,
            notes: itemData.notes || '',
            imagem: itemData.imagem || '',
            ncm: itemData.ncm || '',
            cest: itemData.cest || '',
            cfop: itemData.cfop || '',
            origem: itemData.origem || '',
            origem_st: itemData.origem_st || '0',
            cst_icms: itemData.cst_icms || '',
            aliquota_icms: itemData.aliquota_icms || 0,
            cst_pis: itemData.cst_pis || '',
            aliquota_pis: itemData.aliquota_pis || 0,
            cst_cofins: itemData.cst_cofins || '',
            aliquota_cofins: itemData.aliquota_cofins || 0,
            cst_ipi: itemData.cst_ipi || '',
            aliquota_ipi: itemData.aliquota_ipi || 0
        };
    } else {
        // Novo item do formulário
        const m2 = parseFloat($('#m2_principal').val()) || 0;
        const quantidade = parseFloat($('#quantidade_principal').val()) || 1;
        const preco = parseFloat($('#preco_principal').val()) || 0;
        // Cálculo: m² × preço × quantidade
        const total = m2 * preco * quantidade;

        item = {
            product_id: $('#produto_id_principal').val() || '',
            product_name: $('#item_search_principal').val() || '',
            product_sku: selectedProduto?.sku || '',
            altura: parseFloat($('#altura_principal').val()) || 0,
            largura: parseFloat($('#largura_principal').val()) || 0,
            m2: m2,
            quantity: m2, // M² (para compatibilidade com banco)
            quantity2: quantidade, // Quantidade de itens
            unit_price: preco,
            discount: 0,
            discount_type: 'fixed',
            total_price: total,
            notes: $('#obs_principal').val() || '',
            imagem: $('#imagem_base64_principal').val() || '',
            ncm: selectedProduto?.fiscal?.ncm || '',
            cest: selectedProduto?.fiscal?.cest || '',
            cfop: selectedProduto?.fiscal?.cfop || '',
            origem: selectedProduto?.fiscal?.origem || '',
            origem_st: selectedProduto?.fiscal?.origem_st || '0',
            cst_icms: selectedProduto?.fiscal?.cst_icms || '',
            aliquota_icms: selectedProduto?.fiscal?.aliquota_icms || 0,
            cst_pis: selectedProduto?.fiscal?.cst_pis || '',
            aliquota_pis: selectedProduto?.fiscal?.aliquota_pis || 0,
            cst_cofins: selectedProduto?.fiscal?.cst_cofins || '',
            aliquota_cofins: selectedProduto?.fiscal?.aliquota_cofins || 0,
            cst_ipi: selectedProduto?.fiscal?.cst_ipi || '',
            aliquota_ipi: selectedProduto?.fiscal?.aliquota_ipi || 0
        };
    }

    if (!item.product_name && !item.product_id) {
        if (!isLoad) {
            Swal.fire({
                icon: 'warning',
                title: 'Atenção',
                text: 'Selecione ou digite um item!'
            });
            $('#item_search_principal').focus();
        }
        return;
    }

    const index = itensTabela.length;
    itensTabela.push(item);

    const $tbody = $('#tbody-itens');

    // Escapar valores para evitar problemas de HTML injection
    const escapeHtml = (text) => {
        const map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        };
        return String(text || '').replace(/[&<>"']/g, m => map[m]);
    };

    // Criar thumbnail da imagem
    let imgHtml = '<span class="text-muted small">-</span>';
    if (item.imagem) {
        // Se for base64 (data:image), usar diretamente
        // Se for caminho de arquivo, garantir que comece com /
        const imgSrc = item.imagem.startsWith('data:image') ? item.imagem :
                      (item.imagem.startsWith('/') ? item.imagem : '/' + item.imagem);
        imgHtml = `<img src="${imgSrc}" class="img-thumbnail" style="max-width: 40px; max-height: 40px; cursor: pointer;"
              onclick="visualizarImagemItem(${index})" title="Clique para ampliar">`;
    }

    // Calcular M² do item
    const m2Item = item.m2 || item.quantity || (parseFloat(item.altura || 0) * parseFloat(item.largura || 0));
    const quantidadeItem = parseFloat(item.quantity2 || item.quantity || 1);

    const $row = $(`
        <tr data-index="${index}">
            <td>${escapeHtml(item.product_name)}</td>
            <td class="text-center">${imgHtml}</td>
            <td class="text-center">${parseFloat(item.altura || 0).toFixed(2)}</td>
            <td class="text-center">${parseFloat(item.largura || 0).toFixed(2)}</td>
            <td class="text-center">${m2Item.toFixed(3)}</td>
            <td class="text-center">${quantidadeItem.toFixed(0)}</td>
            <td class="text-end">R$ ${parseFloat(item.unit_price || 0).toFixed(2)}</td>
            <td class="text-end"><strong>R$ ${parseFloat(item.total_price || 0).toFixed(2)}</strong></td>
            <td>${escapeHtml(item.notes) || '-'}</td>
            <td class="text-center">
                <div class="btn-group btn-group-sm" role="group">
                    <button type="button" class="btn btn-outline-primary" onclick="editarItemDaTabela(${index})" title="Alterar item">
                        <i class="bi bi-pencil"></i>
                    </button>
                    <button type="button" class="btn btn-outline-danger" onclick="removerItemDaTabela(${index})" title="Remover item">
                    <i class="bi bi-trash"></i>
                </button>
                </div>
            </td>
            <input type="hidden" name="itens[${index}][product_id]" value="${escapeHtml(item.product_id)}">
            <input type="hidden" name="itens[${index}][product_name]" value="${escapeHtml(item.product_name)}">
            <input type="hidden" name="itens[${index}][product_sku]" value="${escapeHtml(item.product_sku)}">
            <input type="hidden" name="itens[${index}][altura]" value="${item.altura || 0}">
            <input type="hidden" name="itens[${index}][largura]" value="${item.largura || 0}">
            <input type="hidden" name="itens[${index}][m2]" value="${m2Item}">
            <input type="hidden" name="itens[${index}][quantity]" value="${m2Item}">
            <input type="hidden" name="itens[${index}][quantity2]" value="${quantidadeItem}">
            <input type="hidden" name="itens[${index}][unit_price]" value="${item.unit_price || 0}">
            <input type="hidden" name="itens[${index}][discount]" value="0">
            <input type="hidden" name="itens[${index}][discount_type]" value="fixed">
            <input type="hidden" name="itens[${index}][total_price]" value="${item.total_price}">
            <input type="hidden" name="itens[${index}][imagem]" value="${escapeHtml(item.imagem)}">
            <input type="hidden" name="itens[${index}][notes]" value="${escapeHtml(item.notes)}">
            <input type="hidden" name="itens[${index}][ncm]" value="${escapeHtml(item.ncm)}">
            <input type="hidden" name="itens[${index}][cest]" value="${escapeHtml(item.cest)}">
            <input type="hidden" name="itens[${index}][cfop]" value="${escapeHtml(item.cfop)}">
            <input type="hidden" name="itens[${index}][origem]" value="${escapeHtml(item.origem)}">
            <input type="hidden" name="itens[${index}][origem_st]" value="${escapeHtml(item.origem_st || '0')}">
            <input type="hidden" name="itens[${index}][cst_icms]" value="${escapeHtml(item.cst_icms)}">
            <input type="hidden" name="itens[${index}][aliquota_icms]" value="${item.aliquota_icms || 0}">
            <input type="hidden" name="itens[${index}][cst_pis]" value="${escapeHtml(item.cst_pis)}">
            <input type="hidden" name="itens[${index}][aliquota_pis]" value="${item.aliquota_pis || 0}">
            <input type="hidden" name="itens[${index}][cst_cofins]" value="${escapeHtml(item.cst_cofins)}">
            <input type="hidden" name="itens[${index}][aliquota_cofins]" value="${item.aliquota_cofins || 0}">
            <input type="hidden" name="itens[${index}][cst_ipi]" value="${escapeHtml(item.cst_ipi)}">
            <input type="hidden" name="itens[${index}][aliquota_ipi]" value="${item.aliquota_ipi || 0}">
        </tr>
    `);

    $tbody.append($row);

    console.log('Item adicionado à tabela. Total de itens:', itensTabela.length);

    if (!isLoad) {
        limparCamposItem();
        atualizarTotalGeral();
    }

    // Garantir que a tabela seja exibida e o alerta ocultado
    $('#alert-sem-itens').hide();
    $('#tabela-itens').show();
}

function removerItemDaTabela(index) {
    itensTabela.splice(index, 1);

    // Remover linha da tabela
    $(`#tbody-itens tr[data-index="${index}"]`).remove();

    // Reindexar
    $('#tbody-itens tr').each(function(i) {
        $(this).attr('data-index', i);
        // Atualizar onclick de ambos os botões
        $(this).find('button').eq(0).attr('onclick', `editarItemDaTabela(${i})`);
        $(this).find('button').eq(1).attr('onclick', `removerItemDaTabela(${i})`);
    });

    // Reindexar inputs hidden
    $('#tbody-itens input[type="hidden"]').each(function(i) {
        const input = $(this);
        const name = input.attr('name').replace(/\[\d+\]/, `[${i}]`);
        input.attr('name', name);
    });

    atualizarTotalGeral();

    if (itensTabela.length === 0) {
        $('#alert-sem-itens').show();
        $('#tabela-itens').hide();
    }
}

async function editarItemDaTabela(index) {
    console.log('=== EDITANDO ITEM ===');
    console.log('Índice:', index);

    // Pegar o item do array
    const item = itensTabela[index];

    if (!item) {
        Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: 'Item não encontrado!'
        });
        return;
    }

    console.log('Item a editar:', item);

    // Abrir modal com SweetAlert2
    const {
        value: formValues
    } = await Swal.fire({
        title: '<i class="bi bi-pencil-square me-2"></i>Alterar Item',
        html: `
            <div class="text-start">
                <div class="mb-3">
                    <label class="form-label fw-bold">Produto/Serviço</label>
                    <input type="text" id="swal-product" class="form-control" value="${item.product_name}" readonly>
                </div>

                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="form-label fw-bold">M²</label>
                        <input type="number" id="swal-m2" class="form-control"
                               value="${(parseFloat(item.altura || 0) * parseFloat(item.largura || 0)).toFixed(3)}"
                               readonly style="background-color: #f8f9fa;">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label fw-bold">Quantidade</label>
                        <input type="number" id="swal-quantity" class="form-control"
                               value="${parseFloat(item.quantity2 || item.quantity || 1).toFixed(0)}"
                               min="1" step="1" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold">Preço Unit. (R$)</label>
                        <input type="number" id="swal-price" class="form-control"
                               value="${parseFloat(item.unit_price || 0).toFixed(2)}"
                               min="0" step="0.01" required>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Total</label>
                    <input type="text" id="swal-total" class="form-control fw-bold text-end"
                           value="R$ ${parseFloat(item.total_price).toFixed(2)}" readonly>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Observações</label>
                    <textarea id="swal-notes" class="form-control" rows="2">${item.notes || ''}</textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Imagem</label>
                    <input type="file" id="swal-image" class="form-control" accept="image/*" onchange="processarImagemModal(this)">
                    <input type="hidden" id="swal-image-base64">
                    <div id="swal-image-preview" class="mt-2" style="display: none;">
                        <div class="border rounded p-2 bg-light">
                            <img id="swal-img-preview" src="" alt="Preview" class="img-thumbnail" style="max-width: 200px; max-height: 200px; display: block; margin: 0 auto;">
                            <div id="swal-img-info" class="text-center mt-2 small text-muted"></div>
                            <div class="text-center mt-2">
                                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerImagemModal()">
                                    <i class="bi bi-trash me-1"></i> Remover Imagem
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        `,
        width: '700px',
        showCancelButton: true,
        confirmButtonText: '<i class="bi bi-check-circle me-2"></i>Salvar',
        cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Cancelar',
        confirmButtonColor: '#198754',
        cancelButtonColor: '#6c757d',
        didOpen: () => {
            // Carregar imagem existente se houver
            if (item.imagem) {
                // Se for base64 (data:image), usar diretamente
                if (item.imagem.startsWith('data:image')) {
                    imagemModalAtual = item.imagem;
                    $('#swal-image-base64').val(item.imagem);
                    $('#swal-img-preview').attr('src', item.imagem);
                    $('#swal-image-preview').slideDown();
                } else {
                    // Se for caminho de arquivo, carregar via URL
                    const imageUrl = item.imagem.startsWith('/') ? item.imagem : '/' + item.imagem;
                    $('#swal-img-preview').attr('src', imageUrl);
                    $('#swal-img-info').html('<i class="bi bi-image me-1"></i> Imagem atual do item');
                    $('#swal-image-preview').slideDown();
                    // Armazenar o caminho original
                    imagemModalAtual = item.imagem;
                }
            }

            // Calcular total automaticamente ao mudar valores
            const calcularTotal = () => {
                const m2 = parseFloat($('#swal-m2').val()) || 0;
                const quantidade = parseFloat($('#swal-quantity').val()) || 1;
                const preco = parseFloat($('#swal-price').val()) || 0;
                // Cálculo: m² × preço × quantidade
                const total = m2 * preco * quantidade;
                $('#swal-total').val('R$ ' + total.toFixed(2).replace('.', ','));
            };

            $('#swal-m2, #swal-quantity, #swal-price').on('input', calcularTotal);

            // Focar no campo de quantidade
            setTimeout(() => $('#swal-quantity').focus().select(), 100);
        },
        preConfirm: () => {
            const m2 = parseFloat($('#swal-m2').val()) || 0;
            const quantity = parseFloat($('#swal-quantity').val()) || 1;
            const price = parseFloat($('#swal-price').val()) || 0;

            if (!quantity || quantity < 1) {
                Swal.showValidationMessage('Quantidade deve ser maior ou igual a 1');
                return false;
            }

            if (!price || price < 0) {
                Swal.showValidationMessage('Preço deve ser maior ou igual a zero');
                return false;
            }

            // Cálculo: m² × preço × quantidade
            const total = m2 * price * quantity;

            return {
                quantity: quantity,
                unit_price: price,
                discount: 0,
                total_price: total,
                notes: $('#swal-notes').val(),
                imagem: imagemModalAtual || item.imagem || ''
            };
        }
    });

    // Se o usuário confirmou
    if (formValues) {
        console.log('Valores alterados:', formValues);

        // Atualizar o item no array
        itensTabela[index] = {
            ...item,
            quantity: item.quantity || (parseFloat(item.altura || 0) * parseFloat(item.largura || 0)), // M²
            quantity2: formValues.quantity, // Quantidade de itens
            unit_price: formValues.unit_price,
            discount: 0,
            total_price: formValues.total_price,
            notes: formValues.notes,
            imagem: formValues.imagem || item.imagem || ''
        };

        console.log('Item atualizado:', itensTabela[index]);

        // Atualizar o item no array
        const m2Item = item.quantity || (parseFloat(item.altura || 0) * parseFloat(item.largura || 0));

        // Atualizar a linha na tabela
        const $row = $(`#tbody-itens tr[data-index="${index}"]`);
        $row.find('td:eq(4)').text(m2Item.toFixed(3)); // M²
        $row.find('td:eq(5)').text(parseFloat(formValues.quantity).toFixed(0)); // Quantidade
        $row.find('td:eq(6)').text('R$ ' + parseFloat(formValues.unit_price).toFixed(2)); // Unit.
        $row.find('td:eq(7)').html('<strong>R$ ' + parseFloat(formValues.total_price).toFixed(2) + '</strong>'); // Total
        $row.find('td:eq(8)').text(formValues.notes || '-'); // Obs.

        // Atualizar imagem na tabela se houver
        if (formValues.imagem) {
            const imgSrc = formValues.imagem.startsWith('data:image') ? formValues.imagem :
                          (formValues.imagem.startsWith('/') ? formValues.imagem : '/' + formValues.imagem);
            const imgHtml = `<img src="${imgSrc}" class="img-thumbnail" style="max-width: 40px; max-height: 40px; cursor: pointer;"
                                  onclick="visualizarImagemItem(${index})" title="Clique para ampliar">`;
            $row.find('td:eq(1)').html(imgHtml);
        }

        // Atualizar inputs hidden
        $row.find('input[name*="[quantity]"]').val(m2Item);
        $row.find('input[name*="[quantity2]"]').val(formValues.quantity);
        $row.find('input[name*="[unit_price]"]').val(formValues.unit_price);
        $row.find('input[name*="[discount]"]').val(0);
        $row.find('input[name*="[total_price]"]').val(formValues.total_price);
        $row.find('input[name*="[notes]"]').val(formValues.notes);
        $row.find('input[name*="[imagem]"]').val(formValues.imagem || '');

        // Recalcular total geral
        atualizarTotalGeral();

        Swal.fire({
            icon: 'success',
            title: 'Item Atualizado!',
            text: 'As alterações foram salvas com sucesso.',
            timer: 1500,
            showConfirmButton: false,
            toast: true,
            position: 'top-end'
        });
    }
}

function visualizarImagemItem(index) {
    const item = itensTabela[index];
    if (!item || !item.imagem) return;

    // Se for base64 (data:image), usar diretamente
    // Se for caminho de arquivo, garantir que comece com /
    const imageUrl = item.imagem.startsWith('data:image') ? item.imagem :
                    (item.imagem.startsWith('/') ? item.imagem : '/' + item.imagem);

    Swal.fire({
        title: item.product_name,
        imageUrl: imageUrl,
        imageAlt: item.product_name,
        width: '80%',
        confirmButtonText: 'Fechar',
        confirmButtonColor: '#6c757d'
    });
}

function limparCamposItem() {
    $('#item_search_principal').val('');
    $('#produto_id_principal').val('');
    $('#altura_principal').val('');
    $('#largura_principal').val('');
    $('#m2_principal').val('0');
    $('#quantidade_principal').val('1');
    $('#preco_principal').val('0');
    $('#total_principal').val('0');
    $('#obs_principal').val('');
    $('#imagem_principal').val('');
    $('#imagem_base64_principal').val('');
    $('#preview_imagem_principal').hide();
    selectedProduto = null;
}

function atualizarTotalGeral() {
    console.log('=== CALCULANDO TOTAL GERAL ===');
    console.log('Quantidade de itens no array:', itensTabela.length);
    console.log('Itens:', itensTabela);

    // Atualizar total da tabela
    const total = itensTabela.reduce((sum, item) => {
        const itemTotal = parseFloat(item.total_price || 0);
        console.log(`Item: ${item.product_name} - Total: R$ ${itemTotal.toFixed(2)}`);
        return sum + itemTotal;
    }, 0);

    console.log('Total calculado: R$', total.toFixed(2));
    $('#total-geral').text('R$ ' + total.toFixed(2).replace('.', ','));

    // Atualizar totais na aba de valores
    calcularTotalGeral();
}

function calcularTotalGeral() {
    // Calcular total dos itens
    const totalItens = itensTabela.reduce((sum, item) => sum + parseFloat(item.total_price || 0), 0);

    // Calcular total das despesas
    const totalDespesas = despesasTabela.reduce((sum, despesa) => sum + parseFloat(despesa.valor || 0), 0);

    // Pegar valor do frete da aba entrega
    const valorFrete = parseFloat($('#freight_value').val()) || 0;

    // Subtotal = Itens + Despesas + Frete
    const subtotal = totalItens + totalDespesas + valorFrete;

    // Calcular desconto
    const descontoTipo = $('#discount_type').val();
    const descontoValor = parseFloat($('#discount').val()) || 0;
    let desconto = 0;

    if (descontoTipo === 'percent') {
        desconto = (subtotal * descontoValor) / 100;
    } else {
        desconto = descontoValor;
    }

    // Total Final = Subtotal - Desconto
    const total = subtotal - desconto;

    // Atualizar campos hidden para compatibilidade
    $('#additions').val('0.00');
    $('#shipping').val(valorFrete.toFixed(2));

    // Atualizar campos exibidos
    $('#subtotal').val(subtotal.toFixed(2));
    $('#subtotal_display').val(formatarMoeda(subtotal));
    $('#total').val(total.toFixed(2));
    $('#total_display').val(formatarMoeda(total));
}

function formatarMoeda(valor) {
    return valor.toFixed(2).replace('.', ',');
}

// ============================================
// SELEÇÃO DE PRAZOS DE PAGAMENTO
// ============================================

function mostrarPrazosMetodoPagamento(metodoId) {
    // Buscar total final da Ordem de Serviço
    const totalFinal = parseFloat($('#total').val()) || 0;

    if (totalFinal <= 0) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção',
            text: 'Adicione itens à Ordem de Serviço antes de selecionar o método de pagamento!'
        });
        $('#payment_method_id').val('');
        return;
    }

    // Buscar prazos do método via AJAX
    $.ajax({
        url: appUrl('/metodos-pagamento/buscar-prazos'),
        method: 'GET',
        data: {
            metodo_id: metodoId
        },
        success: function(response) {
            if (response.success && response.data.prazos && response.data.prazos.length > 0) {
                exibirModalPrazos(response.data.prazos, totalFinal);
            } else {
                // Método sem prazos configurados - usar pagamento simples
                $('#installments').val(1);
            }
        },
        error: function() {
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Não foi possível carregar os prazos de pagamento'
            });
        }
    });
}

function exibirModalPrazos(prazos, totalFinal) {
    let htmlPrazos = '<div class="list-group">';

    prazos.forEach((prazo, index) => {
        const dias = parseInt(prazo.dias);
        const quantidadeParcelas = Math.ceil(dias / 30); // 1 parcela a cada 30 dias

        // Calcular valor das parcelas
        const valorParcela = totalFinal / quantidadeParcelas;
        const valorParcelaInteiro = Math.floor(valorParcela * 100) / 100; // Arredondar para baixo
        const valorUltimaParcela = totalFinal - (valorParcelaInteiro * (quantidadeParcelas - 1));

        let descricaoParcelas;
        if (quantidadeParcelas === 1) {
            descricaoParcelas = `1x de <strong>R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong>`;
        } else {
            if (Math.abs(valorUltimaParcela - valorParcelaInteiro) < 0.01) {
                descricaoParcelas =
                    `${quantidadeParcelas}x de <strong>R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong>`;
            } else {
                descricaoParcelas =
                    `${quantidadeParcelas - 1}x de <strong>R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> + 1x de <strong>R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong>`;
            }
        }

        htmlPrazos += `
            <button type="button" class="list-group-item list-group-item-action prazo-item" onclick="selecionarPrazo(${quantidadeParcelas}, ${dias})">
                <div class="d-flex w-100 justify-content-between align-items-center">
                    <div class="d-flex align-items-start">
                        <i class="bi bi-calendar-check text-primary me-3 mt-1" style="font-size: 1.5rem;"></i>
                        <div>
                            <h6 class="mb-1">${quantidadeParcelas}x - ${dias} Dias</h6>
                            <p class="mb-0 text-muted small">${descricaoParcelas}</p>
                        </div>
                    </div>
                    <div class="ms-3">
                        <i class="bi bi-chevron-right text-secondary"></i>
                    </div>
                </div>
            </button>
        `;
    });

    htmlPrazos += '</div>';

    Swal.fire({
        title: '<i class="bi bi-credit-card me-2"></i> Selecione o Prazo de Pagamento',
        html: htmlPrazos,
        width: '650px',
        showConfirmButton: false,
        showCancelButton: true,
        cancelButtonText: '<i class="bi bi-x-circle me-1"></i> Cancelar',
        customClass: {
            popup: 'swal-wide',
            cancelButton: 'btn btn-secondary'
        },
        buttonsStyling: false
    });
}

function selecionarPrazo(parcelas, dias) {
    const totalFinal = parseFloat($('#total').val()) || 0;

    console.log('=== SELECIONANDO PRAZO ===');
    console.log('Parcelas:', parcelas);
    console.log('Dias:', dias);
    console.log('Total:', totalFinal);

    // Calcular valores das parcelas
    const valorParcela = totalFinal / parcelas;
    const valorParcelaInteiro = Math.floor(valorParcela * 100) / 100;
    const valorUltimaParcela = totalFinal - (valorParcelaInteiro * (parcelas - 1));

    console.log('Valor por parcela:', valorParcelaInteiro);
    console.log('Última parcela:', valorUltimaParcela);

    // Montar descrição detalhada
    let descricaoDetalhada = '';
    if (parcelas === 1) {
        descricaoDetalhada =
            `<strong>${parcelas}x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
    } else {
        if (Math.abs(valorUltimaParcela - valorParcelaInteiro) < 0.01) {
            descricaoDetalhada =
                `<strong>${parcelas}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
        } else {
            descricaoDetalhada =
                `<strong>${parcelas - 1}x de R$ ${valorParcelaInteiro.toFixed(2).replace('.', ',')}</strong> + <strong>1x de R$ ${valorUltimaParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;
        }
    }

    console.log('Descrição:', descricaoDetalhada);

    // Atualizar campo hidden
    $('#installments').val(parcelas);

    // Fechar o modal primeiro
    Swal.close();

    // Exibir informações do parcelamento
    console.log('Elemento #parcelamento-detalhes existe?', $('#parcelamento-detalhes').length);
    console.log('Elemento #parcelamento-info existe?', $('#parcelamento-info').length);

    $('#parcelamento-detalhes').html(descricaoDetalhada);
    $('#parcelamento-info').removeClass('d-none').slideDown();

    console.log('Parcelamento deve estar visível agora');

    // Toast de confirmação
    Swal.fire({
        icon: 'success',
        title: 'Prazo Selecionado!',
        text: `Pagamento em ${parcelas}x (${dias} dias)`,
        timer: 1500,
        showConfirmButton: false,
        toast: true,
        position: 'top-end'
    });
}

// ============================================
// GERENCIAMENTO DE DESPESAS
// ============================================

function adicionarDespesa() {
    const tipo = $('#despesa_tipo').val();
    const descricao = $('#despesa_descricao').val().trim();
    const valor = parseFloat($('#despesa_valor').val()) || 0;

    if (!tipo) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção',
            text: 'Selecione o tipo de despesa!'
        });
        $('#despesa_tipo').focus();
        return;
    }

    if (!descricao) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção',
            text: 'Informe a descrição da despesa!'
        });
        $('#despesa_descricao').focus();
        return;
    }

    if (valor <= 0) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção',
            text: 'Informe um valor válido para a despesa!'
        });
        $('#despesa_valor').focus();
        return;
    }

    const despesa = {
        index: despesaIndex,
        tipo: tipo,
        descricao: descricao,
        valor: valor
    };

    despesasTabela.push(despesa);

    const tipoTexto = $('#despesa_tipo option:selected').text();
    const valorFormatado = valor.toFixed(2).replace('.', ',');

    const $row = $(`
        <tr data-index="${despesaIndex}">
            <td>${tipoTexto}</td>
            <td>${descricao}</td>
            <td class="text-end"><strong>R$ ${valorFormatado}</strong></td>
            <td class="text-center">
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerDespesa(${despesaIndex})">
                    <i class="bi bi-trash"></i>
                </button>
            </td>
            <input type="hidden" name="despesas[${despesaIndex}][tipo]" value="${tipo}">
            <input type="hidden" name="despesas[${despesaIndex}][descricao]" value="${descricao}">
            <input type="hidden" name="despesas[${despesaIndex}][valor]" value="${valor}">
        </tr>
    `);

    $('#tbody-despesas').append($row);
    $('#alert-sem-despesas').hide();
    $('#tabela-despesas').show();

    despesaIndex++;
    limparCamposDespesa();
    atualizarTotalDespesas();
}

function removerDespesa(index) {
    despesasTabela = despesasTabela.filter(d => d.index !== index);
    $(`#tbody-despesas tr[data-index="${index}"]`).remove();
    atualizarTotalDespesas();

    if (despesasTabela.length === 0) {
        $('#alert-sem-despesas').show();
        $('#tabela-despesas').hide();
    }
}

function limparCamposDespesa() {
    $('#despesa_tipo').val('');
    $('#despesa_descricao').val('');
    $('#despesa_valor').val('');
}

function atualizarTotalDespesas() {
    const total = despesasTabela.reduce((sum, despesa) => sum + parseFloat(despesa.valor || 0), 0);
    $('#total-despesas').text('R$ ' + total.toFixed(2).replace('.', ','));

    // Recalcular total geral quando despesas mudarem
    calcularTotalGeral();
}
</script>