<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-pencil-square me-2"></i> Editar Ordem de Serviço</h2>
        <p class="text-muted">Ordem de Serviço #<?= htmlspecialchars($ordem['service_number'] ?? '') ?></p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/ordem-servico') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<form id="form-ordem-servico" method="POST" action="<?= url('/ordem-servico/editar') ?>">
    <?php
    $formPath = ROOT_PATH . '/views/ordem-servico/form.php';
    if (!file_exists($formPath)) {
        error_log("Arquivo form.php não encontrado: {$formPath}");
        echo "<div class='alert alert-danger'>Erro: Arquivo de formulário não encontrado.</div>";
    } else {
        include $formPath;
    }
    ?>

    <div class="row mt-4">
        <div class="col-12">
            <div class="d-grid gap-2 d-md-flex">
                <button type="submit" class="btn btn-success btn-lg">
                    <i class="bi bi-check-circle me-2"></i> Atualizar Ordem de Serviço
                </button>
                <a href="<?= url('/ordem-servico') ?>" class="btn btn-outline-secondary btn-lg">
                    <i class="bi bi-x-circle me-2"></i> Cancelar
                </a>
                <?php if (($ordem['status'] ?? '') !== 'cancelada'): ?>
                <button type="button" class="btn btn-outline-danger btn-lg ms-auto" onclick="cancelarOrdemServico()">
                    <i class="bi bi-x-octagon me-2"></i> Cancelar Ordem de Serviço
                </button>
                <?php endif; ?>
            </div>
        </div>
    </div>
</form>

<script>
$(document).ready(function() {
    $('#form-ordem-servico').on('submit', function(e) {
        e.preventDefault();

        // Validar se há itens
        if (itensTabela.length === 0) {
            Swal.fire({
                icon: 'warning',
                title: 'Atenção',
                text: 'Adicione pelo menos um item à ordem de serviço!'
            });
            $('#itens-tab').tab('show');
            return false;
        }

        // Não precisa validar cliente - pode ser Consumidor Final (vazio)

        // Serializar form normalmente
        let formData = $(this).serialize();

        // Adicionar campos readonly que não são incluídos no serialize()
        const readonlyFields = ['service_number'];
        readonlyFields.forEach(function(fieldName) {
            const $field = $(`#${fieldName}, [name="${fieldName}"]`);
            if ($field.length && $field.val()) {
                // Se o campo não foi incluído no serialize, adicionar manualmente
                if (formData.indexOf(fieldName + '=') === -1) {
                    formData += (formData ? '&' : '') + encodeURIComponent(fieldName) + '=' +
                        encodeURIComponent($field.val());
                }
            }
        });

        // Garantir que o ID está presente
        const $idField = $('input[name="id"]');
        if ($idField.length && $idField.val()) {
            if (formData.indexOf('id=') === -1) {
                formData += (formData ? '&' : '') + 'id=' + encodeURIComponent($idField.val());
            }
        }

        const $btn = $(this).find('button[type="submit"]');
        $btn.prop('disabled', true).html(
            '<span class="spinner-border spinner-border-sm me-2"></span>Atualizando...');

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message,
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        window.location.href = response.redirect || appUrl(
                            '/ordem-servico');
                    });
                } else {
                    $btn.prop('disabled', false).html(
                        '<i class="bi bi-check-circle me-2"></i> Atualizar Ordem de Serviço'
                    );
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message
                    });
                }
            },
            error: function(xhr) {
                $btn.prop('disabled', false).html(
                    '<i class="bi bi-check-circle me-2"></i> Atualizar Ordem de Serviço');
                const response = xhr.responseJSON || {};
                let errorMsg = response.message || 'Erro ao atualizar ordem de serviço';

                // Adicionar mais detalhes do erro se disponível
                if (xhr.status === 400) {
                    errorMsg +=
                        '\n\nErro 400 - Bad Request. Verifique os logs do servidor para mais detalhes.';
                    if (response.errors) {
                        errorMsg += '\n\nDetalhes:\n' + JSON.stringify(response.errors,
                            null, 2);
                    }
                }

                console.error('Erro ao atualizar ordem de serviço:', xhr);
                console.error('Dados enviados:', formData);
                console.error('Resposta do servidor:', response);

                Swal.fire({
                    icon: 'error',
                    title: 'Erro ' + (xhr.status || ''),
                    text: errorMsg,
                    width: '600px'
                });
            }
        });
    });
});

async function cancelarOrdemServico() {
    const result = await Swal.fire({
        title: 'Cancelar Ordem de Serviço?',
        text: 'Esta ação irá marcar a ordem de serviço como cancelada. Deseja continuar?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Sim, cancelar!',
        cancelButtonText: 'Não'
    });

    if (result.isConfirmed) {
        $('#status').val('cancelada');
        $('#form-ordem-servico').submit();
    }
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'ordem-servico';
include ROOT_PATH . '/views/layouts/app.php';
?>